//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#ifndef NO_FILE_SERIALIZE
#define USE_WSMFILE
#include <WSCconductor.h>
#include <WSCserializeData.h>
#include <x11/WSDfileSerialize.h>
#include <fcntl.h>

#define WS_SRL_TYPE "FILE"

WSMFclassInit(WSDfileSerialize,WSDserialize);

void WSGFinitFS(){
static int fl = False;
  if (fl == False){
    fl = True;
    WSGIconductor()->addSerialize(new WSDfileSerialize);
  }
}

#ifndef NO_GLOBAL_CONSTRUCTORS
class  _fserialize_init {
  public:
  _fserialize_init(){
    WSGFinitFS();
  };
};
static _fserialize_init _fserialize_init_execute;
#endif

WSDfileSerialize::WSDfileSerialize(){
  _fp = NULL;
#ifdef USE_WSMFILE
  _mfp = NULL;
#endif
}
WSDfileSerialize::~WSDfileSerialize(){
  _close();
}

long WSDfileSerialize::endTransaction(){
  _close();
  if (_need_save == False){
    return WS_NO_ERR;
  }
  long ret = _open(_field.getString(),WS_WRITE);
  if (ret != WS_NO_ERR){
//fprintf(stderr,"Error: WSDfileSerialize::endTransaction file open error.\n",_field.getString());
    return ret;
  }

  _need_save = False;
  _seek(0);
  long num = _data_list._num;
  char tmp[4];
  WSGIbinType()->memcpy4b(tmp,num);
  _write(tmp,sizeof(char)*4);
  setUnderTransaction(False);

  long i;
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    dt->write(this);
  }
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    delete dt;
  }
  _data_list.clear();
  _close();
  return WS_NO_ERR;
}
long WSDfileSerialize::_open(char* name,long mode){
  char* md = "r";
  if (mode == WS_WRITE){
    md = "w";
  }else if (mode == WS_RW){
//WSMFtrace("WSDfileSerialize::_open  here\n");
    md = "r+";
  }

  if (_fp  != NULL){
    fclose(_fp);
  }

  char buffer1[1024];
  if (!strcmp(_path.getString(),"")){
    sprintf(buffer1,"%s",name);
  }else{
    sprintf(buffer1,"%s/%s",_path.getString(),name);
  }

  _fp = fopen(buffer1,md);
  if (_fp == NULL && mode == WS_RW ){
//WSMFtrace("WSDfileSerialize::_open  here!\n");
    md = "a";
    _fp = fopen(buffer1,md);
  }

  if (_fp == NULL){
//fprintf(stderr,"Error: WSDfileSerialize::_open file open error.   file=%s mode=%s\n",buffer1,md);
    return WS_ERR_CNSRL;
  }else{
#ifdef USE_WSMFILE
    if (mode == WS_READ_ONLY){
      fseek(_fp,0,SEEK_END);
      long size = ftell(_fp);
      fseek(_fp,0,SEEK_SET);
      char* buf = new char[size];

      long ret = fread(buf,1,size,_fp);
      if (_mfp == NULL){
        _mfp = new WSCmfile();
      }
      _mfp->setBuf(buf,size);
    }else{
      if (_mfp != NULL){
        delete _mfp;
      }
      _mfp = NULL;
    }
#endif
    _seek(0);
    return WS_NO_ERR;
  }
}
long WSDfileSerialize::_close(){
  if (_fp  != NULL){
    fclose(_fp);
    _fp = NULL;
  }
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    delete _mfp;
    _mfp = NULL;
  }
#endif
  return WS_NO_ERR;
}
long WSDfileSerialize::_read(void* buf,long len){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    long ret = _mfp->read(buf,len);
    return ret;
  }
#endif
  if (_fp == NULL){
    return 0;
  }
//WSMFtrace("WSDfileSerialize::_read() len=%d\n",len);
  long ret = fread(buf,1,len,_fp);
  return ret;
}
long WSDfileSerialize::_write(void* buf,long len){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return 0;
  }
#endif
  if (_fp == NULL){
    return 0;
  }
  return fwrite(buf,1,len,_fp);
}
long WSDfileSerialize::_tell(){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return _mfp->tell();
  }
#endif
  if (_fp == NULL){
//fprintf(stderr,"WSDfileSerialize::_tell error file=NULL\n");
    return 0;
  }
  return ftell(_fp);
}
long WSDfileSerialize::_size(){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return _mfp->getSize();
  }
#endif
  if (_fp == NULL){
//fprintf(stderr,"WSDfileSerialize::_size error file=NULL\n");
    return 0;
  }
  long pos = ftell(_fp);
  fseek(_fp,0,SEEK_END);
  long ret = ftell(_fp);
  fseek(_fp,pos,SEEK_SET);
  return ret;
}
long WSDfileSerialize::_seek(long addr){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return _mfp->seek(addr);
  }
#endif
  if (_fp == NULL){
    return 0;
  }
  fseek(_fp,addr,SEEK_SET);
  return WS_NO_ERR;
}
long WSDfileSerialize::_seek_end(){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return _mfp->seekEnd();
  }
#endif
  if (_fp == NULL){
    return 0;
  }
  fseek(_fp,0,SEEK_END);
  return WS_NO_ERR;
}
long WSDfileSerialize::_seek_set(){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return _mfp->seekSet();
  }
#endif
  return _seek(0);
}
long WSDfileSerialize::_eof(){
#ifdef USE_WSMFILE
  if (_mfp != NULL){
    return _mfp->eof();
  }
#endif
  if (_fp == NULL){
    return 0;
  }
  return feof(_fp);
}
WSCbool WSDfileSerialize::type(char* tp){
  if ( !strcmp(tp,WS_SRL_TYPE) ){
    return True;
  }else{
    return False;
  }
}
WSDserialize* WSDfileSerialize::createSerialize(){
  return new WSDfileSerialize;
}
#endif //NO_FILE_SERIALIZE

