#!/usr/bin/env ruby

if (ARGV.length != 2)
   print("usage: #{__FILE__} input_ML_file output_ML_file\n")
   exit(1)
end

infile = ARGV[0]
outfile = ARGV[1]

header = <<SRC
open Swig
open Mwt

let mwt_inited = ref false
let mwt_app = ref C_void
let mwt_font_data = ref C_void
let init_application num fontdata=
   match !mwt_inited with
   | true -> ()
   | false ->
      ignore(Mwt._WSGFdeviceInitialize (C_list [C_void]));
      mwt_app := Mwt._WSGIappDev (C_list [C_void]);
      mwt_font_data := new_WSCstring (C_list [C_string fontdata]);
      ignore(Mwt._WSGFwsInitialize (C_list [C_void]));
      ignore(Mwt._WSGFsetFontData (C_list [!mwt_font_data]));
      ignore(Mwt._WSGFsetDefaultEncoding (C_list [C_int num]));
      mwt_inited := true;;

SRC

footer = <<SRC

let invoke obj =
   match !mwt_inited with
   | true -> Swig.invoke obj
   | false -> (fun mth arg -> C_void)

let get_int x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_int (o "getInt" C_void)
         with _ -> Swig.get_int x
      end
   | _ -> Swig.get_int x

let get_float x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_float (o "getDouble" C_void)
         with _ ->
         try
            Swig.get_float (o "getFloat" C_void)
         with _ -> Swig.get_float x
      end
   | _ -> Swig.get_float x

let get_char x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_char (o "getChar" C_void)
         with _ -> Swig.get_char x
      end
   | _ -> Swig.get_char x

let get_string x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_string (o "getCharPtr" C_void)
         with _ ->
         try
            Swig.get_string (o "getString" C_void)
         with _ -> Swig.get_string x
      end
   | _ -> Swig.get_string x

let get_bool x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_bool (o "getUnsignedChar" C_void)
         with _ -> Swig.get_bool x
      end
   | _ -> Swig.get_bool x
SRC

File.open(outfile, "w") { |io|
   io.write(header)
   File.foreach(infile) { |line|
      str = ""
      ary = line.split()
      dir = ary[0]
      val = ary[1]
      case dir
      when "type"
         str = "type #{val} = Mwt.#{val}\n"
      when "exception"
         str = line
      when "external"
         if (line.include?(": c_obj -> Swig.c_obj ="))
            str = "let #{val} = Mwt.#{val} C_void\n"
         else
            next
         end
      when "let"
         case val
         when /^new_/, /^_WSG/
            str = "\nlet "
            fun = val.clone()
         else
            next
         end
         ary[2..-1].each { |word|
            break if (word == "=")
            fun << " " << word
         }
         str << fun << " =\n" <<
<<SRC
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.#{fun}
SRC
      else
         next
      end
      io.write(str)
   }
   io.write(footer)
}
