//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCRbaseDialog.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCbaseDialog.h>

WSMFclassInit(WSCRbaseDialog,WSCRwindow);
WSMFremoteClassInit(WSCRbaseDialog,WSCbaseDialog);

WSCRbaseDialog::WSCRbaseDialog(){
}

WSCRbaseDialog::~WSCRbaseDialog(){
}

void WSCRbaseDialog::onActivate(){
  if (_local != NULL){
    WSCbaseDialog* item = (WSCbaseDialog*)_local->cast("WSCbaseDialog");
    if (item != NULL){
      item->onActivate();
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbaseDialog");
  rc.setOperationName("getStatus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  endRemoteCall();
}
long WSCRbaseDialog::getStatus(){
  if (_local != NULL){
    WSCbaseDialog* item = (WSCbaseDialog*)_local->cast("WSCbaseDialog");
    if (item != NULL){
      return item->getStatus();
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbaseDialog");
  rc.setOperationName("getStatus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  } 
  long ret = 0;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRbaseDialog::popup(){
  if (_local != NULL){
    WSCbaseDialog* item = (WSCbaseDialog*)_local->cast("WSCbaseDialog");
    if (item != NULL){
      return item->popup();
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbaseDialog");
  rc.setOperationName("popup");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return WS_ERR;
  } 
  long ret = 0;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

void _WSCbaseDialog_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getStatus")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL){
        WSCbaseDialog* item = (WSCbaseDialog*)inst->cast("WSCbaseDialog");
        if (item != NULL){
          ret = item->getStatus();
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }
  }else
  if ( rc->_op[0] == 'p'){
    if (!strcmp(rc->_op,"popup")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL){
        WSCbaseDialog* item = (WSCbaseDialog*)inst->cast("WSCbaseDialog");
        if (item != NULL){
          ret = item->popup();
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }
  }else
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onAcivate")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCbaseDialog* item = (WSCbaseDialog*)inst->cast("WSCbaseDialog");
        if (item != NULL){
          item->onActivate();
        }
      }
      return;
    }
  }

extern void _WSCwindow_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCwindow_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCbaseDialog,_WSCbaseDialog_remote_call);

