//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <nx/WSDnxMouse.h>
#include <nx/WSDnxAppDev.h>
#include <nx/WSDnxFormDev.h>
#include <nx/WSDnxColor.h>
#include <WSCbase.h>
#include <WSCcolorSet.h>
#include <WSDfileSystem.h>

WSMFclassInit(WSDnxMouse,WSDmouse);

WSDmouse* _nxMouse_create_handler(){
dbprintf("_nxMouse_create_handler() %s:%d started..\n",__FILE__,__LINE__);
  return new WSDnxMouse();
}

#ifndef NO_GLOBAL_CONSTRUCTORS
class _nxMouse_init{
  public: _nxMouse_init(){
dbprintf("_nxMouse_init() %s:%d started..\n",__FILE__,__LINE__);
    WSDmouse::setCreateInstanceHandler(_nxMouse_create_handler);
  };
};

_nxMouse_init _nxMouse_init_run_constructor;
#endif

WSDnxMouse* WSGInxAppMouse(){
  WSDmouse* mouse = WSGIappMouse();
  if (mouse == NULL){
    return NULL;
  }
  WSDnxMouse* nxMouse =(WSDnxMouse*)mouse->cast("WSDnxMouse");
  return nxMouse;

}
char* dmnames[]={
"0   PS_SELECT black white",
NULL
};

WSDnxMouse::WSDnxMouse(){}
WSDnxMouse::~WSDnxMouse(){}

void WSDnxMouse::resetMouseCursors(){
  long cnt = 0;
  while(1){
    long id = getMouseCursorId(cnt);
    if (id == 0){
      cnt++;
    }else if (id > -1){
      delMouseCursor(cnt);
    }else{
      break;
    }
  }
}

void WSDnxMouse::setMouseCursor(long mno){}
void WSDnxMouse::initialize(){
  long num = 0;
  while(dmnames[num] != NULL){
    WSGInxAppMouse()->setupMouseCursor(dmnames[num]);
    num++;
  };
}


void WSDnxMouse::setupMouseCursor(char* data){
  // TODO parse data and create mouse resource.

}

long WSDnxMouse::getDefaultMouseCursor(){
static _nx_mouse_value* _default_mouse = NULL;
  if (_default_mouse == NULL){
    WSDcolor* fg = WSGIappColorSet()->getColor("black");
    WSDcolor* bg = WSGIappColorSet()->getColor("white");
    _nx_mouse_value* val = new _nx_mouse_value;
    val->_style = 0; // TODO mouse resource
    val->_fg = fg->getValue1();
    val->_bg = bg->getValue1();
    _default_mouse = val;
  }
  return (long)_default_mouse;
}


void* WSDnxMouse::getCurrentMouseWindow(){
  // TODO get current window of the mouse
  return NULL;
}

WSCbool WSDnxMouse::getMousePosition(short* ox,short* oy){
  long posx = 0;
  long posy = 0;
  // TODO get mouse position.
  *ox = posx;
  *oy = posy;
  return True;
}


WSCbool WSDnxMouse::getMousePosition(short* ox,short* oy,WSCbase* client){
  long posx = 0;
  long posy = 0;
  // TODO get mouse position.
  *ox = posx;
  *oy = posy;
  return True;
}

long WSDnxMouse::getMouseStatus(){
   return getStatus();
}

void WSDnxMouse::setMousePosition(short x,short y){
  // TODO set mouse position.
}


