//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WStcpcom.h>
#include <nx/WSDunixThread.h>
#include <stdio.h>
#include <fcntl.h>
#include <WSClocaleSet.h>
#include <pthread.h>
#include <nx/WSnxcom.h>

WSMFclassInit(WSDunixThread,WSDthread);

WSDthread* _unix_th_chandler(){
  return new WSDunixThread;
}

void WSGFinitializeUnixThread(){
    WSDthread::setCreateInstanceHandler((void*)_unix_th_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _unix_th_init {
  public: _unix_th_init(){
    WSGFinitializeUnixThread();
  };
};
_unix_th_init  _unix_th_init_execute;
#endif

WSDunixThread::WSDunixThread(){
  pthread_mutex_init(&_mutex,NULL);
  _id = 0;
}

WSDunixThread::~WSDunixThread(){
  if (_id != 0){
    terminateThread();
  }
}

long WSDunixThread::createThread(void* data){
  pthread_mutex_lock(&_mutex);
  if (_proc == 0){
    pthread_mutex_unlock(&_mutex);
    return WS_ERR;
  }
  if (_id != 0){
    pthread_mutex_unlock(&_mutex);
    return WS_ERR;
  }
  _ptr = data;
  int ret = pthread_create(&_id,NULL,_thread_start_handler,this);
  if (ret != 0){
    _id = 0;
  }
  pthread_mutex_unlock(&_mutex);
  return WS_NO_ERR;
}

void* WSDunixThread::_thread_start_handler(void* ptr){
  WSDunixThread* _this = (WSDunixThread*)ptr;
  void* ret = NULL;
  if (_this->_proc != NULL){
    ret = _this->_proc(_this,_this->_ptr);
  }
  pthread_mutex_lock(&_this->_mutex);
  _this->_id = 0;
  pthread_mutex_unlock(&_this->_mutex);
  pthread_exit(ret);
  return NULL;
}

long WSDunixThread::detachThread(){
  if (_id != 0){
    int ret = pthread_detach(_id);
    if (ret == 0){
      return WS_NO_ERR;
    }
  }
  return WS_ERR;
}
long WSDunixThread::terminateThread(){
  if (_id == 0){
    return WS_ERR;  
  }
  pthread_mutex_lock(&_mutex);
  pthread_cancel(_id);
  pthread_mutex_unlock(&_mutex);
  return WS_ERR;  
}
long WSDunixThread::joinThread(void** retval){
  if (_id != 0){
    int ret = pthread_join(_id,retval);
    if (ret == 0){
      return WS_NO_ERR;
    }
    return WS_ERR;
  }
  return WS_ERR;
}
long WSDunixThread::getStatus(){
  if (_id == 0){
    return WS_THREAD_STOPPED;
  }
  return WS_THREAD_RUNNING;
}
long WSDunixThread::execCallback(void* data){
//  _callback_data = data;

  // TODO send message to the event loop.
#ifdef WS_OWN_EVENT_LOOP
      WSDnxEvent ev;
      ev.type = WSEV_NX_THREAD_MESSAGE;
      _internal_thr_data_* ptr = new _internal_thr_data_;
      ptr->thr = this;
      ptr->data = data;
      ev.data = (void*)ptr;
      WSGFnxSendEvent(&ev);
#endif //WS_OWN_EVENT_LOOP

  return WS_NO_ERR;
}

