//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <stdio.h>
#include <WScom.h>
#include <WSCbase.h>
#include <WSCprocedure.h>

/*
#ifdef MSW
#ifndef CAML_DLL
#define CAML_DLL 1
#endif
#ifndef IN_OCAMLRUN
#define IN_OCAMLRUN 1
#endif
#endif
*/

#ifdef __cplusplus
extern "C" {
#endif
#include <caml/misc.h>
#include <caml/memory.h>
#include <caml/mlvalues.h>
#include <caml/callback.h>

void _procedure_handler(char *fname, WSCbase *ptr)
{
  CAMLparam0();
  value *closure = caml_named_value(fname);
  value *obj = caml_named_value((char*)ptr->getProperty(WSNname));

  if (closure == NULL) {
    fprintf(stderr, "ERROR: procedure:\"%s\" is not found.\n", fname);
    CAMLreturn0;
  }else if (obj == NULL) {
    fprintf(stderr, "ERROR: required object:\"%s\" is not found.\n",(char*)ptr->getProperty(WSNname));
    CAMLreturn0;
  }
//  fprintf(stderr, "callback()\n");
  callback(*closure, *obj);
  CAMLreturn0;
}

#ifdef __cplusplus
};
#endif

class _ocaml_proc_init {
  public:
    _ocaml_proc_init() {
      WSGFsetProcedureHandler((void *)_procedure_handler);
    }
};
_ocaml_proc_init _exec_ocaml_init;
