open Swig
open Mpfc

let mpfc_inited = ref false
let mpfc_app = ref C_void
let mpfc_font_data = ref C_void
let init_application num fontdata=
   match !mpfc_inited with
   | true -> ()
   | false ->
      ignore(Mpfc._WSGFdeviceInitialize (C_list [C_void]));
      mpfc_app := Mpfc._WSGIappDev (C_list [C_void]);
      mpfc_font_data := new_WSCstring (C_list [C_string fontdata]);
      ignore(Mpfc._WSGFwsInitialize (C_list [C_void]));
      ignore(Mpfc._WSGFsetFontData (C_list [!mpfc_font_data]));
      ignore(Mpfc._WSGFsetDefaultEncoding (C_list [C_int num]));
      mpfc_inited := true;;

type c_enum_type = Mpfc.c_enum_type
type c_enum_value = Mpfc.c_enum_value
type c_obj = Mpfc.c_obj
exception BadArgs of string
exception BadMethodName of c_obj * string * string
exception NotObject of c_obj
exception NotEnumType of c_obj
exception LabelNotFromThisEnum of c_obj
exception InvalidDirectorCall of c_obj
let _WS_DATA_SOURCE_NONE = Mpfc._WS_DATA_SOURCE_NONE C_void
let _WS_DATA_SOURCE_INSTANCE = Mpfc._WS_DATA_SOURCE_INSTANCE C_void
let _WS_DATA_SOURCE_FILE = Mpfc._WS_DATA_SOURCE_FILE C_void
let _WS_TEXT = Mpfc._WS_TEXT C_void
let _WS_BINARY = Mpfc._WS_BINARY C_void
let _WS_NORMAL = Mpfc._WS_NORMAL C_void
let _WS_TREE = Mpfc._WS_TREE C_void
let _WS_VERBOSE = Mpfc._WS_VERBOSE C_void
let _WS_HAVE_CHILD = Mpfc._WS_HAVE_CHILD C_void
let _WS_HAVE_BROS = Mpfc._WS_HAVE_BROS C_void
let _WS_OPEN = Mpfc._WS_OPEN C_void
let _WS_INDENT_LEVEL = Mpfc._WS_INDENT_LEVEL C_void
let _WS_ABSOLUTE_OPEN = Mpfc._WS_ABSOLUTE_OPEN C_void
let _WS_ICON = Mpfc._WS_ICON C_void
let _WS_SFORM_FIXED = Mpfc._WS_SFORM_FIXED C_void
let _WS_SFORM_UNDER_RESIZING = Mpfc._WS_SFORM_UNDER_RESIZING C_void
let _WS_EXEC_NONE = Mpfc._WS_EXEC_NONE C_void
let _WS_EXEC_RD = Mpfc._WS_EXEC_RD C_void
let _WS_EXEC_RDWR = Mpfc._WS_EXEC_RDWR C_void
let _WS_EXEC_WR = Mpfc._WS_EXEC_WR C_void
let _WS_DOUBLE_CLICK_TIME = Mpfc._WS_DOUBLE_CLICK_TIME C_void
let _WS_POLICY_ORIGINAL = Mpfc._WS_POLICY_ORIGINAL C_void
let _WS_POLICY_WINDOWS = Mpfc._WS_POLICY_WINDOWS C_void
let _WS_POLICY_GRADATION = Mpfc._WS_POLICY_GRADATION C_void
let _WS_POLICY_AQUA = Mpfc._WS_POLICY_AQUA C_void
let _WS_TYPE_WINDOW = Mpfc._WS_TYPE_WINDOW C_void
let _WS_TYPE_MANAGER = Mpfc._WS_TYPE_MANAGER C_void
let _WS_TYPE_FORM = Mpfc._WS_TYPE_FORM C_void
let _WS_TYPE_SCR_FORM = Mpfc._WS_TYPE_SCR_FORM C_void
let _WS_TYPE_MENU_WINDOW = Mpfc._WS_TYPE_MENU_WINDOW C_void
let _WS_EN_DEFAULT = Mpfc._WS_EN_DEFAULT C_void
let _WS_EN_LOCALE = Mpfc._WS_EN_LOCALE C_void
let _WS_EN_NONE = Mpfc._WS_EN_NONE C_void
let _WS_EN_ISO8859_1 = Mpfc._WS_EN_ISO8859_1 C_void
let _WS_EN_ISO8859_2 = Mpfc._WS_EN_ISO8859_2 C_void
let _WS_EN_ISO8859_3 = Mpfc._WS_EN_ISO8859_3 C_void
let _WS_EN_ISO8859_4 = Mpfc._WS_EN_ISO8859_4 C_void
let _WS_EN_ISO8859_5 = Mpfc._WS_EN_ISO8859_5 C_void
let _WS_EN_ISO8859_6 = Mpfc._WS_EN_ISO8859_6 C_void
let _WS_EN_ISO8859_7 = Mpfc._WS_EN_ISO8859_7 C_void
let _WS_EN_ISO8859_8 = Mpfc._WS_EN_ISO8859_8 C_void
let _WS_EN_ISO8859_9 = Mpfc._WS_EN_ISO8859_9 C_void
let _WS_EN_ISO8859_10 = Mpfc._WS_EN_ISO8859_10 C_void
let _WS_EN_ISO8859_11 = Mpfc._WS_EN_ISO8859_11 C_void
let _WS_EN_ISO8859_12 = Mpfc._WS_EN_ISO8859_12 C_void
let _WS_EN_ISO8859_13 = Mpfc._WS_EN_ISO8859_13 C_void
let _WS_EN_ISO8859_14 = Mpfc._WS_EN_ISO8859_14 C_void
let _WS_EN_ISO8859_15 = Mpfc._WS_EN_ISO8859_15 C_void
let _WS_EN_UTF8 = Mpfc._WS_EN_UTF8 C_void
let _WS_EN_KOI8R = Mpfc._WS_EN_KOI8R C_void
let _WS_EN_EUCJP = Mpfc._WS_EN_EUCJP C_void
let _WS_EN_SJIS = Mpfc._WS_EN_SJIS C_void
let _WS_EN_EUCKR = Mpfc._WS_EN_EUCKR C_void
let _WS_EN_EUCCN = Mpfc._WS_EN_EUCCN C_void
let _WS_EN_BIG5 = Mpfc._WS_EN_BIG5 C_void
let _WS_DIALOG_CANCEL = Mpfc._WS_DIALOG_CANCEL C_void
let _WS_DIALOG_OK = Mpfc._WS_DIALOG_OK C_void
let _WS_DIALOG_NO = Mpfc._WS_DIALOG_NO C_void
let _WS_DIALOG_DONE = Mpfc._WS_DIALOG_DONE C_void

let _WSGIappDev arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappDev arg

let _WSGFwsInitialize arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFwsInitialize arg

let _WSGFwsInitialize2 arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFwsInitialize2 arg

let _WSGFdestroyWindow arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFdestroyWindow arg

let _WSGFdeviceInitialize arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFdeviceInitialize arg

let _WSGIappMouse arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappMouse arg

let _WSGIappKeyboard arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappKeyboard arg
let _WSCDB_SQL_CONCUR_READ_ONLY = Mpfc._WSCDB_SQL_CONCUR_READ_ONLY C_void
let _WSCDB_SQL_CONCUR_LOCK = Mpfc._WSCDB_SQL_CONCUR_LOCK C_void
let _WSCDB_SQL_CONCUR_ROWVER = Mpfc._WSCDB_SQL_CONCUR_ROWVER C_void
let _WSCDB_SQL_CONCUR_VALUES = Mpfc._WSCDB_SQL_CONCUR_VALUES C_void
let _WSCDB_SQL_CONCUR_DEFAULT = Mpfc._WSCDB_SQL_CONCUR_DEFAULT C_void
let _WSCDB_SQL_CURSOR_FORWARD_ONLY = Mpfc._WSCDB_SQL_CURSOR_FORWARD_ONLY C_void
let _WSCDB_SQL_CURSOR_KEYSET_DRIVEN = Mpfc._WSCDB_SQL_CURSOR_KEYSET_DRIVEN C_void
let _WSCDB_SQL_CURSOR_DYNAMIC = Mpfc._WSCDB_SQL_CURSOR_DYNAMIC C_void
let _WSCDB_SQL_CURSOR_STATIC = Mpfc._WSCDB_SQL_CURSOR_STATIC C_void
let _WSCDB_SQL_CURSOR_TYPE_DEFAULT = Mpfc._WSCDB_SQL_CURSOR_TYPE_DEFAULT C_void
let _WSCDB_FIELD_TYPE_CHAR = Mpfc._WSCDB_FIELD_TYPE_CHAR C_void
let _WSCDB_FIELD_TYPE_NUMERIC = Mpfc._WSCDB_FIELD_TYPE_NUMERIC C_void
let _WSCDB_FIELD_TYPE_DECIMAL = Mpfc._WSCDB_FIELD_TYPE_DECIMAL C_void
let _WSCDB_FIELD_TYPE_INTEGER = Mpfc._WSCDB_FIELD_TYPE_INTEGER C_void
let _WSCDB_FIELD_TYPE_SMALLINT = Mpfc._WSCDB_FIELD_TYPE_SMALLINT C_void
let _WSCDB_FIELD_TYPE_FLOAT = Mpfc._WSCDB_FIELD_TYPE_FLOAT C_void
let _WSCDB_FIELD_TYPE_REAL = Mpfc._WSCDB_FIELD_TYPE_REAL C_void
let _WSCDB_FIELD_TYPE_DOUBLE = Mpfc._WSCDB_FIELD_TYPE_DOUBLE C_void
let _WSCDB_FIELD_TYPE_DATE = Mpfc._WSCDB_FIELD_TYPE_DATE C_void
let _WSCDB_FIELD_TYPE_TIME = Mpfc._WSCDB_FIELD_TYPE_TIME C_void
let _WSCDB_FIELD_TYPE_TIMESTAMP = Mpfc._WSCDB_FIELD_TYPE_TIMESTAMP C_void
let _WSCDB_FIELD_TYPE_NONE = Mpfc._WSCDB_FIELD_TYPE_NONE C_void

let _WSGIappFileSelect arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappFileSelect arg

let _WSGFsetDefaultEncoding arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetDefaultEncoding arg

let _WSGFgettext arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgettext arg

let _WSGFimage arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFimage arg

let _WSGIappColorSet arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappColorSet arg

let _WSGFindexColor arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFindexColor arg

let _WSGFcolorName arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcolorName arg

let _WSGFcolor arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcolor arg

let _WSGIappImageSet arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappImageSet arg

let _WSGFimageName arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFimageName arg

let _WSGIappFontSet arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappFontSet arg

let _WSGFdestroyPixmap arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFdestroyPixmap arg

let _WSGFdestroyPixmap arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFdestroyPixmap arg

let _WSGIappMessageDialog arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappMessageDialog arg

let _WSGIappObjectList arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGIappObjectList arg

let _WSGFreadWinFile arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFreadWinFile arg
let _WSCSHEET_DEFAULT = Mpfc._WSCSHEET_DEFAULT C_void
let _WSCSHEET_NONE = Mpfc._WSCSHEET_NONE C_void
let _WSCSHEET_HORZ = Mpfc._WSCSHEET_HORZ C_void
let _WSCSHEET_VERT = Mpfc._WSCSHEET_VERT C_void
let _WSCSHEET_BOTH = Mpfc._WSCSHEET_BOTH C_void
let _WSCSHEET_DEF_ROW_HEIGHT = Mpfc._WSCSHEET_DEF_ROW_HEIGHT C_void
let _WSCSHEET_DEF_COL_WIDTH = Mpfc._WSCSHEET_DEF_COL_WIDTH C_void
let _WSCSHEET_DEFCOLOR = Mpfc._WSCSHEET_DEFCOLOR C_void
let _WSCSHEET_DEFFONT = Mpfc._WSCSHEET_DEFFONT C_void
let _WSCSHEET_DEF_ROWS = Mpfc._WSCSHEET_DEF_ROWS C_void
let _WSCSHEET_DEF_COLS = Mpfc._WSCSHEET_DEF_COLS C_void
let _WSCSHEET_DEF_FIXEDROWS = Mpfc._WSCSHEET_DEF_FIXEDROWS C_void
let _WSCSHEET_DEF_FIXEDCOLS = Mpfc._WSCSHEET_DEF_FIXEDCOLS C_void
let _WSCSHEET_DB_SORT_ASC = Mpfc._WSCSHEET_DB_SORT_ASC C_void
let _WSCSHEET_DB_SORT_DESC = Mpfc._WSCSHEET_DB_SORT_DESC C_void
let _WS_MOUSE_SHIFT = Mpfc._WS_MOUSE_SHIFT C_void
let _WS_MOUSE_LOCK = Mpfc._WS_MOUSE_LOCK C_void
let _WS_MOUSE_CONTROL = Mpfc._WS_MOUSE_CONTROL C_void
let _WS_MOUSE_MOD = Mpfc._WS_MOUSE_MOD C_void
let _WS_MOUSE_BTN1 = Mpfc._WS_MOUSE_BTN1 C_void
let _WS_MOUSE_BTN2 = Mpfc._WS_MOUSE_BTN2 C_void
let _WS_MOUSE_BTN3 = Mpfc._WS_MOUSE_BTN3 C_void
let _WS_MOUSE_BTN4 = Mpfc._WS_MOUSE_BTN4 C_void
let _WS_MOUSE_BTN5 = Mpfc._WS_MOUSE_BTN5 C_void
let _WS_READ = Mpfc._WS_READ C_void
let _WS_WRITE = Mpfc._WS_WRITE C_void
let _WS_RW = Mpfc._WS_RW C_void
let _WS_IN_OUT = Mpfc._WS_IN_OUT C_void
let _WS_OUT = Mpfc._WS_OUT C_void
let _WS_IN = Mpfc._WS_IN C_void
let _WS_NONE = Mpfc._WS_NONE C_void
let _WS_VERTICAL = Mpfc._WS_VERTICAL C_void
let _WS_HORIZONTAL = Mpfc._WS_HORIZONTAL C_void
let _WS_DIRECT_WINDOW = Mpfc._WS_DIRECT_WINDOW C_void
let _WS_DYNAMIC_PIXMAP = Mpfc._WS_DYNAMIC_PIXMAP C_void
let _WS_SHADOW_NONE = Mpfc._WS_SHADOW_NONE C_void
let _WS_SHADOW_TRANS = Mpfc._WS_SHADOW_TRANS C_void
let _WS_SHADOW_OUT = Mpfc._WS_SHADOW_OUT C_void
let _WS_SHADOW_IN = Mpfc._WS_SHADOW_IN C_void
let _WS_SHADOW_EOUT = Mpfc._WS_SHADOW_EOUT C_void
let _WS_SHADOW_EIN = Mpfc._WS_SHADOW_EIN C_void
let _WS_SHADOW_BORDER = Mpfc._WS_SHADOW_BORDER C_void
let _WS_NO_TITLE = Mpfc._WS_NO_TITLE C_void
let _WS_FULL_TITLE = Mpfc._WS_FULL_TITLE C_void
let _WS_ONLY_TITLE = Mpfc._WS_ONLY_TITLE C_void
let _WS_MINI_BTN = Mpfc._WS_MINI_BTN C_void
let _WS_MAX_BTN = Mpfc._WS_MAX_BTN C_void
let _WS_FRAME = Mpfc._WS_FRAME C_void
let _WS_NO_MANAGE = Mpfc._WS_NO_MANAGE C_void
let _WS_LEFT = Mpfc._WS_LEFT C_void
let _WS_RIGHT = Mpfc._WS_RIGHT C_void
let _WS_CENTER = Mpfc._WS_CENTER C_void
let _WS_UP = Mpfc._WS_UP C_void
let _WS_TOP = Mpfc._WS_TOP C_void
let _WS_DOWN = Mpfc._WS_DOWN C_void
let _WS_BOTTOM = Mpfc._WS_BOTTOM C_void
let _WS_LEFT_TOP = Mpfc._WS_LEFT_TOP C_void
let _WS_LEFT_BOTTOM = Mpfc._WS_LEFT_BOTTOM C_void
let _WS_RIGHT_TOP = Mpfc._WS_RIGHT_TOP C_void
let _WS_RIGHT_BOTTOM = Mpfc._WS_RIGHT_BOTTOM C_void
let _WS_RET = Mpfc._WS_RET C_void
let _WS_TAB = Mpfc._WS_TAB C_void
let _WS_STAB = Mpfc._WS_STAB C_void
let _WS_NO_ERR = Mpfc._WS_NO_ERR C_void
let _WS_OK = Mpfc._WS_OK C_void
let _WS_ERR = Mpfc._WS_ERR C_void
let _WS_REMOTE_CALL_FAILED = Mpfc._WS_REMOTE_CALL_FAILED C_void
let _False = Mpfc._False C_void
let _True = Mpfc._True C_void
let _WSTlong = Mpfc._WSTlong C_void
let _WSTulong = Mpfc._WSTulong C_void
let _WSTshort = Mpfc._WSTshort C_void
let _WSTushort = Mpfc._WSTushort C_void
let _WSTchar = Mpfc._WSTchar C_void
let _WSTuchar = Mpfc._WSTuchar C_void
let _WSTfloat = Mpfc._WSTfloat C_void
let _WSTdouble = Mpfc._WSTdouble C_void
let _WSTvoidptr = Mpfc._WSTvoidptr C_void
let _WSTcharptr = Mpfc._WSTcharptr C_void
let _WSTvoid = Mpfc._WSTvoid C_void
let _WSTbool = Mpfc._WSTbool C_void
let _WSTint = Mpfc._WSTint C_void
let _WSTuint = Mpfc._WSTuint C_void
let _WSEV_HASH_MAX_NUM = Mpfc._WSEV_HASH_MAX_NUM C_void
let _WSEV_NONE = Mpfc._WSEV_NONE C_void
let _WSEV_INITIALIZE = Mpfc._WSEV_INITIALIZE C_void
let _WSEV_DELETE = Mpfc._WSEV_DELETE C_void
let _WSEV_ACTIVATE = Mpfc._WSEV_ACTIVATE C_void
let _WSEV_VALUE_CH = Mpfc._WSEV_VALUE_CH C_void
let _WSEV_FOCUS_CH = Mpfc._WSEV_FOCUS_CH C_void
let _WSEV_VISIBLE_CH = Mpfc._WSEV_VISIBLE_CH C_void
let _WSEV_SENSITIVE_CH = Mpfc._WSEV_SENSITIVE_CH C_void
let _WSEV_PARENT_VISIBLE_CH = Mpfc._WSEV_PARENT_VISIBLE_CH C_void
let _WSEV_PARENT_SENSITIVE_CH = Mpfc._WSEV_PARENT_SENSITIVE_CH C_void
let _WSEV_EXPOSE = Mpfc._WSEV_EXPOSE C_void
let _WSEV_RESIZE = Mpfc._WSEV_RESIZE C_void
let _WSEV_MOUSE_IN = Mpfc._WSEV_MOUSE_IN C_void
let _WSEV_MOUSE_OUT = Mpfc._WSEV_MOUSE_OUT C_void
let _WSEV_MOUSE_PRESS = Mpfc._WSEV_MOUSE_PRESS C_void
let _WSEV_MOUSE_RELEASE = Mpfc._WSEV_MOUSE_RELEASE C_void
let _WSEV_MOUSE_MOVE = Mpfc._WSEV_MOUSE_MOVE C_void
let _WSEV_KEY_PRESS = Mpfc._WSEV_KEY_PRESS C_void
let _WSEV_KEY_RELEASE = Mpfc._WSEV_KEY_RELEASE C_void
let _WSEV_KEY_HOOK = Mpfc._WSEV_KEY_HOOK C_void
let _WSEV_MOUSE_DOUBLE_CLICK = Mpfc._WSEV_MOUSE_DOUBLE_CLICK C_void
let _WSEV_SORT = Mpfc._WSEV_SORT C_void
let _WSEV_GUI_POLICY_CH = Mpfc._WSEV_GUI_POLICY_CH C_void
let _WSEV_ITEM_SELECTED = Mpfc._WSEV_ITEM_SELECTED C_void
let _WSEV_STATUS_CH = Mpfc._WSEV_STATUS_CH C_void
let _WSEV_INPUT_FIXED = Mpfc._WSEV_INPUT_FIXED C_void
let _WSEV_BEGIN = Mpfc._WSEV_BEGIN C_void
let _WSEV_END = Mpfc._WSEV_END C_void
let _WSEV_INCREMENT = Mpfc._WSEV_INCREMENT C_void
let _WSEV_DECREMENT = Mpfc._WSEV_DECREMENT C_void
let _WSEV_PAGE_INCREMENT = Mpfc._WSEV_PAGE_INCREMENT C_void
let _WSEV_PAGE_DECREMENT = Mpfc._WSEV_PAGE_DECREMENT C_void
let _WSEV_SCR_MOUSE_PRESS = Mpfc._WSEV_SCR_MOUSE_PRESS C_void
let _WSEV_SCR_MOUSE_RELEASE = Mpfc._WSEV_SCR_MOUSE_RELEASE C_void
let _WSEV_SCR_MOUSE_MOVE = Mpfc._WSEV_SCR_MOUSE_MOVE C_void
let _WSEV_EDIT_MODE_CH = Mpfc._WSEV_EDIT_MODE_CH C_void
let _WSEV_SPECIAL_FOCUS_CH = Mpfc._WSEV_SPECIAL_FOCUS_CH C_void
let _WSEV_CHILD_ADDED = Mpfc._WSEV_CHILD_ADDED C_void
let _WSEV_SELECTION_CH = Mpfc._WSEV_SELECTION_CH C_void
let _WS_IMAGE_DEFAULT = Mpfc._WS_IMAGE_DEFAULT C_void
let _WS_IMAGE_XPM = Mpfc._WS_IMAGE_XPM C_void
let _WS_IMAGE_BMP = Mpfc._WS_IMAGE_BMP C_void
let _WS_IMAGE_PNG = Mpfc._WS_IMAGE_PNG C_void
let _WS_IMAGE_JPG = Mpfc._WS_IMAGE_JPG C_void
let _WSK_BackSpace = Mpfc._WSK_BackSpace C_void
let _WSK_Tab = Mpfc._WSK_Tab C_void
let _WSK_Linefeed = Mpfc._WSK_Linefeed C_void
let _WSK_Clear = Mpfc._WSK_Clear C_void
let _WSK_Return = Mpfc._WSK_Return C_void
let _WSK_Pause = Mpfc._WSK_Pause C_void
let _WSK_Scroll_Lock = Mpfc._WSK_Scroll_Lock C_void
let _WSK_Sys_Req = Mpfc._WSK_Sys_Req C_void
let _WSK_Escape = Mpfc._WSK_Escape C_void
let _WSK_Delete = Mpfc._WSK_Delete C_void
let _WSK_Kanji = Mpfc._WSK_Kanji C_void
let _WSK_Muhenkan = Mpfc._WSK_Muhenkan C_void
let _WSK_Henkan_Mode = Mpfc._WSK_Henkan_Mode C_void
let _WSK_Henkan = Mpfc._WSK_Henkan C_void
let _WSK_Romaji = Mpfc._WSK_Romaji C_void
let _WSK_Hiragana = Mpfc._WSK_Hiragana C_void
let _WSK_Katakana = Mpfc._WSK_Katakana C_void
let _WSK_Hiragana_Katakana = Mpfc._WSK_Hiragana_Katakana C_void
let _WSK_Zenkaku = Mpfc._WSK_Zenkaku C_void
let _WSK_Hankaku = Mpfc._WSK_Hankaku C_void
let _WSK_Zenkaku_Hankaku = Mpfc._WSK_Zenkaku_Hankaku C_void
let _WSK_Touroku = Mpfc._WSK_Touroku C_void
let _WSK_Massyo = Mpfc._WSK_Massyo C_void
let _WSK_Kana_Lock = Mpfc._WSK_Kana_Lock C_void
let _WSK_Kana_Shift = Mpfc._WSK_Kana_Shift C_void
let _WSK_Eisu_Shift = Mpfc._WSK_Eisu_Shift C_void
let _WSK_Eisu_toggle = Mpfc._WSK_Eisu_toggle C_void
let _WSK_Home = Mpfc._WSK_Home C_void
let _WSK_Left = Mpfc._WSK_Left C_void
let _WSK_Up = Mpfc._WSK_Up C_void
let _WSK_Right = Mpfc._WSK_Right C_void
let _WSK_Down = Mpfc._WSK_Down C_void
let _WSK_Prior = Mpfc._WSK_Prior C_void
let _WSK_Page_Up = Mpfc._WSK_Page_Up C_void
let _WSK_Page_Down = Mpfc._WSK_Page_Down C_void
let _WSK_End = Mpfc._WSK_End C_void
let _WSK_Begin = Mpfc._WSK_Begin C_void
let _WSK_Select = Mpfc._WSK_Select C_void
let _WSK_Print = Mpfc._WSK_Print C_void
let _WSK_Execute = Mpfc._WSK_Execute C_void
let _WSK_Insert = Mpfc._WSK_Insert C_void
let _WSK_Undo = Mpfc._WSK_Undo C_void
let _WSK_Redo = Mpfc._WSK_Redo C_void
let _WSK_Menu = Mpfc._WSK_Menu C_void
let _WSK_Find = Mpfc._WSK_Find C_void
let _WSK_Cancel = Mpfc._WSK_Cancel C_void
let _WSK_Help = Mpfc._WSK_Help C_void
let _WSK_Break = Mpfc._WSK_Break C_void
let _WSK_Mode_switch = Mpfc._WSK_Mode_switch C_void
let _WSK_script_switch = Mpfc._WSK_script_switch C_void
let _WSK_Num_Lock = Mpfc._WSK_Num_Lock C_void
let _WSK_KP_Space = Mpfc._WSK_KP_Space C_void
let _WSK_KP_Tab = Mpfc._WSK_KP_Tab C_void
let _WSK_KP_Enter = Mpfc._WSK_KP_Enter C_void
let _WSK_KP_F1 = Mpfc._WSK_KP_F1 C_void
let _WSK_KP_F2 = Mpfc._WSK_KP_F2 C_void
let _WSK_KP_F3 = Mpfc._WSK_KP_F3 C_void
let _WSK_KP_F4 = Mpfc._WSK_KP_F4 C_void
let _WSK_KP_Home = Mpfc._WSK_KP_Home C_void
let _WSK_KP_Left = Mpfc._WSK_KP_Left C_void
let _WSK_KP_Up = Mpfc._WSK_KP_Up C_void
let _WSK_KP_Right = Mpfc._WSK_KP_Right C_void
let _WSK_KP_Down = Mpfc._WSK_KP_Down C_void
let _WSK_KP_Prior = Mpfc._WSK_KP_Prior C_void
let _WSK_KP_Page_Up = Mpfc._WSK_KP_Page_Up C_void
let _WSK_KP_Next = Mpfc._WSK_KP_Next C_void
let _WSK_KP_Page_Down = Mpfc._WSK_KP_Page_Down C_void
let _WSK_KP_End = Mpfc._WSK_KP_End C_void
let _WSK_KP_Begin = Mpfc._WSK_KP_Begin C_void
let _WSK_KP_Insert = Mpfc._WSK_KP_Insert C_void
let _WSK_KP_Delete = Mpfc._WSK_KP_Delete C_void
let _WSK_KP_Equal = Mpfc._WSK_KP_Equal C_void
let _WSK_KP_Multiply = Mpfc._WSK_KP_Multiply C_void
let _WSK_KP_Add = Mpfc._WSK_KP_Add C_void
let _WSK_KP_Separator = Mpfc._WSK_KP_Separator C_void
let _WSK_KP_Subtract = Mpfc._WSK_KP_Subtract C_void
let _WSK_KP_Decimal = Mpfc._WSK_KP_Decimal C_void
let _WSK_KP_Divide = Mpfc._WSK_KP_Divide C_void
let _WSK_KP_0 = Mpfc._WSK_KP_0 C_void
let _WSK_KP_1 = Mpfc._WSK_KP_1 C_void
let _WSK_KP_2 = Mpfc._WSK_KP_2 C_void
let _WSK_KP_3 = Mpfc._WSK_KP_3 C_void
let _WSK_KP_4 = Mpfc._WSK_KP_4 C_void
let _WSK_KP_5 = Mpfc._WSK_KP_5 C_void
let _WSK_KP_6 = Mpfc._WSK_KP_6 C_void
let _WSK_KP_7 = Mpfc._WSK_KP_7 C_void
let _WSK_KP_8 = Mpfc._WSK_KP_8 C_void
let _WSK_KP_9 = Mpfc._WSK_KP_9 C_void
let _WSK_F1 = Mpfc._WSK_F1 C_void
let _WSK_F2 = Mpfc._WSK_F2 C_void
let _WSK_F3 = Mpfc._WSK_F3 C_void
let _WSK_F4 = Mpfc._WSK_F4 C_void
let _WSK_F5 = Mpfc._WSK_F5 C_void
let _WSK_F6 = Mpfc._WSK_F6 C_void
let _WSK_F7 = Mpfc._WSK_F7 C_void
let _WSK_F8 = Mpfc._WSK_F8 C_void
let _WSK_F9 = Mpfc._WSK_F9 C_void
let _WSK_F10 = Mpfc._WSK_F10 C_void
let _WSK_F11 = Mpfc._WSK_F11 C_void
let _WSK_L1 = Mpfc._WSK_L1 C_void
let _WSK_F12 = Mpfc._WSK_F12 C_void
let _WSK_L2 = Mpfc._WSK_L2 C_void
let _WSK_F13 = Mpfc._WSK_F13 C_void
let _WSK_L3 = Mpfc._WSK_L3 C_void
let _WSK_F14 = Mpfc._WSK_F14 C_void
let _WSK_L4 = Mpfc._WSK_L4 C_void
let _WSK_F15 = Mpfc._WSK_F15 C_void
let _WSK_L5 = Mpfc._WSK_L5 C_void
let _WSK_F16 = Mpfc._WSK_F16 C_void
let _WSK_L6 = Mpfc._WSK_L6 C_void
let _WSK_F17 = Mpfc._WSK_F17 C_void
let _WSK_L7 = Mpfc._WSK_L7 C_void
let _WSK_F18 = Mpfc._WSK_F18 C_void
let _WSK_L8 = Mpfc._WSK_L8 C_void
let _WSK_F19 = Mpfc._WSK_F19 C_void
let _WSK_L9 = Mpfc._WSK_L9 C_void
let _WSK_F20 = Mpfc._WSK_F20 C_void
let _WSK_L10 = Mpfc._WSK_L10 C_void
let _WSK_F21 = Mpfc._WSK_F21 C_void
let _WSK_R1 = Mpfc._WSK_R1 C_void
let _WSK_F22 = Mpfc._WSK_F22 C_void
let _WSK_R2 = Mpfc._WSK_R2 C_void
let _WSK_F23 = Mpfc._WSK_F23 C_void
let _WSK_R3 = Mpfc._WSK_R3 C_void
let _WSK_F24 = Mpfc._WSK_F24 C_void
let _WSK_R4 = Mpfc._WSK_R4 C_void
let _WSK_F25 = Mpfc._WSK_F25 C_void
let _WSK_R5 = Mpfc._WSK_R5 C_void
let _WSK_F26 = Mpfc._WSK_F26 C_void
let _WSK_R6 = Mpfc._WSK_R6 C_void
let _WSK_F27 = Mpfc._WSK_F27 C_void
let _WSK_R7 = Mpfc._WSK_R7 C_void
let _WSK_F28 = Mpfc._WSK_F28 C_void
let _WSK_R8 = Mpfc._WSK_R8 C_void
let _WSK_F29 = Mpfc._WSK_F29 C_void
let _WSK_R9 = Mpfc._WSK_R9 C_void
let _WSK_F30 = Mpfc._WSK_F30 C_void
let _WSK_R10 = Mpfc._WSK_R10 C_void
let _WSK_F31 = Mpfc._WSK_F31 C_void
let _WSK_R11 = Mpfc._WSK_R11 C_void
let _WSK_F32 = Mpfc._WSK_F32 C_void
let _WSK_R12 = Mpfc._WSK_R12 C_void
let _WSK_F33 = Mpfc._WSK_F33 C_void
let _WSK_R13 = Mpfc._WSK_R13 C_void
let _WSK_F34 = Mpfc._WSK_F34 C_void
let _WSK_R14 = Mpfc._WSK_R14 C_void
let _WSK_F35 = Mpfc._WSK_F35 C_void
let _WSK_R15 = Mpfc._WSK_R15 C_void
let _WSK_Shift_L = Mpfc._WSK_Shift_L C_void
let _WSK_Shift_R = Mpfc._WSK_Shift_R C_void
let _WSK_Control_L = Mpfc._WSK_Control_L C_void
let _WSK_Control_R = Mpfc._WSK_Control_R C_void
let _WSK_Caps_Lock = Mpfc._WSK_Caps_Lock C_void
let _WSK_Shift_Lock = Mpfc._WSK_Shift_Lock C_void
let _WSK_Meta_L = Mpfc._WSK_Meta_L C_void
let _WSK_Meta_R = Mpfc._WSK_Meta_R C_void
let _WSK_Alt_L = Mpfc._WSK_Alt_L C_void
let _WSK_Alt_R = Mpfc._WSK_Alt_R C_void
let _WSK_Super_L = Mpfc._WSK_Super_L C_void
let _WSK_Super_R = Mpfc._WSK_Super_R C_void
let _WSK_Hyper_L = Mpfc._WSK_Hyper_L C_void
let _WSK_Hyper_R = Mpfc._WSK_Hyper_R C_void
let _WSK_space = Mpfc._WSK_space C_void
let _WSK_exclam = Mpfc._WSK_exclam C_void
let _WSK_quotedbl = Mpfc._WSK_quotedbl C_void
let _WSK_numbersign = Mpfc._WSK_numbersign C_void
let _WSK_dollar = Mpfc._WSK_dollar C_void
let _WSK_percent = Mpfc._WSK_percent C_void
let _WSK_ampersand = Mpfc._WSK_ampersand C_void
let _WSK_apostrophe = Mpfc._WSK_apostrophe C_void
let _WSK_quoteright = Mpfc._WSK_quoteright C_void
let _WSK_parenleft = Mpfc._WSK_parenleft C_void
let _WSK_parenright = Mpfc._WSK_parenright C_void
let _WSK_asterisk = Mpfc._WSK_asterisk C_void
let _WSK_plus = Mpfc._WSK_plus C_void
let _WSK_comma = Mpfc._WSK_comma C_void
let _WSK_minus = Mpfc._WSK_minus C_void
let _WSK_period = Mpfc._WSK_period C_void
let _WSK_slash = Mpfc._WSK_slash C_void
let _WSK_0 = Mpfc._WSK_0 C_void
let _WSK_1 = Mpfc._WSK_1 C_void
let _WSK_2 = Mpfc._WSK_2 C_void
let _WSK_3 = Mpfc._WSK_3 C_void
let _WSK_4 = Mpfc._WSK_4 C_void
let _WSK_5 = Mpfc._WSK_5 C_void
let _WSK_6 = Mpfc._WSK_6 C_void
let _WSK_7 = Mpfc._WSK_7 C_void
let _WSK_8 = Mpfc._WSK_8 C_void
let _WSK_9 = Mpfc._WSK_9 C_void
let _WSK_colon = Mpfc._WSK_colon C_void
let _WSK_semicolon = Mpfc._WSK_semicolon C_void
let _WSK_less = Mpfc._WSK_less C_void
let _WSK_equal = Mpfc._WSK_equal C_void
let _WSK_greater = Mpfc._WSK_greater C_void
let _WSK_question = Mpfc._WSK_question C_void
let _WSK_at = Mpfc._WSK_at C_void
let _WSK_A = Mpfc._WSK_A C_void
let _WSK_B = Mpfc._WSK_B C_void
let _WSK_C = Mpfc._WSK_C C_void
let _WSK_D = Mpfc._WSK_D C_void
let _WSK_E = Mpfc._WSK_E C_void
let _WSK_F = Mpfc._WSK_F C_void
let _WSK_G = Mpfc._WSK_G C_void
let _WSK_H = Mpfc._WSK_H C_void
let _WSK_I = Mpfc._WSK_I C_void
let _WSK_J = Mpfc._WSK_J C_void
let _WSK_K = Mpfc._WSK_K C_void
let _WSK_L = Mpfc._WSK_L C_void
let _WSK_M = Mpfc._WSK_M C_void
let _WSK_N = Mpfc._WSK_N C_void
let _WSK_O = Mpfc._WSK_O C_void
let _WSK_P = Mpfc._WSK_P C_void
let _WSK_Q = Mpfc._WSK_Q C_void
let _WSK_R = Mpfc._WSK_R C_void
let _WSK_S = Mpfc._WSK_S C_void
let _WSK_T = Mpfc._WSK_T C_void
let _WSK_U = Mpfc._WSK_U C_void
let _WSK_V = Mpfc._WSK_V C_void
let _WSK_W = Mpfc._WSK_W C_void
let _WSK_X = Mpfc._WSK_X C_void
let _WSK_Y = Mpfc._WSK_Y C_void
let _WSK_Z = Mpfc._WSK_Z C_void
let _WSK_bracketleft = Mpfc._WSK_bracketleft C_void
let _WSK_backslash = Mpfc._WSK_backslash C_void
let _WSK_bracketright = Mpfc._WSK_bracketright C_void
let _WSK_asciicircum = Mpfc._WSK_asciicircum C_void
let _WSK_underscore = Mpfc._WSK_underscore C_void
let _WSK_grave = Mpfc._WSK_grave C_void
let _WSK_quoteleft = Mpfc._WSK_quoteleft C_void
let _WSK_a = Mpfc._WSK_a C_void
let _WSK_b = Mpfc._WSK_b C_void
let _WSK_c = Mpfc._WSK_c C_void
let _WSK_d = Mpfc._WSK_d C_void
let _WSK_e = Mpfc._WSK_e C_void
let _WSK_f = Mpfc._WSK_f C_void
let _WSK_g = Mpfc._WSK_g C_void
let _WSK_h = Mpfc._WSK_h C_void
let _WSK_i = Mpfc._WSK_i C_void
let _WSK_j = Mpfc._WSK_j C_void
let _WSK_k = Mpfc._WSK_k C_void
let _WSK_l = Mpfc._WSK_l C_void
let _WSK_m = Mpfc._WSK_m C_void
let _WSK_n = Mpfc._WSK_n C_void
let _WSK_o = Mpfc._WSK_o C_void
let _WSK_p = Mpfc._WSK_p C_void
let _WSK_q = Mpfc._WSK_q C_void
let _WSK_r = Mpfc._WSK_r C_void
let _WSK_s = Mpfc._WSK_s C_void
let _WSK_t = Mpfc._WSK_t C_void
let _WSK_u = Mpfc._WSK_u C_void
let _WSK_v = Mpfc._WSK_v C_void
let _WSK_w = Mpfc._WSK_w C_void
let _WSK_x = Mpfc._WSK_x C_void
let _WSK_y = Mpfc._WSK_y C_void
let _WSK_z = Mpfc._WSK_z C_void
let _WSK_braceleft = Mpfc._WSK_braceleft C_void
let _WSK_bar = Mpfc._WSK_bar C_void
let _WSK_braceright = Mpfc._WSK_braceright C_void
let _WSK_asciitilde = Mpfc._WSK_asciitilde C_void
let _WS_LIST_TREE_OPEN = Mpfc._WS_LIST_TREE_OPEN C_void
let _WS_LIST_TREE_OPEN_CH = Mpfc._WS_LIST_TREE_OPEN_CH C_void
let _WS_LIST_INDENT_LEVEL = Mpfc._WS_LIST_INDENT_LEVEL C_void
let _WS_LIST_INDENT_STATUS = Mpfc._WS_LIST_INDENT_STATUS C_void
let _WS_LIST_LABEL_LIST = Mpfc._WS_LIST_LABEL_LIST C_void
let _WS_LIST_TOP = Mpfc._WS_LIST_TOP C_void
let _WS_ROOT_INSTANCE_ID = Mpfc._WS_ROOT_INSTANCE_ID C_void
let _WS_ROOT_PROPERTY_ID = Mpfc._WS_ROOT_PROPERTY_ID C_void
let _WS_ROOT_PROCEDURE_ID = Mpfc._WS_ROOT_PROCEDURE_ID C_void
let _WS_NEXT_CHILD_INSTANCE_ID = Mpfc._WS_NEXT_CHILD_INSTANCE_ID C_void
let _WS_PARENT_INSTANCE_ID = Mpfc._WS_PARENT_INSTANCE_ID C_void
let _WS_SET_ROOT_INSTANCE = Mpfc._WS_SET_ROOT_INSTANCE C_void
let _WS_REMOVE_ROOT_INSTANCE = Mpfc._WS_REMOVE_ROOT_INSTANCE C_void
let _WS_SET_SELECTED_INSTANCE = Mpfc._WS_SET_SELECTED_INSTANCE C_void
let _WS_REMOVE_SELECTED_INSTANCE = Mpfc._WS_REMOVE_SELECTED_INSTANCE C_void
let _WS_NEXT_SELECTED_INSTANCE_ID = Mpfc._WS_NEXT_SELECTED_INSTANCE_ID C_void
let _WS_INSTANCE_NAME = Mpfc._WS_INSTANCE_NAME C_void
let _WS_PROPERTY_NAME = Mpfc._WS_PROPERTY_NAME C_void
let _WS_PROPERTY_VALUE = Mpfc._WS_PROPERTY_VALUE C_void
let _WS_PROPERTY_TYPE = Mpfc._WS_PROPERTY_TYPE C_void
let _WS_PROPERTY_ATTRIBUTE = Mpfc._WS_PROPERTY_ATTRIBUTE C_void
let _WS_PROCEDURE_FUNCTION_NAME = Mpfc._WS_PROCEDURE_FUNCTION_NAME C_void
let _WS_PROCEDURE_NAME = Mpfc._WS_PROCEDURE_NAME C_void
let _WS_OBJECT_NAME = Mpfc._WS_OBJECT_NAME C_void
let _WS_OBJECT_ARRAY_NAME = Mpfc._WS_OBJECT_ARRAY_NAME C_void
let _WS_OBJECT_ARRAY_NAME_INVALID = Mpfc._WS_OBJECT_ARRAY_NAME_INVALID C_void
let _WS_OTHER_NAME = Mpfc._WS_OTHER_NAME C_void
let _WS_PROPERTY_SELECT_VALUE_NAME = Mpfc._WS_PROPERTY_SELECT_VALUE_NAME C_void
let _WS_PROPERTY_SELECT_VALUE = Mpfc._WS_PROPERTY_SELECT_VALUE C_void
let _WS_PROPERTY_TITLE = Mpfc._WS_PROPERTY_TITLE C_void
let _WS_PROPERTY_TYPE_COLOR = Mpfc._WS_PROPERTY_TYPE_COLOR C_void
let _WS_PROPERTY_TYPE_PIXMAP = Mpfc._WS_PROPERTY_TYPE_PIXMAP C_void
let _WS_PROPERTY_TYPE_FILE_SELECT = Mpfc._WS_PROPERTY_TYPE_FILE_SELECT C_void
let _WS_NEXT_PROPERTY_ID = Mpfc._WS_NEXT_PROPERTY_ID C_void
let _WS_NEXT_PROCEDURE_ID = Mpfc._WS_NEXT_PROCEDURE_ID C_void
let _WS_NEXT_PROPERTY_SELECT_ITEM_ID = Mpfc._WS_NEXT_PROPERTY_SELECT_ITEM_ID C_void
let _WS_NEXT_TARGET_ID = Mpfc._WS_NEXT_TARGET_ID C_void
let _WS_TARGET_NATIVE = Mpfc._WS_TARGET_NATIVE C_void
let _WS_TARGET_NAME = Mpfc._WS_TARGET_NAME C_void
let _WS_TARGET_SUFFIX = Mpfc._WS_TARGET_SUFFIX C_void
let _WS_ITEM_ROOT = Mpfc._WS_ITEM_ROOT C_void
let _WS_NEXT_LANG_ID = Mpfc._WS_NEXT_LANG_ID C_void
let _WS_LANG_STR = Mpfc._WS_LANG_STR C_void
let _WS_NEXT_ENCODING_ID = Mpfc._WS_NEXT_ENCODING_ID C_void
let _WS_ENCODING_NAME = Mpfc._WS_ENCODING_NAME C_void
let _WS_DEFAULT_PROJECT_FILE_NAME = Mpfc._WS_DEFAULT_PROJECT_FILE_NAME C_void
let _WS_LINK_OPT_DEF_FILE_NAME = Mpfc._WS_LINK_OPT_DEF_FILE_NAME C_void
let _WS_LINK_OPTIONS = Mpfc._WS_LINK_OPTIONS C_void
let _WS_STLINK_OPTIONS = Mpfc._WS_STLINK_OPTIONS C_void
let _WS_NEXT_LINK_OPT_ID = Mpfc._WS_NEXT_LINK_OPT_ID C_void
let _WS_LINK_OPT_NAME = Mpfc._WS_LINK_OPT_NAME C_void
let _WS_TARGET_INSTANCE_ID = Mpfc._WS_TARGET_INSTANCE_ID C_void
let _WS_LINK_LIB_DEF_FILE_NAME = Mpfc._WS_LINK_LIB_DEF_FILE_NAME C_void
let _WS_LINK_LIB_NAME = Mpfc._WS_LINK_LIB_NAME C_void
let _WS_LINK_CLASS_DEF_FILE_NAME = Mpfc._WS_LINK_CLASS_DEF_FILE_NAME C_void
let _WS_TARGET_DEF_FILE_NAME = Mpfc._WS_TARGET_DEF_FILE_NAME C_void
let _WS_ENV_DEF_FILE_NAME = Mpfc._WS_ENV_DEF_FILE_NAME C_void
let _WS_LIBNAME_DEF_FILE_NAME = Mpfc._WS_LIBNAME_DEF_FILE_NAME C_void
let _WS_TARGET_ENV_DEF_FILE_NAME = Mpfc._WS_TARGET_ENV_DEF_FILE_NAME C_void
let _WS_TARGET_ENV_TITLE = Mpfc._WS_TARGET_ENV_TITLE C_void
let _WS_TARGET_ENV_NAME = Mpfc._WS_TARGET_ENV_NAME C_void

let _WSGFloadProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadProject arg

let _WSGFloadProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadProject arg

let _WSGFreloadProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFreloadProject arg

let _WSGFreloadProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFreloadProject arg

let _WSGFdestroyProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFdestroyProject arg

let _WSGFdumpProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFdumpProject arg

let _WSGFsaveProject arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsaveProject arg

let _WSGFsetProjectData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetProjectData arg

let _WSGFgetProjectData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetProjectData arg

let _WSGFgetProjectDefaultData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetProjectDefaultData arg

let _WSGFgetProjectEnvironmentData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetProjectEnvironmentData arg

let _WSGFsetProjectEnvironmentData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetProjectEnvironmentData arg

let _WSGFsaveProjectEnvironment arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsaveProjectEnvironment arg

let _WSGFloadLinkOptions arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadLinkOptions arg

let _WSGFloadWinFiles arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadWinFiles arg

let _WSGFloadProjectAndWinFiles arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadProjectAndWinFiles arg

let _WSGFsaveWinFile arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsaveWinFile arg

let _WSGFloadTargets arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadTargets arg

let _WSGFgetMgrData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetMgrData arg

let _WSGFgetMgrStrData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetMgrStrData arg

let _WSGFgetMgrStrStrData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetMgrStrStrData arg

let _WSGFsetMgrStrData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetMgrStrData arg

let _WSGFidToProcedure arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFidToProcedure arg

let _WSGFprocedureToId arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFprocedureToId arg

let _WSGFcreateProjectSrcFile arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcreateProjectSrcFile arg

let _WSGFcreateMakefiles arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcreateMakefiles arg

let _WSGFcreateWindowSrcFiles arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcreateWindowSrcFiles arg

let _WSGFsetDefaultVePopupMenus arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetDefaultVePopupMenus arg

let _WSGFsetDefaultVePropertyEditProcedures arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetDefaultVePropertyEditProcedures arg

let _WSGFcheckNameString arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcheckNameString arg

let _WSGFisArrayName arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFisArrayName arg

let _WSGFgetArrayNo arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetArrayNo arg

let _WSGFgetArrayName arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetArrayName arg

let _WSGFexistName arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFexistName arg

let _WSGFcheckExistFile arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcheckExistFile arg

let _WSGFsetupInstance arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetupInstance arg

let _WSGFloadLibrary arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFloadLibrary arg

let _WSGFsetFontData arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFsetFontData arg

let _WSGFgetEncodingValue arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFgetEncodingValue arg
let _WS_LANG_CPP = Mpfc._WS_LANG_CPP C_void
let _WS_LANG_RUBY = Mpfc._WS_LANG_RUBY C_void
let _WS_LANG_PYTHON = Mpfc._WS_LANG_PYTHON C_void
let _WS_LANG_PERL = Mpfc._WS_LANG_PERL C_void
let _WS_LANG_JAVA = Mpfc._WS_LANG_JAVA C_void
let _WS_LANG_OCAML = Mpfc._WS_LANG_OCAML C_void

let _WSGFcreateProcedure arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFcreateProcedure arg

let _WSGFpasteInstance arg =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc._WSGFpasteInstance arg
let _WS_ERR_NOT_MANAGER = Mpfc._WS_ERR_NOT_MANAGER C_void
let _WS_ERR_OVERWRAPED = Mpfc._WS_ERR_OVERWRAPED C_void

let new_WSCpoint clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCpoint clst

let new_WSCrect clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCrect clst

let new_WSCstring clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCstring clst

let new_WSCstring clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCstring clst

let new_WSCstring clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCstring clst

let new_WSCvariant clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvariant clst

let new_WSCvariant clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvariant clst

let new_WSCvariant clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvariant clst

let new_WSCvariant clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvariant clst

let new_WSCvariant clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvariant clst

let new_WSCprocedure clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCprocedure clst

let new_WSCbase clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCbase clst

let new_WSCform clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCform clst

let new_WSCnwbase clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCnwbase clst

let new_WSCngbase clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCngbase clst

let new_WSCvlabel clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvlabel clst

let new_WSCvbtn clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvbtn clst

let new_WSCvfbtn clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvfbtn clst

let new_WSCvendbtn clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvendbtn clst

let new_WSCvklabel clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvklabel clst

let new_WSCvkflabel clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvkflabel clst

let new_WSCvifield clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvifield clst

let new_WSCvkslabel clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvkslabel clst

let new_WSCvmifield clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvmifield clst

let new_WSCvpifield clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvpifield clst

let new_WSCtextField clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCtextField clst

let new_WSCvarrow clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvarrow clst

let new_WSCvscrBar clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvscrBar clst

let new_WSCvpolyAttr clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvpolyAttr clst

let new_WSCvmeter clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvmeter clst

let new_WSCvclock clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvclock clst

let new_WSCvslider clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvslider clst

let new_WSCpulldownMenu clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCpulldownMenu clst

let new_WSCcomboBox clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCcomboBox clst

let new_WSCoption clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCoption clst

let new_WSCgrid clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCgrid clst

let new_WSCvimage clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvimage clst

let new_WSCvrect clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvrect clst

let new_WSCvarc clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvarc clst

let new_WSCvpoly clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvpoly clst

let new_WSCvline clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvline clst

let new_WSDimage clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSDimage clst

let new_WSCvdrawingArea clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvdrawingArea clst

let new_WSCvbarGraph clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvbarGraph clst

let new_WSCvlineGraph clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvlineGraph clst

let new_WSCvgraphScale clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvgraphScale clst

let new_WSCvgraphMatrix clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvgraphMatrix clst

let new_WSCvtimer clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvtimer clst

let new_WSCvspace clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvspace clst

let new_WSCvballoonHelp clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvballoonHelp clst

let new_WSCvcsocket clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvcsocket clst

let new_WSCvssocket clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvssocket clst

let new_WSCvudpsocket clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvudpsocket clst

let new_WSCvremoteClient clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvremoteClient clst

let new_WSCvremoteServer clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvremoteServer clst

let new_WSCvdb clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvdb clst

let new_WSCdbRecord clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCdbRecord clst

let new_WSCwindow clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCwindow clst

let new_WSCmainWindow clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCmainWindow clst

let new_WSCbaseDialog clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCbaseDialog clst

let new_WSCdialog clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCdialog clst

let new_WSCmessageDialog clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCmessageDialog clst

let new_WSCinputDialog clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCinputDialog clst

let new_WSCwizardDialog clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCwizardDialog clst

let new_WSCfileSelect clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCfileSelect clst

let new_WSCworkingDialog clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCworkingDialog clst

let new_WSCindexForm clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCindexForm clst

let new_WSCsform clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCsform clst

let new_WSCvtoggle clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvtoggle clst

let new_WSCvradio clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvradio clst

let new_WSCradioGroup clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCradioGroup clst

let new_WSCcheckGroup clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCcheckGroup clst

let new_WSCvertForm clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCvertForm clst

let new_WSChorzForm clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSChorzForm clst

let new_WSCmenuArea clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCmenuArea clst

let new_WSCtform clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCtform clst

let new_WSCfform clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCfform clst

let new_WSCprform clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCprform clst

let new_WSCj3wform clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCj3wform clst

let new_WSCscrForm clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCscrForm clst

let new_WSClist clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSClist clst

let new_WSCverbList clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCverbList clst

let new_WSCtreeList clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCtreeList clst

let new_WSCdirTree clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCdirTree clst

let new_WSDcolor clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSDcolor clst

let new_WSCcolorSet clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCcolorSet clst

let new_WSCimageSet clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCimageSet clst

let new_WSDfont clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSDfont clst

let new_WSCfontSet clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCfontSet clst

let new_WSCbaseList clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCbaseList clst

let new_WSCsheet clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCsheet clst

let new_WSCindexData clst =
   match !mpfc_inited with
   | false -> C_void
   | true  -> Mpfc.new_WSCindexData clst

let invoke obj =
   match !mpfc_inited with
   | true -> Swig.invoke obj
   | false -> (fun mth arg -> C_void)

let get_int x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_int (o "getInt" C_void)
         with _ -> Swig.get_int x
      end
   | _ -> Swig.get_int x

let get_float x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_float (o "getDouble" C_void)
         with _ ->
         try
            Swig.get_float (o "getFloat" C_void)
         with _ -> Swig.get_float x
      end
   | _ -> Swig.get_float x

let get_char x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_char (o "getChar" C_void)
         with _ -> Swig.get_char x
      end
   | _ -> Swig.get_char x

let get_string x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_string (o "getCharPtr" C_void)
         with _ ->
         try
            Swig.get_string (o "getString" C_void)
         with _ -> Swig.get_string x
      end
   | _ -> Swig.get_string x

let get_bool x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_bool (o "getUnsignedChar" C_void)
         with _ -> Swig.get_bool x
      end
   | _ -> Swig.get_bool x
