//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <stdio.h>
int main(int argc,char* argv[]){
  int bk = -1;
  int conv = 0;
  int notescape = 0;
  unsigned char val = 0;
  if (argc <3){
    fprintf(stderr,"Usage: sjisfix inputfile outputfile\n");
    return -1;
  }
  FILE* in =fopen(argv[1],"rb");
  FILE* out = fopen(argv[2],"wb");
  if (in == NULL){
    fprintf(stderr,"sjisfix: Can not open inputfile:%s\n",argv[1]);
    return -1;
  }
  if (out == NULL){
    fprintf(stderr,"sjisfix: Can not open outputfile:%s\n",argv[2]);
    return -1;
  }
  while(feof(in) == 0){
    unsigned char val = getc(in);
    if (bk > 0x7f && notescape ==0){
      notescape = 1;
    }else if (bk < 0x80 && notescape%2 ==1){
      notescape = 0;
    }else if (val < 0x80 && notescape%2 ==1){
      notescape = 0;
    }else if (notescape > 0){
      notescape++;
    }
#if 0
    if (bk < 0x80  && val < 0x80){
      notescape = 0;
    }else if (bk > 0x80 ){
      notescape++;
    }
#endif
    if (val == 0x0d ){
        continue;
    }
    if (bk > 0x80 && val == '\\' && notescape%2 == 1){
      fprintf(out,"\\x%02x\\\\",bk);
      conv = 1;
      bk = -1;
      continue;
    }else if(val == 0x0a){
//      if( bk == '\\' && conv == 1){
      if (bk != -1){
        putc(bk,out);
        if (bk != ' ' && bk != '\t'){
          conv = 0;
        }
      }
      if(conv == 1){
        putc('.',out);
      }
      fprintf(out,"\n");
      bk = -1;
      conv = 0;
      continue;
    }else if (bk != -1){
      putc(bk,out);
      if (bk != ' ' && bk != '\t'){
        conv = 0;
      }
    }
    bk = (int)val;
  }

  if (val != 0){
    putc(val,out);
  }
  return 0;
}
