//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <windows.h>
#include <win/WSDwinformDev.h>
#include <win/WSDwinAppDev.h>
#include <WSCdevice.h>
#include <win/WSDwindraw.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSCbase.h>
//#include <WSwincom.h>
#include <win/WSDwinDragDrop.h>
#include <WSDmouse.h>
#include <WSCbaseList.h>
#include <WSDsemaphore.h>

#define DEBUG

WSMFclassInit(WSDwinformDev,WSDwindowDev);

WSDdev* _wscdwinformdev_init_(){
  return new WSDwinformDev();
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _WSDwinformDev_init_ {
  public:_WSDwinformDev_init_(){
     WSGIappDevice()->setCreateHandler("formDev",_wscdwinformdev_init_);
  };
};
static _WSDwinformDev_init_ _init_to_run_WSDwinformDev_;
#endif

//static WSDwindraw* draw_of_winform = NULL;
static long _os_flag = -1;

WSDwinformDev::WSDwinformDev(){
dbprintf("WSDwinformDev::WSDwinformDev %s:%d start\n",__FILE__,__LINE__);
  _click_time = 0;
  if (_os_flag == -1){
    OSVERSIONINFO osvi;
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    GetVersionEx(&osvi);
    _os_flag = osvi.dwPlatformId;
  }
  _mouse_val = 0;
  _pwnd = 0;
  _wnd  = 0;
  _pixmap  = 0;
  _pixmap_mdc  = 0;
  _back_cno = -1;
  _back_pixno = -1;
  _abs_x = 0;
  _abs_y = 0;
  _dc = 0;
  _mdc = 0;
  _exposed = False;
  _moved = False;
  _resized = False;
  _bg_image = 0;
  _mouse_no = 0;
  _global_mouse = False;
//WSMFtrace("WSDwinformDev::WSDwinformDev this=0x%x\n",this);
//  if (draw_of_winform == NULL){
//      draw_of_winform = new WSDwindraw();
//  }
//  setDraw(draw_of_winform);
dbprintf("WSDwinformDev::WSDwinformDev %s:%d done\n",__FILE__,__LINE__);
}

WSDwinformDev::~WSDwinformDev(){
dbprintf("WSDwinformDev::~WSDwinformDev %s:%d start\n",__FILE__,__LINE__);
//printf("WSDwinformDev::~WSDwinformDev this=0x%x XXZZff1\n",this);
//WSMFtrace("WSDwinformDev::~WSDwinformDev 0x%x\n",this);
//  destroyContext();
  destroyPixmap();
  destroyWindow();
//  setExposed(False);
  WSGIwinAppDev()->delUpdateDev(this);
  _exposed = False;
dbprintf("WSDwinformDev::~WSDwinformDev %s:%d done\n",__FILE__,__LINE__);
}
void WSDwinformDev::setExposed(WSCbool fl){
  if (fl != False){
    WSGIwinAppDev()->delUpdateDev(this);
  }else{
    WSGIwinAppDev()->addUpdateDev(this);
  }
  _exposed = fl;
}
short WSDwinformDev::getAbsoluteX(){
  RECT r;
  GetWindowRect(_wnd,&r);
  return r.left;
}
short WSDwinformDev::getAbsoluteY(){
  RECT r;
  GetWindowRect(_wnd,&r);
  return r.top;
}

WSDdev* WSDwinformDev::getEventParentDev(){
  return this;
}

HWND WSDwinformDev::getHWND(){
  return _wnd;
}

long WSDwinformDev::setValue(long kind,void* data){
//  short bx,by;
//  WSCushort bw,bh;
  if (kind == WSDEV_X && *(short*)data == _w_x){
    return WS_NO_ERR;
  }
  if (kind == WSDEV_Y && *(short*)data == _w_y){
    return WS_NO_ERR;
  }
  if (kind == WSDEV_WIDTH && *(WSCushort*)data == _w_w){
    return WS_NO_ERR;
  }
  if (kind == WSDEV_HEIGHT && *(WSCushort*)data == _w_h){
    return WS_NO_ERR;
  }


//  Arg args[4];
  WSDcolor* color;
  WSDimage* image;
//  WSCbool unmanaged = False;
//  WSCbool fl;
  RECT p;
  switch(kind){
    case WSDEV_X: 
             if (_wnd == NULL){
               break;
             }
             _moved = True;
             GetClientRect(_wnd,&p);
             _w_x = *(short*)data;
             MoveWindow(_wnd,_w_x,_w_y,p.right,p.bottom, True);
             if (getVisible() != False){
               _expose_children(0,0,_w_w,_w_h);
             }
             break;
    case WSDEV_Y:
             if (_wnd == NULL){
               break;
             }
             _moved = True;
             GetClientRect(_wnd,&p);
             _w_y = *(short*)data;
             MoveWindow(_wnd,_w_x,_w_y,p.right,p.bottom, True);
             if (getVisible() != False){
               _expose_children(0,0,_w_w,_w_h);
             }
             break;
    case WSDEV_WIDTH:
             if (_wnd == NULL){
               break;
             }
//             _resized = True;
             if (getPixmapStyle() != WS_DIRECT_WINDOW){
               destroyPixmap();
             }
             if (_resize_sequence != False && *(short*)data == _w_now){
               break;
             }             
             if (*(WSCushort*)data > 0){
               GetClientRect(_wnd,&p);
               p.right = p.left + *(WSCushort*)data;
               MoveWindow(_wnd,_w_x,_w_y,p.right,p.bottom, True);
             }
             break;
    case WSDEV_HEIGHT:
             if (_wnd == NULL){
               break;
             }
             _resized = True;
             if (getPixmapStyle() != WS_DIRECT_WINDOW){
               destroyPixmap();
             }
             if (_resize_sequence != False && *(short*)data == _h_now){
               break;
             }             
             if (*(WSCushort*)data > 0){
               GetClientRect(_wnd,&p);
               p.bottom = p.top + *(WSCushort*)data;
               MoveWindow(_wnd,_w_x,_w_y,p.right,p.bottom, True);
             }
             break;
    case WSDEV_BACKCOLOR:
             color = WSGIappColorSet()->getColor(*(short*)data);
             _back_cno = *(short*)data;
             if (color != NULL){
               _bg_cref = (COLORREF)color->getValue1();
             }
             if (_wnd == NULL){
               break;
             }
             setExposed(False);
             invalidate(TRUE);
             break;
    case WSDEV_BACK_PIXMAP:
             _back_pixno = *(short*)data;
             if (*(short*)data == -1){
               _bg_image = 0;
             }else{
               image = WSGIappImageSet()->getImage(*(short*)data);
               if (image != NULL){
                 if (image->getValue1() == -1){
                   _bg_image = 0;
                 }else{
                   _bg_image = (HBITMAP)image->getValue1();
                 }
               }
             }
             if (_wnd != 0){
               setExposed(False);
               invalidate(TRUE);
             }
             break;
    case WSDEV_GRAB_POINTER:
             if (_wnd == NULL){
               break;
             }
             WSGIwinAppDev()->_grabed = *(WSCbool*)data;
             if (WSGIwinAppDev()->_grabed != False){
               WSGIwinAppDev()->setGrabedWnd(_wnd);
               WSGIappMouse()->setMouseFocusClient(NULL);
             }else{
               long state = WSGIappMouse()->getStatus();
               if (state > 0){
                 break;
               }
               WSGIwinAppDev()->setGrabedWnd(NULL);
             }
             break;
     case WSDEV_MOUSE_NO:
             _mouse_no = *(WSCushort*)data;
             _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(*(WSCushort*)data);

             break;
     default:
             break;
  }
  WSDwindowDev::setValue(kind,data);
  return WS_NO_ERR;
}

void WSDwinformDev::_copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl){
  if (_exposed == False){
    return;
  }
  if (_wnd == 0){
    return;
  }

  WSCbool release_dc = False;
  if (_dc == 0){
    _dc = GetDC(_wnd);
    if (_dc == 0){
      return;
    }
    release_dc = True;
  }
  HPALETTE palette = WSGIwinAppDev()->getPalette();
  HPALETTE palette_bk = 0;
  if (palette != 0 ){
     palette_bk = SelectPalette(_dc,palette,False);
     RealizePalette(_dc);
  }
  if (fl == WS_PIXMAP_TO_WINDOW){
    if (_mdc != 0){
      BitBlt(_dc,dx,dy,w,h,_mdc,x,y,SRCCOPY);
    } 
  }else{ 
    BitBlt(_dc,dx,dy,w,h,_dc,x,y,SRCCOPY);
    if (_mdc != 0){
      SelectClipRgn(_mdc,(HRGN)0);
      BOOL ret = BitBlt(_mdc,dx,dy,w,h,_mdc,x,y,SRCCOPY);
    }
  }
  if (palette != 0){
    SelectPalette(_dc,palette_bk,False);
  }
  if (release_dc != 0){
    ReleaseDC(_wnd,_dc);
    _dc = 0;
  }

#ifdef DEBUG
WSMFtrace("WSDwinformDev::_copy_area() is not implemented..\n");
#endif
}

void WSDwinformDev::_clear_area(long x,long y,WSCulong w,WSCulong h){
  if (w == 23767){
    return;
  }
  if (h == 23767){
    return;
  }
  if (x+(long)w < 0){
    return;
  }
  if (y+(long)h < 0){
    return;
  }
  if (_wnd == 0){
    return;
  }
  RECT r;
  r.left = x;
  r.right = x + w;
  r.top = y;
  r.bottom = y + h;
  HDC dc = 0;
  WSCbool release_dc = False;
  if (getPixmapStyle() == WS_DIRECT_WINDOW){
    if (_dc == 0){
      _dc = GetDC(_wnd);
      if (_dc == 0){
        return;
      }
      release_dc = True;
    }
    dc = _dc;
  }else{
    if (_mdc == 0){
      createPixmap();
    }
    dc = _mdc;
  }
  HPALETTE palette = WSGIwinAppDev()->getPalette();
  HPALETTE palette_bk = 0;
  if (palette != 0 ){
     palette_bk = SelectPalette(dc,palette,False);
     RealizePalette(dc);
  }


  if (_bg_image != 0){
    WSDimage* img = WSGIappImageSet()->getImage(_back_pixno);
    if (img != NULL){
      HDC mdc2 = CreateCompatibleDC(dc);
      HBITMAP bbk = (HBITMAP)SelectObject(mdc2,(void*)_bg_image);
#ifndef _WSWINCE
      SetMapMode(mdc2,GetMapMode(dc));
#endif
      POINT p;
      p.x = img->getImageWidth();
      p.y = img->getImageHeight();
#ifndef _WSWINCE
      DPtoLP(dc,&p,1);
#endif
      WSCushort pw = p.x;
      WSCushort ph = p.y;
      if (pw < 1){
        pw = 1;
      }
      if (ph < 1){
        ph = 1;
      }

      HRGN rgn = CreateRectRgn(x,y,x+w,y+h);
      SelectClipRgn(dc,rgn);

      HBITMAP bg_mask = (HBITMAP)img->getValue3();
      HDC mdc3 = 0;
      HBITMAP bbk2 = 0;
      if (bg_mask != (HBITMAP)-1 && bg_mask != (HBITMAP)0){
        mdc3 = CreateCompatibleDC(dc);
        bbk2 = (HBITMAP)SelectObject(mdc3,(void*)bg_mask);
#ifndef _WSWINCE
        SetMapMode(mdc3,GetMapMode(dc));
#endif
        HBRUSH brush = CreateSolidBrush(_bg_cref);
        FillRect(dc,&r,brush);
        DeleteObject(brush);
      }

      long dx,dy;
      for(dx = 0; dx < (signed long)(x+w); dx = dx + pw){
        for(dy = 0; dy < (signed long)(y+h); dy = dy + ph){
          if ( dx < (signed long)(x+w) && dy < (signed long)(y+h)){
            if (mdc3 == 0){
              BitBlt(dc,dx,dy,pw,ph,mdc2,0,0,SRCCOPY);
            }else{
extern void _draw_image_with_mask(HDC hdc,HDC mdc,HDC mdc2,HBITMAP pix,HBITMAP pix2,HPALETTE pl,int x,int y,int w,int h);
              _draw_image_with_mask(dc,mdc2,mdc3,_bg_image, bg_mask,palette,dx,dy,pw,ph);
            }
          }
        }
      }
      SelectClipRgn(dc,(HRGN)0);
      SelectObject(mdc2,(void*)bbk);
      DeleteObject((void*)rgn);
      DeleteDC(mdc2);
      if (mdc3 != 0){
        SelectObject(mdc3,(void*)bbk2);
        DeleteDC(mdc3);
      }
    }
  }else{
    HBRUSH brush = CreateSolidBrush(_bg_cref);
    FillRect(dc,&r,brush);
    DeleteObject(brush);
  }
  if (palette != 0){
    SelectPalette(dc,palette_bk,False);
  }
  if (release_dc != 0){
    ReleaseDC(_wnd,_dc);
    _dc = 0;
  }
}
WSDwinformDev* WSDwinformDev::getParentAreaDev(){
  WSDdev*      pdev = WSDwinformDev::getParentDev();
  if (pdev == NULL){
    return NULL;
  }

  WSDwinformDev* windev = (WSDwinformDev*)pdev->cast("WSDwinformDev");
  if (windev == NULL){
    while(windev == NULL){
      pdev = pdev->getParentDev();
      if (pdev == NULL){
        return NULL;
      }
      windev = (WSDwinformDev*)pdev->cast("WSDwinformDev");
    }
  }
  return windev;
}

void WSDwinformDev::_setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no){
  if (_exposed == False){
//    return;
    _exposed = True;
  }
  if (_mdc == (HDC)0 ||_wnd == (HWND)0){
    return;
  }

  WSDcolor*  color = WSGIappColorSet()->getColor(bg);
  COLORREF bgref = 0;
  if (color != NULL){
    bgref = (COLORREF)color->getValue1();
  }

  if (getPixmap() == (HBITMAP)0){
    createPixmap();
    if (getPixmap() == (HBITMAP)0){
      return;
    } 
  }
  HPALETTE pl = WSGIwinAppDev()->getPalette();
  HPALETTE plbk = 0;
  if (pl != (HPALETTE)0){
    plbk = SelectPalette(_mdc,pl,FALSE);
    RealizePalette(_mdc);
  }
  RECT r;
  r.left =x;
  r.top  =y;
  r.right = x+w;
  r.bottom = y+h;

  if (_bg_image != (HBITMAP)0){
    WSDimage* img = WSGIappImageSet()->getImage(_back_pixno);
    if (img != NULL){
#ifndef _WSWINCE
      SIZE size1; 
      GetBitmapDimensionEx(_bg_image,&size1);
#endif
      HDC mdc2 = CreateCompatibleDC(_mdc);
      HBITMAP bbk = (HBITMAP)SelectObject(mdc2,(void*)_bg_image);
#ifndef _WSWINCE
      SetMapMode(mdc2,GetMapMode(_mdc));
#endif
      POINT p;
      p.x = img->getImageWidth();
      p.y = img->getImageHeight();
#ifndef _WSWINCE
      DPtoLP(_mdc,&p,1);
#endif
      WSCushort pw = p.x;
      WSCushort ph = p.y;
      if (pw < 1){
        pw = 1;
      }
      if (ph < 1){
        ph = 1;
      }
      HRGN rgn = CreateRectRgn(x,y,x+w,y+h);
      SelectClipRgn(_mdc,rgn);

      HBITMAP bg_mask = (HBITMAP)img->getValue3();
      HDC mdc3 = 0;
      HBITMAP bbk2 = 0;
      if (bg_mask != (HBITMAP)-1 && bg_mask != (HBITMAP)0){
        mdc3 = CreateCompatibleDC(_mdc);
        bbk2 = (HBITMAP)SelectObject(mdc3,(void*)bg_mask);
#ifndef _WSWINCE
        SetMapMode(mdc3,GetMapMode(_mdc));
#endif
        HBRUSH br = CreateSolidBrush(bgref);
        FillRect(_mdc,&r,br);
        DeleteObject((void*)br);
      }

      long dx,dy;
      for(dx = 0; dx < x+w; dx = dx + pw){
        for(dy = 0; dy < y+h; dy = dy + ph){
          if ( dx < x+w && dy < y+h){
            if (mdc3 == 0){
              BitBlt(_mdc,dx,dy,pw,ph,mdc2,0,0,SRCCOPY);
            }else{
extern void _draw_image_with_mask(HDC hdc,HDC mdc,HDC mdc2,HBITMAP pix,HBITMAP pix2,HPALETTE pl,int x,int y,int w,int h);
              _draw_image_with_mask(_mdc,mdc2,mdc3,_bg_image, bg_mask,pl,dx,dy,pw,ph);
            }
          }
        }
      }
      SelectClipRgn(_mdc,(HRGN)0);
      SelectObject(mdc2,(void*)bbk);
      DeleteObject((void*)rgn);
      DeleteDC(mdc2);
      if (mdc3 != 0){
        SelectObject(mdc3,(void*)bbk2);
        DeleteDC(mdc3);
      }
    }
  }else{
    HBRUSH br = CreateSolidBrush(bgref);
    SelectClipRgn(_mdc,(HRGN)0);
    FillRect(_mdc,&r,br);
    DeleteObject((void*)br);
  }
  if (plbk != (HPALETTE)0){
    SelectPalette(_mdc,plbk,FALSE);
  }

  return;
}

long WSDwinformDev::createWindow(){
#ifdef DEBUG
WSMFtrace("WSDwinformDev::createWindow() this=0x%x\n",this);
WSMFtrace("WSDwinformDev::createWindow() remove delete callback is not implemented..\n");
#endif
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  short x,y;    
  WSCushort w,h;    
  getWindowSize(&x,&y,&w,&h);
  if (w == 0){
    w = 1;
  }
  if (h == 0){
    h = 1;
  }
  WSDwinformDev* windev;
  windev = getParentAreaDev();

  if (windev == NULL){
    return WS_ERR;
  }

extern char szAppName[];
  _pwnd = windev->getHWND();
#ifndef _WSWINCE
  _wnd = WSGFcreateWindow( szAppName,"",WS_CHILD | WS_OVERLAPPED | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,x,y,w,h,windev->getHWND(),
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#else
  WSCushort* tmpstr = WSGFgetUCS2(szAppName,WS_EN_DEFAULT);
  WSCushort tmpstr2[1];
  tmpstr2[0] = 0;
  _wnd = CreateWindow( tmpstr,tmpstr2,WS_CHILD | WS_CLIPSIBLINGS,x,y,w,h,windev->getHWND(),
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
  delete tmpstr;
#endif
  if (WSGIwinAppDev()->getWndProc() != NULL){
    SetWindowLong(_wnd,GWL_WNDPROC,(LONG)WSGIwinAppDev()->getWndProc());
  }

#ifndef _WSWINCE
  SetProp(_wnd,"frm",(HANDLE)this);
#else
  unsigned short str1[4];
  str1[0] = 'f';
  str1[1] = 'r';
  str1[2] = 'm';
  str1[3] = 0;
  SetProp(_wnd,str1,(HANDLE)this);
#endif
#ifdef DEBUG
WSMFtrace("WSDwinformDev::createWindow() add callbacks is not implemented..\n");
#endif

  return WS_NO_ERR;
}

long WSDwinformDev::setPixmap(HBITMAP pixmap){
  if (pixmap == 0 && _mdc != NULL){
    if (_pixmap_mdc != 0){
      SelectObject(_mdc,_pixmap_mdc); //leaks the gdi objects on win98..
    }
    _pixmap_mdc = 0;
  }
  if (_pixmap != (HBITMAP)0){
    DeleteObject((void*)_pixmap);
    _pixmap = (HBITMAP)0;
  }
  _pixmap = pixmap;
  if (pixmap == 0 && _mdc != NULL){
    DeleteDC(_mdc);
    _mdc = 0;
    _pixmap_mdc = 0;
  }
  return WS_NO_ERR;
}

long WSDwinformDev::getDeviceResource(){
  return 0;
}

long WSDwinformDev::createPixmap(){
  if (_wnd == 0){
    return WS_ERR;
  }
  destroyPixmap();
  WSCushort w = _w_w;
  WSCushort h = _w_h;
  if (_dc == 0){
    _dc = GetDC(_wnd);
    if (_mdc == 0){
      _mdc = CreateCompatibleDC(_dc);
    }
    if (_mdc == 0){
      ReleaseDC(_wnd,_dc);
      _dc = 0;
      return WS_ERR;
    }
    HBITMAP pix = CreateCompatibleBitmap(_dc,w,h);
    setPixmap(pix);
    if (_mdc == 0){
      ReleaseDC(_wnd,_dc);
      _dc = 0;
      return WS_ERR;
    }
    if (_os_flag == VER_PLATFORM_WIN32_NT){
      SelectObject(_mdc,_pixmap); //leaks the gdi objects on win98..
    }else{
      if (_pixmap_mdc == 0){
        _pixmap_mdc = (HBITMAP)SelectObject(_mdc,_pixmap); //leaks the gdi objects on win98..
      }else{
        SelectObject(_mdc,_pixmap); //leaks the gdi objects on win98..
      }
    }
    ReleaseDC(_wnd,_dc);
    _dc = 0;
  }else{
    if (_mdc == 0){
      _mdc = CreateCompatibleDC(_dc);
    }
    if (_mdc == 0){
      return WS_ERR;
    }
    HBITMAP pix = CreateCompatibleBitmap(_dc,w,h);
    setPixmap(pix);
    if (_mdc == 0){
      return WS_ERR;
    }
    if (_os_flag == VER_PLATFORM_WIN32_NT){
      SelectObject(_mdc,_pixmap); //leaks the gdi objects on win98..
    }else{
      if (_pixmap_mdc == 0){
        _pixmap_mdc = (HBITMAP)SelectObject(_mdc,_pixmap); //leaks the gdi objects on win98..
      }else{
        SelectObject(_mdc,_pixmap); //leaks the gdi objects on win98..
      }
    }
  }
  setExposed(True);
   
  _setup_pixmap(0,0,w,h,_bg_no,_bp_no);
  exposeExecute(0,0,w,h);

  return WS_NO_ERR;
}

long WSDwinformDev::getContextResource(){
  if (getPixmapStyle() != WS_DIRECT_WINDOW ){
    if (_mdc == 0){
      return -1;
    }else{
      return (long)_mdc;
    }
  }else{
    return (long)_dc;
  }
  return 0;
}

long WSDwinformDev::getSpecialResource(){
   return (long)_wnd;
}

long WSDwinformDev::getWindowResource(){
  return (long)_wnd;
}


HBITMAP WSDwinformDev::getPixmap(){
  return _pixmap;
}

HWND WSDwinformDev::getWindow(){
  if (getPixmapStyle() != WS_DIRECT_WINDOW ){
    if ( getPixmap() != 0 ){
      return (HWND)getPixmap();
    }else{
      return (HWND)-1;
    }
  }
  if (_wnd == 0){
    return (HWND)-1;
  }
  return _wnd;
}

long WSDwinformDev::destroyWindow(){
dbprintf("WSDwinformDev::destroyWindow %s:%d wnd=0x%x\n",__FILE__,__LINE__,_wnd);
#ifdef DEBUG
WSMFtrace("WSDwinformDev::destroyWindow() remove callbacks is not implemented..\n");
#endif
  WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
  if (mdev == this){
    WSGIwinAppDev()->setMouseFocusDev(NULL);
  }
  if (_wnd != 0){
    MSG msg;
    while(PeekMessage(&msg,_wnd,0,0,PM_REMOVE)){
      if (msg.message == WM_PAINT){
          PAINTSTRUCT ps;
          BeginPaint(_wnd,&ps);
          EndPaint(_wnd,&ps);
      }
    }
    WSGFdestroyWindow(_wnd);
#ifndef _WSWINCE
    SetProp(_wnd,"frm",(HANDLE)0);
#else
    unsigned short str1[4];
    str1[0] = 'f';
    str1[1] = 'r';
    str1[2] = 'm';
    str1[3] = 0;
    SetProp(_wnd,str1,(HANDLE)0);
#endif
    _wnd = 0;
  }
  _pwnd = 0;
  _wnd = 0;
  setInitialized(False);
  return WS_NO_ERR;
}

long WSDwinformDev::destroyPixmap(){
  if (_mdc != 0){
    if (_pixmap_mdc != 0){
      SelectObject(_mdc,_pixmap_mdc); //leaks the gdi objects on win98..
    }
  }
  if (_pixmap != 0){
    DeleteObject((void*)_pixmap);
    _pixmap = 0;
  }
  if (_mdc != 0){
    DeleteDC(_mdc);
    _mdc = 0;
    _pixmap_mdc = 0;
  }
//  setPixmap(0);
  WSDwindowDev::destroyPixmap();
  return WS_NO_ERR;
}

long WSDwinformDev::setVisible(WSCbool fl){
  WSCbool bk = getVisible();
  WSDdev::setVisible(fl);
  if (fl == True){
    if (getAttachedClient() == NULL){
      fl = False;
    }else if (getAttachedClient()->getVisible() == False){
      fl = False;
    }
  }
  if (fl == False){
    WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
    if (mdev == this){
      WSGIwinAppDev()->setMouseFocusDev(NULL);
    }
    WSDwinformDev* windev = getParentAreaDev();
    if (windev != NULL && windev->getHWND() == 0){
      destroyWindow();
    }else{
      if (_wnd != 0){
        ShowWindow(_wnd,SW_HIDE);
      }
    }
  }else{
    if (_wnd == 0){
      createWindow();
    }

    if (getPixmapStyle() != WS_DIRECT_WINDOW){
      if (bk == False){
        destroyPixmap(); //expose handler ō쐬邽߁AĂ
      }
//TEST//////////////////////////////////////////////////////////////////////
//       //XXXXXXXXXXXXXXXXXXXXXXXXXXXx
//       //قǁApixmap style  static dynamic ̏ꂼsȂ
//        createPixmap();
//TEST//////////////////////////////////////////////////////////////////////
    }
    ShowWindow(_wnd,SW_SHOW);
    SetWindowPos(_wnd,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
    if (bk == False){
      setExposed(False);
      invalidate(False);
    }
  }
  return WS_NO_ERR;
}
void WSDwinformDev::_adjust_cursor(){
  WSCbool gmouse = WSGIappMouse()->getGlobalMouseIdStatus();
  if (gmouse != _global_mouse){
    _global_mouse = gmouse;
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if (_mouse_val == 0){
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if ((long)_mouse_val == -1){
    WSGIwinAppDev()->showCursor(false);
  }else{
    WSGIwinAppDev()->showCursor(true);
    SetCursor(_mouse_val);
  }
}
long WSDwinformDev::dispatchEvent(WinEvent* e){
  if (WSGIappMouse()->getGlobalMouseSensitive() == False){
    _adjust_cursor();
  }
  if (e->message == WM_PAINT){
    _evh_expose(e);
    return 0;
  }else
  if (e->message == WM_MOUSEMOVE){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_mouse_move(e);
    return 0;
  }else
  if (e->message == WM_ERASEBKGND){
//    _clear_and_expose();
    return 0;
  }else
  if (e->message == WM_LBUTTONDOWN){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_press(e,1);
    return 0;
  }else
  if (e->message == WM_MBUTTONDOWN){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_press(e,2);
    return 0;
  }else
  if (e->message == WM_RBUTTONDOWN){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_press(e,3);
    return 0;
  }else
  if (e->message == WM_MOUSEWHEEL && e->uParam == 0xff880000){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_press(e,5);
    return 0;
  }else
  if (e->message == WM_MOUSEWHEEL && e->uParam == 0x780000){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_press(e,4);
    return 0;
  }else
  if (e->message == WM_LBUTTONUP){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_release(e,1);
    return 0;
  }else
  if (e->message == WM_MBUTTONUP){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_release(e,2);
    return 0;
  }else
  if (e->message == WM_RBUTTONUP){
    if (WSGIappMouse()->getGlobalMouseSensitive() == False){
      return 0;
    }
    _evh_btn_release(e,3);
    return 0;
  }else
  if (e->message == WM_MOVE){
    _evh_move(e);
    return 0;
  }else
  if (e->message == WM_SIZE){
    _evh_resize(e);
    return 0;
  }else
#ifdef _WSWINCE
  if (e->message == WM_CANCELMODE){
    WSCbase* ucl = WSGIappMouse()->getMouseUngrabClient();
dbprintf("ucl=0x%x\n",ucl);
    if (ucl != NULL){
      ucl->execEventProc(WSEV_GRAB_CANCELED,NULL);
    }
    return 0;
  }else
#endif
  if (e->message == WM_CLOSE){
    return _evh_delete(e);
  }else
  if (e->message == WM_DESTROY){
    _evh_delete(e);
    return 0;
  }else
  if (e->message == WM_KILLFOCUS){
    WSCbase* fcl = WSCbase::getFocusInstance();
    if (fcl != NULL){
      WSCbase* cl = getAttachedClient();
      WSCbase* pcl = fcl;
      if (cl != NULL){
        WSCbool fl = False;
        while(1){
          if (pcl == NULL){
            break;
          }
          if (cl == pcl){
            fl = True;
            break;
          }
//          pcl = pcl->getParent();
          WSDdev* dev = pcl->getowndev();
          if (dev == NULL){
            pcl = pcl->getParent();
            continue;
          }
          WSDdev* pdev = dev->getParentDev();
          if (pdev == NULL){
            break;
          }
          pcl = pdev->getAttachedClient();
        }
        if (fl != False){
          fcl->onWindowFocusChange(False);
        }
      }
    }

    return 0;
  }else
  if (e->message == WM_SETFOCUS){
    WSCbase* fcl = WSCbase::getFocusInstance();
    if (fcl != NULL){
      WSCbase* cl = getAttachedClient();
      WSCbase* pcl = fcl;
      if (cl != NULL && cl->getVisible() != False){
        if (cl->getObjectType() & WS_TYPE_WINDOW){
extern void _set_active_instance(WSCbase*);
          _set_active_instance(cl);
        }
#if 0
        WSCbase* parent = cl->getParent();
        while(parent != NULL){
          if (parent->getVisible()== False){
            return 0;
          }
          parent = parent->getParent();
        }
#endif
        WSCbool fl = False;
        while(1){
          if (pcl == NULL){
            break;
          }
          if (cl == pcl){
            fl = True;
            break;
          }
//          pcl = pcl->getParent();
          WSDdev* dev = pcl->getowndev();
          if (dev == NULL){
            pcl = pcl->getParent();
            continue;
          }
          WSDdev* pdev = dev->getParentDev();
          if (pdev == NULL){
            break;
          }
          pcl = pdev->getAttachedClient();
        }
        if (fl != False){
//          onFocusChange();
          fcl->onWindowFocusChange(True);
        }else{
//          onFocusChange();
          fcl->setSpecialFocus(False);
          fcl->setFocus(False);
        }
      }else{
        fcl->onWindowFocusChange(True);
      }
    }else{
        onFocusChange();
    }
    return 0;
  }
  return 1;
}
WSCushort WSDwinformDev::getMouseNo(){
  return _mouse_no;
}
void WSDwinformDev::_evh_mouse_in(WinEvent* ev){
  WSCpoint point;
  point.setPoint( LOWORD(ev->lParam), HIWORD(ev->lParam) );
  WSGIwinAppDev()->setMouseFocusDev(this);

  onMouseIn(&point);
#if 0
  WSCbool gmouse = WSGIappMouse()->getGlobalMouseIdStatus();
  if (gmouse != _global_mouse){
    _global_mouse = gmouse;
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if (_mouse_val == 0){
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if ((long)_mouse_val == -1){
    WSGIwinAppDev()->showCursor(false);
  }else{
    WSGIwinAppDev()->showCursor(true);
    SetCursor(_mouse_val);
  }
#endif
  _adjust_cursor();
}

void WSDwinformDev::_evh_mouse_out(WinEvent* ev){
  WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
  if (mdev == NULL){
    onMouseOut();
  }else if (mdev == this){
    WSGIwinAppDev()->setMouseFocusDev(NULL);
    onMouseOut();
  }
}
void WSDwinformDev::_evh_mouse_move(WinEvent* ev){
  WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
#if 0
  WSCbool gmouse = WSGIappMouse()->getGlobalMouseIdStatus();
  if (gmouse != _global_mouse){
    _global_mouse = gmouse;
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if (_mouse_val == 0){
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if ((long)_mouse_val == -1){
    WSGIwinAppDev()->showCursor(false);
  }else{
    WSGIwinAppDev()->showCursor(true);
    SetCursor(_mouse_val);
  }
#endif
  _adjust_cursor();

  if (mdev == NULL){
    _evh_mouse_in(ev);
    return;
  }else if (mdev != this){
    mdev->_evh_mouse_out(ev);
    _evh_mouse_in(ev);
    return;
  }

  WSCpoint point;
  point.setPoint( (short)LOWORD(ev->lParam), (short)HIWORD(ev->lParam) );
#ifdef _WSWINCE
  RECT r;
  GetWindowRect(_wnd,&r);
extern int _mouse_pos_x;
extern int _mouse_pos_y;
  _mouse_pos_x = point.x + r.left;
  _mouse_pos_y = point.y + r.top;
#endif

  WSCbool b1 =  (ev->uParam & MK_LBUTTON) != 0 ? True:False;
  WSCbool b2 =  (ev->uParam & MK_MBUTTON) != 0 ? True:False;
  WSCbool b3 =  (ev->uParam & MK_RBUTTON) != 0 ? True:False;

  long state = WSGIappMouse()->getStatus();
  if (b1){
    state |= WS_MOUSE_BTN1;
  }
  if (b2){
    state |= WS_MOUSE_BTN2;
  }
  if (b3){
    state |= WS_MOUSE_BTN3;
  }
  WSGIappMouse()->setStatus(state);
  onMouseMove(&point);
}

void WSDwinformDev::_evh_move(WinEvent* ev){
}

void WSDwinformDev::_evh_resize(WinEvent* ev){

  RECT r;
  GetClientRect(_wnd,&r);
  
  WSCrect area;
  area.setRect(_w_x,_w_y,r.right - r.left ,r.bottom - r.top);

  _w_now = area.width;
  _h_now = area.height;
  _resize_sequence = True;
  onResize(&area);
  _resize_sequence = False;
}

void WSDwinformDev::_evh_expose(WinEvent* ev){
  PAINTSTRUCT ps;
  BeginPaint(_wnd,&ps);

  WSCrect area;
  area.setRect( (short)ps.rcPaint.left, (short)ps.rcPaint.top,
     (WSCushort)ps.rcPaint.right - ps.rcPaint.left,
     (WSCushort)ps.rcPaint.bottom - ps.rcPaint.top);
  setExposed(True);

  if (_exposed == False || getPixmapStyle() == WS_DIRECT_WINDOW){
    _clear_area(area.x, area.y, area.width, area.height);
  }

  onExpose(&area);

  EndPaint(_wnd,&ps);
}

void WSDwinformDev::_evh_btn_press(WinEvent* ev,int no){
  WSCpoint point;
  point.setPoint( LOWORD(ev->lParam),HIWORD(ev->lParam));
#ifdef _WSWINCE
  RECT r;
  GetWindowRect(_wnd,&r);
extern int _mouse_pos_x;
extern int _mouse_pos_y;
  _mouse_pos_x = point.x + r.left;
  _mouse_pos_y = point.y + r.top;
#endif
  long clk = WSGFclocktime();
  WSCbool dclicked = False;
  if ((WSCulong)clk - (WSCulong)_click_time<250){
    dclicked = True;
  }
  _click_time = clk;
//  if (WSGIwinAppDev()->_grabed == False){
  {
    long state = WSGIappMouse()->getStatus();
    if (no == 4){
      WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN4);
      WSCbase* fcl = WSGIappMouse()->getMouseFocusClient();
      if (fcl != NULL){
        state |= WS_MOUSE_BTN4;
        WSGIappMouse()->setStatus(state);
        fcl->onMousePress(&point);
        WSGIappObjectList()->execInitialize();
        WSGIappObjectList()->execUpdate();
        state &= ~WS_MOUSE_BTN4;
        WSGIappMouse()->setStatus(state);
        fcl->onMouseRelease(&point);
      }
      return;
    }else
    if (no == 5){
      WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN5);
      WSCbase* fcl = WSGIappMouse()->getMouseFocusClient();
      if (fcl != NULL){
        state |= WS_MOUSE_BTN5;
        WSGIappMouse()->setStatus(state);
        fcl->onMousePress(&point);
        WSGIappObjectList()->execInitialize();
        WSGIappObjectList()->execUpdate();
        state &= ~WS_MOUSE_BTN5;
        WSGIappMouse()->setStatus(state);
        fcl->onMouseRelease(&point);
      }
      return;
    }
    WSGIwinAppDev()->setGrabedWnd(_wnd);
  }
 // }
  if (no == 4 || no == 5){
    return;
  }
  long state = WSGIappMouse()->getStatus();
  if (no == 1){
    state |= WS_MOUSE_BTN1;
    WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN1);
  }else
  if (no == 2){
    state |= WS_MOUSE_BTN2;
    WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN2);
  }else
  if (no == 3){
    state |= WS_MOUSE_BTN3;
    WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN3);
  }
  WSGIappMouse()->setStatus(state);

  onMousePress(&point);
  if (dclicked != False){
    onMouseDoubleClick(&point);
  }
#if 0
  WSCbool gmouse = WSGIappMouse()->getGlobalMouseIdStatus();
  if (gmouse != _global_mouse){
    _global_mouse = gmouse;
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if (_mouse_val == 0){
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if ((long)_mouse_val == -1){
    WSGIwinAppDev()->showCursor(false);
  }else{
    WSGIwinAppDev()->showCursor(true);
    SetCursor(_mouse_val);
  }
#endif
  _adjust_cursor();
}

void WSDwinformDev::_evh_btn_release(WinEvent* ev,int no){
  WSCpoint point;
  point.setPoint( LOWORD(ev->lParam),HIWORD(ev->lParam) );
#ifdef _WSWINCE
  RECT r;
  GetWindowRect(_wnd,&r);
extern int _mouse_pos_x;
extern int _mouse_pos_y;
  _mouse_pos_x = point.x + r.left;
  _mouse_pos_y = point.y + r.top;
#endif

  long state = WSGIappMouse()->getStatus();
  if (no == 1){
    state &= ~WS_MOUSE_BTN1;
    WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN1);
  }else
  if (no == 2){
    state &= ~WS_MOUSE_BTN2;
    WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN2);
  }else
  if (no == 3){
    state &= ~WS_MOUSE_BTN3;
    WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN3);
  }
  WSGIappMouse()->setStatus(state);

  if (WSGIwinAppDev()->_grabed == False && state == 0){
    WSGIwinAppDev()->setGrabedWnd(NULL);
  }
  WSDwinDragDrop* xdd = WSGIwinAppDragDrop();
  if (xdd != NULL){
    if (xdd->getDragState() != 0){
      xdd->executeDrop();
      return;
    }
  }

  onMouseRelease(&point);
#if 0
  WSCbool gmouse = WSGIappMouse()->getGlobalMouseIdStatus();
  if (gmouse != _global_mouse){
    _global_mouse = gmouse;
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if (_mouse_val == 0){
    _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(_mouse_no);
  }
  if ((long)_mouse_val == -1){
    WSGIwinAppDev()->showCursor(false);
  }else{
    WSGIwinAppDev()->showCursor(true);
    SetCursor(_mouse_val);
  }
#endif
  _adjust_cursor();
}


void WSDwinformDev::_evh_dummy(WinEvent*){
}

long WSDwinformDev::_evh_delete(WinEvent* ev){
dbprintf("WSDwinformDev::_evh_delete %s:%d start\n",__FILE__,__LINE__);
  _pwnd = 0;
  _wnd = 0;
  setInitialized(False);
dbprintf("WSDwinformDev::_evh_delete %s:%d done\n",__FILE__,__LINE__);
  return 0;
}


void WSDwinformDev::_evh_delete2(void* ptr){
dbprintf("WSDwinformDev::_evh_delete2 %s:%d start\n",__FILE__,__LINE__);
   WSDwinformDev* dev = (WSDwinformDev*)ptr;

   dev->_pwnd = 0;
   dev->_wnd = 0;
   dev->setInitialized(False);
//   dev->detachClient();
dbprintf("WSDwinformDev::_evh_delete2 %s:%d done\n",__FILE__,__LINE__);
}

void WSDwinformDev::setHWND(HWND w){
  _wnd = w;
}
long WSDwinformDev::beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,WSCbool scaling){
  if ((short)w < 1){
    return WS_ERR;
  }
  if ((short)h < 1){
    return WS_ERR;
  }
  if (_exposed == False){
    return WS_ERR;
  }
  if (w == 23767){
    return WS_ERR;
  }
  if (h == 23767){
    return WS_ERR;
  }
  if (_wnd == 0){
    return WS_ERR;
  }

  if (getPixmapStyle() != WS_DIRECT_WINDOW){
    long ret = WS_NO_ERR;
    if (_mdc == 0){
      ret = createPixmap();
    }
    if (ret != WS_NO_ERR){
      setPixmapStyle(WS_DIRECT_WINDOW);
      _dc = GetDC(_wnd);
//WSMFtrace("WSDwinformDev::beginDraw this=0x%x  error _dc=0x%x XXabc1\n",this,_dc);
    }
  }else{
    _dc = GetDC(_wnd);
  }
  return WSDwindowDev::beginDraw(x,y,w,h,absolute,scaling);
}
long WSDwinformDev::endDraw(){
  WSDwindowDev::endDraw();
  if (_dc != 0){
    ReleaseDC(_wnd,_dc);
    _dc = 0;
  }
  return WS_OK;
}
void WSDwinformDev::invalidate(WSCbool fl){
  if (_wnd == 0){
    return;
  }
  RECT r;
  GetClientRect(_wnd,&r);
  InvalidateRect(_wnd,&r,fl);
  setExposed(False);
  return;
}
void WSDwinformDev::_clear_and_expose(){
  WSCrect r;
  r.setRect(0,0,_w_w,_w_h);
  _clear_area(0,0,_w_w,_w_h);
  setExposed(True);
  onExpose(&r);
}
long WSDwinformDev::raise(){
  if (_wnd == 0){
    return WS_ERR;
  }
  SetWindowPos(_wnd,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
  return WS_NO_ERR;
}
long WSDwinformDev::lower(){
  if (_wnd == 0){
    return WS_ERR;
  }
  SetWindowPos(_wnd,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
  return WS_NO_ERR;
}
void WSDwinformDev::restackChildren(){
  if (getAttachedClient() == NULL){
    return;
  }
  WSClistData children = getAttachedClient()->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    WSDdev* dev = child->getowndev();
    if (dev == NULL){
      continue;
    }
    WSDwinformDev* wdev = (WSDwinformDev*)dev->cast("WSDwinformDev");
    if (wdev == NULL){
      continue;
    }
    wdev->raise();
  }
}
void WSDwinformDev::_expose_children(int x,int y,unsigned long w,unsigned long h){
  WSCbase* client = getAttachedClient();
  if (client == NULL){
    return;
  }

  WSClistData list = client->getChildren();
  long i;
  long num = list.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)list[i];
    if (child->getVisible() == False){
      continue;
    }
    WSDdev* dev = child->getdev();
    if (dev == NULL){
      continue;
    }
    WSDwinformDev* wdev =(WSDwinformDev*)dev->cast("WSDwinformDev");
    if (wdev == NULL){
      continue;
    }
    long ex,ey;
    unsigned long ew,eh;
    short dx,dy;
    unsigned short dw,dh;
    wdev->getWindowSize(&dx,&dy,&dw,&dh);
    WSGFandArea(0,0,w,h,dx,dy,dw,dh,
                &ex,&ey,&ew,&eh);
    if (ew != 0 && eh != 0){
      wdev->exposeArea(ex-dx,ey-dy,ew,eh);
      wdev->_expose_children(ex-dx,ey-dy,ew,eh);
    }
  }
}
