//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <win/WSDwinappDev.h>
#include <win/WSDwintimer.h>
#include <win/WSDwinformDev.h>

WSMFclassInit(WSDwintimer,WSDtimer);

//250 ms 
#define _WS_INTERVAL_     250

WSDtimer* _wintimer_create_handler(){
  return new WSDwintimer();
}

#ifndef NO_GLOBAL_CONSTRUCTORS
class _wintimer_init{
  public: _wintimer_init(){
    WSDtimer::setCreateInstanceHandler(_wintimer_create_handler);
  };
};

_wintimer_init _wintimer_init_run_constructor;
#endif

WSDwintimer::WSDwintimer(){
  _timer_set();
}
WSDwintimer::~WSDwintimer(){
  _timer_stop();
}


void WSDwintimer::_timer_set(){
  HWND wnd = WSGIwinAppDev()->getHWND();
  UINT ret = SetTimer(wnd, 1,_WS_INTERVAL_,_timer_callback);
  if (ret == 0){
WSMFtrace("WSDwintimer::_timer_set() timer error...\n");
  }
}
void WSDwintimer::_timer_stop(){
  HWND wnd = WSGIwinAppDev()->getHWND();
  KillTimer(wnd, 1);
}
void CALLBACK WSDwintimer::_timer_callback(HWND,UINT,UINT,DWORD){
    WSDtimer* ptr = WSGIappTimer();
    WSDwintimer* obj = (WSDwintimer*)ptr->cast("WSDwintimer");
    obj->_clock++;
    long i;
    long num = obj->_cproc_list.getNum();
#ifndef _WSWINCE
    WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
    if (mdev != NULL){
      POINT p;
      GetCursorPos(&p);
      DWORD lParam = p.y;
      lParam <<= 16;
      lParam |= (DWORD)p.x;
      HWND wnd = mdev->getHWND();
      if (wnd != 0){
        LRESULT result = DefWindowProc(wnd,WM_NCHITTEST,0,lParam);
        if (result == HTNOWHERE){
          WSGIwinAppDev()->setMouseFocusDev(NULL);
          mdev->onMouseOut();
        }
      }
    }
#endif
//printf("WSDwintimer::_timer_callback timer procs=%d WSCfform\n",num);
    //^C}[vZX̋N
    for(i = 0; i < num; i++){
      timerProcRec* proc = (timerProcRec*)obj->_cproc_list.getData(i);
//WSMFtrace("WSDwintimer::_timer_callback clock=%d  proc rate=%d  tm=%d\n",obj->_clock,proc->rate,proc->fclock);
      if ( ( obj->_clock % proc->rate) == proc->fclock ){
//WSMFtrace("WSDwintimer::_timer_callback exec procs=0x%x\n",proc);
        proc->proc(obj->_clock,proc->data);
      }
    }

    num = obj->_proc_list.getNum();
//printf("WSDwintimer::_timer_callback timer tprocs=%d WSCfform\n",num);
    for(i = 0; i < num; i++){
      triggerProcRec* proc = (triggerProcRec*)obj->_proc_list.getData(i);
      if (( obj->_clock % proc->rate) == proc->fclock ){
        obj->_proc_list.del(proc); 
        num = obj->_proc_list.getNum();
        i--;

        proc->proc(obj->_clock,proc->data);
        proc->executed = False;
        delete proc;
      }
    }
    obj->_timer_set();
    return;
}
