//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <windows.h>
#include <win/WSwincom.h>
#include <win/WSDwinwinDev.h>
#include <win/WSDwinAppDev.h>
#include <WSCdevice.h>
//#include <WSDwindraw.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSDtimer.h>
#include <WSCbase.h>
#include <WSDmouse.h>
#include <WSClocaleSet.h>
#include <WSCbaseList.h>
#define DEBUG

#ifdef _WSWINCE
#define strdup _strdup
#endif
WSMFclassInit(WSDwinwinDev,WSDwinformDev);
WSDdev* _wsdwinwindev_init_(){
  return new WSDwinwinDev();
}

#ifndef NO_GLOBAL_CONSTRUCTORS
class _WSDwinwinDev_init_ {
  public:_WSDwinwinDev_init_(){
     WSGIappDevice()->setCreateHandler("windowDev",_wsdwinwindev_init_);
  };
};
static _WSDwinwinDev_init_ _init_to_run_WSDwinwinDev_;
#endif
//static Atom wm_protocols = 0;
//static Atom wm_delete = 0;

WSDwinwinDev::WSDwinwinDev(){
dbprintf("WSDwinwinDev::WSDwinwinDev %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
#ifndef NO_MWT_FUNCTION
  _rebase_handle  = 0;
#endif
//  _shell  = 0;
#ifndef _WSWINCE
  _style = WS_OVERLAPPEDWINDOW;
#else
  _style = 0;
#endif
//  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
  _style_ex = 0;
  _resize_sequence = False;
  _shell  = 0;
  _wnd  = 0;
  _title_bar_style = WS_FULL_TITLE;
  _no_frame = 0;
  _no_frame_first_time = 0;
  _requested_top = 0;
  _popup_parent = False;
  _float_on_top = 0;
  _modal = 0;
  _diff_w = -1;
  _diff_h = -1;
  _x_now = -1;
  _y_now = -1;
  _destroyed_by_method = 0;
  _title_string = 0;
dbprintf("WSDwinwinDev::WSDwinwinDev %s:%d done this=0x%x\n",__FILE__,__LINE__,this);
}

WSDwinwinDev::~WSDwinwinDev(){
dbprintf("WSDwinwinDev::~WSDwinwinDev %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
  if ( _title_string != NULL){
    delete _title_string;
    _title_string = 0;
  }
  destroyWindow();
dbprintf("WSDwinwinDev::~WSDwinwinDev %s:%d done this=0x%x\n",__FILE__,__LINE__,this);
}

WSDdev* WSDwinwinDev::getVisibleParentDev(){
  return this;
}

long WSDwinwinDev::setValue(long kind,void* data){
  WSDwindowDev::setValue(kind,data);

  char val;
//  long vl;
  WSDcolor* color;
  WSDimage* image;
  RECT p;
  WSCstring tmpstr;
  long diff_w = _diff_w;
  long diff_h = _diff_h;
  if (diff_w < 0){
    diff_w = 0;
  }
  if (diff_h < 0){
    diff_h = 0;
  }
  switch(kind){
    case WSDEV_X: 
             if (_wnd != 0){
               if (getVisible() != False){
                 GetWindowRect(_wnd,&p);
                 p.left = *(short*)data;
                 if (_resize_sequence != False && *(short*)data == _x_now){
                   break;
                 }
#ifndef NO_MWT_FUNCTION
                 if (_rebase_handle != 0){
                   break;
                 }
#endif
                 SetWindowPos(_shell,NULL,p.left - _diff_x,p.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
               }
             }
             break;
    case WSDEV_Y:
             if (_wnd != 0){
               if (getVisible() != False){
                 GetWindowRect(_wnd,&p);
                 p.top = *(short*)data;
                 if (_resize_sequence != False && *(short*)data == _y_now){
                   break;
                 }
#ifndef NO_MWT_FUNCTION
                 if (_rebase_handle != 0){
                   break;
                 }
#endif
                 SetWindowPos(_shell,NULL,p.left,p.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
               }
             }
             break;
    case WSDEV_WIDTH:
             if (_wnd != 0){
               if (getVisible() != False && *(WSCushort*)data > 0){
                 GetClientRect(_wnd,&p);
                 p.right = p.left + *(short*)data;
                 MoveWindow(_wnd,0,0,
                            p.right  - p.left,
                            _w_h, True);
                 if (_resize_sequence != False && *(short*)data == _w_now){
                   break;
                 }
                 MoveWindow(_shell,_w_x,_w_y,
                            _w_w + diff_w,
                            _w_h + diff_h, True);
               }
             }
             break;
    case WSDEV_HEIGHT:
             if (_wnd != 0){
               if (getVisible() != False && *(WSCushort*)data > 0){
                 GetClientRect(_wnd,&p);
                 p.bottom = p.top + *(short*)data;
                 MoveWindow(_wnd,0,0,
                            _w_w,
                            _w_h, True);
                 if (_resize_sequence != False && *(short*)data == _h_now){
                   break;
                 }
                 MoveWindow(_shell,_w_x,_w_y,
                            _w_w + diff_w,
                            _w_h + diff_h, True);
               }
             }
             break;
    case WSDEV_BACKCOLOR:
             _back_cno = *(short*)data;
             color = WSGIappColorSet()->getColor(*(short*)data);
             if (color != NULL){
               _bg_cref = (COLORREF)color->getValue1();
             }
             if ( _wnd != (HWND)0){
               setExposed(False);
               invalidate(TRUE);
             }
             break;
    case WSDEV_BACK_PIXMAP:
             _back_pixno = *(short*)data;
             if (*(short*)data == -1 ){
               _bg_image = 0;
             }else{
               image = WSGIappImageSet()->getImage(*(short*)data);
               if (image != NULL){
                 if (image->getValue1() == -1){
                   _bg_image = 0;
                 }else{
                   _bg_image = (HBITMAP)image->getValue1();
                 }
               }
             }
             if (_wnd != 0){
               setExposed(False);
               invalidate(TRUE);
             }
             break;
    case WSDEV_TITLE_BAR:
dbprintf("WSDwinwinDev::setValue WSDEV_TITLE_BAR %s:%d start _wnd=0x%x\n",__FILE__,__LINE__,_wnd);
             _diff_x = -1;
             _diff_y = -1;
             val = _title_bar_style;
             if (*(char*)data < 0 || *(char*)data > 4){
               _title_bar_style = 0;
             }else{
               _title_bar_style = *(char*)data;
             }
             if (_title_bar_style == WS_NO_TITLE){ 
                  _style = WS_POPUP;
                  _style_ex = 0;
             }else
             if (_title_bar_style == WS_FULL_TITLE){ 
#ifndef _WSWINCE
                  _style = WS_OVERLAPPEDWINDOW;
#else
                  _style = 0;
#endif
                  _style_ex = 0;
             }else
             if (_title_bar_style == WS_ONLY_TITLE){ 
                  _style = WS_CAPTION | WS_BORDER;
                  _style_ex = 0;
             }else
             if (_title_bar_style == WS_MINI_BTN){ 
                  _style = WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_MINIMIZEBOX;
                  _style_ex = 0;
             }else
             if (_title_bar_style == WS_MAX_BTN){ 
                  _style = WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_MAXIMIZEBOX;
                  _style_ex = 0;
             }else
             if (_title_bar_style == WS_FRAME){ 
                  _style = WS_THICKFRAME;
                  _style_ex = 0;
             }else
             if (_title_bar_style == WS_NO_MANAGE){ 
                  _style = WS_POPUP;
                  _style_ex = 0;
             }
#if 1
//           if (_shell!= 0 && _title_bar_style != val){
//                 destroyWindow();
//           }
             if (_shell!= 0 && WSGIwinAppDev()->getContext2() == 0){
                 destroyWindow();
             }
             if (getVisible()== True){
               setVisible(False);
               setVisible(True);
             }
#endif

             break;
    case WSDEV_TITLE_STRING:
             if (_title_string != NULL){
               delete _title_string;
             }
             tmpstr.setString((char*)data,WSGIappLocaleSet()->getDefaultEncoding());
             _title_string = strdup(
               tmpstr.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
             if (_shell != (HWND)NULL){
#ifndef _WSWINCE
               SetWindowText(_shell,_title_string);
#else
               WSCushort* tmpstr = WSGFgetUCS2(_title_string,WS_EN_DEFAULT);
               SetWindowText(_shell,tmpstr);
               delete tmpstr;
#endif
             }
             break;
    case WSDEV_NO_FRAME:  
             _no_frame = *(char*)data;
             _diff_w = -1;
             _diff_h = -1;
             if (_no_frame != False){
               _diff_w = 0;
               _diff_h = 0;
               _style = 0;
               _style_ex = WS_EX_TOPMOST;
               if ( _shell != 0){
                 destroyWindow();
               }
             }
             break;
    case WSDEV_POPUP_PARENT: 
//WSMFtrace("WSDwinwinDev::setValue WSDEV_POPUP_PARENT is not implemented...\n");
             break;
    case WSDEV_MAP_STATUS: 
             if (getVisible()== True){
                if (*(long*)data == WS_TOP){
                  SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
                }else{
                  SetWindowPos(_shell,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
                }
             }
             break;
    case WSDEV_WIN_ACTIVE: 
             if (getVisible()== True){
                if (*(char*)data == True){
                  SetActiveWindow(_shell);
                }
             }
             break;
    case WSDEV_FLOAT_ON_TOP:
             if (*(char*)data == False){
                _float_on_top = False;
             }else{
                _float_on_top = True;
             }
             if (_wnd == NULL){
               break;
             }
             if (_float_on_top == True){
                SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }else{
                SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }
             break;
    case WSDEV_GRAB_POINTER:
             if (_wnd == NULL){
               break;
             }
             WSGIwinAppDev()->_grabed = *(WSCbool*)data;
             if (WSGIwinAppDev()->_grabed != False){
               WSGIwinAppDev()->setGrabedWnd(_wnd);
               WSGIappMouse()->setMouseFocusClient(NULL);
             }else{
               int state = WSGIappMouse()->getStatus();
               if (state > 0){
                 break;
               }
               WSGIwinAppDev()->setGrabedWnd(NULL);
             }
             break;
    case WSDEV_MODAL:
             if (*(char*)data == False){
               _modal = False;
             }else{
               _modal = True;
             }
             if (_wnd == NULL){
               break;
             }
             if (_modal == True){
                SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }else{
                SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }
             break;
    case WSDEV_MOUSE_NO:
             _mouse_no = *(WSCushort*)data;
             _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(*(WSCushort*)data);
             break;
    case WSDEV_WINDOW_STATE:
             if (getVisible() == False){
               return WS_ERR;
             }
             if (*(long*)data == WS_WINDOW_NORMAL){
               ShowWindow(_shell,SW_SHOWNORMAL);
             }else
             if (*(long*)data == WS_WINDOW_MINIMIZE){
#ifndef _WSWINCE
               ShowWindow(_shell,SW_SHOWMINIMIZED);
#endif
             }else
             if (*(long*)data == WS_WINDOW_MAXIMIZE){
               ShowWindow(_shell,SW_SHOWMAXIMIZED);
             }
             break;
    default:
      return WS_ERR;
  }
  return WS_NO_ERR;
}
long WSDwinwinDev::getValue(long kind,void* val){
  switch(kind){
    case WSDEV_WINDOW_STATE:
      if (getVisible() == False){
        *(long*)val = WS_WINDOW_NORMAL;
        return WS_NO_ERR;
      }
      if (_shell == 0){
        return WS_ERR;
      }
#ifndef _WSWINCE
      if (IsIconic(_shell)){
        *(long*)val = WS_WINDOW_MINIMIZE;
        return WS_NO_ERR;
      }
      if (IsZoomed(_shell)){
        *(long*)val = WS_WINDOW_MAXIMIZE;
        return WS_NO_ERR;
      }
#endif
      *(long*)val = WS_WINDOW_NORMAL;
      return WS_NO_ERR;
    case WSDEV_TITLE_HEIGHT:
      *(WSCushort*)val = _diff_y;
      return WS_NO_ERR;
  }
  return WSDwindowDev::getValue(kind,val);
}
long WSDwinwinDev::createWindow(){
dbprintf("WSDwinwinDev::createWindow %s:%d start _wnd=0x%x\n",__FILE__,__LINE__,_wnd);
  _destroyed_by_method = 0;
  if (_wnd != 0){
dbprintf("WSDwinwinDev::createWindow %s:%d done1\n",__FILE__,__LINE__);
    return WS_NO_ERR;
  }
  _no_frame_first_time = 0;

  short x,y;    
  WSCushort w,h;    
  getWindowSize(&x,&y,&w,&h);
  if (w == 0){
    w = 1;
  }
  if (h == 0){
    h = 1;
  }
  _popup_parent = False;
extern char szAppName[];
  HWND alt_hwnd = (HWND)WSGIwinAppDev()->getContext2();
dbprintf("WSDwinwinDev::createWindow %s:%d alt=0x%x\n",__FILE__,__LINE__,alt_hwnd);

#ifdef _WSWINCE
  WSCushort* tmpstr = WSGFgetUCS2(szAppName,WS_EN_DEFAULT);
  WSCushort tmpstr2[1]; tmpstr2[0] = 0;
#endif

  if (alt_hwnd == 0){
#ifndef NO_MWT_FUNCTION
    void(*create_handler)(WSCbase*) =
      (void(*)(WSCbase*))WSGIappObjectList()->getInternalWindowCreateHandler();
    if (create_handler != NULL){
      create_handler(getAttachedClient());
    }
    if (WSGIappDev()->getRebaseHandle() != 0){
      _rebase_handle = (HWND)WSGIappDev()->getRebaseHandle();
      WSGIappDev()->setRebaseHandle(0);
//      _style_ex = 0;
//      _style = WS_OVERLAPPEDWINDOW;
    }
#endif
  if (_no_frame ){
      HWND pw = WSGIwinAppDev()->getHWND();
#ifndef _WSWINCE
#ifndef NO_MWT_FUNCTION
      if (_rebase_handle != 0){
        pw = _rebase_handle;
        _shell = WSGFcreateWindow(szAppName,"",
             _style | WS_CHILD | WS_CLIPSIBLINGS | WS_POPUP | WS_CLIPCHILDREN, 0,0,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
      }else{
        _shell = WSGFcreateWindowEx( _style_ex,szAppName,"",
             _style | WS_CLIPSIBLINGS | WS_POPUP | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
      }
#else
      _shell = WSGFcreateWindowEx( _style_ex,szAppName,"",
             _style | WS_CLIPSIBLINGS | WS_POPUP | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif
#else
      _shell = CreateWindowEx( _style_ex,tmpstr,tmpstr2,
             _style | WS_CLIPSIBLINGS | WS_POPUP | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif
      SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
    }else{
      HWND pw = NULL;
      WSCbase* client = getAttachedClient();
      WSDdev* pdev = NULL;
      if (client != NULL && client->getParent() != NULL){
        pdev = client->getParent()->getowndev();
      }
      if (pdev != NULL){
        pw = (HWND)pdev->getWindowResource();
      }
#ifndef _WSWINCE
#ifndef NO_MWT_FUNCTION
//printf("WSDwinwinDev::createWindow _rebase_handle=0x%x %d\n",_rebase_handle,_rebase_handle);fflush(stdout);
      if (_rebase_handle != 0){
        _shell = WSGFcreateWindow(szAppName,"", WS_CHILD | WS_OVERLAPPED | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, 0,0,w,h,_rebase_handle,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
        _diff_x = 0;
        _diff_y = 0;
        _diff_w = 0;
        _diff_h = 0;
      }else{
        _shell = WSGFcreateWindowEx( _style_ex,szAppName,"", _style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
        SetWindowLong(_shell,GWL_STYLE,_style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN);
      }
#else
      _shell = WSGFcreateWindowEx( _style_ex,szAppName,"", _style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
      SetWindowLong(_shell,GWL_STYLE,_style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN);
#endif
#else
      _shell = CreateWindowEx( _style_ex,tmpstr,tmpstr2, WS_CLIPSIBLINGS | WS_CLIPCHILDREN, x,y,w,h,NULL,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif


    }
#ifndef _WSWINCE
    _wnd = WSGFcreateWindow(szAppName,"",WS_OVERLAPPED | WS_CLIPCHILDREN | WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#else
    _wnd = CreateWindow(tmpstr,tmpstr2, WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif
  }else{
    _shell = alt_hwnd;
#ifndef _WSWINCE
    _wnd = WSGFcreateWindow(szAppName,"",WS_CLIPCHILDREN | WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#else
    _wnd = CreateWindow(tmpstr,tmpstr2, WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif

  }

#ifdef _WSWINCE
  delete tmpstr;
#endif

  if (_title_string != NULL){
#ifndef _WSWINCE
    SetWindowText(_shell,_title_string);
#else
    WSCushort* tmpstr = WSGFgetUCS2(_title_string,WS_EN_DEFAULT);
    SetWindowText(_shell,tmpstr);
    delete tmpstr;
#endif
  }

  if (WSGIwinAppDev()->getWndProc() != NULL){
    if (alt_hwnd == NULL){
      SetWindowLong(_shell,GWL_WNDPROC,(LONG)WSGIwinAppDev()->getWndProc());
    }
    SetWindowLong(_wnd,GWL_WNDPROC,(LONG)WSGIwinAppDev()->getWndProc());
  }
#ifdef DEBUG
WSMFtrace("WSDwinwinDev::createWindow() add callbacks is not implemented..\n");
#endif
  WSDwinformDev* ptr = this;
#ifndef _WSWINCE
  SetProp(_wnd,"frm",(HANDLE)ptr);
  SetProp(_shell,"frm",(HANDLE)ptr);
#else
  unsigned short str1[4];
  str1[0] = 'f';
  str1[1] = 'r';
  str1[2] = 'm';
  str1[3] = 0;
  SetProp(_wnd,str1,(HANDLE)ptr);
  SetProp(_shell,str1,(HANDLE)ptr);
#endif

dbprintf("WSDwinwinDev::createWindow %s:%d done shell=0x%x wnd=0x%x\n",__FILE__,__LINE__,_shell,_wnd);
  return WS_NO_ERR;
}

long WSDwinwinDev::destroyWindow(){
dbprintf("WSDwinwinDev::destroyWindow() %s:%d start wnd=0x%x,shell=0x%x\n",__FILE__,__LINE__,_wnd,_shell);
  _destroyed_by_method = 1;
  _diff_x = -1;
  _diff_y = -1;
  _diff_w = -1;
  _diff_h = -1;
  destroyPixmap();
  WSCbool destroy = False;
  HWND wnd = _wnd;
  HWND shell = _shell;
  if (wnd != 0){
    MSG msg;
    long limit = 100;
    while(PeekMessage(&msg,wnd,0,0,PM_REMOVE)){
      limit--;
      if (limit < 0){
        break;
      }
      if (msg.message == WM_PAINT){
          PAINTSTRUCT ps;
          BeginPaint(wnd,&ps);
          EndPaint(wnd,&ps);
      }
    }
    destroy = True;
    WSGFdestroyWindow(wnd);
#ifndef _WSWINCE
    SetProp(wnd,"frm",(HANDLE)0);
#else
    unsigned short str1[4];
    str1[0] = 'f';
    str1[1] = 'r';
    str1[2] = 'm';
    str1[3] = 0;
    SetProp(wnd,str1,(HANDLE)0);
#endif
    _wnd =0;
  }
  if (shell != 0){
    MSG msg;
    long limit = 100;
    while(PeekMessage(&msg,shell,0,0,PM_REMOVE)){
      limit--;
      if (limit < 0){
        break;
      }
      if (msg.message == WM_PAINT){
          PAINTSTRUCT ps;
          BeginPaint(shell,&ps);
          EndPaint(shell,&ps);
      }
    }
    WSGFdestroyWindow(shell);
#ifndef _WSWINCE
    SetProp(shell,"frm",(HANDLE)0);
#else
    unsigned short str1[4];
    str1[0] = 'f';
    str1[1] = 'r';
    str1[2] = 'm';
    str1[3] = 0;
    SetProp(shell,str1,(HANDLE)0);
#endif
    _shell =0;
  }
  setExposed(False);
  _pwnd = 0;

  setInitialized(False);
//  destroyAllDependChildren();
//  WSGIwinAppDev()->dispatchEvent();
dbprintf("WSDwinwinDev::destroyWindow() %s:%d done wnd=0x%x,shell=0x%x\n",__FILE__,__LINE__,_wnd,_shell);
#ifndef NO_MWT_FUNCTION
  if (destroy != False){
    void(*destroy_handler)(WSCbase*) =
      (void(*)(WSCbase*))WSGIappObjectList()->getInternalWindowDestroyHandler();
    if (destroy_handler != NULL){
      WSCbase* target = getAttachedClient();
      if (target != NULL){
        destroy_handler(target);
      }
    }
  }
#endif
  return WS_NO_ERR;
}

long WSDwinwinDev::setVisible(WSCbool fl){
dbprintf("WSDwinwinDev::setVisible %s:%d start fl=%d this=0x%x\n",__FILE__,__LINE__,fl,this);
  WSCbool bk = getVisible();
  WSDdev::setVisible(fl);
  if (fl == False){
    WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
    if (mdev == this){
      WSGIwinAppDev()->setMouseFocusDev(NULL);
    }
    if (_wnd != 0){
      if (_modal != False){
        WSCbase* client = getAttachedClient();
        WSDdev* pdev = NULL;
        if (client != NULL && client->getParent() != NULL){
          pdev = client->getParent()->getowndev();
        }
        if (pdev != NULL){
          HWND parent = (HWND)pdev->getWindowResource();
          if (parent != NULL){
            while(1){
              HWND p = GetParent(parent);
              if (p == NULL){
                break;
              }
              parent = p;
            }
            EnableWindow(parent,True);
          }
        }
      }
      if (_no_frame != 0){
        destroyWindow();
      }else{
#ifndef _WSWINCE
        HWND pw = NULL;
        if (getAttachedClient() != NULL){
          WSCbase* client = getAttachedClient()->getParent();
          while(client != NULL){
            WSDdev* pdev = NULL;
            if (client->getObjectType() & WS_TYPE_WINDOW){
              if (client->getVisible() != False){
                pdev = client->getowndev();
              }
            }
            if (pdev != NULL){
              WSCbool fl = True;
              pdev->setValue(WSDEV_WIN_ACTIVE,&fl);
              break;
            }else{
              client = client->getParent();
            }
          }
        }
#endif
        ShowWindow(_shell,SW_HIDE);
        ShowWindow(_wnd,SW_HIDE);
      }
    }
#ifndef NO_MWT_FUNCTION
    void(*unvis_handler)(WSCbase*) =
      (void(*)(WSCbase*))WSGIappObjectList()->getInternalWindowUnvisibleHandler();
    if (unvis_handler != NULL){
      unvis_handler(getAttachedClient());
    }
#endif
  }else{
    if (_wnd == 0){
       createWindow();
    }
#ifndef NO_MWT_FUNCTION
    void(*vis_handler)(WSCbase*) =
      (void(*)(WSCbase*))WSGIappObjectList()->getInternalWindowVisibleHandler();
    if (vis_handler != NULL){
      vis_handler(getAttachedClient());
    }
#endif

    if (getPixmapStyle() != WS_DIRECT_WINDOW){
      if (bk == False){
        destroyPixmap(); //expose handler
      }
    }

    short x,y;    
    WSCushort w,h;    
    getWindowSize(&x,&y,&w,&h);
    if (w == 0){
      w = 1;
    }
    if (h == 0){
      h = 1;
    }
    if (_diff_w == -1){
      RECT r1;
      RECT r2;
      r1.left = _w_x;
      r2.left = _w_x;
      r1.right = _w_x + _w_w;
      r2.right = _w_x + _w_w;
      r1.top = _w_y;
      r2.top = _w_y;
      r1.bottom = _w_y + _w_h;
      r2.bottom = _w_y + _w_h;
      if (_no_frame == False){
#ifndef NO_MWT_FUNCTION
        if (_rebase_handle == 0){
          AdjustWindowRectEx(&r1,_style,FALSE,_style_ex);
        }
#else
        AdjustWindowRectEx(&r1,_style,FALSE,_style_ex);
#endif
      }
      _diff_x = r2.left - r1.left;
      _diff_y = r2.top - r1.top;
      _diff_w = r1.right - r1.left - (r2.right - r2.left);
      _diff_h = r1.bottom - r1.top - (r2.bottom - r2.top);
    }
#ifndef NO_MWT_FUNCTION
    if (_rebase_handle != 0){
      MoveWindow(_shell,0,0, w + _diff_w ,h + _diff_h,False);
    }else{
      MoveWindow(_shell,x,y, w + _diff_w ,h + _diff_h,False);
    }
#else
    MoveWindow(_shell,x,y, w + _diff_w ,h + _diff_h,False);
#endif
    MoveWindow(_wnd,0,0, w,h,False);
#ifndef WS_NWIN
    if (_no_frame != False){
      ShowWindow(_wnd,SW_SHOWNOACTIVATE);
      ShowWindow(_shell,SW_SHOWNOACTIVATE);
    }else{
#ifndef _WSWINCE
      ShowWindow(_wnd,SW_SHOW);
      ShowWindow(_shell,SW_SHOW);
      SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
      if (_modal != False){
        WSCbase* client = getAttachedClient();
        WSDdev* pdev = NULL;
        if (client != NULL && client->getParent() != NULL){
          pdev = client->getParent()->getowndev();
        }
        if (pdev != NULL){
          HWND parent = (HWND)pdev->getWindowResource();
          if (parent != NULL){
            while(1){
              HWND p = GetParent(parent);
              if (p == NULL){
                break;
              }
              parent = p;
            }
            EnableWindow(parent,False);
          }
        }
      }
#else
      ShowWindow(_wnd,SW_SHOW);
      ShowWindow(_shell,SW_SHOW);
      SetForegroundWindow(_shell);
      UpdateWindow(_shell);
      UpdateWindow(_wnd);
#endif
    }
#endif
  }
  return WS_NO_ERR;
}

WSDdev* WSDwinwinDev::getParentDev(){
  return NULL;
}
long WSDwinwinDev::dispatchEvent(WinEvent* ev){
  return WSDwinformDev::dispatchEvent(ev);
}
void WSDwinwinDev::_evh_focus_ch(WinEvent* ev){
//WSMFtrace("WSDwinwinDev::_evh_focus_ch() is not implemented.\n");
}

void WSDwinwinDev::_evh_mouse_in(WinEvent* ev){
  WSDwinformDev::_evh_mouse_in(ev);
}

long WSDwinwinDev::_evh_delete(WinEvent* e){
dbprintf("WSDwinwinDev::_evh_delete %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
  if (_modal != False){
    WSCbase* client = getAttachedClient();
    WSDdev* pdev = NULL;
    if (client != NULL && client->getParent() != NULL){
      pdev = client->getParent()->getowndev();
    }
    if (pdev != NULL){
      HWND parent = (HWND)pdev->getWindowResource();
      if (parent != NULL){
        while(1){
          HWND p = GetParent(parent);
          if (p == NULL){
            break;
          }
          parent = p;
        }
        EnableWindow(parent,True);
      }
    }
  }
  if (_destroyed_by_method != False){
dbprintf("WSDwinwinDev::_evh_delete %s:%d done1 this=0x%x\n",__FILE__,__LINE__,this);
    return 0;
  }
  if (e->message == WM_CLOSE){
    if (_wnd != e->hWnd && _shell != e->hWnd){
      return 1;
    }
    WSCbase* client = getAttachedClient();
    if (client != NULL){
      if (WSGFgetWindowEnableClose(client) != False){
#ifndef _WSWINCE
        HWND pw = NULL;
        WSCbase* client2 = client->getParent();
        while(client2 != NULL){
          WSDdev* pdev = NULL;
          if (client2->getObjectType() & WS_TYPE_WINDOW){
            if (client2->getVisible() != False){
              pdev = client2->getowndev();
            }
          }
          if (pdev != NULL){
            WSCbool fl = True;
            pdev->setValue(WSDEV_WIN_ACTIVE,&fl);
            break;
          }else{
            client2 = client2->getParent();
          }
        }
        return 1;
#else
        WSCbool exec_closed = False;
        if (_wnd == e->hWnd || _shell== e->hWnd){
dbprintf("WSDwinwinDev::_evh_delete %s:%d call2 destroyWindow ev=%d\n",__FILE__,__LINE__,e->message);
          exec_closed = True;
          _pwnd = 0;
          _wnd = 0;
          _shell = 0;
          setInitialized(False);
dbprintf("WSDwinwinDev::_evh_delete %s:%d call2 onUnmap this=0x%x\n",__FILE__,__LINE__,this);
          onUnmap();
        }
        WSCbase* client = getAttachedClient();
        if (client != NULL && exec_closed == True){
          client->execEventProc(WSEV_WINDOW_CLOSED,NULL);
        }
dbprintf("WSDwinwinDev::_evh_delete %s:%d done2 this=0x%x\n",__FILE__,__LINE__,this);
        return 1;
#endif
      }
      client->execEventProc(WSEV_WINDOW_CLOSED,NULL);
      return 0;
    }
  }
  WSCbool exec_closed = False;
  if (_wnd == e->hWnd){
    exec_closed = True;
    _pwnd = 0;
    _wnd = 0;
    _shell = 0;
    setInitialized(False);
dbprintf("WSDwinwinDev::_evh_delete %s:%d call1 onUnmap this=0x%x\n",__FILE__,__LINE__,this);
    onUnmap();
  }else
  if (_shell == e->hWnd){
    exec_closed = True;
    _pwnd = 0;
    _wnd = 0;
    _shell = 0;
    setInitialized(False);
dbprintf("WSDwinwinDev::_evh_delete %s:%d call2 onUnmap this=0x%x\n",__FILE__,__LINE__,this);
    onUnmap();
  }
  WSCbase* client = getAttachedClient();
  if (client != NULL && exec_closed == True){
    client->execEventProc(WSEV_WINDOW_CLOSED,NULL);
  }
dbprintf("WSDwinwinDev::_evh_delete %s:%d done2 this=0x%x\n",__FILE__,__LINE__,this);
  return 0;
}

void WSDwinwinDev::_evh_move(WinEvent* ev){
  if (getVisible() == False){
    return;
  }
  if (_shell != WSGIwinAppDev()->getEventWnd()){
    return;
  }
#ifndef _WSWINCE
  if (IsIconic(WSGIwinAppDev()->getEventWnd())){
    return;
  }
#endif

  MSG msg;
  if (PeekMessage(&msg,_shell,WM_MOVE,WM_MOVE,PM_NOREMOVE) != False){
    return;
  }
  RECT r,r2,r3;
  GetWindowRect(_shell,&r);
  GetWindowRect(_wnd,&r2);
  GetClientRect(_shell,&r3);
  if (r.left == _w_x && 
      r.top == _w_y ){
    return;
  }

  WSCrect area;
  area.setRect(r.left,r.top, _w_w,_w_h);

  if (area.x <-30000|| area.y < -30000){
    return;
  }
#if 0
  if (area.width >=32760|| area.width < 3){
    area.width = _w_w;
    area.height = _w_h;
  }
#endif
  _x_now = area.x;
  _y_now = area.y;
  _w_now = area.width;
  _h_now = area.height;
  _resize_sequence = True;
  onResize(&area);
  _resize_sequence = False;
}

void WSDwinwinDev::_evh_resize(WinEvent* ev){
  if (getVisible() == False){
    return;
  }
  if (_wnd == WSGIwinAppDev()->getEventWnd()){
    return;
  }
#ifndef _WSWINCE
  if (IsIconic( WSGIwinAppDev()->getEventWnd())){
    return;
  }
#endif

  MSG msg;
  if (PeekMessage(&msg,_shell,WM_SIZE,WM_SIZE,PM_NOREMOVE) != False){
    return;
  }
  if (PeekMessage(&msg,_wnd,WM_SIZE,WM_SIZE,PM_NOREMOVE) != False){
    return;
  }
  RECT r,r2,r3;
  GetWindowRect(_shell,&r);
  GetWindowRect(_wnd,&r2);
  GetClientRect(_shell,&r3);

  if ( (r3.right - r3.left) == _w_w && 
      (r3.bottom - r3.top) == _w_h ){
    return;
  }

  WSCrect area;
  area.setRect(_w_x, _w_y,r.right - r.left - _diff_w, r.bottom - r.top - _diff_h);

  if (area.x < -30000|| area.y < -30000){
    return;
  }
  if (area.width >= 32760 || area.width < 3){
    return;
  }
  _x_now = area.x;
  _y_now = area.y;
  _w_now = area.width;
  _h_now = area.height;
  _resize_sequence = True;
  onResize(&area);
  _resize_sequence = False;

}

void WSDwinwinDev::_evh_expose(WinEvent* ev){

  if (_shell == WSGIwinAppDev()->getEventWnd()){
    PAINTSTRUCT ps;
    BeginPaint(_shell,&ps);
    EndPaint(_shell,&ps);
    return;
  }

  PAINTSTRUCT ps;
  BeginPaint(_wnd,&ps);
  WSCrect area;
  area.setRect( (short)ps.rcPaint.left, (short)ps.rcPaint.top,
     (WSCushort)ps.rcPaint.right - ps.rcPaint.left,
     (WSCushort)ps.rcPaint.bottom - ps.rcPaint.top);

  setExposed(True);
  if (getPixmapStyle() == WS_DIRECT_WINDOW){
    _clear_area(area.x,area.y,area.width,area.height);
  }
  onExpose(&area);

  EndPaint(_wnd,&ps);
}
#ifndef NO_MWT_FUNCTION
void WSDwinwinDev::getDiffCoordinates(long* ox,long* oy){
  if (_rebase_handle == NULL){
    *ox = _diff_x;
    *oy = _diff_y;
    return;
  }
  *ox = 0;
  *oy = 0;
  short x,y;
  WSCushort w,h;
  getWindowSize(&x,&y,&w,&h);
  if (_shell == 0){
    return;
  }
  HWND win = _shell;
  int total_x = 0;
  int total_y = 0;
  while(1){
    RECT r;
    GetWindowRect(win,&r);
    total_x += r.left;
    total_y += r.top;
    //exit here. for eclipse plugin.
    break;
    HWND p = GetParent(win);
    if (p == 0){
      break;
    }
    win = p;
  }
  *ox = total_x - x + _diff_x;
  *oy = total_y - y + _diff_y;
}
HWND WSDwinwinDev::getRebaseHandle(){
  return _rebase_handle;
}
#endif
