//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCwindow.h>
#include <WSCvrect.h>
#include <WSCvlabel.h>
#include <WSCvbtn.h>
#include <WSCform.h>
#include <WSCscrForm.h>
#include <WSCvscrBar.h>
#include <WSCscrFrame.h>
#include <WSCvifield.h>
#include <WSDappDev.h>
#include <WSDnwDev.h>
#include <WSCdevice.h>
#include <WSCvtoggle.h>
#include <WSCconductor.h>
#include <WSCvclock.h>
#include <WScom.h>
#include <WSDdragDrop.h>
#include <WSDmouse.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDprivateTimer.h>
#include <WSCfontSet.h>
#include <WSCfileSelect.h>
#include <WSDfileSystem.h>
#include <WSCmessageDialog.h>
#include <WSCwizardDialog.h>
#include <WSDexternal.h>
#include <WSCpopupMenu.h>
#include <WSCtextField.h>
#include <WSClocaleSet.h>
#include <WSCoption.h>

#include <advance/WSCinspector.h>
#include <advance/WSCprojectEditor.h>
#include <advance/WSCobjectBox.h>
#include <advance/WSCprocessForm.h>
#include <advance/WSCcolorSelect.h>
#include <advance/WSadcom.h>

#define WS_NO_WORKING_DIALOG

#define WS_DIALOG_PIX1  WS_PIXMAP_DIR "bi8.xpm"
#define WS_DIALOG_PIX2  WS_PIXMAP_DIR "bi24.xpm"
#define WS_DIALOG_PIX3  WS_PIXMAP_DIR "bi4.xpm"
#define WS_MSG_PIX  WS_PIXMAP_DIR "bi23.xpm"

//󥹥ѿ
WSCbaseDialog*     mainwindow;
//WSCvlabel*         show_project;
//WSCvlabel*         show_dir;
WSCmessageDialog*  message;
WSCmessageDialog*  question;
WSCinspector*      inspector;
WSCprojectEditor*  pe;
WSCobjectBox*      objectbox;
WSCfileSelect*     fselect;
WSCwizardDialog*     newwin;
WSCwizardDialog*     newprj;
WSCwizardDialog*     searchwz;
WSCbaseDialog*     objsearchwz;
WSCfform*           toolbar;
WSCpopupMenu*      popupmenu;
WSCpopupMenu*      popupmenu2;
//WSCprocessBox*     procbox;
WSCprocessForm*     procform;
WSClistData        selected_clients;
WSClistData        copy_clients;
WSClistData        winlist;
WSCstring          current_project;
WSCstring          current_dir;

WSCvlabel*         show_prj1;
WSCvlabel*         show_dir1;
WSCvlabel*         show_prj2;
WSCvlabel*         show_dir2;

#define WS_PM_MENU1 WSGFgettext("A3:WSSTR Copy    :COPY:,Paste:PASTE:,SP,Properties:PROP:,Procedures:OP:,Attributes:EXPROP:,SP,Delete:DEL:")
#define WS_PM_MENU2 WSGFgettext("A3:WSSTR Copy    :COPY:,Paste:PASTE:,SP,Properties:PROP:,Procedures:OP:,Attributes:EXPROP:,SP,Front:FRONT:,Back:BACK:,SP,Delete:DEL:")

#define WS_TITLE_WIDTH   200
#define WS_TITLE_HEIGHT  200
WSCwindow* title =  NULL;
WSCform*       titlei = NULL;

WSCstring _get_java_package_name_handler(){
  WSCstring pkgname = pe->getProjectData("#JAVA_PKG_NAME");
  pkgname.delHeadSpace();
  pkgname.delTailSpace();
  return pkgname;
}
WSClistData _dll_list;
WSCbase* _create_instance_dll_load_handler(char* cname,WSCbase* parent,char* name){
  WSCstring reqlib = objectbox->getRequiredLibrary(cname);
  if (!strcmp((char*)reqlib,"")){
    return NULL;
  }
  WSDexternal* newext = WSDexternal::getNewInstance();
extern WSCstring get_complete_libname(char*);
//printf("reqlib=%s\n",(char*)reqlib);
  WSCstring libname = get_complete_libname((char*)reqlib);
//printf("comp_reqlib=%s\n",(char*)libname);
  long ret = newext->open((char*)libname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
  if (ret != WS_NO_ERR){
//printf("Library %s not found.\n",(char*)libname);
    return NULL;
  }
  _dll_list.add((void*)newext);
  WSCbase* obj = WSCbase::getNewInstance(cname,parent,name);
  return obj;

}
void pe_update_work(WSCbase* obj){
  if (obj->getVisible() == False){
    inspector->updateList();
  }
}

long _get_lang_hd(){
  return pe->getLanguage();
}
long _get_mapping_hd(){
  if (pe->useMpfcMapping() != False){
    return WS_MAPPING_MPFC;
  }else{
    return WS_MAPPING_MWT;
  }
}

#define WS_TITLE_COMMAND "$(WSDIR)/bin/wstitle &"
extern char* get_project_dir();
long create_proc_for_template(char* pname,char* base_cname){
  WSCstring procstr;
  WSCstring pname2;
  pname2 << pname;
  WSCstring fpname;
  fpname << pname;
  if (pe->getLanguage() == WS_LANG_RUBY){
    if (pname2.isExist(".cpp") != -1){
      pname2.replaceString(".cpp","",1);
      fpname.replaceString(".cpp",".rb",1);
    }
    pname2.replaceString(".rb","",1);
  }else
  if (pe->getLanguage() == WS_LANG_PYTHON){
    if (pname2.isExist(".cpp") != -1){
      pname2.replaceString(".cpp","",1);
      fpname.replaceString(".cpp",".py",1);
    }
    pname2.replaceString(".py","",1);
  }else
  if (pe->getLanguage() == WS_LANG_PERL){
    if (pname2.isExist(".cpp") != -1){
      pname2.replaceString(".cpp","",1);
      fpname.replaceString(".cpp",".pl",1);
    }
    pname2.replaceString(".pl","",1);
  }else
  if (pe->getLanguage() == WS_LANG_JAVA){
    if (pname2.isExist(".cpp") != -1){
      pname2.replaceString(".cpp","",1);
      fpname.replaceString(".cpp",".java",1);
    }
    pname2.replaceString(".java","",1);
  }else
  if (pe->getLanguage() == WS_LANG_OCAML){
    if (pname2.isExist(".cpp") != -1){
      pname2.replaceString(".cpp","",1);
      fpname.replaceString(".cpp",".ml",1);
    }
    pname2.replaceString(".ml","",1);
  }else{
    pname2.replaceString(".cpp","",1);
  }

  if (base_cname == NULL){
    long lang = pe->getLanguage();
    if (lang == WS_LANG_CPP){
      WSGFopCreate(&procstr,pname2,NULL);
    }else
    if (lang == WS_LANG_RUBY){
      WSGFopCreateRb(&procstr,pname2,NULL);
    }else
    if (lang == WS_LANG_PYTHON){
      WSGFopCreatePy(&procstr,pname2,NULL);
    }else
    if (lang == WS_LANG_PERL){
      WSGFopCreatePerl(&procstr,pname2,NULL);
    }else
    if (lang == WS_LANG_JAVA){
      WSGFopCreateJava(&procstr,pname2,NULL);
    }else
    if (lang == WS_LANG_OCAML){
      WSGFopCreateOcaml(&procstr,pname2,NULL);
    }
  }else{
    WSGFclassProcedureCreate(&procstr,pname2,NULL,base_cname);
  }
  WSCstring fname;
  fname << get_project_dir() << "/" << fpname;

  WSCbool fl = WSGFcheckExistFile((char*)fname);

  if (fl != False){
    char buffer[2048];
    sprintf(buffer,WSGFgettext("q3:WSSTR Overwrite existing file: %s?"),
                   (char*)fname);
    question->setProperty(WSNlabelString,buffer);
    question->setProperty(WSNwidth,550);
    long ret = question->popup();
    if (ret != WS_DIALOG_OK){
      return 1;
    }
  }
  long ret = WSGFreplaceTextFile((char*)fname,(char*)procstr,False); 
  return ret;
}

WSCbool _arrow_key_for_selected_obj(long key,WSCbool fl){
  if (fl != False){
    if (key == WSK_Up ||
        key == WSK_Down ||
        key == WSK_Left ||
        key == WSK_Right){
      WSCbase* focusobj = WSCbase::getFocusInstance();
      if (focusobj == NULL){
        return True;
      }
      long hit=0;
      long i;
      long num = selected_clients.getNum();
      for(i=0; i<num ;i++){
        WSCbase* target = (WSCbase*)selected_clients[i];
        if (target == target->getParentWindow()){
          continue;
        }
        if (focusobj == target){
          hit =1;
          break;
        }
        if (focusobj == target->getParentWindow()){
          hit =1;
          break;
        }
        if (focusobj->getParentWindow() == target->getParentWindow()){
          hit =1;
          break;
        }
      }
      if (hit != 0){
        WSCushort gx,gy;
        WSCbase::getGripHandGrid(&gx,&gy);
        WSCbool changed = 0;
        for(i=0; i<num ;i++){
          WSCbase* target = (WSCbase*)selected_clients[i];
          if (target == target->getParentWindow()){
            continue;
          }
          if (key == WSK_Up){
            WSCbool wshift = WSGIappKeyboard()->withShift();
            if (wshift == False){
              short pos = target->getProperty(WSNy);
              target->clear();
              target->setProperty(WSNy,(pos - gy));
            }else{
              long h = target->getProperty(WSNheight);
              if (h - (long)gy > -1){
                target->clear();
                target->setProperty(WSNheight,(h - gy));
              }
            }
            target->redraw();
            changed = 1;
          }else
          if (key == WSK_Down){
            WSCbool wshift = WSGIappKeyboard()->withShift();
            if (wshift == False){
              short pos = target->getProperty(WSNy);
              target->clear();
              target->setProperty(WSNy,(pos + gy));
            }else{
              long h = target->getProperty(WSNheight);
              target->clear();
              target->setProperty(WSNheight,(h + gy));
            }
            target->redraw();
            changed = 1;
          }else
          if (key == WSK_Left){
            WSCbool wshift = WSGIappKeyboard()->withShift();
            if (wshift == False){
              short pos = target->getProperty(WSNx);
              target->clear();
              target->setProperty(WSNx,(pos - gx));
            }else{
              long w = target->getProperty(WSNwidth);
              if (w - (long)gx > -1){
                target->clear();
                target->setProperty(WSNwidth,(w - gx));
              }

            }
            target->redraw();
            changed = 1;
          }else
          if (key == WSK_Right){
            WSCbool wshift = WSGIappKeyboard()->withShift();
            if (wshift == False){
              short pos = target->getProperty(WSNx);
              target->clear();
              target->setProperty(WSNx,(pos + gx));
            }else{
              long w = target->getProperty(WSNwidth);
              target->clear();
              target->setProperty(WSNwidth,(w + gx));
            }
            target->redraw();
            changed = 1;
          }
        }
        WSCbase* prop_editor = WSGIappPropertyEditor();
        if ( changed != 0 && prop_editor != NULL ){
          WSGIappPropertyEditor()->setUserData(WS_GEOMETRY_UPDATE,(void*)1);
          WSGIappPropertyEditor()->update();
        }
        return False;
      }
    }
  }
  return True;
}


void initialize(){
  WSGIappLocaleSet()->setDefaultEncoding(WS_EN_UTF8);

  WSCstring* copyright = WSGFreadTextFile("$(WSDIR)/sys/data/copyright");
  if (copyright != NULL){
//    printf("%s",copyright->getString());
    delete copyright;
  }else{
    WSGIappMessageDialog()->setProperty(WSNlabelString,"$(WSDIR)/sys/data/copyright: not found. \nPlease set WideStudio home\nto WSDIR environment variable.");
    WSGIappMessageDialog()->setProperty(WSNheight,150);
    WSGIappMessageDialog()->setProperty(WSNwidth,500);
    WSGIappMessageDialog()->popup();
    WSGFexit(1);
  }
#ifdef MSW
extern int _system(char*);
  _system(WSGIappFileSystem()->adjustFileName(WS_TITLE_COMMAND));
#else
  system(WSGIappFileSystem()->adjustFileName(WS_TITLE_COMMAND));
#endif

  WSGFenablePropertyBuilderTitle();
  WSCscrForm::setUseScrBarClass("WSCvbscrBar");
  WSCtextField::setUseScrBarClass("WSCvbscrBar");

  WSGFsetGetLanguageHandler(_get_lang_hd);
  WSGFsetGetMappingHandler(_get_mapping_hd);

  //changed by hirabayashi 1999 02/10
//  WSGIappColorSet()->initialize("$(WSDIR)/sys/data/color.data");
  WSGIappFontSet()->setDefaultFont(8);

  WSGIappColorSelect();

extern void create_main_window();
  create_main_window();

  WSGIappKeyboard()->setGlobalKeyHook( _arrow_key_for_selected_obj);

#if 0
  tbox = new WSCtoolBox(NULL,"toolb");
  tbox->initialize();
  tbox->setPropertyV(WSNx,(short)200);
  tbox->setPropertyV(WSNy,(short)200);
  tbox->setPropertyV(WSNfileName,WS_TOOLB_FILE);
#endif
  
  WSGFreadWinSrcSetCreateProcHandler(create_proc_for_template);

//  fselect = new WSCfileSelect(NULL,"bl-fselect");
//  fselect->initialize();
  fselect = WSGIappFileSelect();
  fselect->setPropertyV(WSNwidth,(WSCushort)300);
  fselect->setPropertyV(WSNwidth,(WSCushort)400);
  fselect->setPropertyV(WSNmodal,(WSCbool)True);
  fselect->setPropertyV(WSNdefaultPosition,(WSCbool)True);
 
  message = new WSCmessageDialog(NULL,"bl-message");
  message->initialize();
  message->setPropertyV(WSNmodal,(WSCbool)True);
  message->setPropertyV(WSNdefaultPosition,(WSCbool)True);
  message->setPropertyV(WSNwidth,(WSCushort)400);
  message->setPropertyV(WSNheight,(WSCushort)125);
  message->setPropertyV(WSNlabelPixmap,WS_MSG_PIX);
  message->setPropertyV(WSNtitleString,"Message");
  message->setPropertyV(WSNcancel,False);

  question = new WSCmessageDialog(NULL,"bl-question");
  question->initialize();
  question->setPropertyV(WSNmodal,(WSCbool)True);
  question->setPropertyV(WSNdefaultPosition,(WSCbool)True);
  question->setPropertyV(WSNwidth,(WSCushort)400);
  question->setPropertyV(WSNheight,(WSCushort)125);
  question->setPropertyV(WSNno,(WSCbool)True);
  question->setPropertyV(WSNlabelPixmap,WS_MSG_PIX);
  question->setPropertyV(WSNtitleString,WSGFgettext("B4:WSSTR Confirmation"));

  WSCstring loc = WSGIappLocaleSet()->getSystemLocaleName();
  if (!strcmp((char*)loc,"C")){
    loc = "en_US";
  }
  WSCstring datadir;
  datadir << "$(WSDIR)/sys/data/locale/" << loc << "/lib1.data";
  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)datadir)) == False){
    loc = "en_US";
  }
  datadir ="";
  datadir << "$(WSDIR)/sys/data/locale/" << loc;
  WSCstring data;
  data << datadir << "/lib1.data,";
  data << datadir << "/lib2.data,";
  data << datadir << "/lib3.data,";
  data << datadir << "/lib4.data,";
  data << datadir << "/lib5.data";

  objectbox = new  WSCobjectBox(NULL,"objectbox");
  objectbox->initialize();
  objectbox->setPropertyV(WSNx,(short)10);
  objectbox->setPropertyV(WSNy,(short)10);
  objectbox->setProperty(WSNwidth,500);
  objectbox->setProperty(WSNfileName,data);

  objectbox->setPropertyV(WSNlabelPixmap, WS_DIALOG_PIX2 );
  objectbox->setPropertyV(WSNtitleString,WSGFgettext("C4:WSSTR ObjectBox"));

  pe = new  WSCprojectEditor(NULL,"pe");
  pe->initialize();
  pe->setPropertyV(WSNx,(short)10);
  pe->setPropertyV(WSNy,(short)10);

  pe->setPropertyV(WSNwidth,(WSCushort)840);
  pe->setPropertyV(WSNheight,(WSCushort)400);
  pe->setPropertyV(WSNtitleString,WSGFgettext("D4:WSSTR ProjectSettings"));
  pe->setPropertyV(WSNlabelPixmap, WS_DIALOG_PIX1 );
  pe->setObjectBox(objectbox);

  pe->loadEditorOptions("$(WSDIR)/sys/data/editors");
  pe->loadLinkOptions("$(WSDIR)/sys/data/linkoptions");

  WSCprocedure* updateop = new WSCprocedure("updateop",WSEV_VISIBLE_CH);
  updateop->setFunction(pe_update_work,"pe_update_work");
  pe->addProcedure(updateop);


extern void create_newprj_dialog();
  create_newprj_dialog();

extern void _create_win_tracewin();
  _create_win_tracewin();

  WSCstring defprj;
  defprj << "$(WSDIR)/sys/data/locale/" << loc << "/default.prj";
  pe->setDefaultProjectName(defprj);
  pe->open(defprj);

  WSCstring defrc;
  defrc << "$(WSDIR)/sys/data/locale/" << loc << "/default.rc";
  pe->open_global(defrc);

#ifdef MSW
  long ret = pe->open_global("$(WINDIR)/.wsbuilderrc");
#else
  long ret = pe->open_global("$(HOME)/.wsbuilderrc");
#endif
#if 0 //move above..
  if (ret != WS_NO_ERR){
    WSCstring defrc;
    defrc << "$(WSDIR)/sys/data/locale/" << loc << "/default.rc";
    pe->open_global(defrc);
  }
#endif
extern void create_newwin_dialog();
  create_newwin_dialog();

extern void create_searchwz_dialog();
  create_searchwz_dialog();

extern void create_objsearchwz_dialog();
  create_objsearchwz_dialog();

  popupmenu = new WSCpopupMenu(NULL,"menu");
  popupmenu->initialize();
  popupmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  popupmenu->setPropertyV(WSNmenuItems,WS_PM_MENU1);
  popupmenu->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  popupmenu->setPropertyV(WSNbackColor,"gray85");
//  popupmenu->setPropertyV(WSNtopShadowColor,"gray95");
//  popupmenu->setPropertyV(WSNbottomShadowColor,"gray55");
  popupmenu->setEmboss(True);

  extern void icopy_work2(WSCbase*);
  WSCprocedure* pmop = new WSCprocedure("COPY",WSEV_NONE);
  pmop->setFunction(icopy_work2,"icopy_work2");
  popupmenu->addProcedure(pmop);

  extern void ipaste_work2(WSCbase*);
  pmop = new WSCprocedure("PASTE",WSEV_NONE);
  pmop->setFunction(ipaste_work2,"ipaste_work2");
  popupmenu->addProcedure(pmop);

  extern void iprop_work2(WSCbase*);
  pmop = new WSCprocedure("PROP",WSEV_NONE);
  pmop->setFunction(iprop_work2,"iprop_work2");
  popupmenu->addProcedure(pmop);

  extern void iop_work2(WSCbase*);
  pmop = new WSCprocedure("OP",WSEV_NONE);
  pmop->setFunction(iop_work2,"iop_work2");
  popupmenu->addProcedure(pmop);

  extern void iextprop_work2(WSCbase*);
  pmop = new WSCprocedure("EXPROP",WSEV_NONE);
  pmop->setFunction(iextprop_work2,"iextprop_work2");
  popupmenu->addProcedure(pmop);

  extern void idel_work2(WSCbase*);
  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(idel_work2,"idel_work2");
  popupmenu->addProcedure(pmop);

//  procbox = new WSCprocessBox(NULL,"procbox");
//  procbox->initialize();
//  WSGFsetGeometry(procbox,100,100,400,300);
  procform = new WSCprocessForm(inspector->getForm4(),"procform");
  procform->initialize();
  procform->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  procform->setPropertyV(WSNusePixmap,(WSCbool)True);
  procform->setVisible(True);
//  procform->setProperty(WSNshadowThickness,0);
  inspector->setForm4Client(procform);

extern void build_btn_sensitive_ch(WSCbase*);

  WSCprocedure* pfop = new WSCprocedure("activate",WSEV_ACTIVATE);
  pfop->setFunction(build_btn_sensitive_ch,"build_btn_sensitive_ch");
  procform->addProcedure(pfop);


//  WSCtextField* mtext = procbox->getTextField();
  WSCbase* mtext = procform->getTextFrame();
  extern void error_editor_open(WSCbase*);
  WSCprocedure* mtop = new WSCprocedure("EDITOR OPEN",WSEV_MOUSE_DOUBLE_CLICK);
//  WSCprocedure* mtop = new WSCprocedure("EDITOR OPEN",WSEV_MOUSE_PRESS);
  mtop->setFunction(error_editor_open,"error_editor_open");
  mtext->addProcedure(mtop);


  popupmenu2 = new WSCpopupMenu(NULL,"menu");
  popupmenu2->initialize();
  popupmenu2->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  popupmenu2->setPropertyV(WSNmenuItems,WS_PM_MENU2);
  popupmenu2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  popupmenu2->setEmboss(True);

  extern void icopy_work2(WSCbase*);
  pmop = new WSCprocedure("COPY",WSEV_NONE);
  pmop->setFunction(icopy_work2,"icopy_work2");
  popupmenu2->addProcedure(pmop);

  extern void ipaste_work2(WSCbase*);
  pmop = new WSCprocedure("PASTE",WSEV_NONE);
  pmop->setFunction(ipaste_work2,"ipaste_work2");
  popupmenu2->addProcedure(pmop);

  extern void iprop_work2(WSCbase*);
  pmop = new WSCprocedure("PROP",WSEV_NONE);
  pmop->setFunction(iprop_work2,"iprop_work2");
  popupmenu2->addProcedure(pmop);

  extern void iop_work2(WSCbase*);
  pmop = new WSCprocedure("OP",WSEV_NONE);
  pmop->setFunction(iop_work2,"iop_work2");
  popupmenu2->addProcedure(pmop);

  extern void iextprop_work2(WSCbase*);
  pmop = new WSCprocedure("EXPROP",WSEV_NONE);
  pmop->setFunction(iextprop_work2,"iextprop_work2");
  popupmenu2->addProcedure(pmop);

  extern void ifront_work2(WSCbase*);
  pmop = new WSCprocedure("FRONT",WSEV_NONE);
  pmop->setFunction(ifront_work2,"ifront_work2");
  popupmenu2->addProcedure(pmop);

  extern void iback_work2(WSCbase*);
  pmop = new WSCprocedure("BACK",WSEV_NONE);
  pmop->setFunction(iback_work2,"iback_work2");
  popupmenu2->addProcedure(pmop);

  extern void idel_work2(WSCbase*);
  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(idel_work2,"idel_work2");
  popupmenu2->addProcedure(pmop);

#if 0
  procbox = new WSCprocessBox(NULL,"procbox");
  procbox->initialize();
  WSGFsetGeometry(procbox,100,100,400,300);
#endif

extern void _create_win_policy_select();
  _create_win_policy_select();


#if 0
extern long check_name_strings(char*,WSCbase*);
  WSGFsetExistNameHandler(check_name_strings);
#endif

extern void setup_instance(WSCbase*);
  WSGFsetCreateHandler(setup_instance);

extern void del_instance(WSCbase*);
  WSGFsetDeleteHandler(del_instance);

extern void load_window_style();
  load_window_style();

extern void adjust_mainwindow(WSCbase*);
  adjust_mainwindow(mainwindow);  
//  WSGIappFontSet()->setDefaultFont(0);
extern long check_name_strings(char*,WSCbase*);
  WSGFsetExistNameHandler(check_name_strings);
  WSCscrForm::setUseScrBarClass(NULL);
  WSCtextField::setUseScrBarClass(NULL);
  WSCbase::setCreateInstanceHandler(_create_instance_dll_load_handler);

  WSGFsetJavaPackageNameHandler((void*)_get_java_package_name_handler);

extern void _gui_policy_change();
  _gui_policy_change();

extern long load_complete_lib_name(char*);
  load_complete_lib_name(
     WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/config/libname"));

  if (WSGIappDev()->getArgc() > 1){
    char** ptr = WSGIappDev()->getArgv();
    WSCstring fname = ptr[1];
    WSCstring filename = WSGFgetFileName(ptr[1]);
    WSCstring current_dir = WSGFgetDirName(ptr[1]);
    WSCstring current_project = filename;

    pe->setProjectData("#ENCODING","LOCALE");

    long ret = pe->open(fname);
    if (ret != WS_NO_ERR){
      message->setPropertyV(WSNwidth,(WSCushort)400);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,
        WSGFgettext("C4:WSSTR Unexpected error occurred in reading the project files..."));
      message->popup();
    }else{
extern void set_project_name(char*,char*);
      set_project_name((char*)current_project,(char*)current_dir);
      long len = strlen((char*)fname);
      if (len > 4 && !strcmp( ((char*)fname) + len-4,".prj")){
        fname.replaceString(".prj",".wns",1);
#ifdef MSW
      }else if (len > 4 && !strcmp( ((char*)fname) + len-4,".PRJ")){
        fname.replaceString(".PRJ",".wns",1);
#endif
      }else{
        fname << ".wns";
      }
extern long load_winfiles(char*,WSClistData*);
      ret = load_winfiles(fname,&winlist);
      if (ret != WS_NO_ERR){
        WSCstring buf;
        buf << WSGFgettext("D4:WSSTR Can not open File: ") << fname
            << WSGFgettext("E4:WSSTR  .");
        message->setPropertyV(WSNwidth,(WSCushort)400);
        message->setPropertyV(WSNreplyHandler,(void*)NULL);
        message->setPropertyV(WSNlabelString,(char*)buf);
        message->popup();
        return;
      }
      inspector->setClients(&winlist);

      fname.replaceString(".wns",".col",1);
#ifdef MSW
      fname.replaceString(".WNS",".col",1);
#endif
      WSGIappColorSelect()->load((char*)fname);
    }
extern void setup_buildbtn();
    setup_buildbtn();
  }
  mainwindow->setVisible(True);

};

void _gui_policy_change(){
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    inspector->setProperty(WSNshadowThickness,1);
    mainwindow->getCmdFormObject()->setVisible(True);
    show_prj1->setVisible(False);
    show_prj2->setVisible(False);
    show_dir1->setVisible(False);
    show_dir2->setVisible(False);
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    inspector->setProperty(WSNshadowThickness,2);
    mainwindow->getCmdFormObject()->setVisible(False);
    show_prj1->setVisible(True);
    show_prj2->setVisible(True);
    show_dir1->setVisible(True);
    show_dir2->setVisible(True);
  }
extern WSCoption* opt31;
extern WSCoption* opt32;
extern WSCoption* nmopt1;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_GRADATION){
    opt31->setProperty(WSNgradation,WS_GR_LT_RB);
    opt32->setProperty(WSNgradation,WS_GR_LT_RB);
    nmopt1->setProperty(WSNgradation,WS_GR_LT_RB);
  }else{
    opt31->setProperty(WSNgradation,WS_GR_NONE);
    opt32->setProperty(WSNgradation,WS_GR_NONE);
    nmopt1->setProperty(WSNgradation,WS_GR_NONE);
  }
}

class _init_ {
  public: _init_(){
    WSGFdeviceInitialize();
    WSGIappDev()->setInitHandler(initialize);

  }
};

_init_ _init_to_run;

