//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSClocaleSet.h>
#include <WSCinitializeManager.h>

#if defined (_VC) || defined (_BCC)
#define NO_JAPANESE_EUC_MSG
#define NO_JAPANESE_UTF8_MSG
#define NO_KSC5601_MSG
#define NO_GB2312_MSG
#endif

#ifndef NO_ENGLISH_MSG
void _wsbuilder_lang_init_proc(){
#include "English.cpp"
}
#endif
#ifndef NO_JAPANESE_EUC_MSG
void _wsbuilder_lang_init_proc1(){
#include "Japanese.cpp"
}
#endif
#ifndef NO_JAPANESE_SJIS_MSG
void _wsbuilder_lang_init_proc2(){
#include "Japanese-sjis.cpp"
}
#endif
#ifndef NO_JAPANESE_UTF8_MSG
void _wsbuilder_lang_init_proc3(){
#include "Japanese-utf8.cpp"
}
#endif
#ifndef NO_KSC5601_MSG
void _wsbuilder_lang_init_proc4(){
#include "Korean.cpp"
}
#endif
#ifndef NO_GB2312_MSG
void _wsbuilder_lang_init_proc5(){
#include "Chinese-zh_cn.cpp"
}
#endif
#ifndef NO_ES_MSG
void _wsbuilder_lang_init_proc6(){
#include "Espanol.cpp"
#include "Espanol-ar.cpp"
}
#endif
#ifndef NO_ES_UTF8_MSG
void _wsbuilder_lang_init_proc7(){
#include "Espanol-utf8.cpp"
#include "Espanol-ar-utf8.cpp"
}
#endif

class _wsbuilder_lang_init_{
public:
  _wsbuilder_lang_init_(){
#ifndef NO_ENGLISH_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc);
#endif
#ifndef NO_JAPANESE_EUC_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc1);
#endif
#ifndef NO_JAPANESE_SJIS_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc2);
#endif
#ifndef NO_JAPANESE_UTF8_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc3);
#endif
#ifndef NO_KSC5601_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc4);
#endif
#ifndef NO_GB2312_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc5);
#endif
#ifndef NO_ES_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc6);
#endif
#ifndef NO_ES_UTF8_MSG
    WSGIappInitializeManager()->addInitializeProc(_wsbuilder_lang_init_proc7);
#endif
  };
};

static _wsbuilder_lang_init_ _run_libwsad_lang_init;

