//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDappDev.h>
#include <WSCwindow.h>
#include <WSCvbtn.h>
#include <WSCtextField.h>
#include <WSCpulldownMenu.h>
#include <WSCform.h>
#include <WSCfileSelect.h>
#include <WSCmessageDialog.h>
#include <WSCvifield.h>
#include <WSCwizardDialog.h>
#include <WSCvtoggle.h>
#include <WSDfileSystem.h>
#include <WSDtimer.h>
#include <WSCvfbtn.h>
#include <WSCballoonHelp.h>
#include <WSCbaseList.h>
#include <WSCcomboBox.h>
#include <WSCfunction.h>
#include <WSCfunctionList.h>
#include <WSCdialog.h>
#include <WSCvradio.h>
#include <WSClocaleSet.h>
#include <WSCoption.h>
#include <WSCfform.h>
#include <WSDmessage.h>
#include <advance/WSadcom.h>
#include <advance/WSCprojectEditor.h>
#include <advance/WSCinspector.h>
#include <advance/WSCobjectBox.h>
#include <advance/WSCprocessForm.h>
#include <advance/WSCprocessBox.h>
#include <advance/WSCcolorSelect.h>
#include <advance/WSCprocedureEditor.h>
#include <WSCvmifield.h>
#include <WSCdirTree.h>
#include <WSCmenuArea.h>
#include <WSCpopupMenu.h>
#include <WSCundoManager.h>

#ifdef MSW
WS_WINMAIN
extern int _system(char*);
extern int _system_console(char*);
#include <direct.h>
#else
#include <unistd.h>
#include <sys/stat.h>
#endif

WSCushort toolbarw;

#include <WSDexecute.h>

#define WS_MSG_PIX  WS_PIXMAP_DIR "bi23.xpm"
#define WS_BUILDER_PIX  WS_PIXMAP_DIR "bi4.xpm"
#define WS_BUILDER_TITLE "WS BUILDER"

#ifndef MSW
#define LBTNS 18
#else //MSW
#define LBTNS 17
#endif //MSW

static int sepa[] = {
0,0,0,0,1,0,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0
};

static char* pixmaps[] = {
WS_PIXMAP_DIR "pcreate.xpm",
WS_PIXMAP_DIR "pload.xpm",
WS_PIXMAP_DIR "psave.xpm",
WS_PIXMAP_DIR "pend.xpm",
WS_PIXMAP_DIR "wcreate.xpm",
WS_PIXMAP_DIR "wload.xpm",
WS_PIXMAP_DIR "wsave.xpm",
WS_PIXMAP_DIR "wtrash.xpm",
WS_PIXMAP_DIR "edit.xpm",
WS_PIXMAP_DIR "ope.xpm",
WS_PIXMAP_DIR "obox.xpm",
WS_PIXMAP_DIR "pset.xpm",
WS_PIXMAP_DIR "make.xpm",
WS_PIXMAP_DIR "makec.xpm",
WS_PIXMAP_DIR "run.xpm",
WS_PIXMAP_DIR "search.xpm",
#ifndef MSW
WS_PIXMAP_DIR "search2.xpm",
#endif //MSW
WS_PIXMAP_DIR "help.xpm",
WS_PIXMAP_DIR "help.xpm",
WS_PIXMAP_DIR "help.xpm",
WS_PIXMAP_DIR "help.xpm",
NULL
};
static char* bhelpstr[] = {
"E4:WSSTR New project",
"F4:WSSTR Open project",
"G4:WSSTR Save project",
"H4:WSSTR Close project",
"I4:WSSTR New application window",
"J4:WSSTR Open application window",
"K4:WSSTR Save application window",
"L4:WSSTR Delete instance",
"M4:WSSTR Properties",
"N4:WSSTR Procedures",
"O4:WSSTR Display the object box",
"P4:WSSTR Project settings",
"Q4:WSSTR Build all",
"Q4:WSSTR Cancel",
"R4:WSSTR Execute",
"S4:WSSTR Find instances",
#ifndef MSW
"T4:WSSTR Find files",
#endif //MSW
"U4:WSSTR Help",
"",
"",
"",
"",
"",
"",
NULL
};

#define BUILD_BTN 12
#define BUILD_CANCEL_BTN 13
#define EXEC_BTN 14

static void m11_work(WSCbase*);
static void m12_work(WSCbase*);
static void m13_work(WSCbase*);
static void m23_work(WSCbase*);
static void m28_work(WSCbase*);
static void m32_work(WSCbase*);
static void m32c_work(WSCbase*);
static void m36_work(WSCbase*);
static void m24_work(WSCbase*);
static void m25_work(WSCbase*);
static void m41_work(WSCbase*);
static void m44_work(WSCbase*);
static void m51_work(WSCbase*);
static void m52_work(WSCbase*);
static void m53_work(WSCbase*);
static void m55_work(WSCbase*);
static void m56_work(WSCbase*);
static void m81_work(WSCbase*);


static WSCeventProc btnprocs[] = {
m51_work,
m52_work,
m53_work,
m56_work,
m11_work,
m12_work,
m13_work,
m23_work,
m24_work,
m25_work,
m41_work,
m55_work,
m32_work,
m32c_work,
m36_work,
m28_work,
#ifndef MSW
m44_work,
#endif //MSW
m81_work,
m81_work,
m81_work,
m81_work,
m81_work,
NULL

};
extern WSCbaseDialog* mainwindow;
//extern WSCvlabel*     show_project;
//extern WSCvlabel*     show_dir;
extern WSCfileSelect* fselect;
extern WSCprojectEditor* pe;
extern WSCmessageDialog* message;
extern WSCmessageDialog* question;
extern WSCinspector*     inspector;
extern WSCwizardDialog*  newprj;
extern WSCfform*         toolbar;
WSCvlabel* spm;
WSCvfbtn* execbtn;
WSCvfbtn* build_btn;
WSCvfbtn* build_cancel_btn;
extern WSCprocessForm* procform;

extern WSClistData selected_clients;
extern WSClistData copy_clients;
extern WSClistData      winlist;
extern WSCstring        current_project;
extern WSCstring        current_dir;

extern WSCvlabel* show_prj1;
extern WSCvlabel* show_prj2;
extern WSCvlabel* show_dir1;
extern WSCvlabel* show_dir2;

extern long create_makefile();
extern long create_window_srcs();

#define WS_LB_Y2          62
#define WS_LB_SBH         27

#define WS_LB_WIDTH      640
#define WS_LB_HEIGHT     400
#define WS_TB_HEIGHT     30
#define WS_TB_WIDTH      28

#define WS_LB_XOFFSET      0
#define WS_LB_YOFFSET      1

#define WS_LB_W1          95
#define WS_LB_W2          80

#define WS_LB_W3          85
#define WS_LB_W4          80
#define WS_LB_W5         130
#define WS_LB_W6         110
//#define WS_LB_W7          90
#define WS_LB_W8          80
#define WS_LB_H           20
#define WS_LB_AHEIGHT     24

#define WS_MENU1_LB     WSGFgettext("V4:WSSTR  File(F)")
#define WS_MENU1_STR    WSGFgettext("W4:WSSTR New window(N)         :m11:N,Open window(O):m12:O,Save window(S):m13:S,Save as(R):m14:R,Save all(A):m15:A,SP,Exit(X):m16:X")
#define WS_MENU2_LB     WSGFgettext("X4:WSSTR  Edit(E)")
#define WS_MENU2_STR    WSGFgettext("Y4:WSSTR Copy(C):m21:C,Paste(P):m22:P,SP,Display(I):m27:I,Find(F):m28:F,Delete(D):m23:D,SP,Properties(R):m24:R,Procedures:{List up(L):m25:L,New procedure(N):m251:N,Properties(S):m252:S,Edit(E):m253:E,Delete(X):m254:X},Attributes(A):m26:A,Files(L):m29:L")

#define WS_MENU3_LB     WSGFgettext("Z4:WSSTR  Build(B)")
#define WS_MENU3_STR    WSGFgettext("a4:WSSTR Compile(C)    :m31:C,Build all(B):m32:B,Rebuild(R):m33:R,Clean(E):m34:E,SP,Debug(D):m35:D,Execute(X):m36:X,Execute with Trace(T):m39:T,SP,Generate source(G):m37:G,Generate inf file(I):m38:I")
#define WS_MENU3_STR2   WSGFgettext("b4:WSSTR Compile(C)    :m31:C,Build all(B):m32:B,Rebuild(R):m33:R,Clean(E):m34:E,SP,Debug(D):m35:D,Abort(X):m36:X,SP,Generate source(G):m37:G,Generate inf file(I):m38:I")

#define WS_MENU4_LB     WSGFgettext("c4:WSSTR  View(V)")
#ifdef MSW
#define WS_MENU4_STR    WSGFgettext("d4:WSSTR ObjectBox(O) :m41:O,Component(C)    :m42:C,ToolBar(B):m43:B,Terminal(T):m45:T")
#else
#define WS_MENU4_STR    WSGFgettext("e4:WSSTR ObjectBox(O) :m41:O,Component(C)    :m42:C,ToolBar(B):m43:B,Find Files(F):m44:F,Terminal(T):m45:T")
#endif
#define WS_MENU5_LB     WSGFgettext("f4:WSSTR  Project(P)")
#define WS_MENU5_STR    WSGFgettext("g4:WSSTR New project(N)        :m51:N,Open project(O):m52:O,Save project(S):m53:S,Rename project(R):m54:R,SP,Project settings(E):m55:E,SP,Close project(C):m56:C")

#define WS_MENU6_LB     WSGFgettext("h4:WSSTR  Option(O)")
#define WS_MENU6_STR    WSGFgettext("i4:WSSTR Environment(E)    :m61:E,SP,Colors(C):m62:C,Fonts(F):m63:F,Look and Feel(L):m64:L")
#define WS_MENU8_LB     WSGFgettext("j4:WSSTR  Help(H)")
#define WS_MENU8_STR    WSGFgettext("k4:WSSTR Index(I):m81:I,Reference(R)     :m82:R,User's guide(U):m83:U,About WideStudio(V):m84:V,License(L):m85:L")

extern long create_project();


#ifdef BTRON
extern void copy_file(char* f1,char* f2);
#if 0 //move to advance/WSadcom.cpp
void copy_file(char* f1,char* f2){
  WSCstring* str = WSGFreadTextFile(f1);
  if (str != NULL){
    WSGFreplaceTextFile(f2,str->getString(),True);
    delete str;
  }
}
#endif
#endif
void _pmenu_popuped(WSCbase* inst){
  if (inst->getVisible() == False){
    return;
  }
  WSCbase* list = inspector->getClassList();
  WSClist* clist = (WSClist*)list->cast("WSClist");
  long val = (long)clist->getUserData("MENU-POPUP");
  clist->setUserData("MENU-POPUP",(void*)0);
  WSCpopupMenu* pmenu = (WSCpopupMenu*)inst->cast("WSCpopupMenu");
  if (val == 0){
    pmenu->popdown();
  }else
  if (clist != NULL && pmenu != NULL){
    long pos = clist->getSelectedPos();
    if (pos < 0){
      pmenu->popdown();
    }
  }
}
void _clist_item_selected(WSCbase* inst){
  WSClist* clist = (WSClist*)inst->cast("WSClist");
  long pos = clist->getSelectedPos();
  long pos2 = clist->getPreSelectedPos();
  if (pos != pos2){
    if (pos2 > -1){
      clist->setSelectPos(pos2);
    }
  }
  clist->setUserData("MENU-POPUP",(void*)1);
}
void _new_instance(WSCbase*){
  WSCstring tmp = inspector->getSelectedClassName();
  if (!strcmp(tmp.getString(),"")){
    return;
  }
//  long i;
  long num = selected_clients.getNum();
  if (num > 0){
    void* val = selected_clients[0];
    WSCbase* client = (WSCbase*)val;
    if (client == NULL){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("o4:WSSTR Please specify a instance to paste."));
      message->popup();
      return;
    }
    if (!(client->getObjectType() & WS_TYPE_MANAGER)){
      client = client->getParent();
    }
    if (client == NULL){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("o4:WSSTR Please specify a instance to paste."));
      message->popup();
      return;
    }
    if (!(client->getObjectType() & WS_TYPE_MANAGER)){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("o4:WSSTR Please specify a instance to paste."));
      message->popup();
      return;
    }
    WSCbase* btarget=client;
    while(1){
      if (btarget->getParent() != NULL){
        btarget = btarget->getParent();
      }else{
        break;
      }
    }

    WSCbase* newobj = WSCbase::getNewInstance(tmp,client,
        WSGFcreateName(btarget->getInstanceName(),tmp));
    if (newobj != NULL){
      newobj->initialize();
      newobj->setPropertyEditMode(True);
      newobj->setVisible(False);

      //֥ȤФƲΤǤФΥϥɥ¹...
      WSGFexecCreateHandler(newobj);
      //֥Ȥ˲ΤǤФΥϥɥϿ...
      void* delete_handler = (void*)WSGFgetDeleteHandler();
      if (delete_handler != NULL){
        WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
        ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
        ac->setInternal(True);
        newobj->addProcedure(ac);
      }

      if (newobj->existProperty(WSNx) != False){
        WSCproperty* prop = newobj->getPropObj(WSNx);
        if (prop->getBuilderVisible() != False){
          newobj->setProperty(WSNx,10);
        }
      }
      if (newobj->existProperty(WSNy) != False){
        WSCproperty* prop = newobj->getPropObj(WSNy);
        if (prop->getBuilderVisible() != False){
          newobj->setProperty(WSNy,10);
        }
      }
extern WSCprojectEditor* pe;
      long dw1 = atoi(pe->getProjectData("#DWIDTH"));
      long dh1 = atoi(pe->getProjectData("#DHEIGHT"));
      long dt1 = atoi(pe->getProjectData("#DTHICKNESS"));
      WSCushort dw = (WSCushort)dw1;
      WSCushort dh = (WSCushort)dh1;
      WSCushort dt = (WSCushort)dt1;
      if (dw <5){
        dw = 5;
      }
      if (dh <5){
        dh = 5;
      }

      if ( dw != 0){
        if (newobj->existProperty(WSNwidth) != False){
          WSCproperty* prop = newobj->getPropObj(WSNwidth);
          if (prop->getBuilderVisible() != False){
            newobj->setPropertyV(WSNwidth,dw);
          }
        }
      }
      if ( dh != 0){
        if (newobj->existProperty(WSNheight) != False){
          WSCproperty* prop = newobj->getPropObj(WSNheight);
          if (prop->getBuilderVisible() != False){
            newobj->setPropertyV(WSNheight,dh);
          }
        }
      }
      if (newobj->existProperty(WSNshadowThickness) != False){
        WSCproperty* prop = newobj->getPropObj(WSNshadowThickness);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNshadowThickness,(WSCuchar)dt);
        }
      }
      if (newobj->existProperty(WSNtitleString) != False){
        WSCstring str;
extern long title_cnt;
        str << "title" << title_cnt;
        newobj->setProperty(WSNtitleString,str);
        title_cnt++;
      }
      newobj->setUserData(WS_EXT_VAR,(void*)1);

      newobj->setVisible(True);
      newobj->setPropertyEditExecute(True);

extern WSCinspector* inspector;
      inspector->updateList();



    }else{
      WSCstring buffer;
      buffer << WSGFgettext("Q4:WSSTR Can not generate the specified class: ")
             << tmp
             << WSGFgettext("R4:WSSTR .");
extern WSCmessageDialog* message;
      message->setProperty(WSNlabelString,buffer);
      message->popup();
    }
  }else{
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("o4:WSSTR Please specify a instance to paste."));
      message->popup();
  }

}
void _help_instance(WSCbase*){
  WSCstring tmp = inspector->getSelectedClassName();
  if (!strcmp(tmp.getString(),"")){
    return;
  }
extern WSCbool get_wait_for_lock();
  if (get_wait_for_lock() != False){
    return;
  }
  WSCstring str( pe->getProjectData("#WEBB_NAME"));
  WSCstring loc = WSGIappLocaleSet()->getSystemLocaleName();
  if (!strcmp((char*)loc,"C")){
    loc = "en_US";
  }
  WSCstring fcheck;
  fcheck <<  "$(WSDIR)/doc/" << loc << "/ht-ref/" << tmp << ".html";
  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)fcheck)) == False){
    loc = "en_US";
  }

  WSCstring fname;
  fname <<  "\"file://$(WSDIR)/doc/" << loc << 
     "/ht-ref/" << tmp << ".html\"";
  str << " " << WSGIappFileSystem()->adjustFileName((char*)fname) <<" &";

#ifdef MSW
  _system((char*)str);
#else
#ifdef BTRON
//nop..
#else
  system((char*)str);
#endif
#endif
extern void wait_for(char*);
  wait_for(WSGFgettext("A4:WSSTR Please wait for a while to start web browser.."));
}

void set_sensitive_exec_btn(WSCbool fl){
  if (fl == False){
    execbtn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "run2.xpm");
    execbtn->setSensitive(False);
  }else{
    execbtn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "run.xpm");
    execbtn->setSensitive(True);
  }
}

void set_sensitive_build_btn(WSCbool fl){
  if (fl == False){
    build_btn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "make2.xpm");
    build_btn->setSensitive(False);
  }else{
    build_btn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "make.xpm");
    build_btn->setSensitive(True);
  }
}

void set_sensitive_build_cancel_btn(WSCbool fl){
  if (fl == False){
    build_cancel_btn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "makec2.xpm");
    build_cancel_btn->setSensitive(False);
  }else{
    build_cancel_btn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "makec.xpm");
    build_cancel_btn->setSensitive(True);
  }
}
void setup_buildbtn(){
  if (pe->getLanguage() == WS_LANG_CPP ||
      pe->getLanguage() == WS_LANG_JAVA||
      pe->getLanguage() == WS_LANG_OCAML){
    set_sensitive_exec_btn(True);
    set_sensitive_build_btn(True);
    set_sensitive_build_cancel_btn(False);
  }else{
    set_sensitive_exec_btn(True);
    set_sensitive_build_btn(False);
    set_sensitive_build_cancel_btn(False);
  }
}
void build_btn_sensitive_ch(WSCbase*){
  WSCbool fl = procform->getExecuteStatus();
  if (fl == False){
    set_sensitive_build_btn(True);
    set_sensitive_build_cancel_btn(False);
  }else{
    set_sensitive_build_btn(False);
    set_sensitive_build_cancel_btn(True);
  }
}
#if 0 //move to advance/WSmgrcom.cpp
WSClistData _lib_list;
void add_lib_list(char* libname){
  long num = _lib_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* item = (char*)_lib_list[i];
    if (!strcmp(libname,item)){
      return;
    }
  }
  char* str = WSGFstrdup(libname);
//printf("add_lib_name: libname=%s str=%s\n",libname,str);
  _lib_list.add((void*)str);
}
void clear_lib_list(){
  long num = _lib_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* item = (char*)_lib_list[i];
    delete item;
  }
  _lib_list.clear();
}
WSClistData* get_lib_name(){
  return &_lib_list;
}
#endif

void _update_lib_list(WSCbase* item){
extern WSCobjectBox* objectbox;
  WSCstring str = objectbox->getRequiredLibrary(item->getClassName());
//printf("_update_lib_list str=%s\n",(char*)str);
  if (strcmp((char*)str,"")){
    add_lib_list(str); 
  }
  WSClistData children = item->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    _update_lib_list(child);
  }
}
void update_lib_list(){
  clear_lib_list();
  long num = winlist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)winlist[i];
    if (target != NULL){
      WSCbase* win = target->getParentWindow();
      _update_lib_list(win);
    }
  }
}
extern char* get_product_name();

WSCindexVariantData _complete_lib_name;
WSCindexVariantData _complete_lib_name2;
WSCindexVariantData _complete_lib_stname;
long load_complete_lib_name(char* fname){
  _complete_lib_name.clear();
  _complete_lib_name2.clear();
  _complete_lib_stname.clear();
  WSCstring* str = WSGFreadTextFile(fname);
  if (str != NULL){
    while(str->eof() == False){
      WSCstring line = str->gets();
      WSCstring libname = line.getWord(0);
      WSCstring complete_libname = line.getWord(1);
      if (strcmp((char*)libname,"")){
        _complete_lib_name.setData(libname,complete_libname);
        _complete_lib_name2.setData(libname,line.getWord(2));
        _complete_lib_stname.setData(libname,line.getWord(3));
      }
    }
    delete str;
    return WS_NO_ERR;
  }
  return WS_ERR;
}

WSCstring target_suffix;

WSCstring get_complete_libname(char* libname){
  if (!strcmp(target_suffix.getString(),pe->getTargetSuffixName())){
    return _complete_lib_name.getData(libname);
  }else{
    WSCstring fname;
    target_suffix = pe->getTargetSuffixName();
    fname << "$(WSDIR)/sys/config/libname" << pe->getTargetSuffixName();
    load_complete_lib_name(
       WSGIappFileSystem()->adjustFileName(fname.getString()));
  }
  return _complete_lib_name.getData(libname);
}
WSCstring get_complete_libname2(char* libname){
  if (!strcmp(target_suffix.getString(),pe->getTargetSuffixName())){
    return _complete_lib_name2.getData(libname);
  }else{
    WSCstring fname;
    target_suffix = pe->getTargetSuffixName();
    fname << "$(WSDIR)/sys/config/libname" << pe->getTargetSuffixName();
    load_complete_lib_name(
       WSGIappFileSystem()->adjustFileName(fname.getString()));
  }
  return _complete_lib_name2.getData(libname);
}
WSCstring get_complete_stlibname(char* libname){
  if (!strcmp(target_suffix.getString(),pe->getTargetSuffixName())){
    return _complete_lib_stname.getData(libname);
  }else{
    WSCstring fname;
    target_suffix = pe->getTargetSuffixName();
    fname << "$(WSDIR)/sys/config/libname" << pe->getTargetSuffixName();
    load_complete_lib_name(
       WSGIappFileSystem()->adjustFileName(fname.getString()));
  }
  return _complete_lib_stname.getData(libname);
}




static void m11_work(WSCbase*){
extern WSCprojectEditor* pe;
extern WSCbase* create_new_window(char*);
  WSCstring cname;
  cname = pe->getProjectData("#WINC_NAME");
  WSCbase* newwin = create_new_window((char*)cname);
extern void add_new_window(WSCbase*);
  if (newwin != NULL){
    add_new_window(newwin);  
  }

}

static void m12_work(WSCbase*){
extern void read_win_src();
     read_win_src();
}
static void m13_work(WSCbase*){
  long num = selected_clients.getNum();
  if (num < 1){
    message->setProperty(WSNwidth,500);
    message->setProperty(WSNheight,120);
    message->setPropertyV(WSNlabelString,WSGFgettext("l4:WSSTR Please specify a window to save."));
    message->popup();
    return;
  }
  long i;
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)selected_clients[i];
    if (target != NULL){
      WSCbase* win = target->getParentWindow();
extern long win_save(WSCbase*);
      win_save(win);
    }
  }
}

static void m14_work(WSCbase*){
  long num = selected_clients.getNum();
  if (num < 1){
    message->setPropertyV(WSNlabelString,WSGFgettext("l4:WSSTR Please specify a window to save."));
    message->popup();
    return;
  }
  long i;
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)selected_clients[i];
    if (target != NULL){
      WSCbase* win = target->getParentWindow();
extern long win_rename_save(WSCbase*);
      win_rename_save(win);
    }
  }
}

static void m15_work(WSCbase*){
  long num = winlist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)winlist[i];
    if (target != NULL){
      WSCbase* win = target->getParentWindow();
extern long win_save(WSCbase*);
      long ret = win_save(win);
      if (ret != WS_NO_ERR){
        question->setPropertyV(WSNwidth,(WSCushort)500);
        question->setPropertyV(WSNheight,(WSCushort)120);
        question->setPropertyV(WSNlabelString,WSGFgettext("m4:WSSTR Continue saving?"));
        long ret1 = question->popup();
        if (ret1 != WS_DIALOG_OK){
          break;
        }
      }
    }
  }
}


static void m16_work(WSCbase*){
extern void exit_builder();
    exit_builder();
}

//void delay_work(WSCuchar ,void*){
//  mainwindow->setVisible(True);
//}
static void m16_work2(WSCbase*){
  if (mainwindow->getVisible() == False){
extern void exit_builder();
    exit_builder();
//    WSGIappTimer()->addTriggerProc(delay_work,WS250MS,NULL);
    mainwindow->setVisible(True);
  }
}
static void m17_work(WSCbase*){
}
static void m21_work(WSCbase*){
  long i;
  long num = selected_clients.getNum();
  if (num < 1){
    WSCstring buffer;
    buffer << WSGFgettext("n4:WSSTR Please specify some instances to copy.");
    message->setProperty(WSNlabelString,buffer);
    message->popup();
    return;
  }
  copy_clients.clear();
  for(i=0; i<num; i++){
    void* item = selected_clients[i];
    copy_clients.add(item);
  }
}
static void m22_work(WSCbase*){
  long num = selected_clients.getNum();
  message->setPropertyV(WSNwidth,(WSCushort)400);
  message->setPropertyV(WSNreplyHandler,(void*)NULL);
  if (num < 1){
    WSCstring buffer;
    buffer << WSGFgettext("o4:WSSTR Please specify a instance to paste.");
    message->setProperty(WSNlabelString,buffer);
    message->popup();
    return;
  }else if (num > 1){
    WSCstring buffer;
    buffer << WSGFgettext("p4:WSSTR Some instances are selected to paste.\nPlease specify a instance.");
    message->setProperty(WSNlabelString,buffer);
    message->popup();
    return;
  }
  WSCbase* target = (WSCbase*)selected_clients[0];
extern void paste(WSCbase*);
  paste(target);
}
static void m23_work(WSCbase*){
extern void delete_object(WSCbase*);
  if (selected_clients.getNum() == 0){
    message->setPropertyV(WSNwidth,(WSCushort)600);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("q4:WSSTR Please select the instance to delete."));
    message->popup();
  }else{
    long i;
    long num = selected_clients.getNum();
    WSClistData tmp = selected_clients;
    WSClistData dlist;
    for(i=0; i<num; i++){
      WSCbase* client = (WSCbase*)selected_clients[i];
      dlist.add(client);
    }

    for(i=0; i<num; i++){
      WSCbase* target = (WSCbase*)dlist[i];
      WSCstring buffer;
      buffer << WSGFgettext("r4:WSSTR Delete instance: ") << target->getInstanceName()
             << WSGFgettext("s4:WSSTR  ?");
      question->setPropertyV(WSNwidth,(WSCushort)500);
      question->setPropertyV(WSNheight,(WSCushort)125);
      question->setPropertyV(WSNreplyHandler,(void*)NULL);
      question->setProperty(WSNlabelString,buffer);
      long ret = question->popup();
      if (ret == WS_DIALOG_OK){
        selected_clients.clear();
        copy_clients.clear();
extern void idel_delay_work(WSCuchar,void* ptr);
        WSGIappTimer()->addTriggerProc(idel_delay_work,WS250MS,target);
      }else if (ret == WS_DIALOG_CANCEL){
        break;
      }
    }
  }
}
static void m24_work(WSCbase*){
  inspector->setSelectIndexTab(2);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)2);
}
static void m25_work(WSCbase*){
  inspector->setSelectIndexTab(3);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)3);
}
static void m251_work(WSCbase*){
  inspector->setSelectIndexTab(3);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)3);
  WSCbase* pre = inspector->getProcedureEditor();
  WSCprocedureEditor* pred =(WSCprocedureEditor*)pre->cast("WSCprocedureEditor");
  pred->createNewProc();
}
static void m252_work(WSCbase*){
  inspector->setSelectIndexTab(3);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)3);
  WSCbase* pre = inspector->getProcedureEditor();
  WSCprocedureEditor* pred =(WSCprocedureEditor*)pre->cast("WSCprocedureEditor");
  pred->editProc();
}
static void m253_work(WSCbase*){
  inspector->setSelectIndexTab(3);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)3);
  WSCbase* pre = inspector->getProcedureEditor();
  WSCprocedureEditor* pred =(WSCprocedureEditor*)pre->cast("WSCprocedureEditor");
  pred->execEditor();
}

static void m254_work(WSCbase*){
  inspector->setSelectIndexTab(3);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)3);
  WSCbase* pre = inspector->getProcedureEditor();
  WSCprocedureEditor* pred =(WSCprocedureEditor*)pre->cast("WSCprocedureEditor");
  pred->deleteProc();
}
static void m26_work(WSCbase*){
  inspector->setSelectIndexTab(4);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)4);
}
static void m27_work(WSCbase*){
  if (selected_clients.getNum() == 0){
    message->setPropertyV(WSNwidth,(WSCushort)600);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("t4:WSSTR Please specify a instance to display."));
    message->popup();
  }else{
    long i;
    long num = selected_clients.getNum();
    WSClistData tmp = selected_clients;
    WSClistData deleted;
    for(i=0; i<num; i++){
      WSCbase* target = (WSCbase*)selected_clients[i];
      while(target != NULL){
        target->setVisible(True);
        target = target->getParent();
      }
    }
  }
}

static void m28_work(WSCbase*){
  if (winlist.getNum() < 1){
    message->setPropertyV(WSNwidth,(WSCushort)500);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("u4:WSSTR There is no instance for search."));
    message->popup();
    return;
  }
extern void exec_obj_search();
exec_obj_search();
}
static void m29_work(WSCbase*){
  inspector->setSelectIndexTab(0);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)0);
}
static void m2_vis_work(WSCbase* obj){
  WSCpulldownMenu* menu = (WSCpulldownMenu*)obj->cast("WSCpulldownMenu");
  if (menu == NULL){
    return;
  }
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  long num = WSGIappUndoManager()->getNum();
  if (num > 0){
    menu->setValueSensitive(1,True);
  }else{
    menu->setValueSensitive(1,False);
  }
#endif
#endif
}
static void m291_work(WSCbase*){
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSGIappUndoManager()->execUndoProc();
//  inspector->setPropertyV(WSNvalue,(WSCuchar)0);
#endif
#endif
}

static void m31_work(WSCbase*){
  long i;
  long num = selected_clients.getNum();
  if (num < 1){
    message->setProperty(WSNwidth,500);
    message->setProperty(WSNheight,120);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("v4:WSSTR Please specify a application window to compile."));
    message->setVisible(True);
    return;
  }
  WSClistData plist;
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)selected_clients[i];
    WSCbase* parent = target->getParentWindow();
    if (parent == NULL){
      parent = target;
    }
    long fl = False;
    long j = 0;
    long n = plist.getNum();
    for(j=0; j<n; j++){
      WSCbase* p = (WSCbase*)plist[i];
      if (p == parent){
        fl = True;
        break;
      } 
    }
    if (fl == False){
      plist.add((void*)parent);
    }
  }

extern void icmpl_proc(WSCbase* base);
  num = selected_clients.getNum();
  for(i=0; i<num; i++){
    WSCbase* p = (WSCbase*)plist[i];
    icmpl_proc(p);
  }
}
static void m32_work(WSCbase*){
extern void make_execute();
  make_execute();
}
static void m32c_work(WSCbase*){
  procform->stop();
}


static void m33_work(WSCbase*){
extern void make_execute2();
  make_execute2();
}
static void m34_work(WSCbase*){
extern void make_clean();
  make_clean();
//WSMFtrace("m34----\n");
}

WSCpulldownMenu* pulldownmenu3;
static long test_execute = 0;

static WSDexecute* execute = NULL;
static void m35_work(WSCbase*){
extern char* get_dbg_name();
extern char* get_vproduct_name();
extern char* get_project_dir();
    char buffer[1024];
    long lang = WSGFgetLanguage();
    long ret = 0;
    if (lang == WS_LANG_CPP){
      if (!strcmp(get_project_dir(),"")){
        WSCstring tmp( get_dbg_name() );
#ifdef MacOS
        char buffer[4096];
        getcwd(buffer,sizeof(buffer));
        sprintf(buffer,"%s \"%s/%s\" &",tmp.getString(),buffer,get_vproduct_name());
#else //MacOS
#ifdef BTRON
        sprintf(buffer,"%s %s.out &",tmp.getString(),get_vproduct_name());
#else
        sprintf(buffer,"%s %s &",tmp.getString(),get_vproduct_name());
#endif
#endif //MacOS
      }else{
        WSCstring project_dir = get_project_dir();
#ifndef MSW //for gdb..
        project_dir.replaceString(" ","\\ ",0);
#endif //MSW
        WSCstring tmp( get_dbg_name() );
#ifdef MacOS
        if (!strcmp(".",project_dir.getString())){
          char buffer[4096];
          getcwd(buffer,sizeof(buffer));
          project_dir = buffer;
        }
#endif //MacOS
#ifdef BTRON
        sprintf(buffer,"%s \"%s/%s.out\"",tmp.getString(),project_dir.getString(),get_vproduct_name());
#else
        sprintf(buffer,"%s \"%s/%s\" &",tmp.getString(),project_dir.getString(),get_vproduct_name());
#endif
      }
#ifdef MSW
      ret = _system(buffer);
#else
#ifdef BTRON
extern int btron_system(char*);
      ret = btron_system(buffer);
#else
      ret = system(buffer);
#endif
#endif

    }else
    if (lang == WS_LANG_RUBY){
      create_makefile();
      create_window_srcs();
      WSCstring str( pe->getProjectData("#RUBYD"));
      if (!strcmp(get_project_dir(),"")){
        sprintf(buffer,"%s %s.rb 2>&1",(char*)str,get_vproduct_name());
      }else{
        sprintf(buffer,"%s %s.rb 2>&1",(char*)str,get_vproduct_name());
      }
      WSCstring dir = get_project_dir();
      procform->setProperty(WSNdirName,(char*)dir);
      procform->setProperty(WSNfileName,buffer);
      inspector->setFormVisible(4,True);
//      procform->setVisible(True);
      procform->start();
    }else
    if (lang == WS_LANG_PYTHON){
      create_makefile();
      create_window_srcs();
      WSCstring str( pe->getProjectData("#PYTHOND"));
      if (!strcmp(get_project_dir(),"")){
        sprintf(buffer,"%s %s.py 2>&1",(char*)str,get_vproduct_name());
      }else{
        sprintf(buffer,"%s %s.py 2>&1",(char*)str,get_vproduct_name());
      }
      WSCstring dir = get_project_dir();
      procform->setProperty(WSNdirName,(char*)dir);
      procform->setProperty(WSNfileName,buffer);
      inspector->setFormVisible(4,True);
//      procform->setVisible(True);
      procform->start();
    }else
    if (lang == WS_LANG_PERL){
      create_makefile();
      create_window_srcs();
      WSCstring str( pe->getProjectData("#PERLD"));
      if (!strcmp(get_project_dir(),"")){
        sprintf(buffer,"%s %s.pl 2>&1",(char*)str,get_vproduct_name());
      }else{
        sprintf(buffer,"%s %s.pl 2>&1",(char*)str,get_vproduct_name());
      }
      WSCstring dir = get_project_dir();
      procform->setProperty(WSNdirName,(char*)dir);
      procform->setProperty(WSNfileName,buffer);
      inspector->setFormVisible(4,True);
//      procform->setVisible(True);
      procform->start();
    }else
    if (lang == WS_LANG_JAVA){
#if 0
      create_makefile();
      create_window_srcs();
#endif
      WSCstring str( pe->getProjectData("#JAVA"));
      WSCstring pkgname(pe->getProjectData("#JAVA_PKG_NAME"));
      pkgname.delHeadSpace();
      pkgname.delTailSpace();
      if (!strcmp((char*)pkgname,"")){
        sprintf(buffer,"%s %s 2>&1",(char*)str,get_vproduct_name());
      }else{
        sprintf(buffer,"%s %s.%s 2>&1",(char*)str,(char*)pkgname,get_vproduct_name());
      }
      WSCstring dir = get_project_dir();
      procform->setProperty(WSNdirName,(char*)dir);
      procform->setProperty(WSNlabelString,buffer);
      procform->addString("\n");
      procform->setProperty(WSNfileName,buffer);
      inspector->setFormVisible(4,True);
//      procform->setVisible(True);
      procform->start();
    }else
    if (lang == WS_LANG_OCAML){
      sprintf(buffer,"%s 2>&1",get_vproduct_name());
      WSCstring dir = get_project_dir();
      procform->setProperty(WSNdirName,(char*)dir);
      procform->setProperty(WSNlabelString,buffer);
      procform->addString("\n");
      procform->setProperty(WSNfileName,buffer);
      inspector->setFormVisible(4,True);
//      procform->setVisible(True);
      procform->start();

    }

//printf("ret=%d\n",ret);
    if (ret != 0){
      WSCstring buf;
      buf = "command: ";
      buf << buffer << "\n";
      buf << WSGFgettext("w4:WSSTR Please check the debugger settings or confirm whether the project is built.");
      message->setPropertyV(WSNwidth,(WSCushort)600);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,(char*)buf);
      message->setVisible(True);
    }


}
WSCbool exec_app(){
extern long get_link_type();
  if (get_link_type() != 0 &&
      get_link_type() != 4 ){
     message->setPropertyV(WSNwidth,(WSCushort)450);
     message->setPropertyV(WSNreplyHandler,(void*)NULL);
     message->setPropertyV(WSNlabelString,
       WSGFgettext("x4:WSSTR Can not execute the class library..."));
     message->setVisible(True);
     return False;
  }
  if (test_execute == 0){
extern char* get_project_name();
    if (!strcmp(get_project_name(),"")){
      message->setPropertyV(WSNwidth,(WSCushort)450);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,
        WSGFgettext("y4:WSSTR Can not execute the load module.\nPlease confirm whether the project is collect or built."));
      message->setVisible(True);
      return False;
    }
    if (execute == NULL){
      execute = WSDexecute::getNewInstance();
    }
extern char* get_vproduct_name();
extern char* get_project_dir();
    char buffer[1024];
    long lang = WSGFgetLanguage();
    if (lang == WS_LANG_CPP){
      if (!strcmp(get_project_dir(),"")){
#ifdef BTRON
        sprintf(buffer,"%s.out",get_vproduct_name());
#else
        sprintf(buffer,"%s",get_vproduct_name());
#endif
      }else{
        WSCstring tmp( get_project_dir() );
#ifdef BTRON
        sprintf(buffer,"%s/%s.out",tmp.getString(),get_vproduct_name());
#else
        sprintf(buffer,"%s/%s",tmp.getString(),get_vproduct_name());
#endif
      }
    }else
    if (lang == WS_LANG_RUBY){
      create_makefile();
      create_window_srcs();
      WSCstring str( pe->getProjectData("#RUBY"));
      if (!strcmp(get_project_dir(),"")){
        sprintf(buffer,"%s %s.rb",(char*)str.getString(),get_product_name());
      }else{
//        sprintf(buffer,"%s %s/%s.rb",(char*)str,get_project_dir(),get_product_name());
        sprintf(buffer,"%s %s.rb",(char*)str,get_product_name());
        execute->setCurrentDir(get_project_dir());
      }
    }else
    if (lang == WS_LANG_PYTHON){
      create_makefile();
      create_window_srcs();
      WSCstring str( pe->getProjectData("#PYTHON"));
      if (!strcmp(get_project_dir(),"")){
        sprintf(buffer,"%s %s.py",(char*)str.getString(),get_product_name());
      }else{
//        sprintf(buffer,"%s %s/%s.py",(char*)str,get_project_dir(),get_product_name());
        sprintf(buffer,"%s %s.py",(char*)str,get_product_name());
        execute->setCurrentDir(get_project_dir());
      }
    }else
    if (lang == WS_LANG_PERL){
      create_makefile();
      create_window_srcs();
      WSCstring str( pe->getProjectData("#PERL"));
      if (!strcmp(get_project_dir(),"")){
        sprintf(buffer,"%s %s.pl",(char*)str.getString(),get_product_name());
      }else{
//        sprintf(buffer,"%s %s/%s.pl",(char*)str,get_project_dir(),get_product_name());
        sprintf(buffer,"%s %s.pl",(char*)str,get_product_name());
        execute->setCurrentDir(get_project_dir());
      }
    }else
    if (lang == WS_LANG_JAVA){
#if 0
      create_makefile();
      create_window_srcs();
#endif
      WSCstring str( pe->getProjectData("#JAVA"));
      WSCstring pkgname(pe->getProjectData("#JAVA_PKG_NAME"));
      pkgname.delHeadSpace();
      pkgname.delTailSpace();
      if (!strcmp((char*)pkgname,"")){
        sprintf(buffer,"%s %s",(char*)str.getString(),get_product_name());
      }else{
        sprintf(buffer,"%s %s.%s",(char*)str.getString(),(char*)pkgname,get_product_name());
      }
      if (strcmp(get_project_dir(),"")){
        execute->setCurrentDir(get_project_dir());
      }
    }else
    if (lang == WS_LANG_OCAML){
      sprintf(buffer,"%s",get_product_name());
      if (strcmp(get_project_dir(),"")){
        execute->setCurrentDir(get_project_dir());
      }
    }
    long ret = execute->execute(buffer);
    if (ret == WS_NO_ERR){
      pulldownmenu3->setPropertyV(WSNmenuItems,WS_MENU3_STR2);
      test_execute = 1;
      execbtn->setPropertyV(WSNlabelPixmap, WS_PIXMAP_DIR "runx.xpm");
    }else{
      message->setPropertyV(WSNwidth,(WSCushort)450);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,
        WSGFgettext("y4:WSSTR Can not execute the load module.\nPlease confirm whether the project is collect or built."));
      message->setVisible(True);
      return False;
    }
    return True;
  }else{
    if (execute == NULL){
      return False;
    }
    execute->killProcess();
    pulldownmenu3->setPropertyV(WSNmenuItems,WS_MENU3_STR);
    test_execute = 0;
    execbtn->setPropertyV(WSNlabelPixmap, WS_PIXMAP_DIR "run.xpm");
  }
  return True;
}
static void m36_work(WSCbase*){
extern WSCdialog* tracewin;
  tracewin->setVisible(False);
  exec_app();
}

static void m37_work(WSCbase*){
  long i;
  long num = selected_clients.getNum();
  if (num < 1){
    message->setProperty(WSNwidth,500);
    message->setProperty(WSNheight,120);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("z4:WSSTR Please specify a application window to generate source code."));
    message->setVisible(True);
    return;
  }
  WSClistData plist;
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)selected_clients[i];
    WSCbase* parent = target->getParentWindow();
    if (parent == NULL){
      parent = target;
    }
    long fl = False;
    long j = 0;
    long n = plist.getNum();
    for(j=0; j<n; j++){
      WSCbase* p = (WSCbase*)plist[i];
      if (p == parent){
        fl = True;
        break;
      } 
    }
    if (fl == False){
      plist.add((void*)parent);
    }
  }

extern long create_window_src(WSCbase* win);
  num = selected_clients.getNum();
  for(i=0; i<num; i++){
    WSCbase* p = (WSCbase*)plist[i];
    create_window_src(p);
  }
}

void save_inf_file(){
extern char* get_project_name();
extern void set_project_name(char* prjname,char* dirname);
  if (!strcmp("",get_project_name())){
    question->setPropertyV(WSNwidth,(WSCushort)500);
    question->setPropertyV(WSNheight,(WSCushort)125);
    question->setPropertyV(WSNlabelString,
      WSGFgettext("K4:WSSTR The project has no name.\nName the project and save it?"));
    long ret = question->popup();
    if (ret == WS_DIALOG_OK){
      long ret2 = create_project();
      if (ret2 != WS_NO_ERR){
        return;
      }
      fselect->setPropertyV(WSNfileName,"");
      fselect->setPropertyV(WSNmaskFileName,"prj");
      fselect->setPropertyV(WSNdirName,".");
      long ret = fselect->popup();
      if (ret == WS_DIALOG_OK){
        WSCstring filename(fselect->getProperty(WSNfileName));
        WSCstring dirname(fselect->getProperty(WSNdirName));
        set_project_name((char*)filename,(char*)dirname);
      }else{
        return;
      }
    }else{
      return;
    }
  }

extern WSCstring get_structure_inf(WSClistData*);
  WSCstring data(get_structure_inf(&winlist));
extern char* get_full_project_name();
  WSCstring fname(get_full_project_name());
#ifdef MSW
  fname.replaceString(".PRJ",".txt",1);
#endif
  fname.replaceString(".prj",".txt",1);

  long ret = WSGFreplaceTextFile((char*)fname,data,False);
  if (ret != WS_NO_ERR){
    WSCstring buf;
    buf << WSGFgettext("F4:WSSTR Can not save FILE: ") << fname
        << WSGFgettext("G4:WSSTR  .");
    message->setPropertyV(WSNwidth,(WSCushort)640);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
  }
  return;
}

static void m38_work(WSCbase*){
  save_inf_file();
}
static void m39_work(WSCbase*){
  WSCbool fl = exec_app();
  if (fl != False){
extern char* get_vproduct_name();
    if (!strcmp(get_vproduct_name(),"")){
      return;
    }
extern char* get_project_name();
    if (!strcmp(get_project_name(),"")){
      return;
    }
extern WSCdialog* tracewin;
extern WSCtextField* newtext_000;
    newtext_000->setProperty(WSNlabelString,"");
    newtext_000->update();
    tracewin->setProperty(WSNok,True);
    tracewin->setProperty(WSNno,False);
    tracewin->setVisible(True);
  }
}

//---------------------------------------------------------------
static void m41_work(WSCbase*){
//  plwin->setVisible(True);
extern WSCobjectBox* objectbox;
  objectbox->setVisible(True);
  objectbox->setMapStatus(WS_TOP);
}

static void m42_work(WSCbase*){
  pe->setMenu(2);
  pe->setVisible(True);
  pe->setMapStatus(WS_TOP);
}
static void m43_work(WSCbase*){
  WSCbool tbvis = toolbar->getProperty(WSNvis);
  if (tbvis == False){
    toolbar->setVisible(True);
  }else{
    toolbar->setVisible(False);
  }
extern void adjust_mainwindow(WSCbase*);
  adjust_mainwindow(mainwindow);
}

static void m44_work(WSCbase*){
//WSMFtrace("m44----\n");
extern void exec_search();
exec_search();
}
static void m45_work(WSCbase*){
  WSCstring str( pe->getProjectData("#TERMINAL"));
//printf("m45_work %s\n",(char*)str);
#ifdef MSW
  str << " &";
  _system_console((char*)str);
#else
#ifdef BTRON
extern int btron_system(char*);
  btron_system((char*)str);
#else
  str << " &";
  system((char*)str);
#endif
#endif
}
static void m46_work(WSCbase*){
  inspector->setFormVisible(1,True);
}
static void m47_work(WSCbase*){
  inspector->setFormVisible(2,True);
}
static void m48_work(WSCbase*){
  inspector->setFormVisible(3,True);
}
static void m49_work(WSCbase*){
  WSCbase* clist = inspector->getClassList();
  if (clist->getVisible() == False){
    inspector->setFormVisible(5,True);
    WSCstring* loadstr3 = WSGFreadTextFile("$(WSDIR)/sys/data/classes.dat");
    if (loadstr3 == NULL){
      return;
    }
    WSClist* clist2 = (WSClist*)clist->cast("WSClist");
    if (clist2 != NULL){
      clist2->setProperty(WSNdata,loadstr3->getString());
    }
    delete loadstr3;
  }
  inspector->setFormVisible(5,True);
}
//static void m46_work(WSCbase*){
//WSMFtrace("m46----\n");
//}
//static void m47_work(WSCbase*){
//WSMFtrace("m47----\n");
//}

static void m51_work(WSCbase*){
extern long close_project();
  long ret = close_project();
  if (ret == -1){
     return;
  }
  create_project();
}

static void m52_work(WSCbase*){
//WSMFtrace("m52----\n");
extern void load_project();
  load_project();
}

static void m53_work(WSCbase*){
extern void save_project();
  save_project();
}
static void m54_work(WSCbase*){
//WSMFtrace("m54----\n");
extern void rename_save_project();
  rename_save_project();
}

static void m55_work(WSCbase*){
//WSMFtrace("m55----\n");
extern WSCprojectEditor* pe;
  pe->setVisible(True);
  pe->setMapStatus(WS_TOP);
}
static void m56_work(WSCbase*){
//WSMFtrace("m56----\n");
extern long close_project();
  close_project();
}
//static void m57_work(WSCbase*){
//WSMFtrace("m57----\n");
//}

//---------------------------------------------------------------
static void m61_work(WSCbase*){
  pe->setVisible(True);
  pe->setMenu(1);
  pe->setMapStatus(WS_TOP);
}
static void m62_work(WSCbase*){
  WSGIappColorSelect()->setVisible(True);
  WSGIappColorSelect()->setMapStatus(WS_TOP);
}

static void m63_work(WSCbase*){
  pe->setVisible(True);
  pe->setMenu(5);
  pe->setMapStatus(WS_TOP);
}

static void m64_work(WSCbase*){

extern void policy_select_popup();
  policy_select_popup();
#if 0
extern WSCdialog* policy_select;
extern WSCvradio* polvrad_002;
extern WSCvradio* polvrad_003;
extern WSCvradio* polvrad_000;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    polvrad_002->setStatus(True);
  }
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    polvrad_003->setStatus(True);
  }
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_GRADATION){
    polvrad_000->setStatus(True);
  }else{
    polvrad_000->setStatus(False);
  }
  long ret = policy_select->popup();
  if (ret == WS_DIALOG_OK){
    long st1 = polvrad_002->getStatus();
    long st2 = polvrad_000->getStatus();
    long policy = 0;
    if (st1 != False){
      policy = WS_POLICY_ORIGINAL;
    }else{
      policy = WS_POLICY_WINDOWS;
    }
    if (st2 != False){
      policy |= WS_POLICY_GRADATION;
    }
    WSGIappDev()->setGuiPolicy(policy,True);
//extern void _gui_policy_change();
//    _gui_policy_change();
//extern void adjust_mainwindow(WSCbase*);
//    adjust_mainwindow(mainwindow);
    WSGIappDev()->saveGuiPolicy();
  }
#endif
}

static void m65_work(WSCbase*){
#if 0
//WSMFtrace("m65----\n");
extern WSCcolorList* clist;
  WSCstring str;
  str.setString( project->getProjectName() );
  str.delHeadSpace();
  str.delTailSpace();
  clist->setPropertyV(WSNfileName, str.getString() );
  clist->setVisible(True);
#endif
}
static void m66_work(WSCbase*){
#if 0
extern WSCmouseList* mlist;
  WSCstring str;
  str.setString( project->getProjectName() );
  str.delHeadSpace();
  str.delTailSpace();
  mlist->setPropertyV(WSNfileName, str.getString() );
  mlist->setVisible(True);
#endif
}
//static void m67_work(WSCbase*){
//WSMFtrace("m67----\n");
//}

//---------------------------------------------------------------
//static void m71_work(WSCbase*){
//}
//static void m72_work(WSCbase*){
//}
//static void m73_work(WSCbase*){
//}
//static void m74_work(WSCbase*){
//}
//static void m75_work(WSCbase*){
//}
//static void m76_work(WSCbase*){
//}
//static void m77_work(WSCbase*){
//}

//---------------------------------------------------------------
extern WSCbool get_wait_for_lock();
static void m81_work(WSCbase*){
  if (get_wait_for_lock() != False){
    return;
  }
  WSCstring str( pe->getProjectData("#WEBB_NAME"));
  WSCstring loc = WSGIappLocaleSet()->getSystemLocaleName();
  if (!strcmp((char*)loc,"C")){
    loc = "en_US";
  }
  WSCstring fcheck;
  fcheck <<  "$(WSDIR)/doc/" << loc << "/index.html";
  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)fcheck)) == False){
    loc = "en_US";
  }
  WSCstring fname;
  fname <<  "\"file://$(WSDIR)/doc/" << loc <<
     "/index.html\"";
  str << " " << WSGIappFileSystem()->adjustFileName((char*)fname) <<" &";

//printf("m81_work.. %s\n",(char*)str);
#ifdef MSW
  _system((char*)str);
#else
#ifdef BTRON
//nop...
#else
  system((char*)str);
#endif
#endif
extern void wait_for(char*);
  wait_for(WSGFgettext("A4:WSSTR Please wait for a while to start web browser.."));
}
static void m82_work(WSCbase*){
  if (get_wait_for_lock() != False){
    return;
  }
  WSCstring str( pe->getProjectData("#WEBB_NAME"));
  WSCstring loc = WSGIappLocaleSet()->getSystemLocaleName();
  if (!strcmp((char*)loc,"C")){
    loc = "en_US";
  }
  WSCstring fcheck;
  fcheck <<  "$(WSDIR)/doc/" << loc << "/ht-ref/objects.html";
  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)fcheck)) == False){
    loc = "en_US";
  }
  WSCstring fname;
  fname <<  "\"file://$(WSDIR)/doc/" << loc << "/ht-ref/objects.html\"";
  str << " " << WSGIappFileSystem()->adjustFileName((char*)fname) <<" &";
#ifdef MSW
  _system((char*)str);
#else
#ifdef BTRON
//nop...
#else
  system((char*)str);
#endif
#endif
extern void wait_for(char*);
  wait_for(WSGFgettext("A4:WSSTR Please wait for a while to start web browser.."));
}
static void m83_work(WSCbase*){
  if (get_wait_for_lock() != False){
    return;
  }
  WSCstring str( pe->getProjectData("#WEBB_NAME"));

  WSCstring loc = WSGIappLocaleSet()->getSystemLocaleName();
  if (!strcmp((char*)loc,"C")){
    loc = "en_US";
  }
  WSCstring fcheck;
  fcheck <<  "$(WSDIR)/doc/" << loc << "/builder-doc/builder.html";
  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)fcheck)) == False){
    loc = "en_US";
  }
  WSCstring fname;
  fname <<  "\"file://$(WSDIR)/doc/" << loc << "/builder-doc/builder.html\"";
  str << " " << WSGIappFileSystem()->adjustFileName((char*)fname) <<" &";

#ifdef MSW
  _system((char*)str);
#else
#ifdef BTRON
//nop...
#else
  system((char*)str);
#endif
#endif
extern void wait_for(char*);
  wait_for(WSGFgettext("A4:WSSTR Please wait for a while to start web browser.."));
}
static void m84_work(WSCbase*){
  WSCstring* str = WSGFreadTextFile("$(WSDIR)/sys/data/copyright");
  if (str != NULL){
    message->setProperty(WSNlabelString,*str);
    delete str;
    message->setProperty(WSNwidth,500);
    message->setProperty(WSNheight,450);
    message->setProperty(WSNalignmentH,WS_LEFT);
    message->popup();
    message->setProperty(WSNheight,120);
  }
}
static void m85_work(WSCbase*){
extern void show_license();
  show_license();
}
//static void m86_work(WSCbase*){
//WSMFtrace("m86----\n");
//}
//static void m87_work(WSCbase*){
//WSMFtrace("m87----\n");
//}

static WSCform* menuarea;
static WSCform* menuarea2;
//static WSCform* statusbar;
static WSCpulldownMenu* pulldownmenu8;

void adjust_mainwindow(WSCbase*){
  WSCushort h,w;
  mainwindow->getPropertyV(WSNwidth,&w);
  mainwindow->getPropertyV(WSNheight,&h);

  if (w > 2){
    if(toolbar->getFloated() == False){
      spm->setVisible(True);
      menuarea2->setProperty(WSNy,0);
      menuarea2->setProperty(WSNheight,WS_TB_HEIGHT-2);
      menuarea2->setProperty(WSNwidth,w + 100);
      toolbar->setPropertyV(WSNshadowThickness,(WSCuchar)0);
//      toolbar->setProperty(WSNshadowType,WS_SHADOW_EIN);
      toolbar->setPropertyV(WSNwidth,(WSCushort)(w + 100));
    }else{
      spm->setVisible(False);
      menuarea2->setProperty(WSNy,2);
      menuarea2->setProperty(WSNheight,WS_TB_HEIGHT-4);
      menuarea2->setProperty(WSNwidth,toolbarw -14);
      toolbar->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      toolbar->setProperty(WSNshadowType,WS_SHADOW_OUT);
      toolbar->setPropertyV(WSNwidth,toolbarw);
    }
    menuarea->setPropertyV(WSNwidth,(WSCushort)(w));
    inspector->setPropertyV(WSNwidth,(WSCushort)(w -2));

    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      if ((w - WS_LB_W8 - 10) >
            (WS_LB_XOFFSET + WS_LB_W1 + WS_LB_W2 +
             WS_LB_W3 + WS_LB_W4 + WS_LB_W5 + WS_LB_W6)){
        pulldownmenu8->setPropertyV(WSNx,(short)(w - WS_LB_W8 - 10));
      }else{
        pulldownmenu8->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1 +
                       WS_LB_W2 + WS_LB_W3 + WS_LB_W4 + WS_LB_W5 + WS_LB_W6));
      }
      menuarea->redraw();
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      pulldownmenu8->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1 +
                       WS_LB_W2 + WS_LB_W3 + WS_LB_W4 + WS_LB_W5 + WS_LB_W6));
    }
  }else{
    toolbar->setPropertyV(WSNwidth,(WSCushort)(1));
    menuarea->setPropertyV(WSNwidth,(WSCushort)(1));
    inspector->setPropertyV(WSNwidth,(WSCushort)(1));
    pulldownmenu8->setPropertyV(WSNx,(short)(1));
  }
  long diff = 0;

  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 18;
  }
  
  show_prj1->setProperty(WSNx,3);
  show_prj1->setProperty(WSNy,h-20);
  show_prj2->setProperty(WSNx,111);
  show_prj2->setProperty(WSNy,h-20);
  show_prj2->setProperty(WSNwidth,153);
  show_dir1->setProperty(WSNx,267);
  show_dir1->setProperty(WSNy,h-20);
  show_dir2->setProperty(WSNx,370);
  show_dir2->setProperty(WSNy,h-20);
  show_dir2->setProperty(WSNwidth,w - 372 - 50);

//  mainwindow->setProperty(WSNmarginLeft,w - 100);

  WSCbool tbvis = toolbar->getProperty(WSNvis);
  if (tbvis == False || toolbar->getFloated() != False){
    inspector->setPropertyV(WSNy,(short)(WS_LB_AHEIGHT +1));
    if (h > 40 + WS_LB_AHEIGHT){
      inspector->setPropertyV(WSNheight,(WSCushort)(h -40 +diff - WS_LB_AHEIGHT));
    }else{
      inspector->setPropertyV(WSNheight,(WSCushort)(1));
    } 
  }else{
    inspector->setPropertyV(WSNy,(short)(WS_LB_AHEIGHT + WS_TB_HEIGHT +1));
    if (h > 40 + WS_LB_AHEIGHT + WS_TB_HEIGHT){
      inspector->setPropertyV(WSNheight,(WSCushort)(h -40 +diff - WS_LB_AHEIGHT - WS_TB_HEIGHT));
    }else{
      inspector->setPropertyV(WSNheight,(WSCushort)(1));
    } 
  }
  mainwindow->redraw();
}
long delay_adjust_flag = 0;
void delay_adjust_mainwindow_work(WSCuchar clk,void*){
  adjust_mainwindow(mainwindow);
  delay_adjust_flag = 0;
}

void delay_adjust_mainwindow(WSCbase*){
  if (delay_adjust_flag == 0){
    delay_adjust_flag = 1;
    WSGIappTimer()->addTriggerProc(delay_adjust_mainwindow_work,WS250MS,NULL);
  }
}
void toolbar_adjust(WSCbase*){
  adjust_mainwindow(mainwindow);
}
void _gui_policy_ch(WSCbase*){
extern void _gui_policy_change();
  _gui_policy_change();
  adjust_mainwindow(mainwindow);
}
void create_main_window(){
//    WSCushort window_width = WSGIappDev()->getWidth();
  WSCushort window_width = 680;

  mainwindow = new  WSCbaseDialog(NULL,"mainwindow");
  mainwindow->initialize();
  mainwindow->setPropertyV(WSNx,(short)400);
  mainwindow->setPropertyV(WSNy,(short)100);
  mainwindow->setPropertyV(WSNwidth,(WSCushort)window_width);
  mainwindow->setPropertyV(WSNheight,(WSCushort)WS_LB_HEIGHT);
//TEST
  mainwindow->setPropertyV(WSNshadowThickness,(WSCuchar)0);
//  mainwindow->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  mainwindow->setPropertyV(WSNforeColor,"gray75");
//  mainwindow->setPropertyV(WSNbackColor,"gray80");
//  mainwindow->setPropertyV(WSNtopShadowColor,"gray95");
//  mainwindow->setPropertyV(WSNbottomShadowColor,"gray55");
  mainwindow->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  mainwindow->setPropertyV(WSNtitleString,WS_BUILDER_TITLE);
  mainwindow->setPropertyV(WSNlabelPixmap, WS_BUILDER_PIX );
  mainwindow->setPropertyV(WSNok,(WSCbool)False);
  mainwindow->setPropertyV(WSNno,(WSCbool)False);
  mainwindow->setProperty(WSNbarThickness,18);
//  mainwindow->setProperty(WSNemboss,True);
  mainwindow->setProperty(WSNindicatorOn,True);

  WSCprocedure* pch = new WSCprocedure("pch",WSEV_GUI_POLICY_CH);
  pch->setFunction(_gui_policy_ch,"_gui_policy_ch");
  mainwindow->addProcedure(pch);



  //ä줿Ȥӥνλ
  WSCprocedure* mexit = new WSCprocedure("mexit",WSEV_VISIBLE_CH);
  mexit->setFunction(m16_work2,"m16_work2");
  mainwindow->addProcedure(mexit);

  WSCprocedure* mresize = new WSCprocedure("mexit",WSEV_RESIZE);
  mresize->setFunction(delay_adjust_mainwindow,"delay_adjust_mainwindow");
  mainwindow->addProcedure(mresize);

  show_prj1 = new WSCvlabel(mainwindow,"show_prj1");
  show_prj1->initialize();
  WSGFsetGeometry(show_prj1,3,5,105,18);
  show_prj1->setProperty(WSNlabelString,"PROJECT:");
  show_prj1->setProperty(WSNshadowType,WS_SHADOW_IN);
  show_prj1->setProperty(WSNshadowThickness,1);
  show_prj1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  show_prj1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  show_prj1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  show_prj1->setProperty(WSNalignmentH,WS_LEFT);

  show_prj2 = new WSCvlabel(mainwindow,"show_prj2");
  show_prj2->initialize();
  WSGFsetGeometry(show_prj2,5,5,100,18);
  show_prj2->setProperty(WSNlabelString,"");
  show_prj2->setProperty(WSNshadowType,WS_SHADOW_IN);
  show_prj2->setProperty(WSNshadowThickness,1);
  show_prj2->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  show_prj2->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  show_prj2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  show_prj2->setProperty(WSNalignmentH,WS_LEFT);

  show_dir1 = new WSCvlabel(mainwindow,"show_dir1");
  show_dir1->initialize();
  WSGFsetGeometry(show_dir1,5,5,100,18);
  show_dir1->setProperty(WSNlabelString,"DIR:");
  show_dir1->setProperty(WSNshadowType,WS_SHADOW_IN);
  show_dir1->setProperty(WSNshadowThickness,1);
  show_dir1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  show_dir1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  show_dir1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  show_dir1->setProperty(WSNalignmentH,WS_LEFT);

  show_dir2 = new WSCvlabel(mainwindow,"show_dir2");
  show_dir2->initialize();
  WSGFsetGeometry(show_dir2,5,5,100,18);
  show_dir2->setProperty(WSNlabelString,"");
  show_dir2->setProperty(WSNshadowType,WS_SHADOW_IN);
  show_dir2->setProperty(WSNshadowThickness,1);
  show_dir2->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  show_dir2->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  show_dir2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  show_dir2->setProperty(WSNalignmentH,WS_LEFT);

  toolbar = new WSCfform(mainwindow,"toolbar");
  toolbar->initialize();
  toolbar->setPropertyV(WSNx,(short)-2);
  toolbar->setPropertyV(WSNy,(short)(WS_LB_AHEIGHT+1));
  toolbar->setPropertyV(WSNwidth,(WSCushort)644);
  toolbar->setPropertyV(WSNheight,(WSCushort)WS_TB_HEIGHT);
//  toolbar->setPropertyV(WSNshadowThickness,(WSCuchar)2);
  toolbar->setPropertyV(WSNshadowThickness,(WSCuchar)0);
//  toolbar->setProperty(WSNshadowType,WS_SHADOW_EIN);
  toolbar->setProperty(WSNindicatorOn,False);
//  toolbar->setPropertyV(WSNbackColor,"gray80");
//  toolbar->setPropertyV(WSNtopShadowColor,"gray95");
//  toolbar->setPropertyV(WSNbottomShadowColor,"gray55");
  toolbar->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  toolbar->setVisible(True);



  WSCprocedure* ac_t = new WSCprocedure("statusch",WSEV_STATUS_CH);
  ac_t->setFunction(toolbar_adjust,"statusch");
  toolbar->addProcedure(ac_t);

  menuarea2 = new  WSCform(toolbar,"lb-menuarea");
  menuarea2->initialize();
  menuarea2->setPropertyV(WSNx,(short)10);
  menuarea2->setPropertyV(WSNy,(short)0);
  menuarea2->setPropertyV(WSNwidth,(WSCushort)(window_width));
  menuarea2->setPropertyV(WSNheight,(WSCushort)WS_TB_HEIGHT);
  menuarea2->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  menuarea2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  menuarea2->setVisible(True);

  spm = new WSCvlabel(toolbar,"sepa");
  spm->initialize();
  spm->setProperty(WSNx,0);
  spm->setProperty(WSNy,WS_TB_HEIGHT -2);
  spm->setProperty(WSNwidth,window_width);
  spm->setProperty(WSNheight,2);
  spm->setProperty(WSNshadowType,WS_SHADOW_EIN);
  spm->setProperty(WSNanchorLeftFlag,True);
  spm->setProperty(WSNanchorLeft,0);
  spm->setProperty(WSNanchorRightFlag,True);
  spm->setProperty(WSNanchorRight,0);
  spm->setVisible(True);

  long i;
  long diff = 0;
  for(i=0; i < LBTNS; i++){
    if (sepa[i] == 1){
      diff += 4;
      WSCvlabel* sp1 = new WSCvlabel(menuarea2,"sepa");
      sp1->initialize();
      sp1->setPropertyV(WSNx,(short)(i*(WS_TB_WIDTH+2) + diff));
      sp1->setPropertyV(WSNy,(short)0);
      sp1->setPropertyV(WSNwidth,(WSCushort)2);
      sp1->setPropertyV(WSNheight,(WSCushort)(WS_TB_WIDTH -4));
      sp1->setPropertyV(WSNshadowThickness,1);
      sp1->setPropertyV(WSNshadowType,WS_SHADOW_IN);
      sp1->setVisible(True);
    }
    WSCvfbtn* bt1 = new WSCvfbtn(menuarea2,"bt1");
    bt1->initialize();
    bt1->setPropertyV(WSNx,(short)(4+i*(WS_TB_WIDTH+2) + diff));
    bt1->setPropertyV(WSNy,(short)0);
    bt1->setPropertyV(WSNwidth,(WSCushort)(WS_TB_WIDTH));
    bt1->setPropertyV(WSNheight,(WSCushort)(WS_TB_WIDTH -2));
    bt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//    bt1->setPropertyV(WSNbackColor,"gray80");
    bt1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    bt1->setPropertyV(WSNlabelPixmap,pixmaps[i]);
    WSGFsetMargin(bt1,0);
//printf("%s\n",pixmaps[i]);
    bt1->setVisible(True);
    WSGIappBalloonHelp()->registerClient(bt1,WSGFgettext(bhelpstr[i]));
    if (EXEC_BTN == i){
      execbtn = bt1;
      execbtn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "run2.xpm");
      execbtn->setSensitive(False);
    }
    if (BUILD_BTN == i){
      build_btn = bt1;
      build_btn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "make2.xpm");
      build_btn->setSensitive(False);
    }
    if (BUILD_CANCEL_BTN == i){
      build_cancel_btn = bt1;
      build_cancel_btn->setProperty(WSNlabelPixmap,WS_PIXMAP_DIR "makec2.xpm");
      build_cancel_btn->setSensitive(False);
    }
    WSCprocedure* ac = new WSCprocedure("btproc",WSEV_ACTIVATE);
    ac->setFunction(btnprocs[i],"btnproc");
    bt1->addProcedure(ac);
  }
  toolbarw = i * (WS_TB_WIDTH + 2) + diff + WS_TB_WIDTH -2;

  inspector = new  WSCinspector(mainwindow,"inspector");
  inspector->initialize();
  inspector->setPropertyV(WSNx,(short)1);
  inspector->setPropertyV(WSNy,(short)(WS_LB_AHEIGHT+1));
  inspector->setPropertyV(WSNwidth,(WSCushort)640);
  inspector->setPropertyV(WSNheight,(WSCushort)450);
  inspector->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  inspector->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  inspector->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  inspector->setPropertyV(WSNbarThickness,(WSCushort)5);
  inspector->setProperty(WSNmarginTop,2);
  inspector->setProperty(WSNmarginLeft,0);
  inspector->setProperty(WSNmarginRight,0);
  inspector->setProperty(WSNmarginBottom,0);
  inspector->setPropertyV(WSNbarValue,"150,300,150,200");
  inspector->setVisible(True);
  extern char* get_project_dir();
  inspector->setGetDirHandler((void*)get_project_dir);
  extern void editor_execute(WSCprocedureEditor*,char*);
  inspector->setEditorExecuteHandler((void*)editor_execute);
  inspector->setFormVisible(1,False);
  inspector->setFormVisible(4,False);

  inspector->setClients(&winlist);
  inspector->setSelectedClientList(&selected_clients);
extern void load_project_handler(WSCinspector*,char*);
  inspector->setLoadProjectHandler(load_project_handler);
extern char* get_ext_files_handler();
  inspector->setExternalSourceFilesHandler((void*)get_ext_files_handler);
  
  WSGFsetAppPropertyEditor(inspector->getPropertyEditor());

  extern void icopy_work(WSCbase*);
  WSCprocedure* iop1 = new WSCprocedure("COPY",WSEV_NONE);
  iop1->setFunction(icopy_work,"icopy_work");
  inspector->addProcedure(iop1);

  extern void ipaste_work(WSCbase*);
  WSCprocedure* iop2 = new WSCprocedure("PASTE",WSEV_NONE);
  iop2->setFunction(ipaste_work,"ipaste_work");
  inspector->addProcedure(iop2);

  extern void isearch_work(WSCbase*);
  WSCprocedure* iop3 = new WSCprocedure("SEARCH",WSEV_NONE);
  iop3->setFunction(isearch_work,"isearch_work");
  inspector->addProcedure(iop3);

  extern void iprj_work(WSCbase*);
  WSCprocedure* iop4 = new WSCprocedure("PRJ",WSEV_NONE);
  iop4->setFunction(iprj_work,"iprj_work");
  inspector->addProcedure(iop4);

  extern void icmpl_work(WSCbase*);
  WSCprocedure* iop5 = new WSCprocedure("COMP",WSEV_NONE);
  iop5->setFunction(icmpl_work,"icmpl_work");
  inspector->addProcedure(iop5);

  extern void isave_work(WSCbase*);
  WSCprocedure* iop6 = new WSCprocedure("SAVE",WSEV_NONE);
  iop6->setFunction(isave_work,"isave_work");
  inspector->addProcedure(iop6);

  extern void idel_work(WSCbase*);
  WSCprocedure* iop7 = new WSCprocedure("DEL",WSEV_NONE);
  iop7->setFunction(idel_work,"idel_work");
  inspector->addProcedure(iop7);

  WSCpopupMenu* pmenu = new WSCpopupMenu(NULL,"menu");
  pmenu->initialize();
  pmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  pmenu->setPropertyV(WSNmenuItems,"new instance:NEW_INST::,help:HELP_INST::");
  pmenu->setEmboss(True);
  WSCprocedure* op00 = new WSCprocedure("NEW_INST",WSEV_NONE);
  op00->setFunction(_new_instance,"_new_instance");
  pmenu->addProcedure(op00);
  WSCprocedure* op01 = new WSCprocedure("HELP_INST",WSEV_NONE);
  op01->setFunction(_help_instance,"_help_instance");
  pmenu->addProcedure(op01);
  WSCbase* clist = inspector->getClassList();
  clist->addProcedureV("clist_item_selected","clist_item_selected",_clist_item_selected,WSEV_ITEM_PRE_SELECTED);
  pmenu->addProcedureV("pmenu_popuped","pmenu_popuped",_pmenu_popuped,WSEV_VISIBLE_CH);

  WSClist* clist2 = (WSClist*)clist->cast("WSClist");
  pmenu->registerClient(clist2->getScrFrame());

//  menuarea = new  WSCform(mainwindow,"lb-menuarea");
  menuarea = new  WSCmenuArea(mainwindow,"lb-menuarea");
  menuarea->initialize();
  menuarea->setPropertyV(WSNx,(short)0);
  menuarea->setPropertyV(WSNy,(short)0);
  menuarea->setPropertyV(WSNwidth,(WSCushort)(window_width));
  menuarea->setPropertyV(WSNheight,(WSCushort)WS_LB_AHEIGHT);
//TEST
  menuarea->setPropertyV(WSNshadowThickness,(WSCuchar)0);
//  menuarea->setPropertyV(WSNforeColor,"gray75");
//  menuarea->setPropertyV(WSNbackColor,"gray80");
//  menuarea->setPropertyV(WSNtopShadowColor,"gray95");
//  menuarea->setPropertyV(WSNbottomShadowColor,"gray55");
//  menuarea->setProperty(WSNforeColor,WS_DF_MENUFORECOLOR);
//  menuarea->setProperty(WSNbackColor,WS_DF_MENUBACKCOLOR);
//  menuarea->setProperty(WSNtopShadowColor,WS_DF_MENUTOPSHADOWCOLOR);
//  menuarea->setProperty(WSNbottomShadowColor,WS_DF_MENUBOTTOMSHADOWCOLOR);
  menuarea->setVisible(True);

  WSCpulldownMenu* pulldownmenu1 = new WSCpulldownMenu(menuarea,"mb-pulldown-1");
  pulldownmenu1->initialize();
  pulldownmenu1->setPropertyV(WSNx,(short)WS_LB_XOFFSET);
  pulldownmenu1->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu1->setPropertyV(WSNwidth,(WSCushort)WS_LB_W1);
  pulldownmenu1->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu1->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu1->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu1->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu1->setPropertyV(WSNlabelString,WS_MENU1_LB);
  pulldownmenu1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu1->setPropertyV(WSNmenuItems,WS_MENU1_STR);
  pulldownmenu1->setProperty(WSNshortcut,"F");
  pulldownmenu1->setProperty(WSNitemHeight,24);
  pulldownmenu1->setVisible(True);

  WSCprocedure* m11 = new WSCprocedure("m11",WSEV_NONE);
  m11->setFunction(m11_work,"m11_work");
  pulldownmenu1->addProcedure(m11);

  WSCprocedure* m12 = new WSCprocedure("m12",WSEV_NONE);
  m12->setFunction(m12_work,"m12_work");
  pulldownmenu1->addProcedure(m12);

  WSCprocedure* m13 = new WSCprocedure("m13",WSEV_NONE);
  m13->setFunction(m13_work,"m13_work");
  pulldownmenu1->addProcedure(m13);

  WSCprocedure* m14 = new WSCprocedure("m14",WSEV_NONE);
  m14->setFunction(m14_work,"m14_work");
  pulldownmenu1->addProcedure(m14);

  WSCprocedure* m15 = new WSCprocedure("m15",WSEV_NONE);
  m15->setFunction(m15_work,"m15_work");
  pulldownmenu1->addProcedure(m15);

  WSCprocedure* m16 = new WSCprocedure("m16",WSEV_NONE);
  m16->setFunction(m16_work,"m16_work");
  pulldownmenu1->addProcedure(m16);

  WSCprocedure* m17 = new WSCprocedure("m17",WSEV_NONE);
  m17->setFunction(m17_work,"m17_work");
  pulldownmenu1->addProcedure(m17);

//----------------------------------------------------------------

  WSCpulldownMenu* pulldownmenu2 = new WSCpulldownMenu(menuarea,"mb-pulldown-2");
  pulldownmenu2->initialize();
  pulldownmenu2->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1));
  pulldownmenu2->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu2->setPropertyV(WSNwidth,(WSCushort)WS_LB_W2);
  pulldownmenu2->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu2->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu2->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu2->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu2->setPropertyV(WSNlabelString,WS_MENU2_LB);
  pulldownmenu2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu2->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu2->setPropertyV(WSNmenuItems,WS_MENU2_STR);
  pulldownmenu2->setProperty(WSNshortcut,"E");
  pulldownmenu2->setVisible(True);

  WSCprocedure* m21 = new WSCprocedure("m21",WSEV_NONE);
  m21->setFunction(m21_work,"m21_work");
  pulldownmenu2->addProcedure(m21);

  WSCprocedure* m22 = new WSCprocedure("m22",WSEV_NONE);
  m22->setFunction(m22_work,"m22_work");
  pulldownmenu2->addProcedure(m22);

  WSCprocedure* m23 = new WSCprocedure("m23",WSEV_NONE);
  m23->setFunction(m23_work,"m23_work");
  pulldownmenu2->addProcedure(m23);

  WSCprocedure* m24 = new WSCprocedure("m24",WSEV_NONE);
  m24->setFunction(m24_work,"m24_work");
  pulldownmenu2->addProcedure(m24);

  WSCprocedure* m25 = new WSCprocedure("m25",WSEV_NONE);
  m25->setFunction(m25_work,"m25_work");
  pulldownmenu2->addProcedure(m25);

  WSCprocedure* m251 = new WSCprocedure("m251",WSEV_NONE);
  m251->setFunction(m251_work,"m251_work");
  pulldownmenu2->addProcedure(m251);

  WSCprocedure* m252 = new WSCprocedure("m252",WSEV_NONE);
  m252->setFunction(m252_work,"m252_work");
  pulldownmenu2->addProcedure(m252);

  WSCprocedure* m253 = new WSCprocedure("m253",WSEV_NONE);
  m253->setFunction(m253_work,"m253_work");
  pulldownmenu2->addProcedure(m253);

  WSCprocedure* m254 = new WSCprocedure("m254",WSEV_NONE);
  m254->setFunction(m254_work,"m254_work");
  pulldownmenu2->addProcedure(m254);

  WSCprocedure* m26 = new WSCprocedure("m26",WSEV_NONE);
  m26->setFunction(m26_work,"m26_work");
  pulldownmenu2->addProcedure(m26);

  WSCprocedure* m27 = new WSCprocedure("m27",WSEV_NONE);
  m27->setFunction(m27_work,"m27_work");
  pulldownmenu2->addProcedure(m27);

  WSCprocedure* m28 = new WSCprocedure("m28",WSEV_NONE);
  m28->setFunction(m28_work,"m28_work");
  pulldownmenu2->addProcedure(m28);

  WSCprocedure* m29 = new WSCprocedure("m29",WSEV_NONE);
  m29->setFunction(m29_work,"m29_work");
  pulldownmenu2->addProcedure(m29);

  WSCprocedure* m291 = new WSCprocedure("m291",WSEV_NONE);
  m291->setFunction(m291_work,"m291_work");
  pulldownmenu2->addProcedure(m291);

  WSCprocedure* m2_vis = new WSCprocedure("m2_vis",WSEV_MENU_POPUP);
  m2_vis->setFunction(m2_vis_work,"m2_vis_work");
  pulldownmenu2->addProcedure(m2_vis);

//----------------------------------------------------------------

  pulldownmenu3 = new WSCpulldownMenu(menuarea,"mb-pulldown-3");
  pulldownmenu3->initialize();
  pulldownmenu3->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1 + WS_LB_W2));
  pulldownmenu3->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu3->setPropertyV(WSNwidth,(WSCushort)WS_LB_W3);
  pulldownmenu3->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu3->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu3->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu3->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu3->setPropertyV(WSNlabelString,WS_MENU3_LB);
  pulldownmenu3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu3->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu3->setPropertyV(WSNmenuItems,WS_MENU3_STR);
  pulldownmenu3->setProperty(WSNshortcut,"B");
  pulldownmenu3->setProperty(WSNitemHeight,24);
  pulldownmenu3->setVisible(True);

  WSCprocedure* m31 = new WSCprocedure("m31",WSEV_NONE);
  m31->setFunction(m31_work,"m31_work");
  pulldownmenu3->addProcedure(m31);

  WSCprocedure* m32 = new WSCprocedure("m32",WSEV_NONE);
  m32->setFunction(m32_work,"m32_work");
  pulldownmenu3->addProcedure(m32);

  WSCprocedure* m33 = new WSCprocedure("m33",WSEV_NONE);
  m33->setFunction(m33_work,"m33_work");
  pulldownmenu3->addProcedure(m33);

  WSCprocedure* m34 = new WSCprocedure("m34",WSEV_NONE);
  m34->setFunction(m34_work,"m34_work");
  pulldownmenu3->addProcedure(m34);

  WSCprocedure* m35 = new WSCprocedure("m35",WSEV_NONE);
  m35->setFunction(m35_work,"m35_work");
  pulldownmenu3->addProcedure(m35);

  WSCprocedure* m36 = new WSCprocedure("m36",WSEV_NONE);
  m36->setFunction(m36_work,"m36_work");
  pulldownmenu3->addProcedure(m36);

  WSCprocedure* m37 = new WSCprocedure("m37",WSEV_NONE);
  m37->setFunction(m37_work,"m37_work");
  pulldownmenu3->addProcedure(m37);

  WSCprocedure* m38 = new WSCprocedure("m38",WSEV_NONE);
  m38->setFunction(m38_work,"m38_work");
  pulldownmenu3->addProcedure(m38);

  WSCprocedure* m39 = new WSCprocedure("m39",WSEV_NONE);
  m39->setFunction(m39_work,"m39_work");
  pulldownmenu3->addProcedure(m39);

//----------------------------------------------------------------

  WSCpulldownMenu* pulldownmenu4 = new WSCpulldownMenu(menuarea,"mb-pulldown-4");
  pulldownmenu4->initialize();
  pulldownmenu4->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1 + WS_LB_W2 + WS_LB_W3));
  pulldownmenu4->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu4->setPropertyV(WSNwidth,(WSCushort)WS_LB_W4);
  pulldownmenu4->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu4->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu4->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu4->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu4->setPropertyV(WSNlabelString,WS_MENU4_LB);
  pulldownmenu4->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu4->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu4->setPropertyV(WSNmenuItems,WS_MENU4_STR);
  pulldownmenu4->setProperty(WSNshortcut,"V");
  pulldownmenu4->setProperty(WSNitemHeight,24);
  pulldownmenu4->setVisible(True);

  WSCprocedure* m41 = new WSCprocedure("m41",WSEV_NONE);
  m41->setFunction(m41_work,"m41_work");
  pulldownmenu4->addProcedure(m41);

  WSCprocedure* m42 = new WSCprocedure("m42",WSEV_NONE);
  m42->setFunction(m42_work,"m42_work");
  pulldownmenu4->addProcedure(m42);

  WSCprocedure* m43 = new WSCprocedure("m43",WSEV_NONE);
  m43->setFunction(m43_work,"m43_work");
  pulldownmenu4->addProcedure(m43);

  WSCprocedure* m44 = new WSCprocedure("m44",WSEV_NONE);
  m44->setFunction(m44_work,"m44_work");
  pulldownmenu4->addProcedure(m44);

  WSCprocedure* m45 = new WSCprocedure("m45",WSEV_NONE);
  m45->setFunction(m45_work,"m45_work");
  pulldownmenu4->addProcedure(m45);

  WSCprocedure* m46 = new WSCprocedure("m46",WSEV_NONE);
  m46->setFunction(m46_work,"m46_work");
  pulldownmenu4->addProcedure(m46);

  WSCprocedure* m47 = new WSCprocedure("m47",WSEV_NONE);
  m47->setFunction(m47_work,"m47_work");
  pulldownmenu4->addProcedure(m47);

  WSCprocedure* m48 = new WSCprocedure("m48",WSEV_NONE);
  m48->setFunction(m48_work,"m48_work");
  pulldownmenu4->addProcedure(m48);

  WSCprocedure* m49 = new WSCprocedure("m49",WSEV_NONE);
  m49->setFunction(m49_work,"m49_work");
  pulldownmenu4->addProcedure(m49);

//----------------------------------------------------------------

  WSCpulldownMenu* pulldownmenu5 = new WSCpulldownMenu(menuarea,"mb-pulldown-5");
  pulldownmenu5->initialize();
  pulldownmenu5->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1 + WS_LB_W2 + WS_LB_W3 + WS_LB_W4));
  pulldownmenu5->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu5->setPropertyV(WSNwidth,(WSCushort)WS_LB_W5);
  pulldownmenu5->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu5->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu5->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu5->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu5->setPropertyV(WSNlabelString,WS_MENU5_LB);
  pulldownmenu5->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu5->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu5->setPropertyV(WSNmenuItems,WS_MENU5_STR);
  pulldownmenu5->setProperty(WSNshortcut,"P");
  pulldownmenu5->setProperty(WSNitemHeight,24);
  pulldownmenu5->setVisible(True);

  WSCprocedure* m51 = new WSCprocedure("m51",WSEV_NONE);
  m51->setFunction(m51_work,"m51_work");
  pulldownmenu5->addProcedure(m51);

  WSCprocedure* m52 = new WSCprocedure("m52",WSEV_NONE);
  m52->setFunction(m52_work,"m52_work");
  pulldownmenu5->addProcedure(m52);

  WSCprocedure* m53 = new WSCprocedure("m53",WSEV_NONE);
  m53->setFunction(m53_work,"m53_work");
  pulldownmenu5->addProcedure(m53);

  WSCprocedure* m54 = new WSCprocedure("m54",WSEV_NONE);
  m54->setFunction(m54_work,"m54_work");
  pulldownmenu5->addProcedure(m54);

  WSCprocedure* m55 = new WSCprocedure("m55",WSEV_NONE);
  m55->setFunction(m55_work,"m55_work");
  pulldownmenu5->addProcedure(m55);

  WSCprocedure* m56 = new WSCprocedure("m56",WSEV_NONE);
  m56->setFunction(m56_work,"m56_work");
  pulldownmenu5->addProcedure(m56);


//----------------------------------------------------------------

  WSCpulldownMenu* pulldownmenu6 = new WSCpulldownMenu(menuarea,"mb-pulldown-6");
  pulldownmenu6->initialize();
  pulldownmenu6->setPropertyV(WSNx,(short)(WS_LB_XOFFSET + WS_LB_W1 + WS_LB_W2 + WS_LB_W3 + WS_LB_W4 + WS_LB_W5));
  pulldownmenu6->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu6->setPropertyV(WSNwidth,(WSCushort)WS_LB_W6);
  pulldownmenu6->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu6->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu6->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu6->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu6->setPropertyV(WSNlabelString,WS_MENU6_LB);
  pulldownmenu6->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu6->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu6->setPropertyV(WSNmenuItems,WS_MENU6_STR);
  pulldownmenu6->setProperty(WSNshortcut,"O");
  pulldownmenu6->setProperty(WSNitemHeight,24);
  pulldownmenu6->setVisible(True);

  WSCprocedure* m61 = new WSCprocedure("m61",WSEV_NONE);
  m61->setFunction(m61_work,"m61_work");
  pulldownmenu6->addProcedure(m61);

  WSCprocedure* m62 = new WSCprocedure("m62",WSEV_NONE);
  m62->setFunction(m62_work,"m62_work");
  pulldownmenu6->addProcedure(m62);

  WSCprocedure* m63 = new WSCprocedure("m63",WSEV_NONE);
  m63->setFunction(m63_work,"m63_work");
  pulldownmenu6->addProcedure(m63);

  WSCprocedure* m64 = new WSCprocedure("m64",WSEV_NONE);
  m64->setFunction(m64_work,"m64_work");
  pulldownmenu6->addProcedure(m64);

  WSCprocedure* m65 = new WSCprocedure("m65",WSEV_NONE);
  m65->setFunction(m65_work,"m65_work");
  pulldownmenu6->addProcedure(m65);

  WSCprocedure* m66 = new WSCprocedure("m66",WSEV_NONE);
  m66->setFunction(m66_work,"m66_work");
  pulldownmenu6->addProcedure(m66);

  pulldownmenu8 = new WSCpulldownMenu(menuarea,"mb-pulldown-7");
  pulldownmenu8->initialize();
  pulldownmenu8->setPropertyV(WSNx,(short)( window_width - WS_LB_W8 - 10));
  pulldownmenu8->setPropertyV(WSNy,(short)WS_LB_YOFFSET);
  pulldownmenu8->setPropertyV(WSNwidth,(WSCushort)WS_LB_W8);
  pulldownmenu8->setPropertyV(WSNheight,(WSCushort)WS_LB_H);
//  pulldownmenu8->setPropertyV(WSNbackColor,"gray80");
//  pulldownmenu8->setPropertyV(WSNtopShadowColor,"gray95");
//  pulldownmenu8->setPropertyV(WSNbottomShadowColor,"gray45");
  pulldownmenu8->setPropertyV(WSNlabelString,WS_MENU8_LB);
  pulldownmenu8->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  pulldownmenu8->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  pulldownmenu8->setPropertyV(WSNmenuItems,WS_MENU8_STR);
  pulldownmenu8->setProperty(WSNshortcut,"H");
  pulldownmenu8->setProperty(WSNitemHeight,24);
  pulldownmenu8->setVisible(True);

  WSCprocedure* m81 = new WSCprocedure("m81",WSEV_NONE);
  m81->setFunction(m81_work,"m81_work");
  pulldownmenu8->addProcedure(m81);

  WSCprocedure* m82 = new WSCprocedure("m82",WSEV_NONE);
  m82->setFunction(m82_work,"m82_work");
  pulldownmenu8->addProcedure(m82);

  WSCprocedure* m83 = new WSCprocedure("m83",WSEV_NONE);
  m83->setFunction(m83_work,"m83_work");
  pulldownmenu8->addProcedure(m83);

  WSCprocedure* m84 = new WSCprocedure("m84",WSEV_NONE);
  m84->setFunction(m84_work,"m84_work");
  pulldownmenu8->addProcedure(m84);

  WSCprocedure* m85 = new WSCprocedure("m85",WSEV_NONE);
  m85->setFunction(m85_work,"m85_work");
  pulldownmenu8->addProcedure(m85);

   adjust_mainwindow(mainwindow);
};

extern WSCstring current_project;
extern WSCstring current_dir;
void set_project_name(char* prjname,char* dirname){
  current_project = prjname;
  if (strcmp((char*)current_dir,dirname)){
    long i;
    long num = winlist.getNum();
    for(i=0; i<num; i++){
      WSCbase* win = (WSCbase*)winlist[i];
      WSGFmarkChanged(win);
    }
  }
  current_dir = dirname;
  WSCstring titlestr(WS_BUILDER_TITLE);
  if (!strcmp(current_project,"")){
    titlestr << " PROJECT:" << WSGFgettext("B4:WSSTR NoName") << " DIR:" << current_dir;
    show_prj2->setProperty(WSNlabelString,WSGFgettext("B4:WSSTR NoName"));
    show_dir2->setProperty(WSNlabelString,current_dir);
  }else{
    titlestr << " PROJECT:" << current_project << " DIR:" << current_dir;
    show_prj2->setProperty(WSNlabelString,current_project);
    show_dir2->setProperty(WSNlabelString,current_dir);
  }

  mainwindow->setPropertyV(WSNtitleString,(char*)titlestr);
}

WSCstring get_project_editor(){
  WSCstring ret;
  ret = pe->getProjectData("#EDITOR_NAME");
  return ret;
}
WSCstring get_pure_project_name(){
  WSCstring tmp;
  tmp = current_project;
  tmp.replaceString(".prj","",1);
#ifdef MSW
  tmp.replaceString(".PRJ","",1);
#endif
  return tmp;
}

char* get_project_name(){
  return (char*)current_project;
}
char* get_project_dir(){
  if (!strcmp((char*)current_dir,"")){
    return ".";
  }
  return (char*)current_dir;
}
char* get_product_name(){
  WSCstring stlink( pe->getProjectData("#STLINK") );
  if (atoi((char*)stlink)){
    return pe->getProjectData("#STOUTPUT");
  }else{
    return pe->getProjectData("#OUTPUT");
  }
}
char* get_dbg_product_name(){
  WSCstring stlink( pe->getProjectData("#STLINK") );
  if (atoi((char*)stlink)){
    return pe->getProjectData("#DBG_STOUTPUT");
  }else{
    return pe->getProjectData("#DBG_OUTPUT");
  }
}
char* get_dbg_name(){
  return pe->getProjectData("#DEBUGGER");
}
char* get_make_name(){
  return pe->getProjectData("#MAKE");
}
char* get_vproduct_name(){
  WSCstring str;
  str = pe->getProjectData("#CMODE");
#ifdef MSW
extern long get_link_type();
  if (get_link_type() == 2){ //NETSCAPE PLUGIN
    if (atoi((char*)str)){
      static WSCstring ret;
      ret = "np";
      ret << get_dbg_product_name();
      return ret;
    }else{
      static WSCstring ret;
      ret = "np";
      ret << get_product_name();
      return ret;
    }
  }
#endif
  if (atoi((char*)str)){
    return get_dbg_product_name();
  }else{
    return get_product_name();
  }
}
WSCstring get_runtime_cflags(){
  WSCstring str;
  str =  pe->getProjectData("#USER_FL");
  str << " " << pe->getProjectData("#USER_RT_FL");
  return str;
}
WSCstring get_debug_cflags(){
  WSCstring str;
  str =  pe->getProjectData("#USER_FL");
  str << " " << pe->getProjectData("#USER_DBG_FL");
  return str;
}
WSCstring get_cflags(){
  WSCstring str;
  str = pe->getProjectData("#CMODE");
  if (atoi((char*)str)){
    return get_debug_cflags();
  }else{
    return get_runtime_cflags();
  }
}

void load_project(){
extern long close_project();
  long ret = close_project();
  if (ret == -1){
     return;
  }
  clear_lib_list();

  fselect->setPropertyV(WSNfileName,"");
  fselect->setPropertyV(WSNmaskFileName,"prj");
  fselect->setPropertyV(WSNreplyHandler,(void*)NULL);
  ret = fselect->popup();
  if (ret != WS_DIALOG_OK){
    return;
  }

  WSCstring filename(fselect->getProperty(WSNfileName));
  WSCstring dirname(fselect->getProperty(WSNdirName));

  WSCstring fname;
  WSCstring current_project = filename;
  WSCstring current_dir;

  if (!strcmp((char*)dirname,"")){
    fname << filename;
    current_dir = "";
  }else{
    fname << dirname << "/" << filename;
    current_dir = dirname;
  }
  pe->setProjectData("#ENCODING","LOCALE");

  ret = pe->open(fname);
  if (ret != WS_NO_ERR){
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("C4:WSSTR Unexpected error occurred in reading the project files..."));
    message->popup();
    return;
  }


  set_project_name((char*)current_project,(char*)current_dir);

  long len = strlen((char*)fname);
  if (len > 4 && !strcmp( ((char*)fname) + len-4,".prj")){
    fname.replaceString(".prj",".wns",1);
#ifdef MSW
  }else if (len > 4 && !strcmp( ((char*)fname) + len-4,".PRJ")){
    fname.replaceString(".PRJ",".wns",1);
#endif
  }else{
    fname << ".wns";
  }

extern long load_winfiles(char*,WSClistData*);
  ret = load_winfiles(fname,&winlist);
  if (ret != WS_NO_ERR){
    WSCstring buf;
    buf << WSGFgettext("D4:WSSTR Can not open File: ") << fname
        << WSGFgettext("E4:WSSTR  .");
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
    return;
  }
  inspector->setClients(&winlist);

  fname.replaceString(".wns",".col",1);
#ifdef MSW
  fname.replaceString(".WNS",".col",1);
#endif
  WSGIappColorSelect()->load((char*)fname);

  setup_buildbtn();
}
void load_project_handler(WSCinspector* inspector,char* sname){
//printf("load_project_handler() sname=%s\n",sname);
  WSCstring filename = WSGFgetFileName(sname);
  WSCstring dirname = WSGFgetDirName(sname);
  long prefixw = filename.getWords(".");
  WSCstring prefix = filename.getWord(prefixw-1,".");
//printf("fname=%s prefix=%s\n",filename.getString(),prefix.getString());
  if (prefixw < 2 || strcmp(prefix.getString(),"prj")){
    return;
  }

extern long close_project();
  long ret = close_project();
  if (ret == -1){
     return;
  }
  clear_lib_list();


  WSCstring fname;
  WSCstring current_project = filename;
  WSCstring current_dir;

  if (!strcmp((char*)dirname,"")){
    fname << filename;
    current_dir = "";
  }else{
    fname << dirname << "/" << filename;
    current_dir = dirname;
  }
  pe->setProjectData("#ENCODING","LOCALE");

  ret = pe->open(fname);
  if (ret != WS_NO_ERR){
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,
      WSGFgettext("C4:WSSTR Unexpected error occurred in reading the project files..."));
    message->popup();
    return;
  }


  set_project_name((char*)current_project,(char*)current_dir);

  long len = strlen((char*)fname);
  if (len > 4 && !strcmp( ((char*)fname) + len-4,".prj")){
    fname.replaceString(".prj",".wns",1);
#ifdef MSW
  }else if (len > 4 && !strcmp( ((char*)fname) + len-4,".PRJ")){
    fname.replaceString(".PRJ",".wns",1);
#endif
  }else{
    fname << ".wns";
  }

extern long load_winfiles(char*,WSClistData*);
  ret = load_winfiles(fname,&winlist);
  if (ret != WS_NO_ERR){
    WSCstring buf;
    buf << WSGFgettext("D4:WSSTR Can not open File: ") << fname
        << WSGFgettext("E4:WSSTR  .");
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
    return;
  }
  inspector->setClients(&winlist);

  fname.replaceString(".wns",".col",1);
#ifdef MSW
  fname.replaceString(".WNS",".col",1);
#endif
  WSGIappColorSelect()->load((char*)fname);
  setup_buildbtn();
}
char* get_win_project_file(){
static  WSCstring buf;
  buf = "";
  long i;
  long num = winlist.getNum();
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)winlist[i];
    if (win->getUserData(WS_REGISTERED)){
      WSCstring fname;
      if (win->getUserData(WS_FILENAME) ){
        fname = (char*)win->getUserData(WS_FILENAME);
      }else{
        fname  = win->getInstanceName();
        fname << ".win";
      }
      buf << fname << "\n";
    }
  }
  return (char*)buf;
}
long save_win_project_file(){
extern char* get_full_project_name();
  WSCstring data(get_win_project_file());
  WSCstring fname(get_full_project_name());
#ifdef MSW
  fname.replaceString(".PRJ",".wns",1);
#endif
  fname.replaceString(".prj",".wns",1);
  long ret = WSGFreplaceTextFile((char*)fname,data,False);
  if (ret != WS_NO_ERR){
    WSCstring buf;
    buf << WSGFgettext("F4:WSSTR Can not save FILE: ") << fname
        << WSGFgettext("G4:WSSTR  .");
    message->setPropertyV(WSNwidth,(WSCushort)640);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
  }
  return ret;
}
long check_need_save_win_project_file(){
extern char* get_full_project_name();
  WSCstring data(get_win_project_file());
  WSCstring fname(get_full_project_name());
#ifdef MSW
  fname.replaceString(".PRJ",".wns",1);
#endif
  fname.replaceString(".prj",".wns",1);
  if (WSGFcheckDiffTextFile((char*)fname,data)){
    return 1;
  }
  return 0;
}

long check_need_save_project(){
  if (!strcmp("",get_project_name())){
    return 1;
  }
  if (check_need_save_win_project_file()){
    return 1;
  }
  WSCstring prjdata(pe->getProjectData());
  
extern char* get_full_project_name();
  if (WSGFcheckDiffTextFile(get_full_project_name(),prjdata)){
    return 1;
  }
  return 0;
}
void destroy_windows(){
  WSClistData tmp;
  tmp =  winlist;
  selected_clients.clear();
  copy_clients.clear();
  winlist.clear();
  inspector->updateList();

  long num = tmp.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)tmp[i];
    win->setVisible(False);
    delete win;
  }
}
long close_project(){
  set_sensitive_exec_btn(False);
  set_sensitive_build_btn(False);
  set_sensitive_build_cancel_btn(False);

  if (strcmp("",get_project_name())){
    long ret = check_need_save_project();
    if (ret == 1){
      question->setPropertyV(WSNheight,(WSCushort)125);
      question->setPropertyV(WSNwidth,(WSCushort)500);
      question->setPropertyV(WSNlabelString,
        WSGFgettext("H4:WSSTR The project was modified.\nSave it?"));
      long ret = question->popup();
      if (ret == WS_DIALOG_OK){
extern void save_project();
        save_project();
      }else if (ret == WS_DIALOG_CANCEL){
        return -1;
      }
    }
  }
extern void save_windows_with_check();
  save_windows_with_check();
  destroy_windows();
  WSCstring loc = WSGIappLocaleSet()->getSystemLocaleName();
  if (!strcmp((char*)loc,"C")){
    loc = "en_US";
  }
  WSCstring defprj;
  defprj << "$(WSDIR)/sys/data/locale/" << loc
         << "/default.prj" << pe->getTargetSuffixName();
  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)defprj)) == False){
    loc = "en_US";
    defprj ="";
    defprj << "$(WSDIR)/sys/data/locale/" << loc
         << "/default.prj" << pe->getTargetSuffixName();
  }

  clear_lib_list();
  pe->clearUseDll();

  pe->setProjectData("#ENCODING","LOCALE");

  pe->open(defprj);
  WSCstring tmp;
  tmp = get_project_dir();
  set_project_name("",tmp.getString());
  WSGIappColorSelect()->clearColorEntry();

  if (test_execute != False){
extern WSCdialog* tracewin;
    tracewin->setVisible(False);
    exec_app();
  }

  return 0;
}

void save_windows(){
  long num = winlist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)winlist[i];
extern long check_win_save(WSCbase*);
    if (check_win_save(win) != 0){
//    if (WSGFcheckMarkChanged(win) != False){
extern long win_save(WSCbase*);
      long ret = win_save(win);
      if (ret != WS_NO_ERR){
        WSCstring buf;
        buf << WSGFgettext("I4:WSSTR Abort saving the application window.");
        message->setPropertyV(WSNlabelString,(char*)buf);
        message->popup();
        break;
      }
    }
  }
}

void save_windows_with_check(){
  long num = winlist.getNum();
  long i;
  long fl = 0;
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)winlist[i];
//    if (WSGFcheckMarkChanged(win) != False){
      WSCstring data = WSGFcreateWinSrc(win);
extern char* get_win_file_name(WSCbase*);
      long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
        encoding = WS_EN_LOCALE;
      }

//      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        if (WSGFcheckDiffTextFile(get_win_file_name(win),data.getString(encoding))){
          fl = 1;
//printf("save_windows_with_check diff!!!\n");
          break;
        }
//      }else{
//        if (WSGFcheckDiffTextFile(get_win_file_name(win),data)){
//          fl = 1;
//          break;
//        }
//      }
//    }
  }
  if (fl != 0){

    question->setPropertyV(WSNwidth,(WSCushort)500);
    question->setPropertyV(WSNheight,(WSCushort)125);
    question->setPropertyV(WSNlabelString,
      WSGFgettext("J4:WSSTR Some application windows were modified \nSave them?"));
    long ret = question->popup();
    if (ret == WS_DIALOG_OK){
      save_windows();
    }
  }
}

char* get_full_project_name(){
  WSCstring filename(get_project_name());
  WSCstring dirname(get_project_dir()); 
static  WSCstring fname;
  if (!strcmp((char*)dirname,"")){
    fname = filename;
  }else{
    fname = dirname;
    fname << "/" << filename;
  }
  return  (char*)fname;
}

void save_project(){
  if (!strcmp("",get_project_name())){
    question->setPropertyV(WSNwidth,(WSCushort)500);
    question->setPropertyV(WSNheight,(WSCushort)125);
    question->setPropertyV(WSNlabelString,
      WSGFgettext("K4:WSSTR The project has no name.\nName the project and save it?"));
    long ret = question->popup();
    if (ret == WS_DIALOG_OK){
      long ret2 = create_project();
      if (ret2 != WS_NO_ERR){
        return;
      }
      fselect->setPropertyV(WSNfileName,"");
      fselect->setPropertyV(WSNmaskFileName,"prj");
      fselect->setPropertyV(WSNdirName,".");
      long ret = fselect->popup();
      if (ret == WS_DIALOG_OK){
        WSCstring filename(fselect->getProperty(WSNfileName));
        WSCstring dirname(fselect->getProperty(WSNdirName));
        set_project_name((char*)filename,(char*)dirname);
      }else{
        return;
      }
    }else{
      return;
    }
  }

extern char* get_full_project_name();
  WSCstring fname(get_full_project_name());
  pe->save(fname);
//  pe->save_global("$(HOME)/.wsbuilderrc");

  fname.replaceString(".prj",".col",1);
#ifdef MSW
  fname.replaceString(".PRJ",".col",1);
#endif

  WSGIappColorSelect()->save((char*)fname);
  save_windows_with_check();
  save_win_project_file();
}

void rename_save_project(){
  fselect->setPropertyV(WSNfileName,get_project_name());
  fselect->setPropertyV(WSNdirName,get_project_dir());
  fselect->setPropertyV(WSNmaskFileName,"prj");

  long ret = fselect->popup();
  if (ret != WS_DIALOG_OK){
//printf("canceled..\n");
    return;
  }

  WSCstring filename(fselect->getProperty(WSNfileName));
  WSCstring dirname(fselect->getProperty(WSNdirName));
  set_project_name(filename,dirname);
  save_project();
}

long create_project(){
  long ret = newprj->popup();
  if (ret == WS_DIALOG_DONE){
extern WSCvifield* npif1;
extern WSCvifield* npif2;
    WSCstring pname;
    WSCstring dname;
    pname = npif1->getProperty(WSNlabelString);
    pname.delHeadSpace();
    pname.delTailSpace();
    if (!strcmp((char*)pname,"")){
      pname << "newproject";
    }

    if (WSGFcheckNameString((char*)pname) == False){
extern WSCmessageDialog* message;
      WSCstring str;
      str << WSGFgettext("O4:WSSTR Invalid name: ") << pname
          << WSGFgettext("P4:WSSTR .\nPlease specify a usable name in C/C++ variables.");
      message->setPropertyV(WSNwidth,(WSCushort)400);
      message->setPropertyV(WSNlabelString,(char*)str);
      message->popup();
      return WS_ERR;
    }


    long ret = WSGFexistName(pname.getString(),NULL);
    if (ret == WS_OBJECT_ARRAY_NAME){
extern WSCmessageDialog* message;
      WSCstring str;
      str << WSGFgettext("O4:WSSTR Invalid name: ") << pname
          << WSGFgettext("P4:WSSTR .\nCan not use array name.");
      message->setPropertyV(WSNwidth,(WSCushort)400);
      message->setPropertyV(WSNlabelString,(char*)str);
      message->popup();
      return WS_ERR;
    }else if (ret == WS_PROCEDURE_NAME){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,WSGFgettext("O3:WSSTR Invalid name.\nAlready used by another event procedure."));
      message->popup();
      return WS_ERR;
    }else if (ret == WS_OBJECT_NAME){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Invalid name.\nAlready used by another externalinstance."));
      message->popup();
      return WS_ERR;
    }else if (ret == WS_OBJECT_ARRAY_NAME_INVALID){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("Q3:WSSTR Invalid array name.\nThe Array type differs from another one,or exists also another window."));
      message->popup();
      return WS_ERR;
    }else if (ret == WS_OTHER_NAME){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("R3:WSSTR Invalid name.\nAlready used by the project name or the other one."));
      message->popup();
      return WS_ERR;
    }

    WSCstring pname2(pname);
    pname << ".prj";
    dname = npif2->getProperty(WSNlabelString);
    dname.delHeadSpace();
    dname.delTailSpace();
    if (!strcmp((char*)dname,"")){
      dname << ".";
    }
    long chs = dname.getChars();
    WSCstring tmp(dname);
    tmp.deleteChars(0,chs-1);
    if (!strcmp(tmp.getString(),"/") || !strcmp(tmp.getString(),"\\")){
      dname.deleteChars(chs-1,1);
    }
    WSCstring str2(dname);
#ifdef MSW
    str2.replaceString("/","\\",0);
#endif
    char* dir = str2.getString();
    long fstat = WSGIappFileSystem()->check(dir);
    if (fstat == 0){
      ret = WSGIappFileSystem()->createDir(dir);
      if (ret != WS_NO_ERR){
        WSCstring msg;
        msg << WSGFgettext("F:WSSTRCannot create directory:");
        msg << str2;
        msg << WSGFgettext("G:WSSTR.");
        message->setProperty(WSNlabelString,msg);
        message->popup();
        return WS_ERR;
      }
      fstat = WSGIappFileSystem()->check(dir);
    }

    if (!(fstat & WS_FS_DIR) || (fstat & WS_FS_READONLY)){
      WSCstring msg;
      msg << WSGFgettext("F:WSSTRCannot create directory:\n");
      msg << str2;
      msg << WSGFgettext("G:WSSTRCannot create directory:\n");
      message->setProperty(WSNlabelString,msg);
      message->popup();
      return WS_ERR;
    }

    set_project_name(pname,dname);

    pe->setProjectData("#OUTPUT",pname2);
    pe->setProjectData("#STOUTPUT",pname2);
    pname2 << "d";
    pe->setProjectData("#DBG_OUTPUT",pname2);
    pe->setProjectData("#DBG_STOUTPUT",pname2);

//extern WSCvtoggle* nptgl21;
extern WSCoption* npopt1;
    pe->setProjectData("#LIB_CREATE",WSGFltoa(npopt1->getValue()));

extern WSCoption* opt31;
    long val = opt31->getProperty(WSNvalue);
    void* val2 = (void*)val;
    pe->setProjectData("#ENCODING",(char*)val2);

extern WSCoption* opt32;
    val = opt32->getProperty(WSNvalue);
    pe->setLanguage(val);

extern void setup_buildbtn();
    setup_buildbtn();

    return WS_NO_ERR;
  }
  return WS_ERR;
}

void load_window_style(){
#ifdef MSW
  WSCstring* loadstr = WSGFreadTextFile("$(WINDIR)/.wsbuilder_defaults");
#else
  WSCstring* loadstr = WSGFreadTextFile("$(HOME)/.wsbuilder_defaults");
#endif
  if (loadstr == NULL){
    return;
  }
  while(loadstr->eof() == False){
    WSCstring line = loadstr->gets();
    WSCstring tmp = line.getWord(0,":");
    WSCstring objname = tmp.getWord(0,".");
    long llen = strlen(line.getString());
    long slen = strlen(tmp.getString());
    WSCstring prop = tmp.getWord(1,".");
 //   WSCstring value = line.getWord(1,":");
    char* linev = line.getString();
    char* valuev = "";
    if (llen >slen+1){
      valuev = &linev[slen+1];
    }
    WSCstring value;
    value.setString(valuev);
    value.delHeadSpace();
    value.delTailSpace();
    objname.delHeadSpace();
    objname.delTailSpace();
    prop.delHeadSpace();
    prop.delTailSpace();
    WSCbase* client = WSGIappObjectList()->getInstance("WSCbase",(char*)objname);
    if (client != NULL){
      client->setProperty((char*)prop,(char*)value);
    }
//printf("%s %s %s\n",(char*)objname,(char*)prop,(char*)value);
  }
  delete loadstr;

#ifdef MSW
  WSCstring* loadstr2 = WSGFreadTextFile("$(WINDIR)/.wsbuilder_dir");
#else
  WSCstring* loadstr2 = WSGFreadTextFile("$(HOME)/.wsbuilder_dir");
#endif
  if (loadstr2 == NULL){
    return;
  }
  WSCbase* dirt = inspector->getDirTree();
  WSCdirTree* dirt2 = (WSCdirTree*)dirt->cast("WSCdirTree");
  if (dirt2 != NULL){
    dirt2->setDirInf(*loadstr2);
  }
  delete loadstr2;

#ifdef MSW
  WSCstring* loadstr3 = WSGFreadTextFile("$(WINDIR)/.wsbuilder_classes");
#else
  WSCstring* loadstr3 = WSGFreadTextFile("$(HOME)/.wsbuilder_classes");
#endif
  if (loadstr3 == NULL){
    return;
  }
  WSCbase* clist = inspector->getClassList();
  WSClist* clist2 = (WSClist*)clist->cast("WSClist");
  if (clist2 != NULL){
    clist2->setProperty(WSNdata,loadstr3->getString());
  }
  delete loadstr3;


}
void save_window_style(){
  WSCstring savestr;
  savestr << "mainwindow.x: " << mainwindow->getProperty(WSNx) <<"\n";
  savestr << "mainwindow.y: " << mainwindow->getProperty(WSNy) <<"\n";
  savestr << "mainwindow.width: " << mainwindow->getProperty(WSNwidth) <<"\n";
  savestr << "mainwindow.height: " << mainwindow->getProperty(WSNheight) <<"\n";
  savestr << "inspector.width: " << inspector->getProperty(WSNwidth) <<"\n";
  savestr << "inspector.height: " << inspector->getProperty(WSNwidth) <<"\n";
  savestr << "inspector.value: " << inspector->getProperty(WSNvalue) <<"\n";
  savestr << "inspector.barValue: " << inspector->getProperty(WSNbarValue) <<"\n";

  WSCbase* dirt = inspector->getDirTree();
  savestr << dirt->getInstanceName() << ".vbarValue: ";
  savestr << dirt->getProperty(WSNvbarValue) <<"\n";

  savestr << "app-fselect.width:" << fselect->getProperty(WSNwidth) << "\n";
  savestr << "app-fselect.height:" << fselect->getProperty(WSNheight) << "\n";

//  savestr << "procbox.x:" << procbox->getProperty(WSNx) << "\n";
//  savestr << "procbox.y:" << procbox->getProperty(WSNy) << "\n";
//  savestr << "procbox.width:" << procbox->getProperty(WSNwidth) << "\n";
//  savestr << "procbox.height:" << procbox->getProperty(WSNheight) << "\n";
//  savestr << "procform.vis:" << procform->getVisible() << "\n";
  WSCcolorSelect* cs = WSGIappColorSelect();
  savestr << "AppColorSelect.x:" << cs->getProperty(WSNx) << "\n";
  savestr << "AppColorSelect.y:" << cs->getProperty(WSNy) << "\n";
  savestr << "AppColorSelect.width:" << cs->getProperty(WSNwidth) << "\n";
  savestr << "AppColorSelect.height:" << cs->getProperty(WSNheight) << "\n";
  savestr << "app-fselect.dirName:" << WSGIappFileSelect()->getProperty(WSNdirName) << "\n";
  WSCdirTree* dirt2 = (WSCdirTree*)dirt->cast("WSCdirTree");
  WSCstring savestr2;
  if (dirt2 != NULL){
    savestr2 = dirt2->getDirInf();
  }
  WSCbase* clist = inspector->getClassList();
  WSCstring savestr3;
  savestr3 = clist->getProperty(WSNdata);



#ifdef MSW
  WSGFreplaceTextFile("$(WINDIR)/.wsbuilder_defaults",(char*)savestr,False);
  WSGFreplaceTextFile("$(WINDIR)/.wsbuilder_dir",(char*)savestr2,False);
  WSGFreplaceTextFile("$(WINDIR)/.wsbuilder_classes",(char*)savestr3,False);
#else
  WSGFreplaceTextFile("$(HOME)/.wsbuilder_defaults",(char*)savestr,False);
  WSGFreplaceTextFile("$(HOME)/.wsbuilder_dir",(char*)savestr2,False);
  WSGFreplaceTextFile("$(HOME)/.wsbuilder_classes",(char*)savestr3,False);
#endif



}

void exit_builder(){
  message->setPropertyV(WSNlabelString,WSGFgettext("L4:WSSTR Exit the application builder?"));
  message->setPropertyV(WSNcancel,(WSCbool)True);
  long ret = message->popup();
  message->setPropertyV(WSNcancel,(WSCbool)False);
  if (ret != WS_DIALOG_OK){
//    mainwindow->setVisible(True);
    return;
  }
  ret = close_project();
  if (ret != WS_DIALOG_CANCEL){
//    mainwindow->setVisible(True);
    return;
  }
  save_window_style();
#ifdef MSW
  pe->save_global("$(WINDIR)/.wsbuilderrc");
#else
  pe->save_global("$(HOME)/.wsbuilderrc");
#endif

#ifdef BTRON
  delete procform;
#endif

  WSGFexit(0);
}

void under_construction(){
  message->setPropertyV(WSNlabelString,WSGFgettext("M4:WSSTR Sorry, under construction..."));
  message->popup();
}

//# define WS_MAKE_FILE         WS_DATA_DIR "make_exe"
//# define WS_MAKE_FILE_DLL     WS_DATA_DIR "make_dll"
# define WS_MAKE_FILE2        "makefile"
# define WS_MAKE_FLAGS        WS_CFG_DIR "mkflags"
# define WS_MAKE_FLAGS2       "mkflags"
#ifdef MacOS
#define WS_XPM_DLL "xpm.bundle"
#define WS_PNG_DLL "png.bundle"
#define WS_JPG_DLL "jpg.bundle"
#else
#define WS_XPM_DLL "libwsxpm.so"
#define WS_PNG_DLL "libwspng.so"
#define WS_JPG_DLL "libwsjpg.so"
#endif
long get_lib_create_flag(){
  if (atoi(pe->getProjectData("#LIB_CREATE")) == 1){
    return 1;
  }
  return 0;
}
long get_link_type(){
  return atoi(pe->getProjectData("#LIB_CREATE"));
}
char* get_lib_value(){
  WSCvariant static_linked = pe->getProjectData("#STLINK");
static  WSCstring ret;
  ret = pe->getProjectData("#USER_LIB");
  if (static_linked.getLong() == False){
    ret << " " << pe->getLinkOptions(get_link_type());
  }else{
    ret << " " << pe->getStaticLinkOptions(get_link_type());
  }
  return ret;
}
//char* get_static_lib_value(){
//static  WSCstring ret;
//  ret = pe->getProjectData("#USER_LIB");
//  ret << " " << pe->getStaticLinkOptions(get_link_type());
//  return ret;
//}


char* get_objs(){
  return pe->getProjectData("#OBJS");
}
char* get_sources(){
  return pe->getProjectData("#WS_FILES");
}
char* get_ext_lib_value(){
  WSCstring str( pe->getProjectData("#CMODE") );
  WSCstring str2( pe->getProjectData("#STLINK") );
  if (atoi((char*)str)){
    if (atoi((char*)str2)){
      return pe->getProjectData("#USER_DBG_STLIB");
    }else{
      return pe->getProjectData("#USER_DBG_LIB");
    }
  }else{
    if (atoi((char*)str2)){
      return pe->getProjectData("#USER_RT_STLIB");
    }else{
      return pe->getProjectData("#USER_RT_LIB");
    }
  }
}
WSCstring get_include_value(){
  WSCstring str;
  str = pe->getProjectData("#USER_INCLUDE");
  if (atoi((char*) pe->getProjectData("#CMODE"))){
    str << " " << pe->getProjectData("#USER_DBG_INCLUDE");
  }else{
    str << " " << pe->getProjectData("#USER_RT_INCLUDE");
  }
  return str;
}

long file_output_error(char* fname){
  WSCstring buffer;
  buffer << WSGFgettext("N4:WSSTR Failed to save FILE: ")
         << get_project_dir() << "/"
         << fname << "\n"
         << WSGFgettext("O4:WSSTR Do you continue?");
  message->setPropertyV(WSNlabelString,(char*)buffer);
  message->setPropertyV(WSNcancel,(WSCbool)True);
  long ret = message->popup();
  message->setPropertyV(WSNcancel,(WSCbool)False);
  return ret;
}
long file_output_error2(char* fname){
  WSCstring buffer;
  buffer << WSGFgettext("N4:WSSTR Failed to save FILE: ") << fname << "\n"
         << WSGFgettext("O4:WSSTR Do you continue?");
  message->setPropertyV(WSNlabelString,(char*)buffer);
  message->setPropertyV(WSNcancel,(WSCbool)True);
  long ret = message->popup();
  message->setPropertyV(WSNcancel,(WSCbool)False);
  return ret;
}
#ifdef MSW
void copyfile_to_project_dir(char* destname,char* srcname){
  WSCstring fname = "";
  fname << get_project_dir() << "/" << destname;
  if (WSGFcheckExistFile(fname) == False){
    WSCstring buffer;
    buffer = WSGIappFileSystem()->adjustFileName(srcname);
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    while( fname.replaceString("//","/",0));
    while( fname.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
             fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
  }
}
#endif

long create_window_src(WSCbase* win){
  WSCstring fname;
  long ret;
#ifdef MSW
  if (get_link_type() != 2 && get_link_type() != 3){ //NOT NETSCAPE/IE PLUGIN
    fname << get_project_dir() << "/" << "wsres.rc";
    if (WSGFcheckExistFile(fname) == False){
      WSCstring buffer;
      buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres.rc");
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      while( fname.replaceString("//","/",0));
      while( fname.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
               fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }
  }else{ //NETSCAPE/IE PLUGIN
    fname << get_project_dir() << "/" << "wsres.rc";
//    if (WSGFcheckExistFile(fname) == False){
    {
      WSCstring buffer;
      if (get_link_type() == 2){ //NETSCAPE PLUGIN
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres-nsp.rc");
      }else{ //IE PLUGIN
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres-iep.rc");
      }
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      while( fname.replaceString("//","/",0));
      while( fname.replaceString("/","\\",0));

      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
               fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
      if (get_link_type() == 3){ //IE PLUGIN
        fname ="";
        fname << get_project_dir() << "/" << "resource.h";
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/resource.h");
        while( buffer.replaceString("//","/",0));
        while( buffer.replaceString("/","\\",0));
        while( fname.replaceString("//","/",0));
        while( fname.replaceString("/","\\",0));

        CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
               fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
        fname ="";
        fname << get_project_dir() << "/" << "dwinvers.h";
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/dwinvers.h");
        while( buffer.replaceString("//","/",0));
        while( buffer.replaceString("/","\\",0));
        while( fname.replaceString("//","/",0));
        while( fname.replaceString("/","\\",0));

        CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
               fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
      }
    }

    WSCstring buffer2;
    buffer2 << get_project_dir() << "/wsres.rc";
    while( buffer2.replaceString("//","/",0));
    while( buffer2.replaceString("/","\\",0));

    WSCstring* buf2 = WSGFreadTextFile(buffer2);
    if (buf2 != NULL){
      buf2->replaceString("#PROGRAM#",get_vproduct_name(),0);
      WSCstring pname(get_vproduct_name());
      if (get_link_type() == 3){ //IE PLUGIN
        pname << ".ocx";
      }else{
        pname << ".dll";
      }
      buf2->replaceString("#PROGRAM-NAME#",pname,0);
      WSGFreplaceTextFile(buffer2,buf2->getString(),False);
      delete buf2;
    }
  }

  fname = "";
  fname << get_project_dir() << "/" << "icons";
  ret = _mkdir(fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));

  copyfile_to_project_dir("icons/psave.ico", "$(WSDIR)/sys/pixmaps/psave.ico");
  copyfile_to_project_dir("icons/pend.ico","$(WSDIR)/sys/pixmaps/pend.ico");
  copyfile_to_project_dir("icons/wload.ico","$(WSDIR)/sys/pixmaps/wload.ico");
  copyfile_to_project_dir("icons/wsave.ico","$(WSDIR)/sys/pixmaps/wsave.ico");
  copyfile_to_project_dir("icons/obox.ico","$(WSDIR)/sys/pixmaps/obox.ico");
  copyfile_to_project_dir("icons/make.ico","$(WSDIR)/sys/pixmaps/make.ico");
  copyfile_to_project_dir("icons/run.ico","$(WSDIR)/sys/pixmaps/run.ico");
  copyfile_to_project_dir("icons/search.ico","$(WSDIR)/sys/pixmaps/search.ico");
  copyfile_to_project_dir("icons/search2.ico","$(WSDIR)/sys/pixmaps/search2.ico");
  copyfile_to_project_dir("icons/help.ico","$(WSDIR)/sys/pixmaps/help.ico");
  copyfile_to_project_dir("icons/runx.ico","$(WSDIR)/sys/pixmaps/runx.ico");
  copyfile_to_project_dir("icons/bi4.ico","$(WSDIR)/sys/pixmaps/bi4.ico");
  copyfile_to_project_dir("icons/bi13.ico","$(WSDIR)/sys/pixmaps/bi13.ico");
  copyfile_to_project_dir("icons/bi15.ico","$(WSDIR)/sys/pixmaps/bi15.ico");
  copyfile_to_project_dir("icons/bi16.ico","$(WSDIR)/sys/pixmaps/bi16.ico");
  copyfile_to_project_dir("icons/bi17.ico","$(WSDIR)/sys/pixmaps/bi17.ico");
  copyfile_to_project_dir("icons/bi18.ico","$(WSDIR)/sys/pixmaps/bi18.ico");
  copyfile_to_project_dir("icons/bi19.ico","$(WSDIR)/sys/pixmaps/bi19.ico");
  copyfile_to_project_dir("icons/bi23.ico","$(WSDIR)/sys/pixmaps/bi23.ico");
  copyfile_to_project_dir("icons/bi24.ico","$(WSDIR)/sys/pixmaps/bi24.ico");
  copyfile_to_project_dir("icons/bi25.ico","$(WSDIR)/sys/pixmaps/bi25.ico");
  copyfile_to_project_dir("icons/endbtn.ico","$(WSDIR)/sys/pixmaps/endbtn.ico");
  copyfile_to_project_dir("icons/ope.ico","$(WSDIR)/sys/pixmaps/ope.ico");
  copyfile_to_project_dir("icons/wcreate.ico","$(WSDIR)/sys/pixmaps/wcreate.ico");
  copyfile_to_project_dir("icons/wtrash.ico","$(WSDIR)/sys/pixmaps/wtrash.ico");
  copyfile_to_project_dir("icons/edit.ico","$(WSDIR)/sys/pixmaps/edit.ico");
  copyfile_to_project_dir("icons/pset.ico","$(WSDIR)/sys/pixmaps/pset.ico");
  copyfile_to_project_dir("icons/bi8.ico","$(WSDIR)/sys/pixmaps/bi8.ico");
  copyfile_to_project_dir("icons/pcreate.ico","$(WSDIR)/sys/pixmaps/pcreate.ico");
  copyfile_to_project_dir("icons/pload.ico","$(WSDIR)/sys/pixmaps/pload.ico");
  copyfile_to_project_dir("icons/bi40.ico","$(WSDIR)/sys/pixmaps/bi40.ico");
  copyfile_to_project_dir("icons/bi41.ico","$(WSDIR)/sys/pixmaps/bi41.ico");
  copyfile_to_project_dir("icons/bi42.ico","$(WSDIR)/sys/pixmaps/bi42.ico");
  copyfile_to_project_dir("icons/bi43.ico","$(WSDIR)/sys/pixmaps/bi43.ico");

#if 0
  fname = "";
  fname << get_project_dir() << "/" << "wsres.h";
  if (WSGFcheckExistFile(fname) == False){
    WSCstring buffer;
    buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres.h");
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    while( fname.replaceString("//","/",0));
    while( fname.replaceString("/","\\",0));
    CopyFile((char*)buffer,(char*)fname,FALSE);
  }
#endif
  fname = "";
  fname << get_project_dir() << "/" << "main.ico";
  if (WSGFcheckExistFile(fname) == False){
    WSCstring buffer;
    buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/main.ico");
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    while( fname.replaceString("//","/",0));
    while( fname.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
             fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
  }
  fname = "";
#endif /* MSW */
  if (win->getUserData(WS_WIN_CLASS)){
    if (pe->getLanguage() == WS_LANG_CPP){
      WSCbase* b = WSGFgetClassBase(win);
      WSCstring* output;
      fname << get_project_dir() << "/" << win->getInstanceName() << ".cpp";
      if (WSGFcheckExistFile(fname) == False){
        output = WSGFcreateWindowClassSrc(b);
        long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
        if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
          encoding = WS_EN_LOCALE;
        }

        ret = WSGFreplaceTextFile((char*)fname,output->getString(encoding),False);
        delete output;
        if (ret != WS_NO_ERR){
          ret = file_output_error2(fname);
          if (ret != WS_DIALOG_OK){
            WSGFresetClassBase(win);
            return -1;
          }
        }
      }
      fname = get_project_dir();
      fname << "/" << win->getInstanceName() << ".h";
      if (WSGFcheckExistFile(fname) == False){
        output = WSGFcreateWindowClassHeader(b);
        long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
        if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
          encoding = WS_EN_LOCALE;
        }

        ret = WSGFreplaceTextFile((char*)fname,output->getString(encoding),False);
        delete output;
        if (ret != WS_NO_ERR){
          ret = file_output_error2(fname);
          if (ret != WS_DIALOG_OK){
            WSGFresetClassBase(win);
            return -1;
          }
        }
      }else{
        long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
        if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
          encoding = WS_EN_LOCALE;
        }

        WSCstring* head = WSGFreadTextFile(fname,encoding);
        if (head != NULL){
          WSGFupdateWindowClassHeader(head,b);
          ret = WSGFreplaceTextFile(fname,head->getString(encoding),False);
          if (ret != WS_NO_ERR){
            ret = file_output_error2(fname);
            if (ret != WS_DIALOG_OK){
              return -1;
            }
          }
          delete head;
        }
      }
  
      fname = get_project_dir();
      fname << "/" << win->getInstanceName() << "P.cpp";
      output = WSGFcreateWindowClassSrcP(b);
      long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
        encoding = WS_EN_LOCALE;
      }

      ret = WSGFreplaceTextFile((char*)fname,output->getString(encoding),False);
      delete output;
      if (ret != WS_NO_ERR){
        ret = file_output_error2(fname);
        if (ret != WS_DIALOG_OK){
          WSGFresetClassBase(win);
          return -1;
        }
      }

      fname = get_project_dir();
      fname << "/" << win->getInstanceName() << "P.h";
      output = WSGFcreateWindowClassHeaderP(b);
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        ret = WSGFreplaceTextFile((char*)fname,output->getString(encoding),False);
      }else{
        ret = WSGFreplaceTextFile((char*)fname,(char*)(*output),False);
      }
      delete output;
      if (ret != WS_NO_ERR){
        ret = file_output_error2(fname);
        if (ret != WS_DIALOG_OK){
          WSGFresetClassBase(win);
          return -1;
        }
      }

      if (win->getUserData(WS_RCLASS_GENERATE) != NULL){
      
        WSCstring outp = WSGFcreateVirtualRemoteClassHeader(win);
        char* rcname = (char*)win->getUserData(WS_RCLASS_NAME);
        if (rcname != NULL){
          fname = get_project_dir();
          fname << "/" << rcname << ".h";
          if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
            ret = WSGFreplaceTextFile((char*)fname,
                              outp.getString(encoding),False);
          }else{
            ret = WSGFreplaceTextFile((char*)fname,(char*)outp,False);
          }
          if (ret != WS_NO_ERR){
            ret = file_output_error2(fname);
            if (ret != WS_DIALOG_OK){
              WSGFresetClassBase(win);
              return -1;
            }
          }
          outp = WSGFcreateVirtualRemoteClassSrc(win);
          fname = get_project_dir();
          fname << "/" << rcname << ".cpp";
          if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
            ret = WSGFreplaceTextFile((char*)fname,
                                 outp.getString(encoding),False);
          }else{
            ret = WSGFreplaceTextFile((char*)fname,(char*)outp,False);
          }
          if (ret != WS_NO_ERR){
            ret = file_output_error2(fname);
            if (ret != WS_DIALOG_OK){
              WSGFresetClassBase(win);
              return -1;
            }
          }
        }
      }
      WSGFresetClassBase(win);
    } //WS_LANG_CPP
  }else if (win->getUserData(WS_WIN_STORE)){
    fname << get_project_dir() << "/" << win->getInstanceName() << ".oof";
    WSGIconductor()->setSerializePath( "" );
    WSDserialize* db = WSGIconductor()->beginTransaction("FILE",(char*)fname);
    if (db != NULL){
      WSCbase* b = WSGFgetClassBase(win);
      WSGIconductor()->save(db,b->getClassName(),win->getInstanceName(),b);
      WSGIconductor()->endTransaction(db);
      WSGFresetClassBase(win);
    }else{
      ret = file_output_error2(fname);
      if (ret != WS_DIALOG_OK){
        return -1;
      }
    }
  }else{
    WSCbool mpfc_mapping = pe->useMpfcMapping();

    fname = get_project_dir();
    WSCstring* output = NULL;
    if (pe->getLanguage() == WS_LANG_RUBY){
      fname << "/" << win->getInstanceName() << ".rb";
      if (mpfc_mapping != False){
        output = WSGFcreateWindowSrcRb(win);
      }else{
        output = WSGFcreateWindowSrcMwtRb(win);
      }
    }else
    if (pe->getLanguage() == WS_LANG_PYTHON){
      fname << "/" << win->getInstanceName() << ".py";
      if (mpfc_mapping != False){
        output = WSGFcreateWindowSrcPy(win);
      }else{
        output = WSGFcreateWindowSrcMwtPy(win);
      }
    }else
    if (pe->getLanguage() == WS_LANG_PERL){
      fname << "/" << win->getInstanceName() << ".pl";
      if (mpfc_mapping != False){
        output = WSGFcreateWindowSrcPerl(win);
      }else{
        output = WSGFcreateWindowSrcMwtPerl(win);
      }
    }else
    if (pe->getLanguage() == WS_LANG_JAVA){
      WSCstring pkgname = pe->getProjectData("#JAVA_PKG_NAME");
      pkgname.delHeadSpace();
      pkgname.delTailSpace();
      fname << "/" << win->getInstanceName() << ".java";
      if (mpfc_mapping != False){
        output = WSGFcreateWindowSrcJava(win,(char*)pkgname);
      }else{
        output = WSGFcreateWindowSrcMwtJava(win,(char*)pkgname);
      }
    }else
    if (pe->getLanguage() == WS_LANG_OCAML){
      fname << "/" << win->getInstanceName() << ".ml";
      if (mpfc_mapping != False){
        output = WSGFcreateWindowSrcOcaml(win);
      }else{
        output = WSGFcreateWindowSrcMwtOcaml(win);
      }
    }else{
      fname << "/" << win->getInstanceName() << ".cpp";
      output = WSGFcreateWindowSrc(win);
    } 
    long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
      encoding = WS_EN_LOCALE;
    }

    ret = WSGFreplaceTextFile((char*)fname,output->getString(encoding),False);
    delete output;
    if (ret != WS_NO_ERR){
      ret = file_output_error2(fname);
      if (ret != WS_DIALOG_OK){
        return -1;
      }
    }
    if (pe->getLanguage() == WS_LANG_CPP){
      fname = get_project_dir();
      fname << "/" << win->getInstanceName() << ".h";
      WSCstring* output2 = WSGFcreateWindowHeader(win);
      ret = WSGFreplaceTextFile((char*)fname,
                                 output2->getString(encoding),False);
      delete output2;
      if (ret != WS_NO_ERR){
        ret = file_output_error2(fname);
        if (ret != WS_DIALOG_OK){
          return -1;
        }
      }
    }
  }
  return 0;    
}

long create_window_srcs(){
  long i;
  long num = winlist.getNum();
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)winlist[i];
    if (win->getUserData(WS_REGISTERED) == (void*)0){
      continue;
    }
    if (create_window_src(win) != 0){
      return -1;
    }
  }
  return 0;
}

long create_makefile(){
  update_lib_list();

  WSCstring buffer; 
  long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }

//  if (encoding == WS_EN_LOCALE || encoding == WS_EN_NONE ||
//      encoding == WS_EN_DEFAULT ){
//    encoding = WSGIappLocaleSet()->getDefaultEncoding();
//  }
  WSCstring enc;
  enc = WSGFgetEncodingName(encoding);
  WSCstring mfname;
  mfname << "$(WSDIR)/sys/data/" << enc
         << "/make_exe" << pe->getTargetSuffixName();

  if (WSGFcheckExistFile(WSGIappFileSystem()->adjustFileName((char*)mfname)) == False){
    enc = "C";
    mfname ="";
    mfname << "$(WSDIR)/sys/data/" << enc
         << "/make_exe" << pe->getTargetSuffixName();
  }
  WSCstring mfname_dll;
  mfname_dll << "$(WSDIR)/sys/data/" << enc
             << "/make_dll" << pe->getTargetSuffixName();

  WSCstring mfname_nsp;
  mfname_nsp << "$(WSDIR)/sys/data/" << enc
             << "/make_nsp" << pe->getTargetSuffixName();

  WSCstring mfname_iep;
  mfname_iep << "$(WSDIR)/sys/data/" << enc
             << "/make_iep" << pe->getTargetSuffixName();

  WSCstring test_html;
  if (get_link_type() == 3){
    test_html << "$(WSDIR)/sys/data/test-iep.html";
  }else{
    test_html << "$(WSDIR)/sys/data/test.html";
  }
  long lang = pe->getLanguage();
//  long map_type = pe->getOldSwigMapping();
  long mpfc_mapping = pe->useMpfcMapping();
  if (lang == WS_LANG_CPP || lang == WS_LANG_OCAML){
  if (get_link_type() == 0 || 
      get_link_type() == 2 || get_link_type() == 3 ||
      get_link_type() == 4){
#ifdef MSW
    if (get_link_type() == 0||
        get_link_type() == 4){
      buffer = WSGIappFileSystem()->adjustFileName(mfname);
    }else if (get_link_type() == 2){
      buffer = WSGIappFileSystem()->adjustFileName(mfname_nsp);
    }else if (get_link_type() == 3){
      buffer = WSGIappFileSystem()->adjustFileName(mfname_iep);
    }
    if (lang == WS_LANG_OCAML){
      mfname = "";
      if (mpfc_mapping != False){
        mfname << "$(WSDIR)/sys/data/" << enc
               << "/make_ocaml_mpfc";
      }else{
        mfname << "$(WSDIR)/sys/data/" << enc
               << "/make_ocaml";
      }
      buffer = WSGIappFileSystem()->adjustFileName(mfname);
    }
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    WSCstring buffer2;
    buffer2 << get_project_dir() << "/" << WS_MAKE_FILE2;
    while( buffer2.replaceString("//","/",0));
    while( buffer2.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else
#ifdef BTRON
    WSCstring buffer2;
    if (get_link_type() == 0 ||
        get_link_type() == 4){
      buffer = WSGIappFileSystem()->adjustFileName(mfname);
    }else if (get_link_type() == 2){
      buffer = WSGIappFileSystem()->adjustFileName(mfname_nsp);
    }
    if (lang == WS_LANG_OCAML){
      mfname = "";
      if (mpfc_mapping != False){
        mfname << "$(WSDIR)/sys/data/" << enc
               << "/make_ocaml_mpfc";
      }else{
        mfname << "$(WSDIR)/sys/data/" << enc
               << "/make_ocaml";
      }
      buffer = WSGIappFileSystem()->adjustFileName(mfname);
    }
    buffer2 << get_project_dir() << "/" << WS_MAKE_FILE2;
    copy_file( (char*)buffer,(char*)buffer2);
#else
    if (get_link_type() == 0 ||
        get_link_type() == 4){
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(mfname)
           << "\" \"" << get_project_dir() << "/" << WS_MAKE_FILE2 << "\"";
    }else if (get_link_type() == 2){
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(mfname_nsp) 
           << "\" \"" << get_project_dir() << "/" << WS_MAKE_FILE2 << "\"";
    }
    if (lang == WS_LANG_OCAML){
      mfname = "";
      if (mpfc_mapping != False){
        mfname << "$(WSDIR)/sys/data/" << enc
               << "/make_ocaml_mpfc";
      }else{
        mfname << "$(WSDIR)/sys/data/" << enc
               << "/make_ocaml";
      }
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(mfname)
           << "\" \"" << get_project_dir() << "/" << WS_MAKE_FILE2 << "\"";
    }
    system((char*)buffer);
#endif

    WSCvariant static_linked = pe->getProjectData("#STLINK");
    if (atoi(static_linked) == 1 && lang != WS_LANG_OCAML){
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_XPM_DLL);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_XPM_DLL;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_XPM_DLL) 
           << "\" \"" << get_project_dir() << "/" << WS_XPM_DLL << "\"";
      system((char*)buffer);
#endif
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_PNG_DLL);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_PNG_DLL;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_PNG_DLL) 
           << "\" \"" << get_project_dir() << "/" << WS_PNG_DLL << "\"";
      system((char*)buffer);
#endif

#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_JPG_DLL);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_JPG_DLL;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_JPG_DLL) 
           << "\" \"" << get_project_dir() << "/" << WS_JPG_DLL << "\"";
      system((char*)buffer);
#endif
    }
#endif
    if ((get_link_type() == 2 || get_link_type() == 3) &&
        lang != WS_LANG_OCAML){
      WSCstring* buf2 = WSGFreadTextFile(test_html);
      if (buf2 != NULL){
        buf2->replaceString("#PROGRAM#",get_vproduct_name(),0);
        WSCstring buffer2;
 
        if (get_link_type() == 2){
          buffer2 << get_project_dir() << "/test.html";
        }else if (get_link_type() == 3){
          buffer2 << get_project_dir() << "/test.html";
          long val = 0;
          sscanf( pe->getProjectData("#ID"),"%x",&val);
          char buffer[1024];
          sprintf(buffer,"%08x",val+3);
          buf2->replaceString("#ID#",buffer,0);
        }
#ifdef MSW
        while( buffer2.replaceString("//","/",0));
        while( buffer2.replaceString("/","\\",0));
#endif //MSW
        WSGFreplaceTextFile(buffer2,buf2->getString(),False);
        delete buf2;
      }
    }

  }else if (lang == WS_LANG_CPP){
#ifdef MSW
    buffer = WSGIappFileSystem()->adjustFileName(mfname_dll);
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    WSCstring buffer2;
    buffer2 << get_project_dir() << "/" << WS_MAKE_FILE2;
    while( buffer2.replaceString("//","/",0));
    while( buffer2.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
             buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else
#ifdef BTRON
    buffer = WSGIappFileSystem()->adjustFileName(mfname_dll);
    WSCstring buffer2 = get_project_dir();
    buffer2 << "/" << WS_MAKE_FILE2;
    copy_file((char*)buffer,(char*)buffer2);
#else
    buffer = "\\cp \"";
    buffer << WSGIappFileSystem()->adjustFileName(mfname_dll) 
           << "\" \"" << get_project_dir() << "/" << WS_MAKE_FILE2 << "\"";
    system((char*)buffer);
#endif
#endif
  }

#ifdef MSW
  WSCstring mkflags_fname(WS_MAKE_FLAGS);
  mkflags_fname << pe->getTargetSuffixName();
  buffer = WSGIappFileSystem()->adjustFileName(mkflags_fname);
  while( buffer.replaceString("//","/",0));
  while( buffer.replaceString("/","\\",0));
  WSCstring buffer2;
  buffer2 << get_project_dir() << "/" << WS_MAKE_FLAGS2;
  while( buffer2.replaceString("//","/",0));
  while( buffer2.replaceString("/","\\",0));
  CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
             buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else
#ifdef BTRON
  WSCstring mkflags_fname(WS_MAKE_FLAGS);
  mkflags_fname << pe->getTargetSuffixName();
  buffer = WSGIappFileSystem()->adjustFileName(mkflags_fname);
  WSCstring buffer2 = get_project_dir();
  buffer2 << "/" << WS_MAKE_FLAGS2;
  copy_file((char*)buffer,(char*)buffer2);
#else
#ifdef MacOS
  if (get_link_type() == 0 ||
      get_link_type() == 4 ){
    WSCstring mac_sh;
    mac_sh << "$(WSDIR)/sys/data/sample.sh";
    WSCstring* buf_sh = WSGFreadTextFile(mac_sh);
    if (buf_sh != NULL){
      buf_sh->replaceString("#PROGRAM#",get_vproduct_name(),0);
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << get_vproduct_name() << ".sh";
      WSGFreplaceTextFile(buffer2,buf_sh->getString(),False);
      buffer2 = "chmod a+x ";
      buffer2 << get_project_dir() << "/" << get_vproduct_name() << ".sh";
      system((char*)buffer2);
      delete buf_sh;
    }
  }
#endif
  buffer = "\\cp \"";
  buffer << WSGIappFileSystem()->adjustFileName(WS_MAKE_FLAGS) 
         << pe->getTargetSuffixName()
         << "\" \"" << get_project_dir() << "/" << WS_MAKE_FLAGS2 << "\"";
  system((char*)buffer);
#endif
#endif
  }else
  if (lang == WS_LANG_RUBY){
#ifdef MSW
#define WS_RUBY_LIB  "$(WSDIR)/lib/mpfc.dll"
#define WS_RUBY_LIB2  "mpfc.dll"
#define WS_RUBY_LIB_MWT  "$(WSDIR)/lib/mwt.dll"
#define WS_RUBY_LIB2_MWT  "mwt.dll"
    if (mpfc_mapping != False){
      buffer = WSGIappFileSystem()->adjustFileName(WS_RUBY_LIB);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_RUBY_LIB2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }else{
      buffer = WSGIappFileSystem()->adjustFileName(WS_RUBY_LIB_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_RUBY_LIB2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
     }
#else
#ifndef MacOS
#define WS_RUBY_LIB  "$(WSDIR)/lib/mpfc.so"
#define WS_RUBY_LIB2  "mpfc.so"
#define WS_RUBY_LIB_MWT  "$(WSDIR)/lib/mwt.so"
#define WS_RUBY_LIB2_MWT  "mwt.so"
#else //MacOS
#define WS_RUBY_LIB  "$(WSDIR)/lib/mpfc.bundle"
#define WS_RUBY_LIB2  "mpfc.bundle"
#define WS_RUBY_LIB_MWT  "$(WSDIR)/lib/mwt.bundle"
#define WS_RUBY_LIB2_MWT  "mwt.bundle"
#endif //MacOS
    if (mpfc_mapping != False){
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_RUBY_LIB);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_RUBY_LIB2;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_RUBY_LIB) 
             << "\" \"" << get_project_dir() << "/" << WS_RUBY_LIB2 << "\"";
      system((char*)buffer);
#endif
    }else{
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_RUBY_LIB_MWT);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_RUBY_LIB2_MWT;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_RUBY_LIB_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_RUBY_LIB2_MWT << "\"";
      system((char*)buffer);
#endif
    }
#endif
  }else
  if (lang == WS_LANG_PYTHON){
#ifdef MSW
#define WS_PYTHON_LIB  "$(WSDIR)/lib/_mpfc.dll"
#define WS_PYTHON_LIB2  "_mpfc.dll"
#define WS_PYTHON_LIB_MWT  "$(WSDIR)/lib/_mwt.dll"
#define WS_PYTHON_LIB2_MWT  "_mwt.dll"
#define WS_PYTHON_SRC  "$(WSDIR)/lib/mpfc.py"
#define WS_PYTHON_SRC2  "mpfc.py"
#define WS_PYTHON_SRC_MWT  "$(WSDIR)/lib/mwt.py"
#define WS_PYTHON_SRC2_MWT  "mwt.py"
    if (mpfc_mapping != False){
      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_LIB);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_PYTHON_LIB2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_SRC);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      buffer2 = "";
      buffer2 << get_project_dir() << "/" << WS_PYTHON_SRC2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

    }else{
      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_LIB_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_PYTHON_LIB2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_SRC_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      buffer2 = "";
      buffer2 << get_project_dir() << "/" << WS_PYTHON_SRC2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }

#else
#ifndef MacOS
#define WS_PYTHON_LIB  "$(WSDIR)/lib/_mpfcmodule.so"
#define WS_PYTHON_LIB2  "_mpfcmodule.so"
#define WS_PYTHON_LIB_MWT  "$(WSDIR)/lib/_mwtmodule.so"
#define WS_PYTHON_LIB2_MWT  "_mwtmodule.so"
#else //MacOS
#define WS_PYTHON_LIB  "$(WSDIR)/lib/_mpfcmodule.so"
#define WS_PYTHON_LIB2  "_mpfcmodule.so"
#define WS_PYTHON_LIB_MWT  "$(WSDIR)/lib/_mwtmodule.so"
#define WS_PYTHON_LIB2_MWT  "_mwtmodule.so"
#endif //MacOS
#define WS_PYTHON_SRC  "$(WSDIR)/lib/mpfc.py"
#define WS_PYTHON_SRC2  "mpfc.py"
#define WS_PYTHON_SRC_MWT  "$(WSDIR)/lib/mwt.py"
#define WS_PYTHON_SRC2_MWT  "mwt.py"

    if (mpfc_mapping != False){
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_LIB);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_PYTHON_LIB2;
      copy_file((char*)buffer,(char*)buffer2);

      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_SRC);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_PYTHON_SRC2;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PYTHON_LIB) 
             << "\" \"" << get_project_dir() << "/" << WS_PYTHON_LIB2 << "\"";
      system((char*)buffer);

      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PYTHON_SRC) 
             << "\" \"" << get_project_dir() << "/" << WS_PYTHON_SRC2 << "\"";
      system((char*)buffer);
#endif
    }else{
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_LIB_MWT);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_PYTHON_LIB2_MWT;
      copy_file((char*)buffer,(char*)buffer2);

      buffer = WSGIappFileSystem()->adjustFileName(WS_PYTHON_SRC_MWT);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_PYTHON_SRC2_MWT;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PYTHON_LIB_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_PYTHON_LIB2_MWT << "\"";
      system((char*)buffer);

      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PYTHON_SRC_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_PYTHON_SRC2_MWT << "\"";
      system((char*)buffer);
#endif
    }

#endif
  }else
  if (lang == WS_LANG_PERL){
#ifdef MSW
#define WS_PERL_LIB  "$(WSDIR)/lib/mpfc_perl.dll"
#define WS_PERL_LIB2  "mpfc_perl.dll"
#define WS_PERL_LIB_MWT  "$(WSDIR)/lib/mwt_perl.dll"
#define WS_PERL_LIB2_MWT  "mwt_perl.dll"
#define WS_PERL_SRC  "$(WSDIR)/lib/mpfc.pm"
#define WS_PERL_SRC2  "mpfc.pm"
#define WS_PERL_SRC_MWT  "$(WSDIR)/lib/mwt.pm"
#define WS_PERL_SRC2_MWT  "mwt.pm"
    if (mpfc_mapping != False){
      buffer = WSGIappFileSystem()->adjustFileName(WS_PERL_LIB);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_PERL_LIB2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

      buffer = WSGIappFileSystem()->adjustFileName(WS_PERL_SRC);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      buffer2 = "";
      buffer2 << get_project_dir() << "/" << WS_PERL_SRC2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }else{
      buffer = WSGIappFileSystem()->adjustFileName(WS_PERL_LIB_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_PERL_LIB2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

      buffer = WSGIappFileSystem()->adjustFileName(WS_PERL_SRC_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      buffer2 = "";
      buffer2 << get_project_dir() << "/" << WS_PERL_SRC2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }
#else

#ifndef MacOS 
#define WS_PERL_LIB  "$(WSDIR)/lib/mpfc_perl.so"
#define WS_PERL_LIB2  "mpfc_perl.so"
#define WS_PERL_LIB_MWT  "$(WSDIR)/lib/mwt_perl.so"
#define WS_PERL_LIB2_MWT  "mwt_perl.so"
#else //MacOS
#define WS_PERL_LIB  "$(WSDIR)/lib/mpfc_perl.bundle"
#define WS_PERL_LIB2  "mpfc_perl.bundle"
#define WS_PERL_LIB_MWT  "$(WSDIR)/lib/mwt_perl.bundle"
#define WS_PERL_LIB2_MWT  "mwt_perl.bundle"
#endif

#define WS_PERL_SRC  "$(WSDIR)/lib/mpfc.pm"
#define WS_PERL_SRC2  "mpfc.pm"
#define WS_PERL_SRC_MWT  "$(WSDIR)/lib/mwt.pm"
#define WS_PERL_SRC2_MWT  "mwt.pm"

    if (mpfc_mapping != False){
#ifdef BTRON
      buffer << WSGIappFileSystem()->adjustFileName(WS_PERL_LIB);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_PERL_LIB2;
      copy_file((char*)buffer,(char*)buffer2);
      buffer = WSGIappFileSystem()->adjustFileName(WS_PERL_SRC);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_PERL_SRC2;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PERL_LIB) 
             << "\" \"" << get_project_dir() << "/" << WS_PERL_LIB2 << "\"";
      system((char*)buffer);
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PERL_SRC) 
             << "\" \"" << get_project_dir() << "/" << WS_PERL_SRC2 << "\"";
      system((char*)buffer);
#endif
    }else{
#ifdef BTRON
      buffer << WSGIappFileSystem()->adjustFileName(WS_PERL_LIB_MWT);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_PERL_LIB2_MWT;
      copy_file((char*)buffer,(char*)buffer2);
      buffer = WSGIappFileSystem()->adjustFileName(WS_PERL_SRC_MWT);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_PERL_SRC2_MWT;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PERL_LIB_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_PERL_LIB2_MWT << "\"";
      system((char*)buffer);
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_PERL_SRC_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_PERL_SRC2_MWT << "\"";
      system((char*)buffer);
#endif
    }

#endif
  }else
  if (lang == WS_LANG_JAVA){
#ifdef MSW
#define WS_JAVA_LIB  "$(WSDIR)/lib/mpfc_java.dll"
#define WS_JAVA_LIB2  "mpfc_java.dll"
#define WS_JAVA_LIB_MWT  "$(WSDIR)/lib/mwt_java.dll"
#define WS_JAVA_LIB2_MWT  "mwt_java.dll"
#define WS_JAVA_SRC  "$(WSDIR)/lib/mpfc.jar"
#define WS_JAVA_SRC2  "mpfc.jar"
#define WS_JAVA_SRC_MWT  "$(WSDIR)/lib/mwt.jar"
#define WS_JAVA_SRC2_MWT  "mwt.jar"
    if (mpfc_mapping != False){
      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_JAVA_LIB2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      buffer2 = "";
      buffer2 << get_project_dir() << "/" << WS_JAVA_SRC2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }else{
      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_JAVA_LIB2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      buffer2 = "";
      buffer2 << get_project_dir() << "/" << WS_JAVA_SRC2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }
#else

#ifndef MacOS
#define WS_JAVA_LIB  "$(WSDIR)/lib/libmpfc_java.so"
#define WS_JAVA_LIB2  "libmpfc_java.so"
#define WS_JAVA_LIB_MWT  "$(WSDIR)/lib/libmwt_java.so"
#define WS_JAVA_LIB2_MWT  "libmwt_java.so"
#else //MacOS
#define WS_JAVA_LIB  "$(WSDIR)/lib/libmpfc_java.jnilib"
#define WS_JAVA_LIB2  "libmpfc_java.jnilib"
#define WS_JAVA_LIB_MWT  "$(WSDIR)/lib/libmwt_java.jnilib"
#define WS_JAVA_LIB2_MWT  "libmwt_java.jnilib"
#endif //MacOS

#define WS_JAVA_SRC  "$(WSDIR)/lib/mpfc.jar"
#define WS_JAVA_SRC2  "mpfc.jar"
#define WS_JAVA_SRC_MWT  "$(WSDIR)/lib/mwt.jar"
#define WS_JAVA_SRC2_MWT  "mwt.jar"

    if (mpfc_mapping != False){
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_JAVA_LIB2;
      copy_file((char*)buffer,(char*)buffer2);

      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_JAVA_SRC2;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB) 
             << "\" \"" << get_project_dir() << "/" << WS_JAVA_LIB2 << "\"";
      system((char*)buffer);

      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC) 
             << "\" \"" << get_project_dir() << "/" << WS_JAVA_SRC2 << "\"";
      system((char*)buffer);
#endif
    }else{
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB_MWT);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_JAVA_LIB2_MWT;
      copy_file((char*)buffer,(char*)buffer2);

      buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC_MWT);
      buffer2 = get_project_dir();
      buffer2 << "/" << WS_JAVA_SRC2_MWT;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_JAVA_LIB2_MWT << "\"";
      system((char*)buffer);

      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_JAVA_SRC2_MWT << "\"";
      system((char*)buffer);
#endif
    }

#endif
  }
  if (lang == WS_LANG_OCAML){
#ifdef MSW

#define WS_OCAML_LIB  "$(WSDIR)/lib/dllmpfc_ocaml.dll"
#define WS_OCAML_LIB2  "dllmpfc_ocaml.dll"
#define WS_OCAML_LIB_MWT  "$(WSDIR)/lib/dllmwt_ocaml.dll"
#define WS_OCAML_LIB2_MWT  "dllmwt_ocaml.dll"

    if (mpfc_mapping != False){
      buffer = WSGIappFileSystem()->adjustFileName(WS_OCAML_LIB);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_OCAML_LIB2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }else{
      buffer = WSGIappFileSystem()->adjustFileName(WS_OCAML_LIB_MWT);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << get_project_dir() << "/" << WS_OCAML_LIB2_MWT;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
    }

#else

#ifndef MacOS
#define WS_OCAML_LIB  "$(WSDIR)/lib/dllmpfc_ocaml.so"
#define WS_OCAML_LIB2  "dllmpfc_ocaml.so"
#define WS_OCAML_LIB_MWT  "$(WSDIR)/lib/dllmwt_ocaml.so"
#define WS_OCAML_LIB2_MWT  "dllmwt_ocaml.so"
#else //MacOS
#define WS_OCAML_LIB  "$(WSDIR)/lib/dllmpfc_ocaml.dylib"
#define WS_OCAML_LIB2  "dllmpfc_ocaml.dylib"
#define WS_OCAML_LIB_MWT  "$(WSDIR)/lib/dllmwt_ocaml.dylib"
#define WS_OCAML_LIB2_MWT  "dllmwt_ocaml.dylib"
#endif //MacOS

    if (mpfc_mapping != False){
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_OCAML_LIB);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_OCAML_LIB2;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_OCAML_LIB) 
             << "\" \"" << get_project_dir() << "/" << WS_OCAML_LIB2 << "\"";
      system((char*)buffer);
#endif
    }else{
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(WS_OCAML_LIB_MWT);
      WSCstring buffer2 = get_project_dir();
      buffer2 << "/" << WS_OCAML_LIB2_MWT;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(WS_OCAML_LIB_MWT) 
             << "\" \"" << get_project_dir() << "/" << WS_OCAML_LIB2_MWT << "\"";
      system((char*)buffer);
#endif
    }

#endif
  }

  WSCstring mkinf_fname;
  WSCstring mkinf_fname2;
  WSCstring projectsrc_fname;
  if (strcmp(get_project_dir(),"")){
    mkinf_fname << get_project_dir() << "/";
    projectsrc_fname << get_project_dir() << "/";
  }
  mkinf_fname2 = mkinf_fname;
  mkinf_fname << "mk.inf";
  mkinf_fname2 << "makefile.env";
  if (lang == WS_LANG_RUBY){
    projectsrc_fname << get_pure_project_name() << ".rb";
  }else
  if (lang == WS_LANG_PYTHON){
    projectsrc_fname << get_pure_project_name() << ".py";
  }else
  if (lang == WS_LANG_PERL){
    projectsrc_fname << get_pure_project_name() << ".pl";
  }else
  if (lang == WS_LANG_JAVA){
    projectsrc_fname << get_pure_project_name() << ".java";
  }else
  if (lang == WS_LANG_OCAML){
    projectsrc_fname << get_pure_project_name() << ".ml";
  }else{
    projectsrc_fname << get_pure_project_name() << ".cpp";
  }

  WSCstring wininf,opinf;
  WSCstring prj_src;

  WSClistData  oplist;
  wininf << "WINOBJ = " << get_pure_project_name() << ".o \\\n";


  if (lang == WS_LANG_RUBY){
    if (mpfc_mapping != False){
      prj_src << "#\n";
      prj_src << "#WINDOW BUILDER PROJECT MASTER SRC\n";
      prj_src << "require 'mpfc'\n\n";
      prj_src << "Mpfc::WSGFdeviceInitialize()\n";
      prj_src << "app = Mpfc::WSGIappDev()\n";
      prj_src << "Mpfc::WSGFwsInitialize()\n\n";

      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "fontdata = Mpfc::WSCstring.new(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\")\n";
        prj_src << "Mpfc::WSGFsetFontData(fontdata)\n";
        delete font_data;
      }
      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        prj_src << "Mpfc::WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ")\n";
        if (encoding == WS_EN_UTF8){
          prj_src << "$KCODE = \"UTF8\"\n";
        }else if (encoding == WS_EN_EUCJP){
          prj_src << "$KCODE = \"EUC\"\n";
        }else if (encoding == WS_EN_SJIS){
          prj_src << "$KCODE = \"SJIS\"\n";
        }else if (encoding == WS_EN_EUCKR){
          prj_src << "$KCODE = \"EUCKR\"\n";
        }else if (encoding == WS_EN_EUCCN){
          prj_src << "$KCODE = \"EUCCN\"\n";
        }else{
          prj_src << "$KCODE = \"NONE\"\n";
        }
      }

      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "#--- OBJECT execute auto initialize ---\n";
          prj_src << "load \"" << win->getInstanceName() <<".rb\"\n";
  
        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
          //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
    }else{ //MWT Mapping..
      prj_src << "#\n";
      prj_src << "#WINDOW BUILDER PROJECT MASTER SRC\n";
      prj_src << "require 'mwt'\n\n";
      prj_src << "Mwt::WSGFdeviceInitialize()\n";
      prj_src << "app = Mwt::WSGIappDev()\n";
      prj_src << "Mwt::WSGFwsInitialize()\n\n";

      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "fontdata = Mwt::WSCstring.new(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\")\n";
        prj_src << "Mwt::WSGFsetFontData(fontdata)\n";
        delete font_data;
      }
      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        prj_src << "Mwt::WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ")\n";
        if (encoding == WS_EN_UTF8){
          prj_src << "$KCODE = \"UTF8\"\n";
        }else if (encoding == WS_EN_EUCJP){
          prj_src << "$KCODE = \"EUC\"\n";
        }else if (encoding == WS_EN_SJIS){
          prj_src << "$KCODE = \"SJIS\"\n";
        }else if (encoding == WS_EN_EUCKR){
          prj_src << "$KCODE = \"EUCKR\"\n";
        }else if (encoding == WS_EN_EUCCN){
          prj_src << "$KCODE = \"EUCCN\"\n";
        }else{
          prj_src << "$KCODE = \"NONE\"\n";
        }
      }

      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "#--- OBJECT execute auto initialize ---\n";
          prj_src << "load \"" << win->getInstanceName() <<".rb\"\n";
  
        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
          //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
 


    }

  }else
  if (lang == WS_LANG_PYTHON){
    if (mpfc_mapping != False){
      prj_src << "#\n";
      prj_src << "#WINDOW BUILDER PROJECT MASTER SRC\n";
      prj_src << "import mpfc\n\n";
      prj_src << "mpfc.WSGFdeviceInitialize()\n";
      prj_src << "app = mpfc.WSGIappDev()\n";
      prj_src << "mpfc.WSGFwsInitialize()\n\n";
      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "fontdata = mpfc.WSCstring(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\")\n";
        prj_src << "mpfc.WSGFsetFontData(fontdata)\n";
        delete font_data;
      }

      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        prj_src << "mpfc.WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ");\n";
      }

      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "#--- OBJECT execute auto initialize ---\n";
          prj_src << "import " << win->getInstanceName() <<"\n";

        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
          //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
    }else{
      prj_src << "#\n";
      prj_src << "#WINDOW BUILDER PROJECT MASTER SRC\n";
      prj_src << "import mwt\n\n";
      prj_src << "mwt.WSGFdeviceInitialize()\n";
      prj_src << "app = mwt.WSGIappDev()\n";
      prj_src << "mwt.WSGFwsInitialize()\n\n";
      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "fontdata = mwt.WSCstring(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\")\n";
        prj_src << "mwt.WSGFsetFontData(fontdata)\n";
        delete font_data;
      }

      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        prj_src << "mwt.WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ");\n";
      }

      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "#--- OBJECT execute auto initialize ---\n";
          prj_src << "import " << win->getInstanceName() <<"\n";

        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
          //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
    }
  }else
  if (lang == WS_LANG_PERL){
    if (mpfc_mapping != False){
      prj_src << "#\n";
      prj_src << "#WINDOW BUILDER PROJECT MASTER SRC\n";
      prj_src << "use mpfc;\n\n";
      prj_src << "mpfc::WSGFdeviceInitialize();\n";
      prj_src << "$app = mpfc::WSGIappDev();\n";
      prj_src << "mpfc::WSGFwsInitialize();\n\n";
 
      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "$fontdata = new mpfc::WSCstring(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\");\n";
        prj_src << "mpfc::WSGFsetFontData($fontdata);\n";
        delete font_data;
      }
 
      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        prj_src << "mpfc::WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ");\n";
      }

      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "#--- OBJECT execute auto initialize ---\n";
          prj_src << "require \"" << win->getInstanceName() <<".pl\";\n";
  
        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
            //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
    }else{
      prj_src << "#\n";
      prj_src << "#WINDOW BUILDER PROJECT MASTER SRC\n";
      prj_src << "use mwt;\n\n";
      prj_src << "mwt::WSGFdeviceInitialize();\n";
      prj_src << "$app = mwt::WSGIappDev();\n";
      prj_src << "mwt::WSGFwsInitialize();\n\n";
  
      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "$fontdata = new mwt::WSCstring(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\");\n";
        prj_src << "mwt::WSGFsetFontData($fontdata);\n";
        delete font_data;
      }

      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
        prj_src << "mwt::WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ");\n";
      }

      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "#--- OBJECT execute auto initialize ---\n";
          prj_src << "require \"" << win->getInstanceName() <<".pl\";\n";
  
        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
            //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
 

    }
  }else
  if (lang == WS_LANG_JAVA){
    if (mpfc_mapping != False){
      prj_src << "//WINDOW BUILDER PROJECT MASTER SRC\n";
      WSCstring pkgname = pe->getProjectData("#JAVA_PKG_NAME");
      pkgname.delHeadSpace();
      pkgname.delTailSpace();
      if (strcmp((char*)pkgname,"")){
        prj_src << "package " << pkgname << ";\n\n";
      }
      prj_src << "import org.widestudio.mpfc.*;\n\n";
      prj_src << "public class " << get_product_name() << "{\n";
      prj_src << "  static{\n";
      prj_src << "    System.loadLibrary(\"mpfc_java\");\n";
      prj_src << "  };\n";
      prj_src << "  public static void main(String[] args){\n";
      prj_src << "    Mpfc.WSGFdeviceInitialize();\n";
      prj_src << "    WSDappDev app = Mpfc.WSGIappDev();\n";
      prj_src << "    Mpfc.WSGFwsInitialize();\n\n";

      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "   WSCstring fontdata = new WSCstring(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\");\n";
        prj_src << "    Mpfc.WSGFsetFontData(fontdata);\n";
        delete font_data;
      }
 

      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
#if 0 //for java fixed encoding: UTF8
        prj_src << "    Mpfc.WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ");\n";
#else
        prj_src << "    Mpfc.WSGFsetDefaultEncoding(16);\n";
#endif
      }
      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "    //--- OBJECT execute auto initialize ---\n";
          prj_src << "    " << win->getInstanceName() <<".create_win_"
                  << win->getInstanceName() << "();\n";
  
        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
          //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
    }else{
      prj_src << "//WINDOW BUILDER PROJECT MASTER SRC\n";
      WSCstring pkgname = pe->getProjectData("#JAVA_PKG_NAME");
      pkgname.delHeadSpace();
      pkgname.delTailSpace();
      if (strcmp((char*)pkgname,"")){
        prj_src << "package " << pkgname << ";\n\n";
      }
      prj_src << "import org.widestudio.mwt.*;\n\n";
      prj_src << "public class " << get_product_name() << "{\n";
      prj_src << "  static{\n";
      prj_src << "    System.loadLibrary(\"mwt_java\");\n";
      prj_src << "  };\n";
      prj_src << "  public static void main(String[] args){\n";
      prj_src << "    Mwt.WSGFdeviceInitialize();\n";
      prj_src << "    WSDappDev app = Mwt.WSGIappDev();\n";
      prj_src << "    Mwt.WSGFwsInitialize();\n\n";

      WSCstring* font_data = WSGFgetFontSaveData();
      if (font_data != NULL){
        prj_src << "    WSCstring fontdata = new WSCstring(\"";
        font_data->replaceString("\n","\\n",0);
        prj_src << font_data->getString() << "\");\n";
        prj_src << "    Mwt.WSGFsetFontData(fontdata);\n";
        delete font_data;
      }

      encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
      if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
#if 0 //for java fixed encoding: UTF8
        prj_src << "    Mwt.WSGFsetDefaultEncoding(" <<
                    WSGFltoa(encoding) << ");\n";
#else
        prj_src << "    Mwt.WSGFsetDefaultEncoding(16);\n";
#endif
      }
      long i;
      long num =  winlist.getNum();
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        WSGFgetProcedureList(win,&oplist);
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
             (long)win->getUserData(WS_WIN_STORE) == 0 ){
          prj_src << "    //--- OBJECT execute auto initialize ---\n";
          prj_src << "    " << win->getInstanceName() <<".create_win_"
                  << win->getInstanceName() << "();\n";
  
        }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
          //Ϥʤ...
        }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
          //Ϥʤ...
        }
      }
    }
  }else
  if (lang == WS_LANG_OCAML){
    prj_src << "(* WINDOW BUILDER PROJECT MASTER SRC *)\n";
    prj_src << "open Swig\n";
    if (mpfc_mapping != False){
      prj_src << "open Mpfclib\n";
    }else{
      prj_src << "open Mwtlib\n";
    }
    encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
      prj_src << "let _ = init_application " << encoding << " ";
    }else{
      prj_src << "let _ = init_application 1 ";
    }

    WSCstring* font_data = WSGFgetFontSaveData();
    if (font_data != NULL){
      font_data->replaceString("\n","\\n",0);
      prj_src << "\"" << font_data->getString() << "\"";
      delete font_data;
    }

    prj_src << "\n\n";

    long i;
    long num =  winlist.getNum();
    for(i=0; i< num; i++){
      WSCbase* win = (WSCbase*)winlist[i];
extern void WSGFcreateWindowInstanceList2Ocaml(WSCstring* str,WSCbase* base);
      WSGFcreateWindowInstanceList2Ocaml(&prj_src,win);
    }
    prj_src << "\n\n";
    for(i=0; i< num; i++){
      WSCbase* win = (WSCbase*)winlist[i];
      wininf << "        ";
      wininf << win->getInstanceName();
      if (i == num -1){
        wininf << ".o \n";
      }else{
        wininf << ".o \\\n";
      }
extern void WSGFcreateWindowInstanceList3Ocaml(WSCstring* str,WSCbase* base);
      if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
           (long)win->getUserData(WS_WIN_STORE) == 0 ){
        prj_src << "(*--- OBJECT execute auto initialize ---*)\n";
        prj_src << "let _ = _create_win_" << win->getInstanceName() <<"()\n";
        WSGFcreateWindowInstanceList3Ocaml(&prj_src,win);
        prj_src << "\n";
      }
      WSGFgetProcedureList(win,&oplist);
    }
    prj_src << "\n\n";
  }else{
    prj_src << "//WINDOW BUILDER PROJECT MASTER SRC//\n";
    prj_src << "#include <WScom.h>\n";
    prj_src << "#include <WSDappDev.h>\n";
    prj_src << "#include <WSCbaseList.h>\n\n";
    prj_src << "#include <WSClocaleSet.h>\n\n";
    prj_src << "#ifdef MSW\n";
    prj_src << "WS_WINMAIN\n";
    prj_src << "#endif\n\n";

    prj_src << "char* mou[] = {\n";
    prj_src << "WS_DEFAULT_MOUSE_ID,\n";
//    WSCstring* mou_data = WSGFgetMouseCursorSaveData();
//    if (mou_data != NULL){
//      while(!mou_data->eof()){
//        WSCstring data = mou_data->gets();
//        prj_src << "\"" << data << "\",\n";
//      }
//      delete mou_data;
//    }
    prj_src << "NULL};\n\n" << "void _mouse_init_(){\n";
    prj_src << "  WSGFloadMouseCursorData(mou);\n}\n\n";

    prj_src << "char* fon[] = {\n";
    WSCstring* font_data = WSGFgetFontSaveData();
    if (font_data != NULL){
      while(!font_data->eof()){
        WSCstring data = font_data->gets();
        prj_src << "\"" << data << "\",\n";
      }
      delete font_data;
    }
    prj_src << "NULL};\n\n";
    if (strcmp(pe->getGuiPolicy(),"")){
      WSCstring policy = pe->getGuiPolicy();
      prj_src << "void _policy_init_(){\n";
      prj_src << "  WSGIappDev()->setGuiPolicy(" << policy.getWord(0,",") << ",False);\n";
      prj_src << "  WSGIappDev()->setExtGuiPolicy(\"" << policy.getWord(1,",") << "\",True);\n";
      prj_src << "}\n";
    }

    prj_src << "void _font_init_(){\n  WSGFloadFontData(fon);\n}\n";
    prj_src << "class _init_app_class_{\n";
    prj_src << "  public: _init_app_class_(){\n";

    prj_src << "    WSGFdeviceInitialize();\n";
//    prj_src << "    WSGIappDev()->setInitHandler(_color_init_);\n";
    if (strcmp(pe->getGuiPolicy(),"")){
      prj_src << "    WSGIappDev()->setInitHandler(_policy_init_);\n";
    }
    prj_src << "    WSGIappDev()->setInitHandler(_font_init_);\n";
    prj_src << "    WSGIappDev()->setInitHandler(_mouse_init_);\n";
    encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
      prj_src << "    WSGIappLocaleSet()->setDefaultEncoding(" <<
                  WSGFltoa(encoding) << ");\n";
    }
    prj_src << "    WSDappDev* app = WSGIappDev();\n";
    prj_src << "    app->setInstanceName(\"";
    prj_src << get_product_name();
    prj_src << "\");\n";
    WSCstring pl = pe->getGuiPolicy();
    if (strcmp((char*)pl,"")){
      WSCstring value = pl.getWord(0,",");
      WSCstring exname = pl.getWord(1,",");
      if (!strcmp(exname,"")){
        prj_src << "    app->setGuiPolicy(" << value << ",True);\n";
      }else{
        prj_src << "    app->setGuiPolicy(" << value << ",False);\n";
        prj_src << "    app->setExtGuiPolicy(\"" << exname << "\",True);\n";
      }
    }
    prj_src << "  };\n};\nstatic _init_app_class_ _execute_app_class_;\n\n";

    long i;
    long num =  winlist.getNum();
    for(i=0; i< num -1; i++){
      WSCbase* win = (WSCbase*)winlist[i];
      if (win->getUserData(WS_REGISTERED) == (void*)0){
        continue;
      }
      WSGFgetProcedureList(win,&oplist);
      if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
           (long)win->getUserData(WS_WIN_STORE) == 0 ){
        wininf << "        ";
        wininf << win->getInstanceName();
        wininf << ".o \\\n";
  
        if (get_link_type() == 0|| //NORMAL APPLICATION
            get_link_type() == 4){ //CONSOLE APPLICATION
          prj_src << "//--- OBJECT execute auto initialize ---//\n";
          prj_src << "extern WSDLEX WSCbase* _create_win_";
          prj_src << win->getInstanceName() << "();\n";
  
          prj_src << "class _initialize_window_" << WSGFltoa(i);
          prj_src << "{\n public: _initialize_window_" << WSGFltoa(i);
          prj_src << "(){\n  WSGIappDev()->setInitHandler((void(*)())_create_win_";
          prj_src << win->getInstanceName() << ");\n";
  
          prj_src << " };\n";
          prj_src << "};\n";
          prj_src << "static _initialize_window_";
          prj_src << WSGFltoa(i);
          prj_src << " _execute_initialize_";
          prj_src << WSGFltoa(i);
          prj_src << ";\n\n";
        }else if (get_link_type() == 2 || get_link_type() == 3){ //NETSCAPE/IE PLUGIN
          prj_src << "extern WSDLEX WSCbase* _create_win_";
          prj_src << win->getInstanceName();
          prj_src << "();\n";
        } 
      }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
        wininf << "        ";
        wininf << win->getInstanceName();
        wininf << ".o \\\n";
        if ((long)win->getUserData(WS_RCLASS_GENERATE) == 1){
          char* rcname = (char*)win->getUserData(WS_RCLASS_NAME);
          if (rcname != NULL){
            wininf << "        " << rcname << ".o\\\n";
          }
        }
        wininf << "        ";
        wininf << win->getInstanceName();
        wininf << "P.o \\\n";
      }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
        //Ϥʤ...
      }
    }
    if (num > 0){
      WSCbase* win = (WSCbase*)winlist[num-1];
      WSGFgetProcedureList(win,&oplist);
      if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
           (long)win->getUserData(WS_WIN_STORE) == 0 ){
        wininf << "        ";
        wininf << win->getInstanceName();
        wininf << ".o ";

        if (get_link_type() == 0 || //NORMAL APPLICATION
            get_link_type() == 4){ //CONSOLE APPLICATION
          prj_src << "//--- OBJECT execute auto initialize ---//\n";
          prj_src << "extern WSDLEX WSCbase* _create_win_";
          prj_src << win->getInstanceName();
          prj_src << "();\n";
          prj_src << "class _initialize_window_";
          prj_src << WSGFltoa(i);
          prj_src << "{\n public: _initialize_window_";
          prj_src << WSGFltoa(i);
          prj_src << "(){\n  WSGIappDev()->setInitHandler((void(*)())_create_win_";
          prj_src << win->getInstanceName() << ");\n";

          prj_src << " };\n";
          prj_src << "};\n";
          prj_src << "static _initialize_window_";
          prj_src << WSGFltoa(i);
          prj_src << " _execute_initialize_";
          prj_src << WSGFltoa(i);
          prj_src << ";\n\n";
        }else if (get_link_type() == 2 || get_link_type() == 3){ //NETSCAPE/IE PLUGIN
          prj_src << "extern WSDLEX WSCbase* _create_win_";
          prj_src << win->getInstanceName();
          prj_src << "();\n";
        }
      }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
        wininf << "        ";
        wininf << win->getInstanceName();
        wininf << ".o \\\n";
        if ((long)win->getUserData(WS_RCLASS_GENERATE) == 1){
          char* rcname = (char*)win->getUserData(WS_RCLASS_NAME);
          if (rcname != NULL){
            wininf << "        " << rcname << ".o\\\n";
          }
        }
        wininf << "        ";
        wininf << win->getInstanceName() << "P.o ";
      }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
        //Ϥʤ...
      }
    }

    if (get_link_type() == 2 || get_link_type() == 3){ //NETSCAPE/IE PLUGIN
      prj_src << "extern int WSGFwsInitialize();\n";
      prj_src << "extern \"C\" {\n";
      prj_src << "void _ws_initialize(void* context){\n";
      prj_src << "  WSGIappDev()->setContext(context);\n";
      prj_src << "  WSGFwsInitialize();\n";
      prj_src << "};\n";
      prj_src << "void _ws_set_window(void* win){\n";
      prj_src << "  WSGIappDev()->setContext2(win);\n";
      prj_src << "};\n";
      prj_src << "WSCbase* _ws_create_window(){\n";
      prj_src << "//--- OBJECT execute auto initialize ---//\n";
      int cnt = 0;
      for(i=0; i< num; i++){
        WSCbase* win = (WSCbase*)winlist[i];
        if (win->getUserData(WS_REGISTERED) == (void*)0){
          continue;
        }
        cnt++;
        if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
           (long)win->getUserData(WS_WIN_STORE) == 0 ){
          if (i==0){
            prj_src << "  WSCbase* ret = _create_win_";
            prj_src << win->getInstanceName();
            prj_src << "();\n";
          }else{
            prj_src << "  _create_win_";
            prj_src << win->getInstanceName();
            prj_src << "();\n";
          }
        }
      }
      if (get_link_type() == 2){ //NETSCAPE PLUGIN
        prj_src << "  WSGFwsNsPluginInitialize();\n";
      }else{ //IE PLUGIN
        prj_src << "  WSGFwsIePluginInitialize();\n";
      }
      if (cnt==0){
        prj_src << "  return NULL;\n";
      }else{
        prj_src << "  return ret;\n";
      }
      prj_src << "};\n";
      prj_src << "};\n";
      prj_src << "\n";
      if (get_link_type() == 3){ //NETSCAPE PLUGIN
        long val = 0;
        sscanf( pe->getProjectData("#ID"),"%x",&val);
        prj_src << "#include <initguid.h>\n";
        prj_src << "DEFINE_GUID(LIBID_WSocxObjects,0x"
                << pe->getProjectData("#ID")
                << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
        char buffer[1024];
        sprintf(buffer,"%08x",val+1);
        prj_src << "DEFINE_GUID(IID_IWSocx,        0x"
                << buffer
                << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
        sprintf(buffer,"%08x",val+2);
        prj_src << "DEFINE_GUID(DIID_DWSocxEvents,       0x"
                << buffer
                << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
        sprintf(buffer,"%08x",val+3);
        prj_src << "DEFINE_GUID(CLSID_WSocx,       0x"
                << buffer
                << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
      }
    }
  }

  if (lang == WS_LANG_RUBY){
    long num = oplist.getNum();
    long i;
    for(i=0; i< num; i++){
      char* opname = (char*)oplist.getData(i);
      prj_src << "load \"" << opname << ".rb\"\n";
    }
    prj_src << "app.execInitHandler()\n\n";
    prj_src << "app.handleEvents()\n\n";
  }else
  if (lang == WS_LANG_PYTHON){
    long num = oplist.getNum();
    long i;
    for(i=0; i< num; i++){
      char* opname = (char*)oplist.getData(i);
      prj_src << "import " << opname << "\n";
    }
    prj_src << "app.execInitHandler()\n\n";
    prj_src << "app.handleEvents()\n\n";
  }else
  if (lang == WS_LANG_PERL){
      prj_src << "\n$app->execInitHandler();\n";
      prj_src << "\n$app->handleEvents();\n";
  }else
  if (lang == WS_LANG_JAVA){
    prj_src << "    app.execInitHandler();\n";
    prj_src << "    app.handleEvents();\n";
    prj_src << "  }\n}\n";
  }else
  if (lang == WS_LANG_OCAML){
    if (mpfc_mapping != False){
      prj_src << "let _ = !mpfc_app -> \"execInitHandler\" ()\n";
      prj_src << "let _ = !mpfc_app -> \"handleEvents\" ()\n";
    }else{
      prj_src << "let _ = !mwt_app -> \"execInitHandler\" ()\n";
      prj_src << "let _ = !mwt_app -> \"handleEvents\" ()\n";
    }
  }
  long num = oplist.getNum();
  if (num > 0){
    opinf << "OPOBJ = \\\n";
  }
  long i;
  for(i=0; i< num -1; i++){
    char* opname = (char*)oplist.getData(i);
    opinf << "        ";
    opinf << opname;
    opinf << ".o \\\n";
    delete[] opname;
  }
  if (num > 0){
    char* opname = (char*)oplist.getData(num -1);
    opinf << "        ";
    opinf << opname;
    opinf << ".o ";
    delete[] opname;
  }

  WSCstring mkinf2;
  if (strcmp(pe->getTargetEnvironment(),"")){
    WSCstring tenv =  pe->getProjectData(pe->getTargetEnvironment());
#ifdef MSW
    char c;
    for(c = 'a'; c < 'z'+1; c++){
      char buf[3];
      buf[0] = c;
      buf[1] = ':';
      buf[2] = 0;

      char buf2[3];
      buf2[0] = c + 'A' - 'a';
      buf2[1] = ':';
      buf2[2] = 0;

      char buf3[2];
      buf3[0] = c;
      buf3[1] = 0;

      WSCstring dest("/cygdrive/");
      dest << buf3;
      if (tenv.isExist(buf) != -1){
        tenv.replaceString(buf,dest,1);
      }else
      if (tenv.isExist(buf2) != -1){
        tenv.replaceString(buf2,dest,1);
      }
    }
    while(tenv.replaceString("\\","/",0));
    while(tenv.replaceString("//","/",0));
#endif
    if (strcmp(tenv,"")){
      mkinf2 << "##########################################\n";
      mkinf2 << "# compiler environment                   #\n";
      mkinf2 << "##########################################\n\n";
      mkinf2 << "BD = " << tenv << "\n\n";
    }
  }

  WSCstring mkinf;
  mkinf << "##########################################\n";
  mkinf << "# compiler flags                         #\n";
  mkinf << "##########################################\n\n";
  mkinf << "DEBUG = " << get_cflags() << "\n\n";
  WSCstring str;
  str = pe->getProjectData("#CMODE");
#ifdef MSW
  if (atoi((char*)str)){
    mkinf << "DBGRM = echo\n\n";
  }else{
    mkinf << "DBGRM = $(RM)\n\n";
  }
#else
  if (atoi((char*)str)){
    mkinf << "__DBG_MK__ = 1\n\n";
  }
#endif
  mkinf << "##########################################\n";
  mkinf << "# setting of includes                    #\n";
  mkinf << "##########################################\n\n";
  mkinf << "ALL_INCLUDES = ";
  mkinf <<  get_include_value() << "\n\n";
  mkinf << "##########################################\n";
  mkinf << "# setting of libraries                   #\n";
  mkinf << "##########################################\n\n";
  mkinf << "ALL_LIBS = ";
  mkinf << get_lib_value();
  mkinf << " " << get_ext_lib_value();

  WSCvariant static_linked = pe->getProjectData("#STLINK");
  WSCstring t_lib;
  t_lib << "ALL_LIBS2 = ";
  t_lib << get_lib_value();
  t_lib << " " << get_ext_lib_value();


  WSClistData* liblist = get_lib_name();
  long lnum = liblist->getNum();
  for(i=0; i<lnum; i++){
    char* libname = (char*)(*liblist)[i];
    if (static_linked.getLong() == False){
      WSCstring clibname = get_complete_libname2(libname);
      clibname.replaceString(","," ",0);
      mkinf << " " << clibname;
      t_lib << " " << clibname;
    }else{
      WSCstring clibname = get_complete_stlibname(libname);
      clibname.replaceString(","," ",0);
      mkinf << " " << clibname;
      t_lib << " " << clibname;
    }
  }
  t_lib.replaceString("WSDIR","WS_DEFAULT_DIR",0);


  mkinf << "\n\n";
  mkinf << t_lib;

  mkinf << "\n\n";
  mkinf << "##########################################\n";
  mkinf << "# setting of window                      #\n";
  mkinf << "##########################################\n\n";
  mkinf << wininf << "\n\n";
  mkinf << opinf << "\n\n";
  mkinf << "OBJS = $(WINOBJ) $(OPOBJ) ";

  WSCstring sources(get_sources());
  sources.delHeadSpace();
  sources.delTailSpace();
  if (strcmp((char*)sources,"")){
    WSCstring files;
    if (lang == WS_LANG_CPP){
      sources.replaceString(".CXX",".o",-1);
      sources.replaceString(".cxx",".o",-1);
      sources.replaceString(".CPP",".o",-1);
      sources.replaceString(".cpp",".o",-1);
      sources.replaceString(".C",".o",-1);
      sources.replaceString(".c",".o",-1);
      sources.replaceString(".cc",".o",-1);
      long num = sources.getWords();
      long i;
      WSCstring str;
      for(i=0; i<num; i++){
        WSCstring item = sources.getWord(i);
        char* ptr = item.getString();
        long len = strlen(ptr);
        if (len > 2 && !strncmp(&(ptr[len-2]),".o",2)){
          str << item << ",";
        }
      }
      sources = str;
    }else if (lang == WS_LANG_OCAML){
      sources.replaceString(".ml",".o",-1);
      sources.replaceString(".ML",".o",-1);
    }
    sources.replaceString(","," ",-1);
    mkinf << sources << " ";
  }

  mkinf << get_objs() << " \n\n";
  mkinf << "##########################################\n";
  mkinf << "# setting of target binary               #\n";
  mkinf << "##########################################\n\n";
  mkinf << "TARGET = ";
  if ( get_lib_create_flag() == 0){
    if (get_link_type() == 0 ||
        get_link_type() == 4){
      mkinf << get_vproduct_name();
    }else{
#ifdef MSW
    if (get_link_type() == 3){
      mkinf << get_vproduct_name() << ".ocx";
    }else{
      mkinf << get_vproduct_name() << ".dll";
    }
#else /*MSW*/
#ifdef MacOS
    mkinf << get_vproduct_name() << ".dylib";
#else 
    mkinf << get_vproduct_name() << ".so";
#endif
#endif /*MSW*/
    }
    mkinf << "\n\n";
    mkinf << "CC=" << pe->getProjectData("#CC1") << "\n";
    mkinf << "CXX=" << pe->getProjectData("#CC") << "\n";
  }else{
#ifdef MSW
    if (get_link_type() == 3){
      mkinf << get_vproduct_name() << ".ocx";
    }else{
      mkinf << "lib" <<  get_vproduct_name() << ".dll";
    }
#else /*MSW*/
#ifdef MacOS
    mkinf << "lib" <<  get_vproduct_name() << ".dylib";
#else 
    mkinf << "lib" <<  get_vproduct_name() << ".so";
#endif
#endif /*MSW*/
    mkinf << "\n\n";
    mkinf << "TARGET2 = ";
    mkinf << "lib" <<  get_vproduct_name() << ".a";
    mkinf << "\n\n";
    mkinf << "CC=" << pe->getProjectData("#CC1") << "\n";
    mkinf << "CXX=" << pe->getProjectData("#CC") << "\n";
  }

  if (lang == WS_LANG_CPP || lang == WS_LANG_OCAML){
    WSGFreplaceTextFile(mkinf_fname,(char*)mkinf,False);
    WSGFreplaceTextFile(mkinf_fname2,(char*)mkinf2,False);
  }
  //饤֥ξ硢prj.cpp 򤽤Ѥ˺ľ...
  if (get_lib_create_flag() != 0){
    prj_src = "";
    WSCstring tmp;
    long num  = winlist.getNum();
    long i;
    for(i=0; i< num; i++){
      WSCbase* win = (WSCbase*)winlist[i];
      if ( (long)win->getUserData(WS_WIN_CLASS) != 0){
        tmp << "\"";
        tmp << win->getInstanceName();
        tmp << "\",\"";
        char* class_icon = (char*)win->getUserData(WS_CLASS_ICON);
        if (class_icon == NULL){
          tmp << WS_PIXMAP_DIR "obj/obj.xpm";
        }else{
          tmp << class_icon;
        }
        tmp << "\",\"";
        tmp << win->getInstanceName();
        char* class_comment = (char*)win->getUserData(WS_CLASS_COMMENT);
        if (class_comment != NULL){
          tmp << "(";
          tmp << class_comment;
          tmp << ")";
        }
//        tmp << WSGFgettext("P4:WSSTR \",\n");
        tmp << "\",\n";
      }
    }

    prj_src << "#include <WScom.h>\n";
    prj_src << "#include <WSDexternal.h>\n\n";
    prj_src << "static char *object_symbols[] = {\n";

    prj_src << tmp;

    prj_src << "NULL\n};\n\n";
    prj_src << "class  _dll_init {\n";
    prj_src << "  public:\n";
    prj_src << "  _dll_init(){\n";
    prj_src << "     WSDexternal::setTempData(object_symbols);\n";
    prj_src << "     WSDexternal::setProjectName(\""
            <<  get_vproduct_name() << "\");\n";
    prj_src << "  }\n";
    prj_src << "};\n";
    prj_src << "static _dll_init _execute_initialize;\n";
    prj_src << "\n";
  }

  WSGFreplaceTextFile(projectsrc_fname,(char*)prj_src,False);
  return WS_NO_ERR;
}
void _delay_proc(WSCuchar ,void*){
  procform->start();
}
void execute_buildall(){
  WSCstring str;
  procform->setPropertyV(WSNlabelString,"");
#ifdef MSW
  str = get_project_dir();
  procform->setPropertyV(WSNdirName,(char*)str);
  str = get_make_name();
  str << " clean";
  procform->setPropertyV(WSNfileName,(char*)str);
  inspector->setFormVisible(4,True);
//  procform->setVisible(True);
  procform->start();
  while(1){
    if (procform->getHandle() == 0){
      break;
    }
    WSGIappDev()->dispatchEvent();
  }
  procform->setProperty(WSNlabelString,"");
  str = get_make_name();
  procform->setPropertyV(WSNfileName,(char*)str);
#else /* MSW */
#ifdef BTRON
  str = get_project_dir();
  procform->setProperty(WSNdirName,(char*)str);
  str = get_make_name();
  str << " -f " << WS_MAKE_FILE2 << " clean";
  procform->setPropertyV(WSNfileName,(char*)str);
  inspector->setFormVisible(4,True);
//  procform->setVisible(True);
  procform->start();
  while(1){
    if (procform->getHandle() == 0){
      break;
    }
    WSGIappDev()->dispatchEvent();
  }
  procform->setProperty(WSNlabelString,"");
  str = get_make_name();
  procform->setPropertyV(WSNfileName,(char*)str);
#else
  str << "cd \"" << get_project_dir() << "\";";
  str << "(sleep 1; " << get_make_name() << " clean; ";
  str << get_make_name() << " ) 2>&1 | tee log.txt";
#endif /* BTRON */
#endif /* MSW */
  procform->setPropertyV(WSNlabelString,"");
  procform->setPropertyV(WSNfileName,(char*)str);
  inspector->setFormVisible(4,True);
//  procform->setVisible(True);
  WSGIappTimer()->addTriggerProc(_delay_proc,WS250MS,NULL);
}
void execute_make(){
  WSCstring str;
  procform->setPropertyV(WSNlabelString,"");
#ifdef MSW
  str = get_project_dir();
  procform->setPropertyV(WSNdirName,(char*)str);
  str =  get_make_name();
  str << " -f " << WS_MAKE_FILE2;
#else /* MSW */
#ifdef BTRON
//  str << "cd " << get_project_dir() << " ; ";
  str = get_project_dir();
  procform->setProperty(WSNdirName,(char*)str);
  str = get_make_name();
  str << " -f " << WS_MAKE_FILE2;
#else
  str << "cd \"" << get_project_dir() << "\";";
  str << "sleep 1; " << get_make_name() << " -f " << WS_MAKE_FILE2
      << " 2>&1 | tee log.txt";
#endif
#endif /* MSW */
  procform->setPropertyV(WSNlabelString,"");
  procform->setPropertyV(WSNfileName,(char*)str);
  inspector->setFormVisible(4,True);
//  procform->setVisible(True);
  WSGIappTimer()->addTriggerProc(_delay_proc,WS250MS,NULL);
}
void execute_clean(){
  WSCstring str;
  procform->setPropertyV(WSNlabelString,"");
#ifdef MSW
  str = get_project_dir();
  procform->setPropertyV(WSNdirName,(char*)str);
  str = get_make_name();
  str << " -f " << WS_MAKE_FILE2 << " clean";
#else /* MSW */
#ifdef BTRON
  str = get_project_dir();
  procform->setProperty(WSNdirName,(char*)str);
  str = get_make_name();
  str << " -f " << WS_MAKE_FILE2 << " clean";
#else
  str << "cd \"" << get_project_dir() << "\";";
  str << "sleep 1; " << get_make_name() << " -f " << WS_MAKE_FILE2
      << " clean 2>&1";
#endif /* BTRON */
#endif /* MSW */
  procform->setPropertyV(WSNlabelString,"");
  procform->setPropertyV(WSNfileName,(char*)str);
  inspector->setFormVisible(4,True);
//  procform->setVisible(True);
  WSGIappTimer()->addTriggerProc(_delay_proc,WS250MS,NULL);
}
long check_project(){
  if (!strcmp(get_project_name(),"")){
    question->setPropertyV(WSNlabelString,
     WSGFgettext("Q4:WSSTR No project is specified.\nGenerate a new project?"));
    question->setPropertyV(WSNwidth,(WSCushort)500);
    question->setPropertyV(WSNheight,(WSCushort)135);
    question->setPropertyV(WSNreplyHandler,(void*)NULL);
    long ret = question->popup();
    if (ret == WS_DIALOG_OK){
      long ret2 = create_project();
      if (ret2 == WS_NO_ERR){
        return 0;
      }
    }
    return 1;
  }
  return 0;
}
void make_execute(){
  if (check_project()){
    return;
  }
  create_makefile();
  create_window_srcs();
  if (pe->getLanguage() == WS_LANG_CPP){
    execute_make(); 
  }else
  if (pe->getLanguage() == WS_LANG_JAVA){
    WSCstring str = get_project_dir();
    procform->setProperty(WSNdirName,(char*)str);
    WSCstring cmd = pe->getProjectData("#JAVAD");
    long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    if (encoding == WS_EN_SJIS){
      cmd << " -encoding " << WSGFgetEncodingName(encoding);
    }else if (encoding == WS_EN_EUCJP){
      cmd << " -encoding " << WSGFgetEncodingName(encoding);
    }else if (encoding == WS_EN_EUCCN){
      cmd << " -encoding " << WSGFgetEncodingName(encoding);
    }else if (encoding == WS_EN_UTF8){
      cmd << " -encoding " << WSGFgetEncodingName(encoding);
    }else if (encoding == WS_EN_BIG5){
      cmd << " -encoding " << WSGFgetEncodingName(encoding);
    }else if (encoding == WS_EN_CP1251){
      cmd << " -encoding " << WSGFgetEncodingName(encoding);
    }else if (encoding == WS_EN_KOI8R){
      cmd << " -encoding koi8";
    }
#ifdef MSW
#else
    cmd << " 2>&1 | tee log.txt";
#endif
    procform->setProperty(WSNlabelString,cmd);
    procform->addString("\n");
    procform->setProperty(WSNfileName,cmd);
    inspector->setFormVisible(4,True);
    procform->start();
  }else
  if (pe->getLanguage() == WS_LANG_OCAML){
    execute_make(); 
  }
}

void make_execute2(){
  if (check_project()){
    return;
  }
  create_makefile();
  create_window_srcs();
  if (pe->getLanguage() == WS_LANG_CPP){
    execute_buildall(); 
  }else
  if (pe->getLanguage() == WS_LANG_JAVA){
    WSCstring str = get_project_dir();
    procform->setProperty(WSNdirName,(char*)str);
    WSCstring cmd = pe->getProjectData("#JAVAD");
    procform->setProperty(WSNfileName,cmd);
    inspector->setFormVisible(4,True);
    procform->start();
  }else
  if (pe->getLanguage() == WS_LANG_OCAML){
    execute_buildall(); 
  }
}
void make_clean(){
  if (check_project()){
    return;
  }
  create_makefile();
  create_window_srcs();
  if (pe->getLanguage() == WS_LANG_CPP){
    execute_clean(); 
  }else
  if (pe->getLanguage() == WS_LANG_JAVA){
// ToDo: need implement..
  }else
  if (pe->getLanguage() == WS_LANG_OCAML){
    execute_clean(); 
  }
}

void exec_search(){
extern WSCwizardDialog* searchwz;
  long ret = searchwz->popup();
  if (ret == WS_DIALOG_DONE){
extern WSCvifield* schif1;
extern WSCcomboBox* schif2;
extern WSCvifield* schif3;
    WSCstring dir(schif1->getProperty(WSNlabelString));
    if (!strcmp(dir,"")){
      dir = ".";
    }
    WSCstring searchstr(schif3->getProperty(WSNlabelString));
    if (!strcmp(searchstr,"")){
      message->setPropertyV(WSNlabelString,
        WSGFgettext("R4:WSSTR Please specify a keyword to search files."));
      message->setPropertyV(WSNwidth,(WSCushort)450);
      message->setPropertyV(WSNheight,(WSCushort)150);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->popup();
      return;
    }
    WSCstring ftype(schif2->getProperty(WSNlabelString));
    if (!strcmp(ftype,"")){
      ftype = "*";
    } 
    WSCstring str;
    str << "wssearch " << searchstr;
    str << " " << dir;
    str << " '" << ftype << "' 2>&1";
extern WSCprocessForm* procform;
    procform->setPropertyV(WSNlabelString,"");
    procform->setPropertyV(WSNfileName,(char*)str);
    inspector->setFormVisible(4,True);
//    procform->setVisible(True);
extern void _delay_proc(WSCuchar,void*);
    WSGIappTimer()->addTriggerProc(_delay_proc,WS250MS,NULL);

  }
}
void exec_obj_search(){
extern WSCbaseDialog* objsearchwz;
  objsearchwz->setVisible(True);
}

void editor_execute(WSCprocedureEditor*,char* pgname){
  WSCstring str;
  str = pe->getProjectData("#EDITOR_NAME");
  str.delHeadSpace();
  str.delTailSpace();
  if (!strcmp((char*)str,"")){
    message->setPropertyV(WSNlabelString,
      WSGFgettext("S4:WSSTR No editor is specified.\nPlease confirm the project settings and specify the editor."));
    message->setPropertyV(WSNwidth,(WSCushort)450);
    message->setPropertyV(WSNheight,(WSCushort)150);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->popup();
    return;
  }
  str << " ";
#ifdef MSW
  WSCstring str2;
  str2 << "\"";
  WSCbool absolute = False;
  if (pgname[0] != 0 && pgname[1] == ':'){
    absolute = True;
  }
  if (absolute == False && strcmp(get_project_dir(),"")){
    str2 <<  get_project_dir() << "/";
  }
  str2 << pgname << "\" &";
  while(str2.replaceString("//","/",0));
  str2.replaceString("/","\\",0);
  str << str2;
//printf("editor_execute cmd=#%s#\n",(char*)str);
  _system((char*)str);
#else
  WSCbool absolute = False;
  if (pgname[0] == '/'){
    absolute = True;
  }
  if (pgname[0] == '"' && pgname[1] == '/'){
    absolute = True;
  }
  if (absolute == False && strcmp(get_project_dir(),"")){
    str <<  get_project_dir() << "/";
  }
#ifdef BTRON
extern int btron_system(char*);
  str << pgname;
  btron_system((char*)str);
#else
  str << pgname << " &";
  system((char*)str);
#endif
#endif
}
void read_win_src(){
  fselect->setPropertyV(WSNmaskFileName,"win");
  long ret = fselect->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring dirname(fselect->getProperty(WSNdirName));
    WSCstring fname(fselect->getProperty(WSNfileName));
extern long read_win_file(char*,char*,WSClistData*);
    long ret = read_win_file(dirname,fname,&winlist);
    if (ret != WS_ERR){
      inspector->setClients(&winlist);
    }
  }
}
void delete_object(WSCbase* target){
  if (target == NULL){
    return;
  }
  long i;
  long num = winlist.getNum(); 
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)winlist[i];
    if (item == target){
      winlist.delPos(i);
      break;
    }
  }
  inspector->updateList(); 
  delete target;
}

WSCmessageDialog* msg2 = NULL;
WSCbool get_wait_for_lock(){
  if (msg2 != NULL && msg2->getVisible() != False){
    return True;
  } 
  return False;
}
void wait_for_timer_proc(WSCuchar clk,void*){
  msg2->setVisible(False);
}
void wait_for(char* str){
  if (msg2 == NULL){
    msg2 = new WSCmessageDialog(NULL,"msg2");
    msg2->initialize();
    msg2->setPropertyV(WSNmodal,(WSCbool)True);
    msg2->setPropertyV(WSNdefaultPosition,(WSCbool)True);
    msg2->setPropertyV(WSNheight,(WSCushort)125);
    msg2->setPropertyV(WSNlabelPixmap,WS_MSG_PIX);
    msg2->setPropertyV(WSNtitleString,"Message");
    msg2->setPropertyV(WSNok,(WSCbool)False);
    msg2->setPropertyV(WSNno,(WSCbool)False);

  }
  msg2->setPropertyV(WSNwidth,(WSCushort)500);
  msg2->setPropertyV(WSNlabelString,str);
  msg2->setVisible(True);
  WSGIappTimer()->addTimerProc(wait_for_timer_proc,WS2000MS,NULL);
}
void show_license(){
static  WSCmessageBox* license = NULL;
  if (license == NULL){
    license = new WSCmessageBox(NULL,"license");
    license->initialize();
    WSGFsetGeometry(license,100,100,760,600);
    license->setProperty(WSNtitleString,"License");
    license->setProperty(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi23.xpm");
    license->setProperty(WSNcancel,False);
  }

  WSCstring path;
  path << "$(WSDIR)/sys/data/license";
  WSCstring* str = WSGFreadTextFile(path);
  if (str != NULL){
    license->setProperty(WSNlabelString,str->getString());
    license->popup();
  }
}

WSCstring WSGFgetPureInstanceName(WSCbase* obj){
  WSCstring str;
  long arrayno;
  char arrayname[1024];
  long array = WSGFcheckArrayName(obj->getInstanceName(),&arrayno,arrayname);

  if (array != False){
    str = arrayname;
    return str;
  }
  str = obj->getInstanceName();
  return str;
}
#if 0 // move to advance/WSadcom.cpp
long _check_name_strings(char* cname,WSCbase* base,WSCbase* client,char* aname){
   WSCbase* basep = NULL;
   WSCbase* bp = base->getParentWindow();
   if (client != NULL){
     basep = client->getParentWindow();
   }

   long arrayno;
   char arrayname[1024];
   WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&arrayno,arrayname);
   if (array == False && !strcmp(base->getInstanceName(),cname)){
     if ( (long)base->getUserData(WS_EXT_VAR) != 0 ){
       return WS_OBJECT_NAME;
     }else if ( basep == bp ){
       return WS_OBJECT_NAME;
     }
   }

   if (array != False && !strcmp(arrayname,cname)){
     if (bp == basep && client == NULL ){
       return WS_OBJECT_ARRAY_NAME;
     }else if (bp == basep && client != NULL &&
               !strcmp(client->getClassName(),base->getClassName())){
       return WS_OBJECT_ARRAY_NAME;
     }else{
       return WS_OBJECT_ARRAY_NAME_INVALID;
     }
   }
   if (aname != NULL){
     if (array == False && !strcmp(base->getInstanceName(),aname)){
       if ( (long)base->getUserData(WS_EXT_VAR) != 0 ){
         return WS_OBJECT_NAME;
       }else if ( basep == bp ){
         return WS_OBJECT_NAME;
       }
     }
     if (array != False && !strcmp(arrayname,aname)){
       if (bp == basep && client == NULL ){
         return WS_OBJECT_ARRAY_NAME;
       }else if (bp == basep && client != NULL &&
               !strcmp(client->getClassName(),base->getClassName())){
         return WS_OBJECT_ARRAY_NAME;
       }else{
         return WS_OBJECT_ARRAY_NAME_INVALID;
       }
     }
   }


   WSClistData* prlist = base->getProcedureList();
   long i;
   long num = prlist->getNum();
   for(i=0; i<num; i++){
     WSCprocedure* ac = (WSCprocedure*)prlist->getData(i);
     if(!strcmp(ac->getFunctionName(),cname)){
       return WS_PROCEDURE_NAME;
     }
   }
   WSClistData children = base->getChildren();
   num = children.getNum();
   for(i=0; i<num; i++){
     WSCbase* child = (WSCbase*)children[i];
     if (child->getInternalObject() == False){
       long ret = _check_name_strings(cname,child,client,aname);
       if (ret != 0){
         return ret;
       }
     }
   }
   return 0;
}
#endif
#if 0 //move to advance/WSadcom.cpp
WSCbase* _search_instance(char* name,WSCbase* item){
  if (item->getInternalObject() != False){
    return NULL;
  }
  if (!strcmp(name,item->getInstanceName())){
    return item;
  }
  WSClistData children = item->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    WSCbase* target = _search_instance(name,child);
    if (target != NULL){
      return target;
    }
  }
  return NULL;
}
#endif
WSCbase* search_instance(char* name){
  long i;
  long num = winlist.getNum();
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)winlist[i];
    WSCbase* target = _search_instance(name,win);
    if (target != NULL){
      return target;
    }
  }
  return NULL;
}
long check_name_strings(char* cname,WSCbase* client){

  if (!strcmp("main",cname)){
    return WS_OTHER_NAME;
  }
  if (!strcmp("WinMain",cname)){
    return WS_OTHER_NAME;
  }
  if (!strcmp(get_project_name(),cname)){
    return WS_OTHER_NAME;
  }
  WSCstring pname(get_project_name());
  pname.replaceString(".prj","",1);
  if (!strcmp(pname.getString(),cname)){
    return WS_OTHER_NAME;
  }
                                                                                

  WSCbase* pic = NULL;
  if (client != NULL){
    pic = client->getParentWindow();
  }

  WSCbase* sinst = search_instance(cname);
  if (sinst != NULL){
    return WS_OBJECT_NAME;
  }

  long arrayno;
  char arrayname[1024];
  WSCbool array = WSGFcheckArrayName(cname,&arrayno,arrayname);
  if (array != False){
    WSCbase* sinst = search_instance(arrayname);
    if (sinst != NULL){
      return WS_OBJECT_NAME;
    }
    WSCfunction* func = WSGIappFunctionList()->getFunction(arrayname);
    if (func != NULL){
      return WS_PROCEDURE_NAME;
    }
    return WS_OBJECT_ARRAY_NAME;
  }else{
    WSCfunction* func = WSGIappFunctionList()->getFunction(cname);
    if (func != NULL){
      return WS_PROCEDURE_NAME;
    }
  }

  long i;
  long num = winlist.getNum();
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)winlist[i];
    long ret;
    if (array != False){
      ret = _check_name_strings(cname,win,client,arrayname);
    }else{
      ret = _check_name_strings(cname,win,client,NULL);
    }
    if (ret != 0){
      return ret;
    }

  }

  return 0;
}
void actop1(WSCbase* ptr){
  WSCdialog* obj = (WSCdialog*)ptr->cast("WSCdialog"); 
  long val = obj->getStatus();
  if (val != WS_DIALOG_CANCEL){
    obj->setVisible(False);
  }
}

void error_editor_open(WSCbase* obj){
static long clk = 0;
  WSCvmifield* mt = (WSCvmifield*)obj->cast("WSCvmifield");
  long cpos =  mt->getProperty(WSNcursorPos);
  WSCstring str = mt->getString();
  WSCstring tmp = str;
  tmp.cutString(cpos);
  long cy = tmp.getLines() -1;
  if (cy < 0){
    cy = 0;
  }
  tmp = str.getWord(cy,"\n");
  WSCstring fname = tmp.getWord(0,":");
  long lnum = atoi(tmp.getWord(1,":"));
  WSCstring errstr = tmp.getWord(2,":");
  long ntime = WSGFclocktime();
  if (lnum == 0){
#ifdef MSW
    fname = tmp.getWord(1,":");
    lnum = atoi(tmp.getWord(2,":"));
    errstr = tmp.getWord(3,":");
    if (lnum == 0){
      return;
    }
#else
    return;
#endif
  }
  if (!strcmp(errstr.getString(),"")){
    return;
  }
  if (clk == 0 || ntime - clk > 1000){
//printf("error_editor_open called.. line=%d %s\n",lnum,fname.getString());
    WSCstring ename = pe->getProjectData("#EDITOR_NAME");
    WSCstring eopts = pe->getProjectData("#EDITOR_OPTION");
    ename.delHeadSpace();
    ename.delTailSpace();
    if (!strcmp((char*)ename,"")){
      message->setPropertyV(WSNlabelString,
        WSGFgettext("S4:WSSTR No editor is specified.\nPlease confirm the project settings and specify the editor."));
      message->setPropertyV(WSNwidth,(WSCushort)450);
      message->setPropertyV(WSNheight,(WSCushort)150);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->popup();
      return;
    }

    if (!strcmp((char*)eopts,"")){
      message->setPropertyV(WSNlabelString,
        WSGFgettext("S4:WSSTR No editor option is specified.\nPlease confirm the project settings and specify the editor."));
      message->setPropertyV(WSNwidth,(WSCushort)450);
      message->setPropertyV(WSNheight,(WSCushort)150);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->popup();
      return;
    }
    ename << " ";

    long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    if (!strcmp(WSGFgetEncodingName(encoding),WSN_EN_SJIS) ||
        !strcmp(WSGFgetEncodingName(encoding),WSN_EN_EUCKR)){
//      if (!strncmp(fname.getString(),"_",1)){
//        fname.replaceString("_","",1);
//printf("main.cpp:: fname=%s\n",fname.getString());
//      }
      fname.replaceString("_.cpp",".cpp",1);
      fname.replaceString("_.CPP",".CPP",1);
      fname.replaceString("_.c",".c",1);
      fname.replaceString("_.C",".C",1);
      fname.replaceString("_.cc",".cc",1);
      fname.replaceString("_.CC",".CC",1);
      fname.replaceString("_.cxx",".cxx",1);
      fname.replaceString("_.CXX",".CXX",1);
    }

#ifdef MSW
    WSCstring str2;
    str2 << "\"";
    if (strcmp(get_project_dir(),"") && strncmp(fname.getString(),"/",1)){
      char* fname2 = fname.getString();
      if (fname2[0] != 0 &&  fname2[1] == ':'){
      }else{
        str2 <<  get_project_dir() << "/";
      }
    }
    str2 << fname << "\"";
    while(str2.replaceString("//","/",0));
    str2.replaceString("/","\\",0);
    eopts.replaceString("%F",str2,1);
    eopts.replaceString("%L",WSGFltoa(lnum),1);
    ename << eopts << " &";
//printf("editor_execute cmd=#%s#\n",(char*)ename);
    _system((char*)ename);
#else
    WSCstring str2;
    str2 << "\"";
    if (strcmp(get_project_dir(),"") && strncmp(fname.getString(),"/",1)){
      str2 <<  get_project_dir() << "/";
    }
    str2 << fname << "\"";
    eopts.replaceString("%F",str2,1);
    eopts.replaceString("%L",WSGFltoa(lnum),1);
#ifdef BTRON
    ename << eopts;
extern int btron_system(char*);
    btron_system(ename.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#else
    ename << eopts << " &";
//printf("editor_execute cmd=#%s#\n",(char*)ename);
    system(ename.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif
#endif
    clk = ntime;
  }

}
char* get_ext_files_handler(){
  return pe->getProjectData("#WS_FILES");
}
