//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCwizardDialog.h>
#include <WSCvifield.h>
#include <WSCform.h>
#include <WSCvtoggle.h>
#include <WSCbaseList.h>
#include <WSCoption.h>
#include <WSCmessageDialog.h>
#include <WSClocaleSet.h>
#include <advance/WSCprojectEditor.h>

extern WSCwizardDialog* newwin;
extern WSCmessageDialog* message;

WSCvtoggle* tgl11;
WSCvtoggle* tgl12;
WSCvtoggle* tgl21;
WSCvifield* nmif1;
WSCoption*  nmopt1;
extern WSCprojectEditor* pe;

WSClistData optbuf;

static void visop(WSCbase*){
  if (newwin->getVisible() != False){
    long win_cnt = 0;
    char buffer[32];
    while(1){
      sprintf(buffer,"newwin%03d",win_cnt);
      if (WSGIappObjectList()->getInstance("WSCbase",buffer) == NULL){
        break;
      }
      win_cnt++;
    }
    nmif1->setPropertyV(WSNlabelString,buffer);

    tgl11->setStatus(1,1);
    tgl21->setStatus(1,0);
    newwin->setPropertyV(WSNvalue,(WSCuchar)0);
  }else{
    if (newwin->getStatus() == WS_DIALOG_DONE){
      if (tgl11->getStatus() != False){
        newwin->setUserData(WS_WIN_CLASS,(void*)0);
      }else{
        newwin->setUserData(WS_WIN_CLASS,(void*)1);
      }
    }
  }

  if (newwin->getVisible() == False){
    return;
  }

  long i;
  long num = optbuf.getNum();
  for(i=0; i<num; i++){
    char* ptr =(char*)optbuf[i];
    delete ptr;
  }

  optbuf.clear();
  WSCstring cname;
  cname = pe->getProjectData("#WINC_NAME");
 long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
 if (encoding == WS_EN_DEFAULT){
   encoding = WSGIappLocaleSet()->getSystemLocaleEncoding();
 }
//printf("encoding en=%d\n",encoding);
  WSCstring template_file;
  template_file << "$(WSDIR)/sys/data/"
//               << WSGIappLocaleSet()->getDefaultLocaleName()
               << WSGFgetEncodingName(encoding)
//               << WSGIappLocaleSet()->getSystemLocaleName()
               << "/" << cname << "/templates";
  WSCstring* templates = WSGFreadTextFile(template_file,encoding);
//                  WSGIappLocaleSet()->getSystemLocaleEncoding());
  WSCstring template_menu;
  if (templates != NULL){
    WSCstring line = templates->gets();
    WSCstring line2 = templates->gets();
    long default_val = (long)WSGFstrdup((char*)line2);
    optbuf.add((void*)default_val);
    template_menu << line << ":" << WSGFltoa(default_val) << ":";
    while(!templates->eof()){
      template_menu << ",";
      WSCstring line = templates->gets();
      WSCstring line2 = templates->gets();
      char* ptr = WSGFstrdup((char*)line2);
      optbuf.add((void*)ptr);
      template_menu << line << ":" << WSGFltoa((long)ptr) << ":";
    }
    delete templates;
    nmopt1->setProperty(WSNmenuItems,template_menu);
    nmopt1->setProperty(WSNvalue,default_val);
  }else{
#if 0
    WSCstring msg;
    msg << WSGFgettext("Z4:WSSTR Can not read file:")
        << template_file
        << WSGFgettext("a4:WSSTR .");

    message->setProperty(WSNwidth,550);
    message->setProperty(WSNlabelString,msg);
    message->popup();
#endif
    char buf[128];
    char* ptr = "NONE";
    sprintf(buf,"None:%d:",ptr);
    nmopt1->setProperty(WSNmenuItems,buf);
    nmopt1->setProperty(WSNvalue,(long)ptr);
  }
}
static void tgl_value_ch(WSCbase*){
  if (tgl11->getStatus() == 1){
    long win_cnt = 0;
    char buffer[32];
    while(1){
      sprintf(buffer,"newwin%03d",win_cnt);
      if (WSGIappObjectList()->getInstance("WSCbase",buffer) == NULL){
        break;
      }
      win_cnt++;
    }
    nmif1->setPropertyV(WSNlabelString,buffer);
  }else{
    long win_cnt = 0;
    char buffer[32];
    while(1){
      sprintf(buffer,"newcls%03d",win_cnt);
      if (WSGIappObjectList()->getInstance("WSCbase",buffer) == NULL){
        break;
      }
      win_cnt++;
    }
    nmif1->setPropertyV(WSNlabelString,buffer);
  }
}
void create_newwin_dialog(){

  newwin = new WSCwizardDialog(NULL,"newwin");
  newwin->initialize();
  WSGFsetGeometry(newwin,300,300,550,120);
  newwin->setPropertyV(WSNtitleString,WSGFgettext("W4:WSSTR New application window"));
  newwin->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi39.xpm");
  newwin->setPropertyV(WSNlabelString,WSGFgettext("X4:WSSTR < Back,Next >,Finish"));
  newwin->setPropertyV(WSNmenuItems,(WSCuchar)3);
  newwin->setPropertyV(WSNmodal,(WSCbool)True);
  WSCprocedure* op1 = new WSCprocedure("visop",WSEV_VISIBLE_CH);
  op1->setFunction(visop,"visop");
  newwin->addProcedure(op1);

  WSCvlabel* sp1 = new WSCvlabel(newwin,"lb11");
  sp1->initialize();
  WSGFsetGeometry(sp1,0,5,1280,2);
  sp1->setPropertyV(WSNuserValue,(long)1);
  sp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp1->setVisible(True);


  WSCvlabel* lb11 = new WSCvlabel(newwin,"lb11");
  lb11->initialize();
  WSGFsetGeometry(lb11,5,12,100,20);
  lb11->setPropertyV(WSNlabelString,WSGFgettext("Y4:WSSTR Type"));
  lb11->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb11,0);
  lb11->setVisible(True); 

  tgl11 = new  WSCvtoggle(newwin,"tgl11");
  tgl11->initialize();
  tgl11->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  tgl11->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  tgl11->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  tgl11->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  tgl11->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  tgl11->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  tgl11->setPropertyV(WSNlabelString,WSGFgettext("Z4:WSSTR  Normal window"));
  tgl11->setPropertyV(WSNalignmentH,(WSCuchar)0);
  tgl11->setPropertyV(WSNuserValue,(long)1);
  tgl11->setPropertyV(WSNid,(short)1);
  tgl11->setPropertyV(WSNgroup,"wintg1");
  tgl11->setPropertyV(WSNunique,(WSCbool)True);
  WSGFsetGeometry(tgl11,110,10,270,26);
  tgl11->setVisible(True);

  WSCprocedure* op2 = new WSCprocedure("tglop",WSEV_VALUE_CH);
  op2->setFunction(tgl_value_ch,"tgl_value_ch");
  tgl11->addProcedure(op2);

  tgl12 = new  WSCvtoggle(newwin,"tgl12");
  tgl12->initialize();
  tgl12->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  tgl12->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  tgl12->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  tgl12->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  tgl12->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  tgl12->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  tgl12->setPropertyV(WSNlabelString,WSGFgettext("a4:WSSTR  Class"));
  tgl12->setPropertyV(WSNalignmentH,(WSCuchar)0);
  tgl12->setPropertyV(WSNuserValue,(long)1);
  tgl12->setPropertyV(WSNid,(short)2);
  tgl12->setPropertyV(WSNgroup,"wintg1");
  tgl12->setPropertyV(WSNunique,(WSCbool)True);
  WSGFsetGeometry(tgl12,110,40,270,26);
  tgl12->setVisible(True);

  //page2

  WSCvlabel* sp2 = new WSCvlabel(newwin,"lb11");
  sp2->initialize();
  WSGFsetGeometry(sp2,0,5,1280,2);
  sp2->setPropertyV(WSNuserValue,(long)2);
  sp2->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp2->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp2->setVisible(True);

  WSCvlabel* lb21 = new WSCvlabel(newwin,"lb11");
  lb21->initialize();
  WSGFsetGeometry(lb21,5,12,100,20);
  lb21->setPropertyV(WSNlabelString,WSGFgettext("b4:WSSTR Project"));
  lb21->setPropertyV(WSNuserValue,(long)2);
  WSGFsetMargin(lb21,0);
  lb21->setVisible(True); 

  tgl21 = new  WSCvtoggle(newwin,"tgl21");
  tgl21->initialize();
  tgl21->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  tgl21->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  tgl21->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  tgl21->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  tgl21->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  tgl21->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  tgl21->setPropertyV(WSNlabelString,WSGFgettext("c4:WSSTR  Add to project"));
  tgl21->setPropertyV(WSNalignmentH,(WSCuchar)0);
  tgl21->setPropertyV(WSNuserValue,(long)2);
  WSGFsetGeometry(tgl21,110,10,270,26);
  tgl21->setVisible(True);

  WSCvlabel* lb22 = new WSCvlabel(newwin,"lb11");
  lb22->initialize();
  WSGFsetGeometry(lb22,5,40,100,20);
  lb22->setPropertyV(WSNlabelString,WSGFgettext("d4:WSSTR Name"));
  lb22->setPropertyV(WSNuserValue,(long)2);
  WSGFsetMargin(lb22,0);
  lb22->setVisible(True); 

  nmif1 = new  WSCvifield(newwin,"nmif1");
  nmif1->initialize();
  nmif1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  nmif1->setPropertyV(WSNshadowType,(char)1);
  nmif1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  nmif1->setPropertyV(WSNmaxLength,(WSCushort)16);
  nmif1->setPropertyV(WSNuserValue,(long)2);
  WSGFsetGeometry(nmif1,110,42,270,20);

  WSCvlabel* lb31 = new WSCvlabel(newwin,"lb21");
  lb31->initialize();
  WSGFsetGeometry(lb31,5,12,120,20);

  lb31->setPropertyV(WSNlabelString,WSGFgettext("Y4:WSSTR Templates"));

  lb31->setPropertyV(WSNuserValue,(long)3);
  WSGFsetMargin(lb31,0);
  lb31->setVisible(True);

  nmopt1 = new WSCoption(newwin,"nmopt1");
  nmopt1->initialize();
  WSGFsetGeometry(nmopt1,130,12,410,20);
  nmopt1->setPropertyV(WSNuserValue,(long)3);
  nmopt1->setProperty(WSNshadowThickness,1);
  nmopt1->setVisible(True);

}

