//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

//----------------------------------------------------//
// Wide Studio Application C++ Source File            //
//            created by Wide Studio source generator //
//----------------------------------------------------//
#include <WScom.h>
#include <WSDappDev.h>

//--- OBJECT includes ---//
#include <WSCdialog.h>
#include <WSCvlabel.h>
#include <WSCvradio.h>
#include <WSCoption.h>

//--- OBJECT instance variable ---//
WSCdialog* policy_select;
WSCvradio* polvrad_002;
WSCvradio* polvrad_003;
WSCvradio* polvrad_000;
WSCoption* polvopti000;
WSClistData  look_and_feel_name_list;
WSClistData  look_and_feel_value_list;
//--- OBJECT src ---//
void policy_select_popup(){

  WSCulong val = WSGIappDev()->getGuiPolicy();
  WSCstring expolicy_name = WSGIappDev()->getExtGuiPolicyName();
  long num = look_and_feel_name_list.getNum();
  long i;
  long hit =-1;
  for(i=0; i<num; i++){
    if (val == (WSCulong)look_and_feel_value_list[i]){
      if (!strcmp((char*)expolicy_name,(char*)look_and_feel_name_list[i])){
        hit = i;
      }
    }
  }
  if (hit == -1){
    hit = 0;
  }

  polvopti000->setProperty(WSNvalue,hit);

  long ret = policy_select->popup();
  if (ret == WS_DIALOG_OK){
    long val = polvopti000->getProperty(WSNvalue);
    WSGIappDev()->setGuiPolicy((long)look_and_feel_value_list[val],False);
    WSGIappDev()->setExtGuiPolicy((char*)look_and_feel_name_list[val],True);
    WSGIappDev()->saveGuiPolicy();
  }
}
void _create_win_policy_select(){


	policy_select = new  WSCdialog(NULL,"policy_select");
	policy_select->initialize();
	policy_select->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi8.xpm");
	policy_select->setPropertyV(WSNmodal,(WSCbool)1);
	policy_select->setPropertyV(WSNname,"policy_select");
	policy_select->setPropertyV(WSNtitleString,WSGFgettext("a4:WSSTR Look and Feel"));
	policy_select->setPropertyV(WSNx,(short)106);
	policy_select->setPropertyV(WSNy,(short)131);
	policy_select->setPropertyV(WSNwidth,(unsigned short)500);
	policy_select->setPropertyV(WSNheight,(unsigned short)135);
	WSCprocedure* op_policy_select_5 = new WSCprocedure("actop1",2);
	extern void actop1(WSCbase*);
	op_policy_select_5->setFunction(actop1,"actop1");
	policy_select->addProcedure(op_policy_select_5);

	WSCvlabel* polvlab_000 = new  WSCvlabel(policy_select,"polvlab_000");
	polvlab_000->initialize();
	polvlab_000->setPropertyV(WSNshadowType,(char)1);
	polvlab_000->setPropertyV(WSNbackColor,"DEF10");
	polvlab_000->setPropertyV(WSNtopShadowColor,"DEF3");
	polvlab_000->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvlab_000->setPropertyV(WSNname,"polvlab_000");
	polvlab_000->setPropertyV(WSNvis,(WSCbool)1);
	polvlab_000->setPropertyV(WSNy,(short)5);
	polvlab_000->setPropertyV(WSNwidth,(unsigned short)1280);
	polvlab_000->setPropertyV(WSNheight,(unsigned short)2);

	WSCvlabel* polvlab_001 = new  WSCvlabel(policy_select,"polvlab_001");
	polvlab_001->initialize();
	polvlab_001->setPropertyV(WSNbackColor,"DEF1");
	polvlab_001->setPropertyV(WSNtopShadowColor,"DEF3");
	polvlab_001->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvlab_001->setPropertyV(WSNlabelString,"Look & Feel");
	polvlab_001->setPropertyV(WSNname,"polvlab_001");
	polvlab_001->setPropertyV(WSNvis,(WSCbool)1);
	polvlab_001->setPropertyV(WSNx,(short)5);
	polvlab_001->setPropertyV(WSNy,(short)10);
	polvlab_001->setPropertyV(WSNwidth,(unsigned short)150);
	polvlab_001->setPropertyV(WSNheight,(unsigned short)20);



	polvopti000 = new  WSCoption(policy_select,"polvrad_002");
	polvopti000->initialize();
	polvopti000->setPropertyV(WSNx,(short)160);
	polvopti000->setPropertyV(WSNy,(short)10);
	polvopti000->setPropertyV(WSNwidth,(unsigned short)200);
	polvopti000->setPropertyV(WSNheight,(unsigned short)20);

    WSCstring* str = WSGFreadTextFile("$(WSDIR)/sys/data/lookfeels");
    WSCstring menu;
    if (str != NULL){
      long cnt = 0;
      while(!str->eof()){
        WSCstring line = str->gets();
        if (line.getWords(",") != 3){
          continue;
        }
        WSCstring item = line.getWord(0,",");
        WSCstring val = line.getWord(1,",");
        WSCstring expolicy_name = line.getWord(2,",");
        item.delHeadSpace();
        item.delTailSpace();
        val.delHeadSpace();
        val.delTailSpace();
        expolicy_name.delHeadSpace();
        expolicy_name.delTailSpace();
        if (cnt != 0){
          menu << ",";
        }
        menu << item << ":" << cnt << ":";
        look_and_feel_name_list.add((void*)WSGFstrdup(expolicy_name));
        look_and_feel_value_list.add((void*)atoi((char*)val));
        cnt++;
      }
      delete str;
    }
	polvopti000->setProperty(WSNmenuItems,(char*)menu);

	polvopti000->setPropertyV(WSNvis,(WSCbool)1);

#if 0
	polvrad_002 = new  WSCvradio(policy_select,"polvrad_002");
	polvrad_002->initialize();
	polvrad_002->setPropertyV(WSNindicatorSize,(unsigned char)16);
	polvrad_002->setPropertyV(WSNindicatorColor,"white");
	polvrad_002->setPropertyV(WSNselectColor,"DEF14");
	polvrad_002->setPropertyV(WSNunique,(WSCbool)1);
	polvrad_002->setPropertyV(WSNgroup,"lookfeel");
	polvrad_002->setPropertyV(WSNid,(short)1);
	polvrad_002->setPropertyV(WSNbackColor,"DEF10");
	polvrad_002->setPropertyV(WSNtopShadowColor,"DEF3");
	polvrad_002->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvrad_002->setPropertyV(WSNlabelString,"Original");
	polvrad_002->setPropertyV(WSNalignmentH,(unsigned char)0);
	polvrad_002->setPropertyV(WSNmarginTop,(unsigned char)0);
	polvrad_002->setPropertyV(WSNmarginBottom,(unsigned char)0);
	polvrad_002->setPropertyV(WSNmarginLeft,(unsigned char)10);
	polvrad_002->setPropertyV(WSNmarginRight,(unsigned char)0);
	polvrad_002->setPropertyV(WSNname,"polvrad_002");
	polvrad_002->setPropertyV(WSNvis,(WSCbool)1);
	polvrad_002->setPropertyV(WSNx,(short)160);
	polvrad_002->setPropertyV(WSNy,(short)10);
	polvrad_002->setPropertyV(WSNwidth,(unsigned short)200);
	polvrad_002->setPropertyV(WSNheight,(unsigned short)20);

	polvrad_003 = new  WSCvradio(policy_select,"polvrad_003");
	polvrad_003->initialize();
	polvrad_003->setPropertyV(WSNindicatorSize,(unsigned char)16);
	polvrad_003->setPropertyV(WSNindicatorColor,"white");
	polvrad_003->setPropertyV(WSNselectColor,"DEF14");
	polvrad_003->setPropertyV(WSNunique,(WSCbool)1);
	polvrad_003->setPropertyV(WSNgroup,"lookfeel");
	polvrad_003->setPropertyV(WSNid,(short)2);
	polvrad_003->setPropertyV(WSNbackColor,"DEF10");
	polvrad_003->setPropertyV(WSNtopShadowColor,"DEF3");
	polvrad_003->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvrad_003->setPropertyV(WSNlabelString,"Windows");
	polvrad_003->setPropertyV(WSNalignmentH,(unsigned char)0);
	polvrad_003->setPropertyV(WSNmarginTop,(unsigned char)0);
	polvrad_003->setPropertyV(WSNmarginBottom,(unsigned char)0);
	polvrad_003->setPropertyV(WSNmarginLeft,(unsigned char)10);
	polvrad_003->setPropertyV(WSNmarginRight,(unsigned char)0);
	polvrad_003->setPropertyV(WSNname,"polvrad_003");
	polvrad_003->setPropertyV(WSNvis,(WSCbool)1);
	polvrad_003->setPropertyV(WSNx,(short)161);
	polvrad_003->setPropertyV(WSNy,(short)33);
	polvrad_003->setPropertyV(WSNwidth,(unsigned short)200);
	polvrad_003->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* polvlab_004 = new  WSCvlabel(policy_select,"polvlab_004");
	polvlab_004->initialize();
	polvlab_004->setPropertyV(WSNshadowType,(char)1);
	polvlab_004->setPropertyV(WSNbackColor,"DEF10");
	polvlab_004->setPropertyV(WSNtopShadowColor,"DEF3");
	polvlab_004->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvlab_004->setPropertyV(WSNname,"polvlab_004");
	polvlab_004->setPropertyV(WSNvis,(WSCbool)1);
	polvlab_004->setPropertyV(WSNy,(short)55);
	polvlab_004->setPropertyV(WSNwidth,(unsigned short)1280);
	polvlab_004->setPropertyV(WSNheight,(unsigned short)2);

	WSCvlabel* polvlab_005 = new  WSCvlabel(policy_select,"polvlab_005");
	polvlab_005->initialize();
	polvlab_005->setPropertyV(WSNbackColor,"DEF1");
	polvlab_005->setPropertyV(WSNtopShadowColor,"DEF3");
	polvlab_005->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvlab_005->setPropertyV(WSNlabelString,"Gradation");
	polvlab_005->setPropertyV(WSNname,"polvlab_005");
	polvlab_005->setPropertyV(WSNvis,(WSCbool)1);
	polvlab_005->setPropertyV(WSNx,(short)5);
	polvlab_005->setPropertyV(WSNy,(short)60);
	polvlab_005->setPropertyV(WSNwidth,(unsigned short)150);
	polvlab_005->setPropertyV(WSNheight,(unsigned short)20);

	polvrad_000 = new  WSCvradio(policy_select,"polvrad_000");
	polvrad_000->initialize();
	polvrad_000->setPropertyV(WSNindicatorSize,(unsigned char)16);
	polvrad_000->setPropertyV(WSNindicatorColor,"white");
	polvrad_000->setPropertyV(WSNselectColor,"DEF14");
	polvrad_000->setPropertyV(WSNid,(short)1);
	polvrad_000->setPropertyV(WSNbackColor,"DEF10");
	polvrad_000->setPropertyV(WSNtopShadowColor,"DEF3");
	polvrad_000->setPropertyV(WSNbottomShadowColor,"DEF4");
	polvrad_000->setPropertyV(WSNlabelString,"Gradation");
	polvrad_000->setPropertyV(WSNalignmentH,(unsigned char)0);
	polvrad_000->setPropertyV(WSNmarginTop,(unsigned char)0);
	polvrad_000->setPropertyV(WSNmarginBottom,(unsigned char)0);
	polvrad_000->setPropertyV(WSNmarginLeft,(unsigned char)10);
	polvrad_000->setPropertyV(WSNmarginRight,(unsigned char)0);
	polvrad_000->setPropertyV(WSNname,"polvrad_000");
	polvrad_000->setPropertyV(WSNvis,(WSCbool)1);
	polvrad_000->setPropertyV(WSNx,(short)160);
	polvrad_000->setPropertyV(WSNy,(short)60);
	polvrad_000->setPropertyV(WSNwidth,(unsigned short)200);
	polvrad_000->setPropertyV(WSNheight,(unsigned short)20);
#endif
}

//--- end of src ---//
