//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCbase.h>
#include <WSCprocedure.h>
#include <WSClistData.h>
#include <WSCbaseList.h>
#include <WSCmessageDialog.h>
#include <WSDmouse.h>
#include <WSDdragDrop.h>
#include <WSCvifield.h>
#include <WSCvtoggle.h>
#include <WSCwizardDialog.h>
#include <WSCpopupMenu.h>
#include <advance/WSadcom.h>
#include <advance/WSCprojectEditor.h>
#include <advance/WSCinspector.h>
#include <advance/WSCprocessForm.h>
#include <WSCfileSelect.h>
#include <WSCclassInformation.h>
#include <WSDtimer.h>
#include <WSCoption.h>
#include <WSClocaleSet.h>
#include <WSDappDev.h>
#include <WSCundoManager.h>

extern WSClistData       selected_clients;
extern WSClistData       copy_clients;
extern WSClistData       winlist;
extern WSCwizardDialog*  newwin;
extern WSCmessageDialog* message;
extern WSCinspector*     inspector;
extern WSCstring         current_dir;
extern WSCpopupMenu*     popupmenu;
extern WSCpopupMenu*     popupmenu2;
extern WSCprojectEditor* pe;
extern WSCprocessForm*    procform;


extern void _register_drop_site(WSCbase* obj);
extern void _unregister_drop_site(WSCbase* obj);
extern void _register_popup_menu(WSCbase*);
extern void _unregister_popup_menu(WSCbase*);

long title_cnt = 1;

char* get_win_file_name(WSCbase* client){
  WSCstring fname;
  if (client->getUserData(WS_FILENAME)){
    fname = (char*)client->getUserData(WS_FILENAME);
  }else{
    fname = client->getInstanceName();
    fname << ".win";
  }
static WSCstring ret;
  if (!strcmp((char*)current_dir,"")){
    ret = fname;
  }else{
    ret = current_dir;
    ret << "/" << fname;
  }
//printf("get_win_file_name filename=%s\n",(char*)ret);
  return (char*)ret;
}


void setup_instance(WSCbase* target){
//printf("setup handler:  %s\n",target->getInstanceName());
  _register_drop_site(target);
  _register_popup_menu(target);
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSGIappUndoManager()->clear();
#endif
#endif

#if 0 /* move to make_execute*/
extern WSCobjectBox* objectbox;
  WSCstring reqlib = objectbox->getRequiredLibrary(target->getClassName());
  if (strcmp((char*)reqlib,"")){
extern void add_lib_list(char*);
    add_lib_list(reqlib);
  }
#endif
}

void del_instance(WSCbase* target){
//printf("delete handler:  %s\n",target->getInstanceName());
  _unregister_drop_site(target);
  _unregister_popup_menu(target);
  WSCbase* parent = target->getParent();
  if (parent == NULL){
    winlist.del(target);
  }
  long val = (long)target->getUserData(WS_NO_DEL_BUILDER_DATA);
  if (val == 0){
    WSClistData* property_list =(WSClistData*)target->getUserData(WS_PROP_LIST);
    if (property_list != NULL){
      long num = property_list->getNum();
      long i;
      for(i=0; i< num; i++){
        prop_data* propdata = (prop_data*)(*property_list)[i];
        delete propdata;
      }
      delete property_list;
      target->setUserData(WS_PROP_LIST,NULL);
    }
    WSClistData* utrg_list =(WSClistData*)target->getUserData(WS_UTRG_LIST);
    if (utrg_list != NULL){
      long num = utrg_list->getNum();
      long i;
      for(i=0; i< num; i++){
        utrg_data* utrgdata = (utrg_data*)(*utrg_list)[i];
        delete utrgdata;
      }
      delete utrg_list;
      target->setUserData(WS_UTRG_LIST,NULL);
    }
    WSClistData* trg_list =(WSClistData*)target->getUserData(WS_TRG_LIST);
    if (trg_list != NULL){
      delete trg_list;
      target->setUserData(WS_TRG_LIST,NULL);
    }
    WSClistData* rmtd_list =(WSClistData*)target->getUserData(WS_RMETHOD_LIST);
    if (rmtd_list != NULL){
      long num = rmtd_list->getNum();
      long i;
      for(i=0; i< num; i++){
        rmethod_data* rmdata = (rmethod_data*)(*rmtd_list)[i];
        delete rmdata;
      }
      delete rmtd_list;
      target->setUserData(WS_RMETHOD_LIST,NULL);
    }
    WSClistData* rcname =(WSClistData*)target->getUserData(WS_RCLASS_NAME);
    if (rcname != NULL){
      delete rcname;
      target->setUserData(WS_RCLASS_NAME,NULL);
    }
    WSClistData* rcbname =(WSClistData*)target->getUserData(WS_RCLASS_BNAME);
    if (rcbname != NULL){
      delete rcbname;
      target->setUserData(WS_RCLASS_BNAME,NULL);
    }
  }
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSGIappUndoManager()->clear();
#endif
#endif
//printf("delete handler: done.\n");
}

long win_save(WSCbase* win){
  WSCstring str = WSGFcreateWinSrc(win);
  WSCstring fname(get_win_file_name(win));
  long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }

  long ret = 0;
//  if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
    ret = WSGFreplaceTextFile((char*)fname,str.getString(encoding),False);
//  }else{
//    ret = WSGFreplaceTextFile((char*)fname,(char*)str,False);
//  }
  if (ret != WS_NO_ERR){
    WSCstring buf;
    buf << WSGFgettext("A4:WSSTR Failed to save FILE: ") << fname
        << WSGFgettext("B4:WSSTR .");
    message->setPropertyV(WSNwidth,(WSCushort)640);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
    return WS_ERR;
  }
  WSGFclearMarkChanged(win);
  return WS_NO_ERR;
}
long check_win_save(WSCbase* win){
  WSCstring str = WSGFcreateWinSrc(win);
  WSCstring fname(get_win_file_name(win));
  long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }

  long ret = 0;
//  if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
    char* outstr = str.getString(encoding);
    ret = WSGFcheckDiffFile((char*)fname,outstr,strlen(outstr));
//  }else{
//    char* outstr = (char*)str;
//    ret = WSGFcheckDiffFile((char*)fname,outstr,strlen(outstr));
//  }
  return ret;
}




long win_rename_save(WSCbase* win){
  WSCstring str = WSGFcreateWinSrc(win);
extern WSCfileSelect* fselect;
  fselect->setPropertyV(WSNmaskFileName,"win");
  fselect->setPropertyV(WSNfileName,get_win_file_name(win));
extern char* get_project_dir();
  fselect->setPropertyV(WSNdirName,get_project_dir());

  long ret = fselect->popup();
  if (ret != WS_DIALOG_OK){
    return WS_NO_ERR;
  }
  WSCstring fname(fselect->getFileName());

  long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }

//  if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
    ret = WSGFreplaceTextFile((char*)fname,str.getString(encoding),False);
//  }else{
//    ret = WSGFreplaceTextFile((char*)fname,(char*)str,False);
//  }
  if (ret != WS_NO_ERR){
    WSCstring buf;
    buf << WSGFgettext("A4:WSSTR Failed to save FILE: ") << fname
        << WSGFgettext("B4:WSSTR .");
    message->setPropertyV(WSNwidth,(WSCushort)640);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
    return WS_ERR;
  }
  WSGFclearMarkChanged(win);
  return WS_NO_ERR;
}


void isave_proc(WSCbase* target){
  WSCbase* parent = target->getParentWindow();
  if (parent == NULL){
    return;
  }
  win_save(parent);
}
void isave_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    isave_proc(target);
  }
}

void isave_work(WSCbase*){
//printf("isave..\n");
  WSCbase* target = (WSCbase*)inspector->getPopupMenuSelectedClient();
  if (target == NULL){
    return;
  }
  isave_proc(target);
}
void idel_delay_work(WSCuchar,void* ptr){
  WSCbase* client = (WSCbase*)ptr;
  WSCbase* parent = client->getParent();
  if (parent == NULL){
    winlist.del(client);
    inspector->updateList();
  }
  delete client;
  inspector->updateList();
}
void idel_proc(WSCbase* target){
  long i,j;
  long num = selected_clients.getNum();
  WSClistData dlist;
  for(i=0; i<num; i++){
    WSCbase* client = (WSCbase*)selected_clients[i];
    if (client != target){
      long add_fl = True;
      long inum = dlist.getNum();
      for(j=0; j<inum; j++){
        WSCbase* item = (WSCbase*)dlist[j];
        if (client->isParent(item) != False){
          add_fl = False;
        } 
      }
      if (add_fl != False){
        dlist.add(client);
      }
    }
  }
  long add_fl = True;
  long inum = dlist.getNum();
  for(j=0; j<inum; j++){
    WSCbase* item = (WSCbase*)dlist[j];
    if (target->isParent(item) != False){
      add_fl = False;
    } 
  }
  if (add_fl != False){
    dlist.add(target);
  }
  
  num = dlist.getNum();
  for(i=0; i<num; i++){
    WSCbase* client = (WSCbase*)dlist[i];
    if (WSGIappObjectList()->existInstance(client) == False){
      continue;
    }
    WSCstring str;
    str << WSGFgettext("C4:WSSTR Delete instance:") << client->getInstanceName()
        << WSGFgettext("D4:WSSTR ?");
    message->setPropertyV(WSNlabelString,(char*)str);  
    message->setPropertyV(WSNcancel,(WSCbool)True);
    long ret = message->popup();
    message->setPropertyV(WSNcancel,(WSCbool)False);
    if (ret == WS_DIALOG_OK){
      selected_clients.clear();
      copy_clients.clear();
      WSGIappTimer()->addTriggerProc(idel_delay_work,WS250MS,client);
    }else if (ret == WS_DIALOG_CANCEL){
      break;
    }
  }
}

void idel_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    if (WSGIappObjectList()->existInstance(target) != False){
      idel_proc(target);
    }
  }
}
void idel_work(WSCbase*){
  WSCbase* target = inspector->getPopupMenuSelectedClient();
//printf("idel_work target=0x%x\n",target);
  if (target == NULL){
    return;
  }
  if (WSGIappObjectList()->existInstance(target) != False){
    idel_proc(target);
  }
}

void ifront_proc(WSCbase* target){
  target->setOrder(WS_BOTTOM);
}
void ifront_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    if (WSGIappObjectList()->existInstance(target) != False){
      ifront_proc(target);
    }
  }
}
void ifront_work(WSCbase*){
  WSCbase* target = inspector->getPopupMenuSelectedClient();
//printf("ifront_work target=0x%x\n",target);
  if (target == NULL){
    return;
  }
  if (WSGIappObjectList()->existInstance(target) != False){
    ifront_proc(target);
  }
}

void iback_proc(WSCbase* target){
  target->setOrder(WS_TOP);
}
void iback_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    if (WSGIappObjectList()->existInstance(target) != False){
      iback_proc(target);
    }
  }
}
void iback_work(WSCbase*){
  WSCbase* target = inspector->getPopupMenuSelectedClient();
//printf("iback_work target=0x%x\n",target);
  if (target == NULL){
    return;
  }
  if (WSGIappObjectList()->existInstance(target) != False){
    iback_proc(target);
  }
}

void isearch_proc(WSCbase* target){
//extern void under_construction();
//  under_construction();
extern void exec_obj_search();
  exec_obj_search();
}
void isearch_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    isearch_proc(target);
  }
}
void isearch_work(WSCbase*){
//printf("isearch..\n");
  WSCbase* target = (WSCbase*)inspector->getPopupMenuSelectedClient();
  if (target == NULL){
    return;
  }
  isearch_proc(target);
}

void ipaste_proc(WSCbase* target){
//printf("obj=%s\n",target->getInstanceName());
extern void paste(WSCbase*);
  paste(target);
}
void ipaste_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    ipaste_proc(target);
  }
}
void _delay_ipaste_proc(WSCuchar clk,void* ptr){
  WSCbase* target = (WSCbase*)ptr;
  ipaste_proc(target);
}
void ipaste_work(WSCbase*){
//printf("ipaste..\n");
  WSCbase* target = (WSCbase*)inspector->getPopupMenuSelectedClient();
  if (target == NULL){
    return;
  }
  WSGIappTimer()->addTriggerProc(_delay_ipaste_proc,WS2000MS,target);
//  ipaste_proc(target);
}

void icopy_proc(WSCbase* target){
//printf("obj=%s\n",target->getInstanceName());
  copy_clients.clear();
  long i;
  long num = selected_clients.getNum();
  for(i=0; i<num; i++){
    void* val = selected_clients[i];
    copy_clients.add((void*)val);
  }
//printf("icopy_proc  selected=%d  num=%d\n",num,copy_clients.getNum());
}
void icopy_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    icopy_proc(target);
  }
}
void icopy_work(WSCbase*){
//printf("icopy..\n");
  WSCbase* target = (WSCbase*)inspector->getPopupMenuSelectedClient();
  if (target == NULL){
    return;
  }
  icopy_proc(target);
}

void iprj_proc(WSCbase* base){
//printf("obj=%s\n",target->getInstanceName());
extern WSCmessageDialog* question;
  question->setPropertyV(WSNwidth,(WSCushort)500);
  question->setPropertyV(WSNreplyHandler,(void*)NULL);
  WSCstring buffer;
  WSCbase* target = base->getParentWindow();
  if (target->getUserData(WS_REGISTERED) == NULL){
    buffer << WSGFgettext("E4:WSSTR Add application window: ") << target->getInstanceName()
           << WSGFgettext("F4:WSSTR  to the project?");
    question->setPropertyV(WSNlabelString,(char*)buffer);
    long ret = question->popup();
    if (ret == WS_DIALOG_OK){
      target->setUserData(WS_REGISTERED,(void*)1);
    }    
  }else{
    buffer << WSGFgettext("G4:WSSTR Remove application window: ") << target->getInstanceName()
           << WSGFgettext("H4:WSSTR  from the project?");
    question->setPropertyV(WSNlabelString,(char*)buffer);
    long ret = question->popup();
    if (ret == WS_DIALOG_OK){
      target->setUserData(WS_REGISTERED,(void*)0);
    }    
  }
}
void iprj_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    iprj_proc(target);
  }
}
void iprj_work(WSCbase* menu){
  WSCbase* target = (WSCbase*)inspector->getPopupMenuSelectedClient();
  if (target == NULL){
    return;
  }
  iprj_proc(target);
}
void icmpl_proc(WSCbase* base){

extern long create_makefile();
extern long create_window_src(WSCbase*);
extern char* get_project_dir();

  WSCbase* target = base->getParentWindow();
  create_makefile();
  create_window_src(target);
  WSCstring fname;
  WSCstring str;
//#ifdef FreeBSD
//  if (target->getUserData(WS_WIN_CLASS)){
//    fname = target->getInstanceName();
//    str << "cd " << get_project_dir() << ";";
//    str << "/bin/rm -f " << fname << ".o " << fname << "P.o ;";
//    str << "gmake " << fname << ".o " << fname << "P.o 2>&1 | tee log.txt";
//  }else{
//    fname = target->getInstanceName();
//    str << "cd " << get_project_dir() << ";";
//    str << "/bin/rm -f " << fname << ".o ;";
//    str << "gmake " << fname << ".o 2>&1 | tee log.txt";
//    WSGFresetClassBase(target);
//  }
//#else /*FreeBSD*/
#ifdef MSW
  if (target->getUserData(WS_WIN_CLASS)){
    str = get_project_dir();
    procform->setPropertyV(WSNdirName,(char*)str);
    fname = target->getInstanceName();
    str = "";
    str << "rm.exe -f " << fname << ".o " << fname << "P.o";
    procform->setPropertyV(WSNfileName,(char*)str);
    procform->setVisible(True);
    procform->start();
    while(1){
      if (procform->getHandle() == 0){
        break;
      }
      WSGIappDev()->dispatchEvent();
    }
    procform->setProperty(WSNlabelString,"");
    str = "";
extern char* get_make_name();
//    str << "make " << fname << ".o " << fname << "P.o";
    str << get_make_name() << " " << fname << ".o " << fname << "P.o";
  }else{
    str = get_project_dir();
    procform->setPropertyV(WSNdirName,(char*)str);

    str = "";
    fname = target->getInstanceName();
    str << "rm.exe -f " << fname << ".o ;";
    procform->setPropertyV(WSNfileName,(char*)str);
    procform->setVisible(True);
    procform->start();
    while(1){
      if (procform->getHandle() == 0){
        break;
      }
      WSGIappDev()->dispatchEvent();
    }
    procform->setProperty(WSNlabelString,"");
extern char* get_make_name();
    str = "";
//    str << "make " << fname << ".o ";
    str << get_make_name() << " " << fname << ".o ";
    WSGFresetClassBase(target);
  }
#else /* MSW */
  if (target->getUserData(WS_WIN_CLASS)){
    fname = target->getInstanceName();
    str << "cd \"" << get_project_dir() << "\";";
    str << "/bin/rm -f " << fname << ".o " << fname << "P.o ;";
extern char* get_make_name();
//    str << "make " << fname << ".o " << fname << "P.o 2>&1 | tee log.txt";
    str << get_make_name() << " " << fname << ".o " << fname << "P.o 2>&1 | tee log.txt";
  }else{
    fname = target->getInstanceName();
    str << "cd \"" << get_project_dir() << "\";";
    str << "/bin/rm -f " << fname << ".o ;";
extern char* get_make_name();
//    str << "make " << fname << ".o 2>&1 | tee log.txt";
    str << get_make_name() << " " << fname << ".o 2>&1 | tee log.txt";
    WSGFresetClassBase(target);
  }
#endif /* MSW */
//#endif /* FreeBSD */

extern WSCprocessForm* procform;
//printf("execute_buildall exec:%s\n",(char*)str);
  procform->setPropertyV(WSNlabelString,"");
  procform->setPropertyV(WSNfileName,(char*)str);
  procform->setVisible(True);
  procform->start();

}
void icmpl_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target != NULL){
    icmpl_proc(target);
  }
}

void icmpl_work(WSCbase* menu){
//printf("icmpl..\n");
  WSCbase* target = (WSCbase*)inspector->getPopupMenuSelectedClient();
  if (target == NULL){
    return;
  }
  icmpl_proc(target);
}

void iprop_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target == NULL){
    return;
  }
//printf("obj=%s\n",target->getInstanceName());
//extern void under_construction();
//  under_construction();
  inspector->setSelectIndexTab(2);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)2);
}

void iop_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target == NULL){
    return;
  }
//printf("obj=%s\n",target->getInstanceName());
//extern void under_construction();
//  under_construction();
  inspector->setSelectIndexTab(3);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)3);
}
void iextprop_work2(WSCbase* menu){
  WSCbase* target;
  menu->getPropertyV(WSNclient,(void**)&target);
  if (target == NULL){
    return;
  }
//printf("obj=%s\n",target->getInstanceName());
//extern void under_construction();
//  under_construction();
  inspector->setSelectIndexTab(4);
//  inspector->setPropertyV(WSNvalue,(WSCuchar)4);
}



WSCstring& get_dir_name(char* fname){
static WSCstring ret;
  ret = "";
  WSCstring fn(fname);
  long wnum = fn.getWords("/");
  if (wnum == 0){
    return ret;
  }
  long i;
  for(i=0; i < wnum -1; i++){
    ret << fn.getWord(i,"/");
    if (i != wnum -2){
      ret << "/";
    }
  }
  return ret;
}

WSCstring& get_file_name(char* fname){
static WSCstring ret;
  ret = "";
  WSCstring fn(fname);
  long wnum = fn.getWords("/");
  if (wnum == 0){
    return ret;
  }

  ret = fn.getWord(wnum-1,"/");
  return ret;
}

long read_win_file(char* dirname,char* fname,WSClistData* wlist){
  WSCstring fname2;
  if ( !strcmp(dirname,"") ){
    fname2 << fname;
  }else{
    fname2 << dirname << "/" << fname;
  }

  long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }
  WSCstring* windata = WSGFreadTextFile((char*)fname2,encoding);
  if (windata != NULL){
    
    WSCbase* win = WSGFreadWinSrc(*windata,True);
    if (win != NULL){
      win->setUserData(WS_REGISTERED,(void*)1);
      win->setUserData(WS_FILENAME,WSGFstrdup((char*)fname));
      wlist->add((void*)win);
    }else{
      WSCstring buffer;
      buffer << WSGFgettext("I4:WSSTR Failed to read file:") << fname2
             << WSGFgettext("J4:WSSTR .\nDo you stop reading?");
      message->setPropertyV(WSNwidth,(WSCushort)500);
      message->setPropertyV(WSNheight,(WSCushort)135);
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,(char*)buffer);
      message->setPropertyV(WSNno,(WSCbool)True);
      message->setPropertyV(WSNcancel,(WSCbool)True);
      long ret = message->popup();
      message->setPropertyV(WSNcancel,(WSCbool)False);
      message->setPropertyV(WSNwidth,(WSCushort)450);
      message->setPropertyV(WSNheight,(WSCushort)125);
      message->setPropertyV(WSNno,(WSCbool)False);
      if (ret == WS_DIALOG_OK){
        delete windata;
        return WS_ERR;
      }
    }
    delete windata;
  }else{
    WSCstring buffer;
      buffer << WSGFgettext("I4:WSSTR Failed to read file:") << fname2
             << WSGFgettext("J4:WSSTR .\nDo you stop reading?");
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buffer);
    message->setPropertyV(WSNwidth,(WSCushort)500);
    message->setPropertyV(WSNheight,(WSCushort)135);
    message->setPropertyV(WSNno,(WSCbool)True);
    message->setPropertyV(WSNcancel,(WSCbool)True);
    long ret = message->popup();
    message->setPropertyV(WSNcancel,(WSCbool)False);
    message->setPropertyV(WSNno,(WSCbool)False);
    message->setPropertyV(WSNwidth,(WSCushort)450);
    message->setPropertyV(WSNheight,(WSCushort)125);
    if (ret == WS_DIALOG_OK){
      return WS_ERR;
    }
  }
  return WS_NO_ERR;
}

extern WSCmessageDialog* message;
long _load_winfiles(char* dirname,char* filename,WSClistData* wlist){
  WSCstring fname;
  if ( !strcmp(dirname,"") ){
    fname << filename;
  }else{
    fname << dirname << "/" << filename;
  }
  WSCstring* data = WSGFreadTextFile((char*)fname);
  if (data == NULL){
    WSCstring buffer;
    buffer << WSGFgettext("K4:WSSTR Failed to open File: ") << fname
           << WSGFgettext("L4:WSSTR .");
extern WSCmessageDialog* message;
    message->setPropertyV(WSNwidth,(WSCushort)500);
    message->setPropertyV(WSNheight,(WSCushort)120);
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buffer);
    message->popup();
    return WS_ERR;
  }
  WSCstring line;
  while(data->eof() == False){
    line = data->gets();
    line.delHeadSpace();
    line.delTailSpace();

    long ret1 = read_win_file(dirname,line,wlist);
    if (ret1 == WS_ERR){
      delete data;
      return WS_ERR;
    }

#if 0
    WSCstring* windata = WSGFreadTextFile((char*)fname2);
    if (windata != NULL){
      WSCbase* win = WSGFreadWinSrc(*windata,True);
      if (win != NULL){
        win->setUserData(WS_REGISTERED,(void*)1);
        win->setUserData(WS_FILENAME,WSGFstrdup((char*)line));
        wlist->add((void*)win);
      }else{
        WSCstring buffer;
      buffer << WSGFgettext("I4:WSSTR Failed to read file:") << fname2;
             << WSGFgettext("J4:WSSTR .\nDo you stop reading?");
        message->setPropertyV(WSNwidth,(WSCushort)500);
        message->setPropertyV(WSNheight,(WSCushort)135);
        message->setPropertyV(WSNreplyHandler,(void*)NULL);
        message->setPropertyV(WSNlabelString,(char*)buffer);
        message->setPropertyV(WSNno,(WSCbool)True);
        long ret = message->popup();
        message->setPropertyV(WSNno,(WSCbool)False);
        if (ret == WS_DIALOG_OK){
          delete windata;
          delete data;
          return WS_ERR;
        }
      }
      delete windata;
    }else{
      WSCstring buffer;
      buffer << WSGFgettext("I4:WSSTR Failed to read file:") << fname2;
             << WSGFgettext("J4:WSSTR .\nDo you stop reading?");
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,(char*)buffer);
      message->setPropertyV(WSNwidth,(WSCushort)500);
      message->setPropertyV(WSNheight,(WSCushort)135);
      message->setPropertyV(WSNno,(WSCbool)True);
      long ret = message->popup();
      message->setPropertyV(WSNno,(WSCbool)False);
      if (ret == WS_DIALOG_OK){
        delete data;
        return WS_ERR;
      }
    }
#endif
  }
  delete data;
  return WS_NO_ERR;
}

long load_winfiles(char* filename,WSClistData* wlist){
  return _load_winfiles(get_dir_name(filename),get_file_name(filename),wlist);
}

long _save_winfiles(char* dirname,char* filename,WSClistData* wlist){

  WSCstring data;
  long i;
  long num = wlist->getNum();
  for(i=0; i<num; i++){
    WSCbase* win = (WSCbase*)(*wlist)[i];
    WSCstring output = WSGFcreateWinSrc(win);

    WSCstring fname2;
    if ( strcmp(dirname,"") ){
      fname2 << dirname << "/";
    }
  
    char* wname = (char*)win->getUserData(WS_FILENAME);
    if (wname == NULL){
      fname2 << win->getInstanceName() << ".win";
    }else{
      fname2 << wname;
    }
    long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
      encoding = WS_EN_LOCALE;
    }

    long ret = 0;
//    if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
      ret = WSGFreplaceFile(fname2,output.getString(encoding),
                               strlen(output.getString(encoding)),False );
//    }else{
//      ret = WSGFreplaceFile(fname2,(char*)output,
//                               strlen((char*)output),False );
//    }
    if (ret != WS_NO_ERR){
      WSCstring buffer;
      buffer << WSGFgettext("I4:WSSTR Failed to read file:") << fname2
             << WSGFgettext("J4:WSSTR .\nDo you stop reading?");
      message->setPropertyV(WSNreplyHandler,(void*)NULL);
      message->setPropertyV(WSNlabelString,(char*)buffer);
      message->setPropertyV(WSNno,(WSCbool)True);
      long ret = message->popup();
      message->setPropertyV(WSNno,(WSCbool)False);
      if (ret == WS_DIALOG_OK){
        return WS_ERR;
      }
    }
    if (wname == NULL){
      data << win->getInstanceName() << ".win\n";
    }else{
      data << wname << "\n";
    }
  }

  WSCstring fname;
  if ( !strcmp(dirname,"") ){
    fname << filename;
  }else{
    fname << dirname << "/" << filename;
  }

  long ret = WSGFreplaceFile(fname,(char*)data,
                             strlen((char*)data),False );


  if (ret != WS_NO_ERR){
    WSCstring buffer;
    buffer << WSGFgettext("M4:WSSTR Failed to write File: ") << fname
           << WSGFgettext("N4:WSSTR .");
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buffer);
    message->popup();
    return WS_ERR;
  }
  return WS_NO_ERR;
}

long save_winfiles(char* fname,WSClistData* wlist){
  return _save_winfiles(get_dir_name(fname),get_file_name(fname),wlist);
}



WSCbase* create_new_window(char* cname){
  if (cname == NULL){
    return NULL;
  }
extern WSCvifield* nmif1;
  long status = newwin->popup();
  if (status != WS_DIALOG_DONE){
    return NULL;
  }
  WSCstring iname(nmif1->getProperty(WSNlabelString));
  iname.delHeadSpace();
  iname.delTailSpace();
  long ret = WSGFexistName(iname.getString(),NULL);
  if (ret == WS_OBJECT_ARRAY_NAME){
extern WSCmessageDialog* message;
    WSCstring str;
    str << WSGFgettext("O4:WSSTR Invalid name: ") << iname
        << WSGFgettext("P4:WSSTR .\nCan not use array name.");
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNlabelString,(char*)str);
    message->popup();
    return NULL;
  }else if (ret == WS_PROCEDURE_NAME){
extern WSCmessageDialog* message;
    message->setPropertyV(WSNlabelString,WSGFgettext("O3:WSSTR Invalid name.\nAlready used by another event procedure."));
    message->popup();
    return NULL;
  }else if (ret == WS_OBJECT_NAME){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Invalid name.\nAlready used by another externalinstance."));
    message->popup();
    return NULL;
  }else if (ret == WS_OBJECT_ARRAY_NAME_INVALID){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("Q3:WSSTR Invalid array name.\nThe Array type differs from another one,or exists also another window."));
    message->popup();
    return NULL;
  }else if (ret == WS_OTHER_NAME){
extern WSCmessageDialog* message;
      message->setPropertyV(WSNlabelString,
        WSGFgettext("R3:WSSTR Invalid name.\nAlready used by the project name or the other one."));
    message->popup();
    return NULL;
  }

extern char* get_project_name();
  if (!strcmp(get_project_name(),iname)){
extern WSCmessageDialog* message;
    WSCstring str;
    str << WSGFgettext("O4:WSSTR Invalid name: ") << iname
        << WSGFgettext("P4:WSSTR .\nAlready used by project name.");
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNlabelString,(char*)str);
    message->popup();
    return NULL;
  }

  if (WSGFcheckNameString((char*)iname) == False){
extern WSCmessageDialog* message;
    WSCstring str;
    str << WSGFgettext("O4:WSSTR Invalid name: ") << iname
        << WSGFgettext("P4:WSSTR .\nPlease specify a usable name in C/C++ variables.");
    message->setPropertyV(WSNwidth,(WSCushort)400);
    message->setPropertyV(WSNlabelString,(char*)str);
    message->popup();
    return NULL;
  }

extern WSCoption* nmopt1;
  long val =nmopt1->getValue();
  char* ptr = (char*)val;
  WSCbase* win = NULL;
  if (!strcmp(ptr,"NONE")){
    win = WSCbase::getNewInstance(cname,NULL,iname);
  }else{
    long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING"));
    WSCstring fname;
    fname << "$(WSDIR)/sys/data/"
//          << WSGIappLocaleSet()->getDefaultLocaleName()
          << WSGFgetEncodingName(encoding)
//          << WSGIappLocaleSet()->getSystemLocaleName()
          << "/" << cname << "/" << ptr;
    if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
      encoding = WS_EN_LOCALE;
    }

    WSCstring* windata = WSGFreadTextFile((char*)fname,encoding);
    if (windata != NULL){
      win = WSGFreadWinSrc2(*windata,True,iname);
      if (win == NULL){
        WSCstring buffer;
        buffer << WSGFgettext("Z4:WSSTR Can not read file:")
               << fname
               << WSGFgettext("a4:WSSTR .");
        message->setPropertyV(WSNwidth,(WSCushort)550);
        message->setPropertyV(WSNreplyHandler,(void*)NULL);
        message->setPropertyV(WSNlabelString,(char*)buffer);
        message->setPropertyV(WSNno,(WSCbool)True);
        message->popup();
        return NULL;
      }
    }else{
      WSCstring msg;
      msg << WSGFgettext("Z4:WSSTR Can not read file:")
          << fname
          << WSGFgettext("a4:WSSTR .");
  
      message->setProperty(WSNwidth,550);
      message->setProperty(WSNlabelString,msg);
      message->popup();
      return NULL;
    }
  }

  if (win == NULL){
    WSCstring buffer;
    buffer << WSGFgettext("Q4:WSSTR Can not generate the specified class: ")
           << cname
           << WSGFgettext("R4:WSSTR .");
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buffer);
    message->setPropertyV(WSNwidth,(WSCushort)500);
    message->popup();
    return NULL;
  }
  if (win->cast("WSCwindow") == NULL &&
      win->cast("WSCbaseDialog") == NULL ){
    WSCstring buffer;
    buffer << WSGFgettext("S4:WSSTR Can not change the specified class: ")
           << cname
           << WSGFgettext("T4:WSSTR  to window type.\nPlease specify a class of window/dialog base.");
extern WSCmessageDialog* message;
    message->setPropertyV(WSNreplyHandler,(void*)NULL);
    message->setPropertyV(WSNlabelString,(char*)buffer);
    message->popup();
    return NULL;
  }
  win->initialize();
  win->setPropertyV(WSNx,(short)100);
  win->setPropertyV(WSNy,(short)100);
  win->setPropertyV(WSNwidth,(WSCushort)400);
  win->setPropertyV(WSNheight,(WSCushort)400);

  if (win->existProperty(WSNtitleString) != False){
    WSCstring str;
    str << "title" << title_cnt;
    win->setProperty(WSNtitleString,str);
    title_cnt++;
  }

  void* delete_handler = (void*)WSGFgetDeleteHandler();
  if (delete_handler != NULL){
    WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
    ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
    ac->setInternal(True);
    win->addProcedure(ac);
  }
  WSGFmarkChanged(win);

  win->setVisible(True);
  win->setUserData(WS_EXT_VAR,(void*)1);
extern WSCvtoggle* tgl21;
extern WSCvtoggle* tgl12;
  if (tgl21->getStatus() == 0){
    win->setUserData(WS_REGISTERED,(void*)0);
  }else{
    win->setUserData(WS_REGISTERED,(void*)1);
  }
  if (tgl12->getStatus() == 0){
    win->setUserData(WS_WIN_CLASS,(void*)0);
  }else{
    win->setUserData(WS_WIN_CLASS,(void*)1);
  }
//printf("create_new_win vis=%s\n",(char*)win->getProperty(WSNvis));
//printf("create_new_win2 editmode=%d\n",win->getPropertyEditMode());
  WSGFexecCreateHandler(win);
  win->setPropertyEditExecute(True);
  return win;
}

void add_new_window(WSCbase* win){
  winlist.add(win);
extern WSCinspector* inspector;
  inspector->updateList();
}


void _drop_proc(WSCbase* b1,WSCbase* b2){
  short x,y;
  WSGIappMouse()->getMousePosition(&x,&y,b1);
  WSCbase* btarget=b1;
  while(1){
    if (btarget->getParent() != NULL){
      btarget = btarget->getParent();
    }else{
      break;
    }
  }

  WSCbase* newobj = WSCbase::getNewInstance(b2->getProperty(WSNuserString),b1,
         WSGFcreateName(btarget->getInstanceName(),b2->getProperty(WSNuserString)));
  if (newobj != NULL){
    newobj->initialize();
    newobj->setPropertyEditMode(True);
    newobj->setVisible(False);

    //֥ȤФƲΤǤФΥϥɥ¹...
    WSGFexecCreateHandler(newobj);
    //֥Ȥ˲ΤǤФΥϥɥϿ...
    void* delete_handler = (void*)WSGFgetDeleteHandler();
    if (delete_handler != NULL){
         WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
         ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
         ac->setInternal(True);
         newobj->addProcedure(ac);
    }

    if (newobj->existProperty(WSNx) != False){
      WSCproperty* prop = newobj->getPropObj(WSNx);
      if (prop->getBuilderVisible() != False){
        newobj->setPropertyV(WSNx,x);
      }
    }
    if (newobj->existProperty(WSNy) != False){
      WSCproperty* prop = newobj->getPropObj(WSNy);
      if (prop->getBuilderVisible() != False){
        newobj->setPropertyV(WSNy,y);
      }
    }
extern WSCprojectEditor* pe;
    long dw1 = atoi(pe->getProjectData("#DWIDTH"));
    long dh1 = atoi(pe->getProjectData("#DHEIGHT"));
    long dt1 = atoi(pe->getProjectData("#DTHICKNESS"));
    WSCushort dw = (WSCushort)dw1;
    WSCushort dh = (WSCushort)dh1;
    WSCushort dt = (WSCushort)dt1;
    if (dw <5){
      dw = 5;
    }
    if (dh <5){
      dh = 5;
    }

    if ( dw != 0){
      if (newobj->existProperty(WSNwidth) != False){
        WSCproperty* prop = newobj->getPropObj(WSNwidth);
        if (prop != NULL && prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNwidth,dw);
        }
      }
    }
    if ( dh != 0){
      if (newobj->existProperty(WSNheight) != False){
        WSCproperty* prop = newobj->getPropObj(WSNheight);
        if (prop != NULL && prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNheight,dh);
        }
      }
    }
    if (newobj->existProperty(WSNshadowThickness) != False){
      WSCproperty* prop = newobj->getPropObj(WSNshadowThickness);
      if (prop != NULL && prop->getBuilderVisible() != False){
        newobj->setPropertyV(WSNshadowThickness,(WSCuchar)dt);
      }
    }
#if 0
    char* fg = pe->getProjectData("#FGCOLOR");
    if ( fg != NULL){
      if (newobj->existProperty(WSNforeColor) != False){
        WSCproperty* prop = newobj->getPropObj(WSNforeColor);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNforeColor,fg);
        }
      }
    }
    char* bg = pe->getProjectData("#BGCOLOR");
    if ( bg != NULL){
      if (newobj->existProperty(WSNbackColor) != False){
        WSCproperty* prop = newobj->getPropObj(WSNbackColor);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNbackColor,bg);
        }
      }
    }
    char* ts = pe->getProjectData("#TSCOLOR");
    if ( ts != NULL){
      if (newobj->existProperty(WSNtopShadowColor) != False){
        WSCproperty* prop = newobj->getPropObj(WSNtopShadowColor);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNtopShadowColor,ts);
        }
      }
    }
    char* bs = pe->getProjectData("#BSCOLOR");
    if ( bs != NULL){
      if (newobj->existProperty(WSNbottomShadowColor) != False){
        WSCproperty* prop = newobj->getPropObj(WSNbottomShadowColor);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNbottomShadowColor,bs);
        }
      }
    }
#endif
    if (newobj->existProperty(WSNtitleString) != False){
      WSCstring str;
      str << "title" << title_cnt;
      newobj->setProperty(WSNtitleString,str);
      title_cnt++;
    }
    newobj->setUserData(WS_EXT_VAR,(void*)1);

    newobj->setVisible(True);
#if 0 // already executed in setup_instance
    WSGFregisterPopupMenu(newobj);
    if (newobj->getObjectType() & WS_TYPE_MANAGER){
      WSGIappDragDrop()->registerDropSite(newobj,"OBJECT-CREATE",_drop_proc);
    }
#endif
    newobj->setPropertyEditExecute(True);

extern WSCinspector* inspector;
    inspector->updateList();

  }else{
WSMFtrace("WSGFdropProc create error! #%s#\n",(char*)b2->getProperty(WSNuserString));
  }

}
void _register_drop_site(WSCbase* obj){
  if (obj->getObjectType() & WS_TYPE_MANAGER){
    WSGIappDragDrop()->registerDropSite(obj,"OBJECT-CREATE",_drop_proc);
    WSClistData children = obj->getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children.getData(i);
      if (child->getInternalObject() == False){
        _register_drop_site(child);
      }
    }
  }
}
void _unregister_drop_site(WSCbase* obj){
//printf("_unregister_drop_site here!\n");
  if (obj == NULL){
    return;
  }
//  if (obj->getObjectType() & WS_TYPE_MANAGER){
//printf("_unregister_drop_site %s\n",obj->getInstanceName());
    WSGIappDragDrop()->unregisterDropSite(obj);
//  }
  WSClistData children = obj->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children.getData(i);
    if (child->getInternalObject() == False){
      _unregister_drop_site(child);
    }
  }
}

void _unregister_popup_menu(WSCbase* client){
  if (client->getObjectType() & WS_TYPE_WINDOW){
    popupmenu->unregisterClient(client);
  }else{
    popupmenu2->unregisterClient(client);
  }
}
void _register_popup_menu(WSCbase* client){
  if (client->getObjectType() & WS_TYPE_WINDOW){
    popupmenu->registerClient(client,True);
  }else{
    popupmenu2->registerClient(client,True);
  }
}

void paste(WSCbase* target){
  if (!(target->getObjectType() & WS_TYPE_MANAGER)){
    WSCstring buf;
    buf << WSGFgettext("U4:WSSTR Can not paste the instance on the specified instance: ")
        << target->getInstanceName() << WSGFgettext("V4:WSSTR .");
    message->setPropertyV(WSNwidth,(WSCushort)500);
    message->setPropertyV(WSNlabelString,(char*)buf);
    message->popup();
    return;
  }

  long i;
  long num = copy_clients.getNum(); 
  for(i=0; i < num; i++){
    WSCbool overwrap = False;
    WSCbase* item = (WSCbase*)copy_clients[i];
    if (item == NULL){
      continue;
    }
    if (target == item){
      overwrap = True;
    }else{
      WSCbase* ptarget = target;
      while(1){
        if (ptarget == NULL){
          break;
        }
        if (ptarget == item){
          overwrap = True;
          break;
        }
        ptarget = ptarget->getParent();
      }
    }

    if (overwrap == True){
      WSCstring buffer;
      buffer << WSGFgettext("W4:WSSTR Can not paste the specified instance: ")
             << target->getInstanceName() << ","
             << item->getInstanceName()
             << WSGFgettext("X4:WSSTR ,\nbecause it overlap the source and the destination...");
      message->setPropertyV(WSNwidth,(WSCushort)500);
      message->setPropertyV(WSNlabelString,(char*)buffer);
      message->popup();
      continue;
    }
extern WSCbase* copy_recursive(WSCbase*,WSCbase*);
    WSCbase* cpobj = copy_recursive(item,target);
    if (cpobj != NULL){
      short x = cpobj->getProperty(WSNx);
      x += 10;
      short y = cpobj->getProperty(WSNy);
      y += 10;
      cpobj->setProperty(WSNx,x);
      cpobj->setProperty(WSNy,y);
    }
  }
  inspector->updateList();
}
#if 0// moved to advance/WSadcom.cpp
WSCbase* copy_recursive(WSCbase* item,WSCbase* target){
  WSCbase* newobj = WSCbase::getNewInstance(item->getClassName(),target,
         WSGFcreateName(target->getParentWindow()->getInstanceName(),
                        item->getClassName()));
  if (newobj != NULL){
    newobj->initialize();
    newobj->setVisible(False);

    WSGFexecCreateHandler(newobj);
    void* delete_handler = (void*)WSGFgetDeleteHandler();
    if (delete_handler != NULL){
      WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
      ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
      ac->setInternal(True);
      newobj->addProcedure(ac);
    }

    WSClistData* oplist = item->getProcedureList();
    long i;
    long num = oplist->getNum();
    for(i=0; i<num; i++){
      WSCprocedure* ac = (WSCprocedure*)(*oplist)[i];
      WSCprocedure* newac = new WSCprocedure(ac->getProcName(),
                                                    ac->getTrigger());

      newac->setFunction((void(*)(WSCbase*))ac->getProc(),ac->getFunctionName());
      newac->setUseFile(ac->getUseFile());
      newac->setInternal(ac->getInternal());
      newobj->addProcedure(newac);
    }
    WSClistData* property_list = item->getClassInformation()->getAllPropertyList();
    if (property_list == NULL){
      return newobj;
    }
    num = property_list->getNum();
    for(i=0; i<num; i++){
      WSCproperty* prop = (WSCproperty*)(*property_list)[i];
      if (!strcmp(prop->getPropObjName(),WSNname)){
        continue;
      }
      newobj->setProperty(prop->getPropObjName(),
        item->getProperty(prop->getPropObjName()));
    }

    newobj->setPropertyEditMode(True);
    newobj->setUserData(WS_EXT_VAR,item->getUserData(WS_EXT_VAR));
  }

  WSClistData children = item->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() != False){
      continue;
    }
    copy_recursive(child,newobj);
  }
  return newobj;

}
#endif
WSCstring _get_structure_inf_work(WSCbase* base,int level){
  WSCstring ret;
  WSClistData children = base->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<level;i++){
    ret << "  ";
  }
  ret << "+-" << base->getClassName()<< ":" << base->getInstanceName()<<"\n";

  WSClistData* prc_list = base->getProcedureList();
  long pnum = prc_list->getNum();
  long j;
  for(j=0; j< pnum; j++){
    WSCprocedure* ac = (WSCprocedure*)(*prc_list)[j];
    if (ac->getInternal() != False){
      continue;
    }
    ret << "  ";
    for(i=0; i<level;i++){
      ret << "  ";
    }
    WSCstring pname(ac->getProcName(),WS_EN_UTF8);
    long encoding = WSGFgetEncodingValue(pe->getProjectData("#ENCODING")); 
    ret << " [" << pname.getString(encoding) << "]:" << ac->getTrigger()<<":";
    if (ac->getUseFile() == False){
      ret << ac->getFunctionName()<<"\n";
    }else{
      long lang = pe->getLanguage();
      if (lang == WS_LANG_CPP){
        ret << ac->getFunctionName()<<".cpp\n";
      }else
      if (lang == WS_LANG_RUBY){
        ret << ac->getFunctionName()<<".rb\n";
      }else
      if (lang == WS_LANG_PYTHON){
        ret << ac->getFunctionName()<<".py\n";
      }else
      if (lang == WS_LANG_PERL){
        ret << ac->getFunctionName()<<".pl\n";
      }else
      if (lang == WS_LANG_JAVA){
        ret << ac->getFunctionName()<<".java\n";
      }
    }
  }

  for(i=0; i<num;i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() != False){
      continue;
    }
    ret << _get_structure_inf_work(child,level+1);
  }
  return ret;
}
WSCstring get_structure_inf(WSClistData* wlist){
  WSCstring ret;
  long num = wlist->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* base = (WSCbase*)(*wlist)[i];
    ret << _get_structure_inf_work(base,0);
  }
  return ret;
}

