//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#ifndef WS_EMBED
#include <x11/WSDunixExternal.h>
#include <stdio.h>
#include <WSClocaleSet.h>
#ifndef MacOS
#include <dlfcn.h>
#else //MacOS
#include <Carbon/Carbon.h>
#include <Strings.h>
//#include <CodeFragments.h>
//#include <Aliases.h>

#include <mach-o/dyld.h>
#define RTLD_LAZY 0

#include <WSClistData.h>
#include <WSDenv.h>

static void expand_list(char* fname, WSCstring* path_list, WSClistData* outlist) {
  if (path_list->getChars() <= 0) return;

  for (long i = 0; i < path_list->getWords(":"); i++) {
    WSCstring tmp = path_list->getWord(i, ":");
    if (tmp.getChars() > 0) {
      tmp << "/" << fname;
      WSCstring* path = new WSCstring(tmp);
      outlist->add((void*)path);
    }
  }
}

static void make_dl_path_list(char* fname, WSClistData* outlist) {
  if (fname[0] == '/') {
    outlist->add((void*)(new WSCstring(fname)));
    return;
  }

  static char* env_list[] = {
    "LD_LIBRARY_PATH",
    "DYLD_LIBRARY_PATH"
  };
  static char* env_fallback = "DYLD_FALLBACK_LIBRARY_PATH";

  WSCstring path_list;

  for (unsigned long i = 0; i < sizeof(env_list); i++) {
    path_list = WSGIappEnvironment()->getEnv(env_list[i]);
    expand_list(fname, &path_list, outlist);
  }

  path_list = WSGIappEnvironment()->getEnv(env_fallback);
  if (path_list.getChars() <= 0) {
    path_list = WSGIappEnvironment()->getPlaneString("$(HOME)/lib");
    path_list << ":" << "/usr/local/lib" << ":" << "/usr/lib";
  }
  expand_list(fname, &path_list, outlist);
  outlist->add((void*)(new WSCstring(fname)));

  return;
}
static void delete_items(WSClistData* list) {
  for (long i = 0; i < list->getNum(); i++) {
    delete (WSCstring*)list->getData(i);
  }
}

void* dlopen(char* fname,long){
  WSClistData list;
  make_dl_path_list(fname, &list);

  for (long i = 0; i < list.getNum(); i++) {
    NSObjectFileImage handle;
    WSCstring* path = (WSCstring*)list.getData(i);
    int result = NSCreateObjectFileImageFromFile(path->getString(), &handle);
    if (result == NSObjectFileImageSuccess) {
      NSLinkModule(handle,fname, NSLINKMODULE_OPTION_NONE);
      delete_items(&list);
      return handle;
    }
  }
  fprintf(stderr,"Failed to load file:%s\n", fname);
  delete_items(&list);
  return NULL;
};
void* dlsym(void* ptr,char* procn){
  WSCstring procn2("_");
  procn2 << procn;
  if(NSIsSymbolNameDefined(procn)) {
    printf("Failed to find symbol=%s\n",procn);
  }
  /* NSLookupAndBindSymbol require function name with "_" !! */
  NSSymbol sym = NSLookupAndBindSymbol(procn2.getString());
  void* ret = (void*)NSAddressOfSymbol(sym);
  return (void*)ret;
}
#endif //MacOS

WSMFclassInit(WSDunixExternal,WSDexternal);

WSDexternal* _unix_external_create(){
  return new WSDunixExternal;
}
void WSGFunixExternalInit(){
  WSDexternal::setCreateInstanceHandler((void*)_unix_external_create);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _unix_external_init {
  public: _unix_external_init(){
    WSGFunixExternalInit();
  };
};
_unix_external_init  _unix_external_init_execute;
#endif

WSDunixExternal::WSDunixExternal(){
  _dl_ptr = NULL;
}

WSDunixExternal::~WSDunixExternal(){
  if (_dl_ptr != NULL){
    close();
  }
}

long WSDunixExternal::open(char* name){
  _ptr = NULL;
  WSDexternal::setTempData(NULL); 

  _dll_name.setString(name);
  _dll_name.delHeadSpace();
  char* fn = _dll_name.getString(WSGIappLocaleSet()->getSystemLocaleEncoding())
;
#ifdef MacOS
  WSCstring tmp1;
  if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_UTF8){
extern char* utf8_to_macutf8(char*);
    char* fn2 = utf8_to_macutf8(
       _dll_name.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
    if (fn2 != NULL){
      tmp1.setString(fn2);
      delete fn2;
      fn = tmp1.getString();
    }
  }
#endif

  _dl_ptr = dlopen(fn,RTLD_LAZY);
  if (_dl_ptr != NULL){
    _ptr = WSDexternal::getTempData();
    return WS_NO_ERR;
  }
#ifndef MacOS
fprintf(stderr,"Error: WSDunixExternal::open  dll open error:%s\n",dlerror());
#endif //MacOS
  return WS_ERR;
}

long WSDunixExternal::close(){
  if (_dl_ptr != NULL){
#ifndef MacOS
    dlclose(_dl_ptr);
#endif //MacOS
    _dl_ptr = NULL;
    _ptr = NULL;
  }
  return WS_NO_ERR;
}

WSCstring* WSDunixExternal::getObjectSymbols(){
  if (_ptr != NULL){
    WSCstring* str = new WSCstring;
    char** sym = (char**) _ptr;
    long i=0;
    while(1){
      if (sym[i] == NULL){
        break;
      }
      str->addString(sym[i]);
      str->addString(" ");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
    }
    return str;
  }
  return NULL;
}
#endif //WS_EMBED
