//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <xunicode.h>
#include <WScom.h>
#include <x11/WSDxcodeConvert.h>
#include <WSDenv.h>

WSDcodeConvert* _code_convert_create_handler_(){
  return new WSDxcodeConvert;
}

int WSDxcodeConvert::codeConvert(char* str,int max,int codeto,const char* src,int len,int codefrom){
  return XUCodeConv(str,max,codeto,src,len,codefrom);
}
int WSDxcodeConvert::getSystemEncoding(){
extern int XUGetLocale();
  return XUGetLocale();
}
void WSDxcodeConvert::initialize(){
  XUInit();
extern char* XUGetLang();
  setSystemLocaleName(XUGetLang(),getSystemEncoding());
}
int WSDxcodeConvert::utf8CharLen(const char* str,int max){
  return XUutf8CharLen(str,max); 
}
int WSDxcodeConvert::encode(WSCushort* str,int max,const char* src,int len,int code){
  return XUEncode((XUChar*)str,max,src,len,code);
}
int WSDxcodeConvert::decode(char* str,int max,const WSCushort* src,int len,int code){
  return XUDecode(str,max,(XUChar*)src,len,code);
}

