//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <X11/Xlib.h>
#include <WScom.h>
#ifndef WS_EMBED
#include <WSDappDev.h>
#include <WSCbaseDialog.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCfontSet.h>
#include <WSDfont.h>
#include <WSCclassInformation.h>
#include <WSClocaleSet.h>
#include <x11/WSDxfontSelect.h>
#include <x11/WSDxappDev.h>

#define _WS_STR1 "B2:WSSTR dots"
#define _WS_STR2 "C2:WSSTR vendor"
#define _WS_STR3 "D2:WSSTR code"
#define _WS_STR4 "E2:WSSTR fmly"
#define _WS_STR5 "F2:WSSTR wght"
#define _WS_STR6 "G2:WSSTR slant"
#define _WS_STR7 "H2:WSSTR "
#define _WS_STR8 "I2:WSSTR AaBbCcDd\\n12345"

WSMFguiClassInitialize(WSDxfontSelect,WSCbaseDialog);

WSMFpropertyValueChange(WSDxfontSelect,WSNtitleBar,char,WS_ONLY_TITLE);

//static void _xfonts_init_(){
void _xfonts_init_(){
  WSCbase* fonteditor = new WSDxfontSelect(NULL,"font-editor");
  fonteditor->initialize();
  fonteditor->setPropertyV(WSNx,(short)400);
  fonteditor->setPropertyV(WSNy,(short)300);
  WSGFsetFontEditor(fonteditor);
}
#if 0
class _xfontselect_init_ {
  public:
    _xfontselect_init_(){
       WSGIappDev()->setInitHandler(_xfonts_init_);
    };
};
static _xfontselect_init_ _xfs_execute_;
#endif

long fsizes[] ={2,6,8,10,12,14,16,18,20,24,26,32,34,40,50,60,0};

WSDxfontSelect::WSDxfontSelect(WSCbase* base,char* objName):
WSCbaseDialog(base,objName){
  lb004 = NULL;
  opt000 = NULL;
  opt001 = NULL;
  opt002 = NULL;
  opt003 = NULL;
  opt004 = NULL;
  opt005 = NULL;
  opt006 = NULL;
//  _font_name = WSGFstrdup("14 jisx0201.1976 jisx0208.1983 * misc misc misc");
  _font_name = WSGFstrdup("14 * 0 0");
  _target_name = WSGFstrdup("");
  _rep = NULL;
  _font_no = 0;
  _title_bar = WS_ONLY_TITLE;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNfontName,char*,_font_name,WSSfontName);
    WSMFpropertyCreate(WSNtype,char*,_target_name,WSStype);
//    WSMFpropertyCreate(WSNreplyHandler,void*,_rep,WSSreplyHandler);
    WSMFpropertyCreate(WSNfont,WSCuchar,_font_no,WSSfont);

    WSMFpropertyValueChangeDef(WSDxfontSelect,WSNtitleBar,char);
    WSMFpropertyDelete(WSNpixmapStyle);
    WSMFpropertyVisibleOff(WSNwidth);
    WSMFpropertyVisibleOff(WSNheight);
    WSMFaddTrigger(3);
  WSMFpropertyCreateEnd
}
//WSMFproperty(WSDxfontSelect,WSNfontName,char*,_font_name,WSGFstrdup("14 jisx0201.1976 jisx0208.1983 * misc misc misc"));
WSMFproperty(WSDxfontSelect,WSNfontName,char*,_font_name,WSGFstrdup("14 * 0 0"));
void WSDxfontSelect::setWorkWSNfontName(char* data){
  WSCstring str(data);
  _size = atoi((char*)str.getWord(0));
  if (_target_name != NULL && _target_name[0] != 0){
    _ec = "iso8859";
    _kc = "*";
    _gc = "*";
    _ev = "*";
    _kv = "*";
    _gv = "*";
    _fmly = "*";
    _wght = "*";
    _slant = "*";
    updateList();
    return;
  }
//  if (strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
    //C
    _ec = "*";
    _kc = "*";
    _gc = "*";
    _ev = "*";
    _kv = "*";
    _gv = "*";
    _fmly = str.getWord(1);
    _wght = "*";
    _slant = "*";
//  }else{
//    //japanese
//    _ec = str.getWord(1);
//    _kc = str.getWord(2);
//    _gc = str.getWord(3);
//    _ev = str.getWord(4);
//    _kv = str.getWord(5);
//    _gv = str.getWord(6);
//  }

  updateList();
}

void WSDxfontSelect::getWorkWSNfontName(char** fn){
  if (_target_name != NULL && _target_name[0] != 0){
    WSCstring filename("$(WSDIR)/sys/data/fontdef.");
    filename << _target_name;
    WSCstring* str = WSGFreadTextFile(filename);
    if (str != NULL){
      str->delLineFeed();
      if (!strcmp(str->getString(),"")){
        return;
      }
      WSCstring tmp( WSGFltoa(_size) );
      str->replaceString("%d",tmp,1);
      delete _font_name;
      _font_name = WSGFstrdup(str->getString());
      delete str;
      *fn = _font_name;
      return;
    }
#if 0
    WSCstring str( WSGFltoa(_size) );
    str << " 60c6";
    delete _font_name;
    _font_name = WSGFstrdup((char*)str);
    *fn = _font_name;
#endif
  }
  WSCstring str( WSGFltoa(_size));
//  if (strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
    //C
    str << " " << _fmly << " ";
    if (!strcmp("*",(char*)_wght) || !strcmp("medium",_wght)){
      str << "0 ";
    }else{
      str << "1 ";
    }
    if (!strcmp("*",(char*)_slant) || !strcmp("r",_slant)){
      str << "0 ";
    }else{
      str << "1 ";
    }

//    str << " " << _ec << " " << _fmly << " " << _wght
//        << " " << _ev << " " << _slant << " " << "*"; 
//  }else{
//    //japanese
//    str << " " << _ec << " " << _kc << " " << _gc
//        << " " << _ev << " " << _kv << " " << _gv; 
//  }
  delete _font_name;
  _font_name = WSGFstrdup((char*)str);
  *fn = _font_name;
}
WSMFproperty(WSDxfontSelect,WSNtype,char*,_target_name,WSGFstrdup(""));
void WSDxfontSelect::setWorkWSNtype(char* data){}
void WSDxfontSelect::getWorkWSNtype(char** fn){}

//WSMFproperty(WSDxfontSelect,WSNreplyHandler,void*,_rep,NULL);
//void WSDxfontSelect::setWorkWSNreplyHandler(void*){ }
//void WSDxfontSelect::getWorkWSNreplyHandler(void**){ }

WSMFproperty(WSDxfontSelect,WSNfont,WSCuchar,_font_no,0);
void WSDxfontSelect::setWorkWSNfont(WSCuchar data){
  if (lb004 != NULL){
    lb004->setPropertyV(WSNfont,(WSCuchar)data);
  }
  WSDfont* font = WSGIappFontSet()->getFont((short)data);
  if (font != NULL){
    setWorkWSNfontName(font->getFontName());
    updateList();
  }
}
void WSDxfontSelect::getWorkWSNfont(WSCuchar* data){}


WSDxfontSelect::~WSDxfontSelect(){
  delAllProcedure();
  delete _font_name;
  delete _target_name;
}

long WSDxfontSelect::initialize(){
  WSGIappFontSet()->setDefaultFont(8);
  WSCbaseDialog::initialize();

  setUserData(WS_BASE_CLASS,(void*)this);
  setPropertyV(WSNwidth,(WSCushort)450);
  setPropertyV(WSNheight,(WSCushort)195);
  setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  setPropertyV(WSNbackColor,"gray80");
  setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  setPropertyV(WSNtitleBar,(char)2);

  xfonarea001 = new  WSCform(this,"xfonarea001");
  xfonarea001->initialize();
  xfonarea001->setInternalObject(True);
  xfonarea001->setUserData(WS_BASE_CLASS,(void*)this);
  xfonarea001->setPropertyV(WSNx,(short)1);
  xfonarea001->setPropertyV(WSNy,(short)5);
  xfonarea001->setPropertyV(WSNwidth,(WSCushort)448);
  xfonarea001->setPropertyV(WSNheight,(WSCushort)150);
  xfonarea001->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  xfonarea001->setPropertyV(WSNbackColor,"gray75");
  xfonarea001->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  xfonarea001->setVisible(True);

  WSCform* xfonarea003 = new  WSCform(xfonarea001,"xfonarea003");
  xfonarea003->initialize();
  xfonarea003->setInternalObject(True);
  xfonarea003->setUserData(WS_BASE_CLASS,(void*)this);
  xfonarea003->setPropertyV(WSNx,(short)5);
  xfonarea003->setPropertyV(WSNy,(short)5);
  xfonarea003->setPropertyV(WSNwidth,(WSCushort)200);
  xfonarea003->setPropertyV(WSNheight,(WSCushort)140);
  xfonarea003->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  xfonarea003->setPropertyV(WSNshadowType,(char)1);
  xfonarea003->setVisible(True);

  lb004 = new  WSCvlabel(xfonarea003,"lb004");
  lb004->initialize();
  lb004->setInternalObject(True);
  lb004->setUserData(WS_BASE_CLASS,(void*)this);
  lb004->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  lb004->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR8));
  lb004->setPropertyV(WSNx,(short)5);
  lb004->setPropertyV(WSNy,(short)5);
  lb004->setPropertyV(WSNwidth,(WSCushort)190);
  lb004->setPropertyV(WSNheight,(WSCushort)130);
  lb004->setVisible(True);

//printf("lb004=#%s#\n",WSGFgettext(_WS_STR8));
//WSCstring str( WSGFgettext(_WS_STR8));
//str.replaceString("\\n","\n",-1);
//printf("lb004=#%s#\n",str.getString());

  opt000 = new  WSCoption(xfonarea001,"opt000");
  opt000->initialize();
  opt000->setInternalObject(True);
  opt000->setUserData(WS_BASE_CLASS,(void*)this);
  opt000->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt000->setPropertyV(WSNbackColor,"gray80");
//  opt000->setPropertyV(WSNbottomShadowColor,"gray55");
  opt000->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt000->setPropertyV(WSNx,(short)285);
  opt000->setPropertyV(WSNy,(short)5);
  opt000->setPropertyV(WSNwidth,(WSCushort)150);
  opt000->setPropertyV(WSNheight,(WSCushort)20);
  WSCprocedure* op_opt000_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_opt000_0->setFunction(xfdVch,"xfdVch");
  opt000->addProcedure(op_opt000_0);
  opt000->setVisible(True);

  opt001 = new  WSCoption(xfonarea001,"opt001");
  opt001->initialize();
  opt001->setInternalObject(True);
  opt001->setUserData(WS_BASE_CLASS,(void*)this);
  opt001->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt001->setPropertyV(WSNbackColor,"gray80");
//  opt001->setPropertyV(WSNbottomShadowColor,"gray55");
  opt001->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt001->setPropertyV(WSNx,(short)285);
  opt001->setPropertyV(WSNy,(short)25);
  opt001->setPropertyV(WSNwidth,(WSCushort)150);
  opt001->setPropertyV(WSNheight,(WSCushort)20);
  WSCprocedure* op_opt001_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_opt001_0->setFunction(xfdVch,"xfdVch");
  opt001->addProcedure(op_opt001_0);
//  opt001->setVisible(True);

  opt002 = new  WSCoption(xfonarea001,"opt002");
  opt002->initialize();
  opt002->setInternalObject(True);
  opt002->setUserData(WS_BASE_CLASS,(void*)this);
  opt002->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt002->setPropertyV(WSNbackColor,"gray80");
//  opt002->setPropertyV(WSNbottomShadowColor,"gray55");
  opt002->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt002->setPropertyV(WSNx,(short)285);
  opt002->setPropertyV(WSNy,(short)45);
  opt002->setPropertyV(WSNwidth,(WSCushort)150);
  opt002->setPropertyV(WSNheight,(WSCushort)20);
  WSCprocedure* op_opt002_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_opt002_0->setFunction(xfdVch,"xfdVch");
  opt002->addProcedure(op_opt002_0);
//  opt002->setVisible(True);

  opt003 = new  WSCoption(xfonarea001,"opt003");
  opt003->initialize();
  opt003->setInternalObject(True);
  opt003->setUserData(WS_BASE_CLASS,(void*)this);
  opt003->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt003->setPropertyV(WSNbackColor,"gray80");
//  opt003->setPropertyV(WSNbottomShadowColor,"gray55");
  opt003->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt003->setPropertyV(WSNx,(short)285);
//  opt003->setPropertyV(WSNy,(short)65);
  opt003->setPropertyV(WSNy,(short)25);
  opt003->setPropertyV(WSNwidth,(WSCushort)150);
  opt003->setPropertyV(WSNheight,(WSCushort)20);
  WSCprocedure* op_opt003_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_opt003_0->setFunction(xfdVch,"xfdVch");
  opt003->addProcedure(op_opt003_0);
  opt003->setVisible(True);

  opt004 = new  WSCoption(xfonarea001,"opt004");
  opt004->initialize();
  opt004->setInternalObject(True);
  opt004->setUserData(WS_BASE_CLASS,(void*)this);
  opt004->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt004->setPropertyV(WSNbackColor,"gray80");
//  opt004->setPropertyV(WSNbottomShadowColor,"gray55");
  opt004->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt004->setPropertyV(WSNx,(short)285);
  opt004->setPropertyV(WSNy,(short)45);
//  opt004->setPropertyV(WSNy,(short)85);
  opt004->setPropertyV(WSNwidth,(WSCushort)150);
  opt004->setPropertyV(WSNheight,(WSCushort)20);
  WSCprocedure* op_opt004_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_opt004_0->setFunction(xfdVch,"xfdVch");
  opt004->addProcedure(op_opt004_0);
  opt004->setVisible(True);

  opt005 = new  WSCoption(xfonarea001,"opt005");
  opt005->initialize();
  opt005->setInternalObject(True);
  opt005->setUserData(WS_BASE_CLASS,(void*)this);
  opt005->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt005->setPropertyV(WSNbackColor,"gray80");
//  opt005->setPropertyV(WSNbottomShadowColor,"gray55");
  opt005->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt005->setPropertyV(WSNx,(short)285);
  opt005->setPropertyV(WSNy,(short)65);
//  opt005->setPropertyV(WSNy,(short)105);
  opt005->setPropertyV(WSNwidth,(WSCushort)150);
  opt005->setPropertyV(WSNheight,(WSCushort)20);
  WSCprocedure* op_opt005_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_opt005_0->setFunction(xfdVch,"xfdVch");
  opt005->addProcedure(op_opt005_0);
  opt005->setVisible(True);

  opt006 = new  WSCoption(xfonarea001,"opt006");
  opt006->initialize();
  opt006->setInternalObject(True);
  opt006->setUserData(WS_BASE_CLASS,(void*)this);
  opt006->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  opt006->setPropertyV(WSNbackColor,"gray80");
//  opt006->setPropertyV(WSNbottomShadowColor,"gray55");
  opt006->setPropertyV(WSNalignmentH,(WSCuchar)0);
  opt006->setPropertyV(WSNx,(short)285);
  opt006->setPropertyV(WSNy,(short)125);
  opt006->setPropertyV(WSNwidth,(WSCushort)150);
  opt006->setPropertyV(WSNheight,(WSCushort)20);
//  WSCprocedure* op_opt006_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
//  op_opt006_0->setFunction(xfdVch,"xfdVch");
//  opt006->addProcedure(op_opt006_0);

//  if (!strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
//    //japanese
//    opt006->setVisible(True);
//  }


  xfonvtex014 = new  WSCvlabel(xfonarea001,"xfonvtex014");
  xfonvtex014->initialize();
  xfonvtex014->setInternalObject(True);
  xfonvtex014->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex014->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR1));
  xfonvtex014->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex014->setPropertyV(WSNx,(short)210);
  xfonvtex014->setPropertyV(WSNy,(short)5);
  xfonvtex014->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex014->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex014->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);
  xfonvtex014->setVisible(True);

#if 0
  WSCvlabel* xfonvtex015 = new  WSCvlabel(xfonarea001,"xfonvtex015");
  xfonvtex015->initialize();
  xfonvtex015->setInternalObject(True);
  xfonvtex015->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex015->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR2));
  xfonvtex015->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex015->setPropertyV(WSNx,(short)210);
  xfonvtex015->setPropertyV(WSNy,(short)25);
  xfonvtex015->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex015->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex015->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);
  xfonvtex015->setVisible(True);
#endif
#if 0
  WSCvlabel* xfonvtex016 = new  WSCvlabel(xfonarea001,"xfonvtex016");
  xfonvtex016->initialize();
  xfonvtex016->setInternalObject(True);
  xfonvtex016->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex016->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR3));
  xfonvtex016->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex016->setPropertyV(WSNx,(short)210);
  xfonvtex016->setPropertyV(WSNy,(short)45);
  xfonvtex016->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex016->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex016->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);
  xfonvtex016->setVisible(True);
#endif
  xfonvtex017 = new  WSCvlabel(xfonarea001,"xfonvtex017");
  xfonvtex017->initialize();
  xfonvtex017->setInternalObject(True);
  xfonvtex017->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex017->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR4));
  xfonvtex017->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex017->setPropertyV(WSNx,(short)210);
//  xfonvtex017->setPropertyV(WSNy,(short)65);
  xfonvtex017->setPropertyV(WSNy,(short)25);
  xfonvtex017->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex017->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex017->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);
  xfonvtex017->setVisible(True);

  xfonvtex018 = new  WSCvlabel(xfonarea001,"xfonvtex018");
  xfonvtex018->initialize();
  xfonvtex018->setInternalObject(True);
  xfonvtex018->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex018->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR5));
  xfonvtex018->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex018->setPropertyV(WSNx,(short)210);
  xfonvtex018->setPropertyV(WSNy,(short)45);
//  xfonvtex018->setPropertyV(WSNy,(short)85);
  xfonvtex018->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex018->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex018->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);
  xfonvtex018->setVisible(True);



  xfonvtex019 = new  WSCvlabel(xfonarea001,"xfonvtex019");
  xfonvtex019->initialize();
  xfonvtex019->setInternalObject(True);
  xfonvtex019->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex019->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR6));
  xfonvtex019->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex019->setPropertyV(WSNx,(short)210);
  xfonvtex019->setPropertyV(WSNy,(short)65);
//  xfonvtex019->setPropertyV(WSNy,(short)105);
  xfonvtex019->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex019->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex019->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);
  xfonvtex019->setVisible(True);


  WSCvlabel* xfonvtex020 = new  WSCvlabel(xfonarea001,"xfonvtex020");
  xfonvtex020->initialize();
  xfonvtex020->setInternalObject(True);
  xfonvtex020->setUserData(WS_BASE_CLASS,(void*)this);
  xfonvtex020->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR7));
  xfonvtex020->setPropertyV(WSNalignmentH,(WSCuchar)2);
  xfonvtex020->setPropertyV(WSNx,(short)210);
  xfonvtex020->setPropertyV(WSNy,(short)125);
  xfonvtex020->setPropertyV(WSNwidth,(WSCushort)70);
  xfonvtex020->setPropertyV(WSNheight,(WSCushort)20);
  xfonvtex020->setPropertyV(WSNshadowType,(signed char)WS_SHADOW_TRANS);

//  if (!strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
//    //japanese
//    xfonvtex020->setVisible(True);
//  }


  WSGIappFontSet()->setDefaultFont(0);
  return WS_NO_ERR;
}
#if 0
void WSDxfontSelect::xfdSet(WSCbase* object){
  WSDxfontSelect* base = (WSDxfontSelect*)object->getUserData(WS_BASE_CLASS);
  void (*hd)(WSCbase*,void*) = (void(*)(WSCbase*,void*))base->_rep;
  void* data;
  base->getPropertyV(WSNuserValue,(long*)&data); 
  if (hd != NULL){
    hd(base,data);
  }
  base->setVisible(False);
}
#endif
void WSDxfontSelect::xfdVch(WSCbase* object){
  WSDxfontSelect* base = (WSDxfontSelect*)object->getUserData(WS_BASE_CLASS);
  long val;

  base->opt000->getPropertyV(WSNvalue,&val);
  base->_size = val;

  base->opt001->getPropertyV(WSNvalue,&val);
  long num = base->_ev_name_list.getNum();
  if (val < num){
    char* str = (char*)base->_ev_name_list[val];
    base->_ev = str;
  }

  base->opt003->getPropertyV(WSNvalue,&val);
  long japanese = False;
//  if (strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
    //C
    num = base->_fmly_name_list.getNum();
//  }else{
//    //japanese
//    japanese = True;
//    num = base->_kv_name_list.getNum();
//  }
  if (val < num){
    if (japanese == False){
      //C
      char* str = (char*)base->_fmly_name_list[val];
      base->_fmly = str;
    }else{
      char* str = (char*)base->_kv_name_list[val];
      base->_kv = str;
    }
  }

  base->opt005->getPropertyV(WSNvalue,&val);
  if (japanese == False){
    //C
    num = base->_slant_name_list.getNum();
  }else{
    //japanese
    num = base->_gv_name_list.getNum();
  }
  if (val < num){
    if (japanese == False){
      //C
      char* str = (char*)base->_slant_name_list[val];
      base->_slant = str;
    }else{
      //Japanese
      char* str = (char*)base->_gv_name_list[val];
      base->_gv = str;
    }
  }

  base->opt002->getPropertyV(WSNvalue,&val);
  num = base->_ec_name_list.getNum();
  if (val < num){
    char* str = (char*)base->_ec_name_list[val];
    base->_ec = str;
  }

  base->opt004->getPropertyV(WSNvalue,&val);
  if (japanese == False){
    //C
    num = base->_wght_name_list.getNum();
  }else{
    num = base->_kc_name_list.getNum();
  }
  if (val < num){
    if (japanese == False){
      //C
      char* str = (char*)base->_wght_name_list[val];
      base->_wght = str;
    }else{
      //Japanese
      char* str = (char*)base->_kc_name_list[val];
      base->_kc = str;
    }
  }

  base->opt006->getPropertyV(WSNvalue,&val);
  num = base->_gc_name_list.getNum();
  if (val < num){
    char* str = (char*)base->_gc_name_list[val];
    base->_gc = str;
  }

  base->updateList();

  WSCstring buf( WSGFltoa(base->_size));
#if 0
  if (japanese == False){
    //C
    buf << " " << base->_ec << " " << base->_fmly << " " << base->_wght
        << " " << base->_ev << " " << base->_slant << " " << "*"; 
  }else{
    //Japanese
    buf << " " << base->_ec << " " << base->_kc << " " << base->_gc
        << " " << base->_ev << " " << base->_kv << " " << base->_gv; 
  }
#endif
  buf << " " << base->_fmly << " ";
  if (!strcmp("*",(char*)base->_wght) || !strcmp("medium",(char*)base->_wght)){
    buf << "0 ";
  }else{
    buf << "1 ";
  }
  if (!strcmp("*",(char*)base->_slant) || !strcmp("r",(char*)base->_slant)){
    buf << "0 ";
  }else{
    buf << "1 ";
  }


  WSCuchar fontn;
  base->getPropertyV(WSNfont,&fontn);
//printf("WSDxfontSelect::xfdVch fno=%d %s\n",fontn,(char*)buf);
  WSDfont* font = WSGIappFontSet()->getFont((short)fontn);
  if (font != NULL){
    font->setSrc((char*)buf);
    if (base->_target_name != NULL && base->_target_name[0] != 0){
      WSCstring str( WSGFltoa(base->_size) );
      str << " 60c6";
      font->setFontName((char*)str);
    }
  }
  if (base->lb004 != NULL){
    base->lb004->setPropertyV(WSNfont,(WSCuchar)fontn);
    base->lb004->redraw();
  }
}
#if 0
void WSDxfontSelect::xfdEnd(WSCbase* object){
  WSDxfontSelect* base = (WSDxfontSelect*)object->getUserData(WS_BASE_CLASS);
  base->setVisible(False);
}
#endif

void WSDxfontSelect::addEvName(char* data){
  _add_name(data,&_ev_name_list);
}
void WSDxfontSelect::addEcName(char* data){
  _add_name(data,&_ec_name_list);
}

void WSDxfontSelect::addKvName(char* data){
  _add_name(data,&_kv_name_list);
}
void WSDxfontSelect::addKcName(char* data){
  _add_name(data,&_kc_name_list);
}


void WSDxfontSelect::addGvName(char* data){
  _add_name(data,&_gv_name_list);
}
void WSDxfontSelect::addGcName(char* data){
  _add_name(data,&_gc_name_list);
}

void WSDxfontSelect::addFmlyName(char* data){
  _add_name(data,&_fmly_name_list);
}
void WSDxfontSelect::addWghtName(char* data){
  _add_name(data,&_wght_name_list);
}
void WSDxfontSelect::addSlantName(char* data){
  _add_name(data,&_slant_name_list);
}

void WSDxfontSelect::_add_name(char* data,WSClistData* list){
  long num = list->getNum();
  long i;
  for(i=0; i<num; i++){
    char* item = (char*)(*list)[i];
    if (!strcmp(item,data)){
      return;
    }
  }
  list->add((void*)WSGFstrdup(data));
}

void WSDxfontSelect::onVisibleChange(WSCbool fl){
  WSCbaseDialog::onVisibleChange(fl);
  if (fl != False){
    lb004->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR8));
    xfonvtex014->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR1));
    xfonvtex017->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR4));
    xfonvtex018->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR5));
    xfonvtex019->setPropertyV(WSNlabelString,WSGFgettext(_WS_STR6));
  }
  updateList();
}

long WSDxfontSelect::execEventProc(long ev,void* data){
  if (ev == WSEV_ACTIVATE){
    onActivate();
  }
  return WSCbase::execEventProc(ev,data);
}


void WSDxfontSelect::updateList(){
  WSClistData en_size_list;
  _size_list.clear();
  long escal = 0;  
  long kscal = 0;  
  long gscal = 0;  

  long i;
  long num = _ev_name_list.getNum();
  for(i=0; i<num; i++){
    char* str = (char*)_ev_name_list[i];
    delete str;
  }
  _ev_name_list.clear();
  _ev_name_list.add((void*)WSGFstrdup("*"));
 
  num = _kv_name_list.getNum();
  for(i=0; i<num; i++){
    char* str = (char*)_kv_name_list[i];
    delete str;
  }
  _kv_name_list.clear();
  _kv_name_list.add((void*)WSGFstrdup("*"));

  num = _gv_name_list.getNum();
  for(i=0; i<num; i++){
    char* str = (char*)_gv_name_list[i];
    delete str;
  }
  _gv_name_list.clear();
  _gv_name_list.add((void*)WSGFstrdup("*"));

  num = _ec_name_list.getNum();
  for(i=0; i<num; i++){
    char* str = (char*)_ec_name_list[i];
    delete str;
  }
  _ec_name_list.clear();
  _ec_name_list.add((void*)WSGFstrdup("*"));

  num = _kc_name_list.getNum();
  for(i=0; i<num; i++){
    char* str = (char*)_kc_name_list[i];
    delete str;
  }
  _kc_name_list.clear();
  _kc_name_list.add((void*)WSGFstrdup("*"));

  num = _gc_name_list.getNum();
  for(i=0; i<num; i++){
    char* str = (char*)_gc_name_list[i];
    delete str;
  }
  _gc_name_list.clear();
  _gc_name_list.add((void*)WSGFstrdup("*"));

//  if (strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
    //C
    num = _fmly_name_list.getNum();
    for(i=0; i<num; i++){
      char* str = (char*)_fmly_name_list[i];
      delete str;
    }
    _fmly_name_list.clear();
    _fmly_name_list.add((void*)WSGFstrdup("*"));

    num = _wght_name_list.getNum();
    for(i=0; i<num; i++){
      char* str = (char*)_wght_name_list[i];
      delete str;
    }
    _wght_name_list.clear();
    _wght_name_list.add((void*)WSGFstrdup("*"));

    num = _slant_name_list.getNum();
    for(i=0; i<num; i++){
      char* str = (char*)_slant_name_list[i];
      delete str;
    }
    _slant_name_list.clear();
    _slant_name_list.add((void*)WSGFstrdup("*"));
//  }

  _size_list.add((void*)0);
  i=0;
  while(fsizes[i] != 0){
    _size_list.add((void*)fsizes[i]);
    i++;
  }

  WSCstring buf("-");
  buf << _ev << "-*-*-*-*-*-" << WSGFltoa(_size) << "-*-*-*-*-*-" << _ec << "-*";
  WSDxappDev* app = WSGIxwinAppDev();
  Display* disp = app->display();
  int num_fonts;
  char** fonts = XListFonts(disp,(char*)buf,200,&num_fonts);
  long japanese = False;
//  if (!strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
//    japanese = True;
//  }
  if (num_fonts > 0){
    long i;
    for(i=0; i<num_fonts; i++){
      WSCstring tmp(fonts[i]);
      WSCstring vnd = tmp.getWord(1,"-");
      addEvName(vnd.getString());
      if (japanese == False){
        WSCstring fmly = tmp.getWord(2,"-");
        addFmlyName(fmly.getString());
        WSCstring wght = tmp.getWord(3,"-");
        addWghtName(wght.getString());
        WSCstring slant = tmp.getWord(4,"-");
        addSlantName(slant.getString());
      }
      WSCstring code = tmp.getWord(13,"-");
      addEcName(code.getString());
    }
    XFreeFontNames(fonts);
  }
  buf = "-";
  buf << _ev << "-*-*-*-*-*-*-*-*-*-*-*-" << _ec << "-*";
  fonts = XListFonts(disp,(char*)buf,200,&num_fonts);
  if (num_fonts > 0){
    long i;
    for(i=0; i<num_fonts; i++){
      WSCstring tmp(fonts[i]);
      WSCstring sz = tmp.getWord(7,"-");
      if (0 == atoi(sz.getString())){
        escal = 1;
      } 
      long num = en_size_list.getNum();
      long i;
      if (num == 0){
        en_size_list.add((void*)atoi(sz.getString()));
      }else{
        for(i=0; i<num; i++){
          long s =(long)en_size_list[i];
          if (s == atoi(sz.getString())){
            break;
          }
          if (i+1 == num){
            en_size_list.add((void*)atoi(sz.getString()));
          }
        }
      }
    }
    XFreeFontNames(fonts);
  }
  buf = "-";
  buf << _kv << "-*-*-*-*-*-" << WSGFltoa(_size) << "-*-*-*-*-*-" << _kc << "-*";
  app = WSGIxwinAppDev();
  fonts = XListFonts(disp,buf,200,&num_fonts);
  if (num_fonts > 0){
    long i;
    for(i=0; i<num_fonts; i++){
      WSCstring tmp(fonts[i]);
      WSCstring vnd = tmp.getWord(1,"-");
      addKvName(vnd.getString());
      WSCstring code = tmp.getWord(13,"-");
      addKcName(code.getString());
    }
    XFreeFontNames(fonts);
  }

  buf = "-";
  buf << _kv << "-*-*-*-*-*-*-*-*-*-*-*-" << _kc << "-*";
  fonts = XListFonts(disp,buf,200,&num_fonts);
  if (num_fonts > 0){
    WSClistData tmpl;
    long i;
    for(i=0; i<num_fonts; i++){
      WSCstring tmp(fonts[i]);
      WSCstring sz = tmp.getWord(7,"-");
      if (0 == atoi(sz.getString())){
        kscal = 1;
      } 
      long num = en_size_list.getNum();
      long i;
      for(i=0; i<num; i++){
        long s =(long)en_size_list[i];
        if (s == atoi(sz.getString())){
          long tnum = tmpl.getNum();
          WSCbool fl = False;
          long j;
          for(j=0; j < tnum; j++){
            long item = (long)tmpl[i];
            if (item == s){
              fl = True;
              break;
            }
          }
          if (fl == False){
            tmpl.add((void*)s);
          }
        }
      }
    }
    XFreeFontNames(fonts);
    en_size_list.clear();
    num = tmpl.getNum();
    for(i=0; i<num; i++){
      en_size_list.add(tmpl[i]);
    }
  }

  buf = "-";
  buf << _gv << "-*-*-*-*-*-" << WSGFltoa(_size) << "-*-*-*-*-*-" << _gc << "-*";
  app = WSGIxwinAppDev();
  fonts = XListFonts(disp,buf,200,&num_fonts);
  if (num_fonts > 0){
    long i;
    for(i=0; i<num_fonts; i++){
      WSCstring tmp(fonts[i]);
      WSCstring vnd = tmp.getWord(1,"-");
      addGvName(vnd.getString());
      WSCstring code = tmp.getWord(13,"-");
      addGcName(code.getString());
    }
    XFreeFontNames(fonts);
  }
  buf = "-";
  buf << _gv << "-*-*-*-*-*-*-*-*-*-*-*-" << _gc << "-*";
  fonts = XListFonts(disp,buf,200,&num_fonts);
  if (num_fonts > 0){
    WSClistData tmpl;
    long i;
    for(i=0; i<num_fonts; i++){
      WSCstring tmp(fonts[i]);
      WSCstring sz = tmp.getWord(7,"-");
      if (0 == atoi(sz.getString())){
        gscal = 1;
      } 
      long num = en_size_list.getNum();
      long i;
      for(i=0; i<num; i++){
        long s =(long)en_size_list[i];
        if (s == atoi(sz.getString())){
          long tnum = tmpl.getNum();
          WSCbool fl = False;
          long j;
          for(j=0; j < tnum; j++){
            long item = (long)tmpl[i];
            if (item == s){
              fl = True;
              break;
            }
          }
          if (fl == False){
            tmpl.add((void*)s);
          }
        }
      }
    }
    XFreeFontNames(fonts);
    en_size_list.clear();
    num = tmpl.getNum();
    for(i=0; i<num; i++){
      en_size_list.add(tmpl[i]);
    }
  }

  WSCstring opt_buf(""); 
  num = _size_list.getNum();
  long select_num = 0;
  for(i=0; i<num; i++){
    long item = (long)_size_list[i];
    opt_buf << WSGFltoa(item) << ":" << WSGFltoa(item) << ":";
    if (item == _size){
      select_num = _size;
    }
    if ( i+1 != num ){
      opt_buf << ",";
    }
  }

  if (opt000 != NULL){
    opt000->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt000->setPropertyV(WSNvalue,select_num);
    num = _size_list.getNum();
    for(i=0; i<num; i++){
      if (escal == kscal == gscal == 1){
        opt000->setItemSensitive(i,True);
      }else{
        opt000->setItemSensitive(i,False);
      }
    }
    num = en_size_list.getNum();
    for(i=0; i<num; i++){
      opt000->setSelectValue((long)en_size_list[i],True);
    }
  }

  opt_buf = "";
  num = _ev_name_list.getNum();
  select_num = 0;
  for(i=0; i<num; i++){
    char* item = (char*)_ev_name_list[i];
    opt_buf << item << ":" << WSGFltoa(i) << ":";
    if (!strcmp(item,_ev.getString())){
      select_num = i;
    }
    if ( i+1 != num ){
      opt_buf << ",";
    }
  }

  if (opt001 != NULL){
    opt001->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt001->setPropertyV(WSNvalue,select_num);
  }

  opt_buf = "";
  if (japanese == False){
    num = _fmly_name_list.getNum();
    select_num = 0;
    for(i=0; i<num; i++){
      char* item = (char*)_fmly_name_list[i];
      opt_buf << item << ":" << WSGFltoa(i) << ":";
      if (!strcmp(item,_fmly.getString())){
        select_num = i;
      }
      if ( i+1 != num ){
        opt_buf << ",";
      }
    }
  }else{
    num = _kv_name_list.getNum();
    select_num = 0;
    for(i=0; i<num; i++){
      char* item = (char*)_kv_name_list[i];
      opt_buf << item << ":" << WSGFltoa(i) << ":";
      if (!strcmp(item,_kv.getString())){
        select_num = i;
      }
      if ( i+1 != num ){
        opt_buf << ",";
      }
    }
  }
  if (opt003 != NULL){
    opt003->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt003->setPropertyV(WSNvalue,select_num);
  }

  opt_buf = "";
  if (japanese == False){
    num = _slant_name_list.getNum();
    select_num = 0;
    for(i=0; i<num; i++){
      char* item = (char*)_slant_name_list[i];
      opt_buf << item << ":" << WSGFltoa(i) << ":";
      if (!strcmp(item,_slant.getString())){
        select_num = i;
      }
      if ( i+1 != num ){
        opt_buf << ",";
      }
    }
  }else{
    num = _gv_name_list.getNum();
    select_num = 0;
    for(i=0; i<num; i++){
      char* item = (char*)_gv_name_list[i];
      opt_buf << item << ":" << WSGFltoa(i) << ":";
      if (!strcmp(item,_gv.getString())){
        select_num = i;
      }
      if ( i+1 != num ){
        opt_buf << ",";
      }
    }
  }

  if (opt005 != NULL){
    opt005->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt005->setPropertyV(WSNvalue,select_num);
  }

  opt_buf = "";
  num = _ec_name_list.getNum();
  select_num = 0;
  for(i=0; i<num; i++){
    char* item = (char*)_ec_name_list[i];
    opt_buf << item << ":" << WSGFltoa(i) << ":";
    if (!strcmp(item,_ec.getString())){
      select_num = i;
    }
    if ( i+1 != num ){
      opt_buf << ",";
    }
  }
  if (opt002 != NULL){
    opt002->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt002->setPropertyV(WSNvalue,select_num);
  }

  opt_buf = "";
  if (japanese == False){
    num = _wght_name_list.getNum();
    select_num = 0;
    for(i=0; i<num; i++){
      char* item = (char*)_wght_name_list[i];
      opt_buf << item << ":" << WSGFltoa(i) << ":";
      if (!strcmp(item,_wght.getString())){
        select_num = i;
      }
      if ( i+1 != num ){
        opt_buf << ",";
      }
    }
  }else{
    num = _kc_name_list.getNum();
    select_num = 0;
    for(i=0; i<num; i++){
      char* item = (char*)_kc_name_list[i];
      opt_buf << item << ":" << WSGFltoa(i) << ":";
      if (!strcmp(item,_kc.getString())){
        select_num = i;
      }
      if ( i+1 != num ){
        opt_buf << ",";
      }
    }
  }

  if (opt004 != NULL){
    opt004->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt004->setPropertyV(WSNvalue,select_num);
  }

  opt_buf = "";
  num = _gc_name_list.getNum();
  select_num = 0;
  for(i=0; i<num; i++){
    char* item = (char*)_gc_name_list[i];
    opt_buf << item << ":" << WSGFltoa(i) << ":";
    if (!strcmp(item,_gc.getString())){
      select_num = i;
    }
    if ( i+1 != num ){
      opt_buf << ",";
    }
  }
  if (opt006 != NULL){
    opt006->setPropertyV(WSNmenuItems,(char*)opt_buf);
    opt006->setPropertyV(WSNvalue,select_num);
  }
}
void WSDxfontSelect::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
void WSDxfontSelect::onResize(WSCrect* area){
  WSCbaseDialog::onResize(area);
  if (area->width > 2){
    xfonarea001->setProperty(WSNwidth,(area->width -2));
  }else{
    xfonarea001->setProperty(WSNwidth,1);
  }
  if (area->height > 45){
    xfonarea001->setProperty(WSNheight,area->height -45);
  }else{
    xfonarea001->setProperty(WSNheight,1);
  }
}
#endif
