#if 0
//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
#endif
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <formP.h>
#include <stdio.h>

static Boolean SetValues();
static XtGeometryResult GeometryManager();
static XtGeometryResult PreferredGeometry();
static void ClassInit();
static void ClassPartInit();
static void Init();
static void Resize();
static void ChangeManaged();

FormClassRec formClassRec = {
  { /* core_class fields */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "Form",
    /* widget_size        */    sizeof(FormRec),
    /* class_initialize   */    ClassInit,
    /* class_part_init    */    ClassPartInit,
    /* class_inited       */    FALSE,
    /* initialize         */    Init,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    NULL,
    /* num_resources      */    0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	PreferredGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },
  { /* composite_class fields */
    /* geometry_manager   */   GeometryManager,
    /* change_managed     */   ChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* extension          */   NULL
  }
};

WidgetClass formWidgetClass = (WidgetClass)&formClassRec;

static void ClassInit(){
}

static void ClassPartInit(Widget class){
}

/* ARGSUSED */
static void Init(Widget request, Widget new, ArgList  args,
                     Cardinal*  num_args){
}

static void Resize(Widget w){
}

/* ARGSUSED */
static XtGeometryResult GeometryManager(Widget w, XtWidgetGeometry* request,
                             XtWidgetGeometry* reply){
/*	return XtGeometryYes;*/
  return XtGeometryNo;
}


/* ARGSUSED */
static Boolean SetValues(Widget current, Widget request,
                  Widget new, ArgList args, Cardinal* num_args){
  long i;
  long fl = 0;
  for(i=0; i<*num_args;i++){
    if (!strcmp(args[i].name,"x")){
	  current->core.x = args[i].value;
	  fl = 1;
	  break;
	}else if (!strcmp(args[i].name,"y")){
/*printf("y=%d\n",args[i].value);*/
	  current->core.y = args[i].value;
	  fl = 1;
	  break;
	}else if (!strcmp(args[i].name,"width")){
	  current->core.width = args[i].value;
	  fl = 1;
	  break;
	}else if (!strcmp(args[i].name,"height")){
	  current->core.height = args[i].value;
	  fl = 1;
	  break;
	}
  }
  if (fl == 1){
/*printf("ResizeWindow. %d,%d,%d,%d   0x%x\n", current->core.x,current->core.y, current->core.width,current->core.height,XtWindow(current));*/
    if (XtWindow(current) != 0){
      XMoveResizeWindow(XtDisplay(current),XtWindow(current),
           current->core.x,current->core.y,
           current->core.width,current->core.height);
    }
    return( False );
  }
  return( True );
}

static void ChangeManaged(Widget w){
}


static XtGeometryResult PreferredGeometry(Widget widget,
          XtWidgetGeometry* request, XtWidgetGeometry* reply ){
  return XtGeometryYes;
}

