//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDSERIALIZE_H
#define WSDSERIALIZE_H

#include <WSdrDef.h>
#include <WSCroot.h>
#include <WSCstring.h>
#include <WSClistData.h>

class WSCserializeData;

class WSDserialize :public WSCroot{

protected:
  WSCstring _field;
  WSCstring _path;
  WSClistData _data_list;
  WSCserializeData* _current_data;
  unsigned _need_save:1;
  unsigned _transact:1;
  unsigned _use_socket:1;

  long _write_data(WSCserializeData* dt, char* type, void* data, long items);
  long _write_sub_class(WSCserializeData*,char* type,void* data, long items); 

  long _read_data(WSCserializeData* dt, char* type, void* data, long items);
  long _read_sub_class( WSCserializeData*,char* type,void* data, long items); 

  long _save(WSClistData*,  char* type, char* name, void* ptr);
  long _load(WSCserializeData*,WSClistData*,char* type,char* name,void* ptr);
  long _load_alloc(WSCserializeData*,WSClistData*,char* type,char* name,
          void** ptr, void* cdata);
  long _search_instance(WSClistData*,char* type,char mode,char*** otype,
          char*** onames,long* num);
public:
  virtual long _open(char* name,long mode)  = 0;
  virtual long _close() = 0;
  virtual long _read(void*,long len)  = 0;
  virtual long _write(void*,long len) = 0;
  virtual long _eof() = 0;
  virtual long _seek(long addr) = 0;
  virtual long _seek_set() = 0;
  virtual long _seek_end() = 0;
  virtual long _size() = 0;
  virtual long _tell() = 0;

  WSDserialize();
  virtual ~WSDserialize();
  long size(char* type, char* name);
  long search(char* type, long mode, char*** data,long* num);

  long save(char* type, char* name, void* data);
  long load(char* type, char* name, void* ptr);
  long loadAlloc(char* type, char* name, void** ptr,void* cdata);
  //must delete type,delete names (if num != 0 )
  long searchInstance(char* type,char mode,char*** otype,char*** onames,long* num);

  long saveData(char* type, char* name, void* data);
  long loadData(char* type, char* name, void* ptr);
  long loadAllocData(char* type, char* name, void** ptr,void* cdata);

  //must delete type,delete names (if num != 0 )
  long searchInstanceData(char* type,char mode,char*** otype,char*** onames,long* num);

  virtual WSCbool type(char* ) = 0;
  virtual WSDserialize* createSerialize() = 0;

  virtual long beginTransaction(char* field);
  virtual long endTransaction();
  WSCbool underTransaction();
  void    setUnderTransaction(WSCbool);
  char*   getPath();
  void    setPath(char*);

  WSMFclassDef(WSDserialize,WSCroot);
};
#endif
