//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall 
// not be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from  
// Toshikaz Hirabayashi.


#ifndef WSDWINAPPDEV_H
#define WSDWINAPPDEV_H

#include <windows.h>
#include <WSDappDev.h>
class WSDwinformDev;

class WSDwinAppDev  :public WSDappDev{

 protected:
  HINSTANCE _hinst;
  LPSTR  _lpCmdLine;
  HWND   _hwnd;
  MSG    _msg;
  WSDwinformDev* _mfocus_dev;
  WSClistData _update_dev_list;
  HPALETTE _palette;
  HWND _grabed_wnd;
 public:
  WSDwinAppDev();
  virtual ~WSDwinAppDev();

  virtual void update();

  long setInitPrm(LPSTR);
  long setWnd(HWND);
  long handleEvents();

  virtual long dispatchEvent();
  virtual long processEvent();
          long _dispatchEvent(WSCbool wait);
  virtual long initialize();

  void setInstanceHandle(HINSTANCE);
  HINSTANCE getInstanceHandle();
  HWND getHWND();
  HWND getEventWnd();
  static HWND   _event_wnd;

  virtual long getDeviceResource();
  virtual long getWindowResource();
  virtual long getContextResource();
  virtual long getSpecialResource();

  virtual WSCushort getWidth();
  virtual WSCushort getHeight();

  virtual long loadGuiPolicy();
  virtual long saveGuiPolicy();

  WSDwinformDev* getMouseFocusDev();
  void    setMouseFocusDev(WSDwinformDev*);
  void addUpdateDev(WSDwinformDev*);
  void delUpdateDev(WSDwinformDev*);
  void setGrabedWnd(HWND wnd);
  HWND getGrabedWnd();
  HPALETTE getPalette();
  long setInitPrm(int iprm,char** cprm);
  WSMFclassDef(WSDwinAppDev,WSDappDev);
};

extern WSDwinAppDev* WSGIwinAppDev();

#endif
