//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCbase.h>

static WSCdevice* theAppDevice = NULL;
WSCdevice* WSGIappDevice(){
  if (theAppDevice == NULL){
    theAppDevice = new WSCdevice();
  }
  return theAppDevice;
}
WSCdevice::~WSCdevice(){
  long num = _device_name.getNum();
  long i;
  for(i=0; i < num; i++){
    delete (char*)_device_name[i];
  }
}
WSDdev* WSCdevice::getDevObject(char* cname,WSCbase* base){
  long i;
  long num = _device_create.getNum();
  for(i=0; i < num; i++){
    char* cn = (char*)_device_name[i];
    if (cn[0] == cname[0] && !strcmp(cn,cname)){
      WSDdev* (*handler)() = (WSDdev* (*)())_device_create[i];
      return  handler();
    }
  }
  return NULL;
}
long WSCdevice::setCreateHandler(char* cname,WSDdev* (*hd)() ){
  //use hash
  //DEVELOP ....
  if (cname == NULL){
    return WS_ERR;
  }
  char* cn = WSGFstrdup(cname);
  _device_create.add((void*)hd);
  _device_name.add((void*)cn);
  return WS_NO_ERR;
}
void WSCdevice::addDeleteInstance(WSDdev* dev){
  _deleted_instances.add((void*)dev);
}
void WSCdevice::clearDeleteList(){
  long num = _deleted_instances.getNum();
  long i;
  for(i=0 ;i < num; i++){
    WSDdev* dev = (WSDdev*)_deleted_instances[i];
//printf("WSCdevice::clearDeleteList   delete...\n");
    delete dev;
  }
  _deleted_instances.clear();
}
