//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCinputDialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSCvifield.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCinputDialog,WSCbaseDialog);
WSMFversion(WSCinputDialog,WSCbaseDialog);

#define D_BTN_WIDTH 80
WSMFpropertyValueChange(WSCinputDialog,WSNno,WSCbool,False);

WSCinputDialog::WSCinputDialog(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _label_string = WSGFstrdup("");
  _label = NULL;
  _title = NULL;
  _area1 = NULL;
  _wbg_no = WS_DF_DARKBACKCOLOR;
  _no = False;
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCinputDialog);
    WSMFpropertyCreate(WSNlabelString,   char*, _label_string,WSSlabelString);
    WSMFpropertyCreate(WSNworkBackColor,  short, _wbg_no,WSSworkBackColor );

    WSMFpropertyValueChangeDef(WSCinputDialog,WSNno,WSCbool);
    WSMFpropertyDelete(WSNshadowThickness);

  WSMFpropertyCreateEnd
}

WSCinputDialog::~WSCinputDialog(){
  if (_label_string != NULL){
    delete _label_string;
    _label_string = NULL;
  }
}

WSMFproperty( WSCinputDialog, WSNlabelString, char*, _label_string,WSGFstrdup("") );
WSMFproperty( WSCinputDialog, WSNworkBackColor,short, _wbg_no ,WS_DF_DARKBACKCOLOR);

void WSCinputDialog::setWorkWSNtitleString(char* str){
  WSCbaseDialog::setWorkWSNtitleString(str);
  if (_title != NULL){
    _title->setProperty(WSNlabelString,str);
  }
}

void WSCinputDialog::setWorkWSNlabelString(char* str){
  if (_label != NULL){
    _label->setPropertyV(WSNlabelString,str);
  }
}

void WSCinputDialog::getWorkWSNlabelString(char** str){
  if (_label != NULL){
    if (_label_string != NULL){
      delete _label_string;
      _label_string = NULL;
    }
    WSCstring tmp;
    tmp = _label->getProperty(WSNlabelString);
    _label_string = WSGFstrdup( tmp );
    *str = _label_string;
  }
}

void WSCinputDialog::setWorkWSNforeColor(short no){
  if (_title != NULL){
    _title->setProperty(WSNforeColor,no);
  }
  if (_label != NULL){
    _label->setProperty(WSNforeColor,no);
  }
  WSCbaseDialog::setWorkWSNforeColor(no);
}
void WSCinputDialog::setWorkWSNworkBackColor(short no){
  if (_area1 != NULL){
    _area1->setProperty(WSNbackColor,no);
  }
}
void WSCinputDialog::getWorkWSNworkBackColor(short* ){}

long WSCinputDialog::initialize(){
  WSCbaseDialog::initialize();

  _area1 = new WSCform(this,"md-label");
  _area1->setInternalObject(True);
  _area1->initialize();
//  _area1->setPropertyV(WSNx,     (short)5 );
  _area1->setPropertyV(WSNx,     (short)0 );
  _area1->setPropertyV(WSNy,     (short)5 );
//  _area1->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _area1->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _area1->setProperty(WSNbackColor,_wbg_no);
//  _area1->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  _area1->setVisible(True);

  _label = new WSCvifield(_area1,"md-if");
  _label->setInternalObject(True);
  _label->initialize();
  _label->setPropertyV(WSNx,     (short)10 );
  _label->setPropertyV(WSNy,     (short)30 );
  _label->setPropertyV(WSNheight,(WSCushort)(20));
//  _label->setPropertyV(WSNforeColor,"black");
//  _label->setPropertyV(WSNbackColor,WSGFcolor("gray85"));
//  _label->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
//  _label->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
  _label->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _label->setPropertyV(WSNfillSpace,(WSCbool)False);
  _label->setPropertyV(WSNinterCur,(WSCbool)True);
  _label->setPropertyV(WSNmaxLength,(WSCushort)128);
  _label->setPropertyV(WSNcolumns,(WSCushort)20);
  _label->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  _label->setPropertyV(WSNlabelString,_label_string );
  _label->setVisible(True);
 
  WSCprocedure* lbop = new WSCprocedure("_label_focus_work",WSEV_PARENT_VISIBLE_CH);
  lbop->setInternal(True);
  lbop->setFunction(_label_focus_work,"_label_focus_work");
  _label->addProcedure(lbop);

  _title = new WSCvlabel(_area1,"md-if");
  _title->setInternalObject(True);
  _title->initialize();
  _title->setProperty(WSNx,     (short)10 );
  _title->setProperty(WSNy,     (short)1 );
  _title->setProperty(WSNheight,(WSCushort)(30));
  _title->setProperty(WSNshadowThickness,(WSCuchar)0);
  _title->setProperty(WSNshadowType,(WSCuchar)WS_SHADOW_TRANS);
//  _title->setProperty(WSNlabelString,_title_string);
  _title->setProperty(WSNalignmentH,WS_LEFT);
  _title->setVisible(True);
 

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
 
  return WS_NO_ERR;
}

void WSCinputDialog::_label_focus_work(WSCbase* obj){
  if (obj->getVisible() != False){
    obj->setFocus();
  }
}
void WSCinputDialog::onVisibleChange(WSCbool fl){
  WSCbaseDialog::onVisibleChange(fl);
}

void WSCinputDialog::adjustForm(){
  WSCbaseDialog::adjustForm();
  if(_area1 != NULL){
    long diff = 0;
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      diff = 0;
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      diff = 5;
    }
    if (_w > 2){
//      _area1->setPropertyV(WSNwidth, (WSCushort)(_w - 10));
      _area1->setPropertyV(WSNwidth, (WSCushort)(_w));
    }else{
//      _area1->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h+diff > 45){
      _area1->setPropertyV(WSNheight,(WSCushort)(_h+diff - 45));
      _label->setPropertyV(WSNy,(short)((_h+diff - 45 -20)/2));
      _title->setPropertyV(WSNy,(short)((_h+diff - 45 -20)/2-30));
    }else{
      _area1->setPropertyV(WSNheight,(WSCushort)(1));
      _label->setPropertyV(WSNy,(short)1);
      _title->setPropertyV(WSNy,(short)1);
    }
    if (_w > 20){
      _label->setPropertyV(WSNwidth,(WSCushort)(_w - 22));
      _title->setPropertyV(WSNwidth,(WSCushort)(_w - 22));
    }else{
      _label->setPropertyV(WSNwidth,(WSCushort)(1));
      _title->setPropertyV(WSNwidth,(WSCushort)(1));
    }
  }  
}
void WSCinputDialog::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
long WSCinputDialog::popup(){
  setVisible(True);

  if (getVisible() == False){
    return WS_ERR;
  }
  _popuped = 1;

  if (_ok != False){
    _ok_btn->setSpecialFocus(True);
  }else
  if (_no != False){
    _no_btn->setSpecialFocus(True);
  }else{
    _end_btn->setSpecialFocus(True);
  }
  _label->setFocus();

  while(1){
    if (_popuped == 0){
      break;
    }
    WSGIappDev()->dispatchEvent();
  }
  setVisible(False);
  return _status;
}
void WSCinputDialog::onGuiPolicyChange(long policy){
  if (_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area1->setProperty(WSNy,5);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area1->setProperty(WSNy,0);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    }
    adjustForm();
  }
}

