//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCsform.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDprivateTimer.h>

WSMFguiClassInitialize(WSCsform,WSCform);
WSMFversion(WSCsform,WSCform);
WSMFdefineUseDevice(WSCsform,formDev);

WSDprivateTimer* _delay_timer = NULL;

WSCsform::WSCsform(WSCbase* base,char* objname):
                WSCform(base,objname){

  _pos = WSGFstrdup("50");
  _bw = 5;
  _orientation = WS_VERTICAL;
  _pressed = 0;
  _margin_top = 2;
  _margin_bottom = 2;
  _margin_left = 2;
  _margin_right = 2;
  _adjust_init = 0;
  _exec_resize = 0;
  _adjust_btn = 1;
  _delay_adjust_flag = 0;
  _need_adjust = False;
  _refreshing = False;
  _minimum = 30;
  _separator = WSGFstrdup(",");
 
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCsform);

    WSMFpropertyCreate(WSNseparator,  char*, _separator, WSSseparator );
    WSMFpropertyCreate(WSNbarThickness,WSCushort,_bw,WSSbarThickness);
    WSMFpropertyCreate(WSNbarValue,char*,_pos,WSSbarValue);
    WSMFpropertyCreate(WSNorientation,WSCuchar,_orientation,WSSorientation);
    WSMFpropertySetSelection(WSRorientation,WSRorientationD);
    WSMFpropertyCreate(WSNmarginTop,    WSCuchar,  _margin_top,WSSmarginTop );
    WSMFpropertyCreate(WSNmarginBottom, WSCuchar,  _margin_bottom,WSSmarginBottom);
    WSMFpropertyCreate(WSNmarginLeft,   WSCuchar,  _margin_left,WSSmarginLeft );
    WSMFpropertyCreate(WSNmarginRight,  WSCuchar,  _margin_right,WSSmarginRight);
    WSMFpropertyCreate(WSNrefreshing,  WSCbool,  _refreshing,WSSrefreshing);
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate(WSNminimum,  WSCuchar,  _minimum,WSSminimum);

    WSMFaddTrigger(WSEV_VALUE_CH    );

  WSMFpropertyCreateEnd

}

WSMFproperty(WSCsform,WSNbarThickness,WSCushort,_bw,5);
WSMFproperty(WSCsform,WSNbarValue,char*,_pos,WSGFstrdup("50"));
WSMFproperty(WSCsform,WSNorientation,WSCuchar,_orientation,WS_VERTICAL);
WSMFproperty(WSCsform, WSNmarginTop,   WSCuchar,_margin_top,    2);
WSMFproperty(WSCsform, WSNmarginBottom,WSCuchar,_margin_bottom, 2);
WSMFproperty(WSCsform, WSNmarginLeft,  WSCuchar,_margin_left,   2);
WSMFproperty(WSCsform, WSNmarginRight, WSCuchar,_margin_right,  2);
WSMFproperty(WSCsform, WSNrefreshing,  WSCbool,_refreshing,  False);
WSMFproperty(WSCsform, WSNminimum,  WSCuchar,_minimum,  30);
WSMFproperty(WSCsform, WSNseparator,  char*, _separator,WSGFstrdup(","));

void WSCsform::setWorkWSNseparator(char* data){
  WSCstring tmp(_pos);
  _parse_pos(tmp);
  _need_adjust = True;
  _adjust();
}
void WSCsform::getWorkWSNseparator(char** data){
}
void WSCsform::setWorkWSNminimum(WSCuchar){
  _adjust();
}
void WSCsform::getWorkWSNminimum(WSCuchar*){ }
void WSCsform::setWorkWSNrefreshing(WSCbool){ }
void WSCsform::getWorkWSNrefreshing(WSCbool*){ }
void WSCsform::setWorkWSNbarValue(char* pos){
  _parse_pos(pos);
  _need_adjust = True;
  _adjust();
#if 0
  if (_orientation == WS_VERTICAL){
    if (_w - _shadow_thick*2 - _margin_left - _margin_right - _bw/2 < pos){
      _pos = _w - _shadow_thick*2 - _margin_left - _margin_right - _bw/2;
    }else if (_shadow_thick + _margin_left + _bw/2 > pos){
      _pos = _shadow_thick + _margin_left + _bw/2;
    }

  }else{
    if (_h - _shadow_thick*2 - _margin_top - _margin_bottom - _bw/2 < pos){
      _pos = _h - _shadow_thick*2 - _margin_top - _margin_bottom - _bw/2;
    }else if (_shadow_thick + _margin_top + _bw/2 > pos){
      _pos = _shadow_thick + _margin_top + _bw/2;
    }
  }
#endif
}

void WSCsform::getWorkWSNbarValue(char**){
}

void WSCsform::_parse_pos(char* pos){
  _pos_list.clear();
  WSCstring str(pos);

  long num = str.getWords(_separator);
  long i;
  for(i=0; i<num; i++){
    WSCstring n;
    n = str.getWord(i,_separator);
    long item = atoi(n);
    _pos_list.add((void*)item);
//printf("WSCsform::_parse_pos %d pos=%d\n",i,item);
  }
}


void WSCsform::setWorkWSNwidth(WSCushort w){
  WSCform::setWorkWSNwidth(w);
  if (_orientation == WS_VERTICAL){
    long num = (long)_pos_list.getNum();
    if (w < _shadow_thick*2 + _margin_left + _margin_right + _bw * num + 2){
      w =  _shadow_thick*2 + _margin_left + _margin_right + _bw * num + 2;
      _w = w;
    }
    long i;
    if (_adjust_btn != 0){
//printf("WSCsform::width w=%d\n",w);
      for(i=0; i<num; i++){
        WSCulong pos = (WSCulong)_pos_list[i];
        if (w - _shadow_thick*2 - _margin_left - _margin_right - _bw/2 < pos){
          pos = w - _shadow_thick*2 - _margin_left - _margin_right - _bw/2;
//printf("WSCsform::width %d pos=%d\n",i,pos);
          _pos_list.setData(i,(void*)pos);
        }
      }
    }

    long first = 1;
    WSCstring str;
    for(i=0; i<num; i++){
      long val = (long)_pos_list[i];
      if (first == 0){
        str += _separator;
      }else{
        first = 0;
      }
      str += WSGFltoa(val);
    }
    if (num != 0 ){
      if (_pos != NULL){
        delete _pos;
      }
      _pos = WSGFstrdup((char*)str);
      _need_adjust = True;
//      _adjust();
    }
  }
}
void WSCsform::setAdjustChildren(WSCbool fl){
  _adjust_btn = fl;
}
void WSCsform::setWorkWSNheight(WSCushort h){
  if (_orientation == WS_HORIZONTAL){
    long num = (long)_pos_list.getNum();
    if (h < _shadow_thick*2 + _margin_top + _margin_bottom + _bw * num + 2){
      h =  _shadow_thick*2 + _margin_top + _margin_bottom + _bw * num + 2;
      _h = h;
    }
    long i;
    if (_adjust_btn != 0){
      for(i=0; i<num; i++){
        WSCulong pos = (WSCulong)_pos_list[i];
        if (h - _shadow_thick*2 - _margin_top - _margin_bottom - _bw/2 < pos){
          pos = h - _shadow_thick*2 - _margin_top - _margin_bottom - _bw/2;
//printf("WSCsform::height %d pos=%d\n",i,pos);
          _pos_list.setData(i,(void*)pos);
        }
      }
    }
  }
  WSCform::setWorkWSNheight(h);
  _need_adjust = True;
//  _adjust();
}
void WSCsform::setWorkWSNmarginTop(WSCuchar ){
  if (_initialized != False){
    _need_adjust = True;
//    _adjust();
  }
}
void WSCsform::getWorkWSNmarginTop(WSCuchar* ){}
void WSCsform::setWorkWSNmarginBottom(WSCuchar ){
  if (_initialized != False){
    _need_adjust = True;
//    _adjust();
  }
}
void WSCsform::getWorkWSNmarginBottom(WSCuchar* ){}
void WSCsform::setWorkWSNmarginLeft(WSCuchar ){
  if (_initialized != False){
    _need_adjust = True;
//    _adjust();
  }
}
void WSCsform::getWorkWSNmarginLeft(WSCuchar* ){}
void WSCsform::setWorkWSNmarginRight(WSCuchar ){
  if (_initialized != False){
    _need_adjust = True;
//    _adjust();
  }
}
void WSCsform::getWorkWSNmarginRight(WSCuchar* ){}
void WSCsform::setWorkWSNbarThickness(WSCushort ){
  if (_initialized != False){
    _need_adjust = True;
//    _adjust();
  }
}

void WSCsform::getWorkWSNbarThickness(WSCushort*){}
void WSCsform::setWorkWSNorientation(WSCuchar){
  if (_initialized != False){
    _need_adjust = True;
//    _adjust();
  }
}
void WSCsform::getWorkWSNorientation(WSCuchar*){}

WSCsform::~WSCsform(){
}

long WSCsform::_device_initialize(){
  long ret = WSCform::_device_initialize();
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  dev->setEnableEventBit(WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_PRESS_BIT |
                         WSEV_MOUSE_RELEASE_BIT);
  return ret;
}

long WSCsform::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  if (_adjust_init == 0){
    _adjust_init = 1;
    _parse_pos(_pos);
  }
  if (_need_adjust != False){
    _adjust();
  }
  WSCform::draw();

  return WS_NO_ERR;

}

void WSCsform::onMousePress(WSCpoint* pt){
  long num = _pos_list.getNum();
  long i;
  long mx = pt->x;
  long my = pt->y;
  for(i=0; i<num; i++){
    long pos = (long)_pos_list[i];
    long next = -1;
    if (i < num -1){
      next = (long)_pos_list[i+1];
    } 
    if (_orientation == WS_VERTICAL){
      pos += _shadow_thick + _margin_left;
      next += _shadow_thick + _margin_left;
      long val = pos + _bw/2 + 10;
      if ( i < num -1 && next < val){
         val = next + 1;
      }
      if (pos - 10  - _bw/2<  mx && mx < val){
        _pressed = True;
        _hit_bar = i;
        break;
      }
    }else{
      pos += _shadow_thick + _margin_top;
      next += _shadow_thick + _margin_top;
      long val = pos + _bw/2 + 10;
//      if (next != -1 && next < val){
//         val = next;
//      }
      if ( i < num -1 && next < val){
         val = next + 1;
      }

      if (pos - 10 - _bw/2 <  my && my < val){
        _pressed = True;
        _hit_bar = i;
        break;
      }
    }
  }
  WSCform::onMousePress(pt);
}
void WSCsform::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}
void WSCsform::onMouseRelease(WSCpoint* pt){
  _pressed = False;
  WSCform::onMouseRelease(pt);
  _exec_resize = 1;
  _need_adjust = True;
  _adjust();
  _exec_resize = 0;
  onValueChange();
}
void WSCsform::_clear_area(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return;
  }
  if (getVisible() == False){
    return;
  }
  long er = dev->beginDraw(0,0,_w,_h,True);
  if (er != WS_NO_ERR){
    return;
  }
  dev->clearArea(_shadow_thick + _margin_left,
                 _shadow_thick + _margin_top,
                 _w - _shadow_thick*2 - _margin_right - _margin_left,
                 _h - _shadow_thick*2 - _margin_bottom - _margin_top,True);
  dev->endDraw();
}

void WSCsform::_delay_adjust_work(void* ptr){
  WSCsform* sform = (WSCsform*)ptr;
  sform->_need_adjust = True;
  sform->_adjust();
//  sform->redraw();
  sform->_clear_area();
  sform->_delay_adjust_flag = 0;
}
void WSCsform::onMouseMove(WSCpoint* pt){
  if (_pressed != False){
    long pos = 0;
    if (_orientation == WS_VERTICAL){
      if (pt->x > 0){
        pos = pt->x;
      }
    }else{
      if (pt->y > 0){
        pos = pt->y;
      }
    }
    long pre = 0;
    long next = 0;
    long num =  _pos_list.getNum();

    if (_hit_bar > 0){
      pre = (long)_pos_list[_hit_bar-1];
    }
    if (_hit_bar < num -1){
      next = (long)_pos_list[_hit_bar+1];
    }else{
      if (_orientation == WS_VERTICAL){
        next = _w - _margin_right - _margin_left - _shadow_thick*2;
      }else{
        next = _h - _margin_top - _margin_bottom - _shadow_thick*2;
      }
    }
    if (pos < pre + _minimum){
      pos = pre + _minimum +2;
    }
    if (next < pos + _minimum){
      pos = next -2 - _minimum;
    }

    _pos_list.setData(_hit_bar,(void*)pos);
    num = _pos_list.getNum();
    long i;
    WSCstring str;
    long first = 1;
    for(i=0; i<num; i++){
      long val = (long)_pos_list[i];
      if (first == 0){
        str += _separator;
      }else{
        first = 0;
      }
      str += WSGFltoa(val);
    }
    if (_pos != NULL){
      delete _pos;
    }
    _pos = WSGFstrdup((char*)str); 
#ifndef MSW
    if (_delay_adjust_flag == 0){
      if (_delay_timer == NULL){
        _delay_timer = WSDprivateTimer::getNewInstance();
        _delay_timer->setRate(50);
        _delay_timer->setCont(False);
      }
      _delay_timer->setWorkProc(_delay_adjust_work,this);
      _delay_timer->startTimer();
    }
#else //MSW
    _need_adjust = True;
    _adjust();
    _clear_area();
//    redraw();
#endif //MSW
  }else{
    WSDdev* dev = getowndev();
    if (dev != NULL){
      long num = _pos_list.getNum();
      long i;
      long mx = pt->x;
      long my = pt->y;
      long fl = 0;
      for(i=0; i<num; i++){
        long pos = (long)_pos_list[i];
        long next = -1;
        if (i < num -1){
          next = (long)_pos_list[i+1];
        }
        if (_orientation == WS_VERTICAL){
          pos += _shadow_thick + _margin_left;
          next += _shadow_thick + _margin_left;
          long val = pos + _bw/2 + 10;
          if ( i < num -1 && next < val){
             val = next + 1;
          }
          if (pos - 10  - _bw/2<  mx && mx < val){
            WSCushort mouseno = 182;
            dev->setValue(WSDEV_MOUSE_NO,&mouseno);
            fl = 1;
            break;
          }
        }else{
          pos += _shadow_thick + _margin_top;
          next += _shadow_thick + _margin_top;
          long val = pos + _bw/2 + 10;
//          if (next != -1 && next < val){
//             val = next;
//          }
          if ( i < num -1 && next < val){
             val = next + 1;
          }
          if (pos - 10 - _bw/2 <  my && my < val){
            WSCushort mouseno = 186;
            dev->setValue(WSDEV_MOUSE_NO,&mouseno);
            fl = 1;
            break;
          }
        }
      }
      if (fl == 0){
        dev->setValue(WSDEV_MOUSE_NO,&_mouse_no);
      }
    }
  }

  WSCform::onMouseMove(pt);
  if (_pressed != False){
    onValueChange();
  }
}

void WSCsform::onParentVisibleChange(WSCbool fl){
  WSCform::onParentVisibleChange(fl);
  if (fl != False){
    _need_adjust = True;
    _adjust();
  }
}

void WSCsform::onVisibleChange(WSCbool fl){
  WSCform::onVisibleChange(fl);
  if (fl != False){
    _need_adjust = True;
    _adjust();
  }
}

void WSCsform::update(){
  if (_need_adjust != False){
    _adjust();
  }
  if (isNeedUpdate() != False){
    WSCform::update();
  }
}

void WSCsform::onResize(WSCrect* area){
  WSCform::onResize(area);
  if (_need_adjust != False){
    _adjust();
  }
//  setAbsoluteDraw(True);
//  needUpdate();
}

WSCbase* _get_ext_child(WSClistData* children,long no){
    long i=0;
    long cnt=0;
    WSCbase* child;
    while(1){
      child =(WSCbase*)(*children)[i];
      if(child == NULL){
        return NULL;
      }
//      if (child->getInternalObject() != False){
      if (child->cast("WSCgripHand") != NULL){
        i++;
      }else{
        long nomanaged = (long)child->getUserData("sform-managed");
        if (nomanaged != False){
          i++;
          continue;
        }
        if (no == cnt){
          return child;
        }
        cnt++;
        i++;
      }
    }
}

void WSCsform::_adjust(){
  if (_need_adjust == False){
    return;
  }
  _need_adjust = False;
  long num = _pos_list.getNum()+1;
  long i;
  WSClistData children = getChildren();
  short x,y;
  WSCushort w,h;
  for(i=0; i<num; i++){
    WSCbase* child = _get_ext_child(&children,i);
    if (child == NULL){
      break;
    }
  }
  if (getPropertyEditMode() == False){
    num = i++; 
  }
  for(i=0; i<num; i++){
    long pre = -1;
    if(i > 0){
     pre = (long)_pos_list[i-1] + _bw/2;
    }
    long pos = -1;
    if ( i < num -1){
      pos = (long)_pos_list[i] - _bw/2;
    }
    WSCbase* child = _get_ext_child(&children,i);
//printf("WSCsform::_adjust %d pos=%d\n",i,pos);
    if (_orientation == WS_VERTICAL){
      if (pre == -1){
        pre = 0;
      }
      if (pos == -1){
        pos = _w - _margin_right - _margin_left - _shadow_thick*2;
      }
      if (pos >_w){
        pos = _w;
      }
      if (pos == 0){
        pos = _margin_left + _shadow_thick + 1 + _bw/2;
      }

      if (child != NULL){
//printf("sform::_adjust child%d=%s\n",i,child->getInstanceName());
        x = _shadow_thick + _margin_left + pre;
        y = _shadow_thick + _margin_top;
        w = pos - pre;
        if (w == 0 || pos < w ){
          w = 1;
        }
        h = _h - _shadow_thick*2 - _margin_top - _margin_bottom;
        if (h == 0 || _h < h){
          h = 1;
        }
//printf("WSCsform::_adjust %s->%d,%d,%d,%d\n",child->getInstanceName(),x,y,w,h);
        long val = child->getProperty(WSNwidth);
        if (val > w){
          child->setPropertyV(WSNwidth,w);
          child->setPropertyV(WSNx,x);
        }else{
          child->setPropertyV(WSNx,x);
          child->setPropertyV(WSNwidth,w);
        }
        child->setPropertyV(WSNy,y);
        child->setPropertyV(WSNheight,h);
        if (_exec_resize != 0 || _refreshing != False){
          WSCrect rect;
          rect.x = x;
          rect.y = y;
          rect.width = w;
          rect.height = h;
          child->execEventProc(WSEV_RESIZE,&rect);
        }
//        WSCrect rect;
//        rect.setRect(x,y,w,h);
//        child->execEventProc(WSEV_RESIZE,(void*)&rect); 
//WSMFtrace("WSCsform::_adjust w=%d\n",w);
      }
    }else{
      if (pre == -1){
        pre = 0;
      }
      if (pos == -1){
        pos = _h - _margin_bottom - _margin_top - _shadow_thick*2;
      }
      if (pos >_h){
        pos = _h;
      }
      if (pos == 0){
        pos = _margin_top + _shadow_thick + 1 + _bw/2;
      }

      if (child != NULL){
        x = _shadow_thick + _margin_left;
        y = _shadow_thick + _margin_top + pre ;
        w = _w - _shadow_thick*2 - _margin_left - _margin_right;
        if (w == 0 || _w < w ){
          w = 1;
        }
        h = pos - pre;
        if (h == 0 || pos < h){
          h = 1;
        }
        long val = child->getProperty(WSNheight);
        if (val > h){
          child->setPropertyV(WSNheight,h);
          child->setPropertyV(WSNy,y);
        }else{
          child->setPropertyV(WSNy,y);
          child->setPropertyV(WSNheight,h);
        }
        child->setPropertyV(WSNx,x);
        child->setPropertyV(WSNwidth,w);
        if (_exec_resize != 0 || _refreshing != False){
          WSCrect rect;
          rect.x = x;
          rect.y = y;
          rect.width = w;
          rect.height = h;
          child->execEventProc(WSEV_RESIZE,&rect);
        }
      }
    }
  }
}
long WSCsform::setManaged(WSCbase* target,WSCbool fl){
  WSCbase* parent = target->getParent();
  if (parent != this){
    return WS_ERR;
  }
  long nomanaged = (long)target->getUserData("sform-managed"); 
  if (nomanaged == False && fl != False){
    return WS_NO_ERR;
  }
  if (nomanaged != False && fl == False){
    return WS_NO_ERR;
  }
  if (fl == False){
    target->setUserData("sform-managed",(void*)True); 
  }else{
    target->setUserData("sform-managed",(void*)False); 
  }
  _need_adjust = True;
  _adjust();
  return WS_NO_ERR;
}

long WSCsform::getStatus(){
  if (_pressed == 0){
    return WS_SFORM_FIXED;
  }
  return WS_SFORM_UNDER_RESIZING;
}

void WSCsform::_exec_child_adjust_for_anchors(){
}

WSCbool WSCsform::adjustAnchor(){
  return False;
}
