//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <fcntl.h>
#include <WSDmemSerialize.h>
#include <WSCconductor.h>
#include <WSCserializeData.h>

#define WS_SRL_TYPE "MEM"

WSMFclassInit(WSDmemSerialize,WSDserialize);

WSDserialize* _memdb_create_handler(){
  WSDserialize* db = new WSDmemSerialize();
  return db;
}

class  _memdb_init {
  public:
  _memdb_init(){
    WSGIconductor()->addSerialize(new WSDmemSerialize);
  };
};

static _memdb_init  _wsgi_app_memsr_init;


WSDmemSerialize::WSDmemSerialize(){
  _data = NULL;
  _data_size = 0;
  _ptr = 0;
}

WSDmemSerialize::~WSDmemSerialize(){
  if (_data != NULL){
    delete _data;
    _data = NULL;
  }
}

long WSDmemSerialize::endTransaction(){
  if (_need_save == False){
    return WS_NO_ERR;
  }
  _close();
  long ret = _open(_field.getString(),WS_WRITE);
  if (ret != WS_NO_ERR){
WSMFtrace("WSDmemSerialize::endTransaction   open error.\n");
    return ret;
  }

  _need_save = False;
  _seek(0);
  long num = _data_list.getNum();
  char tmp[4];
  WSGIbinType()->memcpy4b(tmp,num);
  _write(tmp,sizeof(char)*4);

  setUnderTransaction(False);

  long i;
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    dt->write(this);
  }
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    delete dt;
  }
  _data_list.clear();
  _close();
  return WS_NO_ERR;
}

long WSDmemSerialize::_open(char* name,long mode){
  _ptr = 0;
  _seek(0);
  return WS_NO_ERR;
}

long WSDmemSerialize::_close(){
  return WS_NO_ERR;
}

long WSDmemSerialize::_eof(){
  if (_data == NULL){
    return 0; //eof
  }
  if (_ptr > _data_size -1){
    return 0; //eof
  }
  return 1;
}

WSCbool WSDmemSerialize::type(char* tp){
  if ( !strcmp(tp,WS_SRL_TYPE) ){
    return True;
  }else{
    return False;
  }
}

long WSDmemSerialize::_seek_set(){
   return _seek(0);
}

long WSDmemSerialize::_tell(){
  if (_data == NULL){
    return 0;
  }
  if (_ptr > _data_size){
    _ptr = _data_size;
  }
  return _ptr;
}

long WSDmemSerialize::_size(){
  if (_data == NULL){
    _data_size = 0;
    _ptr = 0;
    return 0;
  }
  return _data_size;
}

long WSDmemSerialize::_seek(long addr){
  if (_data == NULL){
    return 0;
  }
  _ptr = addr;
  if (_data_size < _ptr){
    _ptr = _data_size;
  }
  return WS_NO_ERR;
}
long WSDmemSerialize::_seek_end(){
  if (_data == NULL){
    _ptr = 0;
    _data_size = 0;
    return 0;
  }
  _ptr = _data_size;
  return WS_NO_ERR;
}

long WSDmemSerialize::_read(void* buf,long len){
  if (_data == NULL){
    return 0;
  }
  if (len + _ptr > _data_size){
    len = _data_size - _ptr;
  }
  memcpy(buf,&(_data[_ptr]),len);
  _ptr = _ptr + len;
  return len;
}

long WSDmemSerialize::_write(void* buf,long len){
  if (len + _ptr > _data_size){
    void* data_bk = NULL;
    long data_bk_len = 0;
    if (_data != NULL){
      data_bk = _data;
      data_bk_len = _data_size;
    }

    _data_size = _ptr + len;

    _data = new char[_data_size];

    if (data_bk != NULL){
      memcpy(_data,data_bk,data_bk_len);
    }

    if (buf != NULL){
      memcpy(&(_data[_ptr]),buf,len);
    }
    _ptr = _ptr  + len;
    delete (char*)data_bk;
    return len;
  }else{
    memcpy(&(_data[_ptr]),buf,len);
    _ptr = _ptr  + len;
    return len;
  }
}

WSDserialize* WSDmemSerialize::createSerialize(){
  return new WSDmemSerialize;
}
char* WSDmemSerialize::getData(){
  return _data;
}
long WSDmemSerialize::getDataSize(){
  return _data_size;
}
void WSDmemSerialize::setData(char* data,long len){
  if (_data != NULL){
    delete _data;
    _data = NULL;
  }
  _ptr = 0;
  _data_size = len ;
  _data = data;

}

