//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDprivateTimer.h>

WSMFclassInit(WSDprivateTimer,WSCroot);

void* WSDprivateTimer::_create_handler = NULL;

WSDprivateTimer::WSDprivateTimer(){
  _timer_on = False;
  _timer_rate = 50;
  _work_proc = NULL;
  _cont = True;
  _data = NULL;
}

//WSDprivateTimer::~WSDprivateTimer(){
//}

void WSDprivateTimer::startTimer(){
WSMFtrace("Warring. WSDprivateTimer::startTimer() is no effective.\n");
}

void WSDprivateTimer::stopTimer(){
WSMFtrace("Warring. WSDprivateTimer::stopTimer() is no effective.\n");
}

void WSDprivateTimer::setRate(long rate){
  _timer_rate = rate;
  if (_timer_on != False){
    stopTimer();
    startTimer();
  }
}

void WSDprivateTimer::setWorkProc(void(*wp)(void*),void* data){
  _work_proc = wp;
  _data = data;
}

void WSDprivateTimer::setCont(WSCbool fl){
  _cont = fl;
}

WSDprivateTimer* WSDprivateTimer::getNewInstance(){
  WSDprivateTimer* (*chandler)();
  chandler = (WSDprivateTimer* (*)())_create_handler;
  WSDprivateTimer* obj = NULL;
  if (chandler == NULL){
WSMFtrace("Warring. WSDprivateTimer can not create native timer of this system.\n");
    obj = new WSDprivateTimer;
  }else{
    obj = chandler();
  }
  return obj;
}

void WSDprivateTimer::setCreateInstanceHandler(void* hd){
  _create_handler = hd;
}
