//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCSFORM_H
#define WSCSFORM_H

#include <WScom.h>
#include <WSCform.h>

#define WSCsform_VER  1010

class WSCsform :public WSCform{

  private:
  protected:
    char*  _pos;
    WSClistData _pos_list;
    WSCushort _bw;
    WSCushort _hit_bar;
    char*     _separator;
    WSCuchar  _minimum;    
    unsigned  _margin_top:4;
    unsigned  _margin_bottom:4;
    unsigned  _margin_left:4;
    unsigned  _margin_right:4;
    unsigned  _orientation:1;
    unsigned  _pressed:1;
    unsigned  _adjust_init:1;
    unsigned  _exec_resize:1;
    unsigned  _adjust_btn:1;
    unsigned  _delay_adjust_flag:1;
    unsigned  _need_adjust:1;
    unsigned  _refreshing:1;

    WSMFpropertyDef(WSNbarThickness, WSCushort, _bw);
    WSMFpropertyDef(WSNbarValue,     char*, _pos);
    WSMFpropertyDef(WSNorientation,  WSCuchar,  _orientation);
    WSMFpropertyDef(WSNmarginTop,    WSCuchar,  _margin_top   ); 
    WSMFpropertyDef(WSNmarginBottom, WSCuchar,  _margin_bottom); 
    WSMFpropertyDef(WSNmarginLeft,   WSCuchar,  _margin_left  ); 
    WSMFpropertyDef(WSNmarginRight,  WSCuchar,  _margin_right ); 
    WSMFpropertyDef(WSNrefreshing,  WSCbool,  _refreshing ); 
    WSMFpropertyDef(WSNminimum,  WSCuchar,  _minimum ); 
    WSMFpropertyDef(WSNseparator,  char*, _separator  );

    virtual long _device_initialize();
    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);

    void _adjust();
static    void _delay_adjust_work(void*);
    void _parse_pos(char*);
    void _clear_area();
    virtual void  _exec_child_adjust_for_anchors();

  public:
    WSCsform(WSCbase*,char*);
    virtual ~WSCsform();

    virtual void onResize(WSCrect*);
    virtual void onMousePress(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onVisibleChange(WSCbool fl);
    virtual void onParentVisibleChange(WSCbool fl);
    virtual void onValueChange();

    virtual long draw();
    virtual void update();
    long getStatus();
    void setAdjustChildren(WSCbool);
    long setManaged(WSCbase*,WSCbool);

    virtual WSCbool adjustAnchor();

    WSMFguiClassDef(WSCsform,WSCform);
    WSMFsetUseDevice(formDev);
    WSMFversionDef(WSCsform);
};

#endif
