//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <advance/WSCprocedureEditor.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSCimageSet.h>
#include <WSCmessageDialog.h>
#include <WSCfileSelect.h>
#include <WSCvtoggle.h>
#include <WSDfile.h>
#include <WSCballoonHelp.h>
#include <WSCpopupMenu.h>
#include <WSCvfbtn.h>
#include <WSCbaseDialog.h>
#include <WSClist.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>
#include <WSDtimer.h>

#define WS_WARNING_STR  WSGFgettext("L3:WSSTR Warning")

#define WS_DIALOG_PIX1  WS_PIXMAP_DIR "bi23.xpm"
#define WS_DIALOG_PIX2  WS_PIXMAP_DIR "ope.xpm"

static char* pixmaps[] = {
WS_PIXMAP_DIR "wcreate.xpm",
WS_PIXMAP_DIR "pset.xpm",
WS_PIXMAP_DIR "edit.xpm",
WS_PIXMAP_DIR "wtrash.xpm",
};
static char* bhelpstr[] = {
"Z3:WSSTR Add procedure",
"a3:WSSTR Properties",
"b3:WSSTR Edit procedure",
"c3:WSSTR Delete procedure"
"",
"",
""
};

WSCeventProc WSCprocedureEditor::evprocs[] = {
WSCprocedureEditor::_ibtn1_work,
WSCprocedureEditor::_ibtn2_work,
WSCprocedureEditor::_ibtn3_work,
WSCprocedureEditor::_ibtn4_work,
  NULL,
  NULL,
  NULL
};



//#define WS_OLBGCOLOR1 "mistyrose3"
#define WS_OLBGCOLOR1 "#D5C5C5"
#define WS_OLTITLE    "ProcedureList"
#define WS_OLTITLE2   "Instance:"
#define WS_OLLB_X1     5
#define WS_OLLB_W1     30
#define WS_OLLB_X2     35
#define WS_OLLB_W2     120
#define WS_OLLB_X3     155
#define WS_OLLB_W3     100
#define WS_OLLB_X4     255
#define WS_OLLB_W4     95
#define WS_OLLB_H      17
#define WS_OLLB_T      18

#define WS_OLLB_W      400
#define WS_OLLB_HEIGHT 300


#define WS_OLLD_WIDTH     350
#define WS_OLLD_HEIGHT    185
#define WS_OLLD_TWIDTH  170
#define WS_OLLD_T       25
#define WS_OLLD_LX      190
#define WS_OLLD_LWIDTH  140

//////////////////////////////////////////////////////////
#define WS_OLLD_TGRMENU    \
"None:-1:,INITALIZE:0:,DELETE:1:,ACTIVATE:2:,VALUE-CH:3:,\
FOCUS-CH:4:,VISIBLE-CH:5:,SENSITIVE-CH:6:,\
PARENT-VISIBLE-CH:7:,PARENT-SENSITIVE-CH :8:,EXPOSE:9:,\
RESIZE:10:,MOUSE-IN:11:,MOUSE-OUT:12:,MOUSE-PRESS:13:,MOUSE-DOUBLE-CLICK:19:,\
MOUSE-RELEASE:14:,\
MOUSE-MOVE:15:,KEY-PRESS:16:,KEY-RELEASE:17:,KEY-HOOK:18:"
//////////////////////////////////////////////////////////

#define WS_OLLDTITLE1   WSGFgettext("d3:WSSTR Instance:")
#define WS_OLLDTITLE2   WSGFgettext("e3:WSSTR Procedure name:")
#define WS_OLLDTITLE3   WSGFgettext("f3:WSSTR Trigger:")
#define WS_OLLDTITLE5   WSGFgettext("g3:WSSTR Function name:")

WSMFguiClassInitialize(WSCprocedureEditor,WSCform);

long trgs[] = {
WSEV_NONE,
WSEV_INITIALIZE,
WSEV_DELETE,
WSEV_ACTIVATE,
WSEV_VALUE_CH,
WSEV_FOCUS_CH,
WSEV_VISIBLE_CH,
WSEV_SENSITIVE_CH,
WSEV_PARENT_VISIBLE_CH,
WSEV_PARENT_SENSITIVE_CH,
WSEV_EXPOSE,
WSEV_RESIZE,
WSEV_MOUSE_IN,
WSEV_MOUSE_OUT,
WSEV_MOUSE_PRESS,
WSEV_MOUSE_DOUBLE_CLICK,
WSEV_MOUSE_RELEASE,
WSEV_MOUSE_MOVE,
WSEV_KEY_PRESS,
WSEV_KEY_RELEASE,
WSEV_KEY_HOOK,
-2
};

char* trgtoname(long trg,WSCbase* client){
  switch(trg){
    case  WSEV_NONE:         return "NONE";
    case  WSEV_ACTIVATE:     return "ACTIVATE";
    case  WSEV_VALUE_CH:     return "VALUE-CH";
    case  WSEV_EXPOSE:       return "EXPOSE";
    case  WSEV_RESIZE:       return "RESIZE";
    case  WSEV_FOCUS_CH:     return "FOCUS-CH";
    case  WSEV_SENSITIVE_CH: return "SENSITIVE-CH";
    case  WSEV_MOUSE_IN:     return "MOUSE-IN";
    case  WSEV_MOUSE_OUT:    return "MOUSE-OUT";
    case  WSEV_MOUSE_PRESS:  return "MOUSE-PRESS";
    case  WSEV_MOUSE_DOUBLE_CLICK:  return "MOUSE-DOUBLE-CLICK";
    case  WSEV_MOUSE_RELEASE: return "MOUSE-RELEASE";
    case  WSEV_MOUSE_MOVE:   return "MOUSE-MOVE";
    case  WSEV_INITIALIZE:   return "INITIALIZE";
    case  WSEV_DELETE:   return "DELETE";
    case  WSEV_VISIBLE_CH:   return "VISIBLE-CH";
    case  WSEV_PARENT_VISIBLE_CH:   return "PARENT-VISIBLE-CH";
    case  WSEV_PARENT_SENSITIVE_CH:   return "PARENT-SENSITIVE-CH";
    case  WSEV_KEY_PRESS:    return "KEY-PRESS";
    case  WSEV_KEY_RELEASE:  return "KEY-RELEASE";
    case  WSEV_KEY_HOOK:     return "KEY-HOOK";
  }
  WSCindexData* etlist = client->getExtTriggerList();
  long etnum = etlist->getNum();
  long i;
  for(i=0; i< etnum; i++){
    if ((long)etlist->getData(i) == trg){
      return etlist->getIndex(i);
    }
  }
  return "NONE";
}


WSCprocedureEditor::WSCprocedureEditor(WSCbase* base,char* objname):
                WSCform(base,objname){

  _editor_hd = NULL;
  _dir_hd = NULL;
  _client = NULL;

  _client = NULL;
  _list = NULL;
  _darea1 = NULL;
//  _darea2 = NULL;
  _msg = NULL;
  _voidp_client = NULL;
  _opt1 = NULL;
  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient, void*,   _voidp_client,WSSclient );
    WSMFaddTrigger(WSEV_VALUE_CH     );
  WSMFpropertyCreateEnd

}

WSMFproperty( WSCprocedureEditor, WSNclient, void*,   _voidp_client,   NULL);

void WSCprocedureEditor::setWorkWSNwidth(WSCushort data){
  WSCform::setWorkWSNwidth(data);
  _adjust();
}
void WSCprocedureEditor::setWorkWSNheight(WSCushort data){
  WSCform::setWorkWSNheight(data);
  _adjust();
}
void WSCprocedureEditor::setWorkWSNshadowThickness(WSCuchar data){
  WSCform::setWorkWSNshadowThickness(data);
  _list->setProperty(WSNshadowThickness,data);
  _pmenu->setProperty(WSNshadowThickness,data);
}
void WSCprocedureEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;
  setEditClient(client);
  WSCbase* old = (WSCbase*)getUserData("PCLIENT");
  setUserData("PCLIENT",client);
  if (old != client && old != NULL){
//    old->setPropertyEditExecute(False);
  }
}

void WSCprocedureEditor::getWorkWSNclient(void** data){
  WSCbase* client = getEditClient();
  *data = (void*)client;
}


WSCprocedureEditor::~WSCprocedureEditor(){
}

void WSCprocedureEditor::_end_btn_work(WSCbase* obj){
  WSCprocedureEditor* op_edit =(WSCprocedureEditor*)obj->getUserData("OP EDIT");
  op_edit->setVisible(False);
}

void WSCprocedureEditor::setEditorExecuteHandler(void* hd){
  _editor_hd = hd;
}

void WSCprocedureEditor::setGetDirHandler(void* hd){
  _dir_hd = hd;
}

void WSCprocedureEditor::_fsbtn_work(WSCbase* obj){
  WSCprocedureEditor* op_edit=(WSCprocedureEditor*)obj->getUserData("OP EDIT");
  op_edit->_fs->setVisible(True);
}

void WSCprocedureEditor::_file_work(WSCbase* fs){
  WSCprocedureEditor* op_edit = (WSCprocedureEditor*)fs->getUserData("OP EDIT");
  WSCstring fname( fs->getProperty(WSNfileName) );
  fname.replaceString(".cpp","",1);
  fname.replaceString(".C","",1);
  fname.replaceString(".rb","",1);
  fname.replaceString(".py","",1);
  fname.replaceString(".pl","",1);

  WSCbase* win = NULL;
  if (op_edit->_client != NULL){
    win = op_edit->_client->getParentWindow();
  }
  if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) != 0){
    char buffer[128];
    sprintf(buffer,"%s_",win->getInstanceName());
    fname.replaceString(buffer,"",1);
    op_edit->_if3->setPropertyV(WSNlabelString,fname.getString());
  }else{
    op_edit->_if3->setPropertyV(WSNlabelString,fname.getString());
  }

}

void WSCprocedureEditor::_dialog_resize_work(WSCbase* obj){
  WSCbaseDialog* dialog = (WSCbaseDialog*)obj->cast("WSCbaseDialog");
  WSCprocedureEditor* ope = (WSCprocedureEditor*)
                              obj->getUserData("OP EDIT");
  if (dialog == NULL){
    return;
  }
  if (ope == NULL){
    return;
  }

  WSCushort w;
  WSCushort h;
  dialog->getPropertyV(WSNwidth,&w);
  dialog->getPropertyV(WSNheight,&h);
  if (w > 2){
    ope->_darea1->setPropertyV(WSNwidth,(WSCushort)(w-2));
//    ope->_darea2->setPropertyV(WSNwidth,(WSCushort)(w-2));
  }else{
    ope->_darea1->setPropertyV(WSNwidth,(WSCushort)(1));
//    ope->_darea2->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  long val = 45;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    val = 40;
  }
  if (h > val){
    ope->_darea1->setPropertyV(WSNheight,(WSCushort)(h-val));
  }else{
    ope->_darea1->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
void WSCprocedureEditor::_dialog_set_work(WSCbase* obj){
  WSCbaseDialog* dialog = (WSCbaseDialog*)obj->cast("WSCbaseDialog");
  if (dialog == NULL){
    return;
  }
  if (dialog->getStatus() != WS_DIALOG_OK){
    return;
  }
  WSCprocedureEditor* op_edit = (WSCprocedureEditor*)obj->getUserData("OP EDIT");
  long no = (long)op_edit->_dialog1->getUserData("PROCEDURE NO");
  WSCstring opname;
  opname.setString(op_edit->_if2->getProperty(WSNlabelString));
  opname.delLineFeed();
  opname.delHeadSpace();
  opname.delTailSpace();

  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)400);

  if (opname.getWords() != 1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("h3:WSSTR Invalid procedure name..."));
    op_edit->_msg->setVisible(True);
    return;
  }

  WSCstring pgname(op_edit->_if3->getProperty(WSNlabelString));
  pgname.delLineFeed();
  pgname.delHeadSpace();
  pgname.delTailSpace();
  pgname.replaceString(".cpp","",0);
  pgname.replaceString(".C","",0);
  pgname.replaceString(".rb","",0);
  pgname.replaceString(".py","",0);
  pgname.replaceString(".pl","",0);

  if (WSGFcheckNameString(pgname.getString()) != True){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("i3:WSSTR Invalid function name..."));
    op_edit->_msg->setVisible(True);
    return;
 
  }

  if (pgname.getWords() != 1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("j3:WSSTR Invalid procedure name..."));
    op_edit->_msg->setVisible(True);
    return;
  }

  if (WSGFcheckNameString(pgname.getString()) != True){
    long ret = WSGFexistName( pgname.getString(),NULL );
    if (ret == 0){
       //OK.
    }else if (ret == WS_PROCEDURE_NAME){
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("k3:WSSTR Invalid procedure name.\nAlready used by another procedure name."));
      op_edit->_msg->setVisible(True);
      return;
    }else if (ret == WS_OBJECT_NAME){
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Invalid procedure name.\nAlready used by another instance name."));
      op_edit->_msg->setVisible(True);
      return;
    }else if (ret == WS_OBJECT_ARRAY_NAME || ret == WS_OBJECT_ARRAY_NAME_INVALID){
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("m3:WSSTR Invalid procedure name.\nAlready used by another instance array name."));
      op_edit->_msg->setVisible(True);
      return;
    }
  }

  op_edit->_dialog1->setVisible(False);

  if (no == -1 && op_edit->_client != NULL){ //new prop...
    long val;
    op_edit->_opt1->getPropertyV(WSNvalue,&val);
    WSCprocedure* ac = new WSCprocedure(opname.getString(),val);

    ac->setFunction(_op_dummy,pgname.getString());

    if (op_edit->_use_file->getStatus() != False){
      ac->setUseFile(True);

      WSCbase* win = NULL;
      if (op_edit->_client != NULL){
        win = op_edit->_client->getParentWindow();
      }
      WSCstring fname;
      if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) == 0){
         fname =  op_edit->_if3->getProperty(WSNlabelString);
      }else{
        fname = win->getInstanceName();
        fname << "_" << op_edit->_if3->getProperty(WSNlabelString);
      }
      fname.delHeadSpace();
      fname.delTailSpace();
      fname.replaceString(".C","",0);
      fname.replaceString(".cpp","",0);
      fname.replaceString(".rb","",0);
      fname.replaceString(".py","",0);
      fname.replaceString(".pl","",0);

      char buffer[1024];
      long lang = WSGFgetLanguage();
      if (lang == WS_LANG_CPP){
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,"%s.cpp",fname.getString());
        }else{
          sprintf(buffer,"%s/%s.cpp",op_edit->getSrcPath(),fname.getString());
        }
        op_edit->_file_name.setString(buffer);
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.cpp..."),fname.getString());
        }else{
          sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.cpp..."),op_edit->getSrcPath(),fname.getString());
        }

      }else
      if (lang == WS_LANG_RUBY){
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,"%s.rb",fname.getString());
        }else{
          sprintf(buffer,"%s/%s.rb",op_edit->getSrcPath(),fname.getString());
        }
        op_edit->_file_name.setString(buffer);
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.rb..."),fname.getString());
        }else{
          sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.rb..."),op_edit->getSrcPath(),fname.getString());
        }

      }else
      if (lang == WS_LANG_PYTHON){
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,"%s.py",fname.getString());
        }else{
          sprintf(buffer,"%s/%s.py",op_edit->getSrcPath(),fname.getString());
        }
        op_edit->_file_name.setString(buffer);
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.py..."),fname.getString());
        }else{
          sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.py..."),op_edit->getSrcPath(),fname.getString());
        }
      }else
      if (lang == WS_LANG_PERL){
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,"%s.pl",fname.getString());
        }else{
          sprintf(buffer,"%s/%s.pl",op_edit->getSrcPath(),fname.getString());
        }
        op_edit->_file_name.setString(buffer);
        if (!strcmp(op_edit->getSrcPath(),"")){
          sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.pl..."),fname.getString());
        }else{
          sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.pl..."),op_edit->getSrcPath(),fname.getString());
        }
      }

      WSCbool fl = WSGFcheckExistFile(op_edit->_file_name.getString());


      if (fl == False){
        op_edit->_cbtn->execProcedure(WSEV_ACTIVATE);
      }
    }else{
      ac->setUseFile(False);
    }

    op_edit->_client->addProcedure(ac);
    WSGFmarkChanged(op_edit->_client);
    op_edit->updateProcedures();
  }else if (op_edit->_client != NULL){
    long val;
    op_edit->_opt1->getPropertyV(WSNvalue,&val);
    WSCprocedure* ac = op_edit->getSelectedProcedure();
    if (ac != NULL){
      ac->setProcName(opname.getString());
      ac->setTrigger(val);
      ac->setFunction(_op_dummy,pgname.getString());
      if (op_edit->_use_file->getStatus() != False){
        ac->setUseFile(True);
      }else{
        ac->setUseFile(False);
      }

      WSGFmarkChanged(op_edit->_client);
      op_edit->updateProcedures();
    }
  }
//  op_edit->execEventProc(WSEV_VALUE_CH,NULL);
  op_edit->onValueChange();

}

void WSCprocedureEditor::_op_dummy(WSCbase*){
}

void WSCprocedureEditor::_dialog_src_work(WSCbase* obj){
  WSCprocedureEditor* op_edit = (WSCprocedureEditor*)obj->getUserData("OP EDIT");
  WSCbase* win = NULL;
  if (op_edit->_client != NULL){
    win = op_edit->_client->getParentWindow();
  }
  WSCstring fname;
  if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) == 0){
    fname =  op_edit->_if3->getProperty(WSNlabelString);
  }else{
    fname = win->getInstanceName();
    fname << "_" << op_edit->_if3->getProperty(WSNlabelString);
  }
  fname.delHeadSpace();
  fname.delTailSpace();
  fname.replaceString(".C","",0);
  fname.replaceString(".cpp","",0);
  fname.replaceString(".rb","",0);
  fname.replaceString(".py","",0);
  fname.replaceString(".pl","",0);

  WSCbool ok = WSGFcheckNameString(fname.getString());
  if (ok == False){
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
    op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)350);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("n3:WSSTR Invalid function name."));
    op_edit->_msg->setVisible(True);
    return;
  }
  char buffer[1024];
  long lang = WSGFgetLanguage();
  if (lang == WS_LANG_CPP){
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,"%s.cpp",fname.getString());
    }else{
      sprintf(buffer,"%s/%s.cpp",op_edit->getSrcPath(),fname.getString());
    }
    op_edit->_file_name.setString(buffer);
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.cpp..."),
                     fname.getString());
    }else{
      sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.cpp..."),
                     op_edit->getSrcPath(),fname.getString());
    }

  }else
  if (lang == WS_LANG_RUBY){
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,"%s.rb",fname.getString());
    }else{
      sprintf(buffer,"%s/%s.rb",op_edit->getSrcPath(),fname.getString());
    }
    op_edit->_file_name.setString(buffer);
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.rb..."),
                     fname.getString());
    }else{
      sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.rb..."),
                     op_edit->getSrcPath(),fname.getString());
    }

  }else
  if (lang == WS_LANG_PYTHON){
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,"%s.py",fname.getString());
    }else{
      sprintf(buffer,"%s/%s.py",op_edit->getSrcPath(),fname.getString());
    }
    op_edit->_file_name.setString(buffer);
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.py..."),
                     fname.getString());
    }else{
      sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.py..."),
                     op_edit->getSrcPath(),fname.getString());
    }
  }else
  if (lang == WS_LANG_PERL){
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,"%s.pl",fname.getString());
    }else{
      sprintf(buffer,"%s/%s.pl",op_edit->getSrcPath(),fname.getString());
    }
    op_edit->_file_name.setString(buffer);
    if (!strcmp(op_edit->getSrcPath(),"")){
      sprintf(buffer,WSGFgettext("o3:WSSTR Create %s.pl..."),
                     fname.getString());
    }else{
      sprintf(buffer,WSGFgettext("p3:WSSTR Create %s/%s.pl..."),
                     op_edit->getSrcPath(),fname.getString());
    }

  }






  if ( (long)win->getUserData(WS_WIN_CLASS) != 0){ 
    WSCstring fn;
    fn.setString( op_edit->_if3->getProperty(WSNlabelString) );
    fn.delHeadSpace();
    fn.delTailSpace();
    fn.replaceString(".C","",0);
    fn.replaceString(".cpp","",0);
    fn.replaceString(".rb","",0);
    fn.replaceString(".py","",0);
    fn.replaceString(".pl","",0);
    long lang = WSGFgetLanguage();
    if (lang == WS_LANG_CPP){
      WSGFclassProcedureCreate(&op_edit->_file_data,fn.getString(),op_edit->_client->getClassName(),win->getInstanceName());
    }else
    if (lang == WS_LANG_RUBY){
    }else
    if (lang == WS_LANG_PYTHON){
    }else
    if (lang == WS_LANG_PERL){
    }
  }else{
    long lang = WSGFgetLanguage();
    if (lang == WS_LANG_CPP){
      WSGFopCreate(&op_edit->_file_data,fname.getString(),op_edit->_client->getClassName());
    }else
    if (lang == WS_LANG_RUBY){
      WSGFopCreateRb(&op_edit->_file_data,fname.getString(),op_edit->_client->getClassName());
    }else
    if (lang == WS_LANG_PYTHON){
      WSGFopCreatePy(&op_edit->_file_data,fname.getString(),op_edit->_client->getClassName());
    }else
    if (lang == WS_LANG_PERL){
      WSGFopCreatePerl(&op_edit->_file_data,fname.getString(),op_edit->_client->getClassName());
    }
  }
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,"");
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)450);
  op_edit->_msg->setPropertyV(WSNlabelString,buffer);
  op_edit->_msg->setPropertyV(WSNuserValue,(long)op_edit);
  long ret = op_edit->_msg->popup();

  if (ret != WS_DIALOG_OK){
    return;
  }

  WSCbool fl = WSGFcheckExistFile(op_edit->_file_name.getString());

  if (fl != False){
    char buffer[4192];
    sprintf(buffer,WSGFgettext("q3:WSSTR Overwrite existing file: %s?"),op_edit->_file_name.getString());
    op_edit->_msg->setPropertyV(WSNlabelString,buffer);
    op_edit->_msg->setPropertyV(WSNuserValue,(long)op_edit);
    ret = op_edit->_msg->popup();
    if (ret != WS_DIALOG_OK){
      return;
    }
  }

  WSDfile* file = WSDfile::getNewInstance();
  ret = file->open(op_edit->_file_name.getString(),"w");
  if (ret == WS_NO_ERR){
     file->write(op_edit->_file_data.getString(),
                 strlen(op_edit->_file_data.getString()));
     file->close();
  }
  delete file;
}

char* WSCprocedureEditor::getSrcPath(){
  if (_dir_hd != NULL){
    char* (*hd)() = (char*(*)())_dir_hd;
    return hd();
  }
  return "";
}
void WSCprocedureEditor::onVisibleChange(WSCbool fl){
  if (fl == False){
    if (_dialog1->getVisible() != False){
      _dialog1->setVisible(False);
    }
  }
  WSCform::onVisibleChange(fl);
}
void WSCprocedureEditor::_ibtn1_work(WSCbase* obj){
  WSCprocedureEditor* op_edit =(WSCprocedureEditor*)obj->getUserData("OP EDIT");

  if (op_edit->_client != NULL){
    op_edit->_if1->setPropertyV(WSNlabelString,
                             op_edit->_client->getInstanceName());
    op_edit->_if2->setPropertyV(WSNlabelString,"new_ep");
    op_edit->_if3->setPropertyV(WSNlabelString,"");
    op_edit->_opt1->setPropertyV(WSNvalue,(long)-1);
    op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("r3:WSSTR OK"));
    op_edit->_use_file->setStatus(True,False);
    op_edit->_dialog1->setUserData("PROCEDURE NO",(void*)-1);
    op_edit->_dialog1->setVisible(True);
  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
    op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)400);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Please specify a target instance."));
    op_edit->_msg->setVisible(True);
    return;
  }
  
}

void WSCprocedureEditor::_ibtn3_work(WSCbase* obj){
  WSCprocedureEditor* op_edit = (WSCprocedureEditor*)obj->getUserData("OP EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)400);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Please specify a target instance."));
    op_edit->_msg->popup();
    return;
  }
  long no = op_edit->getSelectedProc();
 
  if ( no == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("t3:WSSTR Please select a procedure."));
    op_edit->_msg->popup();
    return;
  }else{
    void (*hd)(WSCprocedureEditor*,char*) =
                  (void(*)(WSCprocedureEditor*,char*))op_edit->_editor_hd;
    WSCbase* win = NULL;
    if (op_edit->_client != NULL){
      win = op_edit->_client->getParentWindow();
    }
    WSCprocedure* ac = op_edit->getSelectedProcedure();
    if (ac != NULL){
      WSCstring fname;
      long lang = WSGFgetLanguage();
      if (lang == WS_LANG_CPP){
        if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) == 0){
          fname << ac->getFunctionName() << ".cpp";
        }else{
          fname = win->getInstanceName();
          fname << "_" << ac->getFunctionName() << ".cpp";
        }
      }else
      if (lang == WS_LANG_RUBY){
        if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) == 0){
          fname << ac->getFunctionName() << ".rb";
        }else{
          fname = win->getInstanceName();
          fname << "_" << ac->getFunctionName() << ".rb";
        }
      }else
      if (lang == WS_LANG_PYTHON){
        if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) == 0){
          fname << ac->getFunctionName() << ".py";
        }else{
          fname = win->getInstanceName();
          fname << "_" << ac->getFunctionName() << ".py";
        }
      }else
      if (lang == WS_LANG_PERL){
        if (win != NULL && (long)win->getUserData(WS_WIN_CLASS) == 0){
          fname << ac->getFunctionName() << ".pl";
        }else{
          fname = win->getInstanceName();
          fname << "_" << ac->getFunctionName() << ".pl";
        }
      }

//printf("WSCprocedureEditor:: pgname=#%s#\n",(char*)fname);
      if (hd != NULL){
        hd(op_edit,fname.getString());
      }
    }else{
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("u3:WSSTR The procedure does not exist."));
      op_edit->_msg->popup();
    }
    return;
  }
}

void WSCprocedureEditor::_ibtn4_work2(WSCbase* obj){
  WSGIappTimer()->addTriggerProc(_delay_work,WS250MS,obj);
}
void WSCprocedureEditor::_delay_work(unsigned char,void* ptr){
  _ibtn4_work((WSCbase*)ptr);
}
void WSCprocedureEditor::_ibtn4_work(WSCbase* obj){
  WSCprocedureEditor* op_edit = (WSCprocedureEditor*)obj->getUserData("OP EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,"");
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)400);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Please specify a target instance."));
    op_edit->_msg->popup();
    return;
  }
 
  if ( op_edit->getSelectedProc() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("t3:WSSTR Please select a procedure."));
    op_edit->_msg->popup();
    return;
  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX2);
    op_edit->_msg->setPropertyV(WSNtitleString,"");
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)350);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("v3:WSSTR Delete this procedure?"));
    long ret = op_edit->_msg->popup();
    if (ret == WS_DIALOG_OK){
      if (op_edit->_client != NULL){
        WSCprocedure* ac = op_edit->getSelectedProcedure();
        if (ac != NULL){
          op_edit->_client->delProcedure(ac);
          WSGFmarkChanged(op_edit->_client);
        }else{
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("u3:WSSTR The procedure does not exist."));
          op_edit->_msg->popup();
        }
        op_edit->updateProcedures();
      }
    }
    return;
  }
}

void WSCprocedureEditor::_ibtn2_work(WSCbase* obj){
  WSCprocedureEditor* op_edit = (WSCprocedureEditor*)obj->getUserData("OP EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,"");
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)400);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Please specify a target instance."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedProc() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("t3:WSSTR Please select a procedure."));
    op_edit->_msg->setVisible(True);
    return;
  }
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Please specify a target instance."));
    op_edit->_msg->setVisible(True);
    return;
  }
  WSCprocedure* ac = op_edit->getSelectedProcedure();
  if (ac != NULL){
    op_edit->_if2->setPropertyV(WSNlabelString,ac->getProcName());
    op_edit->_if3->setPropertyV(WSNlabelString,ac->getFunctionName());
    op_edit->_opt1->setPropertyV(WSNvalue,(long)ac->getTrigger());
    op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("Y3:WSSTR Update"));
    if (ac->getUseFile() != False){
      op_edit->_use_file->setStatus(True,False);
    }else{
      op_edit->_use_file->setStatus(False,False);
    }

    // -1 is first time
    op_edit->_dialog1->setUserData("PROCEDURE NO",(void*)op_edit->getSelectedProc());
    op_edit->_dialog1->setVisible(True);
  }else{
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("u3:WSSTR The procedure does not exist."));
    op_edit->_msg->popup();
  }
}

long WSCprocedureEditor::getSelectedProc(){
  return _list->getSelectedPos();
}
WSCprocedure* WSCprocedureEditor::getSelectedProcedure(){
//  long no = _list->getSelectedPos();
//  return getProcedure(no);
  WSCstring str = _list->getSelectedItem();
  WSCstring pname = str.getWord(0,",");
  WSCstring fname = str.getWord(2,",");
  WSClistData* op_list = _client->getProcedureList();
  long num = op_list->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (!strcmp(ac->getFunctionName(),(char*)fname) &&
        !strcmp(ac->getProcName(),(char*)pname)){
      return ac;
    }
  }
  return NULL;
}
WSCprocedure* WSCprocedureEditor::getProcedure(long no){
  WSClistData* op_list = _client->getProcedureList();
  long num = op_list->getNum();
  long i;
  long cnt=0;
  for(i=0; i<num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (cnt == no){
      return ac;
    }
    cnt++;
  }
  return NULL;
}

long WSCprocedureEditor::draw(){
  if (_no_refresh != False){
    WSCbase::update();
    setAbsoluteDraw(False);
    return WS_NO_ERR;
  }
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False  ){
    if (getDotMode() == False && _grad_no == 0){
      if ( dev->isExposed(0,0,_w,_shadow_thick) == False &&
           dev->isExposed(0,0,_shadow_thick,_h) == False &&
           dev->isExposed(_w -_shadow_thick,0,_shadow_thick,_h) == False &&
           dev->isExposed(0,_h -_shadow_thick,_w,_shadow_thick) == False ){
        return WS_NO_ERR;
      }
    }else{
      if ( dev->isExposed(0,0,_w,_h) == False ){
        return WS_NO_ERR;
      }
    }
  }
  long err = dev->beginDraw(0,0,_w,_h,absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = _w;
  WSCushort eh = _h;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  if (_bp_color == -1){
    if (_grad_no == 0){
      dev->setForeColor(_back_color);
      dev->drawFillRect(0,0,_w,_h);
    }else{
      dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,0,0,_w,_h,_grad_margin);
    }
  }
  if (getDotMode() == True){
    dev->setForeColor(_fore_color);
    long i,j;
    for(i=0; i<_w; i+=10){
      for(j=0; j<_h; j+=10){
        if (ex < i && i < ex+ ew &&
            ey < j && j < ey+ eh ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }
  dev->endDraw();
  return WS_NO_ERR;
}


long WSCprocedureEditor::initialize(){
  WSCform::initialize();

  setPropertyV(WSNx,     (short)5 );
  setPropertyV(WSNy,     (short)5 );
  setPropertyV(WSNwidth, (WSCushort)(WS_OLLB_W -10));
  setPropertyV(WSNheight,(WSCushort)(WS_OLLB_HEIGHT - 45));
//  setPropertyV(WSNshadowThickness,(WSCuchar)0);
//  setPropertyV(WSNforeColor,WSGFcolor("gray45"));
//  setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);

  long i;
  for(i=0; i<4; i++){
    WSCvfbtn* btn = new WSCvfbtn(this,"cs-vfbtn");
    btn->initialize();
    btn->setPropertyV(WSNx,(short)(i* 30));
    btn->setPropertyV(WSNy,(short)(1));
    btn->setPropertyV(WSNwidth,(WSCushort)(30));
    btn->setPropertyV(WSNheight,(WSCushort)(29));
    btn->setPropertyV(WSNlabelPixmap,pixmaps[i]);
    btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    btn->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    WSGFsetMargin(btn,0);
    btn->setUserData("OP EDIT",(void*)this); 

    WSCprocedure* op1 = new WSCprocedure("op1",WSEV_ACTIVATE);
    op1->setFunction(evprocs[i],"evprocs");
    btn->addProcedure(op1);
    btn->setVisible(True);
    WSGIappBalloonHelp()->registerClient(btn,WSGFgettext(bhelpstr[i]));
  }

  _list = new WSClist(this,"pe-area2");
  _list->initialize();
  _list->setInternalObject(True);
  _list->setPropertyV(WSNx,     (short)0 );
  _list->setPropertyV(WSNy,     (short)30 );
  _list->setPropertyV(WSNwidth, (WSCushort)(_w));
  _list->setPropertyV(WSNheight,(WSCushort)(_h -30));
  _list->setPropertyV(WSNworkWidth, (WSCushort)(WS_OLLB_W -20));
  _list->setPropertyV(WSNworkHeight,(WSCushort)1500);
  _list->setPropertyV(WSNscrollHeight,(WSCushort)5);
  _list->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _list->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _list->setPropertyV(WSNbarValue,"150,250");
  _list->setPropertyV(WSNtitleHeight,(WSCuchar)20);
  _list->setPropertyV(WSNtitleString,WSGFgettext("w3:WSSTR Procedure name,Trigger,Function name"));
  _list->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _list->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _list->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _list->setVisible(True);

  //Warning dialog
  _msg = new WSCmessageDialog(NULL,"wl-md");
  _msg->initialize();
  _msg->setPropertyV(WSNx,(short)300);
  _msg->setPropertyV(WSNy,(short)300);
  _msg->setPropertyV(WSNwidth,(WSCushort)400);
  _msg->setPropertyV(WSNheight,(WSCushort)120);
  _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  _msg->setPropertyV(WSNmodal,(WSCbool)True);

  //---------- PROCEDURE CREATE DIALOG -------------------- 

  //procedure setup dialog
  _dialog1 = new WSCbaseDialog(NULL,"dlg_base");
  _dialog1->initialize();
  _dialog1->setInternalObject(True);
  _dialog1->setPropertyV(WSNx,         (short)300                );
  _dialog1->setPropertyV(WSNy,         (short)300                );
  _dialog1->setPropertyV(WSNwidth,(WSCushort)WS_OLLD_WIDTH);
  _dialog1->setPropertyV(WSNheight,(WSCushort)WS_OLLD_HEIGHT);
  _dialog1->setPropertyV(WSNtitleString,"CreateProcedure");
  _dialog1->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/ope2.xpm");
  _dialog1->setPropertyV(WSNreplyHandler,(void*)_dialog_set_work);
  _dialog1->setPropertyV(WSNno,(WSCbool)False);
  _dialog1->setUserData("OP EDIT",(void*)this); 

  WSCprocedure* oprs = new WSCprocedure("op3",WSEV_RESIZE);
  oprs->setFunction(_dialog_resize_work,"_dialog_resize_work");
  _dialog1->addProcedure(oprs);


  _darea1 = new WSCform(_dialog1->getFormObject(),"pe-darea1");
  _darea1->initialize();
  _darea1->setInternalObject(True);
  _darea1->setPropertyV(WSNx,     (short)1 );
  _darea1->setPropertyV(WSNy,     (short)5 );
  _darea1->setPropertyV(WSNwidth, (WSCushort)(WS_OLLD_WIDTH -2));
  _darea1->setPropertyV(WSNheight,(WSCushort)(WS_OLLD_HEIGHT -75));
  _darea1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _darea1->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
  _darea1->setVisible(True);

  _if1 = new WSCvlabel(_darea1,"pe-tlb");
  _if1->initialize();
  _if1->setInternalObject(True);
  _if1->setPropertyV(WSNx,     (short)WS_OLLD_LX );
  _if1->setPropertyV(WSNy,     (short)5 );
  _if1->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_LWIDTH );
  _if1->setPropertyV(WSNheight,(WSCushort)20 );
  _if1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _if1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _if1->setVisible(True);

  WSCvlabel* sp1 = new WSCvlabel(_darea1,"pe-tlb");
  sp1->initialize();
  sp1->setInternalObject(True);
  sp1->setPropertyV(WSNx,     (short)0);
  sp1->setPropertyV(WSNy,     (short)30 );
  sp1->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp1->setPropertyV(WSNheight,(WSCushort)2 );
  sp1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp1->setVisible(True);


  _if2 = new WSCvifield(_darea1,"pe-tif2");
  _if2->initialize();
  _if2->setInternalObject(True);
  _if2->setPropertyV(WSNx,     (short)WS_OLLD_LX );
  _if2->setPropertyV(WSNy,     (short)35 );
  _if2->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_LWIDTH );
  _if2->setPropertyV(WSNheight,(WSCushort)20 );
//  _if2->setPropertyV(WSNcolumns,(WSCushort)18 );
//  _if2->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if2->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if2->setPropertyV(WSNfillSpace,(WSCbool)False);
  _if2->setPropertyV(WSNinterCur,(WSCbool)True);
  _if2->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _if2->setProperty(WSNenableFocusMove,(WSCbool)True);
  _if2->setVisible(True);

  //function name input field...
  _if3 = new WSCvifield(_darea1,"pe-tif3");
  _if3->initialize();
  _if3->setInternalObject(True);
  _if3->setPropertyV(WSNx,     (short)WS_OLLD_LX );
  _if3->setPropertyV(WSNy,     (short)(35 + WS_OLLD_T) );
  _if3->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_LWIDTH );
  _if3->setPropertyV(WSNheight,(WSCushort)20 );
//  _if3->setPropertyV(WSNcolumns,(WSCushort)16 );
//  _if3->setPropertyV(WSNmaxLength,(WSCushort)16 );
  _if3->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if3->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if3->setPropertyV(WSNfillSpace,(WSCbool)False);
  _if3->setPropertyV(WSNinterCur,(WSCbool)True);
  _if3->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _if3->setProperty(WSNenableFocusMove,(WSCbool)True);
  _if3->setProperty(WSNtab,"ope-use_file");
  _if3->setVisible(True);

  //trigger select
  _opt1 = new WSCoption(_darea1,"popt");
  _opt1->initialize();
  _opt1->setInternalObject(True);
  _opt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _opt1->setPropertyV(WSNx,(short)WS_OLLD_LX);
  _opt1->setPropertyV(WSNy,(short)(35 + WS_OLLD_T*2));
  _opt1->setPropertyV(WSNwidth,(WSCushort)WS_OLLD_LWIDTH);
  _opt1->setPropertyV(WSNheight,(WSCushort)20);
  _opt1->setPropertyV(WSNmenuItems,WS_OLLD_TGRMENU);
  _opt1->setPropertyV(WSNemboss,(WSCbool)True);
  _opt1->setVisible(True);
  WSGFsetMargin(_opt1,0);

  WSCvlabel* tlbs1 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs1->initialize();
  tlbs1->setPropertyV(WSNx,     (short)5 );
  tlbs1->setPropertyV(WSNy,     (short)5 );
  tlbs1->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_TWIDTH );
  tlbs1->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs1->setPropertyV(WSNforeColor,"black" );
  tlbs1->setPropertyV(WSNlabelString,WS_OLLDTITLE1);
  tlbs1->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  tlbs1->setVisible(True);
 
  WSCvlabel* tlbs2 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs2->initialize();
  tlbs2->setPropertyV(WSNx,     (short)5 );
  tlbs2->setPropertyV(WSNy,     (short)35 );
  tlbs2->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_TWIDTH );
  tlbs2->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs2->setPropertyV(WSNforeColor,"black" );
  tlbs2->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs2->setPropertyV(WSNlabelString,WS_OLLDTITLE2);
  tlbs2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  tlbs2->setVisible(True);
 
  WSCvlabel* tlbs3 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs3->initialize();
  tlbs3->setPropertyV(WSNx,     (short)5 );
  tlbs3->setPropertyV(WSNy,     (short)(35 + WS_OLLD_T*2) );
  tlbs3->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_TWIDTH );
  tlbs3->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs3->setPropertyV(WSNforeColor,"black" );
  tlbs3->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs3->setPropertyV(WSNlabelString,WS_OLLDTITLE3);
  tlbs3->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  tlbs3->setVisible(True);

  WSCvlabel* tlbs5 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs5->initialize();
  tlbs5->setPropertyV(WSNx,     (short)5 );
  tlbs5->setPropertyV(WSNy,     (short)(35 + WS_OLLD_T*1) );
  tlbs5->setPropertyV(WSNwidth, (WSCushort)WS_OLLD_TWIDTH );
  tlbs5->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs5->setPropertyV(WSNforeColor,"black" );
  tlbs5->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs5->setPropertyV(WSNlabelString,WS_OLLDTITLE5);
  tlbs5->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  tlbs5->setVisible(True);
 
      //-------END BTN SETTING ---------//

  _fsbtn = new WSCvbtn(_darea1,"pe-dset-btn");
  _fsbtn->initialize();
  _fsbtn->setInternalObject(True);
  _fsbtn->setPropertyV(WSNx,         (short)(WS_OLLD_WIDTH-220));
  _fsbtn->setPropertyV(WSNy,         (short)(35 + WS_OLLD_T*3)  );
  _fsbtn->setPropertyV(WSNwidth,     (WSCushort)100       );
  _fsbtn->setPropertyV(WSNheight,    (WSCushort)23        );
  _fsbtn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _fsbtn->setPropertyV(WSNlabelString,WSGFgettext("x3:WSSTR File..."));
  _fsbtn->setUserData("OP EDIT",(void*)this); 
  WSGFsetMargin(_fsbtn,0);

  WSCprocedure* op3 = new WSCprocedure("op3",WSEV_ACTIVATE);
  op3->setFunction(_fsbtn_work,"_fsbtn_work");
  _fsbtn->addProcedure(op3);
  _fsbtn->setVisible(True);

  _cbtn = new WSCvbtn(_darea1,"pe-dset-btn");
  _cbtn->initialize();
  _cbtn->setInternalObject(True);
  _cbtn->setPropertyV(WSNx,         (short)(WS_OLLD_WIDTH-120));
  _cbtn->setPropertyV(WSNy,         (short)(35 + WS_OLLD_T*3)  );
  _cbtn->setPropertyV(WSNwidth,     (WSCushort)100       );
  _cbtn->setPropertyV(WSNheight,    (WSCushort)23        );
  _cbtn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cbtn->setPropertyV(WSNlabelString,WSGFgettext("y3:WSSTR Template"));
  _cbtn->setUserData("OP EDIT",(void*)this); 
  WSGFsetMargin(_cbtn,0);
  _cbtn->setVisible(True);

  WSCprocedure* dop2 = new WSCprocedure("dop2",WSEV_ACTIVATE);
  dop2->setFunction(_dialog_src_work,"_dialog_src_work");
  _cbtn->addProcedure(dop2);

  _use_file = new WSCvtoggle(_darea1,"ope-use_file");
  _use_file->initialize();
  _use_file->setInternalObject(True);
  _use_file->setPropertyV(WSNx, (short)5);
  _use_file->setPropertyV(WSNy, (short)(35 + WS_OLLD_T*3)  );
  _use_file->setPropertyV(WSNwidth, (WSCushort)110);
  _use_file->setPropertyV(WSNheight,(WSCushort)24);
  _use_file->setPropertyV(WSNlabelString, WSGFgettext("z3:WSSTR Internal"));
  _use_file->setPropertyV(WSNmarginLeft, (WSCuchar)10);
  _use_file->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
  _use_file->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
  _use_file->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
  _use_file->setPropertyV(WSNindicatorType,WS_IN);
  _use_file->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  _use_file->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _use_file->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _use_file->setProperty(WSNbacktab,"pe-tif3");
  _use_file->setVisible(True);

  _fs = new WSCfileSelect(NULL,"wl-fs");
  _fs->initialize();
  _fs->setPropertyV(WSNx,(short)300);
  _fs->setPropertyV(WSNy,(short)300);
  _fs->setPropertyV(WSNreplyHandler,(void*)WSCprocedureEditor::_file_work);
  _fs->setUserData("OP EDIT",(void*)this); 

  _pmenu = new WSCpopupMenu(NULL,"menu");
  _pmenu->initialize();
  _pmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  _pmenu->setPropertyV(WSNmenuItems,"");
  _pmenu->setPropertyV(WSNmenuItems,WSGFgettext("A3:WSSTR New:NEW:,Properties:SET:,Edit procedure:EDIT:,Delete procedure:DEL:"));
  _pmenu->setEmboss(True);
  _pmenu->setUserData("OP EDIT",(void*)this);
   
  WSCprocedure* pmop = new WSCprocedure("NEW",WSEV_NONE);
  pmop->setFunction(_ibtn1_work,"_ibtn1_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("SET",WSEV_NONE);
  pmop->setFunction(_ibtn2_work,"_ibtn2_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("EDIT",WSEV_NONE);
  pmop->setFunction(_ibtn3_work,"_ibtn3_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(_ibtn4_work2,"_ibtn4_work2");
  _pmenu->addProcedure(pmop);

  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);
  
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  return WS_NO_ERR;
}

void WSCprocedureEditor::setEditClient(WSCbase* client){
  if (_client != client){
     _client = client;
     updateProcedures();
  }
}

WSCbase* WSCprocedureEditor::getEditClient(){
  return _client;
}

void WSCprocedureEditor::updateProcedures(){
  _list->delAll();
  long i;
  WSCbase* client = getEditClient();
  if (client != NULL){
    WSCstring menustr;
    menustr << WS_OLLD_TGRMENU;
    WSCindexData* etlist = client->getExtTriggerList();
    long etnum = etlist->getNum();
    for(i=0; i< etnum; i++){
      menustr << "," << etlist->getIndex(i) << ":" << (long)etlist->getData(i) <<":";
    }
    _opt1->setProperty(WSNmenuItems,menustr);

    long t=0;
    while(1){
      if (trgs[t] == -2){
        break;
      }
      _opt1->setSelectValue(trgs[t],client->existTrigger(trgs[t]));
      t++;
    }
  }

  if (client == NULL){
    _if1->setPropertyV(WSNlabelString,"");
    _if1->update();
    _list->redraw();
    _dialog1->setVisible(False);
    return;
  }

  _if1->setPropertyV(WSNlabelString,client->getInstanceName());
  _if1->update();
  _dialog1->setVisible(False);

  WSClistData* op_list = client->getProcedureList();
  long num = op_list->getNum();
  _list->setLabelHeight(20);
  for(i=0; i< num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
//printf("WSCprocedureEditor::updateProc %d %s internal=%d\n",i,ac->getProcName(),ac->getInternal());
    if (ac->getInternal() != False){
      continue;
    }
    WSCstring tmp(ac->getProcName());
    tmp << "," << trgtoname( ac->getTrigger(),client);
    tmp << "," << ac->getFunctionName();
    _list->addItem((char*)tmp);
    WSCbase* lb = _list->getLabel(-1);
    lb->setPropertyV(WSNmarginLeft,(WSCuchar)5);
    _pmenu->registerClient(lb);

    WSCprocedure* op = new WSCprocedure("label_selected",WSEV_ACTIVATE);
    op->setFunction(_lb_press,"WSCinspector::_lb_press");
    lb->addProcedure(op);
    lb->setUserData("this",(void*)this);
  }
  _list->updateList();
  _list->redraw();
}

void WSCprocedureEditor::_lb_press(WSCbase* lb){
  static long time = 0;
  long time2 = WSGFclocktime();
  long diff = time2 - time;
  time = time2;

  if (diff < WS_DOUBLE_CLICK_TIME){
    WSCprocedureEditor* obj = (WSCprocedureEditor*)lb->getUserData("this");
    _ibtn3_work(obj->_pmenu);
  }

}
void WSCprocedureEditor::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}

void WSCprocedureEditor::_adjust(){
  if (_list == NULL){
    return;
  }
  _list->setPropertyV(WSNwidth,(WSCushort)_w);

  if (_h > 30){
    _list->setPropertyV(WSNheight,(WSCushort)(_h -30));
  }else{
    _list->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
void WSCprocedureEditor::createNewProc(){
  _ibtn1_work(_pmenu);
}
void WSCprocedureEditor::editProc(){
  _ibtn2_work(_pmenu);
}
void WSCprocedureEditor::execEditor(){
  _ibtn3_work(_pmenu);
}
void WSCprocedureEditor::deleteProc(){
  _ibtn4_work(_pmenu);
}
void WSCprocedureEditor::onGuiPolicyChange(long policy){
  if (_opt1 != NULL){
    WSCform::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_GRADATION){
      _opt1->setProperty(WSNgradation,WS_GR_T_B);
      _fsbtn->setProperty(WSNgradation,WS_GR_T_B);
      _cbtn->setProperty(WSNgradation,WS_GR_T_B);
    }else{
      _opt1->setProperty(WSNgradation,WS_GR_NONE);
      _fsbtn->setProperty(WSNgradation,WS_GR_NONE);
      _cbtn->setProperty(WSNgradation,WS_GR_NONE);
    }
    if (policy & WS_POLICY_ORIGINAL){
      _darea1->setProperty(WSNy,5 );
      _darea1->setProperty(WSNshadowThickness,1);
//      _darea2->setProperty(WSNy,5);
//      _darea2->setProperty(WSNshadowThickness,1);
    }else
    if (policy & WS_POLICY_WINDOWS){
      _darea1->setProperty(WSNy,0 );
      _darea1->setProperty(WSNshadowThickness,0);
//      _darea2->setProperty(WSNy,0);
//      _darea2->setProperty(WSNshadowThickness,0);
    }
    _dialog_resize_work((WSCbase*)_dialog1);
  }
}
