//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvtimer.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvtimer, WSCngbase);
WSMFversion(WSCvtimer, WSCngbase);

WSCvtimer::WSCvtimer(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _timer = NULL;
  _rate = 1000;
  _title_string.setString("Timer\n");
  _title_string << _rate << "ms";
  _on = 0;
  _cont = 1;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvtimer);

    WSMFpropertyCreate(WSNinterval,      WSCulong,   _rate,WSSinterval);
    WSMFpropertyCreate(WSNcont,      WSCbool,   _cont,WSScont);
      WSMFpropertySetSelection(WSRbool, WSRboolD);
    WSMFpropertyCreate(WSNrunning,      WSCbool,   _on,WSSrunning);
      WSMFpropertySetSelection(WSRbool3, WSRbool3D);

    WSMFaddTrigger(WSEV_ACTIVATE  );


  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvtimer, WSNinterval, WSCulong, _rate ,1000);
WSMFproperty( WSCvtimer, WSNcont, WSCbool, _cont ,1);
WSMFproperty( WSCvtimer, WSNrunning, WSCbool, _on ,0);
void WSCvtimer::setWorkWSNinterval(WSCulong){
  if (_timer != NULL){
//    if (_on != 0){
//      _timer->stopTimer();
//      _on = 0;
      _timer->setRate(_rate);
//      _timer->startTimer();
//      _on = 1;
//    }
  }
  _title_string.setString("Timer\n");
  _title_string << _rate << "ms";
};
void WSCvtimer::getWorkWSNinterval(WSCulong*){};
void WSCvtimer::setWorkWSNcont(WSCbool){
  if (_timer != NULL){
//    if (_on != 0){
//      _timer->stopTimer();
//      _on = 0;
      _timer->setCont(_cont);
//      _timer->startTimer();
//      _on = 1;
//    }
  }
};
void WSCvtimer::getWorkWSNcont(WSCbool*){};
void WSCvtimer::setWorkWSNrunning(WSCbool){
  if (getPropertyEditMode() != False){
    return;
  }
  if (_timer == NULL){
    _timer = WSDprivateTimer::getNewInstance();
    if (_timer != NULL){
      _timer->setWorkProc(_timer_proc,(void*)this);
    }
  }
  if (_timer != NULL){
    if (_on != 0){
      _timer->setCont(_cont);
      _timer->setRate(_rate);
      _timer->startTimer();
    }else{
      _timer->stopTimer();
    }
  }
};
void WSCvtimer::getWorkWSNrunning(WSCbool*){};

void WSCvtimer::_timer_proc(void* ptr){
  WSCvtimer* _this = (WSCvtimer*)ptr;
  if (_this->_cont == 0){
    _this->_on = 0;
  }
  _this->onActivate();
}
void WSCvtimer::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}
WSCvtimer::~WSCvtimer() {
  if (_timer != NULL){
    delete _timer;
    _timer = NULL;
  }
}

