//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvclock.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCimageSet.h>
#include <WSDkeyboard.h>
#include <WSDtimer.h>
#include <WSCfontSet.h>
#include <WSClocaleSet.h>
static char *_week_days[] = {
"H:WSSTR SUN",
"I:WSSTR MON",
"J:WSSTR TUE",
"K:WSSTR WED",
"L:WSSTR THU",
"M:WSSTR FRI",
"N:WSSTR SAT"
};
static char *_time_labels[] = {
"O:WSSTR A.M.",
"P:WSSTR P.M.",
"Q:WSSTR AM",
"R:WSSTR PM"
};

WSMFguiClassInitialize(WSCvclock,WSCvlabel);
WSMFversion(WSCvclock,WSCvlabel);

WSMFpropertyValueChange(WSCvclock,WSNusePixmap,char,True);

WSCvclock::WSCvclock(WSCbase* base,char* objname): WSCvlabel(base,objname){
  _date_fmt = 1;
  _week_fmt = 2;
  _clock_fmt = 3;
  _show_sec = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvclock);

    WSMFpropertyCreate(WSNdateFormat, WSCuchar, _date_fmt,WSSdateFormat );
      WSMFpropertySetSelection(WSRdateFormat,WSRdateFormatD);
    WSMFpropertyCreate(WSNweekFormat, WSCuchar, _week_fmt,WSSweekFormat );
      WSMFpropertySetSelection(WSRweekFormat,WSRweekFormatD);
    WSMFpropertyCreate(WSNclockFormat,WSCuchar, _clock_fmt,WSSclockFormat);
      WSMFpropertySetSelection(WSRclockFormat,WSRclockFormatD);
    WSMFpropertyCreate(WSNsecondOn,WSCbool,_show_sec,WSSsecondOn);
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyValueChangeDef(WSCvclock,WSNusePixmap,char);

    WSMFpropertyVisibleOff(WSNlabelString);
    WSMFpropertyDelete(WSNorientation);
    WSMFpropertyDelete(WSNmaxLength);

  WSMFpropertyCreateEnd
  _fmt_handler = NULL;
  _clock_update_id = WSGIappTimer()->addTimerProc(_clock_handler,WS250MS,this);
}

WSMFproperty( WSCvclock, WSNdateFormat, WSCuchar, _date_fmt,   1 );
WSMFproperty( WSCvclock, WSNweekFormat, WSCuchar, _week_fmt,   2 );
WSMFproperty( WSCvclock, WSNclockFormat,WSCuchar, _clock_fmt,  3 );
WSMFproperty( WSCvclock, WSNsecondOn,   WSCbool, _show_sec,    0 );

void WSCvclock::setWorkWSNdateFormat(WSCuchar ){}
void WSCvclock::getWorkWSNdateFormat(WSCuchar*){}
void WSCvclock::setWorkWSNweekFormat(WSCuchar ){}
void WSCvclock::getWorkWSNweekFormat(WSCuchar*){}
void WSCvclock::setWorkWSNclockFormat(WSCuchar ){}
void WSCvclock::getWorkWSNclockFormat(WSCuchar*){}
void WSCvclock::setWorkWSNsecondOn(WSCbool ){}
void WSCvclock::getWorkWSNsecondOn(WSCbool*){}

WSCvclock::~WSCvclock(){
  WSGIappTimer()->delTimerProc(_clock_update_id);
}

void WSCvclock::_clock_handler(WSCuchar,void* ptr){
  WSCvclock* obj = (WSCvclock*)ptr;
  char buf[256];
  char buf_date[64];
  char buf_week[64];
  char buf_clock[64];
  char buf_second[64];

  long timeval[7];
  WSGFgettimeofday(timeval);

  if (obj->_fmt_handler != NULL){
    char bufer[4096];
    obj->_fmt_handler(timeval,bufer,4096);
    obj->setPropertyV(WSNlabelString,bufer);
    obj->setAbsoluteDraw(True);
    if (obj->_shadow_type == WS_SHADOW_TRANS){
      obj->redraw();
    }else{
      obj->draw();
    }
    return;
  }

  switch (obj->_date_fmt){
    case  0:
      sprintf(buf_date,"");
      break;
    case  1:
      {
        if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_EUCJP ||
            WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_SJIS){
          //Japanese
          sprintf(buf_date,WSGFgettext("S:WSSTR %2d/%2d/%4d"),timeval[0]-1988,timeval[1],timeval[2]);
        }else{
          //C
          sprintf(buf_date,WSGFgettext("S:WSSTR %2d/%2d/%4d"),timeval[1],timeval[2],timeval[0]);
        }
      }
      break;
    case  2:
      sprintf(buf_date,WSGFgettext("T:WSSTR %4d/%2d/%2d"),timeval[0],timeval[1],timeval[2]);
      break;
    case  3:
      {
        if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_EUCJP ||
            WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_SJIS){
          //Japanese
          sprintf(buf_date,WSGFgettext("U:WSSTR %2d/%2d/%2d"),timeval[0]%100, timeval[1],timeval[2]);
        }else{
          //C
          sprintf(buf_date,WSGFgettext("U:WSSTR %2d/%2d/%2d"), timeval[1],timeval[2], timeval[0]%100);
        }
      }
      break;
    case  4:
      {
        if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_EUCJP ||
            WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_SJIS){
          //Japanese
          sprintf(buf_date,WSGFgettext("V:WSSTR %2d/%2d/%2d"),timeval[0]-1988,timeval[1],timeval[2]);
        }else{
          //C
          sprintf(buf_date,WSGFgettext("V:WSSTR %2d/%2d/%2d"),timeval[0],timeval[1],timeval[2]);
        }
      }
      break;
    case  5:
      {
        if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_EUCJP ||
            WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_SJIS){
          //Japanese
          sprintf(buf_date,WSGFgettext("W:WSSTR %2d/%2d/%4d"), timeval[0],timeval[1],timeval[2]);
        }else{
          //C
          sprintf(buf_date,WSGFgettext("W:WSSTR %2d/%2d/%4d"), timeval[2],timeval[1],timeval[0]);
        }
      }
      break;
    case  6:
      {
        if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_EUCJP ||
            WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_SJIS){
          //Japanese
          sprintf(buf_date,"%2d/%2d/%2d", timeval[0]%100,timeval[1],timeval[2]);
        }else{
          //C
          sprintf(buf_date,"%2d/%2d/%2d", timeval[2],timeval[1],timeval[0]%100);
        }
      }
      break;
    default:
      {
        if (WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_EUCJP ||
            WSGIappLocaleSet()->getSystemLocaleEncoding() == WS_EN_SJIS){
          //Japanese
          sprintf(buf_date,WSGFgettext("X:WSSTR %4d/%2d/%2d"), timeval[0]-1988,timeval[1],timeval[2]);
        }else{
          //C
          sprintf(buf_date,WSGFgettext("X:WSSTR %4d/%2d/%2d"), timeval[0],timeval[1],timeval[2]);
        }
      }
  }

  switch (obj->_week_fmt){
    case  0:
      sprintf(buf_week,"");
      break;
    case  1:
      sprintf(buf_week,WSGFgettext("Y:WSSTR  %s "),WSGFgettext(_week_days[timeval[6]]));
      break;
    case  2:
      sprintf(buf_week,"(%s)",WSGFgettext(_week_days[timeval[6]]));
      break;
    default:
      sprintf(buf_week,"(%s)",WSGFgettext(_week_days[timeval[6]]));
  }
  switch (obj->_clock_fmt){
    case  0:
      sprintf(buf_clock,"");
      break;
    case  1:
      sprintf(buf_clock,WSGFgettext("Z:WSSTR %2d:%2d"), ((timeval[3] > 11) ? timeval[3]-12 : timeval[3]),timeval[4]);
      break;
    case  2:
      sprintf(buf_clock,WSGFgettext("Z:WSSTR %2d:%2d"),timeval[3],timeval[4]);
      break;
    case  3:
      sprintf(buf_clock,WSGFgettext("a:WSSTR %s %2d:%2d"),
               WSGFgettext(_time_labels[((timeval[3] > 11) ? 1 : 0)]), ((timeval[3] > 11) ? timeval[3]-12 : timeval[3]),timeval[4]);
      break;
    case  4:
      sprintf(buf_clock,"%2d:%02d",
              ((timeval[3] > 11) ? timeval[3]-12 : timeval[3]),timeval[4]);
      break;
    case  5:
      sprintf(buf_clock,"%2d:%02d",timeval[3],timeval[4]);
      break;
    case  6:
      sprintf(buf_clock,"%s%2d:%02d",
                WSGFgettext(_time_labels[((timeval[3] > 11) ? 3 : 2)]),
                ((timeval[3] > 11) ? timeval[3]-12 : timeval[3]),timeval[4]);
      break;
    default:
      sprintf(buf_clock,WSGFgettext("a:WSSTR %s %2d:%2d"),
        WSGFgettext(_time_labels[((timeval[3] > 11) ? 1 : 0)]),
       ((timeval[3] > 11) ? timeval[3]-12 : timeval[3]),timeval[4]);
  }

  if (obj->_clock_fmt == 0){
    buf_second[0] = 0;
  }else{
    switch (obj->_show_sec){
      case  0:
        buf_second[0] = 0;
        break;
      case  1:
        switch (obj->_clock_fmt){
          case  1:
          case  2:
          case  3:
            sprintf(buf_second,WSGFgettext("b:WSSTR :%2d"),timeval[5]);
            strcat(buf_clock, buf_second);
            break;
          case  4:
          case  5:
          case  6:
            sprintf(buf_second,":%02d",timeval[5]);
            strcat(buf_clock, buf_second);
            break;
          default:
            sprintf(buf_second,WSGFgettext("b:WSSTR :%2d"),timeval[5]);
            strcat(buf_clock, buf_second);
        }
        break;
      default:
        sprintf(buf_second,"");
    }
  }
  strcpy(buf, buf_date);
  if ((strlen(buf) != 0) && (strlen(buf_week) != 0)){
    strcat(buf, " ");
  }
  strcat(buf, buf_week);
  if ((strlen(buf) != 0) && (strlen(buf_clock) != 0)){
    strcat(buf, " ");
  }
  strcat(buf, buf_clock);
  obj->setPropertyV(WSNlabelString,buf);
  obj->setAbsoluteDraw(True);
  if (obj->_shadow_type == WS_SHADOW_TRANS){
    obj->redraw();
  }else{
    obj->draw();
  }
}

