//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvgraphScale.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvgraphScale, WSCnwbase);
WSMFversion(WSCvgraphScale, WSCnwbase);

WSCvgraphScale::WSCvgraphScale(WSCbase* base, char* objname):
			WSCnwbase(base, objname){
  _values = WSGFstrdup("0,1,2,3,4,5,6,7,8,9,10");
  _barw = WSGFstrdup("10,5,5,5,5,10,5,5,5,5,10");
  _orientation  = WS_HORIZONTAL;
  _rev = False;
  _num = 11;
  _lw = 2;
  _lt = 0;
  _margin = 10;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvgraphScale);

    WSMFpropertyCreate(WSNvalue,  char*,   _values,WSSvalue);
    WSMFpropertyCreate(WSNcolumns, WSCushort, _num,WSScolumns);
    WSMFpropertyCreate(WSNbarThickness, char*, _barw,WSSbarThickness);
    WSMFpropertyCreate(WSNorientation,  WSCuchar, _orientation,WSSorientation);
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);
    WSMFpropertyCreate(WSNreverseFlag,  WSCbool, _rev,WSSreverseFlag);
      WSMFpropertySetSelection(WSRbool, WSRboolD);
    WSMFpropertyCreate(WSNlineWidth, WSCuchar, _lw,WSSlineWidth);
    WSMFpropertyCreate(WSNlineType,  WSCuchar, _lt,WSSlineType);
      WSMFpropertySetSelection(WSRlineType, WSRlineTypeD);
    WSMFpropertyCreate(WSNmargin,WSCuchar,_margin,WSSmargin);
    WSMFpropertyCreate(WSNfont,         WSCuchar,   _font,WSSfont  );
 
  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvgraphScale, WSNvalue, char*, _values ,WSGFstrdup("0,1,2,3,4,5,6,7,8,9,10"));
WSMFproperty( WSCvgraphScale, WSNcolumns, WSCushort, _num ,11);
WSMFproperty( WSCvgraphScale, WSNbarThickness, char*, _barw , WSGFstrdup("10,5,5,5,5,10,5,5,5,5,10"));
WSMFproperty( WSCvgraphScale, WSNorientation, WSCuchar, _orientation ,WS_HORIZONTAL);
WSMFproperty( WSCvgraphScale, WSNreverseFlag, WSCbool, _rev ,False);
WSMFproperty( WSCvgraphScale, WSNlineWidth, WSCuchar, _lw, 2);
WSMFproperty( WSCvgraphScale, WSNlineType,  WSCuchar,      _lt, 0);
WSMFproperty( WSCvgraphScale, WSNmargin,  WSCuchar,  _margin,10);
WSMFproperty( WSCvgraphScale, WSNfont,        WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());



void WSCvgraphScale::setWorkWSNvalue(char*){};
void WSCvgraphScale::getWorkWSNvalue(char**){};
void WSCvgraphScale::setWorkWSNcolumns(WSCushort){};
void WSCvgraphScale::getWorkWSNcolumns(WSCushort*){};
void WSCvgraphScale::setWorkWSNbarThickness(char*){};
void WSCvgraphScale::getWorkWSNbarThickness(char**){};
void WSCvgraphScale::setWorkWSNorientation(WSCuchar){};
void WSCvgraphScale::getWorkWSNorientation(WSCuchar*){};
void WSCvgraphScale::setWorkWSNreverseFlag(WSCbool){};
void WSCvgraphScale::getWorkWSNreverseFlag(WSCbool*){};
void WSCvgraphScale::setWorkWSNlineWidth(WSCuchar){ }
void WSCvgraphScale::getWorkWSNlineWidth(WSCuchar*){ }
void WSCvgraphScale::setWorkWSNlineType(WSCuchar){ }
void WSCvgraphScale::getWorkWSNlineType(WSCuchar*){ }
void WSCvgraphScale::setWorkWSNmargin(WSCuchar){ }
void WSCvgraphScale::getWorkWSNmargin(WSCuchar*){ }
void WSCvgraphScale::setWorkWSNfont(WSCuchar){ }
void WSCvgraphScale::getWorkWSNfont(WSCuchar*){ }

WSCvgraphScale::~WSCvgraphScale() {
  if (_values != NULL){
    delete _values;
    _values = NULL;
  }
  if (_barw != NULL){
    delete _barw;
    _barw = NULL;
  }
}

long WSCvgraphScale::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (_num == 0){
    return WS_NO_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;
  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
     return WS_NO_ERR;
  }
  if (_orientation == WS_VERTICAL){
    h -= _lw;
  }else{
    w -= _lw;
  }
  long i;
  WSCushort interval = h/_num;
  if (_orientation != WS_VERTICAL){
    interval = w/_num;
  }

  WSCstring vlist(_values);
  WSCstring blist(_barw);
  long lnum = blist.getWords(",");
  long num = _num;
  if (lnum < _num){
    num = lnum;
  }
  dev->setLineWidth(_lw);
  dev->setHatchPattern(0);
  dev->setForeColor(_fore_color);
  dev->setLineDashType(_lt);

  WSDfont* fn = WSGIappFontSet()->getFont(_font);
  if (_orientation == WS_VERTICAL){
    if (_rev == False){
      dev->drawLine(w - _lw/2,interval/2,w - _lw/2, interval/2 + interval*(_num-1)+_lw/2);
    }else{
      dev->drawLine(_lw/2,interval/2,_lw/2, interval/2 + interval*(_num-1)+_lw/2);
    }
    for(i=0; i<num; i++){
      WSCstring tmp = blist.getWord(i,",");
      long val = atoi(tmp);
      if (val > 0){
        if (_rev == False){
          dev->drawLine(w - _lw/2,interval/2+_lw/2 + interval*i,w - val,interval/2+ _lw/2 + interval*i);
        }else{
          dev->drawLine(_lw/2,interval/2+_lw/2 + interval*i,val,interval/2+ _lw/2 + interval*i);
        }
      }
      WSCstring tmp2 = vlist.getWord(i,",");

      long fh = fn->getStringHeight(&tmp2);
      if (_rev == False){
        dev->drawString(w - _margin,interval/2 + _lw/2 + interval*i - fh/2,100,100,
                        &tmp2,_font,WS_LEFT_TOP,-1,False);
      }else{
        dev->drawString(_margin,interval/2 + _lw/2 + interval*i - fh/2,100,100,
                        &tmp2,_font,WS_LEFT_TOP,-1,False);
      }
    }
  }else{
    if (_rev == False){
      dev->drawLine(interval/2,_lw/2, interval/2 + interval*(_num-1)+_lw/2,_lw/2);
    }else{
      dev->drawLine(interval/2,h - _lw/2,interval/2 + interval*(_num-1)+_lw/2,h -_lw/2);
    }
    for(i=0; i<num; i++){
      WSCstring tmp = blist.getWord(i,",");
      long val = atoi(tmp);
      if (val > 0){
        if (_rev == False){
          dev->drawLine(interval/2 + interval*i + _lw/2,
                        _lw/2,
                        interval/2 + interval*i + _lw/2,
                        val);
        }else{
          dev->drawLine(interval/2 + interval*i + _lw/2,
                        h - _lw/2,
                        interval/2 + interval*i + _lw/2,
                        h - val);
        }
      }
      WSCstring tmp2 = vlist.getWord(i,",");

      long fw = fn->getStringWidth(&tmp2);
      if (_rev == False){
        dev->drawString( interval/2 + interval*i + _lw/2 - fw/2,_margin,100,100,
                        &tmp2,_font,WS_LEFT_TOP,-1,False);
      }else{
        dev->drawString( interval/2 + interval*i + _lw/2 - fw/2,h - _margin,100,100,
                        &tmp2,_font,WS_LEFT_TOP,-1,False);
      }
    }
  }

  dev->endDraw();
  return WS_NO_ERR;
}



