//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCRtextField.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCtextField.h>

WSMFclassInit(WSCRtextField,WSCRform);
WSMFremoteClassInit(WSCRtextField,WSCtextField);

WSCRtextField::WSCRtextField(){
}

WSCRtextField::~WSCRtextField(){
}

void WSCRtextField::onActivate(){
  if (_local != NULL){
    WSCtextField* item = (WSCtextField*)_local->cast("WSCtextField");
    if (item != NULL){
      item->onActivate();
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCtextField");
  rc.setOperationName("onActivate");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  endRemoteCall();
}
void WSCRtextField::onValueChange(){
  if (_local != NULL){
    WSCtextField* item = (WSCtextField*)_local->cast("WSCtextField");
    if (item != NULL){
      item->onValueChange();
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCtextField");
  rc.setOperationName("onValueChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  endRemoteCall();
}
WSCstring WSCRtextField::getSelectedString(){
  if (_local != NULL){
    WSCtextField* target = (WSCtextField*)_local->cast("WSCtextField");
    if (target != NULL){
      return target->getSelectedString();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCtextField");
  rc.setOperationName("getSelectedString");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }

  char* ret = NULL;
  _db->loadAlloc(WS_DcRString,"ret",(void**)&ret,NULL);
  endRemoteCall();
  if (ret == NULL){
    WSCstring tmp;
    return tmp;
  }
  WSCstring tmp;
  tmp.setString(ret,WS_EN_UTF8);
  delete ret;
  return tmp;

}
WSCstring WSCRtextField::getString(){
  if (_local != NULL){
    WSCtextField* target = (WSCtextField*)_local->cast("WSCtextField");
    if (target != NULL){
      return target->getString();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCtextField");
  rc.setOperationName("getString");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }

  char* ret = NULL;
  _db->loadAlloc(WS_DcRString,"ret",(void**)&ret,NULL);
  endRemoteCall();
  if (ret == NULL){
    WSCstring tmp;
    return tmp;
  }
  WSCstring tmp;
  tmp.setString(ret,WS_EN_UTF8);
  delete ret;
  return tmp;
}

void _WSCtextField_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onActivate")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCtextField* item = (WSCtextField*)inst->cast("WSCtextField");
        if (item != NULL){
          item->onActivate();
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"onValueChange")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCtextField* item = (WSCtextField*)inst->cast("WSCtextField");
        if (item != NULL){
          item->onValueChange();
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getSelectedString")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCtextField* target = (WSCtextField*)inst->cast("WSCtextField");
        WSCstring ret;
        if (target != NULL){
          ret = target->getSelectedString();
        }
        char* ptr = ret.getString(WS_EN_UTF8);
        db->save(WS_DcRString,"ret",(void*)ptr);
      }else{
        char* ptr = "";
        db->save(WS_DcRString,"ret",(void*)ptr);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getString")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCtextField* target = (WSCtextField*)inst->cast("WSCtextField");
        WSCstring ret;
        if (target != NULL){
          ret = target->getString();
        }
        char* ptr = ret.getString(WS_EN_UTF8);
        db->save(WS_DcRString,"ret",(void*)ptr);
      }else{
        char* ptr = "";
        db->save(WS_DcRString,"ret",(void*)ptr);
      }
      return;
    }
  }

extern void _WSCform_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCform_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCtextField,_WSCtextField_remote_call);

