#ifndef mpfc_H
#define mpfc_H

typedef unsigned char  WSCbool;
typedef void*          WSCptr;
typedef unsigned short WSCushort;
typedef unsigned long  WSCulong;
typedef unsigned char  WSCuchar;
typedef unsigned int   WSCuint;

#define WS_DATA_SOURCE_NONE      0
#define WS_DATA_SOURCE_INSTANCE  1
#define WS_DATA_SOURCE_FILE      2

#define WS_TEXT    0
#define WS_BINARY  1

#define WS_NORMAL  0
#define WS_TREE    1
#define WS_VERBOSE 2

#define WS_HAVE_CHILD   1
#define WS_HAVE_BROS    2

#define WS_OPEN          0
#define WS_INDENT_LEVEL  1
#define WS_ABSOLUTE_OPEN 2
#define WS_ICON          3

#define WS_SFORM_FIXED          0
#define WS_SFORM_UNDER_RESIZING 1

#define WS_EXEC_NONE      0
#define WS_EXEC_RD        1
#define WS_EXEC_RDWR      2
#define WS_EXEC_WR        3

#define WS_DOUBLE_CLICK_TIME    300

#define WS_POLICY_ORIGINAL   1
#define WS_POLICY_WINDOWS    2
#define WS_POLICY_GRADATION  4
#define WS_POLICY_AQUA       8

typedef struct {
  long x, y;
  inline void setPoint(long vx,long vy){
    x = vx;
    y = vy;
  }
} WSCpoint;

struct WSCrect {
  long x, y;
  WSCulong width, height;
  inline void setRect(long vx,long vy,WSCulong vw,WSCulong vh){
    x = vx;
    y = vy;
    width = vw;
    height = vh;
  }
  inline void setRect(WSCrect* r){
    x = r->x;
    y = r->y;
    width = r->width;
    height = r->height;
  }
};


#define WS_EN_DEFAULT    -2
#define WS_EN_LOCALE     -1
#define WS_EN_NONE        0
#define WS_EN_ISO8859_1   1
#define WS_EN_ISO8859_2   2
#define WS_EN_ISO8859_3   3
#define WS_EN_ISO8859_4   4
#define WS_EN_ISO8859_5   5
#define WS_EN_ISO8859_6   6
#define WS_EN_ISO8859_7   7
#define WS_EN_ISO8859_8   8
#define WS_EN_ISO8859_9   9
#define WS_EN_ISO8859_10  10
#define WS_EN_ISO8859_11  11
#define WS_EN_ISO8859_12  12
#define WS_EN_ISO8859_13  13
#define WS_EN_ISO8859_14  14
#define WS_EN_ISO8859_15  15
#define WS_EN_UTF8        16
#define WS_EN_KOI8R       17
#define WS_EN_EUCJP       20
#define WS_EN_SJIS        21
#define WS_EN_EUCKR       30
#define WS_EN_EUCCN       40
#define WS_EN_BIG5        50

#define WS_DIALOG_CANCEL  0
#define WS_DIALOG_OK      1
#define WS_DIALOG_NO      2
#define WS_DIALOG_DONE    3

class WSCstring {
  public:
    WSCstring(char*);
    WSCstring();
    ~WSCstring();

    void setString(char*,long en = WS_EN_DEFAULT);
    char* getString(long en = WS_EN_DEFAULT);
};
class WSCvariant {
  public:
    WSCvariant(long);
    WSCvariant(double);
    WSCvariant(const WSCvariant&);
    WSCvariant(char*);
    WSCvariant(WSCbase*);
    WSCvariant();

    virtual ~WSCvariant();

    char getChar();
    WSCuchar getUnsignedChar();
    short getShort();
    WSCushort getUnsignedShort();
    long getLong();
    WSCulong getUnsignedLong();
    int getInt();
    WSCuint getUnsignedInt();
    float getFloat();
    double getDouble();
    char* getCharPtr();
    WSCbase* getInstancePtr();

    void setValue(long);
    void setValue(char*);
    void setValue(double);
    void setValue(WSCbase*);

    long getType();
    char* getTypeName();
    void clear();
};

class WSDappDev {
public:
  long execInitHandler();
  long handleEvents();
  char* getInstanceName();
  WSCushort getWidth();
  WSCushort getHeight();
  void update();
  void exit(long);
};

extern WSDappDev* WSGIappDev();
extern int WSGFwsInitialize();
extern long WSGFdestroyWindow(WSCbase*);
extern void WSGFdeviceInitialize();
//extern void WSGFfunctionRegister(char*,void*);

class WSCbase {
public:
  WSCbase(WSCbase*,char*);
  ~WSCbase();

  virtual long init();
  WSCbool getInitialized();

  void onMouseIn(WSCpoint*);
  void onMouseOut();
  void onMouseMove(WSCpoint*);
  void onMousePress(WSCpoint*);
  void onMouseRelease(WSCpoint*);
  void onExpose(WSCrect*);
  void onResize(WSCrect*);
  void onVisibleChange(WSCbool);
  void onSensitiveChange(WSCbool);
  void onParentVisibleChange(WSCbool);
  void onParentSensitiveChange(WSCbool);
  void onEditModeChange(WSCbool);
  void onFocusChange(WSCbool);
  void onSpecialFocusChange(WSCbool);
  void onChildAdded(WSCbase*);
  void onSelectionChange(WSCbool);
  void onGuiPolicyChange(long policy);
  void onDefaultColorChange();



  char* getInstanceName();
  void setVisible(WSCbool);
  WSCbool getVisible();

  WSCvariant getProperty(char*);
  WSCbool setProperty(char*,const WSCvariant&);
  WSCbool setProperty(char*,char*);
  WSCbool setProperty(char*,int);
  WSCbool setProperty(char*,double);
  long addProcedure(char* pname,char* fname,long);

  void setParent(WSCbase*);
  WSCbase* getParent();
  WSCbase* getParentWindow();
  WSCbase* getChildInstance(char*);

  void setInternalObject(WSCbool);
  WSCbool getInternalObject();

  WSCbool setDefaultValue(char*);
  WSCbool existProperty(char*);

  char* getDefaultProperty();
  long setFocus(WSCbool fl = True);
  long setSpecialFocus(WSCbool fl = True);

  void setParentVisible(WSCbool);
  void setSensitive(WSCbool);
  void setParentSensitive(WSCbool);

  WSCbool getParentVisible();
  WSCbool getSensitive();
  WSCbool getParentSensitive();
  WSCbool getFocus();
  WSCbool getSpecialFocus();


  long setAbsoluteDraw(WSCbool fl);
  WSCbool getAbsoluteDraw();

  void setUserData(char*,void*);
  void* getUserData(char*);

  void setVariantData(char*,WSCvariant);
  void setVariantData(char*,int);
  void setVariantData(char*,char*);
  void setVariantData(char*,double);
  WSCvariant& getVariantData(char*);

  void execProcedure(char*);
  void execProcedure(long);

  long draw();
  long clear();
  long redraw();
  long cdraw();

static WSCbase* getNewInstance(char* cname,WSCbase*,char*);
static WSCbase* getFocusInstance();
static WSCbase* getSpecialFocusInstance();

};

class WSDmouse {
  public:
    WSDmouse();

    WSCbool getMousePosition(short* x,short* y);
    WSCbool getMousePosition(short* x,short* y,WSCbase*);

    long getMouseStatus();
    void setMousePosition(short x, short y);
    void setMouseCursor(long);

    void  addMouseCursor(long id,long val,char*);
    char* getMouseCursorName(long id);
    long  getMouseCursorId(long pos);
    long  getMouseCursor(long id);

    WSCulong getStatus();
    void setStatus(WSCulong);
    WSCulong getTargetBtn();
    void setTargetBtn(WSCulong);
    void setMouseFocusClient(WSCbase*);
    WSCbase* getMouseFocusClient();
};
WSDmouse* WSGIappMouse();

class WSCform :public WSCbase{
public:
  WSCform(WSCbase*,char*);
  ~WSCform();
};


class WSCnwbase :public WSCbase{
public:
  WSCnwbase(WSCbase*,char*);
  ~WSCnwbase();
};

class WSCngbase :public WSCbase{
public:
  WSCngbase(WSCbase*,char*);
  ~WSCngbase();
};


class WSCvlabel :public WSCnwbase{
public:
  WSCvlabel(WSCbase*,char*);
  ~WSCvlabel();
};

class WSCvbtn :public WSCvlabel{
public:
  WSCvbtn(WSCbase*,char*);
  ~WSCvbtn();

  void onKey(WSDkeyboard*,WSCbool);
  void onActivate();
  void setDrawFocusBorder(WSCbool);
};

class WSCvfbtn :public WSCvbtn{
public:
  WSCvfbtn(WSCbase*,char*);
  ~WSCvfbtn();
};

class WSCvklabel :public WSCvlabel{
public:
  WSCvklabel(WSCbase*,char*);
  ~WSCvklabel();
};

class WSCvkflabel :public WSCvklabel{
public:
  WSCvkflabel(WSCbase*,char*);
  ~WSCvkflabel();
};
class WSDkeyboard {
  public:
    void setKey(long);
    long getKey();
    WSCbool withShift();
    WSCbool withLock();
    WSCbool withCntl();
    WSCbool withAlt();
    WSCbool isCursorKey();
    WSCbool isFuncKey();
    WSCbool isTtyFunction();
    WSCbool getFepStatus();
    WSCbool getEnableFep();
    WSCbool isPressed();

    void setWithShift(WSCbool);
    void setWithLock(WSCbool);
    void setWithCntl(WSCbool);
    void setWithAlt(WSCbool);
    void setIsCursorKey(WSCbool);
    void setIsFuncKey(WSCbool);
    void setIsTtyFunction(WSCbool);
    void setIsPressed(WSCbool);

    WSCstring* getTextString();
    char* getText(long en = WS_EN_DEFAULT);

    void setSelectedString(char*,long en = WS_EN_DEFAULT);
    char* getSelectedString(long en = WS_EN_DEFAULT);
};
WSDkeyboard* WSGIappKeyboard();

class WSCvifield :public WSCvlabel{
public:
  WSCvifield(WSCbase*,char*);
  ~WSCvifield();

    void onCursorBlink();
    void onKeyHook(WSDkeyboard*);
    void onKeyInput(WSDkeyboard*,WSCbool);
    void onKey(WSDkeyboard*,WSCbool);
    void onActivate();
    void onValueChange();
    void onSelectionChange(WSCbool);
    void onVisibleChange(WSCbool);
    void onParentVisibleChange(WSCbool);

  void setCursorFore(WSCbool);
  WSCbool getCursorFore();
  WSCbool setCurPos(long pos);
  void replaceSelectedString(char*,long en = WS_EN_DEFAULT);

  WSCstring getSelectedString();
  void deleteSelectedString();
  long setSelect(long,long);
  long getSelectedPos();
  WSCstring getString();
  void addString(char*,long en = WS_EN_DEFAULT);
};

class WSCvkslabel :public WSCvifield{
public:
  WSCvkslabel(WSCbase*,char*);
  ~WSCvkslabel();
};

class WSCvmifield :public WSCvifield{
public:
  WSCvmifield(WSCbase*,char*);
  ~WSCvmifield();
};

class WSCvpifield :public WSCvifield{
public:
  WSCvpifield(WSCbase*,char*);
  ~WSCvpifield();
};

class WSCtextField :public WSCform{
public:
  WSCtextField(WSCbase*,char*);
  ~WSCtextField();
  void addString(char*,long en = WS_EN_DEFAULT);
    void replaceSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSCstring getSelectedString();
    WSCstring getString();
    void deleteSelectedString();
    long setSelect(long,long);
    long getSelectedPos();

    long getLines();
    long getTopLine();
    long setTopLine(long pos);
    long getBottomLine();
    long setBottomLine(long pos);
    WSCbase* getTextFrame();

};

class WSCvarrow :public WSCvbtn{
public:
  WSCvarrow(WSCbase*,char*);
  ~WSCvarrow();
};

class WSCvscrBar :public WSCnwbase{
public:
  WSCvscrBar(WSCbase*,char*);
  ~WSCvscrBar();

  void onActivate();
  void onBegin();
  void onEnd();
  void onIncrement();
  void onDecrement();
  void onPageIncrement();
  void onPageDecrement();
  void onValueChange();

  WSCulong getMaxSlideValue();

};

class WSCvpolyAttr :public WSCnwbase {
public:
  WSCvpolyAttr(WSCbase*,char*);
  ~WSCvpolyAttr();
};

class WSCvmeter :public WSCvpolyAttr{
public:
  WSCvmeter(WSCbase*,char*);
  ~WSCvmeter();
};

class WSCvclock :public WSCvlabel{
public:
  WSCvclock(WSCbase*,char*);
  ~WSCvclock();
};

class WSCvslider :public WSCnwbase{
public:
  WSCvslider(WSCbase*,char*);
  ~WSCvslider();

  void onActivate();
  void onDragInterval();
  void onValueChange();

};

class WSCpulldownMenu :public WSCvlabel{
public:
  WSCpulldownMenu(WSCbase*,char*);
  ~WSCpulldownMenu();
  void onActivate();

  long setItemSensitive(short no,WSCbool flag);
  long setValueSensitive(short id,WSCbool flag);

  WSCbool* getItemSensitive();

  long getValue();
  long getItems();

  long beginCascade(char* lb);
  long addItem(char* lb,char* op,char* shortc,long id);
  long endCascade();

};


class WSCcomboBox :public WSCform{
public:
  WSCcomboBox(WSCbase*,char*);
  ~WSCcomboBox();
  void onActivate();
};

class WSCoption :public WSCform{
public:
  WSCoption(WSCbase*,char*);
  ~WSCoption();
  void onActivate();
  void onValueChange(long);

  long setItemSensitive(short no, WSCbool flag);
  long setSelectValue(long value, WSCbool flag);

  long     getValue();
  long     getItemValue(long pos);
  WSCbool* getSelectStatus();
  long     getItemNum();
  long     getItems();

};

class WSCgrid :public WSCform{
public:
  WSCgrid(WSCbase*,char*);
  ~WSCgrid();
  void onInputFixed(WSCvariant*,long,long);

    long getCellNo(long px,long py,WSCulong* cx,WSCulong* cy);

    long getHColumns();
    long getVColumns();
    WSCvariant getItem(WSCulong hpos,WSCulong vpos);
    long setItem(WSCulong hpos,WSCulong vpos,WSCvariant);

    long getItemAlignment(WSCulong hpos,WSCulong vpos);

    long setCellForeColor(WSCulong x,WSCulong y,short color);
    long setCellBackColor(WSCulong x,WSCulong y,short color);
    long setCellForeColor(WSCulong x,WSCulong y,char* color);
    long setCellBackColor(WSCulong x,WSCulong y,char* color);

    long setCellInputStatus(WSCulong x,WSCulong y,WSCbool fl);
    long getCellInputStatus(WSCulong x,WSCulong y,WSCbool* fl);

    long getFocusedCell(WSCulong* hpos,WSCulong* vpos);
    long setFocusedCell(WSCulong hpos,WSCulong vpos);
};

class WSCvimage :public WSCnwbase{
public:
  WSCvimage(WSCbase*,char*);
  ~WSCvimage();
};

class WSCvrect :public WSCvpolyAttr{
public:
  WSCvrect(WSCbase*,char*);
  ~WSCvrect();
};

class WSCvarc :public WSCvpolyAttr{
public:
  WSCvarc(WSCbase*,char*);
  ~WSCvarc();
};

class WSCvpoly :public WSCvpolyAttr{
public:
  WSCvpoly(WSCbase*,char*);
  ~WSCvpoly();
};

class WSCvline :public WSCnwbase{
public:
  WSCvline(WSCbase*,char*);
  ~WSCvline();
};

class WSDimage {
public:
  WSDimage();
  ~WSDimage();
  long destroyImage();

  WSCushort getImageWidth();
  WSCushort getImageHeight();
  WSCbool   getReady();
};

class WSCvdrawingArea :public WSCnwbase{
public:
  WSCvdrawingArea(WSCbase*,char*);
  ~WSCvdrawingArea();

  long beginDraw();
  long endDraw();

  long setForeColor(char* cname);
  long setBackColor(char* cname);
  long setLineWidth(short);
  long setLineDashType(char no);
  long setHatchPattern(char no);

  long setRegion(short x,short y,WSCushort w,WSCushort h);
  long drawArc(short x,short y,WSCushort width,WSCushort height,short,short);
  long drawFillArc(short x,short y,WSCushort width,WSCushort height,short _a1,
                   short _a2,char kind);
  long drawLine(short x1,short y1,short x2,short y2);
  long drawLines(WSCpoint*,long num);
  long drawRect(short x,short y,WSCushort w,WSCushort h);
  long drawFillRect(short x,short y,WSCushort w,WSCushort h);
  long drawRects(WSCrect*,long num);
  long drawFillRects(WSCrect*,long num);
  long drawPoly(WSCpoint*,long num);
  long drawFillPoly(WSCpoint*,long num);
//  long drawGradation(long type,short col1,short col2,short col3,
//              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);
  long drawGradation(long type,char* col1,char* col2,char* col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);
//  long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
  long drawImage(short x,short y,WSCushort,WSCushort,char*,char align);
//  long drawStretchedImage(short x,short y,WSCushort,WSCushort,WSDimage*);
  long drawStretchedImage(short x,short y,WSCushort,WSCushort,char*);

  long drawString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                            char*,long encoding = WS_EN_DEFAULT);

  long drawFillString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                        char*,long encoding = WS_EN_DEFAULT);
};

class WSCvbarGraph :public WSCnwbase{
public:
  WSCvbarGraph(WSCbase*,char*);
  ~WSCvbarGraph();
};

class WSCvlineGraph :public WSCnwbase{
public:
  WSCvlineGraph(WSCbase*,char*);
  ~WSCvlineGraph();
};

class WSCvgraphScale :public WSCnwbase{
public:
  WSCvgraphScale(WSCbase*,char*);
  ~WSCvgraphScale();
};

class WSCvgraphMatrix :public WSCnwbase{
public:
  WSCvgraphMatrix(WSCbase*,char*);
  ~WSCvgraphMatrix();
};

class WSCvtimer :public WSCngbase{
public:
  WSCvtimer(WSCbase*,char*);
  ~WSCvtimer();

  void onActivate();
};

class WSCvspace :public WSCngbase{
public:
  WSCvspace(WSCbase*,char*);
  ~WSCvspace();
};

class WSCvballoonHelp :public WSCngbase{
public:
  WSCvballoonHelp(WSCbase*,char*);
  ~WSCvballoonHelp();
};

class WSCvcsocket :public WSCngbase{
public:
  WSCvcsocket(WSCbase*,char*);
  ~WSCvcsocket();
  void onActivate();
  long read(WSCuchar* buf,long size);
  long write(WSCuchar* buf,long size);
  long exec();
  void setBindAddr(char*);
  WSCstring getBindAddr();
  WSCstring getErrorMessage();
};

class WSCvssocket :public WSCngbase{
public:
  WSCvssocket(WSCbase*,char*);
  ~WSCvssocket();
  void onActivate();
  long read(WSCuchar* buf,long size);
  long write(WSCuchar* buf,long size);
  WSCstring getDestAddr();
  WSCstring getErrorMessage();
};

class WSCvudpsocket :public WSCngbase{
public:
  WSCvudpsocket(WSCbase*,char*);
  ~WSCvudpsocket();

  void onActivate();
  long read(WSCuchar* buf,long size);
  long write(WSCuchar* buf,long size);

  WSCstring getDestAddr();
  void setBindAddr(char* addr);
  WSCstring getBindAddr();

  long start();
  long stop();

  WSCstring getErrorMessage();
};


class WSCvremoteClient :public WSCngbase{
public:
  WSCvremoteClient(WSCbase*,char*);
  ~WSCvremoteClient();
};

class WSCvremoteServer :public WSCngbase{
public:
  WSCvremoteServer(WSCbase*,char*);
  ~WSCvremoteServer();
};

class WSCvdb :public WSCngbase{
public:
  WSCvdb(WSCbase*,char*);
  ~WSCvdb();

  long open(char* hostname,char* uid,char* passwd,char* dbname= NULL,
            char* port = NULL);
  long open();
  long close();
  WSCbool isOpen();
  long sqlExecute(const char*);
  long beginTran();
  long commitTran();
  long abortTran();

  WSCstring getErrorMessage();
};


class WSCwindow :public WSCbase{
public:
  WSCwindow(WSCbase*,char*);
  ~WSCwindow();
};

class WSCmainWindow :public WSCwindow{
public:
  WSCmainWindow(WSCbase*,char*);
  ~WSCmainWindow();
};

class WSCbaseDialog :public WSCwindow{
public:
  WSCbaseDialog(WSCbase*,char*);
  ~WSCbaseDialog();
  long getStatus();
  long popup();
};

class WSCdialog :public WSCbaseDialog{
public:
  WSCdialog(WSCbase*,char*);
  ~WSCdialog();
};

class WSCmessageDialog :public WSCbaseDialog{
public:
  WSCmessageDialog(WSCbase*,char*);
  ~WSCmessageDialog();
};

class WSCinputDialog :public WSCbaseDialog{
public:
  WSCinputDialog(WSCbase*,char*);
  ~WSCinputDialog();
};

class WSCwizardDialog :public WSCbaseDialog{
public:
  WSCwizardDialog(WSCbase*,char*);
  ~WSCwizardDialog();
};

class WSCfileSelect :public WSCbaseDialog{
public:
  WSCfileSelect(WSCbase*,char*);
  ~WSCfileSelect();
  char* getFileName();
};
extern WSCfileSelect* WSGIappFileSelect();

class WSCworkingDialog :public WSCbaseDialog{
public:
  WSCworkingDialog(WSCbase*,char*);
  ~WSCworkingDialog();
};

class WSCindexForm :public WSCform{
public:
  WSCindexForm(WSCbase*,char*);
  ~WSCindexForm();

};

class WSCsform :public WSCform{
public:
  WSCsform(WSCbase*,char*);
  ~WSCsform();
  long getStatus();
  void setAdjustChildren(WSCbool);
  long setManaged(WSCbase*,WSCbool);
};

class WSCvtoggle :public WSCvlabel{
public:
  WSCvtoggle(WSCbase*,char*);
  ~WSCvtoggle();
  long setStatus(WSCbool,WSCbool create_ev = True);
  WSCbool getStatus();
  long getGroupValue();
  long setGroupValue(long);
  long clearGroupValue();

};

class WSCvradio :public WSCvtoggle{
public:
  WSCvradio(WSCbase*,char*);
  ~WSCvradio();
};

class WSCradioGroup :public WSCform{
public:
  WSCradioGroup(WSCbase*,char*);
  ~WSCradioGroup();

  void onValueChange(); 
  long setItemSensitive(short,WSCbool);
  WSCbool getItemSensitive(short);
  WSCvradio* getItem(short);
};

class WSCcheckGroup :public WSCradioGroup{
public:
  WSCcheckGroup(WSCbase*,char*);
  ~WSCcheckGroup();
};

class WSCvertForm :public WSCform{
public:
  WSCvertForm(WSCbase*,char*);
  ~WSCvertForm();
};

class WSChorzForm :public WSCvertForm{
public:
  WSChorzForm(WSCbase*,char*);
  ~WSChorzForm();
};

class WSCmenuArea :public WSCform{
public:
  WSCmenuArea(WSCbase*,char*);
  ~WSCmenuArea();
};







class WSCscrForm :public WSCform{
public:
  WSCscrForm(WSCbase*,char*);
  ~WSCscrForm();

  void onScrMousePress(WSCpoint*);
  void onScrMouseRelease(WSCpoint*);
  void onScrMouseMove(WSCpoint*);
  long getVisibleWidth();
  long getVisibleHeight();
  WSCbase* getScrFrame();

};

class WSClist :public WSCscrForm{
public:
  WSClist(WSCbase*,char*);
  ~WSClist();

  void onSort();
  void onItemSelected();
  void onInputFixed(WSCstring,long,long);
  void onInputFixed(char*,long,long);

  void setLabelHeight(WSCushort );
  void delAll();
  WSCbase* getLabel(long);
  long getNum();
  WSCstring getItem(long pos,long col = -1); 
  void addItem(char*,long pos = -1);
  void replaceItem(char* item,long pos);
  void replaceItem(char* item,long pos,long column);

  void delPos(long);
  long getPreSelectedPos();
  long setPreSelectPos(long);
  long getSelectedPos();
  long setSelectPos(long);
  WSCstring getSelectedItem();
  void setTopPos(long);
  void setBottomPos(long);

  long getTopPos();
  long getBottomPos();
  void updateList();
  void setLabelProperty(char*,char*);
  void setLabelClass(char*);
  WSCbool getSelectItemChanged();
  void setSelectItemChanged(WSCbool);

  long setItemVisible(long pos,WSCbool fl);
  long setItemValue(long pos,long kind,long val);
  long getItemValue(long pos,long kind,long* val);
  WSCstring getInputString();
  void cancelInput();
  char* getSeparator();

};

class WSCverbList :public WSClist{
public:
  WSCverbList(WSCbase*,char*);
  ~WSCverbList();
};

class WSCtreeList :public WSClist{
public:
  WSCtreeList(WSCbase*,char*);
  ~WSCtreeList();
};

class WSCdirTree :public WSCtreeList{
public:
  WSCdirTree(WSCbase*,char*);
  ~WSCdirTree();
  long setSelectedDirName(char*,WSCbool opened = False);
  char getSelectedDirName();
};




extern void WSGFsetDefaultEncoding(long);
extern char* WSGFgettext(char*);

extern short WSGFimage(char*);

class WSDcolor {
public:
  WSDcolor();
  char* getColorName();
  WSCbool getUsePrivateCell();
  void setUsePrivateCell(WSCbool);
  long getRGB(long*,long*,long*);
  long setColorName(char* cname);
};

class WSCcolorSet{
public:
  WSCcolorSet();
  WSDcolor* getColor(short no);
  WSDcolor* getColor(char*);
  char* getColorName(short);
};
extern WSCcolorSet* WSGIappColorSet();
extern short WSGFindexColor(char*);
extern char* WSGFcolorName(short);
extern short WSGFcolor(char*);

class WSCimageSet{
public:
  WSCimageSet();
  short getImageNo(char* iname);
  WSDimage* getImage(short);
  WSDimage* getImage(char* iname);
  char*     getImageName(short);
  long destroyImage(short);
  long destroyImage(char* iname);
  long destroyAllImage();
};

extern WSCimageSet* WSGIappImageSet();
extern char* WSGFimageName(short);

class WSDfont{
public:
  WSDfont();
  long getFontHeight();
  long setFontName(char* cname);
  char* getFontName();
  long getStringWidth(char* str,long en = WS_EN_DEFAULT);
  long getStringHeight(char* str,long en = WS_EN_DEFAULT);

};
class WSCfontSet{
public:
  WSCfontSet();
  WSDfont* getFont(short );
  long getStringWidth(short no,char*,long en);
  long getStringHeight(short no,char*,long en);
  void setDefaultFont(short);
  short getDefaultFontNo();
  WSDfont* getDefaultFont();
};
extern WSCfontSet* WSGIappFontSet();
extern void WSGFdestroyPixmap(char*);
extern void WSGFdestroyPixmap(short);

extern WSCmessageDialog* WSGIappMessageDialog();



class WSCbaseList{
  
  
  
 public:
  WSCbaseList();
  /* virtual */  ~WSCbaseList();
  
  WSCbase* getInstance(char* class_name,char* objname);
  WSClistData* getClassList();

  void addClient(WSCbase*,void* bases = NULL);
  void delClient(WSCbase* ,void* bases = NULL);

  long countObject(char* );
  void addNeedUpdate(WSCbase*);
  void addNeedInitialize(WSCbase*);
  void execUpdate();
  void execInitialize();
  void  setUserData(char*,void *);
  void* getUserData(char*);

  WSClistData* getInstanceList(char*);
  WSCRbase*    getRemoteInstance(char*);

  void         setSearchInstanceHandler(void*);
  WSCbase*     searchInstance(char* class_name,char* objname);
  WSCbool      existInstance(WSCbase*);
  void     addEvent(WSCbase*,long ev = WSEV_NONE);
  void     delEvent(WSCbase*,long ev = WSEV_NONE);
  void     execEvent(long,void*);
  void     execEvent(long);
  void     execEvent(char*);

  long     addRemoteInstanceData(WSCremoteInstanceData* idata);
  long     delRemoteInstanceData(WSCremoteInstanceData* idata);
  WSCbool  getRemoteInstanceListUpdated();
  void     setRemoteInstanceListUpdated(WSCbool);


  long     addExportInstanceList(WSCbase* inst);
  long     delExportInstanceList(WSCbase* inst);
  long     addExportInstanceUpdateList(WSCbase* inst);
  long     delExportInstanceUpdateList(WSCbase* inst);

  long     addExportInstanceDeleteList(WSCbase* inst);
  long     delExportInstanceDeleteList(WSCbase* inst);


  WSClistData* getExportInstanceDeleteList();
  WSClistData* getExportInstanceUpdateList();
  WSClistData* getExportInstanceList();
  
  WSCremoteInstanceData*  getRemoteInstanceData(char* pname);
  WSClistData* getRemoteInstanceList();
  
};

extern WSCbaseList *WSGIappObjectList();

//WSCsheet
#define WSCSHEET_DEFAULT               -1

#define WSCSHEET_NONE                  0
#define WSCSHEET_HORZ                  1
#define WSCSHEET_VERT                  2
#define WSCSHEET_BOTH                  3

#define WSCSHEET_DEF_ROW_HEIGHT        20
#define WSCSHEET_DEF_COL_WIDTH         80

#define WSCSHEET_DEFCOLOR              0
#define WSCSHEET_DEFFONT               -1

#define WSCSHEET_DEF_ROWS              51
#define WSCSHEET_DEF_COLS              11
#define WSCSHEET_DEF_FIXEDROWS         1
#define WSCSHEET_DEF_FIXEDCOLS         1

#define WSCSHEET_CELL_NOLOCK           False
#define WSCSHEET_CELL_LOCK             True

#define WSCSHEET_DB_SORT_ASC           0
#define WSCSHEET_DB_SORT_DESC          1

class WSCsheet : public WSCform {
public:
    WSCsheet(WSCbase* parent, char* name);
    virtual ~WSCsheet();

    virtual long init();
    virtual long clear(long col = WSCSHEET_DEF_COLS, long row = WSCSHEET_DEF_ROWS);

public:
  long      getRowCount() const { return _rows; }
  long      setRowCount(long rows = WSCSHEET_DEF_ROWS);
  long      getColumnCount() const { return _cols; }
  long      setColumnCount(long cols = WSCSHEET_DEF_COLS);

  long      getRowHeight(long row);
  long      setRowHeight(long row, long height);
  long      getColumnWidth(long col);
  long      setColumnWidth(long col, long width);
   
  long      getFixedRowCount() const { return _fixedRows; }
  long      setFixedRowCount(long fixedRows = WSCSHEET_DEF_FIXEDROWS);
  long      getFixedColumnCount() const { return _fixedCols; }
  long      setFixedColumnCount(long fixedCols = WSCSHEET_DEF_FIXEDCOLS);

  long      getFixedRowHeight(long row);
  long      setFixedRowHeight(long row, long height);
  long      getFixedColumnWidth(long col);
  long      setFixedColumnWidth(long col, long width);

  long      setSheetBkColor(char* cname);
  long      setSheetBkColor(short color);
  short     getSheetBkColor() const { return _sheetBackColor; }

  long      setCellDefBkColor(char* cname);
  long      setCellDefBkColor(short color);
  short     getCellDefBkColor() const { return _cellBackColor; }

  long      setCellBkColor(char* cname);
  %name(setCellBkColorWithPos)
    long    setCellBkColor(long col, long row, char* cname);
  long      setCellBkColor(short color);
  %name(setCellBkColorWithPos)
    long    setCellBkColor(long col, long row, short color);
  short     getCellBkColor(long col, long row);

  long      setCellDefTextColor(char* cname);
  long      setCellDefTextColor(short color);
  short     getCellDefTextColor() const { return _cellTextColor; }

  long      setCellTextColor(char* cname);
  %name(setCellTextColorWithPos)
    long    setCellTextColor(long col, long row, char* cname);
  long      setCellTextColor(short color);
  %name(setCellTextColorWithPos)
    long    setCellTextColor(long col, long row, short color);
  short     getCellTextColor(long col, long row);

  long      setFixedBkColor(char* cname);
  long      setFixedBkColor(short color);
  short     getFixedBkColor() const { return _fixedBackColor; }

  long      setFixedTextColor(char* cname);
  long      setFixedTextColor(short color);
  short     getFixedTextColor() const { return _fixedTextColor; }

  long      setGridColor(char* cname);
  long      setGridColor(short color);
  short     getGridColor() { return _gridColor; }

  long      setGridLines(short glidLines = WSCSHEET_BOTH);
  short     getGridLines() const { return _gridLines; }

  long      setCellGridLines(short glidLines = WSCSHEET_BOTH);
  %name(setCellGridLinesWithPos)
    long    setCellGridLines(long col, long row, short glidLines = WSCSHEET_BOTH);
  short     getCellGridLines(long col, long row);

  long      setText(long text);
  long      setText(double text);
  long      setText(const char* text);
  long      setText(const WSCvariant& text);
  long      setText(const WSCstring& text);
  %name(setTextWithPos)
    long    setText(long col, long row, long text);
  %name(setTextWithPos)
    long    setText(long col, long row, double text);
  %name(setTextWithPos)
    long    setText(long col, long row, const char* text);
  %name(setTextWithPos)
    long    setText(long col, long row, const WSCvariant& text);
  %name(setTextWithPos)
    long    setText(long col, long row, const WSCstring& text);
  WSCstring getText(long col, long row);

  long      setFixedText(long col, long row, long text);
  long      setFixedText(long col, long row, double text);
  long      setFixedText(long col, long row, const char* text);
  long      setFixedText(long col, long row, const WSCvariant& text);
  long      setFixedText(long col, long row, const WSCstring& text);
  WSCstring getFixedText(long col, long row);

  //long      getCellNo(WSCpoint* pt, long* col, long* row);

  long      setFocusCell(long col, long row);
  //void      getFocusCell(long* col, long* row) { *col = _focusCol; *row = _focusRow; }
  long      getFocusCol() { return _focusCol; }
  long      getFocusRow() { return _focusRow; }
  
  void      setRow(long row);
  long      getRow() { return _startRow; }
  void      setStartRow(long row);
  long      getStartRow() { return (_startRow <= _endRow ? _startRow : _endRow); }
  void      setEndRow(long row);
  long      getEndRow() { return (_startRow > _endRow ? _startRow : _endRow); }

  void      setCol(long col);
  long      getCol() { return _startCol; }
  void      setStartCol(long col);
  long      getStartCol() { return (_startCol <= _endCol ? _startCol : _endCol); }
  void      setEndCol(long col);
  long      getEndCol() { return (_startCol > _endCol ? _startCol : _endCol); }

  void      setSelectCell(WSCbool val);
  WSCbool   getSelectCell() { return _selectCell; }

  void      setEditEnabled(WSCbool val) { _editEnabled = val; }
  WSCbool   getEditEnabled() { return _editEnabled; }

  long      getFocusCellRect(WSCrect* rect);
  long      getVisibleCellRect(long col, long row, WSCrect* rect);
  long      getCellRect(long col, long row, WSCrect* rect);

  long      setTopVisibleRow(long row);
  long      getTopVisibleRow() { return _topVisibleRow; };
  long      setTopVisibleCol(long col);
  long      getTopVisibleCol() { return _topVisibleCol; };

  long      setCellDefFont(short fontno);
  short     getCellDefFont() { return _font; }

  long      setCellFont(short fontno);
  %name(setCellFontWithPos)
    long    setCellFont(long col, long row, short fontno);
  short     getCellFont() { return _font; }
  %name(getCellFontWithPos)
    short   getCellFont(long col, long row);
  
  long      setFixedCellFont(short fontno);
  short     getFixedCellFont() { return _fixedFont; }

  void      setVertAutoNumber(WSCbool val) { _vautoNumber = val; }
  WSCbool   getVertAutoNumber() { return _vautoNumber; }
  void      setHorzAutoNumber(WSCbool val) { _hautoNumber = val; }
  WSCbool   getHorzAutoNumber() { return _hautoNumber; }

  long      setCellAlignemnt(char align);
  %name(setCellAlignemntWithPos)
    long    setCellAlignemnt(long col, long row, char align);
  char      getCellAlignemnt(long col, long row);

  long      setFixedCellAlignemnt(long col, long row, char align);
  char      getFixedCellAlignemnt(long col, long row);

  long      setCellLock(WSCbool lock);
  %name(setCellLockWithPos)
    long    setCellLock(long col, long row, WSCbool lock);
  WSCbool   getCellLock(long col, long row);
  
  WSCushort getClientWidth() { return _clientWidth; }
  WSCushort getClientHeight() { return _clientHeight; }
  
  void      setNoRefresh(WSCbool val) { _no_refresh = val; }
  WSCbool   getNoRefresh() { return _no_refresh; }
  
  long      insertRow();
  %name(insertRowWithVal)
    long    insertRow(long row, long rows);
  long      insertCol();
  %name(insertColWithVal)
    long    insertCol(long col, long cols);
  
  long      deleteRow();
  %name(deleteRowWithVal)
    long    deleteRow(long row, long rows);
  long      deleteCol();
  %name(deleteColWithVal)
    long    deleteCol(long col, long cols);

  /// database 
  long      setDataSource(const char* name);
  long      setDataSource(WSCstring& name);
  WSCstring getDataSource() { _dbwork = _dataSource; return _dbwork; }

  long      setTableName(const char* table);
  long      setTableName(WSCstring& table);
  WSCstring getTableName() { _dbwork = _tableName; return _dbwork; }
  
  long      setDbItem(const char* item);
  long      setDbItem(WSCstring& item);
  WSCstring getDbItem() { _dbwork = _dbItem; return _dbwork; }

  long      setDbSortItem1(const char* item);
  long      setDbSortItem1(WSCstring& item);
  WSCstring getDbSortItem1() { _dbwork = _dbSortItem1; return _dbwork; }

  long      setDbSort1(WSCuchar sort);
  WSCuchar  getDbSort1() { return _dbSort1; }

  long      setDbSortItem2(const char* item);
  long      setDbSortItem2(WSCstring& item);
  WSCstring getDbSortItem2() { _dbwork = _dbSortItem2; return _dbwork; }

  long      setDbSort2(WSCuchar sort);
  WSCuchar  getDbSort2() { return _dbSort2; }

  long      setDbSortItem3(const char* item);
  long      setDbSortItem3(WSCstring& item);
  WSCstring getDbSortItem3() { _dbwork = _dbSortItem3; return _dbwork; }

  long      setDbSort3(WSCuchar sort);
  WSCuchar  getDbSort3() { return _dbSort3; }
  
  long      setDbFilter(const char* filter);
  long      setDbFilter(WSCstring& filter);
  WSCstring getDbFilter() { _dbwork = _dbFilter; return _dbwork; }

  long      setDbStmtString(const char* stmt);
  long      setDbStmtString(WSCstring& stmt);
  WSCstring getDbStmtString() { _dbwork = _dbStmtString; return _dbwork; }

  long      dbRefresh();
};

//kind of mouse button state ,return value of WSDmouse::getMouseStatus()
#define WS_MOUSE_SHIFT     (1<<0)
#define WS_MOUSE_LOCK      (1<<1)
#define WS_MOUSE_CONTROL   (1<<2)
#define WS_MOUSE_MOD       (1<<3)
#define WS_MOUSE_BTN1      (1<<8)
#define WS_MOUSE_BTN2      (1<<9)
#define WS_MOUSE_BTN3      (1<<10)
#define WS_MOUSE_BTN4      (1<<11)
#define WS_MOUSE_BTN5      (1<<12)

//kind of read write mode
#define WS_READ      0
#define WS_WRITE     1
#define WS_RW        2

//kind of indicator type
#define WS_IN_OUT     (unsigned char)0
#define WS_OUT        (unsigned char)1
#define WS_IN         (unsigned char)2
#define WS_NONE       (unsigned char)3

//kind of orientation
#define WS_VERTICAL   (unsigned char)1
#define WS_HORIZONTAL (unsigned char)0

//PIXMAP STYLE
#define WS_DIRECT_WINDOW      (char)(0)
#define WS_DYNAMIC_PIXMAP     (char)(1)

//SHADOW TYPE  //notice. exist in WSRdef
#define WS_SHADOW_NONE     (signed char)(-1)
#define WS_SHADOW_TRANS    (signed char)(-1)
#define WS_SHADOW_OUT      (0)
#define WS_SHADOW_IN       (1)
#define WS_SHADOW_EOUT     (2)
#define WS_SHADOW_EIN      (3)
#define WS_SHADOW_BORDER   (4)

//TITLE BAR  //notice. exist in WSRdef
#define WS_NO_TITLE       (char)0
#define WS_FULL_TITLE     (char)1
#define WS_ONLY_TITLE     (char)2
#define WS_MINI_BTN       (char)3
#define WS_MAX_BTN        (char)4
#define WS_FRAME          (char)5
#define WS_NO_MANAGE      (char)6
//do not change...
#define WS_LEFT           0
#define WS_RIGHT          1
#define WS_CENTER         2
#define WS_UP             3
#define WS_TOP            3
#define WS_DOWN           4
#define WS_BOTTOM         4

#define WS_LEFT_TOP       5
#define WS_LEFT_BOTTOM    6
#define WS_RIGHT_TOP      7
#define WS_RIGHT_BOTTOM   8
#define WS_RET            9
#define WS_TAB           11
#define WS_STAB          12

#define WS_NO_ERR  0
#define WS_OK      0
#define WS_ERR    -1
#define WS_REMOTE_CALL_FAILED    -1

#define False       0
#define True        1

//property type
#define WSTlong         0
#define WSTulong        1
#define WSTshort        2
#define WSTushort       3
#define WSTchar         4
#define WSTuchar        5
#define WSTfloat        6
#define WSTdouble       7
#define WSTvoidptr      8
#define WSTcharptr      9
#define WSTvoid        10
#define WSTbool        11
#define WSTint         12
#define WSTuint        13

//events
#define  WSEV_HASH_MAX_NUM        32
#define  WSEV_NONE                -1
#define  WSEV_INITIALIZE           0
#define  WSEV_DELETE               1
#define  WSEV_ACTIVATE             2
#define  WSEV_VALUE_CH             3
#define  WSEV_FOCUS_CH             4
#define  WSEV_VISIBLE_CH           5
#define  WSEV_SENSITIVE_CH         6
#define  WSEV_PARENT_VISIBLE_CH    7
#define  WSEV_PARENT_SENSITIVE_CH  8
#define  WSEV_EXPOSE               9
#define  WSEV_RESIZE              10
#define  WSEV_MOUSE_IN            11
#define  WSEV_MOUSE_OUT           12
#define  WSEV_MOUSE_PRESS         13
#define  WSEV_MOUSE_RELEASE       14
#define  WSEV_MOUSE_MOVE          15
#define  WSEV_KEY_PRESS           16
#define  WSEV_KEY_RELEASE         17
#define  WSEV_KEY_HOOK            18
#define  WSEV_MOUSE_DOUBLE_CLICK  19

#define  WSEV_SORT                33
#define  WSEV_GUI_POLICY_CH       34
#define  WSEV_ITEM_SELECTED       35
#define  WSEV_STATUS_CH           36
#define  WSEV_INPUT_FIXED         37
#define  WSEV_BEGIN               38
#define  WSEV_END                 39
#define  WSEV_INCREMENT           40
#define  WSEV_DECREMENT           41
#define  WSEV_PAGE_INCREMENT      42
#define  WSEV_PAGE_DECREMENT      43
#define  WSEV_SCR_MOUSE_PRESS     44
#define  WSEV_SCR_MOUSE_RELEASE   45
#define  WSEV_SCR_MOUSE_MOVE      46
#define  WSEV_EDIT_MODE_CH        47
#define  WSEV_SPECIAL_FOCUS_CH    48
#define  WSEV_CHILD_ADDED         49
#define  WSEV_SELECTION_CH        50


//-----------------------------------------------------------------------------
#ifndef MSW //UNIX - Xwindow System
//-----------------------------------------------------------------------------

#define WSK_BackSpace   0xFF08
#define WSK_Tab         0xFF09
#define WSK_Linefeed    0xFF0A
#define WSK_Clear       0xFF0B
#define WSK_Return      0xFF0D
#define WSK_Pause       0xFF13
#define WSK_Scroll_Lock 0xFF14
#define WSK_Sys_Req     0xFF15
#define WSK_Escape      0xFF1B
#define WSK_Delete      0xFFFF

#define WSK_Kanji             0xFF21
#define WSK_Muhenkan          0xFF22
#define WSK_Henkan_Mode       0xFF23
#define WSK_Henkan            0xFF23
#define WSK_Romaji            0xFF24
#define WSK_Hiragana          0xFF25
#define WSK_Katakana          0xFF26
#define WSK_Hiragana_Katakana 0xFF27
#define WSK_Zenkaku           0xFF28
#define WSK_Hankaku           0xFF29
#define WSK_Zenkaku_Hankaku   0xFF2A
#define WSK_Touroku           0xFF2B
#define WSK_Massyo            0xFF2C
#define WSK_Kana_Lock         0xFF2D
#define WSK_Kana_Shift        0xFF2E
#define WSK_Eisu_Shift        0xFF2F
#define WSK_Eisu_toggle       0xFF30

#define WSK_Home              0xFF50
#define WSK_Left              0xFF51
#define WSK_Up                0xFF52
#define WSK_Right             0xFF53
#define WSK_Down              0xFF54
#define WSK_Prior             0xFF55
#define WSK_Page_Up           0xFF55
#define WSK_Page_Down         0xFF56
#define WSK_End               0xFF57
#define WSK_Begin             0xFF58


#define WSK_Select        0xFF60
#define WSK_Print         0xFF61
#define WSK_Execute       0xFF62
#define WSK_Insert        0xFF63
#define WSK_Undo          0xFF65 
#define WSK_Redo          0xFF66
#define WSK_Menu          0xFF67
#define WSK_Find          0xFF68
#define WSK_Cancel        0xFF69
#define WSK_Help          0xFF6A
#define WSK_Break         0xFF6B
#define WSK_Mode_switch   0xFF7E 
#define WSK_script_switch 0xFF7E 
#define WSK_Num_Lock      0xFF7F

/* Keypad Functions, keypad numbers cleverly chosen to map to ascii */
#define WSK_KP_Space     0xFF80
#define WSK_KP_Tab       0xFF89
#define WSK_KP_Enter     0xFF8D
#define WSK_KP_F1        0xFF91
#define WSK_KP_F2        0xFF92
#define WSK_KP_F3        0xFF93
#define WSK_KP_F4        0xFF94
#define WSK_KP_Home      0xFF95
#define WSK_KP_Left      0xFF96
#define WSK_KP_Up        0xFF97
#define WSK_KP_Right     0xFF98
#define WSK_KP_Down      0xFF99
#define WSK_KP_Prior     0xFF9A
#define WSK_KP_Page_Up   0xFF9A
#define WSK_KP_Next      0xFF9B
#define WSK_KP_Page_Down 0xFF9B
#define WSK_KP_End       0xFF9C
#define WSK_KP_Begin     0xFF9D
#define WSK_KP_Insert    0xFF9E
#define WSK_KP_Delete    0xFF9F
#define WSK_KP_Equal     0xFFBD
#define WSK_KP_Multiply  0xFFAA
#define WSK_KP_Add       0xFFAB
#define WSK_KP_Separator 0xFFAC
#define WSK_KP_Subtract  0xFFAD
#define WSK_KP_Decimal   0xFFAE
#define WSK_KP_Divide    0xFFAF

#define WSK_KP_0   0xFFB0
#define WSK_KP_1   0xFFB1
#define WSK_KP_2   0xFFB2
#define WSK_KP_3   0xFFB3
#define WSK_KP_4   0xFFB4
#define WSK_KP_5   0xFFB5
#define WSK_KP_6   0xFFB6
#define WSK_KP_7   0xFFB7
#define WSK_KP_8   0xFFB8
#define WSK_KP_9   0xFFB9

#define WSK_F1   0xFFBE
#define WSK_F2   0xFFBF
#define WSK_F3   0xFFC0
#define WSK_F4   0xFFC1
#define WSK_F5   0xFFC2
#define WSK_F6   0xFFC3
#define WSK_F7   0xFFC4
#define WSK_F8   0xFFC5
#define WSK_F9   0xFFC6
#define WSK_F10  0xFFC7
#define WSK_F11  0xFFC8
#define WSK_L1   0xFFC8
#define WSK_F12  0xFFC9
#define WSK_L2   0xFFC9
#define WSK_F13  0xFFCA
#define WSK_L3   0xFFCA
#define WSK_F14  0xFFCB
#define WSK_L4   0xFFCB
#define WSK_F15  0xFFCC
#define WSK_L5   0xFFCC
#define WSK_F16  0xFFCD
#define WSK_L6   0xFFCD
#define WSK_F17  0xFFCE
#define WSK_L7   0xFFCE
#define WSK_F18  0xFFCF
#define WSK_L8   0xFFCF
#define WSK_F19  0xFFD0
#define WSK_L9   0xFFD0
#define WSK_F20  0xFFD1
#define WSK_L10  0xFFD1
#define WSK_F21  0xFFD2
#define WSK_R1   0xFFD2
#define WSK_F22  0xFFD3
#define WSK_R2   0xFFD3
#define WSK_F23  0xFFD4
#define WSK_R3   0xFFD4
#define WSK_F24  0xFFD5
#define WSK_R4   0xFFD5
#define WSK_F25  0xFFD6
#define WSK_R5   0xFFD6
#define WSK_F26  0xFFD7
#define WSK_R6   0xFFD7
#define WSK_F27  0xFFD8
#define WSK_R7   0xFFD8
#define WSK_F28  0xFFD9
#define WSK_R8   0xFFD9
#define WSK_F29  0xFFDA
#define WSK_R9   0xFFDA
#define WSK_F30  0xFFDB
#define WSK_R10  0xFFDB
#define WSK_F31  0xFFDC
#define WSK_R11  0xFFDC
#define WSK_F32  0xFFDD
#define WSK_R12  0xFFDD
#define WSK_F33  0xFFDE
#define WSK_R13  0xFFDE
#define WSK_F34  0xFFDF
#define WSK_R14  0xFFDF
#define WSK_F35  0xFFE0
#define WSK_R15  0xFFE0

#define WSK_Shift_L    0xFFE1
#define WSK_Shift_R    0xFFE2
#define WSK_Control_L  0xFFE3
#define WSK_Control_R  0xFFE4
#define WSK_Caps_Lock  0xFFE5
#define WSK_Shift_Lock 0xFFE6

#define WSK_Meta_L   0xFFE7
#define WSK_Meta_R   0xFFE8
#define WSK_Alt_L    0xFFE9
#define WSK_Alt_R    0xFFEA
#define WSK_Super_L  0xFFEB
#define WSK_Super_R  0xFFEC
#define WSK_Hyper_L  0xFFED
#define WSK_Hyper_R  0xFFEE

#define WSK_space               0x020
#define WSK_exclam              0x021
#define WSK_quotedbl            0x022
#define WSK_numbersign          0x023
#define WSK_dollar              0x024
#define WSK_percent             0x025
#define WSK_ampersand           0x026
#define WSK_apostrophe          0x027
#define WSK_quoteright          0x027
#define WSK_parenleft           0x028
#define WSK_parenright          0x029
#define WSK_asterisk            0x02a
#define WSK_plus                0x02b
#define WSK_comma               0x02c
#define WSK_minus               0x02d
#define WSK_period              0x02e
#define WSK_slash               0x02f
#define WSK_0                   0x030
#define WSK_1                   0x031
#define WSK_2                   0x032
#define WSK_3                   0x033
#define WSK_4                   0x034
#define WSK_5                   0x035
#define WSK_6                   0x036
#define WSK_7                   0x037
#define WSK_8                   0x038
#define WSK_9                   0x039
#define WSK_colon               0x03a
#define WSK_semicolon           0x03b
#define WSK_less                0x03c
#define WSK_equal               0x03d
#define WSK_greater             0x03e
#define WSK_question            0x03f
#define WSK_at                  0x040
#define WSK_A                   0x041
#define WSK_B                   0x042
#define WSK_C                   0x043
#define WSK_D                   0x044
#define WSK_E                   0x045
#define WSK_F                   0x046
#define WSK_G                   0x047
#define WSK_H                   0x048
#define WSK_I                   0x049
#define WSK_J                   0x04a
#define WSK_K                   0x04b
#define WSK_L                   0x04c
#define WSK_M                   0x04d
#define WSK_N                   0x04e
#define WSK_O                   0x04f
#define WSK_P                   0x050
#define WSK_Q                   0x051
#define WSK_R                   0x052
#define WSK_S                   0x053
#define WSK_T                   0x054
#define WSK_U                   0x055
#define WSK_V                   0x056
#define WSK_W                   0x057
#define WSK_X                   0x058
#define WSK_Y                   0x059
#define WSK_Z                   0x05a
#define WSK_bracketleft         0x05b
#define WSK_backslash           0x05c
#define WSK_bracketright        0x05d
#define WSK_asciicircum         0x05e
#define WSK_underscore          0x05f
#define WSK_grave               0x060
#define WSK_quoteleft           0x060
#define WSK_a                   0x061
#define WSK_b                   0x062
#define WSK_c                   0x063
#define WSK_d                   0x064
#define WSK_e                   0x065
#define WSK_f                   0x066
#define WSK_g                   0x067
#define WSK_h                   0x068
#define WSK_i                   0x069
#define WSK_j                   0x06a
#define WSK_k                   0x06b
#define WSK_l                   0x06c
#define WSK_m                   0x06d
#define WSK_n                   0x06e
#define WSK_o                   0x06f
#define WSK_p                   0x070
#define WSK_q                   0x071
#define WSK_r                   0x072
#define WSK_s                   0x073
#define WSK_t                   0x074
#define WSK_u                   0x075
#define WSK_v                   0x076
#define WSK_w                   0x077
#define WSK_x                   0x078
#define WSK_y                   0x079
#define WSK_z                   0x07a
#define WSK_braceleft           0x07b
#define WSK_bar                 0x07c
#define WSK_braceright          0x07d
#define WSK_asciitilde          0x07e

//-----------------------------------------------------------------------------
#else //MS Windows System
//-----------------------------------------------------------------------------
#define WSK_BackSpace			0x08
#define WSK_Tab				0x09
#define WSK_Linefeed			-1
#define WSK_Clear				0x0C
#define WSK_Return				0x0D
#define WSK_Pause				0x13
#define WSK_Scroll_Lock			0x91
#define WSK_Sys_Req				0x2C
#define WSK_Escape				0x1B
#define WSK_Delete				0x2E

#define WSK_Kanji				0x19
#define WSK_Muhenkan			0x1d
#define WSK_Henkan_Mode			0x1c
#define WSK_Henkan				0x1c
#define WSK_Romaji				0xF2
#define WSK_Hiragana			0xF2
#define WSK_Katakana			0xF2
#define WSK_Hiragana_Katakana	0xF2
#define WSK_Zenkaku				0xF4
#define WSK_Hankaku				0xF3
#define WSK_Zenkaku_Hankaku		0xF4
#define WSK_Touroku				-1
#define WSK_Massyo				-1
#define WSK_Kana_Lock			-1
#define WSK_Kana_Shift			-1
#define WSK_Eisu_Shift			-1
#define WSK_Eisu_toggle			0xF0

#define WSK_Home				0x24
#define WSK_Left				0x25
#define WSK_Up					0x26
#define WSK_Right				0x27
#define WSK_Down				0x28
#define WSK_Prior				0x21
#define WSK_Page_Up				0x21
#define WSK_Page_Down			        0x22
#define WSK_End					0x23


#define WSK_Print				0x2C
#define WSK_Execute				0x2B
#define WSK_Insert				0x2D
#define WSK_Cancel				0x03
#define WSK_Help				0x2F
#define WSK_Break				0x03
#define WSK_Num_Lock			        0x90

#define WSK_KP_Space				-1
#define WSK_KP_Tab				-1
#define WSK_KP_Enter				0x0D
#define WSK_KP_F1				-1
#define WSK_KP_F2				-1
#define WSK_KP_F3				-1
#define WSK_KP_F4				-1
#define WSK_KP_Home				0x24
#define WSK_KP_Left				0x25
#define WSK_KP_Up				0x26
#define WSK_KP_Right				0x27
#define WSK_KP_Down				0x28
#define WSK_KP_Prior				-1
#define WSK_KP_Page_Up				0x21
#define WSK_KP_Next				-1
#define WSK_KP_Page_Down			0x22
#define WSK_KP_End				0x23
#define WSK_KP_Begin				-1
#define WSK_KP_Insert				0x2D
#define WSK_KP_Delete				0x2E
#define WSK_KP_Equal				-1
#define WSK_KP_Multiply				0x6A
#define WSK_KP_Add				0x6B
#define WSK_KP_Separator			0x6C
#define WSK_KP_Subtract				0x6D
#define WSK_KP_Decimal				0x6E
#define WSK_KP_Divide				0x6F

#define WSK_KP_0				0x60
#define WSK_KP_1				0x61
#define WSK_KP_2				0x62
#define WSK_KP_3				0x63
#define WSK_KP_4				0x64
#define WSK_KP_5				0x65
#define WSK_KP_6				0x66
#define WSK_KP_7				0x67
#define WSK_KP_8				0x68
#define WSK_KP_9				0x69

#define WSK_F1					0x70
#define WSK_F2					0x71
#define WSK_F3					0x72
#define WSK_F4					0x73
#define WSK_F5					0x74
#define WSK_F6					0x75
#define WSK_F7					0x76
#define WSK_F8					0x77
#define WSK_F9					0x78
#define WSK_F10					0x79
#define WSK_F11					0x7A
#define WSK_L1					0x7A
#define WSK_F12					0x7B
#define WSK_L2					0x7B
#define WSK_F13					0x7C
#define WSK_L3					0x7C
#define WSK_F14					0x7D
#define WSK_L4					0x7D
#define WSK_F15					0x7E
#define WSK_L5					0x7E
#define WSK_F16					0x7F
#define WSK_L6					0x7F
#define WSK_F17					0x80
#define WSK_L7					0x80
#define WSK_F18					0x81
#define WSK_L8					0x81
#define WSK_F19					0x82
#define WSK_L9					0x82
#define WSK_F20					0x83
#define WSK_L10					0x83
#define WSK_F21					0x84
#define WSK_R1					0x84
#define WSK_F22					0x85
#define WSK_R2					0x85
#define WSK_F23					0x86
#define WSK_R3					0x86
#define WSK_F24					0x87
#define WSK_R4					0x87
#define WSK_F25					-1
#define WSK_R5					-1
#define WSK_F26					-1
#define WSK_R6					-1
#define WSK_F27					-1
#define WSK_R7					-1
#define WSK_F28					-1
#define WSK_R8					-1
#define WSK_F29					-1
#define WSK_R9					-1
#define WSK_F30					-1
#define WSK_R10					-1
#define WSK_F31					-1
#define WSK_R11					-1
#define WSK_F32					-1
#define WSK_R12					-1
#define WSK_F33					-1
#define WSK_R13					-1
#define WSK_F34					-1
#define WSK_R14					-1
#define WSK_F35					-1
#define WSK_R15					-1

/* Modifiers */

#define WSK_Shift_L				0x10
#define WSK_Shift_R				0x10
#define WSK_Control_L			0x11
#define WSK_Control_R			0x11
#define WSK_Caps_Lock			0x14
#define WSK_Shift_Lock			-1

#define WSK_Meta_L				-1
#define WSK_Meta_R				-1
#define WSK_Alt_L				0x12
#define WSK_Alt_R				0x12
#define WSK_Super_L				-1
#define WSK_Super_R				-1
#define WSK_Hyper_L				-1
#define WSK_Hyper_R				-1

#define WSK_space				0x20
#define WSK_exclam				0x121
#define WSK_quotedbl			0x122
#define WSK_numbersign			0x123
#define WSK_dollar				0x124
#define WSK_percent				0x125
#define WSK_ampersand			0x126
#define WSK_apostrophe			0x127
#define WSK_quoteright			0x127
#define WSK_parenleft			0x128
#define WSK_parenright			0x129
#define WSK_asterisk			0x12a
#define WSK_plus				0x12b
#define WSK_comma				0x12c
#define WSK_minus				0x12d
#define WSK_period				0x12e
#define WSK_slash				0x12f
#define WSK_0					0x130
#define WSK_1					0x131
#define WSK_2					0x132
#define WSK_3					0x133
#define WSK_4					0x134
#define WSK_5					0x135
#define WSK_6					0x136
#define WSK_7					0x137
#define WSK_8					0x138
#define WSK_9					0x139
#define WSK_colon				0x13a
#define WSK_semicolon			0x13b
#define WSK_less				0x13c
#define WSK_equal				0x13d
#define WSK_greater				0x13e
#define WSK_question			0x13f
#define WSK_at					0x140
#define WSK_A					0x141
#define WSK_B					0x142
#define WSK_C					0x143
#define WSK_D					0x144
#define WSK_E					0x145
#define WSK_F					0x146
#define WSK_G					0x147
#define WSK_H					0x148
#define WSK_I					0x149
#define WSK_J					0x14a
#define WSK_K					0x14b
#define WSK_L					0x14c
#define WSK_M					0x14d
#define WSK_N					0x14e
#define WSK_O					0x14f
#define WSK_P					0x150
#define WSK_Q					0x151
#define WSK_R					0x152
#define WSK_S					0x153
#define WSK_T					0x154
#define WSK_U					0x155
#define WSK_V					0x156
#define WSK_W					0x157
#define WSK_X					0x158
#define WSK_Y					0x159
#define WSK_Z					0x15a
#define WSK_bracketleft			0x15b
#define WSK_backslash			0x15c
#define WSK_bracketright		0x15d
#define WSK_asciicircum			0x15e
#define WSK_underscore			0x15f
#define WSK_grave				0x160
#define WSK_quoteleft			0x160
#define WSK_a					0x161
#define WSK_b					0x162
#define WSK_c					0x163
#define WSK_d					0x164
#define WSK_e					0x165
#define WSK_f					0x166
#define WSK_g					0x167
#define WSK_h					0x168
#define WSK_i					0x169
#define WSK_j					0x16a
#define WSK_k					0x16b
#define WSK_l					0x16c
#define WSK_m					0x16d
#define WSK_n					0x16e
#define WSK_o					0x16f
#define WSK_p					0x170
#define WSK_q					0x171
#define WSK_r					0x172
#define WSK_s					0x173
#define WSK_t					0x174
#define WSK_u					0x175
#define WSK_v					0x176
#define WSK_w					0x177
#define WSK_x					0x178
#define WSK_y					0x179
#define WSK_z					0x17a
#define WSK_braceleft			0x17b
#define WSK_bar					0x17c
#define WSK_braceright			0x17d
#define WSK_asciitilde			0x17e

#endif

#define WS_LIST_TREE_OPEN "list-tr-open"
#define WS_LIST_TREE_OPEN_CH "list-tr-open-ch"
#define WS_LIST_INDENT_LEVEL "list-indent-level"
#define WS_LIST_INDENT_STATUS "list-indent-status"
#define WS_LIST_LABEL_LIST "list-lb-list"
#define WS_LIST_TOP "list-lb-top"

#endif
