//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCCOLORSET_H
#define WSCCOLORSET_H

#include <WScom.h>
#include <WSClistData.h>
#include <WSDcolor.h>

#define MAX_COLOR_ID    1024

class WSCcolorSet{
 protected:
   WSDcolor*  _cache_table[WS_MAX_HASH_VALUE];
   WSDcolor*  _cache_table2[WS_MAX_HASH_VALUE];
   WSClistData _color_list;
   WSDcolor* (*_color_create_handler)();
   short _local_cno;
   short _default_cols[WS_MAX_DF_COLORS];
   WSDcolor*  _default_colors[WS_MAX_DF_COLORS];

 public:
   WSCcolorSet();
   virtual ~WSCcolorSet();

   long setCreateHandler(WSDcolor* (*)());

   void  setColor(short no,char* cname);
   void  addColor(WSDcolor* color);
   void  delColor(WSDcolor* color);
   short getColorNo(char* cname);
   short getStaticColorNo(char* cname);
   char* getColorName(short);

   WSDcolor* getColor(short no);
   WSDcolor* getColor(char* name);
   WSDcolor* getNewColor();

   long  setDefaultColorNo(long kind,short no);
   short getDefaultColorNo(long kind);
   WSDcolor* getDefaultColor(long kind);

   WSClistData* getColorList();
   WSCbool      existColor(short cid);
};
extern WSDLEX WSCcolorSet*  WSGIappColorSet();
extern WSDLEX short WSGFindexColor(char*);
extern WSDLEX char* WSGFcolorName(short);
extern WSDLEX short WSGFcolor(char*);
#endif
