//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCINDEXFORM_H
#define WSCINDEXFORM_H

#include <WScom.h>
#include <WSCform.h>

#define WSCindexForm_VER  1000
class WSCindexForm :public WSCform{

  protected:
     WSClistData _btns;
     WSCform*    _tab_form;
     char*       _menu_string;
     WSCushort   _bar_thick;
     WSCuchar    _value;
     unsigned    _orientation:1;
     unsigned    _need_adjust:1;
     unsigned    _flipped:1;

     WSMFpropertyDef( WSNbarThickness, WSCushort, _bar_thick   );
     WSMFpropertyDef( WSNorientation,  WSCuchar,  _orientation );
     WSMFpropertyDef( WSNmenuItems,    char*,     _menu_string );
     WSMFpropertyDef( WSNvalue,    WSCuchar,     _value );
     WSMFpropertyDef( WSNflip,    WSCbool,     _flipped );

     virtual void setWorkWSNbackColor(short);
     virtual void setWorkWSNforeColor(short);
     virtual void setWorkWSNwidth(WSCushort);
     virtual void setWorkWSNheight(WSCushort);
     virtual void setWorkWSNshadowType(char);
     virtual void setWorkWSNshadowThickness(WSCuchar);

     void  _value_adjust();
     void  _adjust();
     void  _vis_adjust();
     static void _index_op(WSCbase*);
static void      (*_ext_draw_proc)(void*);
static WSCstring _policy_name;

  public:
    WSCindexForm(WSCbase*,char*);
    virtual ~WSCindexForm();
    virtual void onGuiPolicyChange(long);

    virtual long initialize();
    virtual long draw();
    virtual long redraw();
    virtual long clear();
    virtual long cdraw();

    //internal function
    void set_btn_background(short no);
    WSCbase* get_target_btn();

    WSMFguiClassDef(WSCindexForm,WSCform);
    WSMFversionDef(WSCindexForm);
};
struct WSCindexForm_draw_struct{
  WSCindexForm* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
  short gradation;
  short gradation_margin;
  WSCushort bar_thickness;
  WSCuchar orientation;
  WSCbool flipped;
  char* menu_string;
  WSCulong value;
};



#endif
