//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCRADIOGROUP_H
#define WSCRADIOGROUP_H

#include <WScom.h>
#include <WSCform.h>
#include <WSCvradio.h>

#define WSCradioGroup_VER  1001

class WSCradioGroup   :public WSCform{

  protected:
    WSClistData _radio_list;
    char* _title_string;
    char* _menu_str;
    WSCulong _value;
    WSCushort _item_height;
    short     _indicator_color;
    short     _select_color;
    short     _indicator_pixmap;
    short     _select_pixmap;
    short     _label_pixmap;
 
    unsigned  _font:4;
    unsigned  _margin:3;
    unsigned  _unique:1;
    unsigned  _indicator_size:6;
    unsigned  _indicator_type:2;
    unsigned  _indicator_shadow_thick:4;
    unsigned  _indicator_on:1;
    unsigned  _orientation:1;

    WSMFpropertyDef(WSNvalue,     WSCulong, _value );
    WSMFpropertyDef(WSNtitleString,   char*, _title_string );
    WSMFpropertyDef(WSNmenuItems,   char*, _menu_str );
    WSMFpropertyDef(WSNmenuItemHeight,   WSCushort, _item_height );
    WSMFpropertyDef(WSNfont,         WSCuchar,   _font         );
    WSMFpropertyDef(WSNmargin,  WSCuchar, _margin);
    WSMFpropertyDef(WSNindicatorOn,     WSCbool, _indicator_on   );
    WSMFpropertyDef(WSNindicatorType,   WSCuchar, _indicator_type   );
    WSMFpropertyDef(WSNindicatorSize,   WSCuchar, _indicator_size   );
    WSMFpropertyDef(WSNindicatorShadow, WSCuchar, _indicator_shadow_thick );
    WSMFpropertyDef(WSNindicatorColor,  short,  _indicator_color );
    WSMFpropertyDef(WSNindicatorPixmap, short,  _indicator_pixmap );
    WSMFpropertyDef(WSNselectColor,     short,  _select_color );
    WSMFpropertyDef(WSNselectPixmap,    short,  _select_pixmap );
    WSMFpropertyDef(WSNlabelPixmap,    short,  _label_pixmap );
    WSMFpropertyDef(WSNorientation,     WSCuchar, _orientation  );



    virtual void setWorkWSNbackColor(short);
    virtual void  _adjust();
    static void _value_ch_handler(WSCbase*);

  public:
    WSCradioGroup(WSCbase*,char*);
    virtual ~WSCradioGroup();

    virtual void update();
    virtual long draw();

    virtual void onValueChange();
    virtual void onVisibleChange(WSCbool);

    long setItemSensitive(short no, WSCbool flag);
    WSCbool getItemSensitive(short no);
    WSCvradio* getItem(short no);

    WSMFguiClassDef(WSCradioGroup,WSCform);
    WSMFversionDef(WSCradioGroup);
};
#endif
