//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVDRAWINGAREA_H
#define WSCVDRAWINGAREA_H

#include <WScom.h>
#include <WSCnwbase.h>
#include <WSDimage.h>
#include <WSCvarc.h>
#define WSCvdrawingArea_VER  1000

#define WS_VDRAWINGAREA_MAXLEN_DEFAULT 64

class WSCvdrawingArea   :public WSCnwbase{

  protected:
    unsigned  _begin_draw_fl:1;
    unsigned  _use_pixmap:1;
    WSMFpropertyDef(WSNusePixmap,         WSCbool,  _use_pixmap);

    virtual long _device_initialize();

  public:

    WSCvdrawingArea(WSCbase* base, char* name);

    virtual ~WSCvdrawingArea();
    virtual long draw();
    virtual void update();
    virtual long execEventProc(long,void*);

    virtual long beginDraw();
    virtual long endDraw();

    long setForeColor(char* cname);
    long setBackColor(char* cname);
    long setLineWidth(short);
    long setLineDashType(char no);
    long setHatchPattern(char no);

    long setRegion(short x,short y,WSCushort w,WSCushort h);
    long drawArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2);
    long drawFillArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2,char kind);
    long drawLine(short x1,short y1,short x2,short y2);
    long drawLines(WSCpoint*,long num);
    long drawRect(short x,short y,WSCushort w,WSCushort h);
    long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    long drawRects(WSCrect*,long num);
    long drawFillRects(WSCrect*,long num);
    long drawPoly(WSCpoint*,long num);
    long drawFillPoly(WSCpoint*,long num);
    long drawGradation(long type,short col1,short col2,short col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);
    long drawGradation(long type,char* col1,char* col2,char* col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);

    long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    long drawImage(short x,short y,WSCushort,WSCushort,char*,char align);
    long drawStretchedImage(short x,short y,WSCushort,WSCushort,WSDimage*);
    long drawStretchedImage(short x,short y,WSCushort,WSCushort,char*);

    long drawString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                            char*,long encoding = WS_EN_DEFAULT);

    long drawFillString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                        char*,long encoding = WS_EN_DEFAULT);

    WSMFguiClassDef(WSCvdrawingArea,WSCnwbase);
    WSMFversionDef(WSCvdrawingArea);
};

#endif //WSCVDRAWINGAREA_H
