//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <advance/WSCclassPropEditor.h>
#include <advance/WSadcom.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSCvfbtn.h>
#include <WSDkeyboard.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSCmessageDialog.h>
#include <WSCfileSelect.h>
#include <WSCvtoggle.h>
#include <WSCvradio.h>
#include <WSDfile.h>
#include <WSCballoonHelp.h>
#include <WSClist.h>
#include <WSCpopupMenu.h>
#include <WSDappDev.h>

#define WS_WARNING_STR  WSGFgettext("L3:WSSTR Warning")

#define WS_DIALOG_PIX1  WS_PIXMAP_DIR "bi23.xpm"
#define WS_DIALOG_PIX2  WS_PIXMAP_DIR "ope.xpm"
#define WS_CREATE_PIX   WS_PIXMAP_DIR "wcreate.xpm"
#define WS_TRASH_PIX    WS_PIXMAP_DIR "wtrash.xpm"
#define WS_EDIT_PIX     WS_PIXMAP_DIR "edit.xpm"


#define WS_PEDBGCOLOR1 "#C5C5D5"
#define WS_PEDTITLE2   "Class:"

#define WS_PEDLB_W      500
#define WS_PEDLB_HEIGHT 250
#define WS_PEDLB_COL    16
#define WS_PEDLB_COL2   7


#define WS_PEDLD_WIDTH     350
#define WS_PEDLD_HEIGHT    290
#define WS_PEDLD_TWIDTH  170
#define WS_PEDLD_T       25
#define WS_PEDLD_LX      190
#define WS_PEDLD_LWIDTH  140
#define WS_PEDLD_ATTMENU WSGFgettext("C3:WSSTR Normal:0:,Invisible:4:,Deleted:1:,Default changed:2:,Hidden:3:")

#define WS_PEDLD_TGRMENU    \
"char:4:,WSCuchar:5:,short:2:,WSCushort:3:,\
int:12:,WSCuint:13:,long:0:,WSCulong:1:,\
WSCbool:11:,char*(string):9:,float:6,\
double:7:,void*:8:"

#define WS_PEDLDTITLE1   WSGFgettext("D3:WSSTR Target class:")
#define WS_PEDLDTITLE2   WSGFgettext("E3:WSSTR Property name:")
#define WS_PEDLDTITLE3   WSGFgettext("F3:WSSTR Property type:")
#define WS_PEDLDTITLE4   WSGFgettext("G3:WSSTR Variable name:")
#define WS_PEDLDTITLE5   WSGFgettext("H3:WSSTR Default value:")
#define WS_PEDLDTITLE6   WSGFgettext("I3:WSSTR Attribute:")
#define WS_PEDLDTITLE7   WSGFgettext("J3:WSSTR Builder title:")
#define WS_PEDLDTITLE8   WSGFgettext("K3:WSSTR Select menu:")
#define WS_PEDLDTITLE9   WSGFgettext("K3:WSSTR Edit...")

WSMFguiClassInitialize(WSCclassPropEditor,WSCbaseDialog);

WSCclassPropEditor::WSCclassPropEditor(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _client = NULL;
  _end_btn = NULL;
  _cmd_area1 = NULL;
  _tlbs4 = NULL;
  _oname = NULL;
  _msg = NULL;
  _voidp_client = NULL;
  _darea1 = NULL;
  _darea2 = NULL;
  _pmenu = NULL;
  _opt1 = NULL;
  _opt2 = NULL;
  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient, void*, _voidp_client,WSSclient );
    WSMFaddTrigger(WSEV_VALUE_CH);
  WSMFpropertyCreateEnd
}

//ץѥƥѥץκ
WSMFproperty( WSCclassPropEditor, WSNclient, void*,   _voidp_client,   NULL);

void WSCclassPropEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;
  setUserData("PCLIENT",client);
  setEditClient(client);
}

void WSCclassPropEditor::getWorkWSNclient(void** data){
  WSCbase* client = getEditClient();
  *data = (void*)client;
}

void WSCclassPropEditor::_end_btn_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  op_edit->setVisible(False);
}

void WSCclassPropEditor::_dialog2_set_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  if (op_edit->_dialog2->getStatus() != WS_DIALOG_OK){
    return;
  }
  WSCstring tmp;
  tmp = op_edit->_if20->getProperty(WSNlabelString);
  tmp.delHeadSpace();
  tmp.delTailSpace();
  if (!strcmp((char*)tmp,"")){
    tmp.setString(op_edit->_if2->getProperty(WSNlabelString));
    tmp.delHeadSpace();
    tmp.delTailSpace();
    tmp.replaceString("WSN","WSR",1);
    if (tmp.isExist("WSR") > -1){
      op_edit->_if20->setProperty(WSNlabelString,(char*)tmp);
    }else{
      WSCstring tmp2("WSR");
      tmp2 << tmp;
      op_edit->_if20->setProperty(WSNlabelString,(char*)tmp2);
    }
  }
  long num = op_edit->_vlist->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCstring tmp1;
    tmp1 = op_edit->_vlist->getItem(i);
    tmp << "," << tmp1;
  }
  op_edit->_vsname = tmp;
  op_edit->_vsname.replaceString(" ","\\S",0);
//printf("WSCclassPropEditor::_dialog2_set_work #%s#\n",(char*)tmp);
  op_edit->_dialog2->setVisible(False);
}
void WSCclassPropEditor::_value_set_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");

//Normal:0
//Invisible:4
//Deleted:1
//Default changed:2
//Hidden:3
  long value = obj->getProperty(WSNvalue);
//printf("WSCclassPropEditor::_value_set_work val=%d\n",value);
  if (value == 0 || value == 4){
    op_edit->_var_if->setSensitive(True);
    op_edit->_var_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    op_edit->_value_if->setSensitive(True);
    op_edit->_value_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    op_edit->_bname_if->setSensitive(True);
    op_edit->_bname_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
  }else if (value == 1){
    op_edit->_var_if->setSensitive(False);
    op_edit->_var_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    op_edit->_value_if->setSensitive(False);
    op_edit->_value_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    op_edit->_bname_if->setSensitive(False);
    op_edit->_bname_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
  }else if (value == 2){
    op_edit->_var_if->setSensitive(False);
    op_edit->_var_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    op_edit->_value_if->setSensitive(True);
    op_edit->_value_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    op_edit->_bname_if->setSensitive(False);
    op_edit->_bname_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
  }else if (value == 3){
    op_edit->_var_if->setSensitive(False);
    op_edit->_var_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    op_edit->_value_if->setSensitive(False);
    op_edit->_value_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    op_edit->_bname_if->setSensitive(False);
    op_edit->_bname_if->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
  }else{
    op_edit->_var_if->setSensitive(True);
    op_edit->_var_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    op_edit->_value_if->setSensitive(True);
    op_edit->_value_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    op_edit->_bname_if->setSensitive(True);
    op_edit->_bname_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
  }

}
void WSCclassPropEditor::_dialog_set_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  op_edit->_dialog2->setVisible(False);
  if (op_edit->_dialog1->getStatus() != WS_DIALOG_OK){
    return;
  }
  long no = (long)op_edit->_dialog1->getUserData("PROPERTY NO");
  WSCstring opname;
  opname.setString(op_edit->_if2->getProperty(WSNlabelString));
  opname.delLineFeed();
  opname.delHeadSpace();
  opname.delTailSpace();
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);


  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)320);
  if (opname.getWords() != 1 || strncmp(opname.getString(),"WSN",3) ||
      WSGFcheckNameString(opname.getString()) != True){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("M3:WSSTR Invalid property name.\nPlease specify another name like WSNxxxx..."));
    op_edit->_msg->setVisible(True);
    return;
  }

  long val;
  long val2;
  op_edit->_opt1->getPropertyV(WSNvalue,&val);
  op_edit->_opt2->getPropertyV(WSNvalue,&val2);

  WSCstring varname;
  varname.setString(op_edit->_var_if->getProperty(WSNlabelString));
  varname.delLineFeed();
  varname.delHeadSpace();
  varname.delTailSpace();
  varname.replaceString(".cpp","",0);
  varname.replaceString(".C","",0);

//Normal:0
//Invisible:4
//Deleted:1
//Default changed:2
//Hidden:3


  if ((val2 == 0 || val2 == 4) && WSGFcheckNameString(varname.getString()) != True){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR Invalid variable name..."));
    op_edit->_msg->setVisible(True);
    return;
  }

  if ((val2 == 0 || val2 == 4) && varname.getWords() != 1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR Invalid variable name..."));
    op_edit->_msg->setVisible(True);
    return;
  }

  if ((val2 == 0 || val2 == 4) && WSGFcheckNameString(varname.getString()) != True){
    long ret = WSGFexistName( varname.getString(),NULL );
    if (ret == 0){
       //OK.
    }else if (ret == WS_PROCEDURE_NAME){
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("O3:WSSTR This name is already used by another procedure..."));
      op_edit->_msg->setVisible(True);
      return;
    }else if (ret == WS_OBJECT_NAME){
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR This name is already used by another external instance."));
      op_edit->_msg->setVisible(True);
      return;
    }else if (ret == WS_OBJECT_ARRAY_NAME || ret == WS_OBJECT_ARRAY_NAME_INVALID){
      op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("Q3:WSSTR This name is already used by another external instance array."));
      op_edit->_msg->setVisible(True);
      return;
    }
  }

  op_edit->_dialog1->setVisible(False);

  if (no == -1 && op_edit->_client != NULL){ //ɲ
    WSClistData* property_list = (WSClistData*)op_edit->_client->getUserData(WS_PROP_LIST);
    if (property_list == NULL){
      property_list = new WSClistData();
      op_edit->_client->setUserData(WS_PROP_LIST,(void*)property_list);
    }

    long i;
    long num = property_list->getNum();
    for(i=0; i<num; i++){
        prop_data* propdata =  (prop_data*)(*property_list)[i];
        if ((val2 == 0 || val2 == 4) &&
            !strcmp(propdata->name.getString(),opname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("R3:WSSTR This property name is already used by another property."));
          op_edit->_msg->setVisible(True);
          return;
        }
        if ((val2 == 0||val2==4) && !strcmp(propdata->vname.getString(),varname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("S3:WSSTR The variable is already used."));
          op_edit->_msg->setVisible(True);
          return;
        }
    }

    prop_data* propdata = new prop_data();
    property_list->add((void*)propdata);

    if (op_edit->_use_file->getStatus() != False){
      propdata->use_file = True;
    }else{
      propdata->use_file = False;
    }
    propdata->name.setString( opname.getString() );
    propdata->vname.setString( varname.getString() );
    propdata->value.setString( op_edit->_value_if->getProperty(WSNlabelString) );
    propdata->value.delHeadSpace();
    propdata->value.delTailSpace();
    propdata->type = val;
    propdata->att = val2;
    propdata->bname.setString( op_edit->_bname_if->getProperty(WSNlabelString) );
    propdata->bname.delHeadSpace();
    propdata->bname.delTailSpace();

    op_edit->_vsname.replaceString(" ","\\S",0);
    propdata->values.setString( op_edit->_vsname );

    propdata->values.delHeadSpace();
    propdata->values.delTailSpace();

    WSGFmarkChanged(op_edit->_client);
    op_edit->updateProperties();
  }else if (op_edit->_client != NULL){
    WSClistData* property_list = (WSClistData*)op_edit->_client->getUserData(WS_PROP_LIST);
    if (property_list == NULL){
        property_list = new WSClistData();
        op_edit->_client->setUserData(WS_PROP_LIST,(void*)property_list);
    }
    if (property_list->getNum() > no){
      long i;
      long num = property_list->getNum();
      for(i=0; i<num; i++){
        if (i== no){
          continue;
        }
        prop_data* propdata =  (prop_data*)(*property_list)[i];
        if (val2 == 0 && !strcmp(propdata->name.getString(),opname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("R3:WSSTR This property name is already used by another property."));
          op_edit->_msg->setPropertyV(WSNlabelString,"ץѥƥ̾ʣƤޤ\nۤʤ̾ΤˤƲ");
          op_edit->_msg->setVisible(True);
          return;
        }
        if (val2 == 0 && !strcmp(propdata->vname.getString(),varname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("S3:WSSTR The variable is already used."));
          op_edit->_msg->setVisible(True);
          return;
        }
      }
      prop_data* propdata =  (prop_data*)(*property_list)[no];
      propdata->name.setString( opname.getString() );
      propdata->vname.setString( varname.getString() );
      propdata->value.setString( op_edit->_value_if->getProperty(WSNlabelString) );
      propdata->value.delHeadSpace();
      propdata->value.delTailSpace();
      propdata->type = val;
      propdata->att = val2;
      propdata->bname.setString( op_edit->_bname_if->getProperty(WSNlabelString) );
      propdata->bname.delHeadSpace();
      propdata->bname.delTailSpace();

      op_edit->_vsname.replaceString(" ","\\S",0);
      propdata->values.setString( op_edit->_vsname );
      propdata->values.delHeadSpace();
      propdata->values.delTailSpace();

      if (op_edit->_use_file->getStatus() != False){
        propdata->use_file = True;
      }else{
        propdata->use_file = False;
      }

      WSGFmarkChanged(op_edit->_client);
      op_edit->updateProperties();
    }
  }
  op_edit->onValueChange();
}

void WSCclassPropEditor::setSrcPath(char* path){
  _src_path.setString(path);
}

void WSCclassPropEditor::_ibtn1_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");

  if (op_edit->_client != NULL){
    op_edit->_if2->setPropertyV(WSNlabelString,"WSNnewProperty");
    op_edit->_var_if->setPropertyV(WSNlabelString,"");
    op_edit->_value_if->setPropertyV(WSNlabelString,"");
    op_edit->_bname_if->setPropertyV(WSNlabelString,"");
    op_edit->_vsname.setString("");
    op_edit->_opt1->setPropertyV(WSNvalue,(long)0);
    op_edit->_opt2->setPropertyV(WSNvalue,(long)0);
    op_edit->_opt2->execProcedure(WSEV_ACTIVATE);
    op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("T3:WSSTR Create"));
    op_edit->_use_file->setStatus(False,False);
    op_edit->_dialog1->setUserData("PROPERTY NO",(void*)-1);
    op_edit->_dialog1->setVisible(True);

  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);

    op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

    op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
  
}

void WSCclassPropEditor::_ibtn3_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);

  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedPropObj() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("V3:WSSTR Please select the property."));
    op_edit->_msg->setVisible(True);
    return;
  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX2);
    op_edit->_msg->setPropertyV(WSNtitleString,WSGFgettext("W3:WSSTR Question"));
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)350);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("X3:WSSTR Is it OK to delete the property?"));
    op_edit->_msg->setPropertyV(WSNuserValue,(long)op_edit);
    if (op_edit->_msg->popup() == WS_DIALOG_OK){
      WSCbase* client = op_edit->_client;
      if (client != NULL){
        WSClistData* property_list = (WSClistData*)client->getUserData(WS_PROP_LIST);
        if (property_list != NULL){
          long num = property_list->getNum();
          long no = op_edit->getSelectedPropObj();
          if (no < num){
            prop_data* propdata = (prop_data*)(*property_list)[no];
            property_list->del((void*)propdata);
            delete propdata;
          }
          WSGFmarkChanged(client);
          op_edit->updateProperties();
        }
      }
    }
  }
}

void WSCclassPropEditor::_ibtn2_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);

  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedPropObj() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("V3:WSSTR Please select the property."));
    op_edit->_msg->setVisible(True);
    return;
  }
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }

  WSClistData* property_list = (WSClistData*)op_edit->_client->getUserData(WS_PROP_LIST);

  prop_data* propdata = (prop_data*)(*property_list)[op_edit->getSelectedPropObj()];
  op_edit->_if2->setPropertyV(WSNlabelString,propdata->name.getString());
  op_edit->_var_if->setPropertyV(WSNlabelString,propdata->vname.getString());
  op_edit->_value_if->setPropertyV(WSNlabelString,propdata->value.getString());
  op_edit->_opt1->setPropertyV(WSNvalue,(long)propdata->type);
  op_edit->_opt2->setPropertyV(WSNvalue,(long)propdata->att);
  op_edit->_opt2->execProcedure(WSEV_ACTIVATE);
  op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("Y3:WSSTR Update"));
  op_edit->_bname_if->setPropertyV(WSNlabelString,propdata->bname.getString());
  op_edit->_vsname.setString(propdata->values.getString());
  op_edit->_vsname.replaceString(" ","\\S",0);
  if (propdata->use_file != False){
    op_edit->_use_file->setStatus(True,False);
  }else{
    op_edit->_use_file->setStatus(False,False);
  }

  //-1 is create mode,the other is edit mode.
  op_edit->_dialog1->setUserData("PROPERTY NO",(void*)op_edit->getSelectedPropObj());
  op_edit->_dialog1->setVisible(True);
}

long WSCclassPropEditor::getSelectedPropObj(){
  return _list->getSelectedPos();
}

long WSCclassPropEditor::initialize(){
  WSCbaseDialog::initialize();

  setPropertyV(WSNwidth,(WSCushort)WS_PEDLB_W);
  setPropertyV(WSNheight,(WSCushort)WS_PEDLB_HEIGHT);
  setPropertyV(WSNshadowThickness,(WSCuchar)1);
  setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
//  setPropertyV(WSNtitleBar,(char)WS_ONLY_TITLE);
  setPropertyV(WSNok,(WSCbool)False);
  setPropertyV(WSNno,(WSCbool)False);
  setPropertyV(WSNtitleString,"Property Setup");

  _cmd_area1 = new WSCform(this,"pe-area1");
  _cmd_area1->initialize();
  _cmd_area1->setInternalObject(True);
  _cmd_area1->setPropertyV(WSNx,     (short)1 );
  _cmd_area1->setPropertyV(WSNy,     (short)5 );
  _cmd_area1->setPropertyV(WSNwidth, (WSCushort)(_w));
  _cmd_area1->setPropertyV(WSNheight,(WSCushort)30);
  _cmd_area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cmd_area1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cmd_area1->setVisible(True);

  WSCvlabel* sp2 = new WSCvlabel(_cmd_area1,"pe-tlb");
  sp2->initialize();
  sp2->setInternalObject(True);
  sp2->setPropertyV(WSNx,     (short)0 );
  sp2->setPropertyV(WSNy,     (short)30 );
  sp2->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp2->setPropertyV(WSNheight,(WSCushort)2 );
  sp2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp2->setVisible(True);

  WSCvfbtn* ibtn1 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn1->initialize();
  ibtn1->setInternalObject(True);
  ibtn1->setPropertyV(WSNx,         (short)1                  );
  ibtn1->setPropertyV(WSNy,         (short)1                  );
  ibtn1->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn1->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn1->setPropertyV(WSNlabelPixmap,WSGFimage(WS_CREATE_PIX));
  ibtn1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn1->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn1,0);
  WSGIappBalloonHelp()->registerClient(ibtn1,WSGFgettext("Z3:WSSTR Create new property"));

  WSCprocedure* iop1 = new WSCprocedure("iop1",WSEV_ACTIVATE);
  iop1->setFunction(_ibtn1_work,"_ibtn1_work");
  ibtn1->addProcedure(iop1);
  ibtn1->setVisible(True);

  WSCvfbtn* ibtn2 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn2->initialize();
  ibtn2->setInternalObject(True);
  ibtn2->setPropertyV(WSNx,         (short)31                 );
  ibtn2->setPropertyV(WSNy,         (short)1                  );
  ibtn2->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn2->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn2->setPropertyV(WSNlabelPixmap,WSGFimage(WS_EDIT_PIX));
  ibtn2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn2->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn2,0);
  WSGIappBalloonHelp()->registerClient(ibtn2,WSGFgettext("a3:WSSTR Edit property"));

  WSCprocedure* iop2 = new WSCprocedure("iop2",WSEV_ACTIVATE);
  iop2->setFunction(_ibtn2_work,"_ibtn2_work");
  ibtn2->addProcedure(iop2);
  ibtn2->setVisible(True);

  WSCvfbtn* ibtn3 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn3->initialize();
  ibtn3->setInternalObject(True);
  ibtn3->setPropertyV(WSNx,         (short)61                 );
  ibtn3->setPropertyV(WSNy,         (short)1                  );
  ibtn3->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn3->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn3->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn3->setPropertyV(WSNlabelPixmap,WSGFimage(WS_TRASH_PIX));
  ibtn3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn3->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn3,0);
  WSGIappBalloonHelp()->registerClient(ibtn3,WSGFgettext("b3:WSSTR Delete property"));

  WSCprocedure* iop3 = new WSCprocedure("iop3",WSEV_ACTIVATE);
  iop3->setFunction(_ibtn3_work,"_ibtn3_work");
  ibtn3->addProcedure(iop3);
  ibtn3->setVisible(True);

  _tlbs4 = new WSCvlabel(_cmd_area1,"pe-tlbs4");
  _tlbs4->initialize();
  _tlbs4->setPropertyV(WSNx,     (short)135 );
  _tlbs4->setPropertyV(WSNy,     (short)5 );
  _tlbs4->setPropertyV(WSNwidth, (WSCushort)60 );
  _tlbs4->setPropertyV(WSNheight,(WSCushort)20 );
  _tlbs4->setPropertyV(WSNforeColor,"black" );
  _tlbs4->setPropertyV(WSNlabelString,WS_PEDTITLE2);
  _tlbs4->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _tlbs4->setVisible(True);

  _oname = new WSCvlabel(_cmd_area1,"pe-tlb");
  _oname->initialize();
  _oname->setPropertyV(WSNx,     (short)200 );
  _oname->setPropertyV(WSNy,     (short)4 );
  _oname->setPropertyV(WSNwidth, (WSCushort)100 );
  _oname->setPropertyV(WSNheight,(WSCushort)21 );
  _oname->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _oname->setPropertyV(WSNforeColor,"blue4");
  _oname->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _oname->setVisible(True);

  _list = new WSClist(_cmd_area1,"pe-area2");
  _list->initialize();
  _list->setInternalObject(True);
  _list->setPropertyV(WSNx,     (short)5 );
  _list->setPropertyV(WSNy,     (short)35 );
  _list->setPropertyV(WSNwidth, (WSCushort)(_w - 10));
  _list->setPropertyV(WSNheight,(WSCushort)(_h -35));
//  _list->setPropertyV(WSNworkWidth, (WSCushort)(_w));
//  _list->setPropertyV(WSNworkHeight,(WSCushort)(_h));
  _list->setPropertyV(WSNscrollHeight,(WSCushort)5);
  _list->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _list->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _list->setPropertyV(WSNbarValue,"70,200,300,350");
  _list->setPropertyV(WSNtitleHeight,(WSCuchar)20);
  _list->setPropertyV(WSNtitleString,WSGFgettext("c3:WSSTR Type,Property name,Member name,Attribute,Default value"));
  _list->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _list->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _list->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _list->setVisible(True);

  _pmenu = new WSCpopupMenu(NULL,"menu");
  _pmenu->initialize();
  _pmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  _pmenu->setPropertyV(WSNmenuItems,WSGFgettext("d3:WSSTR New:NEW:,Edit:EDIT:,Delete:DEL:"));
  _pmenu->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _pmenu->setEmboss(True);
  _pmenu->setUserData("WIN EDIT",(void*)this); 

  WSCprocedure* pmop = new WSCprocedure("NEW",WSEV_NONE);
  pmop->setFunction(_ibtn1_work,"_ibtn1_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("EDIT",WSEV_NONE);
  pmop->setFunction(_ibtn2_work,"_ibtn2_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(_ibtn3_work,"_ibtn3_work");
  _pmenu->addProcedure(pmop);

  _pmenu->registerClient(_list->getScrFrame());

  _msg = new WSCmessageDialog(NULL,"wl-md");
  _msg->initialize();
  _msg->setPropertyV(WSNx,(short)300);
  _msg->setPropertyV(WSNy,(short)300);
  _msg->setPropertyV(WSNwidth,(WSCushort)300);
  _msg->setPropertyV(WSNheight,(WSCushort)100);
  _msg->setPropertyV(WSNtitleString,"Warring");
  _msg->setPropertyV(WSNmodal,(WSCbool)True);

  //---------- PROCEDURE CREATE DIALOG -------------------- 
  _dialog1 = new WSCbaseDialog(this,"dlg_base");
  _dialog1->initialize();
  _dialog1->setInternalObject(True);
  _dialog1->setPropertyV(WSNx,(short)300);
  _dialog1->setPropertyV(WSNy,(short)300);
  _dialog1->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_WIDTH);
  _dialog1->setPropertyV(WSNheight,(WSCushort)WS_PEDLD_HEIGHT);
  _dialog1->setPropertyV(WSNtitleString,"PropertyCreate");
  _dialog1->setPropertyV(WSNno,(WSCbool)False);
  _dialog1->setUserData("WIN EDIT",(void*)this); 
  WSCprocedure* dop1 = new WSCprocedure("dop1",WSEV_ACTIVATE);
  dop1->setFunction(_dialog_set_work,"_dialog_set_work");
  _dialog1->addProcedure(dop1);
  WSCprocedure* dop11 = new WSCprocedure("dop11",WSEV_RESIZE);
  dop11->setFunction(_dialog1_resize_work,"_dialog1_resize_work");
  _dialog1->addProcedure(dop11);

  _darea1 = new WSCform(_dialog1->getFormObject(),"pe-_darea1");
  _darea1->initialize();
  _darea1->setInternalObject(True);
  _darea1->setPropertyV(WSNx,     (short)1 );
  _darea1->setPropertyV(WSNy,     (short)35 );
  _darea1->setPropertyV(WSNwidth, (WSCushort)(WS_PEDLD_WIDTH -2));
  _darea1->setPropertyV(WSNheight,(WSCushort)(WS_PEDLD_HEIGHT -75));
  _darea1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _darea1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _darea1->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
  _darea1->setVisible(True);

  WSCvlabel* sp1 = new WSCvlabel(_darea1,"pe-tlb");
  sp1->initialize();
  sp1->setInternalObject(True);
  sp1->setPropertyV(WSNx,     (short)0 );
  sp1->setPropertyV(WSNy,     (short)30 );
  sp1->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp1->setPropertyV(WSNheight,(WSCushort)2 );
  sp1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp1->setVisible(True);

  _if1 = new WSCvlabel(_darea1,"pe-tlb");
  _if1->initialize();
  _if1->setInternalObject(True);
  _if1->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if1->setPropertyV(WSNy,     (short)5 );
  _if1->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if1->setPropertyV(WSNheight,(WSCushort)20 );
  _if1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _if1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _if1->setVisible(True);

  _if2 = new WSCvifield(_darea1,"pe-tlb");
  _if2->initialize();
  _if2->setInternalObject(True);
  _if2->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if2->setPropertyV(WSNy,     (short)35 );
  _if2->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if2->setPropertyV(WSNheight,(WSCushort)20 );
  _if2->setPropertyV(WSNcolumns,(WSCushort)18 );
  _if2->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if2->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if2->setPropertyV(WSNfillSpace,(WSCbool)False);
  _if2->setPropertyV(WSNinterCur,(WSCbool)True);
  _if2->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _if2->setVisible(True);

  _var_if = new WSCvifield(_darea1,"pe-tlb");
  _var_if->initialize();
  _var_if->setInternalObject(True);
  _var_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _var_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2) );
  _var_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _var_if->setPropertyV(WSNheight,(WSCushort)20 );
  _var_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _var_if->setPropertyV(WSNmaxLength,(WSCushort)16 );
  _var_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _var_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _var_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _var_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _var_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _var_if->setVisible(True);

  _value_if = new WSCvifield(_darea1,"pe-tlb");
  _value_if->initialize();
  _value_if->setInternalObject(True);
  _value_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _value_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*3) );
  _value_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _value_if->setPropertyV(WSNheight,(WSCushort)20 );
  _value_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _value_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _value_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _value_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _value_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _value_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _value_if->setPropertyV(WSNlabelString,"");
  _value_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _value_if->setVisible(True);

  _opt1 = new WSCoption(_darea1,"typeopt");
  _opt1->initialize();
  _opt1->setInternalObject(True);
  _opt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _opt1->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _opt1->setPropertyV(WSNy,(short)(35 + WS_PEDLD_T));
  _opt1->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _opt1->setPropertyV(WSNheight,(WSCushort)20);
  _opt1->setPropertyV(WSNmenuItems,WS_PEDLD_TGRMENU);
  _opt1->setPropertyV(WSNemboss,(WSCbool)True);
  _opt1->setVisible(True);

  _opt2 = new WSCoption(_darea1,"popt");
  _opt2->initialize();
  _opt2->setInternalObject(True);
  _opt2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _opt2->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _opt2->setPropertyV(WSNy,(short)(35 + WS_PEDLD_T*4));
  _opt2->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _opt2->setPropertyV(WSNheight,(WSCushort)20);
  _opt2->setPropertyV(WSNmenuItems,WS_PEDLD_ATTMENU);
  _opt2->setPropertyV(WSNemboss,(WSCbool)True);
  _opt2->setVisible(True);
  _opt2->setUserData("WIN EDIT",(void*)this); 

  WSCprocedure* vchop1 = new WSCprocedure("vshop1",WSEV_ACTIVATE);
  vchop1->setFunction(_value_set_work,"_value_set_work");
  _opt2->addProcedure(vchop1);

//XXZZ

  _bname_if = new WSCvifield(_darea1,"pe-tlb");
  _bname_if->initialize();
  _bname_if->setInternalObject(True);
  _bname_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _bname_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*5) );
  _bname_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _bname_if->setPropertyV(WSNheight,(WSCushort)20 );
  _bname_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _bname_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _bname_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _bname_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _bname_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _bname_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _bname_if->setPropertyV(WSNlabelString,"");
  _bname_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _bname_if->setVisible(True);
#if 0
  _vsname_if = new WSCvifield(_darea1,"pe-tlb");
  _vsname_if->initialize();
  _vsname_if->setInternalObject(True);
  _vsname_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _vsname_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*6) );
  _vsname_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _vsname_if->setPropertyV(WSNheight,(WSCushort)20 );
  _vsname_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _vsname_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _vsname_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _vsname_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _vsname_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _vsname_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _vsname_if->setPropertyV(WSNlabelString,"");
  _vsname_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _vsname_if->setVisible(True);
#endif

  _vsname_btn = new WSCvbtn(_darea1,"pe-tlb");
  _vsname_btn->initialize();
  _vsname_btn->setInternalObject(True);
  _vsname_btn->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _vsname_btn->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*6) );
  _vsname_btn->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _vsname_btn->setPropertyV(WSNheight,(WSCushort)20 );
  _vsname_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _vsname_btn->setPropertyV(WSNlabelString, WS_PEDLDTITLE9);
  _vsname_btn->setVisible(True);
  _vsname_btn->setUserData("WIN EDIT",(void*)this); 

  WSCprocedure* vsop1 = new WSCprocedure("vsop1",WSEV_ACTIVATE);
  vsop1->setFunction(_vsname_set_work,"_vsname_set_work");
  _vsname_btn->addProcedure(vsop1);

  WSCvlabel* tlbs1 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs1->initialize();
  tlbs1->setPropertyV(WSNx,     (short)5 );
  tlbs1->setPropertyV(WSNy,     (short)5 );
  tlbs1->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs1->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs1->setPropertyV(WSNforeColor,"black" );
  tlbs1->setPropertyV(WSNlabelString,WS_PEDLDTITLE1);
  tlbs1->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs1->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs1,0);
  tlbs1->setVisible(True);
 
  WSCvlabel* tlbs2 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs2->initialize();
  tlbs2->setPropertyV(WSNx,     (short)5 );
  tlbs2->setPropertyV(WSNy,     (short)35 );
  tlbs2->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs2->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs2->setPropertyV(WSNforeColor,"black" );
  tlbs2->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs2->setPropertyV(WSNlabelString,WS_PEDLDTITLE2);
  tlbs2->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs2,0);
  tlbs2->setVisible(True);
 
  WSCvlabel* tlbs3 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs3->initialize();
  tlbs3->setPropertyV(WSNx,     (short)5 );
  tlbs3->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T) );
  tlbs3->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs3->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs3->setPropertyV(WSNforeColor,"black" );
  tlbs3->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs3->setPropertyV(WSNlabelString,WS_PEDLDTITLE3);
  tlbs3->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs3,0);
  tlbs3->setVisible(True);
 
  WSCvlabel* tlbs4 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs4->initialize();
  tlbs4->setPropertyV(WSNx,     (short)5 );
  tlbs4->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2) );
  tlbs4->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs4->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs4->setPropertyV(WSNforeColor,"black" );
  tlbs4->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs4->setPropertyV(WSNlabelString,WS_PEDLDTITLE4);
  tlbs4->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs4,0);
  tlbs4->setVisible(True);
 
  WSCvlabel* tlbs5 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs5->initialize();
  tlbs5->setPropertyV(WSNx,     (short)5 );
  tlbs5->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*3) );
  tlbs5->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs5->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs5->setPropertyV(WSNforeColor,"black" );
  tlbs5->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs5->setPropertyV(WSNlabelString,WS_PEDLDTITLE5);
  tlbs5->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs5,0);
  tlbs5->setVisible(True);

  WSCvlabel* tlbs6 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs6->initialize();
  tlbs6->setPropertyV(WSNx,     (short)5 );
  tlbs6->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*4) );
  tlbs6->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs6->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs6->setPropertyV(WSNforeColor,"black" );
  tlbs6->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs6->setPropertyV(WSNlabelString,WS_PEDLDTITLE6);
  tlbs6->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs6,0);
  tlbs6->setVisible(True);

  WSCvlabel* tlbs7 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs7->initialize();
  tlbs7->setPropertyV(WSNx,     (short)5 );
  tlbs7->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*5) );
  tlbs7->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs7->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs7->setPropertyV(WSNforeColor,"black" );
  tlbs7->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs7->setPropertyV(WSNlabelString,WS_PEDLDTITLE7);
  tlbs7->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs7,0);
  tlbs7->setVisible(True);

  WSCvlabel* tlbs8 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs8->initialize();
  tlbs8->setPropertyV(WSNx,     (short)5 );
  tlbs8->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*6) );
  tlbs8->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs8->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs8->setPropertyV(WSNforeColor,"black" );
  tlbs8->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs8->setPropertyV(WSNlabelString,WS_PEDLDTITLE8);
  tlbs8->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs8,0);
  tlbs8->setVisible(True);

      //-------END BTN SETTING ---------//
//  _use_file = new WSCvtoggle(_darea1,"ope-use_file");
  _use_file = new WSCvradio(_darea1,"ope-use_file");
  _use_file->initialize();
  _use_file->setInternalObject(True);
  _use_file->setPropertyV(WSNx, (short)5);
  _use_file->setPropertyV(WSNy, (short)(35 + WS_PEDLD_T*7)  );
  _use_file->setPropertyV(WSNwidth, (WSCushort)320);
  _use_file->setPropertyV(WSNheight,(WSCushort)24);
  _use_file->setPropertyV(WSNlabelString, WSGFgettext("e3:WSSTR  Use the handler defined by user"));
  _use_file->setPropertyV(WSNmarginLeft, (WSCuchar)10);
  _use_file->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
//  _use_file->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
//  _use_file->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
//  _use_file->setPropertyV(WSNindicatorType,WS_IN);
  _use_file->setPropertyV(WSNindicatorSize,(WSCuchar)16);
//  _use_file->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _use_file->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  WSGFsetMargin(_use_file,0);
  _use_file->setVisible(True);

  //---------- PROCEDURE CREATE DIALOG --------------------
  _dialog2 = new WSCbaseDialog(this,"dlg_base");
  _dialog2->initialize();
  _dialog2->setInternalObject(True);
  _dialog2->setPropertyV(WSNx,(short)300);
  _dialog2->setPropertyV(WSNy,(short)300);
  _dialog2->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_WIDTH);
  _dialog2->setPropertyV(WSNheight,(WSCushort)WS_PEDLD_HEIGHT);
  _dialog2->setPropertyV(WSNtitleString,"RemoteMethodCreate");
  _dialog2->setPropertyV(WSNno,(WSCbool)False);
  _dialog2->setUserData("WIN EDIT",(void*)this);
  WSCprocedure* dop2 = new WSCprocedure("dop2",WSEV_ACTIVATE);
  dop2->setFunction(_dialog2_set_work,"_dialog2_set_work");
  _dialog2->addProcedure(dop2);
  WSCprocedure* dop21 = new WSCprocedure("dop21",WSEV_RESIZE);
  dop21->setFunction(_dialog2_resize_work,"_dialog2_resize_work");
  _dialog2->addProcedure(dop21);

  _darea2 = new WSCform(_dialog2->getFormObject(),"pe-_darea1");
  _darea2->initialize();
  _darea2->setInternalObject(True);
  _darea2->setPropertyV(WSNx,     (short)1 );
  _darea2->setPropertyV(WSNy,     (short)0 );
  _darea2->setPropertyV(WSNwidth, (WSCushort)(WS_PEDLD_WIDTH -2));
  _darea2->setPropertyV(WSNheight,(WSCushort)(WS_PEDLD_HEIGHT -45));
  _darea2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _darea2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _darea2->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
  _darea2->setVisible(True);

  WSCvlabel* lb20 = new WSCvlabel(_darea2,"pe-tlb");
  lb20->initialize();
  lb20->setInternalObject(True);
  lb20->setPropertyV(WSNx,     (short)10 );
  lb20->setPropertyV(WSNy,(short)(5));
  lb20->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  lb20->setPropertyV(WSNheight,(WSCushort)20 );
  lb20->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Name of the struct:"));
  lb20->setProperty(WSNshadowType,WS_SHADOW_TRANS);
  lb20->setProperty(WSNalignmentH,WS_LEFT);
  lb20->setProperty(WSNanchorRight,20+WS_PEDLD_LWIDTH);
  lb20->setProperty(WSNanchorRightFlag,True);
  lb20->setVisible(True);


  WSCvlabel* sp11 = new WSCvlabel(_darea2,"pe-tlb");
  sp11->initialize();
  sp11->setInternalObject(True);
  sp11->setPropertyV(WSNx,     (short)0 );
  sp11->setPropertyV(WSNy,     (short)30 );
  sp11->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp11->setPropertyV(WSNheight,(WSCushort)2 );
  sp11->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp11->setVisible(True);

  WSCvlabel* lb21 = new WSCvlabel(_darea2,"pe-tlb");
  lb21->initialize();
  lb21->setInternalObject(True);
  lb21->setPropertyV(WSNx,     (short)10 );
  lb21->setPropertyV(WSNy,(short)(40));
  lb21->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  lb21->setPropertyV(WSNheight,(WSCushort)20 );
  lb21->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Name of the value:"));
  lb21->setProperty(WSNshadowType,WS_SHADOW_TRANS);
  lb21->setProperty(WSNalignmentH,WS_LEFT);
  lb21->setProperty(WSNanchorRight,20+WS_PEDLD_LWIDTH);
  lb21->setProperty(WSNanchorRightFlag,True);
  lb21->setVisible(True);

  WSCvlabel* lb22 = new WSCvlabel(_darea2,"pe-tlb");
  lb22->initialize();
  lb22->setInternalObject(True);
  lb22->setPropertyV(WSNx,     (short)10 );
  lb22->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T));
  lb22->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  lb22->setPropertyV(WSNheight,(WSCushort)20 );
  lb22->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Value:"));
  lb22->setProperty(WSNshadowType,WS_SHADOW_TRANS);
  lb22->setProperty(WSNanchorRight,20+WS_PEDLD_LWIDTH);
  lb22->setProperty(WSNanchorRightFlag,True);
  lb22->setVisible(True);

  _if20 = new WSCvifield(_darea2,"pe-tlb");
  _if20->initialize();
  _if20->setInternalObject(True);
  _if20->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if20->setPropertyV(WSNy,(short)(5));
  _if20->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if20->setPropertyV(WSNheight,(WSCushort)20 );
  _if20->setPropertyV(WSNcolumns,(WSCushort)18 );
  _if20->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if20->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _if20->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if20->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if20->setProperty(WSNanchorRight,10);
  _if20->setProperty(WSNanchorRightFlag,True);
  _if20->setVisible(True);


  _if21 = new WSCvifield(_darea2,"pe-tlb");
  _if21->initialize();
  _if21->setInternalObject(True);
  _if21->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if21->setPropertyV(WSNy,(short)(40));
  _if21->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if21->setPropertyV(WSNheight,(WSCushort)20 );
  _if21->setPropertyV(WSNcolumns,(WSCushort)18 );
  _if21->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if21->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _if21->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if21->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if21->setProperty(WSNanchorRight,10);
  _if21->setProperty(WSNanchorRightFlag,True);
  _if21->setVisible(True);

  _if22 = new WSCvifield(_darea2,"pe-tlb");
  _if22->initialize();
  _if22->setInternalObject(True);
  _if22->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _if22->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T));
  _if22->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if22->setPropertyV(WSNheight,(WSCushort)20 );
  _if22->setPropertyV(WSNcolumns,(WSCushort)18 );
  _if22->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if22->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if22->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
//  _if22->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _if22->setProperty(WSNanchorRight,10);
  _if22->setProperty(WSNanchorRightFlag,True);
  _if22->setVisible(True);

  _add_btn = new WSCvbtn(_darea2,"popt");
  _add_btn->initialize();
  _add_btn->setInternalObject(True);
  _add_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _add_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _add_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*2));
  _add_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _add_btn->setPropertyV(WSNheight,(WSCushort)20);
  _add_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Add"));
  _add_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _add_btn->setProperty(WSNanchorRight,10);
  _add_btn->setProperty(WSNanchorRightFlag,True);
  _add_btn->setUserData("WIN EDIT",(void*)this);
  _add_btn->setVisible(True);

  WSCprocedure* p_op1 = new WSCprocedure("p_op1",WSEV_ACTIVATE);
  p_op1->setFunction(_addv_work,"_addv_work");
  _add_btn->addProcedure(p_op1);

  _del_btn = new WSCvbtn(_darea2,"popt");
  _del_btn->initialize();
  _del_btn->setInternalObject(True);
  _del_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _del_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _del_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*3));
  _del_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _del_btn->setPropertyV(WSNheight,(WSCushort)20);
  _del_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Del"));
  _del_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _del_btn->setProperty(WSNanchorRight,10);
  _del_btn->setProperty(WSNanchorRightFlag,True);
  _del_btn->setUserData("WIN EDIT",(void*)this);
  _del_btn->setVisible(True);

  WSCprocedure* p_op2 = new WSCprocedure("p_op2",WSEV_ACTIVATE);
  p_op2->setFunction(_delv_work,"_delv_work");
  _del_btn->addProcedure(p_op2);

  _up_btn = new WSCvbtn(_darea2,"popt");
  _up_btn->initialize();
  _up_btn->setInternalObject(True);
  _up_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _up_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _up_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*4));
  _up_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _up_btn->setPropertyV(WSNheight,(WSCushort)20);
  _up_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Up"));
  _up_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _up_btn->setProperty(WSNanchorRight,10);
  _up_btn->setProperty(WSNanchorRightFlag,True);
  _up_btn->setUserData("WIN EDIT",(void*)this);
  _up_btn->setVisible(True);

  WSCprocedure* p_op3 = new WSCprocedure("p_op3",WSEV_ACTIVATE);
  p_op3->setFunction(_upv_work,"_upv_work");
  _up_btn->addProcedure(p_op3);

  _down_btn = new WSCvbtn(_darea2,"popt");
  _down_btn->initialize();
  _down_btn->setInternalObject(True);
  _down_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _down_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _down_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*5));
  _down_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _down_btn->setPropertyV(WSNheight,(WSCushort)20);
  _down_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Down"));
  _down_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _down_btn->setProperty(WSNanchorRight,10);
  _down_btn->setProperty(WSNanchorRightFlag,True);
  _down_btn->setUserData("WIN EDIT",(void*)this);
  _down_btn->setVisible(True);

  WSCprocedure* p_op4 = new WSCprocedure("p_op4",WSEV_ACTIVATE);
  p_op4->setFunction(_downv_work,"_downv_work");
  _down_btn->addProcedure(p_op4);

  _vlist = new WSClist(_darea2,"pe-area2");
  _vlist->initialize();
  _vlist->setInternalObject(True);
  _vlist->setPropertyV(WSNx,     (short)5 );
  _vlist->setPropertyV(WSNy,     (short)(40 + WS_PEDLD_T*2) );
  _vlist->setPropertyV(WSNwidth, (WSCushort)(WS_PEDLD_WIDTH -170));
  _vlist->setPropertyV(WSNheight,(WSCushort)((WS_PEDLD_HEIGHT -45)-(40 + WS_PEDLD_T)) );
  _vlist->setProperty(WSNanchorTopFlag,True);
  _vlist->setProperty(WSNanchorTop, (40 + WS_PEDLD_T*2));
  _vlist->setProperty(WSNanchorBottom,(WSCushort)(10));
  _vlist->setProperty(WSNanchorBottomFlag,True);
  _vlist->setProperty(WSNanchorRightFlag,True);
  _vlist->setProperty(WSNanchorRight,(WSCushort)(160));
  _vlist->setProperty(WSNanchorLeftFlag,True);
  _vlist->setProperty(WSNanchorLeft,(WSCushort)(5));

  _vlist->setPropertyV(WSNscrollHeight,(WSCushort)5);
  _vlist->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _vlist->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _vlist->setPropertyV(WSNbarValue,"80");
  _vlist->setPropertyV(WSNtitleHeight,(WSCuchar)20);
  _vlist->setPropertyV(WSNtitleString,WSGFgettext("c3:WSSTR Name,Value"));
  _vlist->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _vlist->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _vlist->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _vlist->setVisible(True);


//XXZZ


  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  _adjust(); 
  return WS_NO_ERR;
}

void WSCclassPropEditor::setEditClient(WSCbase* client){
//WSMFtrace("WSCclassPropEditor::setEditClient\n");
  if (_client != client){
     _client = client;
//WSMFtrace("WSCclassPropEditor::setEditClient  dialgo1->setVisible(False)\n");
     _dialog1->setVisible(False);
     updateProperties();
  }
}

WSCbase* WSCclassPropEditor::getEditClient(){
  return _client;
}

void WSCclassPropEditor::updateProperties(){
  _list->delAll();


  WSCbase* client = getEditClient();

  if (client == NULL){
    _oname->setPropertyV(WSNlabelString,"");
    _oname->update();
    _if1->setPropertyV(WSNlabelString,"");
    _if1->update();
    _var_if->setPropertyV(WSNlabelString,"");
    _var_if->update();
    _value_if->setPropertyV(WSNlabelString,"");
    _value_if->update();
    _dialog1->setVisible(False);
    return;
  }

  _oname->setPropertyV(WSNlabelString,client->getInstanceName());
  _oname->update();
  _if1->setPropertyV(WSNlabelString,client->getInstanceName());
  _if1->update();
  _dialog1->setVisible(False);


  WSClistData* property_list = (WSClistData*)client->getUserData(WS_PROP_LIST);
  if (property_list == NULL){
    property_list = new WSClistData();
    client->setUserData(WS_PROP_LIST,(void*)property_list);
  }
  _list->setLabelHeight(20);

  long num = property_list->getNum();
  long i;
  for(i=0; i< num; i++){
     prop_data* propdata = (prop_data*)(*property_list)[i];
     WSCstring str;
extern char* WSGFvalueToType(long);
     str = WSGFvalueToType(propdata->type);
     str << "," << propdata->name.getString() << "," ;

     
     str << propdata->vname.getString() << ",";
     if (propdata->att == 0){
       str << WSGFgettext("f3:WSSTR (Normal)");
     }else if (propdata->att == 1){
       str << WSGFgettext("g3:WSSTR (Deleted)");
     }else if (propdata->att == 2){
       str << WSGFgettext("h3:WSSTR (DefaultChanged)");
     }else if (propdata->att == 3){
       str << WSGFgettext("i3:WSSTR (Hidden)");
     }else if (propdata->att == 4){
       str << WSGFgettext("j3:WSSTR (Invisible)");
     }
     str << "," << propdata->value.getString();
     _list->addItem((char*)str);
     WSCbase* lb = _list->getLabel(-1);
     lb->setPropertyV(WSNmarginLeft,(WSCuchar)5);
  }
  _list->updateList();
  _list->redraw();
}

void WSCclassPropEditor::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}

void WSCclassPropEditor::onResize(WSCrect* rect){
  WSCbaseDialog::onResize(rect);
  _adjust();
}
void WSCclassPropEditor::_vsname_set_work(WSCbase* obj){
  WSCclassPropEditor* edit = 
               (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  if (edit == NULL){
    return;
  }
  WSCstring vsname;
  vsname = edit->_vsname;
  vsname.replaceString("\\S"," ",0);
  long num = edit->_vsname.getWords(",");
  if (num <1){
    WSCstring tmp;
    tmp.setString(edit->_if2->getProperty(WSNlabelString));
    tmp.delHeadSpace();
    tmp.delTailSpace();
    tmp.replaceString("WSN","WSR",1);
    if (tmp.isExist("WSR") > -1){
      edit->_if20->setProperty(WSNlabelString,(char*)tmp);
    }else{
      WSCstring tmp2("WSR");
      tmp2 << tmp;
      edit->_if20->setProperty(WSNlabelString,(char*)tmp2);
    }
  }else{
    WSCstring tmp;
    tmp = vsname.getWord(0,",");
    tmp.delHeadSpace();
    tmp.delTailSpace();
    if (!strcmp((char*)tmp,"")){
      tmp.setString(edit->_if2->getProperty(WSNlabelString));
      tmp.delHeadSpace();
      tmp.delTailSpace();
      tmp.replaceString("WSN","WSR",1);
      if (tmp.isExist("WSR") > -1){
        edit->_if20->setProperty(WSNlabelString,(char*)tmp);
      }else{
        WSCstring tmp2("WSR");
        tmp2 << tmp;
        edit->_if20->setProperty(WSNlabelString,(char*)tmp2);
      }
    }else{
      edit->_if20->setProperty(WSNlabelString,(char*)tmp);
    }
  }

  edit->_vlist->delAll();

  if (num > 1){
    long i;
    for(i = 1; i< num; i++){
      WSCstring tmp;
      tmp = vsname.getWord(i,",");
      i++;
      WSCstring tmp2;
      tmp2 = vsname.getWord(i,",");
      tmp << "," << tmp2;
      edit->_vlist->addItem((char*)tmp);
    }
  }

  edit->_if21->setProperty(WSNlabelString,"Value0");
  edit->_if22->setProperty(WSNlabelString,"0");
  edit->_dialog2->setVisible(True);

}
void WSCclassPropEditor::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }
  if (_w > 2){
    _cmd_area1->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    _cmd_area1->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_w > 12){
    _list->setPropertyV(WSNwidth,(WSCushort)(_w -12));
  }else{
    _list->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (_h +diff > 45){
    _cmd_area1->setPropertyV(WSNheight,(WSCushort)(_h +diff -45));
  }else{
    _cmd_area1->setPropertyV(WSNheight,(WSCushort)(1));
  }

  if (_h +diff > 85){
    _list->setPropertyV(WSNheight,(WSCushort)(_h +diff -85));
  }else{
    _list->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
void WSCclassPropEditor::_dialog2_resize_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  WSCushort w,h;
  op_edit->_dialog2->getPropertyV(WSNwidth,&w);
  op_edit->_dialog2->getPropertyV(WSNheight,&h);
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (w > 2){
    op_edit->_darea2->setPropertyV(WSNwidth,(WSCushort)(w -2));
  }else{
    op_edit->_darea2->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (h+diff > 45){
    op_edit->_darea2->setPropertyV(WSNheight,(WSCushort)(h+diff -45));
  }else{
    op_edit->_darea2->setPropertyV(WSNheight,(WSCushort)(1));
  }

}
void WSCclassPropEditor::_dialog1_resize_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  WSCushort w,h;
  op_edit->_dialog1->getPropertyV(WSNwidth,&w);
  op_edit->_dialog1->getPropertyV(WSNheight,&h);
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (w > 2){
    op_edit->_darea1->setPropertyV(WSNwidth,(WSCushort)(w -2));
  }else{
    op_edit->_darea1->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (h+diff > 45){
    op_edit->_darea1->setPropertyV(WSNheight,(WSCushort)(h+diff -45));
  }else{
    op_edit->_darea1->setPropertyV(WSNheight,(WSCushort)(1));
  }

}

void WSCclassPropEditor::onGuiPolicyChange(long policy){
  if (_opt1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_GRADATION){
      _opt1->setProperty(WSNgradation,WS_GR_LT_RB);
      _opt2->setProperty(WSNgradation,WS_GR_LT_RB);
      _vsname_btn->setProperty(WSNgradation,WS_GR_LT_RB);
    }else{
      _opt1->setProperty(WSNgradation,WS_GR_NONE);
      _opt2->setProperty(WSNgradation,WS_GR_NONE);
      _vsname_btn->setProperty(WSNgradation,WS_GR_NONE);
    }
    if (policy & WS_POLICY_ORIGINAL){
      _cmd_area1->setProperty(WSNy,5);
      _cmd_area1->setProperty(WSNshadowThickness,1);
      _darea1->setProperty(WSNy,5);
      _darea1->setProperty(WSNshadowThickness,1);
      _darea2->setProperty(WSNy,5);
      _darea2->setProperty(WSNshadowThickness,1);
      _list->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else
    if (policy & WS_POLICY_WINDOWS){
      _cmd_area1->setProperty(WSNy,0);
      _cmd_area1->setProperty(WSNshadowThickness,0);
      _darea1->setProperty(WSNy,0);
      _darea1->setProperty(WSNshadowThickness,0);
      _darea2->setProperty(WSNy,0);
      _darea2->setProperty(WSNshadowThickness,0);
      _list->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
    
    _adjust();
  }
}

void WSCclassPropEditor::_addv_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  WSCstring tmp1 = op_edit->_if21->getProperty(WSNlabelString);
  if (!strcmp((char*)tmp1,"")){
    tmp1.setString("notitle");
  }
  WSCstring tmp2 = op_edit->_if22->getProperty(WSNlabelString);
  if (!strcmp((char*)tmp2,"")){
    tmp1.setString("0");
  }
  tmp1 << "," << tmp2;
  op_edit->_vlist->addItem(tmp1);
}
void WSCclassPropEditor::_delv_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");

  long pos = op_edit->_vlist->getSelectedPos();
  if (pos < 0){
    return;
  }
  op_edit->_vlist->delPos(pos);
  op_edit->_vlist->updateList();

}

void WSCclassPropEditor::_upv_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");

  long pos = op_edit->_vlist->getSelectedPos();
  if (pos < 1){
    return;
  }
  WSCstring tmp = op_edit->_vlist->getItem(pos);
  op_edit->_vlist->delPos(pos);
  op_edit->_vlist->addItem((char*)tmp,pos-1);
  op_edit->_vlist->setSelectPos(pos-1);

}
void WSCclassPropEditor::_downv_work(WSCbase* obj){
  WSCclassPropEditor* op_edit = (WSCclassPropEditor*)obj->getUserData("WIN EDIT");
  long pos = op_edit->_vlist->getSelectedPos();
  if (pos < 0){
    return;
  }
  long num = op_edit->_vlist->getNum();
  if (pos == num-1){
    return;
  }
  WSCstring tmp = op_edit->_vlist->getItem(pos);
  op_edit->_vlist->delPos(pos);
  op_edit->_vlist->addItem((char*)tmp,pos+1);
  op_edit->_vlist->setSelectPos(pos+1);
}




