#include <WScom.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>
#include <WSCblink.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSCindexForm.h>
#include <WSCmenuArea.h>
#include <WSCpulldownMenuPopup.h>
#include <WSCfontSet.h>
#include <WSDmouse.h>
#include <WSCvscrBar.h>
#include <WSCscrForm.h>
#include <WSCpulldownMenu.h>
#include <WSCguiPolicy.h>

extern void WSGFdrawModern1Shadow(WSDdev* dev,long shadow_type,WSCushort stick,
   short fg_no, short ts_no, short bs_no, short bg_no,short pno,
   short x, short y, WSCushort w,WSCushort h,WSCbool nodark);


void WSCindexForm_draw_mdr1(void* ptr){
  WSCindexForm_draw_struct* st = (WSCindexForm_draw_struct*)ptr;

  WSCbool absolute = st->_this->getAbsoluteDraw();
  WSDdev* dev = st->dev;

  long err = dev->beginDraw(0,0,st->width,st->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = st->width;
  WSCushort eh = st->height;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  st->_this->WSCbase::update();
  st->_this->setAbsoluteDraw(False);

  if (st->back_pixmap == -1){
    if (st->gradation == 0){
      if (st->bar_thickness != 0){
        WSDcolor* bg = WSGIappColorSet()->getColor(st->back_color);
        long r,g,b;
        bg->getRGB(&r,&g,&b);
        char buffer[64];
        long r1,g1,b1;
        r1 = r -16;
        g1 = g -16;
        b1 = b -16;
        if (r1 < 0){
          r1 = 0;
        }
        if (g1 < 0){
          g1 = 0;
        }
        if (b1 < 0){
          b1 = 0;
        }
        sprintf(buffer,"#%02x%02x%02x",r1,g1,b1);
        short bs1 = WSGIappColorSet()->getColorNo(buffer);
        st->_this->set_btn_background(bs1);
        WSCbase* target = st->_this->get_target_btn();
        target->setProperty(WSNbackColor,st->back_color);
      }
      dev->setForeColor(st->back_color);
      dev->drawFillRect(0,0,st->width,st->height);

    }else{
      dev->drawGradation(st->gradation,st->top_shadow_color,
                    st->back_color,st->bottom_shadow_color,0,0,
                    st->width,st->height,st->gradation_margin);
    }
  }
  if (st->_this->getDotMode() == True){
    dev->setForeColor(st->fore_color);
    long i,j;
    for(i=0; i<st->width; i+=10){
      for(j=0; j<st->height; j+=10){
        if (ex < i+1 && i < ex+ ew+1 &&
            ey < j+1 && j < ey+ eh+1 ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }

//  long stick = st->shadow_thickness;
//  if (stick > 1 && WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
//    stick -=1;
//  }
  long stick = 1;
  WSCstring tmp(st->menu_string);

  long num = tmp.getWords(",");
  if (num > 1 && st->bar_thickness != 0){
    if ( st->orientation == WS_HORIZONTAL){
      if (st->flipped == False){
//        dev->setForeColor(st->top_shadow_color);
        dev->setForeColor(st->bottom_shadow_color);
        if (st->value > 1){
          dev->drawFillRect(0,st->bar_thickness,
                            (st->width) * (st->value -1)/num+2,stick);
        }
        if (st->value < (unsigned)num){
          dev->drawFillRect(st->width * st->value/num-2,st->bar_thickness,
                            (st->width) * (num - st->value)/num+2,stick);
        }
      }else{
        dev->setForeColor(st->bottom_shadow_color);
        if (st->value > 1){
          dev->drawFillRect(0,st->height - st->bar_thickness - stick,
                            (st->width) * (st->value -1)/num+2,stick);
        }
        if (st->value < (unsigned)num){
          dev->drawFillRect(st->width * st->value/num-2,
                            st->height - st->bar_thickness-stick,
                            (st->width) * (num - st->value)/num+2,stick);
        }
      }
    }else{
        if (st->flipped == False){
//          dev->setForeColor(st->top_shadow_color);
          dev->setForeColor(st->bottom_shadow_color);
          if (st->value > 1){
            dev->drawFillRect(st->bar_thickness,0,stick,
                              st->height * (st->value -1)/num+2);
          }
          if (st->value < (unsigned)num){
            dev->drawFillRect(st->bar_thickness,st->height * st->value/num-2,
                              stick,
                              (st->height) * (num - st->value)/num+2);
          }
        }else{
          dev->setForeColor(st->bottom_shadow_color);
          if (st->value > 1){
            dev->drawFillRect(st->width - st->bar_thickness-stick,
                              0,stick,(st->height) * (st->value -1)/num+2);
          }
          if (st->value < (unsigned)num){
            dev->drawFillRect(st->width - st->bar_thickness - stick,
                              st->height * st->value/num-2,stick,
                              (st->height) * (num - st->value)/num+2);
          }
        }
      }
    }

//draw shadow
  if (st->shadow_thickness > 0){
#if 0
    dev->setLineWidth(1);
    dev->setLineDashType(0);
    dev->setForeColor(st->bottom_shadow_color);
    dev->drawRect(1,1,st->width-2,st->height-2);
#endif
    short tsno = st->top_shadow_color;
    short bsno = st->bottom_shadow_color;
    short bgc = st->back_color;
    WSCbase* parent = st->_this->getParent();
    WSCstring parent_bg("DEF1");
    if (parent != NULL){
      parent_bg = (char*)parent->getProperty(WSNbackColor);
    }
    short pbg = WSGIappColorSet()->getColorNo(parent_bg);
    WSGFdrawModern1Shadow(dev, st->shadow_type, st->shadow_thickness,
        tsno, tsno, bsno, bgc, pbg, 0, 0, st->width, st->height,False);
  }


  dev->endDraw();
  return;
}


void WSCmenuArea_draw_mdr1(void* ptr){
  WSCmenuArea_draw_struct* st = (WSCmenuArea_draw_struct*)ptr;

  WSCbool absolute = st->_this->getAbsoluteDraw();
  WSDdev* dev = st->dev;

  long err = dev->beginDraw(0,0,st->width,st->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = st->width;
  WSCushort eh = st->height;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  st->_this->WSCbase::update();
  st->_this->setAbsoluteDraw(False);

  if (st->back_pixmap == -1){
    if (st->gradation == 0){
      short bgc = st->back_color;
      if (bgc == WS_DF_MENUBACKCOLOR){
        bgc = WS_DF_BACKCOLOR;
      }
      dev->setForeColor(bgc);
      dev->drawFillRect(0,0,st->width,st->height);

    }else{
      dev->drawGradation(st->gradation,st->top_shadow_color,st->back_color,st->bottom_shadow_color,0,0,st->width,st->height,st->gradation_margin);
    }
  }
  if (st->_this->getDotMode() == True){
    dev->setForeColor(st->fore_color);
    long i,j;
    for(i=0; i<st->width; i+=10){
      for(j=0; j<st->height; j+=10){
        if (ex < i+1 && i < ex+ ew+1 &&
            ey < j+1 && j < ey+ eh+1 ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }

//draw shadow
  if (st->shadow_type != WS_SHADOW_NONE){

    short tsno = st->top_shadow_color;
    short bsno = st->bottom_shadow_color;
    short bgc = st->back_color;
    WSCbase* parent = st->_this->getParent();
    WSCstring parent_bg("DEF1");
    if (parent != NULL){
      parent_bg = (char*)parent->getProperty(WSNbackColor);
    }
    short pbg = WSGIappColorSet()->getColorNo(parent_bg);
    WSGFdrawModern1Shadow(dev, st->shadow_type, st->shadow_thickness,
        tsno, tsno, bsno, bgc, pbg, 0, 0, st->width, st->height,False);

  }else{
    dev->setLineWidth(0);
    dev->setForeColor(st->bottom_shadow_color);
    dev->drawLine(0,st->height-2,st->width,st->height-2);
    dev->setForeColor(st->top_shadow_color);
    dev->drawLine(0,st->height-1,st->width,st->height-1);
  }

  dev->endDraw();

  return;
}
void WSCpulldownMenuPopup_draw_mdr1(void* ptr){
  WSCpulldownMenuPopup_draw_struct* st = (WSCpulldownMenuPopup_draw_struct*)ptr;

  WSCbool absolute = st->_this->getAbsoluteDraw();
  WSDdev* dev = st->dev;

  long err = dev->beginDraw(0,0,st->width,st->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }

  st->_this->WSCbase::update();
  st->_this->setAbsoluteDraw(False);

  short x = st->x;
  short y = st->y;
  WSCushort w = st->width;
  WSCushort h = st->height;
  short px, py;
  WSGIappMouse()->getMousePosition(&px, &py);
 
  short _fg_no = st->fore_color;
  short _bg_no = st->back_color;
  short _ts_no = st->top_shadow_color;
  short _bs_no = st->bottom_shadow_color;
  long _shadow_type = st->shadow_type;
  long st1 = st->shadow_thickness;
  char* _menu_string = st->menu_string;
  long _font = st->font;
  WSCushort _item_height = st->item_height;


  dev->setForeColor(_bg_no);
  dev->drawFillRect(0, 0, w, h);
//  WSGFdrawShadow(dev,_shadow_type,st1,_fg_no, _ts_no, _bs_no,_bg_no,0,0,w,h);
  dev->setForeColor(_bs_no);
  dev->drawRect(0,0,w,h);

  WSCstring str(_menu_string);
  long num = str.getWords(",");
  long i;
  short posy = st1;
  long child_cnt = 0;

  WSCpulldownMenuPopup* target = st->_this;
  while(target->getParentMenu() != NULL){
    target = target->getParentMenu();
  }
  target->get_prc_name().setString("");
  target->set_selected(False);

    WSCpulldownData* own_pld = (WSCpulldownData*)st->_this->get_pld_data();
    WSCpulldownData* pld = (WSCpulldownData*)target->get_pld_data();

    if (pld == NULL || own_pld == NULL){
WSMFtrace("WSCpulldownMenuPopup::draw ERROR.target->_pld_data is NULL!    %s\n",getInstanceName());
    }
    st->_this->set_child_popup_waited(False);
    long cnt = 0;
    for(i=0; i < num; i++){
      WSCpulldownData* targetitem = own_pld->getItem(cnt);
      long itemid = -1;
      if (targetitem != NULL){
        itemid = targetitem->_id;
      }

      WSCstring item = str.getWord(i, ",");
      WSCstring item_str = item.getWord(0, ":");

      WSCstring space(" ");
      WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);

      if (!strcmp(item_str.getString(),"SP") ||
          !strcmp(item_str.getString(),"SEPARATOR")){

        posy += 2;
        dev->setForeColor(_bs_no);
        dev->setLineDashType(0);
        dev->setLineWidth(1);
        dev->setHatchPattern(0);

        dev->drawLine(st1+1,posy,w-st1-2,posy);
        dev->setForeColor(_ts_no);
        dev->drawLine(st1+1,posy+1,w-st1*2-2,posy+1);
        posy += st1*2;
        posy += 2;
      }else{
        if ( st->selected_item == -1){
          st->_this->set_selected_item(st->items -1);
        }else
        if ( st->selected_item > st->items -1){
          st->_this->set_selected_item(0);
        }
        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + st->item_height && st->mouse_no_check == 0) ||
             (st->mouse_no_check != 0 && cnt == st->selected_item) ){

          if (own_pld->getSensitive(cnt) != False){
            dev->setHatchPattern(0);
            dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTCOLOR));
            dev->drawFillRect( st1+1,posy+1,w-st1*2 -2, _item_height-2);
            dev->setForeColor(_fg_no);
          }
        }

        dev->setForeColor(_fg_no);
        if ( own_pld->getSensitive(cnt) == False) {
          if (st->_this->getEmboss() != False){
            dev->setForeColor(_ts_no);
            dev->drawString(st1*2 + smargin/2+1, posy +st1+1, w -st1*4 - smargin , _item_height -st1*2, &item_str, _font, WS_LEFT, -1, False);
          }else{
            dev->setHatchPattern(8);
          }
        } else {
          dev->setHatchPattern(0);
        }
        if (st->_this->getEmboss() != False && own_pld->getSensitive(cnt) == False){
          dev->setForeColor(_bs_no);
        }else{
          dev->setForeColor(_fg_no);
        }
        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && st->mouse_no_check == 0) ||
             (st->mouse_no_check != 0 && cnt == st->selected_item) ){

          if (own_pld->getSensitive(cnt) != False){
            dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTFORECOLOR));
          }
        }


        dev->drawString(st1*2 + smargin/2, posy +st1, w -st1*4 - smargin , _item_height -st1*2, &item_str, _font, WS_LEFT, -1, False);

        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && st->mouse_no_check == 0) ||
             (st->mouse_no_check != 0 && cnt == st->selected_item) ){

          if (own_pld->getSensitive(cnt) != False){
            st->_this->set_selected_item(cnt);
          }
          WSCstring item_prc_name = item.getWord(1, ":");
          if (!strncmp(item_prc_name.getString(),"{",1)){

            WSCpoint pt[3];
            pt[0].x = w - 10;
            pt[0].y = _item_height /2 +5 + posy;
            pt[1].x = w - 10;
            pt[1].y = _item_height /2 -5 + posy;
            pt[2].x = w - 10 +5;
            pt[2].y = _item_height /2 + posy;
            dev->setForeColor(_fg_no);
            dev->drawFillPoly(pt,3);

            long wpos = str.getWordCharPos(i, ",");
            WSCstring tmp(_menu_string);
            tmp.deleteChars(0,wpos);
            wpos = tmp.getWordCharPos(1,"{");
            tmp.deleteChars(0,wpos);
            char* tstr = tmp.getString(WS_EN_UTF8);
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;
            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                layers++;
              }
              if (tstr[j] == ','){
                num_of_conma++;
              }
            }

            i += num_of_conma;
            if (st->wait_child_popup == 0){
              if (own_pld->getSensitive(cnt) != False){
                WSCstring t(tstr,WS_EN_UTF8);
                st->_this->popupChildPld(child_cnt,t.getString(),x+w,y+posy);
              }
            }else{
              st->_this->set_child_popup_waited(True);
            }
            child_cnt++;

          }else{
            if ( st->_this->checkChildStatus() == False  && own_pld->getSensitive(cnt) != False) {
              target->get_prc_name().setString( item_prc_name.getString() );
              target->set_selected(True);
            }
          }

          WSCstring id_str = item.getWord(3, ":");
          target->set_id_value( atoi(id_str.getString()) );
        }else{
          WSCstring item_prc_name = item.getWord(1, ":");
          if (!strncmp(item_prc_name.getString(),"{",1)){

            WSCpoint pt[3];
            pt[0].x = w - 10;
            pt[0].y = _item_height /2 +5 + posy;
            pt[1].x = w - 10;
            pt[1].y = _item_height /2 -5 + posy;
            pt[2].x = w - 10 +5;
            pt[2].y = _item_height /2 + posy;
            dev->setForeColor(_fg_no);
            dev->drawFillPoly(pt,3);

            long wpos = str.getWordCharPos(i, ",");
            WSCstring tmp(_menu_string);
            tmp.deleteChars(0,wpos);
            wpos = tmp.getWordCharPos(1,"{");
            tmp.deleteChars(0,wpos);
            char* tstr = tmp.getString(WS_EN_UTF8);
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;
            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                 layers++;
              }
              if (tstr[j] == ','){
                num_of_conma++;
              }
            }

            i += num_of_conma; // { }  , Ф
            long num1 = st->_this->get_child_pld_list().getNum();
            WSCpulldownMenuPopup* child_popup = NULL;
            if (child_cnt < num1){
              child_popup = (WSCpulldownMenuPopup*)st->_this->get_child_pld_list()[child_cnt];
            }
            if ( x < px  && px < x+w  &&
                 y < py  && py < y+h &&
                 child_popup != NULL && child_popup->getVisible() != False){
              st->_this->popdownChildPld(child_cnt);
            }
            child_cnt++;
          }
        }
        posy += _item_height;
        cnt++;
      }
    }
    st->_this->set_items(cnt);


  dev->endDraw();

  return;
}
void WSCvscrBar_draw_mdr1(void* ptr){
  WSCvscrBar_draw_struct* dt = (WSCvscrBar_draw_struct*)ptr;

  WSCbool absolute = dt->_this->getAbsoluteDraw();
  WSDdev* dev = dt->dev;

  long err = dev->beginDraw(dt->x,dt->y,dt->width,dt->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }
  dt->_this->WSCbase::update();
  dt->_this->setAbsoluteDraw(False);

  WSCushort st = dt->shadow_thickness;
  WSCushort st2 = dt->shadow_thickness;
  short x = dt->x;
  short y = dt->y;
  WSCushort w = dt->width;
  WSCushort h = dt->height;
  short _fore_color = dt->fore_color;
  short _bg_no = dt->back_color;
  short _ts_no = dt->top_shadow_color;
  short _bs_no = dt->bottom_shadow_color;
  short _bg2_no = dt->back_color2;
  short _shadow_thick = dt->shadow_thickness;
  short _bp_no = dt->back_pixmap;
  short _grad_on = dt->gradation;
  short _slider_size = dt->slider_size;
  short _maximum = dt->maximum;
  short _value = dt->value;
  short _bar_status = dt->bar_status;
  short _orientation = dt->orientation;

  x =0;
  y =0;
  st = 0;

  double bar_area_width  = w - h*3 + st*6;
  double bar_area_height = h - w*3 + st*6;

  dev->setForeColor( _bg2_no );
  if (_grad_on == False){
    dev->drawFillRect( 0,0,w,h);
  }else{
    dev->drawGradation( WS_GR_LT_RB,_ts_no,_bg_no,_bs_no,0-w/2,0-h/2,w*2,h*2,0);
  }

  if (_bp_no != -1){
    WSDimage* image = WSGIappImageSet()->getImage(_bp_no);
    dev->drawImage(0,0,0,0,w,h,image);
  }
//  long policy = WSGIappDev()->getGuiPolicy();

  WSDcolor* bg = WSGIappColorSet()->getColor(_bg_no);
  long r,g,b;
  bg->getRGB(&r,&g,&b);
  char buffer[64];
  long r1,g1,b1;
  r1 = r +32;
  g1 = g +32;
  b1 = b +32;
  if (r1 > 255){
    r1 = 255;
  }
  if (g1 > 255){
    g1 = 255;
  }
  if (b1 > 255){
    b1 = 255;
  }
  sprintf(buffer,"#%02x%02x%02x",r1,g1,b1);
  short ts1 = WSGIappColorSet()->getColorNo(buffer);

  long r2,g2,b2;
  r2 = r -32;
  g2 = g -32;
  b2 = b -32;
  if (r2 < 0){
    r2 = 0;
  }
  if (g2 < 0){
    g2 = 0;
  }
  if (b2 < 0){
    b2 = 0;
  }
  sprintf(buffer,"#%02x%02x%02x",r2,g2,b2);
  short bs1 = WSGIappColorSet()->getColorNo(buffer);

  if (_orientation == WS_HORIZONTAL){
    long ah = h/2;
    if (w > 2){
      if (w > 2  + st*2){
        WSCulong _slider_size_alt = _slider_size;
        long _value_alt = _value;
        if ((WSCulong)((double)bar_area_width * _slider_size /_maximum) < WS_MINIMUM_WIDTH ){
          if ( w-h*3 + st*6 != 0){
            _slider_size_alt  = (WSCulong)(WS_MINIMUM_WIDTH * _maximum / bar_area_width);
            if ( x +w +st*3 -h*3/2 <
               x -st*3 +h*3/2 +(long)((double)bar_area_width * (_value+_slider_size_alt)/_maximum)){
              _value_alt = _maximum -_slider_size_alt;
            }
            if (_value_alt < 0){
              _value_alt = 0;
            }
          }
        }

        long   smallbtn_w  = h/2 -st*4;
        long   smallbtn_h  = h   -st*4;
        if (smallbtn_w < 1){
          smallbtn_w = 1;
        }
        if (smallbtn_h < 1){
          smallbtn_h = 1;
        }
        //btn left left
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_T_B,ts1,
                         _bg_no,bs1,
                         x + st*2 , y+st*2, smallbtn_w, smallbtn_h ,smallbtn_h/3);
//        dev->drawFillRect( x + st*2 , y+st*2, smallbtn_w, smallbtn_h );
        WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN1 ?
                                         WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +st , y +st,
                   h/2 -st*2,
                   h -st*2,False );

        //btn left
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_T_B,ts1,
                         _bg_no,bs1,
                         x +h/2, y+st*2, smallbtn_h, smallbtn_h,smallbtn_h/3 );
//          dev->drawFillRect( x +h/2, y+st*2, smallbtn_h, smallbtn_h );
          WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN2 ?
                                           WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +h/2 -st,
                   y +st,
                   h -st*2,
                   h -st*2,False );
          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_LEFT,
                      x + h/2   + h/4 -st*2,
                      y + h/4,
                      ah,ah);
        //bar
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_T_B,ts1,_bg_no,bs1,
                         (short)(x +(double)h*3/2 -st*2 + (bar_area_width * _value_alt / _maximum )),
                   y +st*2 ,

                   (WSCushort)(x +w + st*3 -st -(double)h*3/2 - ((double)bar_area_width * (_maximum -_value_alt -_slider_size_alt) / _maximum )
                   - (short)(x +(double)h*3/2 -st*2 + ((double)bar_area_width * _value_alt / _maximum ))),
                   h -st*4,smallbtn_h/3 );


//          dev->drawFillRect( (short)(x +(double)h*3/2 -st*2 + (bar_area_width * _value_alt / _maximum )),
//                   y +st*2 ,
//                   (WSCushort)(x +w + st*3 -st -(double)h*3/2 - ((double)bar_area_width * (_maximum -_value_alt -_slider_size_alt) / _maximum )
 //                   - (short)(x +(double)h*3/2 -st*2 + ((double)bar_area_width * _value_alt / _maximum ))),
//                   h -st*4 );

          long bwidth = (long)(x +w + st*3 -((double)h)*3/2 - (((double)bar_area_width) * (_maximum -_value_alt -_slider_size_alt) / _maximum )
            -(x +((double)h)*3/2 -st*3 + (((double)bar_area_width) * _value_alt / _maximum )));

          if (bwidth < 2){
            bwidth = 2;
          }
          WSGFdrawModern1Shadow(dev, WS_SHADOW_OUT,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   (WSCushort)(x +(double)h*3/2 -st*3 + (bar_area_width * _value_alt / _maximum )),
                   y +st , bwidth, h -st*2 ,False);
        //btn right
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_T_B,ts1,_bg_no,bs1,
                          x +w + st*4 -h*3/2, y+st*2, smallbtn_h, smallbtn_h,smallbtn_h/3 );
//          dev->drawFillRect( x +w + st*4 -h*3/2, y+st*2, smallbtn_h, smallbtn_h );
          WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN3 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +w +st*3 -h*3/2 ,
                   y +st,
                   h -st*2,
                   h -st*2,False );
          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_RIGHT,
                      x +w +st*2 -h*3/2 +h/4,
                      y +h/4,
                      ah,ah);

        //btn right right
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_T_B,ts1,_bg_no,bs1,
                           x +w + st*2 -h/2, y+st*2, smallbtn_w, smallbtn_h,smallbtn_h/3 );
//        dev->drawFillRect( x +w + st*2 -h/2, y+st*2, smallbtn_w, smallbtn_h );
        WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN4 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +w +st -h/2 ,
                   y +st,
                   h/2 -st*2,
                   h -st*2,False );
      }
    }
  }else{
    if (h > 2){
      long ah = w/2;
      if (h > 2  + st*2){
        WSCulong _slider_size_alt = _slider_size;
        long           _value_alt = _value;
        if ((WSCulong)(bar_area_height * _slider_size /_maximum) < WS_MINIMUM_WIDTH ){
          if ( h-w*3 + st*6 != 0){
            _slider_size_alt  = (WSCulong)(WS_MINIMUM_WIDTH * _maximum / bar_area_height);

            if ( y +h +st*3 -w*3/2 <
                 y -st*3 +w*3/2 +(long)(bar_area_height * (_value+_slider_size_alt)/_maximum)){
               _value_alt = _maximum -_slider_size_alt;
            }
            if (_value_alt < 0){
              _value_alt = 0;
            }
          }
        }

        long   smallbtn_w  = w   -st*4;
        long   smallbtn_h  = w/2 -st*4;
        if (smallbtn_w < 1){
          smallbtn_w = 1;
        }
        if (smallbtn_h < 1){
          smallbtn_h = 1;
        }
         //btn up up
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_L_R,ts1,_bg_no,bs1,
                           x + st*2 , y+st*2, smallbtn_w, smallbtn_h,smallbtn_w/3 );
//        dev->drawFillRect( x + st*2 , y+st*2, smallbtn_w, smallbtn_h );
        WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN1 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +st , y +st,
                   w -st*2,
                   w/2 -st*2,False );

        //btn up
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_L_R,ts1,_bg_no,bs1,
                           x + st*2 , y+w/2, smallbtn_w, smallbtn_w,smallbtn_w/3 );
//          dev->drawFillRect( x + st*2 , y+w/2, smallbtn_w, smallbtn_w );
        WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN2 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +st ,
                   y -st + w/2,
                   w -st*2,
                   w -st*2,False );

        WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_UP,
                      x + w/4,
                      y + w/2 +w/4 -st*2,
                      ah,ah);
        //bar

        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_L_R,ts1,_bg_no,bs1,
//          dev->drawFillRect(
                   x +st*2 ,
                   (short)(y -st*2 + (double)w*3/2 + (bar_area_height * _value_alt / _maximum )),
                   w -st*4,
                   (WSCushort)((y +h +st*3 -st - (double)w*3/2 - ((double)bar_area_height * (_maximum -_value_alt - _slider_size_alt) / _maximum ))
                      - (short)(y -st*2 + (double)w*3/2 + ((double)bar_area_height * _value_alt / _maximum ))),smallbtn_w/3 );
//printf("WSCvscrBar::draw val=%d max=%d\n",_value_alt,_maximum);

          long bheight = (long)((y +h +st*3 - ((double)w)*3/2 - (((double)bar_area_height) * (_maximum -_value_alt - _slider_size_alt) / _maximum ))
                    -(y -st*3 + ((double)w)*3/2 + (((double)bar_area_height) * _value_alt / _maximum )));

          if (bheight < 2){
            bheight = 2;
          }
          WSGFdrawModern1Shadow(dev, WS_SHADOW_OUT,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +st ,
                   (short)(y -st*3 + (double)w*3/2 + ((double)bar_area_height * _value_alt / _maximum )),
                   w -st*2, bheight,False);

        //ܥ
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_L_R,ts1,_bg_no,bs1,
                        x + st*2 , y+h +st*4 -w*3/2, smallbtn_w, smallbtn_w,smallbtn_w/3 );
//          dev->drawFillRect( x + st*2 , y+h +st*4 -w*3/2, smallbtn_w, smallbtn_w );
          WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN3 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +st,
                   y +h +st*3 -w*3/2 ,
                   w -st*2,
                   w -st*2,False );
          WSGFdrawArrow(dev, True,_shadow_thick*2,
                      _fore_color,_bs_no, _ts_no, WS_DOWN,
                      x+w/4,
                      y+h +st*2 -w*3/2 + w/4,
                      ah,ah);
        //ܥ󲼲
        dev->setForeColor( _bg_no );
        dev->drawGradation(WS_GR_L_R,ts1,_bg_no,bs1,
                           x + st*2 , y+h +st*2 -w/2, smallbtn_w, smallbtn_h,smallbtn_w/3 );
//        dev->drawFillRect( x + st*2 , y+h +st*2 -w/2, smallbtn_w, smallbtn_h );
        WSGFdrawModern1Shadow(dev,_bar_status != WS_BBTN4 ? WS_SHADOW_OUT : WS_SHADOW_IN,st2,
                   _fore_color, _ts_no,_bs_no,_bg_no,_bg_no,
                   x +st,
                   y +h +st -w/2 ,
                   w -st*2,
                   w/2 -st*2,False );

      }
    }
  }

  dev->endDraw();

}

void WSCscrForm_draw_mdr1(void* ptr){
  WSCscrForm_draw_struct* dt = (WSCscrForm_draw_struct*)ptr;

  WSCscrForm* _this = dt->_this;
  WSDdev* dev = dt->dev;
  WSCbool absolute = _this->getAbsoluteDraw();

  long err = dev->beginDraw(0,0,dt->width,dt->height,absolute);
  if (err != WS_NO_ERR){
    return;
  }
  short _x          = dt->x;
  short _y          = dt->y;
  WSCushort _w      = dt->width;
  WSCushort _h      = dt->height;
  WSCushort _shadow_thick = dt->shadow_thickness;
  WSCuchar _shadow_type   = dt->shadow_type;
  short _fore_color = dt->fore_color;
  short _back_color = dt->back_color;
  short _work_back_color = dt->work_back_color;
  short _ts_color   = dt->top_shadow_color;
  short _bs_color   = dt->bottom_shadow_color;
  short _bp_color   = dt->back_pixmap;
  long  _grad_no    = dt->gradation;
  long  _grad_margin = dt->gradation_margin;
  long  _bar_thick  = dt->bar_thickness;
  long  _marginw    = dt->margin_width;
  long  _padding    = dt->padding;
  WSCbool  _frame   = dt->frame;
  unsigned v_bar_thick = _bar_thick + _marginw;
  unsigned h_bar_thick = _bar_thick + _marginw;
  if (dt->vbar_visible == False){
    v_bar_thick = 0;
  }
  if (dt->hbar_visible == False){
    h_bar_thick = 0;
  }

  if ( _shadow_thick > 0){
    WSGFdrawModern1Shadow(dev,_shadow_type, _shadow_thick, _fore_color,
                   _ts_color,_bs_color,_back_color,_back_color,
                   0,0,dt->width,dt->height,False);
  }
  dev->endDraw();

  long err2 = dev->beginDraw(0,0,dt->width,dt->height,absolute);
  if (err2 != WS_NO_ERR){
    return;
  }

  _this->WSCbase::update();
  _this->setAbsoluteDraw(False);
  if (_bp_color == -1){
    dev->setForeColor(_back_color);
    dev->drawFillRect(_w - _shadow_thick - v_bar_thick,
                        _h - _shadow_thick - h_bar_thick,
                        v_bar_thick,
                        h_bar_thick);
  }

  dev->setForeColor(_work_back_color);
  dev->drawFillRect(_shadow_thick,_shadow_thick,
         dt->width - v_bar_thick - _shadow_thick*2,
         dt->height - h_bar_thick - _shadow_thick*2);
  dev->endDraw();
  return;
}

void WSCpulldownMenu_draw_mdr1(void* ptr){
  WSCpulldownMenu_draw_struct* dt = (WSCpulldownMenu_draw_struct*)ptr;

  WSCpulldownMenu* _this = dt->_this;
  WSDdev* dev = dt->dev;
  WSCbool absolute = _this->getAbsoluteDraw();
  short x = dt->x;
  short y = dt->y;
  WSCushort w = dt->width;
  WSCushort h = dt->height;

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return;
  }

  WSCushort _shadow_thick = dt->shadow_thickness;
  WSCbool _bl_fl        = dt->blinking;
  WSCbool blinkfore     = dt->blink_fore;
  long    _shadow_type  = dt->shadow_type;
  long    _bl_type      = dt->blink_type;
  WSCbool _tw_fl        = dt->twin_blink;
  short   _fore_color   = dt->fore_color;
  short   _back_color   = dt->back_color;
  short   _blink_color  = dt->blink_color;
  short   _bg_blink_color = dt->back_blink_color;
  short   _ts_color     = dt->top_shadow_color;
  short   _bs_color     = dt->bottom_shadow_color;
  char*   _label_string = dt->label_string;
  short   _label_pixmap = dt->label_pixmap;
  short   _blink_pixmap = dt->blink_pixmap;
  WSCbool _press_state  = dt->press_state;
  WSCuchar _orientation = dt->orientation;
  long    _grad_no      = dt->gradation;
  WSCushort _grad_margin = dt->gradation_margin;
  WSCushort _margin_left = dt->margin_left;
  WSCushort _margin_right = dt->margin_right;
  WSCushort _margin_top = dt->margin_top;
  WSCushort _margin_bottom =  dt->margin_bottom;
  WSCbool _emboss       = dt->emboss;
  long _font            = dt->font;
  WSCbool _rv_fl        = dt->reverse_flag;

  if (_back_color == WS_DF_MENUBACKCOLOR){
    _back_color = WS_DF_BACKCOLOR;
  }

  _this->WSCbase::update();
  _this->setAbsoluteDraw(False);

  WSCstring  str(_label_string);
  str.replaceString("\\n", "\n", 0);

  if (0 < w && 0 < h){
    if (_rv_fl != False) {
      if (_bl_type != WS_FORE &&
          _bl_fl != False &&
          blinkfore != False &&
          _tw_fl != False) {
        dev->setForeColor(_blink_color);
      } else {
        dev->setForeColor(_fore_color);
      }
    } else {
      if (_bl_type != WS_FORE &&
          _bl_fl != False &&
          blinkfore != False &&
          _tw_fl != False) {
        dev->setForeColor(_bg_blink_color);
      } else {
        dev->setForeColor(_back_color);
      }
    }
    dev->drawFillRect(0, 0, w, h);

    if (_press_state != False) {
      dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTCOLOR));
      dev->drawFillRect(0, 0, w, h);
    }
  }

  WSCushort margin_left   = _margin_left;
  WSCushort margin_right  = _margin_right;
  WSCushort margin_top    = _margin_top;
  WSCushort margin_bottom = _margin_bottom;
  short sx = margin_left;
  short sy = margin_top;
  short sw = 0;
  short sh = 0;
  if ( w > margin_left + margin_right){
    sw = w - margin_left - margin_right;
  }

  if ( h > margin_top + margin_bottom){
    sh = h - margin_top - margin_bottom;
  }

  if( _this->getSensitive() == False ||
     (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0)){
    if (_emboss != False){
      if (_bl_fl != False &&
        blinkfore != False &&
        _bl_type != WS_BACK &&
        _tw_fl != False) {
        dev->setForeColor(_blink_color);
      } else {
        dev->setForeColor(_ts_color);
      }
      dev->setBackColor(_back_color);

      if (_bl_fl != False &&
        blinkfore == False &&
        _bl_type != WS_BACK &&
        _tw_fl == False){
        // 褷ʤ
      }else{
        // ɽʸ
        if (_tw_fl == False || _bl_fl == False){
          dev->drawString(sx+1, sy+1, sw, sh, &str, _font, _this->getAlignment(), -1, False);
        }
      }
    }else{
      dev->setHatchPattern(8); //
    }
  }else{
    dev->setHatchPattern(0); //٥
  }

  if (_rv_fl != False) {
    if (_bl_fl != False &&
        blinkfore != False &&
        _bl_type != WS_BACK &&
        _tw_fl != False) {
      dev->setForeColor(_bg_blink_color);
    } else {
      if ( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
        dev->setForeColor(_bs_color);
      } else {
        dev->setForeColor(_back_color);
      }
    }
    dev->setBackColor(_fore_color);
  } else {
    if (_bl_fl != False &&
        blinkfore != False &&
        _bl_type != WS_BACK &&
        _tw_fl != False) {
      dev->setForeColor(_blink_color);
    } else {
      if ( _emboss != False && (_this->getSensitive() == False ||
          (_this->getPropertyEditMode() != False && (long)_this->getUserData(WS_DET) == 0))){
         dev->setForeColor(_bs_color);
      }else{
         dev->setForeColor(_fore_color);
      }
    }
    dev->setBackColor(_back_color);
  }

  if (_press_state != False) {
    dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTFORECOLOR));
  }
  if (_bl_fl != False &&
      blinkfore == False &&
      _bl_type != WS_BACK &&
      _tw_fl == False){
     // 褷ʤ
  }else{
    // ɽʸ
    dev->drawString(sx, sy, sw, sh, &str, _font, _this->getAlignment(), -1, False);
  }

  dev->endDraw();

  return;
}

class _gui_policy_register_{
  public: _gui_policy_register_(){
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCindexForm::draw",WSCindexForm_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCmenuArea::draw",WSCmenuArea_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCpulldownMenuPopup::draw",WSCpulldownMenuPopup_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCvscrBar::draw",WSCvscrBar_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCscrForm::draw",WSCscrForm_draw_mdr1);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCpulldownMenu::draw",WSCpulldownMenu_draw_mdr1);
  }
};

static _gui_policy_register_ _run_register;

