//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCfform.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDtimer.h>
#include <WSDmouse.h>
#include <WSDwindowDev.h>
#include <WSCfontSet.h>

WSMFguiClassInitialize(WSCfform,WSCbase);
WSMFversion(WSCfform,WSCbase);
WSMFdefineUseDevice(WSCfform,formDev);

WSCfform::WSCfform(WSCbase* base,char* objname):WSCbase(base,objname){
  _user_string = NULL;
  _user_value  = 0;
  _x   = 100;
  _y   = 100;
  _w   = 100;
  _h   = 30;
  _shadow_thick = 2;
//  _fore_color = WSGFcolor("black");
//  _back_color = WSGFcolor("gray85");
//  _ts_color = WSGFcolor("gray95");
//  _bs_color = WSGFcolor("gray95");
  _fore_color = WS_DF_FORECOLOR;
  _back_color = WS_DF_BACKCOLOR;
  _ts_color = WS_DF_TOPSHADOWCOLOR;
  _bs_color = WS_DF_BOTTOMSHADOWCOLOR;
  _bp_no = -1;
  _shadow_type = WS_SHADOW_OUT;
  _sensitive = True;
  _pixmap_style = WS_DIRECT_WINDOW;
  _no_refresh = False;
  _mouse_no     = 0;
  _grad_no     = 0;
  _grad_margin   = 0;
  _update_resize   = 0;
  _anchor_top = 0;
  _anchor_bottom= 0;
  _anchor_left = 0;
  _anchor_right = 0;
  _anchor_top_use = False;
  _anchor_bottom_use = False;
  _anchor_left_use = False;
  _anchor_right_use = False;
  _mouse_x = 0;
  _mouse_y = 0;
  _mouse_pressed = False;
  _mouse_pressed_resize = False;
  _floated = False;
  _indicator = True;
//  _dev_form = NULL;
//  _dev_win = NULL;
  _title_string = WSGFstrdup("");
  _change_sequence = False;
  _orientation = WS_VERTICAL;
  _bar_thick = 8;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _margin = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCfform);
    WSMFpropertyCreate(WSNname,  char*, _instance_name,WSSname );
    WSMFpropertyCreate(WSNuserString,  char*, _user_string,WSSuserString );
    WSMFpropertyCreate(WSNtitleString, char*, _title_string,WSStitleString );
    WSMFpropertyCreate(WSNuserValue,   long,  _user_value,WSSuserValue  );
    WSMFpropertyCreate(WSNx,           short,   _x ,WSSx );
    WSMFpropertyCreate(WSNy,           short,   _y ,WSSy );
    WSMFpropertyCreate(WSNwidth,        WSCushort, _w ,WSSwidth );
    WSMFpropertyCreate(WSNheight,       WSCushort, _h ,WSSheight );
    WSMFpropertyCreate(WSNshadowThickness,  WSCuchar, _shadow_thick,WSSshadowThickness);
    WSMFpropertyCreate(WSNforeColor,    short,   _fore_color,WSSforeColor);
    WSMFpropertyCreate(WSNbackColor,     short,  _back_color,WSSbackColor);
    WSMFpropertyCreate(WSNtopShadowColor,short,  _ts_color,WSStopShadowColor);
    WSMFpropertyCreate(WSNbottomShadowColor,short, _bs_color,WSSbottomShadowColor );
    WSMFpropertyCreate(WSNbackPixmap, short,  _bp_no,WSSbackPixmap );
    WSMFpropertyCreate(WSNshadowType,  char,  _shadow_type,WSSshadowType );
      WSMFpropertySetSelection(WSRshadowType,WSRshadowTypeD);
    WSMFpropertyCreate(WSNvis,       WSCbool,      _vis,WSSvis );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNdet,              WSCbool,  _sensitive,WSSdet);
      WSMFpropertySetSelection(WSRbool1,WSRbool1D);
    WSMFpropertyCreate(WSNpixmapStyle,      WSCuchar,  _pixmap_style,WSSpixmapStyle);
    WSMFpropertySetSelection(WSRpixmapStyle,WSRpixmapStyleD);
    WSMFpropertyCreate( WSNmouse, WSCushort,   _mouse_no,WSSmouse  );

    WSMFpropertyCreate(WSNgradation,  WSCuchar,  _grad_no,WSSgradation);
      WSMFpropertySetSelection(WSRgradation,WSRgradationD);
    WSMFpropertyCreate(WSNgradationMargin,WSCuchar,_grad_margin,WSSgradationMargin);

    WSMFpropertyCreate(WSNanchorTop, WSCushort, _anchor_top,WSSanchorTop);
    WSMFpropertyCreate(WSNanchorBottom,WSCushort,_anchor_bottom,WSSanchorBottom);
    WSMFpropertyCreate(WSNanchorLeft,WSCushort,_anchor_left,WSSanchorLeft);
    WSMFpropertyCreate(WSNanchorRight,WSCushort,_anchor_right,WSSanchorRight);

    WSMFpropertyCreate(WSNanchorTopFlag, WSCbool, _anchor_top_use,WSSanchorTopFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNanchorBottomFlag,WSCbool,_anchor_bottom_use,WSSanchorBottomFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNanchorLeftFlag,WSCbool,_anchor_left_use,WSSanchorLeftFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNanchorRightFlag,WSCbool,_anchor_right_use,WSSanchorRightFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNorientation,WSCuchar,_orientation,WSSorientation);
    WSMFpropertySetSelection(WSRorientation, WSRorientationD);

    WSMFpropertyCreate(WSNexport,WSCbool,_export_,WSSexport);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate( WSNindicatorOn,  WSCbool, _indicator,WSSindicatorOn);
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate( WSNbarThickness,  WSCuchar, _bar_thick,WSSbarThickness); 
    WSMFpropertyCreate(WSNfont,         WSCuchar,   _font,WSSfont  );
    WSMFpropertyCreate(WSNmargin,WSCuchar,_margin,WSSmargin);

    WSMFaddTrigger(WSEV_INITIALIZE  );
    WSMFaddTrigger(WSEV_MOUSE_MOVE  );
    WSMFaddTrigger(WSEV_MOUSE_IN    );
    WSMFaddTrigger(WSEV_MOUSE_OUT   );
    WSMFaddTrigger(WSEV_MOUSE_PRESS   );
    WSMFaddTrigger(WSEV_MOUSE_RELEASE );
    WSMFaddTrigger(WSEV_PARENT_VISIBLE_CH  );
    WSMFaddTrigger(WSEV_VISIBLE_CH  );
    WSMFaddTrigger(WSEV_EXPOSE      );
    WSMFaddTrigger(WSEV_RESIZE      );
    WSMFaddExtTrigger(WSEV_STATUS_CH,"STATUS-CH" );
  WSMFpropertyCreateEnd
}
WSMFproperty(WSCfform,WSNname, char*, _instance_name ,WSGFstrdup("")); 
WSMFproperty(WSCfform,WSNuserString, char*, _user_string ,WSGFstrdup("")); 
WSMFproperty(WSCfform,WSNtitleString, char*, _title_string ,WSGFstrdup("")); 
WSMFproperty(WSCfform,WSNuserValue, long,  _user_value, 0); 
WSMFproperty(WSCfform,WSNx,   short, _x, 100 );
WSMFproperty(WSCfform,WSNy,   short, _y, 100 );
WSMFproperty(WSCfform,WSNwidth, WSCushort, _w, 100  );
WSMFproperty(WSCfform,WSNheight, WSCushort, _h, 30  );
WSMFproperty(WSCfform,WSNshadowThickness, WSCuchar, _shadow_thick, 2);
//WSMFproperty(WSCfform,WSNforeColor, short, _fore_color, WSGFcolor("black") );
//WSMFproperty(WSCfform,WSNbackColor, short, _back_color, WSGFcolor("gray85") );
//WSMFproperty(WSCfform,WSNtopShadowColor, short, _ts_color, WSGFcolor("gray95") );
//WSMFproperty(WSCfform,WSNbottomShadowColor,short, _bs_color, WSGFcolor("gray55") );
WSMFproperty(WSCfform,WSNforeColor, short, _fore_color, WS_DF_FORECOLOR);
WSMFproperty(WSCfform,WSNbackColor, short, _back_color, WS_DF_BACKCOLOR);
WSMFproperty(WSCfform,WSNtopShadowColor, short, _ts_color, WS_DF_TOPSHADOWCOLOR);
WSMFproperty(WSCfform,WSNbottomShadowColor,short, _bs_color, WS_DF_BOTTOMSHADOWCOLOR);
WSMFproperty(WSCfform,WSNbackPixmap, short, _bp_no, -1);
WSMFproperty(WSCfform,WSNshadowType, char,    _shadow_type ,WS_SHADOW_OUT );
WSMFproperty(WSCfform,WSNvis,WSCbool, _vis ,False  );
WSMFproperty(WSCfform,WSNdet,WSCbool, _sensitive, True );
WSMFproperty(WSCfform,WSNpixmapStyle, WSCuchar, _pixmap_style ,WS_DIRECT_WINDOW);
WSMFproperty(WSCfform, WSNmouse,   WSCushort,     _mouse_no     ,0);
WSMFproperty(WSCfform, WSNgradation, WSCuchar, _grad_no   ,0);
WSMFproperty(WSCfform, WSNgradationMargin, WSCuchar, _grad_margin ,0);
WSMFproperty(WSCfform, WSNanchorTop,WSCushort,_anchor_top,0 );
WSMFproperty(WSCfform, WSNanchorBottom,WSCushort,_anchor_bottom,0 );
WSMFproperty(WSCfform, WSNanchorLeft,WSCushort,_anchor_left,0 );
WSMFproperty(WSCfform, WSNanchorRight,WSCushort,_anchor_right,0 );
WSMFproperty(WSCfform, WSNanchorTopFlag,WSCbool,_anchor_top_use,False );
WSMFproperty(WSCfform, WSNanchorBottomFlag,WSCbool,_anchor_bottom_use,False );
WSMFproperty(WSCfform, WSNanchorLeftFlag,WSCbool,_anchor_left_use,False );
WSMFproperty(WSCfform, WSNanchorRightFlag,WSCbool,_anchor_right_use,False );
WSMFproperty(WSCfform, WSNorientation,WSCuchar,_orientation,WS_VERTICAL );
WSMFproperty(WSCfform, WSNexport,WSCbool,_export_,False );
WSMFproperty(WSCfform, WSNindicatorOn,  WSCbool,  _indicator   ,True);
WSMFproperty(WSCfform, WSNbarThickness,  WSCuchar,  _bar_thick   ,8);
WSMFproperty(WSCfform, WSNfont, WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());
WSMFproperty(WSCfform, WSNmargin, WSCuchar, _margin ,0);
void WSCfform::setWorkWSNfont(WSCuchar){}
void WSCfform::getWorkWSNfont(WSCuchar*){}
void WSCfform::setWorkWSNorientation(WSCuchar ){}
void WSCfform::getWorkWSNorientation(WSCuchar* ){}
void WSCfform::setWorkWSNname(char* ){}
void WSCfform::getWorkWSNname(char** ){}
void WSCfform::setWorkWSNuserString(char* ){}
void WSCfform::getWorkWSNuserString(char** ){}
void WSCfform::setWorkWSNtitleString(char* ){}
void WSCfform::getWorkWSNtitleString(char** ){}
void WSCfform::setWorkWSNuserValue(long ){}
void WSCfform::getWorkWSNuserValue(long* ){}
void WSCfform::setWorkWSNx(short data){
  if (_floated == False){
    if (_anchor_left_use != False){
      data = _anchor_left;
      _x = _anchor_left;
    }else if (_anchor_right_use != False){
      if (getParent() != NULL){
        getParent()->setGeometryChanged(True);
        getParent()->needUpdate();
      }
      return;
    }
  }
  if (_initialized != False && _dev != NULL){
    if (getXOffsetPtr() != 0){
      data += *getXOffsetPtr();
    }
    _dev->setValue(WSDEV_X,(void*)&data);
    _geometry_changed = True;
  }
  if (_floated == False){
    _x_original = _x;
  }
}
void WSCfform::getWorkWSNx(short* ){}
void WSCfform::setWorkWSNy(short data){
  if (_floated == False){
    if (_anchor_top_use != False){
      data = _anchor_top;
      _x = _anchor_top;
    }else if (_anchor_bottom_use != False){
      if (getParent() != NULL){
        getParent()->setGeometryChanged(True);
        getParent()->needUpdate();
      }
      return;
    }
  }
  if (_initialized != False && _dev != NULL){
    if (getXOffsetPtr() != 0){
      data += *getYOffsetPtr();
    }
    _dev->setValue(WSDEV_Y,(void*)&data);
    _geometry_changed = True;
  }
  if (_floated == False){
    _y_original = _y;
  }
}
void WSCfform::getWorkWSNy(short* ){}
void WSCfform::setWorkWSNwidth(WSCushort data){
  if (_initialized != False && _dev != NULL){
    if (_floated == False){
      if (_anchor_left_use != False && _anchor_right_use != False){
        if (getParent() != NULL){
          getParent()->setGeometryChanged(True);
          getParent()->needUpdate();
        }
        return;
      }
    }
    _dev->setValue(WSDEV_WIDTH,(void*)&data);
    _geometry_changed = True;
//printf("WSCfform::setWorkWSNwidth %s ->%d\n",getInstanceName(),_w);
    _update_resize = True;
    if (_grad_no != 0){
      setAbsoluteDraw(True);
      needUpdate();
    }
  }else{
    _geometry_changed = True;
    _update_resize = True;
  }
}
void WSCfform::getWorkWSNwidth(WSCushort* ){}
void WSCfform::setWorkWSNheight(WSCushort data){
  if (_initialized != False && _dev != NULL){
    if (_floated == False){
      if (_anchor_top_use != False && _anchor_bottom_use != False){
        if (getParent() != NULL){
          getParent()->setGeometryChanged(True);
          getParent()->needUpdate();
        }
        return;
      }
    }

//printf("WSCfform::setWorkWSNheight %s %d\n",getInstanceName(),data);
    _dev->setValue(WSDEV_HEIGHT,(void*)&data);
    _geometry_changed = True;
    _update_resize = True;
    if (_grad_no != 0){
      setAbsoluteDraw(True);
      needUpdate();
    }
  }else{
    _geometry_changed = True;
    _update_resize = True;
  }
}
void WSCfform::getWorkWSNheight(WSCushort* ){}
void WSCfform::setWorkWSNshadowThickness(WSCuchar ){}
void WSCfform::getWorkWSNshadowThickness(WSCuchar* ){}
void WSCfform::setWorkWSNforeColor(short ){}
void WSCfform::getWorkWSNforeColor(short* ){}
void WSCfform::setWorkWSNbackColor(short data){
  if (_initialized != False && _dev != NULL){
    _dev->setValue(WSDEV_BACKCOLOR,(void*)&data);
  }
}
void WSCfform::getWorkWSNbackColor(short* ){}
void WSCfform::setWorkWSNtopShadowColor(short ){}
void WSCfform::getWorkWSNtopShadowColor(short* ){}
void WSCfform::setWorkWSNbottomShadowColor(short ){}
void WSCfform::getWorkWSNbottomShadowColor(short* ){}
void WSCfform::setWorkWSNbackPixmap(short data){
  if (_initialized != False && _dev != NULL){
    _dev->setValue(WSDEV_BACK_PIXMAP,(void*)&data);
  }
}
void WSCfform::getWorkWSNbackPixmap(short* data){
  if (_initialized != False && _dev != NULL){
    _dev->setValue(WSDEV_BACK_PIXMAP,(void*)data);
  }
}
void WSCfform::setWorkWSNshadowType(char ){}
void WSCfform::getWorkWSNshadowType(char* ){}
void WSCfform::setWorkWSNvis(WSCbool data){
    setVisible(data);
}
void WSCfform::getWorkWSNvis(WSCbool*){}
void WSCfform::setWorkWSNdet(WSCbool data){
  if (getPropertyEditMode() == False){
    if (data == False){
      _sensitive = True;
    }else{
      _sensitive = False;
    }
    setSensitive(data);
  }else{
    if (data == False){
      setUserData(WS_DET,(void*)0);
    }else{
      setUserData(WS_DET,(void*)1);
    }
  }
}
void WSCfform::getWorkWSNdet(WSCbool* data){
  if (getPropertyEditMode() != False){
    long tmp = (long)getUserData(WS_DET);
    WSCbool fl = (WSCbool)tmp;
    *data = fl;
  }
}
void WSCfform::setWorkWSNpixmapStyle(WSCuchar data){
  if (_initialized != False && _dev != NULL){
    _dev->setValue(WSDEV_PIXMAP_STYLE,(void*)&data);
  }
}
void WSCfform::getWorkWSNpixmapStyle(WSCuchar* ){}
void WSCfform::setNoRefresh(WSCbool fl){
  _no_refresh = fl;
}

void WSCfform::setWorkWSNmouse(WSCushort data ){
  if (_initialized != False && _dev != NULL){
    _dev->setValue(WSDEV_MOUSE_NO,(void*)&_mouse_no);
  }
}
void WSCfform::getWorkWSNmouse(WSCushort* ){}
void WSCfform::setWorkWSNgradation(WSCuchar ){}
void WSCfform::getWorkWSNgradation(WSCuchar* ){}
void WSCfform::setWorkWSNgradationMargin(WSCuchar ){}
void WSCfform::getWorkWSNgradationMargin(WSCuchar* ){}
void WSCfform::setWorkWSNmargin(WSCuchar ){}
void WSCfform::getWorkWSNmargin(WSCuchar* ){}

void WSCfform::setWorkWSNanchorTop(WSCushort data){
  if (_anchor_top_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorTop(WSCushort* data){}
void WSCfform::setWorkWSNanchorBottom(WSCushort data){
  if (_anchor_bottom_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorBottom(WSCushort* data){}
void WSCfform::setWorkWSNanchorLeft(WSCushort data){
  if (_anchor_left_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorLeft(WSCushort* data){}
void WSCfform::setWorkWSNanchorRight(WSCushort data){
  if (_anchor_right_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorRight(WSCushort* data){}
void WSCfform::setWorkWSNanchorTopFlag(WSCbool data){
  if (_anchor_top_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorTopFlag(WSCbool* data){}
void WSCfform::setWorkWSNanchorBottomFlag(WSCbool data){
  if (_anchor_bottom_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorBottomFlag(WSCbool* data){}
void WSCfform::setWorkWSNanchorLeftFlag(WSCbool data){
  if (_anchor_left_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorLeftFlag(WSCbool* data){}
void WSCfform::setWorkWSNanchorRightFlag(WSCbool data){
  if (_anchor_right_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCfform::getWorkWSNanchorRightFlag(WSCbool* data){}

void WSCfform::setWorkWSNexport(WSCbool data){
  setExported(data);
}
void WSCfform::getWorkWSNexport(WSCbool* data){
}
void WSCfform::setWorkWSNindicatorOn(WSCbool data){}
void WSCfform::getWorkWSNindicatorOn(WSCbool* data){}
void WSCfform::setWorkWSNbarThickness(WSCuchar data){}
void WSCfform::getWorkWSNbarThickness(WSCuchar* data){}


WSCbool WSCfform::getNoRefresh(){
  return _no_refresh;
}
void WSCfform::setChildren(WSClistData& src){
  _children = src;
}
WSClistData& WSCfform::getChildren(){
  return _children;
}
void WSCfform::onVisibleChange(WSCbool fl){
  long need_resize_event = 0;
  if (fl != False && getowndev() == NULL){
    need_resize_event = 1;
  }
  WSCbase::onVisibleChange(fl);
  if (need_resize_event != 0){
    WSCrect rect;
    rect.x = _x;
    rect.y = _y;
    rect.width = _w;
    rect.height = _h;
    execEventProc(WSEV_RESIZE,(void*)&rect);
  }
}
void WSCfform::onParentVisibleChange(WSCbool fl){
  long need_resize_event = 0;
  if (fl != False && getowndev() == NULL){
    need_resize_event = 1;
  }
  WSCbase::onParentVisibleChange(fl);
  if (need_resize_event != 0){
    WSCrect rect;
    rect.x = _x;
    rect.y = _y;
    rect.width = _w;
    rect.height = _h;
    execEventProc(WSEV_RESIZE,(void*)&rect);
  }
}
void WSCfform::onResize(WSCrect* area){
  WSCbool fl = False;
  if (getPropertyEditMode() == False){
    _x = area->x;
    _y = area->y;
    if (_w != area->width){
      _w = area->width;
      fl = True;
    }
    if (_h != area->height){
      _h = area->height;
      fl = True;
    }
  }
  if (fl != False){
#if 0
    WSDdev* dev = getowndev();
    if (dev != NULL || _pixmap_style != WS_DIRECT_WINDOW){
      dev->setValue(WSDEV_WIDTH,&_w);
      dev->setValue(WSDEV_HEIGHT,&_h);
    }
#endif
    setAbsoluteDraw(True);
    needUpdate();
//    redraw();
  }
#if 0
  if (_floated != False &&
       -100 < _x_bak - _x && _x_bak - _x < 100 &&
       -100 < _y_bak - _y && _y_bak - _y < 100 ){
    _x = _x_bak;
    _y = _y_bak;
//printf("WSCfform::onResize setFloated(False) %s\n",getInstanceName());
    setFloated(False);
  }
#endif
}
WSCfform::~WSCfform(){
  if (_title_string != NULL){
    delete _title_string;
  }
  WSClistData* ghlist = (WSClistData*)getUserData("GH-LIST");
  if (ghlist != NULL){
    delete ghlist;
    setUserData("GH-LIST",(void*)0);
  }
  while(1){
    if (_children.getNum() == 0){
      break;
    }
    WSCbase* child = (WSCbase*)_children[0];
    delete child;
  }
  if (_user_string != NULL){
    delete _user_string;
    _user_string = NULL;
  }
}
long WSCfform::_device_initialize(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (_floated == False){
    char pstyle = getPixmapStyle();
    dev->setVisible(False);
    if (getXOffsetPtr() == NULL){
      dev->setValue(WSDEV_X,(void*)&_x);
    }else{
      short ox = _x + *(getXOffsetPtr());
      dev->setValue(WSDEV_X,(void*)&ox);
    }
    if (getYOffsetPtr() == NULL){
      dev->setValue(WSDEV_Y,(void*)&_y);
    }else{
      short oy = _y + *(getYOffsetPtr());
      dev->setValue(WSDEV_Y,(void*)&oy);
    }
    dev->setValue(WSDEV_MOUSE_NO,(void*)&_mouse_no);
    dev->setValue(WSDEV_WIDTH,(void*)&_w);
    dev->setValue(WSDEV_HEIGHT,(void*)&_h);
    dev->setValue(WSDEV_BACKCOLOR,(void*)&_back_color);
    dev->setValue(WSDEV_BACK_PIXMAP,(void*)&_bp_no);
    dev->setValue(WSDEV_PIXMAP_STYLE,(void*)&pstyle); 
    dev->setEnableEventBit(WSEV_EXPOSE_BIT | WSEV_RESIZE_BIT | WSEV_MOUSE_PRESS_BIT | WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_RELEASE_BIT);
  }else{
    if (getPropertyEditMode() == False){
//      char val = WS_FULL_TITLE;
//      if (_title_bar == WS_NO_MANAGE){
      {
        char val = WS_NO_TITLE;
        _dev->setValue(WSDEV_TITLE_BAR,(void*)&val);
      }
//      }else{
//        _dev->setValue(WSDEV_TITLE_BAR,(void*)&val);
//      }
    }

//    if (_title_bar == WS_NO_MANAGE && getPropertyEditMode() == False){
        WSCbool fl = True;
        dev->setValue(WSDEV_NO_FRAME,(void*)&fl);
        dev->setValue(WSDEV_FLOAT_ON_TOP,(void*)&fl);
//    }else{
//      WSCbool fl = False;
//      dev->setValue(WSDEV_NO_FRAME,(void*)&fl);
//    }

    dev->setValue(WSDEV_MOUSE_NO,(void*)&_mouse_no);
    dev->setValue(WSDEV_X,(void*)&_x);
    dev->setValue(WSDEV_Y,(void*)&_y);
    dev->setValue(WSDEV_WIDTH,(void*)&_w);
    dev->setValue(WSDEV_HEIGHT,(void*)&_h);
    dev->setValue(WSDEV_BACKCOLOR,(void*)&_back_color);
    dev->setValue(WSDEV_BACK_PIXMAP,(void*)&_bp_no);
  
    char pixmap_style = getPixmapStyle();
    dev->setValue(WSDEV_PIXMAP_STYLE,(void*)&pixmap_style);
    if (_title_string != NULL){
      dev->setValue(WSDEV_TITLE_STRING,(void*)_title_string);
    }else{
      dev->setValue(WSDEV_TITLE_STRING,(void*)"");
    }

    dev->setEnableEventBit(WSEV_EXPOSE_BIT | WSEV_RESIZE_BIT |
                           WSEV_MOUSE_PRESS_BIT | WSEV_MOUSE_MOVE_BIT |
                           WSEV_MOUSE_RELEASE_BIT |
                           WSEV_KEY_PRESS_BIT | WSEV_KEY_RELEASE_BIT);
    if (_parent != NULL){
      dev->setValue(WSDEV_POPUP_PARENT,(void*)_parent);
    }
  }
  if (getVisible() != False){
    dev->setVisible(True);
  }
  WSCbase::_device_initialize();
  return WS_NO_ERR;
}
long WSCfform::getObjectType(){
  return (WS_TYPE_MANAGER | WS_TYPE_FORM);
}
long WSCfform::draw(){
  if (_no_refresh != False){
    WSCbase::update();
    setAbsoluteDraw(False);
    return WS_NO_ERR;
  }
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  WSCbool absolute = getAbsoluteDraw(); 
  if (absolute == False  ){
#if 0
    if (getDotMode() == False && _grad_no == 0){
      if ( dev->isExposed(0,0,_w,_shadow_thick) == False &&
           dev->isExposed(0,0,_shadow_thick,_h) == False &&
           dev->isExposed(_w -_shadow_thick,0,_shadow_thick,_h) == False &&
           dev->isExposed(0,_h -_shadow_thick,_w,_shadow_thick) == False ){
        return WS_NO_ERR;
      }
    }else{
#endif
      if ( dev->isExposed(0,0,_w,_h) == False ){
        return WS_NO_ERR;
      }
#if 0
    }
#endif
  }
  if (_update_resize != False){
    _update_resize = False;
    execResizeEvent();
  }

  if (_geometry_changed != False){
    _exec_child_adjust_for_anchors();
  }

  long err = dev->beginDraw(0,0,_w,_h,absolute); 
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = _w;
  WSCushort eh = _h;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  WSCbase::update();
  setAbsoluteDraw(False);
//printf("WSCfform::draw %s bp=%d ab=%d %d %d %d %d\n",getInstanceName(),_bp_no,absolute,ex,ey,ew,eh);
  if (_bp_no == -1){
//printf("w=%d h=%d\n",_w,_h);
    if (_grad_no == 0){
      dev->setForeColor(_back_color);
      dev->drawFillRect(0,0,_w,_h);
    }else{
      dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,0,0,_w,_h,_grad_margin);
    }
  }
  if (getDotMode() == True){
    dev->setForeColor(_fore_color);
    long i,j;
    for(i=0; i<_w; i+=10){
      for(j=0; j<_h; j+=10){
        if (ex < i && i < ex+ ew &&
            ey < j && j < ey+ eh ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }
  WSGFdrawShadow(dev,_shadow_type,_shadow_thick,_fore_color,_ts_color,
                 _bs_color,_back_color,0,0,_w,_h);

  long swidth = 0;
  WSCstring str(_title_string);
  if (_title_string[0] != 0){
    swidth = WSGIappFontSet()->getStringWidth(_font,&str);
  }

  if (_orientation == WS_VERTICAL){
    if ( _h - _shadow_thick*2 - 8 - _margin > 0){
      WSGFdrawShadow(dev,WS_SHADOW_OUT,1,_fore_color,_ts_color,
                   _bs_color,_back_color,
       _shadow_thick + _bar_thick/2 -2 ,_shadow_thick + 2,2,_h - _shadow_thick*2 - 8 - _margin);
      WSGFdrawShadow(dev,WS_SHADOW_OUT,1,_fore_color,_ts_color,
                   _bs_color,_back_color,
       _shadow_thick + _bar_thick/2 +2 ,_shadow_thick + 2,2,_h - _shadow_thick*2 - 8 - _margin);
    }
  }else{
    if ( _w - _shadow_thick*2 - 8 - _margin - swidth > 0){
      WSGFdrawShadow(dev,WS_SHADOW_OUT,1,_fore_color,_ts_color,
                   _bs_color,_back_color,
       _shadow_thick+2 + swidth, _shadow_thick + _bar_thick/2 - 2,_w - _shadow_thick*2 - 8 - swidth - _margin, 2);
      WSGFdrawShadow(dev,WS_SHADOW_OUT,1,_fore_color,_ts_color,
                   _bs_color,_back_color,
       _shadow_thick+2 + swidth, _shadow_thick + _bar_thick/2 + 2,_w - _shadow_thick*2 - 8 - swidth - _margin, 2);
    }
    if (_title_string[0] != 0 && _orientation != WS_VERTICAL){
      dev->setForeColor(_fore_color);
      long fh = WSGIappFontSet()->getStringHeight(_font,&str);
      dev->drawString(_shadow_thick+2,_shadow_thick+2,swidth,fh,&str,_font,WS_CENTER,-1,False);
    }
  }


  if (getFloated() != False && _indicator != False){
    long margin = 2 + _shadow_thick;
    dev->setLineWidth(0);
    dev->setForeColor(_ts_color);
    dev->drawLine(_w - 15 - margin,_h -3 ,_w -3,_h -15 - margin);
    dev->drawLine(_w - 11 - margin,_h -3 ,_w -3,_h -11 - margin);
    dev->drawLine(_w - 7 - margin,_h -3 ,_w -3,_h -7 - margin);
    dev->drawLine(_w - 3 - margin,_h -3 ,_w -3,_h -3 - margin);
    dev->setForeColor(_bs_color);
    dev->drawLine(_w - 14 - margin,_h -3 ,_w -3,_h -14 - margin);
    dev->drawLine(_w - 13 - margin,_h -3 ,_w -3,_h -13 - margin);
    dev->drawLine(_w - 10 - margin,_h -3 ,_w -3,_h -10 - margin);
    dev->drawLine(_w - 9 - margin,_h -3 ,_w -3,_h -9 - margin);
    dev->drawLine(_w - 6 - margin,_h -3 ,_w -3,_h -6 - margin);
    dev->drawLine(_w - 5 - margin,_h -3 ,_w -3,_h -5 - margin);
    dev->drawLine(_w - 2 - margin,_h -3 ,_w -3,_h -2 - margin);
    dev->drawLine(_w - 1 - margin,_h -3 ,_w -3,_h -1 - margin);
  }

  dev->endDraw();
  return WS_NO_ERR;
}
void WSCfform::_exec_child_adjust_for_anchors(){
#if 0
  if (_geometry_changed != False){
    WSClistData children = getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      child->_adjust_for_anchors(_w,_h);
    } 
  }
#endif
  if (adjustAnchor() != False){
    if (_geometry_changed != False){
      WSClistData children = getChildren();
      long num = children.getNum();
      long i;
      for(i=0; i<num; i++){
        WSCbase* child = (WSCbase*)children[i];
        child->_adjust_for_anchors(_w,_h);
        if (getPixmapStyle() == WS_DYNAMIC_PIXMAP){
          if (child->isNeedUpdate() != False){
            if ((long)child->getUserData("anchor update..") == 0){
              child->setUserData("anchor update..",(void*)1);
              child->update();
              child->setUserData("anchor update..",(void*)0);
            }
          }
        }
      }
    }
  }
}

void WSCfform::update(){
  if (isNeedUpdate() != False){
    WSDdev* dev = getowndev();
    if (dev != NULL){
      if (getXOffsetPtr() != NULL){
        short ox = _x + *(getXOffsetPtr());
        short dx;
        dev->getValue(WSDEV_X,&dx);
        if (ox != dx){
          dev->setValue(WSDEV_X,&ox);
        }
      }
      if (getYOffsetPtr() != NULL){
        short oy = _y + *(getYOffsetPtr());
        short dy;
        dev->getValue(WSDEV_Y,&dy);
        if (oy != dy){
          dev->setValue(WSDEV_Y,&oy);
        }
      }
    }
    if (_update_resize != False){
      _update_resize = False;
      execResizeEvent();
    }
    _exec_child_adjust_for_anchors();
    setAbsoluteDraw(True);
    redraw();
    WSCbase::update();
  }
}
long WSCfform::clear(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (getVisible() == False){
    return WS_ERR;
  }
  long er = dev->beginDraw(0,0,_w,_h,True);
  if (er != WS_NO_ERR){
    return WS_NO_ERR;
  }
  dev->clearArea(0,0,_w,_h,False);
  dev->endDraw();
  return WS_NO_ERR;
}

long WSCfform::redraw(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (getVisible() == False){
    return WS_ERR;
  }
  long er = dev->beginDraw(0,0,_w,_h,True);
  if (er != WS_NO_ERR){
    return WS_NO_ERR;
  }
  dev->clearArea(0,0,_w,_h,True);
  dev->endDraw();
  return WS_NO_ERR;
}

long WSCfform::cdraw(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (getVisible() == False){
    return WS_ERR;
  }
  if (getPixmapStyle() != WS_DIRECT_WINDOW){
    redraw();
  }else{
    WSCrect area; 
    area.x = _x;
    area.y = _y;
    area.width = _w;
    area.height = _h;

    short bx,by;
    WSCushort bw,bh; 
    dev->getExposedArea(&bx,&by,&bw,&bh);
    dev->setExposedArea(_x,_y,_w,_h);
    dev->execEvent(WSEV_EXPOSE,&area);
    dev->setExposedArea(bx,by,bw,bh);
  }
  return WS_NO_ERR;
}
void WSCfform::execResizeEvent(){
  WSCrect rect;
  rect.x = _x;
  rect.y = _y;
  rect.width = _w;
  rect.height = _h;
  execEventProc(WSEV_RESIZE,(void*)&rect);
}
void WSCfform::_adjust_for_anchors(WSCushort w,WSCushort h){
  if (w > 0){
    if (_anchor_left_use == 0){
      if (_anchor_right_use != 0){
        long nx = w - _anchor_right - _w;
        _anchor_right_use = False;
        setProperty(WSNx,nx);
        _anchor_right_use = True;
      }
    }else{
      if (_anchor_right_use != 0){
        _anchor_left_use = False;
        _anchor_right_use = False;
        if (w < _anchor_right + _anchor_left){
          setProperty(WSNwidth,1);
        }else{
          setProperty(WSNx,_anchor_left);
          setProperty(WSNwidth,w - _anchor_right - _anchor_left);
        }
        _anchor_left_use = True;
        _anchor_right_use = True;
      }else{
        if (_anchor_left != _x){
          setProperty(WSNx,_anchor_left);
        }
      }
    }
    needUpdate();
    setAbsoluteDraw(True);
  }
  if (h > 0){
    if (_anchor_top_use == 0){
      if (_anchor_bottom_use != 0){
        long ny = h - _anchor_bottom - _h;
        _anchor_bottom_use = False;
        setProperty(WSNy,ny);
        _anchor_bottom_use = True;
      }
    }else{
      if (_anchor_bottom_use != 0){
        _anchor_top_use = False;
        _anchor_bottom_use = False;
        clear();
        if (h < _anchor_bottom + _anchor_top){
          setProperty(WSNheight,1);
        }else{
          setProperty(WSNy,_anchor_top);
          setProperty(WSNheight,h - _anchor_top - _anchor_bottom);
        }
        _anchor_top_use = True;
        _anchor_bottom_use = True;
      }else{
        if (_anchor_top != _y){
          setProperty(WSNy,_anchor_top);
        }
      }
    }
    needUpdate();
    setAbsoluteDraw(True);
  }
}
void WSCfform::onMousePress(WSCpoint* pt){
  WSCbase::onMousePress(pt);
  if (_orientation == WS_VERTICAL){
    if (pt->x > 0 && pt->x < 15 &&
        pt->y > 0 && pt->y < _h - _margin){
      _mouse_x = pt->x;
      _mouse_y = pt->y;
      _mouse_pressed = True;
    }
  }else{
    if (pt->x > 0 && pt->x < _w  - _margin &&
        pt->y > 0 && pt->y < 15){
      _mouse_x = pt->x;
      _mouse_y = pt->y;
      _mouse_pressed = True;
    }
  }
  if (_floated != False){
    if (pt->x > _w -15 && pt->x < _w &&
        pt->y > _h -15 && pt->y < _h){
      if (_indicator != False){
        _mouse_pressed_resize = True;
        if (_resize_timer == NULL){
          _resize_timer = WSDprivateTimer::getNewInstance();
        }
        _resize_timer->stopTimer();
        _resize_timer->setWorkProc(_resize_proc,this);
        _resize_timer->setRate(50);
        _resize_timer->setCont(True);
        _resize_timer->startTimer();
      }
    }
  }
}

void WSCfform::_resize_proc(void* ptr){
  WSCfform* _this = (WSCfform*)ptr;

  short x,y;
  WSGIappMouse()->getMousePosition(&x,&y,_this);
  WSCulong status = WSGIappMouse()->getMouseStatus();

  if (_this->_mouse_pressed_resize != False){
    if (x > 20){
      _this->setProperty(WSNwidth,x + 5);
    }
    if (y > 20){
      _this->setProperty(WSNheight,y + 5);
    }
    _this->update();

    if (status & ( WS_MOUSE_BTN1 | WS_MOUSE_BTN2 | WS_MOUSE_BTN3)){
    }else{
      _resize_timer->stopTimer();
      _this->_mouse_pressed_resize = False;
    }

  }else{
    _resize_timer->stopTimer();
    _this->_mouse_pressed_resize = False;
  }

}
void WSCfform::onMouseMove(WSCpoint* pt){
  WSCbase::onMouseMove(pt);
//printf("move.. %s\n",getInstanceName());
  if (_mouse_pressed == False && _mouse_pressed_resize == False){
    return;
  }
//printf("move.. %s\n",getInstanceName());
  if (_floated == False){
    if (_mouse_pressed == False){
      return;
    }
    if (_mouse_x - pt->x > 100){
//printf("diff!!! %s\n",getInstanceName());
      _x_bak = _x;
      _y_bak = _y;
      _x = pt->x;
      _y = pt->y;
      setFloated(True);
      _mouse_pressed = False;
    }
    if (_mouse_x - pt->x < -100){
//printf("diff!!! %s\n",getInstanceName());
      _x_bak = _x;
      _y_bak = _y;
      _x = pt->x;
      _y = pt->y;
      setFloated(True);
      _mouse_pressed = False;
    }
    if (_mouse_y - pt->y > 100){
//printf("diff!!! %s\n",getInstanceName());
      _x_bak = _x;
      _y_bak = _y;
      _x = pt->x;
      _y = pt->y;
      setFloated(True);
      _mouse_pressed = False;
    }
    if (_mouse_y - pt->y < -100){
//printf("diff!!! %s\n",getInstanceName());
      _x_bak = _x;
      _y_bak = _y;
      _x = pt->x;
      _y = pt->y;
      setFloated(True);
      _mouse_pressed = False;
    }
  }else{
    if (_mouse_pressed_resize != False){
#if 0
      if (pt->x > 20){
        setProperty(WSNwidth,pt->x + 5);
      }
      if (pt->y > 20){
        setProperty(WSNheight,pt->y + 5);
      }
      needUpdate();
#endif
    }else
    if ((_mouse_x > 0 && _mouse_x < 15 &&
         _mouse_y > 0 && _mouse_y < _h &&
         _orientation == WS_VERTICAL) ||
        (_mouse_x > 0 && _mouse_x < _w &&
         _mouse_y > 0 && _mouse_y < 15 &&
         _orientation != WS_VERTICAL) ){
      short x,y;
      WSGIappMouse()->getMousePosition(&x,&y);
      x -= _mouse_x;
      y -= _mouse_y;
      setProperty(WSNx,x-5);
      setProperty(WSNy,y-5);
      needUpdate();
      if (getParent() != NULL){
        WSGIappMouse()->getMousePosition(&x,&y,getParent());
        x -= _mouse_x;
        y -= _mouse_y;
        if ( x - _x_original < 100 &&
             x - _x_original > -100 &&
             y - _y_original < 100 &&
             y - _y_original > -100 ){
          setFloated(False);
          _mouse_pressed = False;
          _change_sequence = False;
        }
      }
    }
  }
}
void WSCfform::onMouseRelease(WSCpoint* pt){
  WSCbase::onMouseRelease(pt);
  _mouse_pressed = False;
  _mouse_pressed_resize = False;

}
WSDprivateTimer* WSCfform::_move_timer = NULL;
WSDprivateTimer* WSCfform::_resize_timer = NULL;

void WSCfform::_move_proc(void* ptr){
  WSCfform* _this = (WSCfform*)ptr;
//printf("move_proc.. %s\n",_this->getInstanceName());
//fflush(stdout);
  short x,y;
  WSGIappMouse()->getMousePosition(&x,&y);
  _this->setProperty(WSNx,x-5);
  _this->setProperty(WSNy,y-5);
  _this->update();
  WSCulong status = WSGIappMouse()->getMouseStatus();
//printf("move_proc timer stats=0x%x  %d %d\n",status,x,y);
//fflush(stdout);


  if (status & ( WS_MOUSE_BTN1 | WS_MOUSE_BTN2 | WS_MOUSE_BTN3)){
//printf("move_proc timer cont..\n");
//fflush(stdout);
  }else{
//printf("move_proc timer stop..\n");
//fflush(stdout);
    _move_timer->stopTimer();
    _this->_change_sequence = False;
  }

  if (_this->getParent() != NULL){
    WSGIappMouse()->getMousePosition(&x,&y,_this->getParent());
    if ( x - _this->_x_original < 100 &&
      x - _this->_x_original > -100 &&
      y - _this->_y_original < 100 &&
      y - _this->_y_original > -100 ){
//printf("here hit!!!!!!!---------------\n");
//fflush(stdout);
    }
  }
}

void WSCfform::_delay_proc(WSCuchar,void* ptr){

  WSCfform* _this = (WSCfform*)ptr;
  _this->_set_floated();
  if (_this->_floated == False){
    return;
  }
  if (_move_timer == NULL){
    _move_timer = WSDprivateTimer::getNewInstance();
  }
  _move_timer->stopTimer();
  _move_timer->setWorkProc(_move_proc,_this);
  _move_timer->setRate(50);
  _move_timer->setCont(True);
  _move_timer->startTimer();
//printf("delay_proc timer started.. %s\n",_this->getInstanceName());
}


void WSCfform::_detach_dev(){
  if (_dev != NULL){
    WSClistData list = getChildren();
    long num = list.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)list[i];
      _detach_dev_sub(child);
    }
  }
}
void WSCfform::_detach_dev_sub(WSCbase* child){
  if (child->getowndev() != NULL){
    WSClistData list = child->getChildren();
    long num = list.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)list[i];
      _detach_dev_sub(child);
    }
    child->getowndev()->deleteInstance();
    child->setdev(NULL);
  }
}
void WSCfform::_set_floated(){
  _detach_dev();
  if (_dev != NULL){
    _dev->detachClient();
    _dev->deleteInstance();
    _dev = NULL;
  }

  if (_floated == False){
    setProperty(WSNx,_x_original);
    setProperty(WSNy,_y_original);
    setdev( WSGIappDevice()->getDevObject("formDev") );
  }else{
    short x,y;
    WSGIappMouse()->getMousePosition(&x,&y);
    setProperty(WSNx,x-5);
    setProperty(WSNy,y-5);

    setdev( WSGIappDevice()->getDevObject("windowDev") );
  }
  getowndev()->setEnableEventBit(_event_mask);

  if (_vis_bk != False){
    setVisible(True);
    setAbsoluteDraw(True);
    needUpdate();
 
  }
  onStatusChange(_floated);
}

void WSCfform::setFloated(WSCbool fl ){
  if ( _change_sequence != False){
    return;
  }
  _change_sequence = True;
//printf("WSCfform::getFloated %d %s\n",fl,getInstanceName());
  _vis_bk = getVisible(); 
  if (_floated != fl){
    if (_dev != NULL){
      if (_vis_bk != False){
        setVisible(False);
      }
//      _dev->detachClient();
    }
#if 0
    if (fl == False){
      if (_dev_form == NULL){
        if (_dev == NULL){
          _dev_form = WSGIappDevice()->getDevObject("formDev");
        }else{
          _dev_form = _dev;
        }
      }
      if (_dev_form != NULL){
        setdev(_dev_form);
      }
    }else{
      if (_dev_win == NULL){
        _dev_win = WSGIappDevice()->getDevObject("windowDev");
      }
      if (_dev_win != NULL){
        setdev(_dev_win);
      }
    }
    if (_vis_bk != False){
      setVisible(True);
    }
#endif
    _floated = fl;
  }
  WSGIappTimer()->addTriggerProc(_delay_proc,WS250MS,this);

//printf("delay_proc timer registered.. %s\n",getInstanceName());
}
WSCbool WSCfform::getFloated(){
  return _floated;
}
void WSCfform::onStatusChange(WSCbool floated){
  execEventProc(WSEV_STATUS_CH,NULL);
}
long WSCfform::execEventProc(long ev, void* data){
  if (ev == WSEV_EXPOSE){
    if (data == NULL){
      WSCrect area;
      area.setRect(0,0,_w,_h);
      onExpose(&area);
      draw();
      if (_expose_op == 1){
        execProcedure(ev);
      }
      return WS_NO_ERR;
    }else{
      WSCrect* area = (WSCrect*)data;
      onExpose(area);
      draw();
      if (_expose_op == 1){
        execProcedure(ev);
      }
    }
    return WS_NO_ERR;
  }
  return WSCbase::execEventProc(ev,data);
}
long WSCfform::getPixmapStyle(){
#ifndef BTRON
#ifndef TE
  return _pixmap_style;
#else
  return WS_DYNAMIC_PIXMAP;
#endif
#else
  return WS_DYNAMIC_PIXMAP;
#endif
}
