//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <mac/WSDmacKeyboard.h>
#include <mac/WSDmacFont.h>
#include <mac/WSDmacAppDev.h>
#include <WSCdevice.h>
#include <WSDcolor.h>
#include <WSDmouse.h>
#include <WSCbase.h>
#include <WSCcolorSet.h>
#include <WSCfontSet.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDmacKeyboard,WSDkeyboard);
#if 0 //XXZZ
#ifndef KINPUT2
#include <locale.h>
#else
extern "C" {
extern int _beginConversionWithAttributes(Widget,Atom,Atom,
    void (*)(Widget,Atom,Atom,int,WSCulong,WSCuchar *,XtPointer),
    void (*)(Widget,Atom,int,XtPointer,Window),
    XtPointer,ArgList,Cardinal);
extern int _endConversion(Widget,Atom,WSCbool);
extern int _changeConversionAttributes(Widget,Atom,ArgList,Cardinal);
}
#endif

extern "C" {
extern char *XSetIMValues(
#if NeedVarargsPrototypes
    XIM /* im */, ...
#endif
);
};
#endif //XXZZ

WSDmacKeyboard* WSGImacKeyboard(){
  WSDkeyboard* keybd = WSGIappKeyboard();
  if (keybd == NULL){
    return NULL;
  }
  WSDmacKeyboard* macKeybd =(WSDmacKeyboard*)keybd->cast("WSDmacKeyboard");
  return macKeybd;
}

WSDkeyboard* _macKeyboard_create_handler(){
  WSDkeyboard* keybd =  new WSDmacKeyboard();
  keybd->initialize();
  return keybd;
}
#if 0 //move to WSGFdeviceInitialize..
class _macKeyboard_init{
  public: _macKeyboard_init(){
    WSDkeyboard::setCreateInstanceHandler(_macKeyboard_create_handler);
  };
};
_macKeyboard_init _macKeyboard_init_execute;
#endif
WSDmacKeyboard::WSDmacKeyboard(){
#if 0 //XXZZ
  _dev_for_xim = NULL;
  _xim = 0;
  _xic = 0;
  _focused = False;
#ifdef SUN
  _xim_init = True;
#else
  _xim_init = False;
#endif

#endif //XXZZ

}

WSDmacKeyboard::~WSDmacKeyboard(){}

#if 0 //XXZZ
void WSDmacKeyboard::_status_start(XIC xic,XPointer,XIMStatusDrawCallbackStruct cdata){ }
void WSDmacKeyboard::_status_done(XIC ,XPointer,XIMStatusDrawCallbackStruct ){ }
void WSDmacKeyboard::_status_draw(XIC xic,XPointer data,XIMStatusDrawCallbackStruct cdata){
    WSDmacKeyboard* obj = (WSDmacKeyboard*)data;
    WSCstring str(cdata.data.text->string.multi_byte);
    str.delHeadSpace();
    str.delTailSpace();
    obj->setModeString(str.getString());
    if (str.isExist("Ѿʸ") != -1 || str.isExist("̵Ѵ")   != -1 ||
        str.isExist("[̵Ѵ]") != -1 ){
      obj->setVisibleModeWindow(False);
    }else{
      obj->setVisibleModeWindow(True);
    }

}
#endif

#if 0 //XXZZ
void WSDmacKeyboard::setDevForXIM(WSDdev* dev){
  _dev_for_xim = dev;
}
WSDdev* WSDmacKeyboard::getDevForXIM(){
  return _dev_for_xim;
}
void WSDmacKeyboard::_im_instantiate(Display* display,XPointer ptr,XPointer){
  WSDmacKeyboard* _this = (WSDmacKeyboard*)ptr;
  _this->_xim_init = True;
}
void WSDmacKeyboard::_im_destroy(XIM,XPointer ptr,XPointer){
  WSDmacKeyboard* _this = (WSDmacKeyboard*)ptr;
  _this->_xim = NULL;
  _this->_xic = 0;
}
#endif //XXZZ

long WSDmacKeyboard::initialize(){
  //ISO8859..
  if (WSGIappCodeConvert()->getSystemLocale() > WS_EN_NONE &&
      WSGIappCodeConvert()->getSystemLocale() < WS_EN_UTF8){
    return WS_NO_ERR;
  }
#if 0 //XXZZ
#ifndef SUN
  XRegisterIMInstantiateCallback(WSGImacAppDev()->display(),
        NULL, NULL, NULL, _im_instantiate, (XPointer)this);
#endif
#endif //XXZZ
  return WS_NO_ERR;
}

long WSDmacKeyboard::startKanji(WSDdev* dev,short x,short y,short fontno,short fgno,short bgno){
#if 0 //XXZZ
  WSDfont*    font  = WSGIappFontSet()->getFont(fontno);
  WSDcolor*   fgcol = WSGIappColorSet()->getColor(fgno);
  WSDcolor*   bgcol = WSGIappColorSet()->getColor(bgno);

  setDevForXIM(dev);
  WSDxfont* xfont = (WSDxfont*)font->cast("WSDxfont");
  if (xfont != NULL){
    short px,py;
    WSCstring tmpstr("ABjpy");
    dev->getAbsoluteAddr(x,y + font->getStringHeight(&tmpstr),&px,&py);
    dev->setAbsoluteAddrChangeHandler(_device_move_handler,this);
    XPoint point;
    point.x = px;
    point.y = py;

    short dx,dy;
    dev->getDispAddr(&dx,&dy);
    setModeWindowPos(dx,dy,dev);

    XRectangle area;
    area.x = 0;
    area.y = 0;
    area.width =  10000;
    area.height = 10000;

    if (_xic != 0){
      XVaNestedList list;
      XVaNestedList list2;
      XFontSet* font_set = (XFontSet*)xfont->getXFontSet();

      list = XVaCreateNestedList(0, XNFontSet,font_set,
               XNSpotLocation,&point, XNArea,&area, 
               XNForeground,fgcol->getValue1(),
               XNBackground,bgcol->getValue1(), NULL,NULL);

      XIMCallback callback_status_start;
      callback_status_start.client_data = (char*)this;
      callback_status_start.callback = (XIMProc)_status_start;

      XIMCallback callback_status_done;
      callback_status_done.client_data = (char*)this;
      callback_status_done.callback = (XIMProc)_status_done;

      XIMCallback callback_status_draw;
      callback_status_draw.client_data = (char*)this;
      callback_status_draw.callback = (XIMProc)_status_draw;

      list2 = XVaCreateNestedList(0, XNStatusStartCallback,
           &callback_status_start, 
           XNStatusDoneCallback,&callback_status_done, 
           XNStatusDrawCallback,&callback_status_draw, NULL,NULL);

      Window win;
      XGetICValues(_xic,XNFocusWindow,&win, NULL);
      if(win != XtWindow((Widget)dev->getSpecialResource())){
        XWindowAttributes att;
        Display* disp =  XtDisplay((Widget)dev->getSpecialResource());
        Window   target =  XtWindow((Widget)dev->getSpecialResource());
        XGetWindowAttributes(disp, target, &att);
        WSCulong mask;
        XGetICValues(_xic,XNFilterEvents,&mask,NULL);
        XSelectInput(disp,target,mask | att.your_event_mask);
        _xic = _get_xic(target);
        XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                     list2, NULL);
      }else{
        XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                     list2, NULL);
      }
      XSetICFocus(_xic);
      _focused = True;
      XFree(list);
      XFree(list2);
    }
  }
#endif //XIM
  return WS_NO_ERR;
}

long WSDmacKeyboard::startAscii(WSDdev* dev,short ,short ,short ,short ,short ){
#if 0 //XXZZ
  if(_xic != 0 ){
    if (_focused == True){
      XUnsetICFocus(_xic);
      _focused = False;
    }
  }

  setDevForXIM(dev);
#endif //XXZZ

  _fep_on = False;
  return WS_NO_ERR;
}


long WSDmacKeyboard::resetFep(WSDdev* dev){
#if 0 //XXZZ
  if(_xic != 0 ){
    if (_focused == True){
      XUnsetICFocus(_xic);
      _focused = False;
    }
  }
  setDevForXIM(NULL);
  return WS_NO_ERR;
#endif //XXZZ
}

#if 0 //XXZZ
XIC WSDmacKeyboard::_create_xic(Window win,XVaNestedList list,XVaNestedList list2){
  if (_xim != 0){
    XCloseIM( _xim );
    _xim = 0;
  }
  WSDmacAppDev* app   = WSGImacAppDev(); 
  setlocale(LC_CTYPE,"");
  XSetLocaleModifiers("");
  _xim = XOpenIM(app->display(),NULL,NULL,NULL);

  if (_xim == 0){
    return NULL;
  }

  XIMCallback ximcallback;
#ifdef SUN
  ximcallback.callback = (XIMProc)_im_destroy;
#else
  ximcallback.callback = _im_destroy;
#endif
  ximcallback.client_data = (XPointer)this;
  XSetIMValues(_xim, XNDestroyCallback, &ximcallback, NULL);
  XIMStyle style = 0;
  static XIMStyle the_styles[]
          = { XIMPreeditPosition | XIMStatusNothing, //over_the_spot style
              XIMPreeditNothing | XIMStatusNothing,  //root style
              XIMPreeditNone | XIMStatusNone,        //root style
              0
            };

  XIMStyles* styleBuf;
  XGetIMValues(_xim,XNQueryInputStyle,&styleBuf,NULL);

  long i = 0;
  while(the_styles[i] != 0){
    long j;
    for(j = 0; j < styleBuf -> count_styles;j++){
        if( the_styles[i] == styleBuf->supported_styles[j]){
          style = styleBuf -> supported_styles[j];
          break;
        }
    }
    if (style != 0){
      break;
    }
    i++;
  }

  XFree(styleBuf);

  if(style == 0){
WSMFtrace("Error. CAN'T USE INPUT STYLE !!  \n" );
    return 0;
  }

  XIC xic = (XIC)XCreateIC(_xim, XNInputStyle,style,
//           XNClientWindow,XtWindow((Widget)WSGImacAppDev()->appWidget()),
           XNClientWindow,win,
           XNFocusWindow,win, XNPreeditAttributes,list,
           XNStatusAttributes,list2, NULL);
  return xic;
}

XIC WSDmacKeyboard::_get_xic(Window win){
  if (_xic != 0){
//    XSetICValues( _xic, XNClientWindow,win,NULL);
    XSetICValues( _xic, XNFocusWindow,win,NULL);
  }
  return _xic;
}
#endif


long WSDmacKeyboard::setFepPos(WSDdev* dev,short x,short y,short fontno,short fgno,short bgno){
#if 0 //XXZZ
static short x_bk = 0;
static short y_bk = 0;

  setDevForXIM(dev);
  WSDfont*    font  = WSGIappFontSet()->getFont(fontno);
  WSDcolor*   fgcol = WSGIappColorSet()->getColor(fgno);
  WSDcolor*   bgcol = WSGIappColorSet()->getColor(bgno);
  WSDxfont* xfont = (WSDxfont*)font->cast("WSDxfont");
  if (dev != NULL && xfont != NULL){
    short px,py;
    WSDfont*  font  = WSGIappFontSet()->getFont(fontno);
    dev->getAbsoluteAddr(x,y + font->getFontHeight(),&px,&py);
//printf("setFepPos %d,%d %d,%d fh=%d\n",x,y,px,py,font->getFontHeight());
    dev->setAbsoluteAddrChangeHandler(_device_move_handler,this);

    XPoint point;
    point.x = px;
    point.y = py;
    short dx,dy;
    dev->getDispAddr(&dx,&dy);
    setModeWindowPos(dx,dy,dev);

    XRectangle area;
    area.x = 0;
    area.y = 0;
    area.width =  10000;
    area.height = 10000;

    if (_xim_init != False){
      XVaNestedList list;
      XVaNestedList list2;

      XFontSet* font_set = (XFontSet*)xfont->getXFontSet();
      list = XVaCreateNestedList(0,
               XNFontSet,font_set,
               XNSpotLocation,&point,
               XNArea,&area,
               XNForeground,fgcol->getValue1(),
               XNBackground,bgcol->getValue1(),NULL,NULL);

      XIMCallback callback_status_start;
      callback_status_start.client_data = (char*)this;
      callback_status_start.callback = (XIMProc)_status_start;

      XIMCallback callback_status_done;
      callback_status_done.client_data = (char*)this;
      callback_status_done.callback = (XIMProc)_status_done;

      XIMCallback callback_status_draw;
      callback_status_draw.client_data = (char*)this;
      callback_status_draw.callback = (XIMProc)_status_draw;

      list2 = XVaCreateNestedList(0, XNStatusStartCallback,
                  &callback_status_start, 
                  XNStatusDoneCallback,&callback_status_done, 
                  XNStatusDrawCallback,&callback_status_draw, NULL,NULL);
      if (_xic == 0){
        _xic = _create_xic(XtWindow((Widget)dev->getSpecialResource()),
                         list,list2);
      }else{
        Window win;
        XGetICValues(_xic,XNFocusWindow,&win, NULL);
        if(win != XtWindow((Widget)dev->getSpecialResource())){
          Display* disp =  XtDisplay((Widget)dev->getSpecialResource());
          Window   target =  XtWindow((Widget)dev->getSpecialResource());
          XWindowAttributes att;
          XGetWindowAttributes(disp, target, &att);
          XDestroyIC(_xic);

          _xic = NULL;
          _xic = _create_xic(XtWindow((Widget)dev->getSpecialResource()),
                           list,list2);
          WSCulong mask;
          XGetICValues(_xic,XNFilterEvents,&mask,NULL);
          XSelectInput(disp,target,mask | att.your_event_mask);
        }else{
          if (x_bk == x && y_bk == y){
            point.y ++;
            XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                         list2, NULL);
            point.y --;
          }
          XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                       list2, NULL);
        }
        XSetICFocus(_xic);
        _focused = True;
      }
      XFree(list);
      XFree(list2);
    }
  }
  x_bk = x;
  y_bk = y;
#endif //XXZZ
  return WS_NO_ERR;
}

void WSDmacKeyboard::setModeWindowPos(short x,short y,WSDdev* dev){
  WSCushort h = 0;
  WSCbase* client = dev->getAttachedClient();
  if (client != NULL){
    if (client->existProperty(WSNheight) != False){
       client->getPropertyV(WSNheight,&h);
    }
  }
  short dx = x;
  short dy = y + h + 10;
  if ((long)(y + h + 40) > (long)WSGIappDev()->getHeight()){
    dy = y - 50;
  }
  setPositionModeWindow(dx,dy);
}


#if 0 //XXZZ
void WSDmacKeyboard::setEnableFep(WSDdev* dev,WSCbool fl){
  WSDkeyboard::setEnableFep(dev,fl);
  return;
#if 0
  if (fl == False){
    if (_xic != 0){
      if (_focused == True){
        XUnsetICFocus(_xic);
        _focused = False;
      }
    }
  }else if (dev != NULL){
    setDevForXIM(dev);
    Window win ;
    if(_xic != 0){
      if ( getDevForXIM() != NULL ){
        WSDdev* dev = getDevForXIM();
        Display* disp =  XtDisplay((Widget)dev->getSpecialResource());
        Window   target =  XtWindow((Widget)dev->getSpecialResource());
        int revent;
        Window tmpw = 0;
        XGetInputFocus(disp, &tmpw,&revent);
        if (tmpw != target){
          int fl = 1;
          if (dev->getVisible() != False){
            XWindowAttributes wa;
            XGetWindowAttributes(disp,target,&wa);
            if (wa.map_state != IsViewable){
              fl = 0;
            }
          }else{
            fl = 0;
          }
          if (fl == 1){
            XSetInputFocus(disp,target,RevertToParent,CurrentTime);
          }
        }

        WSCulong mask;
        XGetICValues(_xic, XNFocusWindow,&win, XNFilterEvents,&mask, NULL);
        if(win != target){
         _xic = _get_xic(target);
          XWindowAttributes att;
          XGetWindowAttributes(disp, target, &att);
          XSelectInput(disp,target,mask | att.your_event_mask);
        }
      }
      XSetICFocus(_xic);
      _focused = True;
    }
  }
#endif
}

WSCbool WSDmacKeyboard::deliverKeyEvent(XEvent* ev){
  WSCbool press = False;
  if ( ev->type == KeyPress){
     press = True;
  }
  char buffer[1024];
  KeySym key = 0;
#ifdef KINPUT2 
  if (ev->type == FocusIn ){
    return True;
  }
  if (_fep_on != False ){
    static WSCulong time_bk = 0;
    if (_dev_for_kn != NULL && _dev_for_kn->getVisible() != False){
      Window win = XtWindow((Widget)_dev_for_kn->getSpecialResource());
      if (ev->xany.window != win){
        ev->xany.window = win;
        if (ev->type == KeyPress){
          XSendEvent( XtDisplay((Widget)_dev_for_kn->getSpecialResource()),
                  win,False,KeyPressMask,ev);
        }else{
          XSendEvent( XtDisplay((Widget)_dev_for_kn->getSpecialResource()),
                  win,False,KeyReleaseMask,ev);
        }
        return False;
      }
    }
    if (ev->macKey.time != time_bk){
      time_bk = ev->macKey.time;
      return False;
    }
  }

  int len = XLookupString((XKeyEvent *)ev,buffer,1022,&key,(XComposeStatus*)NULL);
  buffer[len]=0;
  if (len == 1 && ((WSCuchar)buffer[0] < 0x20 || (WSCuchar)buffer[0] > 0x7f)){
     buffer[0] = 0;
     len = 0;
  }

#else //XIM
  if (_xic == 0){
    if (ev->type == FocusIn){
       return True;
    }
    int len = XLookupString((XKeyEvent *)ev,buffer,1022,&key,(XComposeStatus*)NULL);
    buffer[len]=0;
    if (len == 1 && (buffer[0] < 0x20 || (unsigned char)buffer[0] > 0x7f)){
       buffer[0] = 0;
       len = 0;
    }

  }else{
    if (_dev_for_xim != NULL ){ 
      if (_dev_for_xim->getVisible() != False){
        Window win = XtWindow((Widget)_dev_for_xim->getSpecialResource());
        if (ev->type == FocusIn){
          if ( ev->xany.window != win){

            XWindowAttributes att;
            XGetWindowAttributes(
                 XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
                 win, &att);
            if (att.map_state == IsViewable){
              XSetInputFocus(
                 XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
                 win, RevertToParent,CurrentTime);
            }
            return False;
          }else{
            return True;
          }
        }
        if (ev->xany.window != win){
          if (ev->type == KeyPress || ev->type == KeyRelease){
            ev->xany.window = win;
            WSCbool fl = XFilterEvent(ev,None);
            if (fl != False){
              return False; //It is Ok ,because FEP is effected.
            }
          }else{
            return False;
          }
        }
      }
    }
    Status status = XLookupNone;
    int len = XmbLookupString(_xic,(XKeyEvent *)ev,buffer,1022, &key,&status);
    buffer[len] = 0;
    if(status == XLookupNone){
         len = XLookupString((XKeyEvent *)ev,buffer,1022,&key,(XComposeStatus*)NULL);
    }
    if (len == 1 && (buffer[0] < 0x20 || (unsigned char)buffer[0] > 0x7f)){
       buffer[0] = 0;
       len = 0;
    }

  }
#endif
  setKey(key);
  _with_shift = ((ev->macKey.state & ShiftMask) != 0    );
  if (key == XK_ISO_Left_Tab){
    setKey(XK_Tab);
    _with_shift = 1;
  }
  _with_lock = ((ev->macKey.state & LockMask) != 0     );
  _with_cntl = ((ev->macKey.state & ControlMask) != 0  );
  _with_alt = ((ev->macKey.state & Mod1Mask) != 0     );
  _is_cursor = IsCursorKey(key);
  _is_function = IsFunctionKey(key);
  setText(buffer,WSGIappCodeConvert()->getSystemLocale());

  if (key == WSK_Delete || key == WSK_Insert){
    _is_tty_function = True;
  }else{
    _is_tty_function = False;
  }

#ifdef KINPUT2
  if ( ev->type == KeyPress && (
   (key == WSK_space && withShift() == True ) ||
#ifndef SUN
               key == WSK_Kanji ||
#else 
               key == WSK_Henkan ||
#endif
        (key == WSK_Zenkaku_Hankaku && withAlt() == True) ||
        (key == WSK_Hiragana_Katakana ) )){
    if (_dev_for_kn != NULL && getEnableFep() == True ){
      startKanji(_dev_for_kn,_x_kn,_y_kn,_font_kn,_fg_kn,_bg_kn);
      return False;
    }
  }
#endif

  WSCbool executed = executeHandler(press);
  if (executed == True){
    return False;
  }else{
    return True;
  }
}
#endif //XXZZ

void WSDmacKeyboard::_device_move_handler(WSDdev* dev,void*dt){
  WSDmacKeyboard* obj = (WSDmacKeyboard*)dt;
  if (obj->_fep_on == True){
    obj->startAscii(dev,0,0,0,0,0);
  }
}
void WSDmacKeyboard::setSelectedString(char* str,long encode){
#if 0 //XXZZ
  WSDkeyboard::setSelectedString(str,encode);
  WSDmacAppDev* app   = WSGImacAppDev(); 

  WSCstring string;
  string.setString(str,encode);
  XStoreBytes(app->display(),
              string.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
    strlen( string.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()))+1);

  Window owner = XGetSelectionOwner(app->display(),XA_PRIMARY);
  Window me = XtWindow(app->appWidget());
  if (owner != me){
//printf("WSDmacKeyboard::setSelectedString selection owner::\n");
    XSetSelectionOwner(app->display(),XA_PRIMARY,me,CurrentTime);
  }
#endif //XXZZ
printf("WSDmacKeyboard::setSelectedString... not supported..\n");
}
char* WSDmacKeyboard::getSelectedString(long encoding){
printf("WSDmacKeyboard::getSelectedString... not supported..\n");
#if 0 //XXZZ

static long _lock = 0;
  if (_lock == 0){
    _lock = 1;
    WSDmacAppDev* app   = WSGImacAppDev(); 
static Atom prop = 0;
    if (prop == 0){
      prop = XInternAtom(app->display(),"COMPOUND_TEXT",False);
    }
    Window me = XtWindow(app->appWidget());
    XConvertSelection(app->display(),XA_PRIMARY,XA_STRING,prop,me,CurrentTime);
//printf("WSDmacKeyboard::getSelectedString... create request...\n");


    _wait_for_receive_data = 1;
    while(_wait_for_receive_data){
      app->dispatchEvent();
      WSGIappDevice()->clearDeleteList();
    }
    _lock = 0;
//printf("WSDmacKeyboard::getSelectedString() #%s#\n", WSDkeyboard::getSelectedString());
    return WSDkeyboard::getSelectedString(encoding); 
  }else{
    return "";
  }
#endif //XXZZ
  return "";
}

void WSDmacKeyboard::selectionDataAvailable(){
  _wait_for_receive_data = 0;
}

