//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall 
// not be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from  
// Toshikaz Hirabayashi.


#ifndef WSCBASE_H
#define WSCBASE_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSCproperty.h>
#include <WSClistData.h>
#include <WSCindexData.h>
#include <WSCindexVariantData.h>
#include <WSCprocedure.h>
#include <WSCconductor.h>
#include <WSDserialize.h>
#include <WSCvariant.h>

class WSDdev;
class WSCbase;
class WSCdevice;
class WSCfontSet;
class WSCclassInformation;

#define WSCbase_VER   1000

class WSCbase :public WSCroot{

 private:
  static WSCclassInformation* WSCbase_info_ptr;
  WSCclassInformation* _own_class_info;
 protected:
  static WSClistData* _create_proc_list;
  static WSClistData* _cname_list;
  static WSCbase* _focus_instance;
  static WSCbase* _special_focus_instance;
  static WSCushort _grid_x;
  static WSCushort _grid_y;

  WSCprocedure** _prc_list;
  char*     _instance_name;
  WSDdev*   _dev;
  WSCbase*  _dev_public;
  WSCbase*  _parent;
  WSCbase*  _data_source_server;
  WSClistData*  _data_source_clients;
  char**    _user_data_name_list;
  void**    _user_data_list;
  WSCindexVariantData* _variant_list;
  void**    _scale_ptrs;
  long      _event_mask;
  char      _num_of_user_data;
  unsigned  _name_hash_value:6;
  unsigned  _absolute_draw:1;
  unsigned  _show_grip_hand:1;
  unsigned  _init_registered:1;
  unsigned  _update_registered:1;
  unsigned  _vis:1;
  unsigned  _vis_bk:1;
  unsigned  _parent_vis:1;
  unsigned  _parent_vis_init:1;
  unsigned  _sensitive:1;
  unsigned  _parent_sensitive:1;
  unsigned  _parent_sensitive_init:1;
  unsigned  _property_edit_mode:1;
  unsigned  _internal_object:1;
  unsigned  _geometry_changed:1;
  unsigned  _expose_op:1;
  unsigned  _initialized:1;
  unsigned  _use_parent_base_dev:1;
  unsigned  _dev_is_public_dev:1;
  unsigned  _proc_is_changed:1;
  unsigned  _no_clear:1;
  unsigned  _export_:1;
  unsigned  _export_bk:1;

  static long _edit_mouse_move_handler(void*);

  void _set_prop_error(char*);
  void _set_prop_error2(char*,char*,WSCproperty*);
  void _get_prop_error(char*);
  void _get_prop_error2(char*,char*,WSCproperty*);

 public:
  virtual void onMouseIn(WSCpoint*);
  virtual void onMouseOut();
  virtual void onMouseMove(WSCpoint*);
  virtual void onMousePress(WSCpoint*);
  virtual void onMouseDoubleClick(WSCpoint*);
  virtual void onMouseRelease(WSCpoint*);
  virtual void onExpose(WSCrect*);
  virtual void onResize(WSCrect*);
  virtual void onVisibleChange(WSCbool);
  virtual void onSensitiveChange(WSCbool);
  virtual void onParentVisibleChange(WSCbool);
  virtual void onParentSensitiveChange(WSCbool);
  virtual void onEditModeChange(WSCbool);
  virtual void onFocusChange(WSCbool);
  virtual void onWindowFocusChange(WSCbool);
  virtual void onSpecialFocusChange(WSCbool);
  virtual void onChildAdded(WSCbase*);
  virtual void onSelectionChange(WSCbool);
  virtual void onGuiPolicyChange(long policy);
  virtual void onDefaultColorChange();

 protected:
  virtual long _device_initialize();

  WSCbool _get_parent_visible();
  WSCbool _get_parent_sensitive();
  WSCbool _get_prop(void* value,char type,WSCproperty*);
  char*   _get_property_str_value(WSCproperty*);

  void _draw_grip_hand(short x,short y,WSCushort w,WSCushort h);
  void _exec_procedure(WSCprocedure**,char*);
  void _exec_procedure(WSCprocedure**,long,WSCbool del_ev);
  void _exec_procedure(WSCprocedure*);
  void _exec_del_procedure();
  void _add_prcs(WSCprocedure***,WSCprocedure*);
  void _register_focus_move();

  WSCbase* _get_focus_move_instance(long);
  void   _error_output(char*,char*,char*,WSCbool);
  long   _property_init();
static WSCbase* (*_create_instance_handler)(char*,WSCbase*,char*);
 public:
static void setCreateInstanceHandler(WSCbase*(*)(char*,WSCbase*,char*));
  static void setGripHandGrid(WSCushort,WSCushort);
  static void getGripHandGrid(WSCushort*,WSCushort*);
  virtual void _adjust_for_anchors(WSCushort w,WSCushort h);

  WSCbase(WSCbase *,char *);
  virtual  ~WSCbase();

  virtual long initialize();
  WSCbool getInitialized();
  void    setInstanceName(char *); 

  char* getInstanceName();
  long  getInstanceNameHashValue();

  virtual long getObjectType();
  WSClistData* getProcedureList();
  WSClistData getProcedures();

  void     setParent(WSCbase*);
  WSCbase* getParent();
  WSCbase* getParentWindow();

  long setChild(WSCbase*);
  long delChild(WSCbase*);

  void    setInternalObject(WSCbool );
  WSCbool getInternalObject();

  virtual void setScaleOffsetPtr(double*);
  virtual void setXOffsetPtr(short*);
  virtual void setYOffsetPtr(short*);
  double* getScaleOffsetPtr();
  short*  getXOffsetPtr();
  short*  getYOffsetPtr();

  WSCproperty* getPropObj(char* prop_name);
  long     getPropObjArray(WSClistData*);
  long     isDefaultValue(char*,WSCbool*);
  WSCbool  setDefaultValue(char*);
  WSCbool  existProperty(char*);

  WSCbool  _set_property(char *name,char *data);
  WSCbool  setProperty(char *name,const WSCvariant&);
  WSCvariant getProperty(char *name);
  long     getPropertyArray(WSClistData*,WSCbool include_default);

  virtual char* getDefaultProperty();

  WSCbool  setPropertyV(char *name,long  v);
  WSCbool  getPropertyV(char *name,long* v);
  WSCbool  setPropertyV(char *name,int  v);
  WSCbool  getPropertyV(char *name,int* v);
  WSCbool  setPropertyV(char *name,WSCuint   v);
  WSCbool  getPropertyV(char *name,WSCuint*  v);
  WSCbool  setPropertyV(char *name,WSCuchar   v);
  WSCbool  getPropertyV(char *name,WSCuchar*  v);
  WSCbool  setPropertyV(char *name,WSCushort  v);
  WSCbool  getPropertyV(char *name,WSCushort* v);
  WSCbool  setPropertyV(char *name,WSCulong   v);
  WSCbool  getPropertyV(char *name,WSCulong*  v);
  WSCbool  setPropertyV(char *name,short  v);
  WSCbool  getPropertyV(char *name,short* v);
  WSCbool  setPropertyV(char *name,char*  v);
  WSCbool  getPropertyV(char *name,char** v);
  WSCbool  setPropertyV(char *name,char  v);
  WSCbool  getPropertyV(char *name,char* v);
  WSCbool  setPropertyV(char *name,float  v);
  WSCbool  getPropertyV(char *name,float* v);
  WSCbool  setPropertyV(char *name,double  v);
  WSCbool  getPropertyV(char *name,double* v);
  WSCbool  setPropertyV(char *name,void*  v);
  WSCbool  getPropertyV(char *name,void** v);
  WSCbool  setPropertyV(char *name,WSCvariant v);

  void         setPropertyVDefault(char* name,long fl);
  virtual      WSCclassInformation* getClassInformation();
  WSClistData* getPropertyList();

  virtual long setPropertyEditMode(WSCbool );
  long setFocus(WSCbool fl = True);
  long setSpecialFocus(WSCbool fl = True);

  long setPropertyEditExecute(WSCbool );
  void setVisible(WSCbool); 
  void setNoClearFlag(WSCbool);

  void setParentVisible(WSCbool);
  void setSensitive(WSCbool);
  void setParentSensitive(WSCbool);

  WSCbool getPropertyEditMode();
  WSCbool getVisible();
  WSCbool getParentVisible();
  WSCbool getSensitive();
  WSCbool getParentSensitive();
  WSCbool getFocus();
  WSCbool getSpecialFocus();
  WSCbool getDotMode();

  long    setAbsoluteDraw(WSCbool fl);
  WSCbool getAbsoluteDraw();

  void    setUserData(char*,void *);
  void*   getUserData(char*);
  void    setVariantData(char*,WSCvariant);
  WSCvariant&   getVariantData(char*);

  WSCbase* getChildInstance(char*);
  WSCbase* getFocusMoveInstance(long);

  WSClistData* getDataSourceClients();      
  void         addDataSourceClient(WSCbase*);      
  void         delDataSourceClient(WSCbase*);      
  WSCbase*     getDataSourceServer();      
  void         setDataSourceServer(WSCbase*);      
  void         setDataToDataSourceClients(WSCvariant*);      
  virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT); 
  virtual long getDataSourceType(); 
  virtual char* getDataSourcePropertyName(); 

  virtual WSClistData&    getChildren();      
  virtual void    setChildren(WSClistData&);      
  long            getAllChildren(WSClistData&);      
  virtual  void   update();
  void            needUpdate();

  WSCbool isNeedUpdate();
  WSCbool isParent(WSCbase*);
  WSCbool existTrigger(long);
  WSCbool getMouseAddr(short*,short*);
  WSCindexData* getExtTriggerList();

  virtual long addProcedure(WSCprocedure*);
  long addProcedure(char* pname,char* fname,long);

  long delProcedure(WSCprocedure*);
  long delAllProcedure();
  void execProcedure(char*);
  void execProcedure(long);

  virtual long draw();
  virtual long clear();
  virtual long redraw();
  virtual long cdraw();

  WSDdev* getdev();
  WSDdev* getowndev();
  WSDdev* getParentDev();
  WSDdev* attachdev();
  WSCbase* getPublicDevChild();

  void setUseParentBaseDev(WSCbool);
  WSCbool getUseParentBaseDev();
  long setdev(WSDdev*);
  long setpablicdev(WSDdev*);
  long setMoveMode(WSCbool);
  long setOrder(char);

  long    setShowGriphand(WSCbool);
  long drawGriphand();
  long clearGriphand();

  static void     setCreateHandler(char*,WSCbase* (*hd)(WSCbase*,char*));
  static WSCbase* getNewInstance(char* class_name,WSCbase* parent,char* name);
  static WSCbase* getFocusInstance();
  static WSCbase* getSpecialFocusInstance();
  static WSClistData* getSupportedClassList();

  virtual void onDataSave(WSDserialize*);
  virtual void onDataLoad(WSDserialize*);

  virtual char* getUseDevName();
  virtual long execEventProc(long ev,void*);
  virtual WSCbase* getPropertyInheritChild();

  static  void setCreateCallback(void(*)(void*),void*);

  long getVer(long v = WSCbase_VER);
  long checkVersion(long v);

  void setGeometryChanged(WSCbool);

  void setExportName(char*);
  char* getExportName();
  void setExported(WSCbool);
  WSCbool getExported();

  virtual WSCbool adjustAnchor();

  WSMFclassDef(WSCbase,WSCroot);
};
#define WSMFsetUseDevice(DN) \
  virtual char* getUseDevName()

#define WSMFguiClassDef(CN,VC) \
 public: \
  static WSCbase* createInstance(WSCbase*,char*); \
  virtual char* getClassName(); \
  virtual void* cast(char *cname = NULL); \
  static WSCclassInformation* CN ## _info_ptr; \
  virtual WSCclassInformation* getClassInformation()

#define WSMFversionDef(CN) \
  long getVer(long val = CN ## _VER); \
  long checkVersion(long)

#define WSMFpropertyDef(PN,PT,WorkVal) \
  static void _set_p_w  ## WorkVal(void* ptr,void* data); \
  static void _get_def_w ## WorkVal(void* ptr); \
  static void _get_p_w  ## WorkVal(void* ptr,void* data); \
  virtual void setWork ## PN (PT); \
  virtual void getWork ## PN (PT*)


#endif
