//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDAPPDEV_H
#define WSDAPPDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>
#include <WSCindexData.h>
#include <WSCstring.h>
class WSCbase;

class WSDappDev   :public WSDdev{

  protected:
    WSCbase*  _modal_client;
    void*     _modal_proc;
    WSCstring _name;
    int       _iprm;
    char**    _cprm;
    WSCbase*  _selection_owner;
    long      _policy;
    WSCbase*  _focus_dialog;
    WSClistData _pld_menu_list;
    long      _mode; 
    void*     _alt_context; 
    void*     _alt_context2; 
    WSCindexData _ext_policy_list;
    WSCstring _ext_policy_name;
    WSCindexData* _current_policy_fn_list;


    static WSDappDev*   _instance;
    static WSClistData* _init_handler;
    static WSCbool _init_executed;
    static WSCbool _trace_output;
    static WSClistData* getInitHandler(); 
    static WSCbool getInstanceExist();
    static void setInstance(WSDappDev*);
    static void _trace_msg(char* data);

  public:
    WSDappDev();
    virtual ~WSDappDev();

    virtual long initialize();
    long   execInitHandler();

    virtual WSCushort getWidth();
    virtual WSCushort getHeight();
    virtual void update();

    WSCbool getTraceMode();
    void    setTraceMode(WSCbool fl);
    void    setInstanceName(char*);
    char*   getInstanceName();
//DEVELOP
    void setModalClient(WSCbase*);
    WSCbase* getModalClient();
//    WSCbase* getModal();
    void setFocusDialog(WSCbase*,WSCbool fl);
    WSCbase* getFocusDialog();

    void addMenu(WSCbase*);
    void delMenu(WSCbase*);
    WSClistData& getMenuList();

    void setSelectionOwner(WSCbase*);
    WSCbase* getSelectionOwner();

    void setModalProc(void(*)(WSDdev*,long,void*));
    void* getModalProc();

    static  void setInitHandler( void(*)() );
    static  void setCreateInstanceHandler( WSDappDev* (*hd)() );
    virtual long dispatchEvent()=0;
    virtual long processEvent()=0;
    virtual long handleEvents()=0;

    void setGuiPolicy(long val,WSCbool create_event);
    long getGuiPolicy();
    virtual long loadGuiPolicy() = 0;
    virtual long saveGuiPolicy() = 0;

    int getArgc();
    char** getArgv();
    void exit(long);
    void setMode(long);
    long getMode();
    void setContext(void*);
    void* getContext();
    void setContext2(void*);
    void* getContext2();

    WSCstring getExtGuiPolicyName();
    WSCbool getExtGuiPolicySelected();
    void setExtGuiPolicy(char* policy_name,WSCbool create_event);
    void setExtGuiPolicyProc(char* policy_name,char* procname,void(*)(void*));
    void* getExtGuiPolicyProc(char* procname);
    WSCindexData* getExtGuiPolicyList();

    WSMFclassDef(WSDappDev,WSDdev);
};
extern WSDLEX WSDappDev*  WSGIappDev();
#endif
