#ifndef WSCDBODBC_H
#define WSCDBODBC_H

#ifdef MSW
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sql.h>
#include <sqlext.h>

#include <WScom.h>
#include <WSCvariant.h>

class WSCodbcDatabase;
class WSCodbcRecord;
class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCdbOdbcRecord;
class WSCvodbc;

class WSCdbOdbcDatabase : public WSCdbDrvDatabase
{
public:
	WSCdbOdbcDatabase();
	virtual ~WSCdbOdbcDatabase();
	
	virtual long    open(char* host, char* uid, char* pwd, char* dbname = NULL, char* port = NULL);
	virtual long    close();
	virtual long    beginTran();
	virtual long    commitTran();
	virtual long    abortTran();
	virtual long    sqlExecute(const char* stmt);
	virtual WSCbool isOpen();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual void    getErrorMsg(char* szMsg,long size);
	virtual void    setEncode(long code);
	virtual long    getEncode();

public:
	WSCodbcDatabase* _db;
};

class WSCdbOdbcRecord : public WSCdbDrvRecord
{
public:
	WSCdbOdbcRecord(WSCdbOdbcDatabase* pDatabase);
	WSCdbOdbcRecord(WSCvodbc* obj);
	virtual ~WSCdbOdbcRecord();
	virtual long    open(const char* stmt);
	virtual long    open(const char* stmt, short eCousor, short eAccess = SQL_CONCUR_LOCK);
	virtual long    close();
	virtual WSCbool isEOF();
	virtual WSCbool isOpen();
	virtual long    getColValue(long index, WSCvariant* var);
	virtual long    getColValue(const char* name, WSCvariant* var);
	virtual long    getColStringValue(long index, char* var);
	virtual long    getColStringValue(const char* name, char* var);
	virtual long    setColValue(long index, WSCvariant var);
	virtual long    setColValue(const char* name, WSCvariant var);
	virtual long    edit();
	virtual long    update();
	virtual long    addnew();
	virtual long    deleterow();
	virtual long    moveNext();
	virtual long    movePrevious();
	virtual long    moveFirst();
	virtual long    moveLast();
	virtual long    getColName(long index, char* name);
	virtual long    getColIndex(const char* name);
	virtual long    getColType(long index);
	virtual long    getColType(const char* name);
	virtual long    getColLength(long index);
	virtual long    getColLength(const char* name);
	virtual long    getRowCount();
	virtual long    getColCount();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual WSCstring getErrorMessage();

public:
	WSCdbOdbcDatabase*	_pDB;
	WSCodbcRecord*		_rs;
};

#endif		// WSCDBODBC_H
