#ifndef WSCODBCDATABASE_H
#define WSCODBCDATABASE_H

#ifdef MSW
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sql.h>
#include <sqlext.h>

#include <WScom.h>
#include <WSCvariant.h>


#define CODBC_ACCESS_MODE_READ		0
#define CODBC_ACCESS_MODE_EDIT		1
#define CODBC_ACCESS_MODE_ADDNEW	2

struct _Col {
	SQLCHAR			colName[32];
	SQLSMALLINT		colNameLen;
	SQLSMALLINT		colType;
	SQLUINTEGER		colSize;
	SQLSMALLINT		colScale;
	SQLINTEGER		buffLen;
	SQLINTEGER		len;
	void*			buff;
};

class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCodbcRecord;
class WSCvodbc;

class WSCodbcDatabase
{
public:
	WSCodbcDatabase();
	virtual ~WSCodbcDatabase();
	
	virtual long    open(char* dsn, char* uid, char* pwd);
	virtual long    close();
	virtual long    beginTran();
	virtual long    commitTran();
	virtual long    abortTran();
	virtual long    sqlExecute(const char* stmt);
	virtual WSCbool isOpen();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual void    getErrorMsg(char* szMsg,long size);
	virtual void    setEncode(long code);
	virtual long    getEncode();

private:
	void getError(SQLHANDLE	hstmt);

public:
	WSCbool		_open;
	SQLHANDLE	_henv;
	SQLHANDLE	_hdbc;
	SQLCHAR		_szSqlState[6];
	SQLCHAR		_szErrorMsg[SQL_MAX_MESSAGE_LENGTH + 1];
	long		_encoding;
};

class WSCodbcRecord
{
public:
	WSCodbcRecord(WSCodbcDatabase* pDatabase);
	WSCodbcRecord(WSCvodbc* obj);
	virtual ~WSCodbcRecord();
	virtual long    open(const char* stmt);
	virtual long    open(const char* stmt, short eCousor, short eAccess = SQL_CONCUR_LOCK);
	virtual long    close();
	virtual WSCbool isEOF();
	virtual WSCbool isOpen();
	virtual long    getColValue(long index, WSCvariant* var);
	virtual long    getColValue(const char* name, WSCvariant* var);
	virtual long    getColStringValue(long index, char* var);
	virtual long    getColStringValue(const char* name, char* var);
	virtual long    setColValue(long index, WSCvariant var);
	virtual long    setColValue(const char* name, WSCvariant var);
	virtual long    edit();
	virtual long    update();
	virtual long    addnew();
	virtual long    deleterow();
	virtual long    moveNext();
	virtual long    movePrevious();
	virtual long    moveFirst();
	virtual long    moveLast();
	virtual long    getColName(long index, char* name);
	virtual long    getColIndex(const char* name);
	virtual long    getColType(long index);
	virtual long    getColType(const char* name);
	virtual long    getColLength(long index);
	virtual long    getColLength(const char* name);
	virtual long    getRowCount();
	virtual long    getColCount();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual WSCstring getErrorMessage();

private:
	void Cleanup(WSCodbcDatabase* pDatabase);
	long BindCols();
	void ReleaseCols();
	void getValue(int index, WSCvariant* var);
	void setValue(int index, WSCvariant* var);
	void getError(SQLHANDLE	hstmt);
	long getColTypeConv(long index);

public:
	WSCodbcDatabase*	_pDB;
	SQLHANDLE		_hstmt;
	WSCbool			_open;
	WSCbool			_eof;
	short			_Cols;
	_Col*			_fd;
	short			_access_mode;
	SQLCHAR			_szSqlState[6];
	SQLCHAR			_szErrorMsg[SQL_MAX_MESSAGE_LENGTH + 1];
	SQLINTEGER		_access;
	SQLINTEGER		_Cursor;
};

#endif		// WSCODBCDATABASE_H
