//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDWINMWINDEV_H
#define WSDWINMWINDEV_H

#include <WSDmwindowDev.h>
#include <windows.h>

class WSDwinmwinDev   :public WSDmwindowDev{
 protected:
  WSCuchar*  _bmi;
  HBITMAP    _hBitmap;
  HDC        _mdc;

 public:
  WSDwinmwinDev();
  virtual ~WSDwinmwinDev();

  virtual long createPixmap(WSCushort w,WSCushort h);
  virtual long destroyPixmap();
  long createContext();
  long destroyContext();

  virtual long beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,
                         WSCbool scaling);

  virtual long copyToWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  virtual long copyFromWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  virtual long copyToWindowWithMask(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short,WSDimage*);
  virtual long copyToWindowWithMask(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short,WSDmwindowDev*);
  virtual long getWindowResource();
  virtual long getDeviceResource();
  virtual long getSpecialResource();
  virtual long getContextResource();

  virtual long initBuffer();
  virtual long setBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar r,WSCuchar g,WSCuchar b);
  virtual long getBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar* r,WSCuchar* g,WSCuchar* b);
  virtual long putBufferToPixmap();
  virtual long saveFile(char*,long);

  WSMFclassDef(WSDwinmwinDev,WSDmwindowDev);
};
#endif
