//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <nx/WSDnxAppDev.h>
#include <nx/WSDnxPrivateTimer.h>
#include <nx/WSDnxTimer.h>
#include <nx/WSnxcom.h>

WSMFclassInit(WSDnxTimer,WSDtimer);

//250 ms 
#define _WS_INTERVAL_     250

WSDtimer* _nxTimer_create_handler(){
  return new WSDnxTimer();
}

class _nxTimer_init{
  public: _nxTimer_init(){
    WSDtimer::setCreateInstanceHandler(_nxTimer_create_handler);
  };
};

_nxTimer_init _nxTimer_init_run_constructor;

WSDnxTimer::WSDnxTimer(){
  _internal_timer = new WSDnxPrivateTimer();
  _internal_timer->setCont(True);
  _internal_timer->setRate(_WS_INTERVAL_);
  _internal_timer->setWorkProc(_timer_callback,this);
  _internal_timer->startTimer();
}
WSDnxTimer::~WSDnxTimer(){
  _internal_timer->stopTimer();
  delete _internal_timer;
}


void WSDnxTimer::_timer_callback(void* ptr){
    WSDnxTimer* obj = (WSDnxTimer*)ptr;
    obj->_clock++;
    long i;
    long num = obj->_cproc_list.getNum();

    for(i = 0; i < num; i++){
      timerProcRec* proc = (timerProcRec*)obj->_cproc_list.getData(i);
      if ( ( obj->_clock % proc->rate) == proc->fclock ){
        proc->proc(obj->_clock,proc->data);
      }
    }

    num = obj->_proc_list.getNum();
    //execute the trigger processes...
    for(i = 0; i < num; i++){
      triggerProcRec* proc = (triggerProcRec*)obj->_proc_list.getData(i);
      if (( obj->_clock % proc->rate) == proc->fclock ){
        //delete this executed process from the process list
        obj->_proc_list.del(proc); 
        num = obj->_proc_list.getNum();
        i--;

        proc->proc(obj->_clock,proc->data);
        proc->executed = False;
        delete proc;
      }
    }
    return;
}
