//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSPROPERTY_H
#define WSPROPERTY_H

#include <WScom.h>
#include <WSCstring.h>
class WSCbase;

class WSCproperty{

  public:
    char* property_name;
    char* owner_class_name;
    void (*_get_proc_addr)(void*,void*);
    void (*_set_proc_addr)(void*,void*);
    void (*_def_proc_addr)(void*);
    char** _data_labels;
    char** _data;
    WSCstring  _builder_title;

    unsigned _prop_type:4;
    unsigned _builder_visible:1;
    unsigned _not_use:1;
    unsigned _is_pixmap:1;
    unsigned _is_color:1;
    unsigned _default_value_change:1;
    unsigned _ignore:1;
	unsigned _init_execute:1;
	unsigned _file_select:1;

    WSCproperty(char* prop_name,char* owner_class_name);

    long execSetHandler(void*);

    void setType(char* type, void(*)(void*,void*), void(*)(void*,void*),
                              void(*)(void*));

    long setValue(WSCbase* ,void* ptr);
    void setDefaultValue(WSCbase* obj);
    void setBuilderSelectValues(char* labels[],char* data[]);
    void setGetDefaultValueHandler(void (*)(void*));

    long    getValue(WSCbase* ,void* ptr);
    long    getDefaultValue(void*);
    WSCbool getDefaultValueChange();
    WSCbool getNotUse();
    WSCbool getBuilderVisible();
    WSCbool getFileSelect();
    void    getBuilderSelectValues(char*** labels,char*** data);
    char*   getBuilderTitle();
    char    getPropObjType();
    char*   getPropObjName();
    char*   getPropObjTypeName();
    void*   getGetDefaultValueHandler();

    WSCbool isPixmapPropObj();
    WSCbool isColorPropObj();
    WSCbool isDefaultValue(WSCbase* obj);
};
#endif
